/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CapabilityStatement2", profile="http://hl7.org/fhir/StructureDefinition/CapabilityStatement2")
@ChildOrder(names={"url", "version", "name", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "copyright", "kind", "instantiates", "imports", "software", "implementation", "fhirVersion", "format", "patchFormat", "implementationGuide", "rest"})
public class CapabilityStatement2
extends MetadataResource {
    @Child(name="purpose", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this capability statement2 is defined", formalDefinition="Explanation of why this capability statement2 is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the capability statement2 and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement2.")
    protected MarkdownType copyright;
    @Child(name="kind", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="instance | capability | requirements", formalDefinition="The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/capability-statement-kind")
    protected Enumeration<CapabilityStatement2Kind> kind;
    @Child(name="instantiates", type={CanonicalType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical URL of another capability statement this implements", formalDefinition="Reference to a canonical URL of another CapabilityStatement2 that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.")
    protected List<CanonicalType> instantiates;
    @Child(name="imports", type={CanonicalType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical URL of another capability statement this adds to", formalDefinition="Reference to a canonical URL of another CapabilityStatement2 that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.")
    protected List<CanonicalType> imports;
    @Child(name="software", type={}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Software that is covered by this capability statement", formalDefinition="Software that is covered by this capability statement.  It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.")
    protected CapabilityStatement2SoftwareComponent software;
    @Child(name="implementation", type={}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this describes a specific instance", formalDefinition="Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.")
    protected CapabilityStatement2ImplementationComponent implementation;
    @Child(name="fhirVersion", type={CodeType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version the system supports", formalDefinition="The version of the FHIR specification that this CapabilityStatement2 describes (which SHALL be the same as the FHIR version of the CapabilityStatement2 itself). There is no default value.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/FHIR-version")
    protected Enumeration<Enumerations.FHIRVersion> fhirVersion;
    @Child(name="format", type={CodeType.class}, order=8, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="formats supported (xml | json | ttl | mime type)", formalDefinition="A list of the formats supported by this implementation using their content types.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected List<CodeType> format;
    @Child(name="patchFormat", type={CodeType.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Patch formats supported", formalDefinition="A list of the patch formats supported by this implementation using their content types.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected List<CodeType> patchFormat;
    @Child(name="implementationGuide", type={CanonicalType.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Implementation guides supported", formalDefinition="A list of implementation guides that the server does (or should) support in their entirety.")
    protected List<CanonicalType> implementationGuide;
    @Child(name="rest", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="If the endpoint is a RESTful one", formalDefinition="A definition of the restful capabilities of the solution, if any.")
    protected List<CapabilityStatement2RestComponent> rest;
    private static final long serialVersionUID = 1310130385L;
    @SearchParamDefinition(name="date", path="CapabilityStatement2.date", description="The capability statement2 publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="resource-profile", path="CapabilityStatement2.rest.resource.profile", description="A profile id invoked in a capability statement", type="reference", target={StructureDefinition.class})
    public static final String SP_RESOURCE_PROFILE = "resource-profile";
    public static final ReferenceClientParam RESOURCE_PROFILE = new ReferenceClientParam("resource-profile");
    public static final Include INCLUDE_RESOURCE_PROFILE = new Include("CapabilityStatement2:resource-profile").toLocked();
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement2.useContext", description="A use context type and value assigned to the capability statement2", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="software", path="CapabilityStatement2.software.name", description="Part of the name of a software application", type="string")
    public static final String SP_SOFTWARE = "software";
    public static final StringClientParam SOFTWARE = new StringClientParam("software");
    @SearchParamDefinition(name="resource", path="CapabilityStatement2.rest.resource.type", description="Name of a resource mentioned in a capability statement", type="token")
    public static final String SP_RESOURCE = "resource";
    public static final TokenClientParam RESOURCE = new TokenClientParam("resource");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement2.jurisdiction", description="Intended jurisdiction for the capability statement2", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="format", path="CapabilityStatement2.format", description="formats supported (xml | json | ttl | mime type)", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="description", path="CapabilityStatement2.description", description="The description of the capability statement2", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement2.useContext.code", description="A type of use context assigned to the capability statement2", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="CapabilityStatement2.title", description="The human-friendly name of the capability statement2", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="fhirversion", path="CapabilityStatement2.version", description="The version of FHIR", type="token")
    public static final String SP_FHIRVERSION = "fhirversion";
    public static final TokenClientParam FHIRVERSION = new TokenClientParam("fhirversion");
    @SearchParamDefinition(name="version", path="CapabilityStatement2.version", description="The business version of the capability statement2", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="CapabilityStatement2.url", description="The uri that identifies the capability statement2", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="supported-profile", path="CapabilityStatement2.rest.resource.supportedProfile", description="Profiles for use cases supported", type="reference", target={StructureDefinition.class})
    public static final String SP_SUPPORTED_PROFILE = "supported-profile";
    public static final ReferenceClientParam SUPPORTED_PROFILE = new ReferenceClientParam("supported-profile");
    public static final Include INCLUDE_SUPPORTED_PROFILE = new Include("CapabilityStatement2:supported-profile").toLocked();
    @SearchParamDefinition(name="mode", path="CapabilityStatement2.rest.mode", description="Mode - restful (server/client) or messaging (sender/receiver)", type="token")
    public static final String SP_MODE = "mode";
    public static final TokenClientParam MODE = new TokenClientParam("mode");
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement2.useContext.value as Quantity) | (CapabilityStatement2.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the capability statement2", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="name", path="CapabilityStatement2.name", description="Computationally friendly name of the capability statement2", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(CapabilityStatement2.useContext.value as CodeableConcept)", description="A use context assigned to the capability statement2", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement2.publisher", description="Name of the publisher of the capability statement2", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement2.useContext", description="A use context type and quantity- or range-based value assigned to the capability statement2", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="guide", path="CapabilityStatement2.implementationGuide", description="Implementation guides supported", type="reference", target={ImplementationGuide.class})
    public static final String SP_GUIDE = "guide";
    public static final ReferenceClientParam GUIDE = new ReferenceClientParam("guide");
    public static final Include INCLUDE_GUIDE = new Include("CapabilityStatement2:guide").toLocked();
    @SearchParamDefinition(name="status", path="CapabilityStatement2.status", description="The current status of the capability statement2", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CapabilityStatement2() {
    }

    public CapabilityStatement2(Enumeration<Enumerations.PublicationStatus> status, DateTimeType date, Enumeration<CapabilityStatement2Kind> kind, Enumeration<Enumerations.FHIRVersion> fhirVersion) {
        this.status = status;
        this.date = date;
        this.kind = kind;
        this.fhirVersion = fhirVersion;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public CapabilityStatement2 setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public CapabilityStatement2 setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public CapabilityStatement2 setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public CapabilityStatement2 setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public CapabilityStatement2 setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public CapabilityStatement2 setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public CapabilityStatement2 setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public CapabilityStatement2 setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public CapabilityStatement2 setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public CapabilityStatement2 setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public CapabilityStatement2 setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public CapabilityStatement2 setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public CapabilityStatement2 setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public CapabilityStatement2 setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public CapabilityStatement2 setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public CapabilityStatement2 setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public CapabilityStatement2 setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public CapabilityStatement2 addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public CapabilityStatement2 setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public CapabilityStatement2 setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public CapabilityStatement2 setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public CapabilityStatement2 addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public CapabilityStatement2 setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public CapabilityStatement2 addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public CapabilityStatement2 setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public CapabilityStatement2 setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public CapabilityStatement2 setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public CapabilityStatement2 setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Enumeration<CapabilityStatement2Kind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<CapabilityStatement2Kind>(new CapabilityStatement2KindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public CapabilityStatement2 setKindElement(Enumeration<CapabilityStatement2Kind> value) {
        this.kind = value;
        return this;
    }

    public CapabilityStatement2Kind getKind() {
        return this.kind == null ? null : (CapabilityStatement2Kind)((Object)this.kind.getValue());
    }

    public CapabilityStatement2 setKind(CapabilityStatement2Kind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<CapabilityStatement2Kind>(new CapabilityStatement2KindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public List<CanonicalType> getInstantiates() {
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<CanonicalType>();
        }
        return this.instantiates;
    }

    public CapabilityStatement2 setInstantiates(List<CanonicalType> theInstantiates) {
        this.instantiates = theInstantiates;
        return this;
    }

    public boolean hasInstantiates() {
        if (this.instantiates == null) {
            return false;
        }
        for (CanonicalType item : this.instantiates) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<CanonicalType>();
        }
        this.instantiates.add(t);
        return t;
    }

    public CapabilityStatement2 addInstantiates(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<CanonicalType>();
        }
        this.instantiates.add(t);
        return this;
    }

    public boolean hasInstantiates(String value) {
        if (this.instantiates == null) {
            return false;
        }
        for (CanonicalType v : this.instantiates) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<CanonicalType>();
        }
        return this.imports;
    }

    public CapabilityStatement2 setImports(List<CanonicalType> theImports) {
        this.imports = theImports;
        return this;
    }

    public boolean hasImports() {
        if (this.imports == null) {
            return false;
        }
        for (CanonicalType item : this.imports) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addImportsElement() {
        CanonicalType t = new CanonicalType();
        if (this.imports == null) {
            this.imports = new ArrayList<CanonicalType>();
        }
        this.imports.add(t);
        return t;
    }

    public CapabilityStatement2 addImports(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.imports == null) {
            this.imports = new ArrayList<CanonicalType>();
        }
        this.imports.add(t);
        return this;
    }

    public boolean hasImports(String value) {
        if (this.imports == null) {
            return false;
        }
        for (CanonicalType v : this.imports) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public CapabilityStatement2SoftwareComponent getSoftware() {
        if (this.software == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.software");
            }
            if (Configuration.doAutoCreate()) {
                this.software = new CapabilityStatement2SoftwareComponent();
            }
        }
        return this.software;
    }

    public boolean hasSoftware() {
        return this.software != null && !this.software.isEmpty();
    }

    public CapabilityStatement2 setSoftware(CapabilityStatement2SoftwareComponent value) {
        this.software = value;
        return this;
    }

    public CapabilityStatement2ImplementationComponent getImplementation() {
        if (this.implementation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.implementation");
            }
            if (Configuration.doAutoCreate()) {
                this.implementation = new CapabilityStatement2ImplementationComponent();
            }
        }
        return this.implementation;
    }

    public boolean hasImplementation() {
        return this.implementation != null && !this.implementation.isEmpty();
    }

    public CapabilityStatement2 setImplementation(CapabilityStatement2ImplementationComponent value) {
        this.implementation = value;
        return this;
    }

    public Enumeration<Enumerations.FHIRVersion> getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement2.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public CapabilityStatement2 setFhirVersionElement(Enumeration<Enumerations.FHIRVersion> value) {
        this.fhirVersion = value;
        return this;
    }

    public Enumerations.FHIRVersion getFhirVersion() {
        return this.fhirVersion == null ? null : (Enumerations.FHIRVersion)((Object)this.fhirVersion.getValue());
    }

    public CapabilityStatement2 setFhirVersion(Enumerations.FHIRVersion value) {
        if (this.fhirVersion == null) {
            this.fhirVersion = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
        }
        this.fhirVersion.setValue((Object)value);
        return this;
    }

    public List<CodeType> getFormat() {
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        return this.format;
    }

    public CapabilityStatement2 setFormat(List<CodeType> theFormat) {
        this.format = theFormat;
        return this;
    }

    public boolean hasFormat() {
        if (this.format == null) {
            return false;
        }
        for (CodeType item : this.format) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addFormatElement() {
        CodeType t = new CodeType();
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        this.format.add(t);
        return t;
    }

    public CapabilityStatement2 addFormat(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        this.format.add(t);
        return this;
    }

    public boolean hasFormat(String value) {
        if (this.format == null) {
            return false;
        }
        for (CodeType v : this.format) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeType> getPatchFormat() {
        if (this.patchFormat == null) {
            this.patchFormat = new ArrayList<CodeType>();
        }
        return this.patchFormat;
    }

    public CapabilityStatement2 setPatchFormat(List<CodeType> thePatchFormat) {
        this.patchFormat = thePatchFormat;
        return this;
    }

    public boolean hasPatchFormat() {
        if (this.patchFormat == null) {
            return false;
        }
        for (CodeType item : this.patchFormat) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addPatchFormatElement() {
        CodeType t = new CodeType();
        if (this.patchFormat == null) {
            this.patchFormat = new ArrayList<CodeType>();
        }
        this.patchFormat.add(t);
        return t;
    }

    public CapabilityStatement2 addPatchFormat(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.patchFormat == null) {
            this.patchFormat = new ArrayList<CodeType>();
        }
        this.patchFormat.add(t);
        return this;
    }

    public boolean hasPatchFormat(String value) {
        if (this.patchFormat == null) {
            return false;
        }
        for (CodeType v : this.patchFormat) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getImplementationGuide() {
        if (this.implementationGuide == null) {
            this.implementationGuide = new ArrayList<CanonicalType>();
        }
        return this.implementationGuide;
    }

    public CapabilityStatement2 setImplementationGuide(List<CanonicalType> theImplementationGuide) {
        this.implementationGuide = theImplementationGuide;
        return this;
    }

    public boolean hasImplementationGuide() {
        if (this.implementationGuide == null) {
            return false;
        }
        for (CanonicalType item : this.implementationGuide) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addImplementationGuideElement() {
        CanonicalType t = new CanonicalType();
        if (this.implementationGuide == null) {
            this.implementationGuide = new ArrayList<CanonicalType>();
        }
        this.implementationGuide.add(t);
        return t;
    }

    public CapabilityStatement2 addImplementationGuide(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.implementationGuide == null) {
            this.implementationGuide = new ArrayList<CanonicalType>();
        }
        this.implementationGuide.add(t);
        return this;
    }

    public boolean hasImplementationGuide(String value) {
        if (this.implementationGuide == null) {
            return false;
        }
        for (CanonicalType v : this.implementationGuide) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CapabilityStatement2RestComponent> getRest() {
        if (this.rest == null) {
            this.rest = new ArrayList<CapabilityStatement2RestComponent>();
        }
        return this.rest;
    }

    public CapabilityStatement2 setRest(List<CapabilityStatement2RestComponent> theRest) {
        this.rest = theRest;
        return this;
    }

    public boolean hasRest() {
        if (this.rest == null) {
            return false;
        }
        for (CapabilityStatement2RestComponent item : this.rest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CapabilityStatement2RestComponent addRest() {
        CapabilityStatement2RestComponent t = new CapabilityStatement2RestComponent();
        if (this.rest == null) {
            this.rest = new ArrayList<CapabilityStatement2RestComponent>();
        }
        this.rest.add(t);
        return t;
    }

    public CapabilityStatement2 addRest(CapabilityStatement2RestComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rest == null) {
            this.rest = new ArrayList<CapabilityStatement2RestComponent>();
        }
        this.rest.add(t);
        return this;
    }

    public CapabilityStatement2RestComponent getRestFirstRep() {
        if (this.getRest().isEmpty()) {
            this.addRest();
        }
        return this.getRest().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this capability statement2 when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this capability statement2 is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the capability statement2 is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the capability statement2 when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the capability statement2 author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the capability statement2. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the capability statement2.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this capability statement2. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this capability statement2 is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the capability statement2 was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the capability statement2 changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the capability statement2.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the capability statement2 from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate capability statement2 instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the capability statement2 is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this capability statement2 is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the capability statement2 and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement2.", 0, 1, this.copyright));
        children.add(new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).", 0, 1, this.kind));
        children.add(new Property("instantiates", "canonical(CapabilityStatement2)", "Reference to a canonical URL of another CapabilityStatement2 that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.", 0, Integer.MAX_VALUE, this.instantiates));
        children.add(new Property("imports", "canonical(CapabilityStatement2)", "Reference to a canonical URL of another CapabilityStatement2 that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.", 0, Integer.MAX_VALUE, this.imports));
        children.add(new Property(SP_SOFTWARE, "", "Software that is covered by this capability statement.  It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.", 0, 1, this.software));
        children.add(new Property("implementation", "", "Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, 1, this.implementation));
        children.add(new Property("fhirVersion", "code", "The version of the FHIR specification that this CapabilityStatement2 describes (which SHALL be the same as the FHIR version of the CapabilityStatement2 itself). There is no default value.", 0, 1, this.fhirVersion));
        children.add(new Property(SP_FORMAT, "code", "A list of the formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.format));
        children.add(new Property("patchFormat", "code", "A list of the patch formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.patchFormat));
        children.add(new Property("implementationGuide", "canonical(ImplementationGuide)", "A list of implementation guides that the server does (or should) support in their entirety.", 0, Integer.MAX_VALUE, this.implementationGuide));
        children.add(new Property("rest", "", "A definition of the restful capabilities of the solution, if any.", 0, Integer.MAX_VALUE, this.rest));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this capability statement2 when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this capability statement2 is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the capability statement2 is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the capability statement2 when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the capability statement2 author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the capability statement2. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the capability statement2.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this capability statement2. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this capability statement2 is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the capability statement2 was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the capability statement2 changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the capability statement2.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the capability statement2 from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate capability statement2 instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the capability statement2 is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this capability statement2 is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the capability statement2 and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement2.", 0, 1, this.copyright);
            }
            case 3292052: {
                return new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).", 0, 1, this.kind);
            }
            case -246883639: {
                return new Property("instantiates", "canonical(CapabilityStatement2)", "Reference to a canonical URL of another CapabilityStatement2 that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.", 0, Integer.MAX_VALUE, this.instantiates);
            }
            case 1926037870: {
                return new Property("imports", "canonical(CapabilityStatement2)", "Reference to a canonical URL of another CapabilityStatement2 that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.", 0, Integer.MAX_VALUE, this.imports);
            }
            case 1319330215: {
                return new Property(SP_SOFTWARE, "", "Software that is covered by this capability statement.  It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.", 0, 1, this.software);
            }
            case 1683336114: {
                return new Property("implementation", "", "Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, 1, this.implementation);
            }
            case 461006061: {
                return new Property("fhirVersion", "code", "The version of the FHIR specification that this CapabilityStatement2 describes (which SHALL be the same as the FHIR version of the CapabilityStatement2 itself). There is no default value.", 0, 1, this.fhirVersion);
            }
            case -1268779017: {
                return new Property(SP_FORMAT, "code", "A list of the formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.format);
            }
            case 172338783: {
                return new Property("patchFormat", "code", "A list of the patch formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.patchFormat);
            }
            case 156966506: {
                return new Property("implementationGuide", "canonical(ImplementationGuide)", "A list of implementation guides that the server does (or should) support in their entirety.", 0, Integer.MAX_VALUE, this.implementationGuide);
            }
            case 3496916: {
                return new Property("rest", "", "A definition of the restful capabilities of the solution, if any.", 0, Integer.MAX_VALUE, this.rest);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.kind;
                }
                return baseArray;
            }
            case -246883639: {
                return this.instantiates == null ? new Base[]{} : this.instantiates.toArray(new Base[this.instantiates.size()]);
            }
            case 1926037870: {
                return this.imports == null ? new Base[]{} : this.imports.toArray(new Base[this.imports.size()]);
            }
            case 1319330215: {
                Base[] baseArray;
                if (this.software == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.software;
                }
                return baseArray;
            }
            case 1683336114: {
                Base[] baseArray;
                if (this.implementation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.implementation;
                }
                return baseArray;
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case -1268779017: {
                return this.format == null ? new Base[]{} : this.format.toArray(new Base[this.format.size()]);
            }
            case 172338783: {
                return this.patchFormat == null ? new Base[]{} : this.patchFormat.toArray(new Base[this.patchFormat.size()]);
            }
            case 156966506: {
                return this.implementationGuide == null ? new Base[]{} : this.implementationGuide.toArray(new Base[this.implementationGuide.size()]);
            }
            case 3496916: {
                return this.rest == null ? new Base[]{} : this.rest.toArray(new Base[this.rest.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 3292052: {
                value = new CapabilityStatement2KindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
                return value;
            }
            case -246883639: {
                this.getInstantiates().add(this.castToCanonical(value));
                return value;
            }
            case 1926037870: {
                this.getImports().add(this.castToCanonical(value));
                return value;
            }
            case 1319330215: {
                this.software = (CapabilityStatement2SoftwareComponent)((Object)value);
                return value;
            }
            case 1683336114: {
                this.implementation = (CapabilityStatement2ImplementationComponent)((Object)value);
                return value;
            }
            case 461006061: {
                value = new Enumerations.FHIRVersionEnumFactory().fromType(this.castToCode(value));
                this.fhirVersion = value;
                return value;
            }
            case -1268779017: {
                this.getFormat().add(this.castToCode(value));
                return value;
            }
            case 172338783: {
                this.getPatchFormat().add(this.castToCode(value));
                return value;
            }
            case 156966506: {
                this.getImplementationGuide().add(this.castToCanonical(value));
                return value;
            }
            case 3496916: {
                this.getRest().add((CapabilityStatement2RestComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("kind")) {
            value = new CapabilityStatement2KindEnumFactory().fromType(this.castToCode(value));
            this.kind = value;
        } else if (name.equals("instantiates")) {
            this.getInstantiates().add(this.castToCanonical(value));
        } else if (name.equals("imports")) {
            this.getImports().add(this.castToCanonical(value));
        } else if (name.equals(SP_SOFTWARE)) {
            this.software = (CapabilityStatement2SoftwareComponent)((Object)value);
        } else if (name.equals("implementation")) {
            this.implementation = (CapabilityStatement2ImplementationComponent)((Object)value);
        } else if (name.equals("fhirVersion")) {
            value = new Enumerations.FHIRVersionEnumFactory().fromType(this.castToCode(value));
            this.fhirVersion = value;
        } else if (name.equals(SP_FORMAT)) {
            this.getFormat().add(this.castToCode(value));
        } else if (name.equals("patchFormat")) {
            this.getPatchFormat().add(this.castToCode(value));
        } else if (name.equals("implementationGuide")) {
            this.getImplementationGuide().add(this.castToCanonical(value));
        } else if (name.equals("rest")) {
            this.getRest().add((CapabilityStatement2RestComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case -246883639: {
                return this.addInstantiatesElement();
            }
            case 1926037870: {
                return this.addImportsElement();
            }
            case 1319330215: {
                return this.getSoftware();
            }
            case 1683336114: {
                return this.getImplementation();
            }
            case 461006061: {
                return this.getFhirVersionElement();
            }
            case -1268779017: {
                return this.addFormatElement();
            }
            case 172338783: {
                return this.addPatchFormatElement();
            }
            case 156966506: {
                return this.addImplementationGuideElement();
            }
            case 3496916: {
                return this.addRest();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case -246883639: {
                return new String[]{"canonical"};
            }
            case 1926037870: {
                return new String[]{"canonical"};
            }
            case 1319330215: {
                return new String[0];
            }
            case 1683336114: {
                return new String[0];
            }
            case 461006061: {
                return new String[]{"code"};
            }
            case -1268779017: {
                return new String[]{"code"};
            }
            case 172338783: {
                return new String[]{"code"};
            }
            case 156966506: {
                return new String[]{"canonical"};
            }
            case 3496916: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.copyright");
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.kind");
        }
        if (name.equals("instantiates")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.instantiates");
        }
        if (name.equals("imports")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.imports");
        }
        if (name.equals(SP_SOFTWARE)) {
            this.software = new CapabilityStatement2SoftwareComponent();
            return this.software;
        }
        if (name.equals("implementation")) {
            this.implementation = new CapabilityStatement2ImplementationComponent();
            return this.implementation;
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.fhirVersion");
        }
        if (name.equals(SP_FORMAT)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.format");
        }
        if (name.equals("patchFormat")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.patchFormat");
        }
        if (name.equals("implementationGuide")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.implementationGuide");
        }
        if (name.equals("rest")) {
            return this.addRest();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CapabilityStatement2";
    }

    @Override
    public CapabilityStatement2 copy() {
        CapabilityStatement2 dst = new CapabilityStatement2();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CapabilityStatement2 dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        Enumeration<CapabilityStatement2Kind> enumeration = dst.kind = this.kind == null ? null : this.kind.copy();
        if (this.instantiates != null) {
            dst.instantiates = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiates) {
                dst.instantiates.add(canonicalType.copy());
            }
        }
        if (this.imports != null) {
            dst.imports = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.imports) {
                dst.imports.add(canonicalType.copy());
            }
        }
        dst.software = this.software == null ? null : this.software.copy();
        dst.implementation = this.implementation == null ? null : this.implementation.copy();
        Enumeration<Enumerations.FHIRVersion> enumeration2 = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.format != null) {
            dst.format = new ArrayList<CodeType>();
            for (CodeType codeType : this.format) {
                dst.format.add(codeType.copy());
            }
        }
        if (this.patchFormat != null) {
            dst.patchFormat = new ArrayList<CodeType>();
            for (CodeType codeType : this.patchFormat) {
                dst.patchFormat.add(codeType.copy());
            }
        }
        if (this.implementationGuide != null) {
            dst.implementationGuide = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.implementationGuide) {
                dst.implementationGuide.add(canonicalType.copy());
            }
        }
        if (this.rest != null) {
            dst.rest = new ArrayList<CapabilityStatement2RestComponent>();
            for (CapabilityStatement2RestComponent capabilityStatement2RestComponent : this.rest) {
                dst.rest.add(capabilityStatement2RestComponent.copy());
            }
        }
    }

    protected CapabilityStatement2 typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CapabilityStatement2)) {
            return false;
        }
        CapabilityStatement2 o = (CapabilityStatement2)other_;
        return CapabilityStatement2.compareDeep(this.purpose, o.purpose, true) && CapabilityStatement2.compareDeep(this.copyright, o.copyright, true) && CapabilityStatement2.compareDeep(this.kind, o.kind, true) && CapabilityStatement2.compareDeep(this.instantiates, o.instantiates, true) && CapabilityStatement2.compareDeep(this.imports, o.imports, true) && CapabilityStatement2.compareDeep(this.software, o.software, true) && CapabilityStatement2.compareDeep(this.implementation, o.implementation, true) && CapabilityStatement2.compareDeep(this.fhirVersion, o.fhirVersion, true) && CapabilityStatement2.compareDeep(this.format, o.format, true) && CapabilityStatement2.compareDeep(this.patchFormat, o.patchFormat, true) && CapabilityStatement2.compareDeep(this.implementationGuide, o.implementationGuide, true) && CapabilityStatement2.compareDeep(this.rest, o.rest, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CapabilityStatement2)) {
            return false;
        }
        CapabilityStatement2 o = (CapabilityStatement2)other_;
        return CapabilityStatement2.compareValues(this.purpose, o.purpose, true) && CapabilityStatement2.compareValues(this.copyright, o.copyright, true) && CapabilityStatement2.compareValues(this.kind, o.kind, true) && CapabilityStatement2.compareValues(this.fhirVersion, o.fhirVersion, true) && CapabilityStatement2.compareValues(this.format, o.format, true) && CapabilityStatement2.compareValues(this.patchFormat, o.patchFormat, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.purpose, this.copyright, this.kind, this.instantiates, this.imports, this.software, this.implementation, this.fhirVersion, this.format, this.patchFormat, this.implementationGuide, this.rest});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CapabilityStatement2;
    }

    @Block
    public static class SystemInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="transaction | batch | search-system | history-system", formalDefinition="A coded identifier of the operation, supported by the system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/system-restful-interaction")
        protected Enumeration<SystemRestfulInteraction> code;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -1495143879L;

        public SystemInteractionComponent() {
        }

        public SystemInteractionComponent(Enumeration<SystemRestfulInteraction> code) {
            this.code = code;
        }

        public Enumeration<SystemRestfulInteraction> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SystemInteractionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<SystemRestfulInteraction>(new SystemRestfulInteractionEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SystemInteractionComponent setCodeElement(Enumeration<SystemRestfulInteraction> value) {
            this.code = value;
            return this;
        }

        public SystemRestfulInteraction getCode() {
            return this.code == null ? null : (SystemRestfulInteraction)((Object)this.code.getValue());
        }

        public SystemInteractionComponent setCode(SystemRestfulInteraction value) {
            if (this.code == null) {
                this.code = new Enumeration<SystemRestfulInteraction>(new SystemRestfulInteractionEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SystemInteractionComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public SystemInteractionComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public SystemInteractionComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "A coded identifier of the operation, supported by the system.", 0, 1, this.code));
            children.add(new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "A coded identifier of the operation, supported by the system.", 0, 1, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new SystemRestfulInteractionEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new SystemRestfulInteractionEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.code");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public SystemInteractionComponent copy() {
            SystemInteractionComponent dst = new SystemInteractionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SystemInteractionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SystemInteractionComponent)) {
                return false;
            }
            SystemInteractionComponent o = (SystemInteractionComponent)other_;
            return SystemInteractionComponent.compareDeep(this.code, o.code, true) && SystemInteractionComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SystemInteractionComponent)) {
                return false;
            }
            SystemInteractionComponent o = (SystemInteractionComponent)other_;
            return SystemInteractionComponent.compareValues(this.code, o.code, true) && SystemInteractionComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.rest.interaction";
        }
    }

    @Block
    public static class CapabilityStatement2RestResourceOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name by which the operation/query is invoked", formalDefinition="The name of the operation or query. For an operation, this is the name  prefixed with $ and used in the URL. For a query, this is the name used in the _query parameter when the query is called.")
        protected StringType name;
        @Child(name="definition", type={CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The defined operation/query", formalDefinition="Where the formal definition can be found. If a server references the base definition of an Operation (i.e. from the specification itself such as ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it supports the full capabilities of the operation - e.g. both GET and POST invocation.  If it only supports a subset, it must define its own custom [[[OperationDefinition]]] with a 'base' of the original OperationDefinition.  The custom definition would describe the specific subset of functionality supported.")
        protected CanonicalType definition;
        @Child(name="documentation", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific details about operation behavior", formalDefinition="Documentation that describes anything special about the operation behavior, possibly detailing different behavior for system, type and instance-level invocation of the operation.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -388608084L;

        public CapabilityStatement2RestResourceOperationComponent() {
        }

        public CapabilityStatement2RestResourceOperationComponent(StringType name, CanonicalType definition) {
            this.name = name;
            this.definition = definition;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceOperationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CapabilityStatement2RestResourceOperationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CapabilityStatement2RestResourceOperationComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceOperationComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public CapabilityStatement2RestResourceOperationComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public CapabilityStatement2RestResourceOperationComponent setDefinition(String value) {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            this.definition.setValue(value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceOperationComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatement2RestResourceOperationComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatement2RestResourceOperationComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement2.SP_NAME, "string", "The name of the operation or query. For an operation, this is the name  prefixed with $ and used in the URL. For a query, this is the name used in the _query parameter when the query is called.", 0, 1, this.name));
            children.add(new Property("definition", "canonical(OperationDefinition)", "Where the formal definition can be found. If a server references the base definition of an Operation (i.e. from the specification itself such as ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it supports the full capabilities of the operation - e.g. both GET and POST invocation.  If it only supports a subset, it must define its own custom [[[OperationDefinition]]] with a 'base' of the original OperationDefinition.  The custom definition would describe the specific subset of functionality supported.", 0, 1, this.definition));
            children.add(new Property("documentation", "markdown", "Documentation that describes anything special about the operation behavior, possibly detailing different behavior for system, type and instance-level invocation of the operation.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(CapabilityStatement2.SP_NAME, "string", "The name of the operation or query. For an operation, this is the name  prefixed with $ and used in the URL. For a query, this is the name used in the _query parameter when the query is called.", 0, 1, this.name);
                }
                case -1014418093: {
                    return new Property("definition", "canonical(OperationDefinition)", "Where the formal definition can be found. If a server references the base definition of an Operation (i.e. from the specification itself such as ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it supports the full capabilities of the operation - e.g. both GET and POST invocation.  If it only supports a subset, it must define its own custom [[[OperationDefinition]]] with a 'base' of the original OperationDefinition.  The custom definition would describe the specific subset of functionality supported.", 0, 1, this.definition);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Documentation that describes anything special about the operation behavior, possibly detailing different behavior for system, type and instance-level invocation of the operation.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = this.castToCanonical(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToCanonical(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"canonical"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.name");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.definition");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatement2RestResourceOperationComponent copy() {
            CapabilityStatement2RestResourceOperationComponent dst = new CapabilityStatement2RestResourceOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatement2RestResourceOperationComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestResourceOperationComponent)) {
                return false;
            }
            CapabilityStatement2RestResourceOperationComponent o = (CapabilityStatement2RestResourceOperationComponent)other_;
            return CapabilityStatement2RestResourceOperationComponent.compareDeep(this.name, o.name, true) && CapabilityStatement2RestResourceOperationComponent.compareDeep(this.definition, o.definition, true) && CapabilityStatement2RestResourceOperationComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestResourceOperationComponent)) {
                return false;
            }
            CapabilityStatement2RestResourceOperationComponent o = (CapabilityStatement2RestResourceOperationComponent)other_;
            return CapabilityStatement2RestResourceOperationComponent.compareValues(this.name, o.name, true) && CapabilityStatement2RestResourceOperationComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.definition, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.rest.resource.operation";
        }
    }

    @Block
    public static class CapabilityStatement2RestResourceSearchParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of search parameter", formalDefinition="The name of the search parameter used in the interface.")
        protected StringType name;
        @Child(name="definition", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source of definition for parameter", formalDefinition="An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [[[SearchParameter.url]]]). This element SHALL be populated if the search parameter refers to a SearchParameter defined by the FHIR core specification or externally defined IGs.")
        protected CanonicalType definition;
        @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri | special", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
        protected Enumeration<Enumerations.SearchParamType> type;
        @Child(name="documentation", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server-specific usage", formalDefinition="This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -171123928L;

        public CapabilityStatement2RestResourceSearchParamComponent() {
        }

        public CapabilityStatement2RestResourceSearchParamComponent(StringType name, Enumeration<Enumerations.SearchParamType> type) {
            this.name = name;
            this.type = type;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceSearchParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceSearchParamComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new CanonicalType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.SearchParamType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceSearchParamComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setTypeElement(Enumeration<Enumerations.SearchParamType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.SearchParamType getType() {
            return this.type == null ? null : (Enumerations.SearchParamType)((Object)this.type.getValue());
        }

        public CapabilityStatement2RestResourceSearchParamComponent setType(Enumerations.SearchParamType value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceSearchParamComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatement2RestResourceSearchParamComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement2.SP_NAME, "string", "The name of the search parameter used in the interface.", 0, 1, this.name));
            children.add(new Property("definition", "canonical(SearchParameter)", "An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [[[SearchParameter.url]]]). This element SHALL be populated if the search parameter refers to a SearchParameter defined by the FHIR core specification or externally defined IGs.", 0, 1, this.definition));
            children.add(new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, 1, this.type));
            children.add(new Property("documentation", "markdown", "This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(CapabilityStatement2.SP_NAME, "string", "The name of the search parameter used in the interface.", 0, 1, this.name);
                }
                case -1014418093: {
                    return new Property("definition", "canonical(SearchParameter)", "An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [[[SearchParameter.url]]]). This element SHALL be populated if the search parameter refers to a SearchParameter defined by the FHIR core specification or externally defined IGs.", 0, 1, this.definition);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, 1, this.type);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = this.castToCanonical(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.SearchParamTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToCanonical(value);
            } else if (name.equals("type")) {
                value = new Enumerations.SearchParamTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"canonical"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.name");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.definition");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.type");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatement2RestResourceSearchParamComponent copy() {
            CapabilityStatement2RestResourceSearchParamComponent dst = new CapabilityStatement2RestResourceSearchParamComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatement2RestResourceSearchParamComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestResourceSearchParamComponent)) {
                return false;
            }
            CapabilityStatement2RestResourceSearchParamComponent o = (CapabilityStatement2RestResourceSearchParamComponent)other_;
            return CapabilityStatement2RestResourceSearchParamComponent.compareDeep(this.name, o.name, true) && CapabilityStatement2RestResourceSearchParamComponent.compareDeep(this.definition, o.definition, true) && CapabilityStatement2RestResourceSearchParamComponent.compareDeep(this.type, o.type, true) && CapabilityStatement2RestResourceSearchParamComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestResourceSearchParamComponent)) {
                return false;
            }
            CapabilityStatement2RestResourceSearchParamComponent o = (CapabilityStatement2RestResourceSearchParamComponent)other_;
            return CapabilityStatement2RestResourceSearchParamComponent.compareValues(this.name, o.name, true) && CapabilityStatement2RestResourceSearchParamComponent.compareValues(this.type, o.type, true) && CapabilityStatement2RestResourceSearchParamComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.definition, this.type, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.rest.resource.searchParam";
        }
    }

    @Block
    public static class ResourceInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="read | vread | update | patch | delete | history-instance | history-type | create | search-type", formalDefinition="Coded identifier of the operation, supported by the system resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/type-restful-interaction")
        protected Enumeration<TypeRestfulInteraction> code;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = 2128937796L;

        public ResourceInteractionComponent() {
        }

        public ResourceInteractionComponent(Enumeration<TypeRestfulInteraction> code) {
            this.code = code;
        }

        public Enumeration<TypeRestfulInteraction> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResourceInteractionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<TypeRestfulInteraction>(new TypeRestfulInteractionEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ResourceInteractionComponent setCodeElement(Enumeration<TypeRestfulInteraction> value) {
            this.code = value;
            return this;
        }

        public TypeRestfulInteraction getCode() {
            return this.code == null ? null : (TypeRestfulInteraction)((Object)this.code.getValue());
        }

        public ResourceInteractionComponent setCode(TypeRestfulInteraction value) {
            if (this.code == null) {
                this.code = new Enumeration<TypeRestfulInteraction>(new TypeRestfulInteractionEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResourceInteractionComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ResourceInteractionComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ResourceInteractionComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Coded identifier of the operation, supported by the system resource.", 0, 1, this.code));
            children.add(new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Coded identifier of the operation, supported by the system resource.", 0, 1, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new TypeRestfulInteractionEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new TypeRestfulInteractionEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.code");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public ResourceInteractionComponent copy() {
            ResourceInteractionComponent dst = new ResourceInteractionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResourceInteractionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResourceInteractionComponent)) {
                return false;
            }
            ResourceInteractionComponent o = (ResourceInteractionComponent)other_;
            return ResourceInteractionComponent.compareDeep(this.code, o.code, true) && ResourceInteractionComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResourceInteractionComponent)) {
                return false;
            }
            ResourceInteractionComponent o = (ResourceInteractionComponent)other_;
            return ResourceInteractionComponent.compareValues(this.code, o.code, true) && ResourceInteractionComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.rest.resource.interaction";
        }
    }

    @Block
    public static class CapabilityStatement2RestResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource type that is supported", formalDefinition="A type of resource exposed via the restful interface.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType type;
        @Child(name="profile", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Base System profile for all uses of resource", formalDefinition="A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).")
        protected CanonicalType profile;
        @Child(name="supportedProfile", type={CanonicalType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Profiles for use cases supported", formalDefinition="A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).")
        protected List<CanonicalType> supportedProfile;
        @Child(name="documentation", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information about the use of the resource type", formalDefinition="Additional information about the resource type used by the system.")
        protected MarkdownType documentation;
        @Child(name="interaction", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="Identifies a restful operation supported by the solution.")
        protected List<ResourceInteractionComponent> interaction;
        @Child(name="searchParam", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Search parameters supported by implementation", formalDefinition="Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.")
        protected List<CapabilityStatement2RestResourceSearchParamComponent> searchParam;
        @Child(name="operation", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Definition of a resource operation", formalDefinition="Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.")
        protected List<CapabilityStatement2RestResourceOperationComponent> operation;
        private static final long serialVersionUID = 1394978037L;

        public CapabilityStatement2RestResourceComponent() {
        }

        public CapabilityStatement2RestResourceComponent(CodeType type) {
            this.type = type;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CapabilityStatement2RestResourceComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public CapabilityStatement2RestResourceComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public CapabilityStatement2RestResourceComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public CapabilityStatement2RestResourceComponent setProfile(String value) {
            if (Utilities.noString((String)value)) {
                this.profile = null;
            } else {
                if (this.profile == null) {
                    this.profile = new CanonicalType();
                }
                this.profile.setValue(value);
            }
            return this;
        }

        public List<CanonicalType> getSupportedProfile() {
            if (this.supportedProfile == null) {
                this.supportedProfile = new ArrayList<CanonicalType>();
            }
            return this.supportedProfile;
        }

        public CapabilityStatement2RestResourceComponent setSupportedProfile(List<CanonicalType> theSupportedProfile) {
            this.supportedProfile = theSupportedProfile;
            return this;
        }

        public boolean hasSupportedProfile() {
            if (this.supportedProfile == null) {
                return false;
            }
            for (CanonicalType item : this.supportedProfile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addSupportedProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.supportedProfile == null) {
                this.supportedProfile = new ArrayList<CanonicalType>();
            }
            this.supportedProfile.add(t);
            return t;
        }

        public CapabilityStatement2RestResourceComponent addSupportedProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.supportedProfile == null) {
                this.supportedProfile = new ArrayList<CanonicalType>();
            }
            this.supportedProfile.add(t);
            return this;
        }

        public boolean hasSupportedProfile(String value) {
            if (this.supportedProfile == null) {
                return false;
            }
            for (CanonicalType v : this.supportedProfile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestResourceComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatement2RestResourceComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatement2RestResourceComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<ResourceInteractionComponent> getInteraction() {
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            return this.interaction;
        }

        public CapabilityStatement2RestResourceComponent setInteraction(List<ResourceInteractionComponent> theInteraction) {
            this.interaction = theInteraction;
            return this;
        }

        public boolean hasInteraction() {
            if (this.interaction == null) {
                return false;
            }
            for (ResourceInteractionComponent item : this.interaction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ResourceInteractionComponent addInteraction() {
            ResourceInteractionComponent t = new ResourceInteractionComponent();
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            this.interaction.add(t);
            return t;
        }

        public CapabilityStatement2RestResourceComponent addInteraction(ResourceInteractionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            this.interaction.add(t);
            return this;
        }

        public ResourceInteractionComponent getInteractionFirstRep() {
            if (this.getInteraction().isEmpty()) {
                this.addInteraction();
            }
            return this.getInteraction().get(0);
        }

        public List<CapabilityStatement2RestResourceSearchParamComponent> getSearchParam() {
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
            }
            return this.searchParam;
        }

        public CapabilityStatement2RestResourceComponent setSearchParam(List<CapabilityStatement2RestResourceSearchParamComponent> theSearchParam) {
            this.searchParam = theSearchParam;
            return this;
        }

        public boolean hasSearchParam() {
            if (this.searchParam == null) {
                return false;
            }
            for (CapabilityStatement2RestResourceSearchParamComponent item : this.searchParam) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatement2RestResourceSearchParamComponent addSearchParam() {
            CapabilityStatement2RestResourceSearchParamComponent t = new CapabilityStatement2RestResourceSearchParamComponent();
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return t;
        }

        public CapabilityStatement2RestResourceComponent addSearchParam(CapabilityStatement2RestResourceSearchParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return this;
        }

        public CapabilityStatement2RestResourceSearchParamComponent getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }

        public List<CapabilityStatement2RestResourceOperationComponent> getOperation() {
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
            }
            return this.operation;
        }

        public CapabilityStatement2RestResourceComponent setOperation(List<CapabilityStatement2RestResourceOperationComponent> theOperation) {
            this.operation = theOperation;
            return this;
        }

        public boolean hasOperation() {
            if (this.operation == null) {
                return false;
            }
            for (CapabilityStatement2RestResourceOperationComponent item : this.operation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatement2RestResourceOperationComponent addOperation() {
            CapabilityStatement2RestResourceOperationComponent t = new CapabilityStatement2RestResourceOperationComponent();
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
            }
            this.operation.add(t);
            return t;
        }

        public CapabilityStatement2RestResourceComponent addOperation(CapabilityStatement2RestResourceOperationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
            }
            this.operation.add(t);
            return this;
        }

        public CapabilityStatement2RestResourceOperationComponent getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                this.addOperation();
            }
            return this.getOperation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "A type of resource exposed via the restful interface.", 0, 1, this.type));
            children.add(new Property("profile", "canonical(StructureDefinition)", "A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, 1, this.profile));
            children.add(new Property("supportedProfile", "canonical(StructureDefinition)", "A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, Integer.MAX_VALUE, this.supportedProfile));
            children.add(new Property("documentation", "markdown", "Additional information about the resource type used by the system.", 0, 1, this.documentation));
            children.add(new Property("interaction", "", "Identifies a restful operation supported by the solution.", 0, Integer.MAX_VALUE, this.interaction));
            children.add(new Property("searchParam", "", "Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam));
            children.add(new Property("operation", "", "Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.", 0, Integer.MAX_VALUE, this.operation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "A type of resource exposed via the restful interface.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, 1, this.profile);
                }
                case 1225477403: {
                    return new Property("supportedProfile", "canonical(StructureDefinition)", "A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, Integer.MAX_VALUE, this.supportedProfile);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Additional information about the resource type used by the system.", 0, 1, this.documentation);
                }
                case 1844104722: {
                    return new Property("interaction", "", "Identifies a restful operation supported by the solution.", 0, Integer.MAX_VALUE, this.interaction);
                }
                case -553645115: {
                    return new Property("searchParam", "", "Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam);
                }
                case 1662702951: {
                    return new Property("operation", "", "Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.", 0, Integer.MAX_VALUE, this.operation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
                case 1225477403: {
                    return this.supportedProfile == null ? new Base[]{} : this.supportedProfile.toArray(new Base[this.supportedProfile.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 1844104722: {
                    return this.interaction == null ? new Base[]{} : this.interaction.toArray(new Base[this.interaction.size()]);
                }
                case -553645115: {
                    return this.searchParam == null ? new Base[]{} : this.searchParam.toArray(new Base[this.searchParam.size()]);
                }
                case 1662702951: {
                    return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = this.castToCanonical(value);
                    return value;
                }
                case 1225477403: {
                    this.getSupportedProfile().add(this.castToCanonical(value));
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
                case 1844104722: {
                    this.getInteraction().add((ResourceInteractionComponent)value);
                    return value;
                }
                case -553645115: {
                    this.getSearchParam().add((CapabilityStatement2RestResourceSearchParamComponent)value);
                    return value;
                }
                case 1662702951: {
                    this.getOperation().add((CapabilityStatement2RestResourceOperationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToCanonical(value);
            } else if (name.equals("supportedProfile")) {
                this.getSupportedProfile().add(this.castToCanonical(value));
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else if (name.equals("interaction")) {
                this.getInteraction().add((ResourceInteractionComponent)value);
            } else if (name.equals("searchParam")) {
                this.getSearchParam().add((CapabilityStatement2RestResourceSearchParamComponent)value);
            } else if (name.equals("operation")) {
                this.getOperation().add((CapabilityStatement2RestResourceOperationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
                case 1225477403: {
                    return this.addSupportedProfileElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case 1844104722: {
                    return this.addInteraction();
                }
                case -553645115: {
                    return this.addSearchParam();
                }
                case 1662702951: {
                    return this.addOperation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
                case 1225477403: {
                    return new String[]{"canonical"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
                case 1844104722: {
                    return new String[0];
                }
                case -553645115: {
                    return new String[0];
                }
                case 1662702951: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.type");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.profile");
            }
            if (name.equals("supportedProfile")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.supportedProfile");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.documentation");
            }
            if (name.equals("interaction")) {
                return this.addInteraction();
            }
            if (name.equals("searchParam")) {
                return this.addSearchParam();
            }
            if (name.equals("operation")) {
                return this.addOperation();
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatement2RestResourceComponent copy() {
            CapabilityStatement2RestResourceComponent dst = new CapabilityStatement2RestResourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatement2RestResourceComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            CanonicalType canonicalType = dst.profile = this.profile == null ? null : this.profile.copy();
            if (this.supportedProfile != null) {
                dst.supportedProfile = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType2 : this.supportedProfile) {
                    dst.supportedProfile.add(canonicalType2.copy());
                }
            }
            MarkdownType markdownType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.interaction != null) {
                dst.interaction = new ArrayList<ResourceInteractionComponent>();
                for (ResourceInteractionComponent resourceInteractionComponent : this.interaction) {
                    dst.interaction.add(resourceInteractionComponent.copy());
                }
            }
            if (this.searchParam != null) {
                dst.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
                for (CapabilityStatement2RestResourceSearchParamComponent capabilityStatement2RestResourceSearchParamComponent : this.searchParam) {
                    dst.searchParam.add(capabilityStatement2RestResourceSearchParamComponent.copy());
                }
            }
            if (this.operation != null) {
                dst.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
                for (CapabilityStatement2RestResourceOperationComponent capabilityStatement2RestResourceOperationComponent : this.operation) {
                    dst.operation.add(capabilityStatement2RestResourceOperationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestResourceComponent)) {
                return false;
            }
            CapabilityStatement2RestResourceComponent o = (CapabilityStatement2RestResourceComponent)other_;
            return CapabilityStatement2RestResourceComponent.compareDeep(this.type, o.type, true) && CapabilityStatement2RestResourceComponent.compareDeep(this.profile, o.profile, true) && CapabilityStatement2RestResourceComponent.compareDeep(this.supportedProfile, o.supportedProfile, true) && CapabilityStatement2RestResourceComponent.compareDeep(this.documentation, o.documentation, true) && CapabilityStatement2RestResourceComponent.compareDeep(this.interaction, o.interaction, true) && CapabilityStatement2RestResourceComponent.compareDeep(this.searchParam, o.searchParam, true) && CapabilityStatement2RestResourceComponent.compareDeep(this.operation, o.operation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestResourceComponent)) {
                return false;
            }
            CapabilityStatement2RestResourceComponent o = (CapabilityStatement2RestResourceComponent)other_;
            return CapabilityStatement2RestResourceComponent.compareValues(this.type, o.type, true) && CapabilityStatement2RestResourceComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.profile, this.supportedProfile, this.documentation, this.interaction, this.searchParam, this.operation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.rest.resource";
        }
    }

    @Block
    public static class CapabilityStatement2RestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="client | server", formalDefinition="Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/restful-capability-mode")
        protected Enumeration<RestfulCapabilityMode> mode;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General description of implementation", formalDefinition="Information about the system's restful capabilities that apply across all applications, such as security.")
        protected MarkdownType documentation;
        @Child(name="resource", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource served on the REST interface", formalDefinition="A specification of the restful capabilities of the solution for a specific resource type.")
        protected List<CapabilityStatement2RestResourceComponent> resource;
        @Child(name="interaction", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="A specification of restful operations supported by the system.")
        protected List<SystemInteractionComponent> interaction;
        @Child(name="searchParam", type={CapabilityStatement2RestResourceSearchParamComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Search parameters for searching all resources", formalDefinition="Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.")
        protected List<CapabilityStatement2RestResourceSearchParamComponent> searchParam;
        @Child(name="operation", type={CapabilityStatement2RestResourceOperationComponent.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Definition of a system level operation", formalDefinition="Definition of an operation or a named query together with its parameters and their meaning and type.")
        protected List<CapabilityStatement2RestResourceOperationComponent> operation;
        @Child(name="compartment", type={CanonicalType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Compartments served/used by system", formalDefinition="An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .")
        protected List<CanonicalType> compartment;
        private static final long serialVersionUID = -476653235L;

        public CapabilityStatement2RestComponent() {
        }

        public CapabilityStatement2RestComponent(Enumeration<RestfulCapabilityMode> mode) {
            this.mode = mode;
        }

        public Enumeration<RestfulCapabilityMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<RestfulCapabilityMode>(new RestfulCapabilityModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public CapabilityStatement2RestComponent setModeElement(Enumeration<RestfulCapabilityMode> value) {
            this.mode = value;
            return this;
        }

        public RestfulCapabilityMode getMode() {
            return this.mode == null ? null : (RestfulCapabilityMode)((Object)this.mode.getValue());
        }

        public CapabilityStatement2RestComponent setMode(RestfulCapabilityMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<RestfulCapabilityMode>(new RestfulCapabilityModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2RestComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatement2RestComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatement2RestComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<CapabilityStatement2RestResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<CapabilityStatement2RestResourceComponent>();
            }
            return this.resource;
        }

        public CapabilityStatement2RestComponent setResource(List<CapabilityStatement2RestResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (CapabilityStatement2RestResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatement2RestResourceComponent addResource() {
            CapabilityStatement2RestResourceComponent t = new CapabilityStatement2RestResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<CapabilityStatement2RestResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public CapabilityStatement2RestComponent addResource(CapabilityStatement2RestResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<CapabilityStatement2RestResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public CapabilityStatement2RestResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<SystemInteractionComponent> getInteraction() {
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            return this.interaction;
        }

        public CapabilityStatement2RestComponent setInteraction(List<SystemInteractionComponent> theInteraction) {
            this.interaction = theInteraction;
            return this;
        }

        public boolean hasInteraction() {
            if (this.interaction == null) {
                return false;
            }
            for (SystemInteractionComponent item : this.interaction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SystemInteractionComponent addInteraction() {
            SystemInteractionComponent t = new SystemInteractionComponent();
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            this.interaction.add(t);
            return t;
        }

        public CapabilityStatement2RestComponent addInteraction(SystemInteractionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            this.interaction.add(t);
            return this;
        }

        public SystemInteractionComponent getInteractionFirstRep() {
            if (this.getInteraction().isEmpty()) {
                this.addInteraction();
            }
            return this.getInteraction().get(0);
        }

        public List<CapabilityStatement2RestResourceSearchParamComponent> getSearchParam() {
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
            }
            return this.searchParam;
        }

        public CapabilityStatement2RestComponent setSearchParam(List<CapabilityStatement2RestResourceSearchParamComponent> theSearchParam) {
            this.searchParam = theSearchParam;
            return this;
        }

        public boolean hasSearchParam() {
            if (this.searchParam == null) {
                return false;
            }
            for (CapabilityStatement2RestResourceSearchParamComponent item : this.searchParam) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatement2RestResourceSearchParamComponent addSearchParam() {
            CapabilityStatement2RestResourceSearchParamComponent t = new CapabilityStatement2RestResourceSearchParamComponent();
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return t;
        }

        public CapabilityStatement2RestComponent addSearchParam(CapabilityStatement2RestResourceSearchParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return this;
        }

        public CapabilityStatement2RestResourceSearchParamComponent getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }

        public List<CapabilityStatement2RestResourceOperationComponent> getOperation() {
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
            }
            return this.operation;
        }

        public CapabilityStatement2RestComponent setOperation(List<CapabilityStatement2RestResourceOperationComponent> theOperation) {
            this.operation = theOperation;
            return this;
        }

        public boolean hasOperation() {
            if (this.operation == null) {
                return false;
            }
            for (CapabilityStatement2RestResourceOperationComponent item : this.operation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatement2RestResourceOperationComponent addOperation() {
            CapabilityStatement2RestResourceOperationComponent t = new CapabilityStatement2RestResourceOperationComponent();
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
            }
            this.operation.add(t);
            return t;
        }

        public CapabilityStatement2RestComponent addOperation(CapabilityStatement2RestResourceOperationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
            }
            this.operation.add(t);
            return this;
        }

        public CapabilityStatement2RestResourceOperationComponent getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                this.addOperation();
            }
            return this.getOperation().get(0);
        }

        public List<CanonicalType> getCompartment() {
            if (this.compartment == null) {
                this.compartment = new ArrayList<CanonicalType>();
            }
            return this.compartment;
        }

        public CapabilityStatement2RestComponent setCompartment(List<CanonicalType> theCompartment) {
            this.compartment = theCompartment;
            return this;
        }

        public boolean hasCompartment() {
            if (this.compartment == null) {
                return false;
            }
            for (CanonicalType item : this.compartment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addCompartmentElement() {
            CanonicalType t = new CanonicalType();
            if (this.compartment == null) {
                this.compartment = new ArrayList<CanonicalType>();
            }
            this.compartment.add(t);
            return t;
        }

        public CapabilityStatement2RestComponent addCompartment(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.compartment == null) {
                this.compartment = new ArrayList<CanonicalType>();
            }
            this.compartment.add(t);
            return this;
        }

        public boolean hasCompartment(String value) {
            if (this.compartment == null) {
                return false;
            }
            for (CanonicalType v : this.compartment) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement2.SP_MODE, "code", "Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.", 0, 1, this.mode));
            children.add(new Property("documentation", "markdown", "Information about the system's restful capabilities that apply across all applications, such as security.", 0, 1, this.documentation));
            children.add(new Property(CapabilityStatement2.SP_RESOURCE, "", "A specification of the restful capabilities of the solution for a specific resource type.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("interaction", "", "A specification of restful operations supported by the system.", 0, Integer.MAX_VALUE, this.interaction));
            children.add(new Property("searchParam", "@CapabilityStatement2.rest.resource.searchParam", "Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam));
            children.add(new Property("operation", "@CapabilityStatement2.rest.resource.operation", "Definition of an operation or a named query together with its parameters and their meaning and type.", 0, Integer.MAX_VALUE, this.operation));
            children.add(new Property("compartment", "canonical(CompartmentDefinition)", "An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .", 0, Integer.MAX_VALUE, this.compartment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property(CapabilityStatement2.SP_MODE, "code", "Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.", 0, 1, this.mode);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Information about the system's restful capabilities that apply across all applications, such as security.", 0, 1, this.documentation);
                }
                case -341064690: {
                    return new Property(CapabilityStatement2.SP_RESOURCE, "", "A specification of the restful capabilities of the solution for a specific resource type.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 1844104722: {
                    return new Property("interaction", "", "A specification of restful operations supported by the system.", 0, Integer.MAX_VALUE, this.interaction);
                }
                case -553645115: {
                    return new Property("searchParam", "@CapabilityStatement2.rest.resource.searchParam", "Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam);
                }
                case 1662702951: {
                    return new Property("operation", "@CapabilityStatement2.rest.resource.operation", "Definition of an operation or a named query together with its parameters and their meaning and type.", 0, Integer.MAX_VALUE, this.operation);
                }
                case -397756334: {
                    return new Property("compartment", "canonical(CompartmentDefinition)", "An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .", 0, Integer.MAX_VALUE, this.compartment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 1844104722: {
                    return this.interaction == null ? new Base[]{} : this.interaction.toArray(new Base[this.interaction.size()]);
                }
                case -553645115: {
                    return this.searchParam == null ? new Base[]{} : this.searchParam.toArray(new Base[this.searchParam.size()]);
                }
                case 1662702951: {
                    return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
                }
                case -397756334: {
                    return this.compartment == null ? new Base[]{} : this.compartment.toArray(new Base[this.compartment.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new RestfulCapabilityModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((CapabilityStatement2RestResourceComponent)((Object)value));
                    return value;
                }
                case 1844104722: {
                    this.getInteraction().add((SystemInteractionComponent)((Object)value));
                    return value;
                }
                case -553645115: {
                    this.getSearchParam().add((CapabilityStatement2RestResourceSearchParamComponent)((Object)value));
                    return value;
                }
                case 1662702951: {
                    this.getOperation().add((CapabilityStatement2RestResourceOperationComponent)((Object)value));
                    return value;
                }
                case -397756334: {
                    this.getCompartment().add(this.castToCanonical(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_MODE)) {
                value = new RestfulCapabilityModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else if (name.equals(CapabilityStatement2.SP_RESOURCE)) {
                this.getResource().add((CapabilityStatement2RestResourceComponent)((Object)value));
            } else if (name.equals("interaction")) {
                this.getInteraction().add((SystemInteractionComponent)((Object)value));
            } else if (name.equals("searchParam")) {
                this.getSearchParam().add((CapabilityStatement2RestResourceSearchParamComponent)((Object)value));
            } else if (name.equals("operation")) {
                this.getOperation().add((CapabilityStatement2RestResourceOperationComponent)((Object)value));
            } else if (name.equals("compartment")) {
                this.getCompartment().add(this.castToCanonical(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case -341064690: {
                    return this.addResource();
                }
                case 1844104722: {
                    return this.addInteraction();
                }
                case -553645115: {
                    return this.addSearchParam();
                }
                case 1662702951: {
                    return this.addOperation();
                }
                case -397756334: {
                    return this.addCompartmentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
                case -341064690: {
                    return new String[0];
                }
                case 1844104722: {
                    return new String[0];
                }
                case -553645115: {
                    return new String[]{"@CapabilityStatement2.rest.resource.searchParam"};
                }
                case 1662702951: {
                    return new String[]{"@CapabilityStatement2.rest.resource.operation"};
                }
                case -397756334: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.documentation");
            }
            if (name.equals(CapabilityStatement2.SP_RESOURCE)) {
                return this.addResource();
            }
            if (name.equals("interaction")) {
                return this.addInteraction();
            }
            if (name.equals("searchParam")) {
                return this.addSearchParam();
            }
            if (name.equals("operation")) {
                return this.addOperation();
            }
            if (name.equals("compartment")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.compartment");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatement2RestComponent copy() {
            CapabilityStatement2RestComponent dst = new CapabilityStatement2RestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatement2RestComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            MarkdownType markdownType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<CapabilityStatement2RestResourceComponent>();
                for (CapabilityStatement2RestResourceComponent capabilityStatement2RestResourceComponent : this.resource) {
                    dst.resource.add(capabilityStatement2RestResourceComponent.copy());
                }
            }
            if (this.interaction != null) {
                dst.interaction = new ArrayList<SystemInteractionComponent>();
                for (SystemInteractionComponent systemInteractionComponent : this.interaction) {
                    dst.interaction.add(systemInteractionComponent.copy());
                }
            }
            if (this.searchParam != null) {
                dst.searchParam = new ArrayList<CapabilityStatement2RestResourceSearchParamComponent>();
                for (CapabilityStatement2RestResourceSearchParamComponent capabilityStatement2RestResourceSearchParamComponent : this.searchParam) {
                    dst.searchParam.add(capabilityStatement2RestResourceSearchParamComponent.copy());
                }
            }
            if (this.operation != null) {
                dst.operation = new ArrayList<CapabilityStatement2RestResourceOperationComponent>();
                for (CapabilityStatement2RestResourceOperationComponent capabilityStatement2RestResourceOperationComponent : this.operation) {
                    dst.operation.add(capabilityStatement2RestResourceOperationComponent.copy());
                }
            }
            if (this.compartment != null) {
                dst.compartment = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.compartment) {
                    dst.compartment.add(canonicalType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestComponent)) {
                return false;
            }
            CapabilityStatement2RestComponent o = (CapabilityStatement2RestComponent)other_;
            return CapabilityStatement2RestComponent.compareDeep(this.mode, o.mode, true) && CapabilityStatement2RestComponent.compareDeep(this.documentation, o.documentation, true) && CapabilityStatement2RestComponent.compareDeep(this.resource, o.resource, true) && CapabilityStatement2RestComponent.compareDeep(this.interaction, o.interaction, true) && CapabilityStatement2RestComponent.compareDeep(this.searchParam, o.searchParam, true) && CapabilityStatement2RestComponent.compareDeep(this.operation, o.operation, true) && CapabilityStatement2RestComponent.compareDeep(this.compartment, o.compartment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2RestComponent)) {
                return false;
            }
            CapabilityStatement2RestComponent o = (CapabilityStatement2RestComponent)other_;
            return CapabilityStatement2RestComponent.compareValues(this.mode, o.mode, true) && CapabilityStatement2RestComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mode, this.documentation, this.resource, this.interaction, this.searchParam, this.operation, this.compartment});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.rest";
        }
    }

    @Block
    public static class CapabilityStatement2ImplementationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Describes this specific instance", formalDefinition="Information about the specific installation that this capability statement relates to.")
        protected StringType description;
        @Child(name="url", type={UrlType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Base URL for the installation", formalDefinition="An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.")
        protected UrlType url;
        @Child(name="custodian", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization that manages the data", formalDefinition="The organization responsible for the management of the instance and oversight of the data on the server at the specified URL.")
        protected Reference custodian;
        private static final long serialVersionUID = 1681322786L;

        public CapabilityStatement2ImplementationComponent() {
        }

        public CapabilityStatement2ImplementationComponent(StringType description) {
            this.description = description;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2ImplementationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CapabilityStatement2ImplementationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CapabilityStatement2ImplementationComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public UrlType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2ImplementationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UrlType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CapabilityStatement2ImplementationComponent setUrlElement(UrlType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CapabilityStatement2ImplementationComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UrlType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public Reference getCustodian() {
            if (this.custodian == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2ImplementationComponent.custodian");
                }
                if (Configuration.doAutoCreate()) {
                    this.custodian = new Reference();
                }
            }
            return this.custodian;
        }

        public boolean hasCustodian() {
            return this.custodian != null && !this.custodian.isEmpty();
        }

        public CapabilityStatement2ImplementationComponent setCustodian(Reference value) {
            this.custodian = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement2.SP_DESCRIPTION, "string", "Information about the specific installation that this capability statement relates to.", 0, 1, this.description));
            children.add(new Property(CapabilityStatement2.SP_URL, CapabilityStatement2.SP_URL, "An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.", 0, 1, this.url));
            children.add(new Property("custodian", "Reference(Organization)", "The organization responsible for the management of the instance and oversight of the data on the server at the specified URL.", 0, 1, this.custodian));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(CapabilityStatement2.SP_DESCRIPTION, "string", "Information about the specific installation that this capability statement relates to.", 0, 1, this.description);
                }
                case 116079: {
                    return new Property(CapabilityStatement2.SP_URL, CapabilityStatement2.SP_URL, "An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.", 0, 1, this.url);
                }
                case 1611297262: {
                    return new Property("custodian", "Reference(Organization)", "The organization responsible for the management of the instance and oversight of the data on the server at the specified URL.", 0, 1, this.custodian);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 1611297262: {
                    Base[] baseArray;
                    if (this.custodian == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.custodian;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = this.castToUrl(value);
                    return value;
                }
                case 1611297262: {
                    this.custodian = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals(CapabilityStatement2.SP_URL)) {
                this.url = this.castToUrl(value);
            } else if (name.equals("custodian")) {
                this.custodian = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 1611297262: {
                    return this.getCustodian();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{CapabilityStatement2.SP_URL};
                }
                case 1611297262: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.description");
            }
            if (name.equals(CapabilityStatement2.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.url");
            }
            if (name.equals("custodian")) {
                this.custodian = new Reference();
                return this.custodian;
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatement2ImplementationComponent copy() {
            CapabilityStatement2ImplementationComponent dst = new CapabilityStatement2ImplementationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatement2ImplementationComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.custodian = this.custodian == null ? null : this.custodian.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2ImplementationComponent)) {
                return false;
            }
            CapabilityStatement2ImplementationComponent o = (CapabilityStatement2ImplementationComponent)other_;
            return CapabilityStatement2ImplementationComponent.compareDeep(this.description, o.description, true) && CapabilityStatement2ImplementationComponent.compareDeep(this.url, o.url, true) && CapabilityStatement2ImplementationComponent.compareDeep(this.custodian, o.custodian, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2ImplementationComponent)) {
                return false;
            }
            CapabilityStatement2ImplementationComponent o = (CapabilityStatement2ImplementationComponent)other_;
            return CapabilityStatement2ImplementationComponent.compareValues(this.description, o.description, true) && CapabilityStatement2ImplementationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.url, this.custodian});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.implementation";
        }
    }

    @Block
    public static class CapabilityStatement2SoftwareComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A name the software is known by", formalDefinition="Name the software is known by.")
        protected StringType name;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version covered by this statement", formalDefinition="The version identifier for the software covered by this statement.")
        protected StringType version;
        @Child(name="releaseDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date this version was released", formalDefinition="Date this version of the software was released.")
        protected DateTimeType releaseDate;
        private static final long serialVersionUID = 1819769027L;

        public CapabilityStatement2SoftwareComponent() {
        }

        public CapabilityStatement2SoftwareComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2SoftwareComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CapabilityStatement2SoftwareComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CapabilityStatement2SoftwareComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2SoftwareComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public CapabilityStatement2SoftwareComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public CapabilityStatement2SoftwareComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public DateTimeType getReleaseDateElement() {
            if (this.releaseDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatement2SoftwareComponent.releaseDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.releaseDate = new DateTimeType();
                }
            }
            return this.releaseDate;
        }

        public boolean hasReleaseDateElement() {
            return this.releaseDate != null && !this.releaseDate.isEmpty();
        }

        public boolean hasReleaseDate() {
            return this.releaseDate != null && !this.releaseDate.isEmpty();
        }

        public CapabilityStatement2SoftwareComponent setReleaseDateElement(DateTimeType value) {
            this.releaseDate = value;
            return this;
        }

        public Date getReleaseDate() {
            return this.releaseDate == null ? null : (Date)this.releaseDate.getValue();
        }

        public CapabilityStatement2SoftwareComponent setReleaseDate(Date value) {
            if (value == null) {
                this.releaseDate = null;
            } else {
                if (this.releaseDate == null) {
                    this.releaseDate = new DateTimeType();
                }
                this.releaseDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement2.SP_NAME, "string", "Name the software is known by.", 0, 1, this.name));
            children.add(new Property(CapabilityStatement2.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, 1, this.version));
            children.add(new Property("releaseDate", "dateTime", "Date this version of the software was released.", 0, 1, this.releaseDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(CapabilityStatement2.SP_NAME, "string", "Name the software is known by.", 0, 1, this.name);
                }
                case 351608024: {
                    return new Property(CapabilityStatement2.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, 1, this.version);
                }
                case 212873301: {
                    return new Property("releaseDate", "dateTime", "Date this version of the software was released.", 0, 1, this.releaseDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 212873301: {
                    Base[] baseArray;
                    if (this.releaseDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.releaseDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
                case 212873301: {
                    this.releaseDate = this.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(CapabilityStatement2.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("releaseDate")) {
                this.releaseDate = this.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 212873301: {
                    return this.getReleaseDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 212873301: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement2.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.name");
            }
            if (name.equals(CapabilityStatement2.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.version");
            }
            if (name.equals("releaseDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement2.releaseDate");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatement2SoftwareComponent copy() {
            CapabilityStatement2SoftwareComponent dst = new CapabilityStatement2SoftwareComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatement2SoftwareComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.releaseDate = this.releaseDate == null ? null : this.releaseDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2SoftwareComponent)) {
                return false;
            }
            CapabilityStatement2SoftwareComponent o = (CapabilityStatement2SoftwareComponent)other_;
            return CapabilityStatement2SoftwareComponent.compareDeep(this.name, o.name, true) && CapabilityStatement2SoftwareComponent.compareDeep(this.version, o.version, true) && CapabilityStatement2SoftwareComponent.compareDeep(this.releaseDate, o.releaseDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatement2SoftwareComponent)) {
                return false;
            }
            CapabilityStatement2SoftwareComponent o = (CapabilityStatement2SoftwareComponent)other_;
            return CapabilityStatement2SoftwareComponent.compareValues(this.name, o.name, true) && CapabilityStatement2SoftwareComponent.compareValues(this.version, o.version, true) && CapabilityStatement2SoftwareComponent.compareValues(this.releaseDate, o.releaseDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.version, this.releaseDate});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement2.software";
        }
    }

    public static class SystemRestfulInteractionEnumFactory
    implements EnumFactory<SystemRestfulInteraction> {
        @Override
        public SystemRestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return SystemRestfulInteraction.TRANSACTION;
            }
            if ("batch".equals(codeString)) {
                return SystemRestfulInteraction.BATCH;
            }
            if ("search-system".equals(codeString)) {
                return SystemRestfulInteraction.SEARCHSYSTEM;
            }
            if ("history-system".equals(codeString)) {
                return SystemRestfulInteraction.HISTORYSYSTEM;
            }
            throw new IllegalArgumentException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        public Enumeration<SystemRestfulInteraction> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SystemRestfulInteraction>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.TRANSACTION);
            }
            if ("batch".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.BATCH);
            }
            if ("search-system".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.SEARCHSYSTEM);
            }
            if ("history-system".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.HISTORYSYSTEM);
            }
            throw new FHIRException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        @Override
        public String toCode(SystemRestfulInteraction code) {
            if (code == SystemRestfulInteraction.TRANSACTION) {
                return "transaction";
            }
            if (code == SystemRestfulInteraction.BATCH) {
                return "batch";
            }
            if (code == SystemRestfulInteraction.SEARCHSYSTEM) {
                return "search-system";
            }
            if (code == SystemRestfulInteraction.HISTORYSYSTEM) {
                return "history-system";
            }
            return "?";
        }

        @Override
        public String toSystem(SystemRestfulInteraction code) {
            return code.getSystem();
        }
    }

    public static enum SystemRestfulInteraction {
        TRANSACTION,
        BATCH,
        SEARCHSYSTEM,
        HISTORYSYSTEM,
        NULL;


        public static SystemRestfulInteraction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("batch".equals(codeString)) {
                return BATCH;
            }
            if ("search-system".equals(codeString)) {
                return SEARCHSYSTEM;
            }
            if ("history-system".equals(codeString)) {
                return HISTORYSYSTEM;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TRANSACTION: {
                    return "transaction";
                }
                case BATCH: {
                    return "batch";
                }
                case SEARCHSYSTEM: {
                    return "search-system";
                }
                case HISTORYSYSTEM: {
                    return "history-system";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TRANSACTION: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case BATCH: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case SEARCHSYSTEM: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYSYSTEM: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TRANSACTION: {
                    return "";
                }
                case BATCH: {
                    return "";
                }
                case SEARCHSYSTEM: {
                    return "";
                }
                case HISTORYSYSTEM: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TRANSACTION: {
                    return "transaction";
                }
                case BATCH: {
                    return "batch";
                }
                case SEARCHSYSTEM: {
                    return "search-system";
                }
                case HISTORYSYSTEM: {
                    return "history-system";
                }
            }
            return "?";
        }
    }

    public static class TypeRestfulInteractionEnumFactory
    implements EnumFactory<TypeRestfulInteraction> {
        @Override
        public TypeRestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("read".equals(codeString)) {
                return TypeRestfulInteraction.READ;
            }
            if ("vread".equals(codeString)) {
                return TypeRestfulInteraction.VREAD;
            }
            if ("update".equals(codeString)) {
                return TypeRestfulInteraction.UPDATE;
            }
            if ("patch".equals(codeString)) {
                return TypeRestfulInteraction.PATCH;
            }
            if ("delete".equals(codeString)) {
                return TypeRestfulInteraction.DELETE;
            }
            if ("history-instance".equals(codeString)) {
                return TypeRestfulInteraction.HISTORYINSTANCE;
            }
            if ("history-type".equals(codeString)) {
                return TypeRestfulInteraction.HISTORYTYPE;
            }
            if ("create".equals(codeString)) {
                return TypeRestfulInteraction.CREATE;
            }
            if ("search-type".equals(codeString)) {
                return TypeRestfulInteraction.SEARCHTYPE;
            }
            throw new IllegalArgumentException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        public Enumeration<TypeRestfulInteraction> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TypeRestfulInteraction>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("read".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.READ);
            }
            if ("vread".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.VREAD);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.UPDATE);
            }
            if ("patch".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.PATCH);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.DELETE);
            }
            if ("history-instance".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.HISTORYINSTANCE);
            }
            if ("history-type".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.HISTORYTYPE);
            }
            if ("create".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.CREATE);
            }
            if ("search-type".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.SEARCHTYPE);
            }
            throw new FHIRException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        @Override
        public String toCode(TypeRestfulInteraction code) {
            if (code == TypeRestfulInteraction.READ) {
                return "read";
            }
            if (code == TypeRestfulInteraction.VREAD) {
                return "vread";
            }
            if (code == TypeRestfulInteraction.UPDATE) {
                return "update";
            }
            if (code == TypeRestfulInteraction.PATCH) {
                return "patch";
            }
            if (code == TypeRestfulInteraction.DELETE) {
                return "delete";
            }
            if (code == TypeRestfulInteraction.HISTORYINSTANCE) {
                return "history-instance";
            }
            if (code == TypeRestfulInteraction.HISTORYTYPE) {
                return "history-type";
            }
            if (code == TypeRestfulInteraction.CREATE) {
                return "create";
            }
            if (code == TypeRestfulInteraction.SEARCHTYPE) {
                return "search-type";
            }
            return "?";
        }

        @Override
        public String toSystem(TypeRestfulInteraction code) {
            return code.getSystem();
        }
    }

    public static enum TypeRestfulInteraction {
        READ,
        VREAD,
        UPDATE,
        PATCH,
        DELETE,
        HISTORYINSTANCE,
        HISTORYTYPE,
        CREATE,
        SEARCHTYPE,
        NULL;


        public static TypeRestfulInteraction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("read".equals(codeString)) {
                return READ;
            }
            if ("vread".equals(codeString)) {
                return VREAD;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("patch".equals(codeString)) {
                return PATCH;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if ("history-instance".equals(codeString)) {
                return HISTORYINSTANCE;
            }
            if ("history-type".equals(codeString)) {
                return HISTORYTYPE;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("search-type".equals(codeString)) {
                return SEARCHTYPE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case READ: {
                    return "read";
                }
                case VREAD: {
                    return "vread";
                }
                case UPDATE: {
                    return "update";
                }
                case PATCH: {
                    return "patch";
                }
                case DELETE: {
                    return "delete";
                }
                case HISTORYINSTANCE: {
                    return "history-instance";
                }
                case HISTORYTYPE: {
                    return "history-type";
                }
                case CREATE: {
                    return "create";
                }
                case SEARCHTYPE: {
                    return "search-type";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case READ: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case VREAD: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case PATCH: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYINSTANCE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYTYPE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case SEARCHTYPE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case READ: {
                    return "";
                }
                case VREAD: {
                    return "";
                }
                case UPDATE: {
                    return "";
                }
                case PATCH: {
                    return "";
                }
                case DELETE: {
                    return "";
                }
                case HISTORYINSTANCE: {
                    return "";
                }
                case HISTORYTYPE: {
                    return "";
                }
                case CREATE: {
                    return "";
                }
                case SEARCHTYPE: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case READ: {
                    return "read";
                }
                case VREAD: {
                    return "vread";
                }
                case UPDATE: {
                    return "update";
                }
                case PATCH: {
                    return "patch";
                }
                case DELETE: {
                    return "delete";
                }
                case HISTORYINSTANCE: {
                    return "history-instance";
                }
                case HISTORYTYPE: {
                    return "history-type";
                }
                case CREATE: {
                    return "create";
                }
                case SEARCHTYPE: {
                    return "search-type";
                }
            }
            return "?";
        }
    }

    public static class RestfulCapabilityModeEnumFactory
    implements EnumFactory<RestfulCapabilityMode> {
        @Override
        public RestfulCapabilityMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("client".equals(codeString)) {
                return RestfulCapabilityMode.CLIENT;
            }
            if ("server".equals(codeString)) {
                return RestfulCapabilityMode.SERVER;
            }
            throw new IllegalArgumentException("Unknown RestfulCapabilityMode code '" + codeString + "'");
        }

        public Enumeration<RestfulCapabilityMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RestfulCapabilityMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("client".equals(codeString)) {
                return new Enumeration<RestfulCapabilityMode>(this, RestfulCapabilityMode.CLIENT);
            }
            if ("server".equals(codeString)) {
                return new Enumeration<RestfulCapabilityMode>(this, RestfulCapabilityMode.SERVER);
            }
            throw new FHIRException("Unknown RestfulCapabilityMode code '" + codeString + "'");
        }

        @Override
        public String toCode(RestfulCapabilityMode code) {
            if (code == RestfulCapabilityMode.CLIENT) {
                return "client";
            }
            if (code == RestfulCapabilityMode.SERVER) {
                return "server";
            }
            return "?";
        }

        @Override
        public String toSystem(RestfulCapabilityMode code) {
            return code.getSystem();
        }
    }

    public static enum RestfulCapabilityMode {
        CLIENT,
        SERVER,
        NULL;


        public static RestfulCapabilityMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("client".equals(codeString)) {
                return CLIENT;
            }
            if ("server".equals(codeString)) {
                return SERVER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RestfulCapabilityMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLIENT: {
                    return "client";
                }
                case SERVER: {
                    return "server";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLIENT: {
                    return "http://hl7.org/fhir/restful-capability-mode";
                }
                case SERVER: {
                    return "http://hl7.org/fhir/restful-capability-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLIENT: {
                    return "The application acts as a client for this resource.";
                }
                case SERVER: {
                    return "The application acts as a server for this resource.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLIENT: {
                    return "Client";
                }
                case SERVER: {
                    return "Server";
                }
            }
            return "?";
        }
    }

    public static class CapabilityStatement2KindEnumFactory
    implements EnumFactory<CapabilityStatement2Kind> {
        @Override
        public CapabilityStatement2Kind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return CapabilityStatement2Kind.INSTANCE;
            }
            if ("capability".equals(codeString)) {
                return CapabilityStatement2Kind.CAPABILITY;
            }
            if ("requirements".equals(codeString)) {
                return CapabilityStatement2Kind.REQUIREMENTS;
            }
            throw new IllegalArgumentException("Unknown CapabilityStatement2Kind code '" + codeString + "'");
        }

        public Enumeration<CapabilityStatement2Kind> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CapabilityStatement2Kind>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<CapabilityStatement2Kind>(this, CapabilityStatement2Kind.INSTANCE);
            }
            if ("capability".equals(codeString)) {
                return new Enumeration<CapabilityStatement2Kind>(this, CapabilityStatement2Kind.CAPABILITY);
            }
            if ("requirements".equals(codeString)) {
                return new Enumeration<CapabilityStatement2Kind>(this, CapabilityStatement2Kind.REQUIREMENTS);
            }
            throw new FHIRException("Unknown CapabilityStatement2Kind code '" + codeString + "'");
        }

        @Override
        public String toCode(CapabilityStatement2Kind code) {
            if (code == CapabilityStatement2Kind.INSTANCE) {
                return "instance";
            }
            if (code == CapabilityStatement2Kind.CAPABILITY) {
                return "capability";
            }
            if (code == CapabilityStatement2Kind.REQUIREMENTS) {
                return "requirements";
            }
            return "?";
        }

        @Override
        public String toSystem(CapabilityStatement2Kind code) {
            return code.getSystem();
        }
    }

    public static enum CapabilityStatement2Kind {
        INSTANCE,
        CAPABILITY,
        REQUIREMENTS,
        NULL;


        public static CapabilityStatement2Kind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("capability".equals(codeString)) {
                return CAPABILITY;
            }
            if ("requirements".equals(codeString)) {
                return REQUIREMENTS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CapabilityStatement2Kind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case CAPABILITY: {
                    return "capability";
                }
                case REQUIREMENTS: {
                    return "requirements";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/capability-statement-kind";
                }
                case CAPABILITY: {
                    return "http://hl7.org/fhir/capability-statement-kind";
                }
                case REQUIREMENTS: {
                    return "http://hl7.org/fhir/capability-statement-kind";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The CapabilityStatement instance represents the present capabilities of a specific system instance.  This is the kind returned by /metadata for a FHIR server end-point.";
                }
                case CAPABILITY: {
                    return "The CapabilityStatement instance represents the capabilities of a system or piece of software, independent of a particular installation.";
                }
                case REQUIREMENTS: {
                    return "The CapabilityStatement instance represents a set of requirements for other systems to meet; e.g. as part of an implementation guide or 'request for proposal'.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case CAPABILITY: {
                    return "Capability";
                }
                case REQUIREMENTS: {
                    return "Requirements";
                }
            }
            return "?";
        }
    }
}

