package org.hl7.fhir.r5.formats;

/*
 * #%L
 * org.hl7.fhir.r5
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Thu, Oct 17, 2019 19:56+1100 for FHIR v4.1.0

import org.hl7.fhir.r5.model.*;
import org.hl7.fhir.r5.model.Enumerations.FHIRVersion;
import org.xmlpull.v1.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import java.io.IOException;

public class XmlParser extends XmlParserBase {

  public XmlParser() {
    super();
  }

  public XmlParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }


  protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extension")) 
      res.getExtension().add(parseExtension(xpp));
    else
      return false;
      
    return true;
  }

  protected boolean parseBackboneElementContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) 
      res.getModifierExtension().add(parseExtension(xpp));
    else
      return parseElementContent(eventType, xpp, res);
      
    return true;
  }

  protected boolean parseBackboneElementContent(int eventType, XmlPullParser xpp, BackboneType res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) 
      res.getModifierExtension().add(parseExtension(xpp));
    else
      return parseElementContent(eventType, xpp, res);
      
    return true;
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    parseElementAttributes(xpp, res);
    res.setValue((E) e.fromCode(xpp.getAttributeValue(null, "value")));
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DateType res = new DateType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    StringType res = new StringType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OidType res = new OidType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected CanonicalType parseCanonical(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CanonicalType res = new CanonicalType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UriType res = new UriType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UrlType parseUrl(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UrlType res = new UrlType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    IdType res = new IdType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Extension res = new Extension();
    parseElementAttributes(xpp, res);
    if (xpp.getAttributeValue(null, "url") != null)
        res.setUrl(xpp.getAttributeValue(null, "url"));
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExtensionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExtensionContent(int eventType, XmlPullParser xpp, Extension res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNarrativeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNarrativeContent(int eventType, XmlPullParser xpp, Narrative res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("div")) {
        res.setDiv(parseXhtml(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Meta res = new Meta();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMetaContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMetaContent(int eventType, XmlPullParser xpp, Meta res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
        res.setVersionIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastUpdated")) {
        res.setLastUpdatedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("security")) {
        res.getSecurity().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tag")) {
        res.getTag().add(parseCoding(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Address res = new Address();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAddressContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAddressContent(int eventType, XmlPullParser xpp, Address res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("line")) {
        res.getLine().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("city")) {
        res.setCityElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("district")) {
        res.setDistrictElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("state")) {
        res.setStateElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("postalCode")) {
        res.setPostalCodeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
        res.setCountryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contributor parseContributor(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContributorContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContributorContent(int eventType, XmlPullParser xpp, Contributor res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAttachmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAttachmentContent(int eventType, XmlPullParser xpp, Attachment res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
        res.setContentTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setDataElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("size")) {
        res.setSizeElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hash")) {
        res.setHashElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("creation")) {
        res.setCreationElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("height")) {
        res.setHeightElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("width")) {
        res.setWidthElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frames")) {
        res.setFramesElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDurationElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pages")) {
        res.setPagesElement(parsePositiveInt(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Count res = new Count();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCountContent(int eventType, XmlPullParser xpp, Count res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementContent(int eventType, XmlPullParser xpp, DataRequirement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
        res.setSubject(parseType("subject", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mustSupport")) {
        res.getMustSupport().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("codeFilter")) {
        res.getCodeFilter().add(parseDataRequirementDataRequirementCodeFilterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateFilter")) {
        res.getDateFilter().add(parseDataRequirementDataRequirementDateFilterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("limit")) {
        res.setLimitElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sort")) {
        res.getSort().add(parseDataRequirementDataRequirementSortComponent(xpp, res));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementDataRequirementCodeFilterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementDataRequirementCodeFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.setSearchParamElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
        res.setValueSetElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementDataRequirementDateFilterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementDataRequirementDateFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.setSearchParamElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement.DataRequirementSortComponent parseDataRequirementDataRequirementSortComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementDataRequirementSortComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementDataRequirementSortComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementSortComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("direction")) {
        res.setDirectionElement(parseEnumeration(xpp, DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Dosage parseDosage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDosageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDosageContent(int eventType, XmlPullParser xpp, Dosage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalInstruction")) {
        res.getAdditionalInstruction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientInstruction")) {
        res.setPatientInstructionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timing")) {
        res.setTiming(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "asNeeded")) {
        res.setAsNeeded(parseType("asNeeded", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
        res.setRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseAndRate")) {
        res.getDoseAndRate().add(parseDosageDosageDoseAndRateComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerPeriod")) {
        res.setMaxDosePerPeriod(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerAdministration")) {
        res.setMaxDosePerAdministration(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerLifetime")) {
        res.setMaxDosePerLifetime(parseQuantity(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Dosage.DosageDoseAndRateComponent parseDosageDosageDoseAndRateComponent(XmlPullParser xpp, Dosage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDosageDosageDoseAndRateComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDosageDosageDoseAndRateComponentContent(int eventType, XmlPullParser xpp, Dosage owner, Dosage.DosageDoseAndRateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "dose")) {
        res.setDose(parseType("dose", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
        res.setRate(parseType("rate", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Money res = new Money();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMoneyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMoneyContent(int eventType, XmlPullParser xpp, Money res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("currency")) {
        res.setCurrencyElement(parseCode(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHumanNameContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHumanNameContent(int eventType, XmlPullParser xpp, HumanName res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("family")) {
        res.setFamilyElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("given")) {
        res.getGiven().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prefix")) {
        res.getPrefix().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suffix")) {
        res.getSuffix().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContactPointContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContactPointContent(int eventType, XmlPullParser xpp, ContactPoint res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
        res.setRankElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MarketingStatus parseMarketingStatus(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MarketingStatus res = new MarketingStatus();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMarketingStatusContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMarketingStatusContent(int eventType, XmlPullParser xpp, MarketingStatus res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
        res.setCountry(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.setJurisdiction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateRange")) {
        res.setDateRange(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("restoreDate")) {
        res.setRestoreDateElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIdentifierContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIdentifierContent(int eventType, XmlPullParser xpp, Identifier res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assigner")) {
        res.setAssigner(parseReference(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SubstanceAmount parseSubstanceAmount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SubstanceAmount res = new SubstanceAmount();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubstanceAmountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubstanceAmountContent(int eventType, XmlPullParser xpp, SubstanceAmount res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "amount")) {
        res.setAmount(parseType("amount", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amountType")) {
        res.setAmountType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amountText")) {
        res.setAmountTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceRange")) {
        res.setReferenceRange(parseSubstanceAmountSubstanceAmountReferenceRangeComponent(xpp, res));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SubstanceAmount.SubstanceAmountReferenceRangeComponent parseSubstanceAmountSubstanceAmountReferenceRangeComponent(XmlPullParser xpp, SubstanceAmount owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SubstanceAmount.SubstanceAmountReferenceRangeComponent res = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubstanceAmountSubstanceAmountReferenceRangeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubstanceAmountSubstanceAmountReferenceRangeComponentContent(int eventType, XmlPullParser xpp, SubstanceAmount owner, SubstanceAmount.SubstanceAmountReferenceRangeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lowLimit")) {
        res.setLowLimit(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("highLimit")) {
        res.setHighLimit(parseQuantity(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Statistic parseStatistic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Statistic res = new Statistic();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStatisticContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStatisticContent(int eventType, XmlPullParser xpp, Statistic res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statisticType")) {
        res.setStatisticType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sampleSize")) {
        res.setSampleSize(parseStatisticStatisticSampleSizeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attributeEstimate")) {
        res.getAttributeEstimate().add(parseStatisticStatisticAttributeEstimateComponent(xpp, res));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Statistic.StatisticSampleSizeComponent parseStatisticStatisticSampleSizeComponent(XmlPullParser xpp, Statistic owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Statistic.StatisticSampleSizeComponent res = new Statistic.StatisticSampleSizeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStatisticStatisticSampleSizeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStatisticStatisticSampleSizeComponentContent(int eventType, XmlPullParser xpp, Statistic owner, Statistic.StatisticSampleSizeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfStudies")) {
        res.setNumberOfStudiesElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfParticipants")) {
        res.setNumberOfParticipantsElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("knownDataCount")) {
        res.setKnownDataCountElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numeratorCount")) {
        res.setNumeratorCountElement(parseInteger(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Statistic.StatisticAttributeEstimateComponent parseStatisticStatisticAttributeEstimateComponent(XmlPullParser xpp, Statistic owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Statistic.StatisticAttributeEstimateComponent res = new Statistic.StatisticAttributeEstimateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStatisticStatisticAttributeEstimateComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStatisticStatisticAttributeEstimateComponentContent(int eventType, XmlPullParser xpp, Statistic owner, Statistic.StatisticAttributeEstimateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("level")) {
        res.setLevelElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("range")) {
        res.setRange(parseRange(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("estimateQualifier")) {
        res.getEstimateQualifier().add(parseStatisticStatisticAttributeEstimateEstimateQualifierComponent(xpp, owner));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Statistic.StatisticAttributeEstimateEstimateQualifierComponent parseStatisticStatisticAttributeEstimateEstimateQualifierComponent(XmlPullParser xpp, Statistic owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Statistic.StatisticAttributeEstimateEstimateQualifierComponent res = new Statistic.StatisticAttributeEstimateEstimateQualifierComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStatisticStatisticAttributeEstimateEstimateQualifierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStatisticStatisticAttributeEstimateEstimateQualifierComponentContent(int eventType, XmlPullParser xpp, Statistic owner, Statistic.StatisticAttributeEstimateEstimateQualifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("level")) {
        res.setLevelElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("range")) {
        res.setRange(parseRange(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coding res = new Coding();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodingContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodingContent(int eventType, XmlPullParser xpp, Coding res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("userSelected")) {
        res.setUserSelectedElement(parseBoolean(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSampledDataContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSampledDataContent(int eventType, XmlPullParser xpp, SampledData res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
        res.setOrigin(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriodElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lowerLimit")) {
        res.setLowerLimitElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("upperLimit")) {
        res.setUpperLimitElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dimensions")) {
        res.setDimensionsElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setDataElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Population parsePopulation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Population res = new Population();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePopulationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePopulationContent(int eventType, XmlPullParser xpp, Population res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "age")) {
        res.setAge(parseType("age", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGender(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("race")) {
        res.setRace(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physiologicalCondition")) {
        res.setPhysiologicalCondition(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRatioContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRatioContent(int eventType, XmlPullParser xpp, Ratio res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numerator")) {
        res.setNumerator(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("denominator")) {
        res.setDenominator(parseQuantity(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OrderedDistribution parseOrderedDistribution(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OrderedDistribution res = new OrderedDistribution();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOrderedDistributionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOrderedDistributionContent(int eventType, XmlPullParser xpp, OrderedDistribution res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfIntervals")) {
        res.setNumberOfIntervalsElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bottomOfFirstInterval")) {
        res.setBottomOfFirstInterval(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interval")) {
        res.getInterval().add(parseOrderedDistributionOrderedDistributionIntervalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topOfInterval")) {
        res.setTopOfInterval(parseQuantity(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OrderedDistribution.OrderedDistributionIntervalComponent parseOrderedDistributionOrderedDistributionIntervalComponent(XmlPullParser xpp, OrderedDistribution owner) throws XmlPullParserException, IOException, FHIRFormatError {
    OrderedDistribution.OrderedDistributionIntervalComponent res = new OrderedDistribution.OrderedDistributionIntervalComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOrderedDistributionOrderedDistributionIntervalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOrderedDistributionOrderedDistributionIntervalComponentContent(int eventType, XmlPullParser xpp, OrderedDistribution owner, OrderedDistribution.OrderedDistributionIntervalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rankOrder")) {
        res.setRankOrderElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intervalStatistic")) {
        res.getIntervalStatistic().add(parseStatistic(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Distance res = new Distance();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDistanceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDistanceContent(int eventType, XmlPullParser xpp, Distance res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Age res = new Age();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAgeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAgeContent(int eventType, XmlPullParser xpp, Age res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Reference res = new Reference();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseReferenceContent(int eventType, XmlPullParser xpp, Reference res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTriggerDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTriggerDefinitionContent(int eventType, XmlPullParser xpp, TriggerDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.getData().add(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseExpression(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuantityContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuantityContent(int eventType, XmlPullParser xpp, Quantity res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comparator")) {
        res.setComparatorElement(parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnitElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Period res = new Period();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePeriodContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePeriodContent(int eventType, XmlPullParser xpp, Period res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseDateTime(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Duration res = new Duration();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDurationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDurationContent(int eventType, XmlPullParser xpp, Duration res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Range res = new Range();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRangeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRangeContent(int eventType, XmlPullParser xpp, Range res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("low")) {
        res.setLow(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("high")) {
        res.setHigh(parseQuantity(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RelatedArtifact parseRelatedArtifact(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRelatedArtifactContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRelatedArtifactContent(int eventType, XmlPullParser xpp, RelatedArtifact res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
        res.setLabelElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("citation")) {
        res.setCitationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("document")) {
        res.setDocument(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResourceElement(parseCanonical(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAnnotationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAnnotationContent(int eventType, XmlPullParser xpp, Annotation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "author")) {
        res.setAuthor(parseType("author", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
        res.setTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseMarkdown(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProductShelfLife parseProductShelfLife(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProductShelfLife res = new ProductShelfLife();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProductShelfLifeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProductShelfLifeContent(int eventType, XmlPullParser xpp, ProductShelfLife res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialPrecautionsForStorage")) {
        res.getSpecialPrecautionsForStorage().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ContactDetail parseContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContactDetailContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContactDetailContent(int eventType, XmlPullParser xpp, ContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected UsageContext parseUsageContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseUsageContextContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseUsageContextContent(int eventType, XmlPullParser xpp, UsageContext res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Expression parseExpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Expression res = new Expression();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpressionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpressionContent(int eventType, XmlPullParser xpp, Expression res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseUri(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Signature res = new Signature();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSignatureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSignatureContent(int eventType, XmlPullParser xpp, Signature res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("when")) {
        res.setWhenElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("who")) {
        res.setWho(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetFormat")) {
        res.setTargetFormatElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sigFormat")) {
        res.setSigFormatElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setDataElement(parseBase64Binary(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Timing res = new Timing();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTimingContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTimingContent(int eventType, XmlPullParser xpp, Timing res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repeat")) {
        res.setRepeat(parseTimingTimingRepeatComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(XmlPullParser xpp, Timing owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTimingTimingRepeatComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTimingTimingRepeatComponentContent(int eventType, XmlPullParser xpp, Timing owner, Timing.TimingRepeatComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "bounds")) {
        res.setBounds(parseType("bounds", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("countMax")) {
        res.setCountMaxElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDurationElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("durationMax")) {
        res.setDurationMaxElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("durationUnit")) {
        res.setDurationUnitElement(parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequency")) {
        res.setFrequencyElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequencyMax")) {
        res.setFrequencyMaxElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriodElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodMax")) {
        res.setPeriodMaxElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodUnit")) {
        res.setPeriodUnitElement(parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dayOfWeek")) {
        res.getDayOfWeek().add(parseEnumeration(xpp, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timeOfDay")) {
        res.getTimeOfDay().add(parseTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("when")) {
        res.getWhen().add(parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("offset")) {
        res.setOffsetElement(parseUnsignedInt(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProdCharacteristic parseProdCharacteristic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProdCharacteristic res = new ProdCharacteristic();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProdCharacteristicContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProdCharacteristicContent(int eventType, XmlPullParser xpp, ProdCharacteristic res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("height")) {
        res.setHeight(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("width")) {
        res.setWidth(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("depth")) {
        res.setDepth(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("weight")) {
        res.setWeight(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nominalVolume")) {
        res.setNominalVolume(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("externalDiameter")) {
        res.setExternalDiameter(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("shape")) {
        res.setShapeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("color")) {
        res.getColor().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imprint")) {
        res.getImprint().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
        res.getImage().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scoring")) {
        res.setScoring(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeableConceptContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeableConceptContent(int eventType, XmlPullParser xpp, CodeableConcept res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coding")) {
        res.getCoding().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseParameterDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParameterDefinitionContent(int eventType, XmlPullParser xpp, ParameterDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionContent(int eventType, XmlPullParser xpp, ElementDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("representation")) {
        res.getRepresentation().add(parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceName")) {
        res.setSliceNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceIsConstraining")) {
        res.setSliceIsConstrainingElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
        res.setLabelElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("slicing")) {
        res.setSlicing(parseElementDefinitionElementDefinitionSlicingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("short")) {
        res.setShortElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirements")) {
        res.setRequirementsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
        res.setBase(parseElementDefinitionElementDefinitionBaseComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentReference")) {
        res.setContentReferenceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseElementDefinitionTypeRefComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "defaultValue")) {
        res.setDefaultValue(parseType("defaultValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaningWhenMissing")) {
        res.setMeaningWhenMissingElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderMeaning")) {
        res.setOrderMeaningElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "fixed")) {
        res.setFixed(parseType("fixed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "pattern")) {
        res.setPattern(parseType("pattern", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("example")) {
        res.getExample().add(parseElementDefinitionElementDefinitionExampleComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "minValue")) {
        res.setMinValue(parseType("minValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "maxValue")) {
        res.setMaxValue(parseType("maxValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxLength")) {
        res.setMaxLengthElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.getCondition().add(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("constraint")) {
        res.getConstraint().add(parseElementDefinitionElementDefinitionConstraintComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mustSupport")) {
        res.setMustSupportElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isModifier")) {
        res.setIsModifierElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isModifierReason")) {
        res.setIsModifierReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isSummary")) {
        res.setIsSummaryElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("binding")) {
        res.setBinding(parseElementDefinitionElementDefinitionBindingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mapping")) {
        res.getMapping().add(parseElementDefinitionElementDefinitionMappingComponent(xpp, res));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionSlicingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionSlicingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("discriminator")) {
        res.getDiscriminator().add(parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ordered")) {
        res.setOrderedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rules")) {
        res.setRulesElement(parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionBaseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionBaseComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionTypeRefComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionTypeRefComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetProfile")) {
        res.getTargetProfile().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("aggregation")) {
        res.getAggregation().add(parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versioning")) {
        res.setVersioningElement(parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionExampleComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionExampleComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
        res.setLabelElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionConstraintComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionConstraintComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("key")) {
        res.setKeyElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirements")) {
        res.setRequirementsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("human")) {
        res.setHumanElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("xpath")) {
        res.setXpathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseCanonical(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionBindingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionBindingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.setStrengthElement(parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
        res.setValueSetElement(parseCanonical(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionMappingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identity")) {
        res.setIdentityElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("map")) {
        res.setMapElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected void parseDomainResourceAttributes(XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
    parseResourceAttributes(xpp, res);
  }

  protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setText(parseNarrative(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contained")) {
        res.getContained().add(parseResourceContained(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extension")) {
        res.getExtension().add(parseExtension(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) {
        res.getModifierExtension().add(parseExtension(xpp));
    } else
    return parseResourceContent(eventType, xpp, res);
    return true;
  }

  protected Parameters parseParameters(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Parameters res = new Parameters();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseParametersContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParametersContent(int eventType, XmlPullParser xpp, Parameters res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseParametersParametersParameterComponent(xpp, res));
      } else if (!parseResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(XmlPullParser xpp, Parameters owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseParametersParametersParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParametersParametersParameterComponentContent(int eventType, XmlPullParser xpp, Parameters owner, Parameters.ParametersParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseResourceContained(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
        res.getPart().add(parseParametersParametersParameterComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected void parseResourceAttributes(XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!comments.isEmpty()) {
      res.getFormatCommentsPre().addAll(comments);
      comments.clear();
     }
  }

  protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("id")) {
        res.setIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meta")) {
        res.setMeta(parseMeta(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implicitRules")) {
        res.setImplicitRulesElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
    } else
        return false;
    return true;
  }

  protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Account res = new Account();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAccountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountContent(int eventType, XmlPullParser xpp, Account res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.getSubject().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("servicePeriod")) {
        res.setServicePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.getCoverage().add(parseAccountCoverageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
        res.setOwner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("guarantor")) {
        res.getGuarantor().add(parseAccountGuarantorComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.setPartOf(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAccountCoverageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountCoverageComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.CoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parsePositiveInt(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAccountGuarantorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountGuarantorComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.GuarantorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onHold")) {
        res.setOnHoldElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ActivityDefinition parseActivityDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseActivityDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionContent(int eventType, XmlPullParser xpp, ActivityDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
        res.setSubject(parseType("subject", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
        res.getEditor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
        res.getReviewer().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
        res.getEndorser().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
        res.getLibrary().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, ActivityDefinition.RequestIntent.NULL, new ActivityDefinition.RequestIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, ActivityDefinition.RequestPriority.NULL, new ActivityDefinition.RequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
        res.setDoNotPerformElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseActivityDefinitionActivityDefinitionParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
        res.setProduct(parseType("product", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.getDosage().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.getBodySite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimenRequirement")) {
        res.getSpecimenRequirement().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observationRequirement")) {
        res.getObservationRequirement().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observationResultRequirement")) {
        res.getObservationResultRequirement().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("transform")) {
        res.setTransformElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dynamicValue")) {
        res.getDynamicValue().add(parseActivityDefinitionActivityDefinitionDynamicValueComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseActivityDefinitionActivityDefinitionParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionActivityDefinitionParticipantComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpression(parseExpression(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdministrableProductDefinition parseAdministrableProductDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition res = new AdministrableProductDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdministrableProductDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.getSubject().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrableDoseForm")) {
        res.setAdministrableDoseForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitOfPresentation")) {
        res.setUnitOfPresentation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.getDevice().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
        res.getCharacteristic().add(parseAdministrableProductDefinitionAdministrableProductDefinitionCharacteristicComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("routeOfAdministration")) {
        res.getRouteOfAdministration().add(parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent parseAdministrableProductDefinitionAdministrableProductDefinitionCharacteristicComponent(XmlPullParser xpp, AdministrableProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdministrableProductDefinitionAdministrableProductDefinitionCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionAdministrableProductDefinitionCharacteristicComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition owner, AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatus(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationComponent(XmlPullParser xpp, AdministrableProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition owner, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("firstDose")) {
        res.setFirstDose(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxSingleDose")) {
        res.setMaxSingleDose(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerDay")) {
        res.setMaxDosePerDay(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerTreatmentPeriod")) {
        res.setMaxDosePerTreatmentPeriod(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxTreatmentPeriod")) {
        res.setMaxTreatmentPeriod(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetSpecies")) {
        res.getTargetSpecies().add(parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(XmlPullParser xpp, AdministrableProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition owner, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("withdrawalPeriod")) {
        res.getWithdrawalPeriod().add(parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(XmlPullParser xpp, AdministrableProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition owner, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tissue")) {
        res.setTissue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValue(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.setSupportingInformationElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent parseAdverseEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventContent(int eventType, XmlPullParser xpp, AdverseEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, AdverseEvent.AdverseEventStatus.NULL, new AdverseEvent.AdverseEventStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actuality")) {
        res.setActualityElement(parseEnumeration(xpp, AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detected")) {
        res.setDetectedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedDate")) {
        res.setRecordedDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resultingCondition")) {
        res.getResultingCondition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("seriousness")) {
        res.setSeriousness(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseAdverseEventAdverseEventParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suspectEntity")) {
        res.getSuspectEntity().add(parseAdverseEventAdverseEventSuspectEntityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseAdverseEventAdverseEventSupportingInfoComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("study")) {
        res.getStudy().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent.AdverseEventParticipantComponent parseAdverseEventAdverseEventParticipantComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventParticipantComponent res = new AdverseEvent.AdverseEventParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventAdverseEventParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventAdverseEventParticipantComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
        res.setFunction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventAdverseEventSuspectEntityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventAdverseEventSuspectEntityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "instance")) {
        res.setInstance(parseType("instance", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("causality")) {
        res.setCausality(parseAdverseEventAdverseEventSuspectEntityCausalityComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventAdverseEventSuspectEntityCausalityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventAdverseEventSuspectEntityCausalityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventAdverseEventSuspectEntityCausalityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessmentMethod")) {
        res.setAssessmentMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entityRelatedness")) {
        res.setEntityRelatedness(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent.AdverseEventSupportingInfoComponent parseAdverseEventAdverseEventSupportingInfoComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSupportingInfoComponent res = new AdverseEvent.AdverseEventSupportingInfoComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventAdverseEventSupportingInfoComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventAdverseEventSupportingInfoComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSupportingInfoComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.setItem(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributingFactor")) {
        res.setContributingFactorElement(parseBoolean(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAllergyIntoleranceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAllergyIntoleranceContent(int eventType, XmlPullParser xpp, AllergyIntolerance res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalStatus")) {
        res.setClinicalStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationStatus")) {
        res.setVerificationStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criticality")) {
        res.setCriticalityElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
        res.setOnset(parseType("onset", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedDate")) {
        res.setRecordedDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asserter")) {
        res.setAsserter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastOccurrence")) {
        res.setLastOccurrenceElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reaction")) {
        res.getReaction().add(parseAllergyIntoleranceAllergyIntoleranceReactionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(XmlPullParser xpp, AllergyIntolerance owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
        res.setSubstance(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manifestation")) {
        res.getManifestation().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onset")) {
        res.setOnsetElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exposureRoute")) {
        res.setExposureRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAppointmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentContent(int eventType, XmlPullParser xpp, Appointment res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cancelationReason")) {
        res.setCancelationReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceCategory")) {
        res.getServiceCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
        res.getServiceType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentType")) {
        res.setAppointmentType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("minutesDuration")) {
        res.setMinutesDurationElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("slot")) {
        res.getSlot().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientInstruction")) {
        res.setPatientInstructionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseAppointmentAppointmentParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestedPeriod")) {
        res.getRequestedPeriod().add(parsePeriod(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(XmlPullParser xpp, Appointment owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAppointmentAppointmentParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentAppointmentParticipantComponentContent(int eventType, XmlPullParser xpp, Appointment owner, Appointment.AppointmentParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("required")) {
        res.setRequiredElement(parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAppointmentResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentResponseContent(int eventType, XmlPullParser xpp, AppointmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointment")) {
        res.setAppointment(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participantType")) {
        res.getParticipantType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participantStatus")) {
        res.setParticipantStatusElement(parseEnumeration(xpp, AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventContent(int eventType, XmlPullParser xpp, AuditEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtype")) {
        res.getSubtype().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.setActionElement(parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
        res.setRecordedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeDesc")) {
        res.setOutcomeDescElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purposeOfEvent")) {
        res.getPurposeOfEvent().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseAuditEventAuditEventAgentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseAuditEventAuditEventSourceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
        res.getEntity().add(parseAuditEventAuditEventEntityComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventAgentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventAgentComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.getRole().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("who")) {
        res.setWho(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("altId")) {
        res.setAltIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
        res.setRequestorElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
        res.getPolicy().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("media")) {
        res.setMedia(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetwork(parseAuditEventAuditEventAgentNetworkComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purposeOfUse")) {
        res.getPurposeOfUse().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventAgentNetworkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventAgentNetworkComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddressElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventSourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventSourceComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSiteElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observer")) {
        res.setObserver(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCoding(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventEntityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventEntityComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("what")) {
        res.setWhat(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lifecycle")) {
        res.setLifecycle(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("query")) {
        res.setQueryElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseAuditEventAuditEventEntityDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventEntityDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventEntityDetailComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Basic res = new Basic();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBasicContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBasicContent(int eventType, XmlPullParser xpp, Basic res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Binary res = new Binary();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBinaryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBinaryContent(int eventType, XmlPullParser xpp, Binary res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
        res.setContentTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityContext")) {
        res.setSecurityContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setDataElement(parseBase64Binary(xpp));
      } else if (!parseResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBiologicallyDerivedProductContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productCategory")) {
        res.setProductCategoryElement(parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productCode")) {
        res.setProductCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.getRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantityElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.getParent().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collection")) {
        res.setCollection(parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processing")) {
        res.getProcessing().add(parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manipulation")) {
        res.setManipulation(parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("storage")) {
        res.getStorage().add(parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collector")) {
        res.setCollector(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "collected")) {
        res.setCollected(parseType("collected", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.setProcedure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additive")) {
        res.setAdditive(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "time")) {
        res.setTime(parseType("time", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "time")) {
        res.setTime(parseType("time", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("temperature")) {
        res.setTemperatureElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scale")) {
        res.setScaleElement(parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDuration(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BodyStructure parseBodyStructure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBodyStructureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBodyStructureContent(int eventType, XmlPullParser xpp, BodyStructure res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("morphology")) {
        res.setMorphology(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("locationQualifier")) {
        res.getLocationQualifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
        res.getImage().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleContent(int eventType, XmlPullParser xpp, Bundle res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timestamp")) {
        res.setTimestampElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.setTotalElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseBundleBundleLinkComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
        res.getEntry().add(parseBundleBundleEntryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
        res.setSignature(parseSignature(xpp));
      } else if (!parseResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleLinkComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relation")) {
        res.setRelationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntryComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseBundleBundleLinkComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fullUrl")) {
        res.setFullUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseResourceContained(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("search")) {
        res.setSearch(parseBundleBundleEntrySearchComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseBundleBundleEntryRequestComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseBundleBundleEntryResponseComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntrySearchComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntrySearchComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntrySearchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.setScoreElement(parseDecimal(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntryRequestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntryRequestComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethodElement(parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifNoneMatch")) {
        res.setIfNoneMatchElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifModifiedSince")) {
        res.setIfModifiedSinceElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifMatch")) {
        res.setIfMatchElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifNoneExist")) {
        res.setIfNoneExistElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntryResponseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntryResponseComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocationElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("etag")) {
        res.setEtagElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastModified")) {
        res.setLastModifiedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseResourceContained(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement parseCapabilityStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementContent(int eventType, XmlPullParser xpp, CapabilityStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
        res.getInstantiates().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imports")) {
        res.getImports().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
        res.setSoftware(parseCapabilityStatementCapabilityStatementSoftwareComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementation")) {
        res.setImplementation(parseCapabilityStatementCapabilityStatementImplementationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.setFhirVersionElement(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
        res.getFormat().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patchFormat")) {
        res.getPatchFormat().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementationGuide")) {
        res.getImplementationGuide().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rest")) {
        res.getRest().add(parseCapabilityStatementCapabilityStatementRestComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("messaging")) {
        res.getMessaging().add(parseCapabilityStatementCapabilityStatementMessagingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("document")) {
        res.getDocument().add(parseCapabilityStatementCapabilityStatementDocumentComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementSoftwareComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementSoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("releaseDate")) {
        res.setReleaseDateElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementImplementationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
        res.setCustodian(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("security")) {
        res.setSecurity(parseCapabilityStatementCapabilityStatementRestSecurityComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseCapabilityStatementCapabilityStatementRestResourceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
        res.getCompartment().add(parseCanonical(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cors")) {
        res.setCorsElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.getService().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportedProfile")) {
        res.getSupportedProfile().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versioning")) {
        res.setVersioningElement(parseEnumeration(xpp, CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readHistory")) {
        res.setReadHistoryElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("updateCreate")) {
        res.setUpdateCreateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalCreate")) {
        res.setConditionalCreateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalRead")) {
        res.setConditionalReadElement(parseEnumeration(xpp, CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalUpdate")) {
        res.setConditionalUpdateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalDelete")) {
        res.setConditionalDeleteElement(parseEnumeration(xpp, CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencePolicy")) {
        res.getReferencePolicy().add(parseEnumeration(xpp, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchInclude")) {
        res.getSearchInclude().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchRevInclude")) {
        res.getSearchRevInclude().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementResourceInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestResourceOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestResourceOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementSystemInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementSystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reliableCache")) {
        res.setReliableCacheElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportedMessage")) {
        res.getSupportedMessage().add(parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
        res.setProtocol(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddressElement(parseUrl(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseCanonical(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementDocumentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementDocumentComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2 parseCapabilityStatement2(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2 res = new CapabilityStatement2();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2Content(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2Content(int eventType, XmlPullParser xpp, CapabilityStatement2 res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, CapabilityStatement2.CapabilityStatement2Kind.NULL, new CapabilityStatement2.CapabilityStatement2KindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
        res.getInstantiates().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imports")) {
        res.getImports().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
        res.setSoftware(parseCapabilityStatement2CapabilityStatement2SoftwareComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementation")) {
        res.setImplementation(parseCapabilityStatement2CapabilityStatement2ImplementationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.setFhirVersionElement(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
        res.getFormat().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patchFormat")) {
        res.getPatchFormat().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementationGuide")) {
        res.getImplementationGuide().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rest")) {
        res.getRest().add(parseCapabilityStatement2CapabilityStatement2RestComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.CapabilityStatement2SoftwareComponent parseCapabilityStatement2CapabilityStatement2SoftwareComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2SoftwareComponent res = new CapabilityStatement2.CapabilityStatement2SoftwareComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2CapabilityStatement2SoftwareComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2CapabilityStatement2SoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.CapabilityStatement2SoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("releaseDate")) {
        res.setReleaseDateElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.CapabilityStatement2ImplementationComponent parseCapabilityStatement2CapabilityStatement2ImplementationComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2ImplementationComponent res = new CapabilityStatement2.CapabilityStatement2ImplementationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2CapabilityStatement2ImplementationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2CapabilityStatement2ImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.CapabilityStatement2ImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
        res.setCustodian(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.CapabilityStatement2RestComponent parseCapabilityStatement2CapabilityStatement2RestComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestComponent res = new CapabilityStatement2.CapabilityStatement2RestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2CapabilityStatement2RestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2CapabilityStatement2RestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.CapabilityStatement2RestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement2.RestfulCapabilityMode.NULL, new CapabilityStatement2.RestfulCapabilityModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseCapabilityStatement2CapabilityStatement2RestResourceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.getInteraction().add(parseCapabilityStatement2SystemInteractionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.getSearchParam().add(parseCapabilityStatement2CapabilityStatement2RestResourceSearchParamComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.getOperation().add(parseCapabilityStatement2CapabilityStatement2RestResourceOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
        res.getCompartment().add(parseCanonical(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.CapabilityStatement2RestResourceComponent parseCapabilityStatement2CapabilityStatement2RestResourceComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestResourceComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2CapabilityStatement2RestResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2CapabilityStatement2RestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.CapabilityStatement2RestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportedProfile")) {
        res.getSupportedProfile().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.getInteraction().add(parseCapabilityStatement2ResourceInteractionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.getSearchParam().add(parseCapabilityStatement2CapabilityStatement2RestResourceSearchParamComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.getOperation().add(parseCapabilityStatement2CapabilityStatement2RestResourceOperationComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.ResourceInteractionComponent parseCapabilityStatement2ResourceInteractionComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.ResourceInteractionComponent res = new CapabilityStatement2.ResourceInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2ResourceInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2ResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CapabilityStatement2.TypeRestfulInteraction.NULL, new CapabilityStatement2.TypeRestfulInteractionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent parseCapabilityStatement2CapabilityStatement2RestResourceSearchParamComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2CapabilityStatement2RestResourceSearchParamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2CapabilityStatement2RestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent parseCapabilityStatement2CapabilityStatement2RestResourceOperationComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2CapabilityStatement2RestResourceOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2CapabilityStatement2RestResourceOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement2.SystemInteractionComponent parseCapabilityStatement2SystemInteractionComponent(XmlPullParser xpp, CapabilityStatement2 owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement2.SystemInteractionComponent res = new CapabilityStatement2.SystemInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatement2SystemInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatement2SystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement2 owner, CapabilityStatement2.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CapabilityStatement2.SystemRestfulInteraction.NULL, new CapabilityStatement2.SystemRestfulInteractionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCarePlanContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanContent(int eventType, XmlPullParser xpp, CarePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
        res.getCareTeam().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addressesCode")) {
        res.getAddressesCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addressesReference")) {
        res.getAddressesReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
        res.getGoal().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activity")) {
        res.getActivity().add(parseCarePlanCarePlanActivityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCarePlanCarePlanActivityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanCarePlanActivityComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeCodeableConcept")) {
        res.getOutcomeCodeableConcept().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeReference")) {
        res.getOutcomeReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("progress")) {
        res.getProgress().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetail(parseCarePlanCarePlanActivityDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCarePlanCarePlanActivityDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanCarePlanActivityDetailComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
        res.getGoal().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
        res.setDoNotPerformElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "scheduled")) {
        res.setScheduled(parseType("scheduled", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "reported")) {
        res.setReported(parseType("reported", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
        res.setProduct(parseType("product", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dailyAmount")) {
        res.setDailyAmount(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCareTeamContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCareTeamContent(int eventType, XmlPullParser xpp, CareTeam res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseCareTeamCareTeamParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.getManagingOrganization().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(XmlPullParser xpp, CareTeam owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCareTeamCareTeamParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCareTeamCareTeamParticipantComponentContent(int eventType, XmlPullParser xpp, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("member")) {
        res.setMember(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "coverage")) {
        res.setCoverage(parseType("coverage", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CatalogEntry parseCatalogEntry(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CatalogEntry res = new CatalogEntry();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCatalogEntryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCatalogEntryContent(int eventType, XmlPullParser xpp, CatalogEntry res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, CatalogEntry.CatalogEntryType.NULL, new CatalogEntry.CatalogEntryTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CatalogEntry.CatalogEntryStatus.NULL, new CatalogEntry.CatalogEntryStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderable")) {
        res.setOrderableElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencedItem")) {
        res.setReferencedItem(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedEntry")) {
        res.getRelatedEntry().add(parseCatalogEntryCatalogEntryRelatedEntryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("updatedBy")) {
        res.setUpdatedBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("estimatedDuration")) {
        res.setEstimatedDuration(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billingCode")) {
        res.getBillingCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billingSummary")) {
        res.setBillingSummaryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scheduleSummary")) {
        res.setScheduleSummaryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("limitationSummary")) {
        res.setLimitationSummaryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("regulatorySummary")) {
        res.setRegulatorySummaryElement(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryCatalogEntryRelatedEntryComponent(XmlPullParser xpp, CatalogEntry owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCatalogEntryCatalogEntryRelatedEntryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCatalogEntryCatalogEntryRelatedEntryComponentContent(int eventType, XmlPullParser xpp, CatalogEntry owner, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationshipElement(parseEnumeration(xpp, CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItem parseChargeItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemContent(int eventType, XmlPullParser xpp, ChargeItem res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definitionUri")) {
        res.getDefinitionUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definitionCanonical")) {
        res.getDefinitionCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseChargeItemChargeItemPerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performingOrganization")) {
        res.setPerformingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestingOrganization")) {
        res.setRequestingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("costCenter")) {
        res.setCostCenter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodysite")) {
        res.getBodysite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factorOverride")) {
        res.setFactorOverrideElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceOverride")) {
        res.setPriceOverride(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("overrideReason")) {
        res.setOverrideReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enteredDate")) {
        res.setEnteredDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.getService().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
        res.setProduct(parseType("product", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.getAccount().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItem.ChargeItemPerformerComponent parseChargeItemChargeItemPerformerComponent(XmlPullParser xpp, ChargeItem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemChargeItemPerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemChargeItemPerformerComponentContent(int eventType, XmlPullParser xpp, ChargeItem owner, ChargeItem.ChargeItemPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
        res.setFunction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItemDefinition parseChargeItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition res = new ChargeItemDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionContent(int eventType, XmlPullParser xpp, ChargeItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFromUri")) {
        res.getDerivedFromUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applicability")) {
        res.getApplicability().add(parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("propertyGroup")) {
        res.getPropertyGroup().add(parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(XmlPullParser xpp, ChargeItemDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(XmlPullParser xpp, ChargeItemDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applicability")) {
        res.getApplicability().add(parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceComponent")) {
        res.getPriceComponent().add(parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(XmlPullParser xpp, ChargeItemDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.NULL, new ChargeItemDefinition.ChargeItemDefinitionPriceComponentTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim res = new Claim();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimContent(int eventType, XmlPullParser xpp, Claim res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.setSubType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, Claim.Use.NULL, new Claim.UseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billablePeriod")) {
        res.setBillablePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
        res.setFundsReserve(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseClaimRelatedClaimComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prescription")) {
        res.setPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("originalPrescription")) {
        res.setOriginalPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
        res.setPayee(parseClaimPayeeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referral")) {
        res.setReferral(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
        res.getCareTeam().add(parseClaimCareTeamComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseClaimSupportingInformationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.getProcedure().add(parseClaimProcedureComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseClaimInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accident")) {
        res.setAccident(parseClaimAccidentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseClaimItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.setTotal(parseMoney(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimRelatedClaimComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimRelatedClaimComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
        res.setClaim(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseIdentifier(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimPayeeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimPayeeComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimCareTeamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimCareTeamComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsibleElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
        res.setQualification(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimSupportingInformationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimSupportingInformationComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimDiagnosisComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
        res.setDiagnosis(parseType("diagnosis", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onAdmission")) {
        res.setOnAdmission(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageCode")) {
        res.setPackageCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimProcedureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimProcedureComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "procedure")) {
        res.setProcedure(parseType("procedure", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimInsuranceComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
        res.setFocalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
        res.setBusinessArrangementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.getPreAuthRef().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
        res.setClaimResponse(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimAccidentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimAccidentComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.ItemComponent parseClaimItemComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimItemComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeamSequence")) {
        res.getCareTeamSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosisSequence")) {
        res.getDiagnosisSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureSequence")) {
        res.getProcedureSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSequence")) {
        res.getInformationSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
        res.getSubSite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.getEncounter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseClaimDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseClaimSubDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimSubDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseContent(int eventType, XmlPullParser xpp, ClaimResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.setSubType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, ClaimResponse.Use.NULL, new ClaimResponse.UseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
        res.setRequestor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, ClaimResponse.RemittanceOutcome.NULL, new ClaimResponse.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.setPreAuthRefElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthPeriod")) {
        res.setPreAuthPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payeeType")) {
        res.setPayeeType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseClaimResponseItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addItem")) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.getTotal().add(parseClaimResponseTotalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
        res.setPayment(parseClaimResponsePaymentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
        res.setFundsReserve(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("formCode")) {
        res.setFormCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communicationRequest")) {
        res.getCommunicationRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
        res.getError().add(parseClaimResponseErrorComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
        res.setItemSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseAdjudicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAdjudicationComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseItemDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
        res.setDetailSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetailSequence")) {
        res.setSubDetailSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseAddedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
        res.getItemSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
        res.getDetailSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subdetailSequence")) {
        res.getSubdetailSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.getProvider().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
        res.getSubSite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseClaimResponseAddedItemDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseAddedItemDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseClaimResponseAddedItemSubDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseAddedItemSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseTotalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseTotalComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponsePaymentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponsePaymentComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustment")) {
        res.setAdjustment(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustmentReason")) {
        res.setAdjustmentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseNoteComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseNoteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguage(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
        res.setFocalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
        res.setBusinessArrangementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
        res.setClaimResponse(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseErrorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseErrorComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
        res.setItemSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
        res.setDetailSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetailSequence")) {
        res.setSubDetailSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalImpressionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionContent(int eventType, XmlPullParser xpp, ClinicalImpression res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("previous")) {
        res.setPrevious(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("problem")) {
        res.getProblem().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
        res.getProtocol().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
        res.setSummaryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("finding")) {
        res.getFinding().add(parseClinicalImpressionClinicalImpressionFindingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prognosisCodeableConcept")) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prognosisReference")) {
        res.getPrognosisReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalImpressionClinicalImpressionFindingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionClinicalImpressionFindingComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemCodeableConcept")) {
        res.setItemCodeableConcept(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemReference")) {
        res.setItemReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basis")) {
        res.setBasisElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue parseClinicalUseIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue res = new ClinicalUseIssue();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueContent(int eventType, XmlPullParser xpp, ClinicalUseIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ClinicalUseIssue.ClinicalUseIssueType.NULL, new ClinicalUseIssue.ClinicalUseIssueTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.getSubject().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contraindication")) {
        res.setContraindication(parseClinicalUseIssueClinicalUseIssueContraindicationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
        res.setIndication(parseClinicalUseIssueClinicalUseIssueIndicationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.setInteraction(parseClinicalUseIssueClinicalUseIssueInteractionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parsePopulation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("undesirableEffect")) {
        res.setUndesirableEffect(parseClinicalUseIssueClinicalUseIssueUndesirableEffectComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue.ClinicalUseIssueContraindicationComponent parseClinicalUseIssueClinicalUseIssueContraindicationComponent(XmlPullParser xpp, ClinicalUseIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueContraindicationComponent res = new ClinicalUseIssue.ClinicalUseIssueContraindicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueClinicalUseIssueContraindicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueClinicalUseIssueContraindicationComponentContent(int eventType, XmlPullParser xpp, ClinicalUseIssue owner, ClinicalUseIssue.ClinicalUseIssueContraindicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseSymptomProcedure")) {
        res.setDiseaseSymptomProcedure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseStatus")) {
        res.setDiseaseStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comorbidity")) {
        res.getComorbidity().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
        res.getIndication().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("otherTherapy")) {
        res.getOtherTherapy().add(parseClinicalUseIssueClinicalUseIssueContraindicationOtherTherapyComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent parseClinicalUseIssueClinicalUseIssueContraindicationOtherTherapyComponent(XmlPullParser xpp, ClinicalUseIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent res = new ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueClinicalUseIssueContraindicationOtherTherapyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueClinicalUseIssueContraindicationOtherTherapyComponentContent(int eventType, XmlPullParser xpp, ClinicalUseIssue owner, ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("therapyRelationshipType")) {
        res.setTherapyRelationshipType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue.ClinicalUseIssueIndicationComponent parseClinicalUseIssueClinicalUseIssueIndicationComponent(XmlPullParser xpp, ClinicalUseIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueIndicationComponent res = new ClinicalUseIssue.ClinicalUseIssueIndicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueClinicalUseIssueIndicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueClinicalUseIssueIndicationComponentContent(int eventType, XmlPullParser xpp, ClinicalUseIssue owner, ClinicalUseIssue.ClinicalUseIssueIndicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseSymptomProcedure")) {
        res.setDiseaseSymptomProcedure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseStatus")) {
        res.setDiseaseStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comorbidity")) {
        res.getComorbidity().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedEffect")) {
        res.setIntendedEffect(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDuration(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("undesirableEffect")) {
        res.getUndesirableEffect().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("otherTherapy")) {
        res.getOtherTherapy().add(parseClinicalUseIssueClinicalUseIssueContraindicationOtherTherapyComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue.ClinicalUseIssueInteractionComponent parseClinicalUseIssueClinicalUseIssueInteractionComponent(XmlPullParser xpp, ClinicalUseIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueInteractionComponent res = new ClinicalUseIssue.ClinicalUseIssueInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueClinicalUseIssueInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueClinicalUseIssueInteractionComponentContent(int eventType, XmlPullParser xpp, ClinicalUseIssue owner, ClinicalUseIssue.ClinicalUseIssueInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interactant")) {
        res.getInteractant().add(parseClinicalUseIssueClinicalUseIssueInteractionInteractantComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effect")) {
        res.setEffect(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("incidence")) {
        res.setIncidence(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("management")) {
        res.setManagement(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent parseClinicalUseIssueClinicalUseIssueInteractionInteractantComponent(XmlPullParser xpp, ClinicalUseIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent res = new ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueClinicalUseIssueInteractionInteractantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueClinicalUseIssueInteractionInteractantComponentContent(int eventType, XmlPullParser xpp, ClinicalUseIssue owner, ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent parseClinicalUseIssueClinicalUseIssueUndesirableEffectComponent(XmlPullParser xpp, ClinicalUseIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent res = new ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalUseIssueClinicalUseIssueUndesirableEffectComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseIssueClinicalUseIssueUndesirableEffectComponentContent(int eventType, XmlPullParser xpp, ClinicalUseIssue owner, ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("symptomConditionEffect")) {
        res.setSymptomConditionEffect(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
        res.setClassification(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequencyOfOccurrence")) {
        res.setFrequencyOfOccurrence(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemContent(int eventType, XmlPullParser xpp, CodeSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("caseSensitive")) {
        res.setCaseSensitiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
        res.setValueSetElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hierarchyMeaning")) {
        res.setHierarchyMeaningElement(parseEnumeration(xpp, CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compositional")) {
        res.setCompositionalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionNeeded")) {
        res.setVersionNeededElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.setContentElement(parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplements")) {
        res.setSupplementsElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("filter")) {
        res.getFilter().add(parseCodeSystemCodeSystemFilterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseCodeSystemPropertyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemCodeSystemFilterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemCodeSystemFilterComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operator")) {
        res.getOperator().add(parseEnumeration(xpp, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemPropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.PropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemConceptDefinitionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptDefinitionComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("designation")) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemConceptDefinitionDesignationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptDefinitionDesignationComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUse(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemConceptPropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Communication res = new Communication();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationContent(int eventType, XmlPullParser xpp, Communication res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inResponseTo")) {
        res.getInResponseTo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, Communication.CommunicationPriority.NULL, new Communication.CommunicationPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medium")) {
        res.getMedium().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.setTopic(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("about")) {
        res.getAbout().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sent")) {
        res.setSentElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("received")) {
        res.setReceivedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
        res.setSender(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
        res.getPayload().add(parseCommunicationCommunicationPayloadComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(XmlPullParser xpp, Communication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationCommunicationPayloadComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationCommunicationPayloadComponentContent(int eventType, XmlPullParser xpp, Communication owner, Communication.CommunicationPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestContent(int eventType, XmlPullParser xpp, CommunicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
        res.setDoNotPerformElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medium")) {
        res.getMedium().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("about")) {
        res.getAbout().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
        res.getPayload().add(parseCommunicationRequestCommunicationRequestPayloadComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationProvider")) {
        res.getInformationProvider().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationRequestCommunicationRequestPayloadComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestCommunicationRequestPayloadComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompartmentDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompartmentDefinitionContent(int eventType, XmlPullParser xpp, CompartmentDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("search")) {
        res.setSearchElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseCompartmentDefinitionCompartmentDefinitionResourceComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(XmlPullParser xpp, CompartmentDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("param")) {
        res.getParam().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition res = new Composition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionContent(int eventType, XmlPullParser xpp, Composition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("confidentiality")) {
        res.setConfidentialityElement(parseEnumeration(xpp, Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attester")) {
        res.getAttester().add(parseCompositionCompositionAttesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
        res.setCustodian(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
        res.getRelatesTo().add(parseCompositionCompositionRelatesToComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseCompositionCompositionEventComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
        res.getSection().add(parseCompositionSectionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionCompositionAttesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionCompositionAttesterComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
        res.setTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionCompositionRelatesToComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionCompositionRelatesToComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
        res.setTarget(parseType("target", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionCompositionEventComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionCompositionEventComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionSectionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionSectionComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.setFocus(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setText(parseNarrative(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
        res.setOrderedBy(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
        res.getEntry().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
        res.setEmptyReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
        res.getSection().add(parseCompositionSectionComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapContent(int eventType, XmlPullParser xpp, ConceptMap res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "source")) {
        res.setSource(parseType("source", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
        res.setTarget(parseType("target", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseConceptMapConceptMapGroupComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapConceptMapGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapConceptMapGroupComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceVersion")) {
        res.setSourceVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTargetElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetVersion")) {
        res.setTargetVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
        res.getElement().add(parseConceptMapSourceElementComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unmapped")) {
        res.setUnmapped(parseConceptMapConceptMapGroupUnmappedComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapSourceElementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapSourceElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.SourceElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noMap")) {
        res.setNoMapElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseConceptMapTargetElementComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapTargetElementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapTargetElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.TargetElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationshipElement(parseEnumeration(xpp, Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependsOn")) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("product")) {
        res.getProduct().add(parseConceptMapOtherElementComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapOtherElementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapOtherElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.OtherElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.setPropertyElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapConceptMapGroupUnmappedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapConceptMapGroupUnmappedComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseCanonical(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition res = new Condition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionContent(int eventType, XmlPullParser xpp, Condition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalStatus")) {
        res.setClinicalStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationStatus")) {
        res.setVerificationStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverity(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.getBodySite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
        res.setOnset(parseType("onset", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "abatement")) {
        res.setAbatement(parseType("abatement", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedDate")) {
        res.setRecordedDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asserter")) {
        res.setAsserter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stage")) {
        res.getStage().add(parseConditionConditionStageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evidence")) {
        res.getEvidence().add(parseConditionConditionEvidenceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionConditionStageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionConditionStageComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionStageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
        res.setSummary(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessment")) {
        res.getAssessment().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionConditionEvidenceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionConditionEvidenceComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConditionDefinition parseConditionDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConditionDefinition res = new ConditionDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionDefinitionContent(int eventType, XmlPullParser xpp, ConditionDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverity(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stage")) {
        res.setStage(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hasSeverity")) {
        res.setHasSeverityElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hasBodySite")) {
        res.setHasBodySiteElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hasStage")) {
        res.setHasStageElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observation")) {
        res.getObservation().add(parseConditionDefinitionConditionDefinitionObservationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medication")) {
        res.getMedication().add(parseConditionDefinitionConditionDefinitionMedicationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precondition")) {
        res.getPrecondition().add(parseConditionDefinitionConditionDefinitionPreconditionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("team")) {
        res.getTeam().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("questionnaire")) {
        res.getQuestionnaire().add(parseConditionDefinitionConditionDefinitionQuestionnaireComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("plan")) {
        res.getPlan().add(parseConditionDefinitionConditionDefinitionPlanComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConditionDefinition.ConditionDefinitionObservationComponent parseConditionDefinitionConditionDefinitionObservationComponent(XmlPullParser xpp, ConditionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionObservationComponent res = new ConditionDefinition.ConditionDefinitionObservationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionDefinitionConditionDefinitionObservationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionDefinitionConditionDefinitionObservationComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition owner, ConditionDefinition.ConditionDefinitionObservationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConditionDefinition.ConditionDefinitionMedicationComponent parseConditionDefinitionConditionDefinitionMedicationComponent(XmlPullParser xpp, ConditionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionMedicationComponent res = new ConditionDefinition.ConditionDefinitionMedicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionDefinitionConditionDefinitionMedicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionDefinitionConditionDefinitionMedicationComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition owner, ConditionDefinition.ConditionDefinitionMedicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConditionDefinition.ConditionDefinitionPreconditionComponent parseConditionDefinitionConditionDefinitionPreconditionComponent(XmlPullParser xpp, ConditionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionPreconditionComponent res = new ConditionDefinition.ConditionDefinitionPreconditionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionDefinitionConditionDefinitionPreconditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionDefinitionConditionDefinitionPreconditionComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition owner, ConditionDefinition.ConditionDefinitionPreconditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ConditionDefinition.ConditionPreconditionType.NULL, new ConditionDefinition.ConditionPreconditionTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConditionDefinition.ConditionDefinitionQuestionnaireComponent parseConditionDefinitionConditionDefinitionQuestionnaireComponent(XmlPullParser xpp, ConditionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionQuestionnaireComponent res = new ConditionDefinition.ConditionDefinitionQuestionnaireComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionDefinitionConditionDefinitionQuestionnaireComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionDefinitionConditionDefinitionQuestionnaireComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition owner, ConditionDefinition.ConditionDefinitionQuestionnaireComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseEnumeration(xpp, ConditionDefinition.ConditionQuestionnairePurpose.NULL, new ConditionDefinition.ConditionQuestionnairePurposeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConditionDefinition.ConditionDefinitionPlanComponent parseConditionDefinitionConditionDefinitionPlanComponent(XmlPullParser xpp, ConditionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionPlanComponent res = new ConditionDefinition.ConditionDefinitionPlanComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionDefinitionConditionDefinitionPlanComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionDefinitionConditionDefinitionPlanComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition owner, ConditionDefinition.ConditionDefinitionPlanComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent parseConsent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent res = new Consent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentContent(int eventType, XmlPullParser xpp, Consent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
        res.setScope(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateTime")) {
        res.setDateTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.getOrganization().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceAttachment")) {
        res.getSourceAttachment().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceReference")) {
        res.getSourceReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
        res.getPolicy().add(parseConsentConsentPolicyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policyRule")) {
        res.setPolicyRule(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verification")) {
        res.getVerification().add(parseConsentConsentVerificationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provision")) {
        res.setProvision(parseConsentprovisionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentConsentPolicyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentConsentPolicyComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentPolicyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthorityElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.ConsentVerificationComponent parseConsentConsentVerificationComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentConsentVerificationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentConsentVerificationComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentVerificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verified")) {
        res.setVerifiedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verifiedWith")) {
        res.setVerifiedWith(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationDate")) {
        res.setVerificationDateElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.provisionComponent parseConsentprovisionComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.provisionComponent res = new Consent.provisionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentprovisionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentprovisionComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.getActor().add(parseConsentprovisionActorComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.getPurpose().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.getClass_().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataPeriod")) {
        res.setDataPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.getData().add(parseConsentprovisionDataComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provision")) {
        res.getProvision().add(parseConsentprovisionComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.provisionActorComponent parseConsentprovisionActorComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.provisionActorComponent res = new Consent.provisionActorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentprovisionActorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentprovisionActorComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.provisionDataComponent parseConsentprovisionDataComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.provisionDataComponent res = new Consent.provisionDataComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentprovisionDataComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentprovisionDataComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaning")) {
        res.setMeaningElement(parseEnumeration(xpp, Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract res = new Contract();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContent(int eventType, XmlPullParser xpp, Contract res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legalState")) {
        res.setLegalState(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.setInstantiatesCanonical(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.setInstantiatesUriElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentDerivative")) {
        res.setContentDerivative(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applies")) {
        res.setApplies(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationType")) {
        res.setExpirationType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.getSubject().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.getAuthority().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("domain")) {
        res.getDomain().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.getSite().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
        res.setScope(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "topic")) {
        res.setTopic(parseType("topic", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.getSubType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentDefinition")) {
        res.setContentDefinition(parseContractContentDefinitionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
        res.getTerm().add(parseContractTermComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
        res.getRelevantHistory().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signer")) {
        res.getSigner().add(parseContractSignatoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("friendly")) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legal")) {
        res.getLegal().add(parseContractLegalLanguageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.getRule().add(parseContractComputableLanguageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "legallyBinding")) {
        res.setLegallyBinding(parseType("legallyBinding", xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContentDefinitionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContentDefinitionComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContentDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.setSubType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisher(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationDate")) {
        res.setPublicationDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationStatus")) {
        res.setPublicationStatusElement(parseEnumeration(xpp, Contract.ContractPublicationStatus.NULL, new Contract.ContractPublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractTermComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractTermComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.TermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applies")) {
        res.setApplies(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "topic")) {
        res.setTopic(parseType("topic", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.setSubType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseContractSecurityLabelComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("offer")) {
        res.setOffer(parseContractContractOfferComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asset")) {
        res.getAsset().add(parseContractContractAssetComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseContractActionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseContractTermComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractSecurityLabelComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractSecurityLabelComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.SecurityLabelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.getNumber().add(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
        res.setClassification(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("control")) {
        res.getControl().add(parseCoding(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ContractOfferComponent parseContractContractOfferComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContractOfferComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContractOfferComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractOfferComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.getParty().add(parseContractContractPartyComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.setTopic(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("decision")) {
        res.setDecision(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("decisionMode")) {
        res.getDecisionMode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("answer")) {
        res.getAnswer().add(parseContractAnswerComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.getLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ContractPartyComponent parseContractContractPartyComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContractPartyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContractPartyComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractPartyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.getReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.AnswerComponent parseContractAnswerComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.AnswerComponent res = new Contract.AnswerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractAnswerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAnswerComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AnswerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ContractAssetComponent parseContractContractAssetComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContractAssetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContractAssetComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractAssetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
        res.setScope(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("typeReference")) {
        res.getTypeReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtype")) {
        res.getSubtype().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.getContext().add(parseContractAssetContextComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setConditionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodType")) {
        res.getPeriodType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.getPeriod().add(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usePeriod")) {
        res.getUsePeriod().add(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.getLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("answer")) {
        res.getAnswer().add(parseContractAnswerComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valuedItem")) {
        res.getValuedItem().add(parseContractValuedItemComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.AssetContextComponent parseContractAssetContextComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.AssetContextComponent res = new Contract.AssetContextComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractAssetContextComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAssetContextComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AssetContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractValuedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "entity")) {
        res.setEntity(parseType("entity", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectiveTime")) {
        res.setEffectiveTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("points")) {
        res.setPointsElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
        res.setPaymentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("paymentDate")) {
        res.setPaymentDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsible(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.setRecipient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.getLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ActionComponent parseContractActionComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ActionComponent res = new Contract.ActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractActionComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
        res.setDoNotPerformElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.getSubject().add(parseContractActionSubjectComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntent(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.getLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contextLinkId")) {
        res.getContextLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.getRequester().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requesterLinkId")) {
        res.getRequesterLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
        res.getPerformerType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerRole")) {
        res.setPerformerRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerLinkId")) {
        res.getPerformerLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonLinkId")) {
        res.getReasonLinkId().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractActionSubjectComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractActionSubjectComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ActionSubjectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.getReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractSignatoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractSignatoryComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.SignatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
        res.getSignature().add(parseSignature(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractFriendlyLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractFriendlyLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.FriendlyLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractLegalLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractLegalLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.LegalLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractComputableLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractComputableLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ComputableLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageContent(int eventType, XmlPullParser xpp, Coverage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policyHolder")) {
        res.setPolicyHolder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subscriber")) {
        res.setSubscriber(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subscriberId")) {
        res.setSubscriberId(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("beneficiary")) {
        res.setBeneficiary(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependent")) {
        res.setDependentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payor")) {
        res.getPayor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.getClass_().add(parseCoverageClassComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("order")) {
        res.setOrderElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetworkElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("costToBeneficiary")) {
        res.getCostToBeneficiary().add(parseCoverageCostToBeneficiaryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subrogation")) {
        res.setSubrogationElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contract")) {
        res.getContract().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coverage.ClassComponent parseCoverageClassComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.ClassComponent res = new Coverage.ClassComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageClassComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageClassComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.ClassComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageCostToBeneficiaryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageCostToBeneficiaryComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.CostToBeneficiaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exception")) {
        res.getException().add(parseCoverageExemptionComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coverage.ExemptionComponent parseCoverageExemptionComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageExemptionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageExemptionComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.ExemptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityRequest parseCoverageEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest res = new CoverageEligibilityRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CoverageEligibilityRequest.EligibilityRequestStatus.NULL, new CoverageEligibilityRequest.EligibilityRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.getPurpose().add(parseEnumeration(xpp, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseCoverageEligibilityRequestSupportingInformationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseCoverageEligibilityRequestInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseCoverageEligibilityRequestDetailsComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityRequestSupportingInformationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestSupportingInformationComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("information")) {
        res.setInformation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appliesToAll")) {
        res.setAppliesToAllElement(parseBoolean(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityRequestInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
        res.setFocalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
        res.setBusinessArrangementElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityRequestDetailsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestDetailsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfoSequence")) {
        res.getSupportingInfoSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseCoverageEligibilityRequestDiagnosisComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityRequestDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestDiagnosisComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
        res.setDiagnosis(parseType("diagnosis", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityResponse parseCoverageEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse res = new CoverageEligibilityResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityResponseStatus.NULL, new CoverageEligibilityResponse.EligibilityResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.getPurpose().add(parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
        res.setRequestor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseCoverageEligibilityResponseInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.setPreAuthRefElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
        res.getError().add(parseCoverageEligibilityResponseErrorsComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityResponseInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inforce")) {
        res.setInforceElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitPeriod")) {
        res.setBenefitPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseCoverageEligibilityResponseItemsComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityResponseItemsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseItemsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excluded")) {
        res.setExcludedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetwork(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnit(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
        res.setTerm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefit")) {
        res.getBenefit().add(parseCoverageEligibilityResponseBenefitComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizationRequired")) {
        res.setAuthorizationRequiredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizationSupporting")) {
        res.getAuthorizationSupporting().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizationUrl")) {
        res.setAuthorizationUrlElement(parseUri(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityResponseBenefitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseBenefitComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
        res.setAllowed(parseType("allowed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "used")) {
        res.setUsed(parseType("used", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageEligibilityResponseErrorsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseErrorsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ErrorsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDetectedIssueContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueContent(int eventType, XmlPullParser xpp, DetectedIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "identified")) {
        res.setIdentified(parseType("identified", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implicated")) {
        res.getImplicated().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evidence")) {
        res.getEvidence().add(parseDetectedIssueDetectedIssueEvidenceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetailElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mitigation")) {
        res.getMitigation().add(parseDetectedIssueDetectedIssueMitigationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueDetectedIssueEvidenceComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDetectedIssueDetectedIssueEvidenceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueDetectedIssueEvidenceComponentContent(int eventType, XmlPullParser xpp, DetectedIssue owner, DetectedIssue.DetectedIssueEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDetectedIssueDetectedIssueMitigationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueDetectedIssueMitigationComponentContent(int eventType, XmlPullParser xpp, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.setAction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device res = new Device();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceContent(int eventType, XmlPullParser xpp, Device res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udiCarrier")) {
        res.getUdiCarrier().add(parseDeviceDeviceUdiCarrierComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.getStatusReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("distinctIdentifier")) {
        res.setDistinctIdentifierElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturerElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufactureDate")) {
        res.setManufactureDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
        res.setExpirationDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
        res.setLotNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serialNumber")) {
        res.setSerialNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceName")) {
        res.getDeviceName().add(parseDeviceDeviceDeviceNameComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modelNumber")) {
        res.setModelNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partNumber")) {
        res.setPartNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialization")) {
        res.getSpecialization().add(parseDeviceDeviceSpecializationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.getVersion().add(parseDeviceDeviceVersionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseDeviceDevicePropertyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
        res.setOwner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("safety")) {
        res.getSafety().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.setParent(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device.DeviceUdiCarrierComponent parseDeviceDeviceUdiCarrierComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDeviceUdiCarrierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDeviceUdiCarrierComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceUdiCarrierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceIdentifier")) {
        res.setDeviceIdentifierElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
        res.setIssuerElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.setJurisdictionElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("carrierAIDC")) {
        res.setCarrierAIDCElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("carrierHRF")) {
        res.setCarrierHRFElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entryType")) {
        res.setEntryTypeElement(parseEnumeration(xpp, Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device.DeviceDeviceNameComponent parseDeviceDeviceDeviceNameComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDeviceDeviceNameComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDeviceDeviceNameComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Device.DeviceNameType.NULL, new Device.DeviceNameTypeEnumFactory()));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device.DeviceSpecializationComponent parseDeviceDeviceSpecializationComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDeviceSpecializationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDeviceSpecializationComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("systemType")) {
        res.setSystemType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device.DeviceVersionComponent parseDeviceDeviceVersionComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDeviceVersionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDeviceVersionComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
        res.setComponent(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device.DevicePropertyComponent parseDeviceDevicePropertyComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDevicePropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDevicePropertyComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DevicePropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueQuantity")) {
        res.getValueQuantity().add(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueCode")) {
        res.getValueCode().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition parseDeviceDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition res = new DeviceDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionContent(int eventType, XmlPullParser xpp, DeviceDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udiDeviceIdentifier")) {
        res.getUdiDeviceIdentifier().add(parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "manufacturer")) {
        res.setManufacturer(parseType("manufacturer", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceName")) {
        res.getDeviceName().add(parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modelNumber")) {
        res.setModelNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialization")) {
        res.getSpecialization().add(parseDeviceDefinitionDeviceDefinitionSpecializationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.getVersion().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("safety")) {
        res.getSafety().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("shelfLifeStorage")) {
        res.getShelfLifeStorage().add(parseProductShelfLife(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalCharacteristics")) {
        res.setPhysicalCharacteristics(parseProdCharacteristic(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("languageCode")) {
        res.getLanguageCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("capability")) {
        res.getCapability().add(parseDeviceDefinitionDeviceDefinitionCapabilityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseDeviceDefinitionDeviceDefinitionPropertyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
        res.setOwner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onlineInformation")) {
        res.setOnlineInformationElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parentDevice")) {
        res.setParentDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("material")) {
        res.getMaterial().add(parseDeviceDefinitionDeviceDefinitionMaterialComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceIdentifier")) {
        res.setDeviceIdentifierElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
        res.setIssuerElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.setJurisdictionElement(parseUri(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionDeviceDefinitionDeviceNameComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceDefinitionDeviceNameComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, DeviceDefinition.DeviceNameType.NULL, new DeviceDefinition.DeviceNameTypeEnumFactory()));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionDeviceDefinitionSpecializationComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionDeviceDefinitionSpecializationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceDefinitionSpecializationComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("systemType")) {
        res.setSystemTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionDeviceDefinitionCapabilityComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionDeviceDefinitionCapabilityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceDefinitionCapabilityComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.getDescription().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionDeviceDefinitionPropertyComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionDeviceDefinitionPropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueQuantity")) {
        res.getValueQuantity().add(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueCode")) {
        res.getValueCode().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionDeviceDefinitionMaterialComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDefinitionDeviceDefinitionMaterialComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceDefinitionMaterialComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
        res.setSubstance(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alternate")) {
        res.setAlternateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergenicIndicator")) {
        res.setAllergenicIndicatorElement(parseBoolean(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceMetricContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceMetricContent(int eventType, XmlPullParser xpp, DeviceMetric res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnit(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.setParent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
        res.setOperationalStatusElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("color")) {
        res.setColorElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategoryElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPeriod")) {
        res.setMeasurementPeriod(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("calibration")) {
        res.getCalibration().add(parseDeviceMetricDeviceMetricCalibrationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(XmlPullParser xpp, DeviceMetric owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceMetricDeviceMetricCalibrationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceMetricDeviceMetricCalibrationComponentContent(int eventType, XmlPullParser xpp, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("state")) {
        res.setStateElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
        res.setTimeElement(parseInstant(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceRequest parseDeviceRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceRequestContent(int eventType, XmlPullParser xpp, DeviceRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priorRequest")) {
        res.getPriorRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, DeviceRequest.RequestIntent.NULL, new DeviceRequest.RequestIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "code")) {
        res.setCode(parseType("code", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseDeviceRequestDeviceRequestParameterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
        res.setPerformerType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
        res.getRelevantHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestDeviceRequestParameterComponent(XmlPullParser xpp, DeviceRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceRequestDeviceRequestParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceRequestDeviceRequestParameterComponentContent(int eventType, XmlPullParser xpp, DeviceRequest owner, DeviceRequest.DeviceRequestParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceUseStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceUseStatementContent(int eventType, XmlPullParser xpp, DeviceUseStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
        res.getDerivedFrom().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedOn")) {
        res.setRecordedOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDiagnosticReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDiagnosticReportContent(int eventType, XmlPullParser xpp, DiagnosticReport res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resultsInterpreter")) {
        res.getResultsInterpreter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.getSpecimen().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.getResult().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imagingStudy")) {
        res.getImagingStudy().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("media")) {
        res.getMedia().add(parseDiagnosticReportDiagnosticReportMediaComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conclusion")) {
        res.setConclusionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conclusionCode")) {
        res.getConclusionCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentedForm")) {
        res.getPresentedForm().add(parseAttachment(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportDiagnosticReportMediaComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDiagnosticReportDiagnosticReportMediaComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDiagnosticReportDiagnosticReportMediaComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport owner, DiagnosticReport.DiagnosticReportMediaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.setLink(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentManifestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestContent(int eventType, XmlPullParser xpp, DocumentManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterIdentifier")) {
        res.setMasterIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseDocumentManifestDocumentManifestRelatedComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentManifestDocumentManifestRelatedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestDocumentManifestRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ref")) {
        res.setRef(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceContent(int eventType, XmlPullParser xpp, DocumentReference res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterIdentifier")) {
        res.setMasterIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("docStatus")) {
        res.setDocStatusElement(parseEnumeration(xpp, DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authenticator")) {
        res.setAuthenticator(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
        res.setCustodian(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
        res.getRelatesTo().add(parseDocumentReferenceDocumentReferenceRelatesToComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseDocumentReferenceDocumentReferenceContentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseDocumentReferenceDocumentReferenceContextComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceRelatesToComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceRelatesToComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceContentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceContentComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attachment")) {
        res.setAttachment(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
        res.setFormat(parseCoding(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceContextComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceContextComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.getEncounter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facilityType")) {
        res.setFacilityType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("practiceSetting")) {
        res.setPracticeSetting(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourcePatientInfo")) {
        res.setSourcePatientInfo(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterContent(int eventType, XmlPullParser xpp, Encounter res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusHistory")) {
        res.getStatusHistory().add(parseEncounterStatusHistoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classHistory")) {
        res.getClassHistory().add(parseEncounterClassHistoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
        res.setServiceType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectStatus")) {
        res.setSubjectStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("episodeOfCare")) {
        res.getEpisodeOfCare().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseEncounterEncounterParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointment")) {
        res.getAppointment().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("length")) {
        res.setLength(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.getAccount().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hospitalization")) {
        res.setHospitalization(parseEncounterEncounterHospitalizationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.getLocation().add(parseEncounterEncounterLocationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceProvider")) {
        res.setServiceProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.setPartOf(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterStatusHistoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterStatusHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.StatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterClassHistoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterClassHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.ClassHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterEncounterParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterEncounterParticipantComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("individual")) {
        res.setIndividual(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterDiagnosisComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUse(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
        res.setRankElement(parsePositiveInt(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterEncounterHospitalizationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterEncounterHospitalizationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAdmissionIdentifier")) {
        res.setPreAdmissionIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
        res.setOrigin(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("admitSource")) {
        res.setAdmitSource(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reAdmission")) {
        res.setReAdmission(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dietPreference")) {
        res.getDietPreference().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialCourtesy")) {
        res.getSpecialCourtesy().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialArrangement")) {
        res.getSpecialArrangement().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.setDestination(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dischargeDisposition")) {
        res.setDischargeDisposition(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterEncounterLocationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterEncounterLocationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalType")) {
        res.setPhysicalType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Endpoint parseEndpoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEndpointContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEndpointContent(int eventType, XmlPullParser xpp, Endpoint res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("connectionType")) {
        res.setConnectionType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payloadType")) {
        res.getPayloadType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payloadMimeType")) {
        res.getPayloadMimeType().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddressElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("header")) {
        res.getHeader().add(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEnrollmentRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEnrollmentRequestContent(int eventType, XmlPullParser xpp, EnrollmentRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("candidate")) {
        res.setCandidate(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEnrollmentResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEnrollmentResponseContent(int eventType, XmlPullParser xpp, EnrollmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
        res.setRequestProvider(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEpisodeOfCareContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareContent(int eventType, XmlPullParser xpp, EpisodeOfCare res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusHistory")) {
        res.getStatusHistory().add(parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referralRequest")) {
        res.getReferralRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careManager")) {
        res.setCareManager(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("team")) {
        res.getTeam().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.getAccount().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEpisodeOfCareDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareDiagnosisComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
        res.setRankElement(parsePositiveInt(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EventDefinition parseEventDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEventDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEventDefinitionContent(int eventType, XmlPullParser xpp, EventDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
        res.setSubject(parseType("subject", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
        res.getEditor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
        res.getReviewer().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
        res.getEndorser().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("trigger")) {
        res.getTrigger().add(parseTriggerDefinition(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Evidence parseEvidence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence res = new Evidence();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceContent(int eventType, XmlPullParser xpp, Evidence res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assertion")) {
        res.setAssertionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referentGroup")) {
        res.setReferentGroup(parseEvidenceEvidenceReferentGroupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variableDefinition")) {
        res.getVariableDefinition().add(parseEvidenceEvidenceVariableDefinitionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("synthesisType")) {
        res.setSynthesisType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("studyType")) {
        res.setStudyType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statistic")) {
        res.getStatistic().add(parseStatistic(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("distribution")) {
        res.getDistribution().add(parseOrderedDistribution(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("certainty")) {
        res.getCertainty().add(parseEvidenceEvidenceCertaintyComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Evidence.EvidenceReferentGroupComponent parseEvidenceEvidenceReferentGroupComponent(XmlPullParser xpp, Evidence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceReferentGroupComponent res = new Evidence.EvidenceReferentGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceEvidenceReferentGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceEvidenceReferentGroupComponentContent(int eventType, XmlPullParser xpp, Evidence owner, Evidence.EvidenceReferentGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evidenceSource")) {
        res.setEvidenceSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedGroup")) {
        res.setIntendedGroup(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("directnessMatch")) {
        res.setDirectnessMatch(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceEvidenceVariableDefinitionComponent(XmlPullParser xpp, Evidence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceEvidenceVariableDefinitionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceEvidenceVariableDefinitionComponentContent(int eventType, XmlPullParser xpp, Evidence owner, Evidence.EvidenceVariableDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variableRole")) {
        res.setVariableRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actualDefinition")) {
        res.setActualDefinition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedDefinition")) {
        res.setIntendedDefinition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("directnessMatch")) {
        res.setDirectnessMatch(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Evidence.EvidenceCertaintyComponent parseEvidenceEvidenceCertaintyComponent(XmlPullParser xpp, Evidence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceEvidenceCertaintyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceEvidenceCertaintyComponentContent(int eventType, XmlPullParser xpp, Evidence owner, Evidence.EvidenceCertaintyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.setNote(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rating")) {
        res.getRating().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("certaintySubcomponent")) {
        res.getCertaintySubcomponent().add(parseEvidenceEvidenceCertaintyCertaintySubcomponentComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Evidence.EvidenceCertaintyCertaintySubcomponentComponent parseEvidenceEvidenceCertaintyCertaintySubcomponentComponent(XmlPullParser xpp, Evidence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceCertaintyCertaintySubcomponentComponent res = new Evidence.EvidenceCertaintyCertaintySubcomponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceEvidenceCertaintyCertaintySubcomponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceEvidenceCertaintyCertaintySubcomponentComponentContent(int eventType, XmlPullParser xpp, Evidence owner, Evidence.EvidenceCertaintyCertaintySubcomponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.setNote(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rating")) {
        res.getRating().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EvidenceVariable parseEvidenceVariable(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceVariable res = new EvidenceVariable();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceVariableContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableContent(int eventType, XmlPullParser xpp, EvidenceVariable res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("shortTitle")) {
        res.setShortTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
        res.getEditor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
        res.getReviewer().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
        res.getEndorser().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, EvidenceVariable.EvidenceVariableType.NULL, new EvidenceVariable.EvidenceVariableTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
        res.setActualElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
        res.getCharacteristic().add(parseEvidenceVariableEvidenceVariableCharacteristicComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableEvidenceVariableCharacteristicComponent(XmlPullParser xpp, EvidenceVariable owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEvidenceVariableEvidenceVariableCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableEvidenceVariableCharacteristicComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable owner, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "definition")) {
        res.setDefinition(parseType("definition", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("booleanSet")) {
        res.getBooleanSet().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
        res.setExcludeElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "participantEffective")) {
        res.setParticipantEffective(parseType("participantEffective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timeFromStart")) {
        res.setTimeFromStart(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupMeasure")) {
        res.setGroupMeasureElement(parseEnumeration(xpp, EvidenceVariable.GroupMeasure.NULL, new EvidenceVariable.GroupMeasureEnumFactory()));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario parseExampleScenario(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioContent(int eventType, XmlPullParser xpp, ExampleScenario res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.getActor().add(parseExampleScenarioExampleScenarioActorComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseExampleScenarioExampleScenarioInstanceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("process")) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("workflow")) {
        res.getWorkflow().add(parseCanonical(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioExampleScenarioActorComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioActorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioActorComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actorId")) {
        res.setActorIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioExampleScenarioInstanceComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceId")) {
        res.setResourceIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceType")) {
        res.setResourceTypeElement(parseEnumeration(xpp, ExampleScenario.FHIRResourceType.NULL, new ExampleScenario.FHIRResourceTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.getVersion().add(parseExampleScenarioExampleScenarioInstanceVersionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containedInstance")) {
        res.getContainedInstance().add(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioExampleScenarioInstanceVersionComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioInstanceVersionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioInstanceVersionComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
        res.setVersionIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceId")) {
        res.setResourceIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
        res.setVersionIdElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioExampleScenarioProcessComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preConditions")) {
        res.setPreConditionsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("postConditions")) {
        res.setPostConditionsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("step")) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioExampleScenarioProcessStepComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("process")) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pause")) {
        res.setPauseElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.setOperation(parseExampleScenarioExampleScenarioProcessStepOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alternative")) {
        res.getAlternative().add(parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioExampleScenarioProcessStepOperationComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepOperationComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initiator")) {
        res.setInitiatorElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.setReceiverElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initiatorActive")) {
        res.setInitiatorActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiverActive")) {
        res.setReceiverActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepAlternativeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepAlternativeComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("step")) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.setSubType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, ExplanationOfBenefit.Use.NULL, new ExplanationOfBenefit.UseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billablePeriod")) {
        res.setBillablePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserveRequested")) {
        res.setFundsReserveRequested(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
        res.setFundsReserve(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prescription")) {
        res.setPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("originalPrescription")) {
        res.setOriginalPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
        res.setPayee(parseExplanationOfBenefitPayeeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referral")) {
        res.setReferral(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
        res.setClaim(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
        res.setClaimResponse(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, ExplanationOfBenefit.RemittanceOutcome.NULL, new ExplanationOfBenefit.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.getPreAuthRef().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRefPeriod")) {
        res.getPreAuthRefPeriod().add(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseExplanationOfBenefitSupportingInformationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precedence")) {
        res.setPrecedenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseExplanationOfBenefitInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accident")) {
        res.setAccident(parseExplanationOfBenefitAccidentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addItem")) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.getTotal().add(parseExplanationOfBenefitTotalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
        res.setPayment(parseExplanationOfBenefitPaymentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("formCode")) {
        res.setFormCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitPeriod")) {
        res.setBenefitPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitBalance")) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitRelatedClaimComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitRelatedClaimComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
        res.setClaim(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseIdentifier(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitPayeeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitPayeeComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitCareTeamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitCareTeamComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsibleElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
        res.setQualification(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitSupportingInformationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitSupportingInformationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCoding(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitDiagnosisComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
        res.setDiagnosis(parseType("diagnosis", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onAdmission")) {
        res.setOnAdmission(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageCode")) {
        res.setPackageCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitProcedureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitProcedureComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "procedure")) {
        res.setProcedure(parseType("procedure", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitInsuranceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
        res.setFocalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.getPreAuthRef().add(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAccidentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAccidentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeamSequence")) {
        res.getCareTeamSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosisSequence")) {
        res.getDiagnosisSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureSequence")) {
        res.getProcedureSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSequence")) {
        res.getInformationSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
        res.getSubSite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.getEncounter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAdjudicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAdjudicationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAddedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
        res.getItemSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
        res.getDetailSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetailSequence")) {
        res.getSubDetailSequence().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.getProvider().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
        res.getSubSite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAddedItemDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseExplanationOfBenefitAddedItemDetailSubDetailComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
        res.setProductOrService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitTotalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitTotalComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitPaymentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitPaymentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustment")) {
        res.setAdjustment(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustmentReason")) {
        res.setAdjustmentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitNoteComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitNoteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguage(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitBenefitBalanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitBenefitBalanceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excluded")) {
        res.setExcludedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetwork(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnit(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
        res.setTerm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("financial")) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitBenefitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitBenefitComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
        res.setAllowed(parseType("allowed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "used")) {
        res.setUsed(parseType("used", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFamilyMemberHistoryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryContent(int eventType, XmlPullParser xpp, FamilyMemberHistory res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
        res.setDataAbsentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sex")) {
        res.setSex(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "born")) {
        res.setBorn(parseType("born", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "age")) {
        res.setAge(parseType("age", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("estimatedAge")) {
        res.setEstimatedAgeElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "deceased")) {
        res.setDeceased(parseType("deceased", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.getCondition().add(parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.getProcedure().add(parseFamilyMemberHistoryFamilyMemberHistoryProcedureComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributedToDeath")) {
        res.setContributedToDeathElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
        res.setOnset(parseType("onset", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected FamilyMemberHistory.FamilyMemberHistoryProcedureComponent parseFamilyMemberHistoryFamilyMemberHistoryProcedureComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res = new FamilyMemberHistory.FamilyMemberHistoryProcedureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFamilyMemberHistoryFamilyMemberHistoryProcedureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryFamilyMemberHistoryProcedureComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributedToDeath")) {
        res.setContributedToDeathElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "performed")) {
        res.setPerformed(parseType("performed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Flag res = new Flag();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFlagContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFlagContent(int eventType, XmlPullParser xpp, Flag res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Goal res = new Goal();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGoalContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGoalContent(int eventType, XmlPullParser xpp, Goal res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lifecycleStatus")) {
        res.setLifecycleStatusElement(parseEnumeration(xpp, Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("achievementStatus")) {
        res.setAchievementStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("continuous")) {
        res.setContinuousElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescription(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "start")) {
        res.setStart(parseType("start", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseGoalGoalTargetComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
        res.setStatusDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expressedBy")) {
        res.setExpressedBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addresses")) {
        res.getAddresses().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeCode")) {
        res.getOutcomeCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeReference")) {
        res.getOutcomeReference().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(XmlPullParser xpp, Goal owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGoalGoalTargetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGoalGoalTargetComponentContent(int eventType, XmlPullParser xpp, Goal owner, Goal.GoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
        res.setMeasure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "detail")) {
        res.setDetail(parseType("detail", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "due")) {
        res.setDue(parseType("due", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition parseGraphDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionContent(int eventType, XmlPullParser xpp, GraphDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionGraphDefinitionLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionGraphDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceName")) {
        res.setSliceNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseGraphDefinitionGraphDefinitionLinkTargetComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("params")) {
        res.setParamsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
        res.getCompartment().add(parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.setRuleElement(parseEnumeration(xpp, GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Group res = new Group();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGroupContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupContent(int eventType, XmlPullParser xpp, Group res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
        res.setActualElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantityElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingEntity")) {
        res.setManagingEntity(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
        res.getCharacteristic().add(parseGroupGroupCharacteristicComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("member")) {
        res.getMember().add(parseGroupGroupMemberComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGroupGroupCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupGroupCharacteristicComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
        res.setExcludeElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Group.GroupMemberComponent parseGroupGroupMemberComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGroupGroupMemberComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupGroupMemberComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupMemberComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
        res.setEntity(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inactive")) {
        res.setInactiveElement(parseBoolean(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGuidanceResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGuidanceResponseContent(int eventType, XmlPullParser xpp, GuidanceResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestIdentifier")) {
        res.setRequestIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "module")) {
        res.setModule(parseType("module", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("occurrenceDateTime")) {
        res.setOccurrenceDateTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evaluationMessage")) {
        res.getEvaluationMessage().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outputParameters")) {
        res.setOutputParameters(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.setResult(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
        res.getDataRequirement().add(parseDataRequirement(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceContent(int eventType, XmlPullParser xpp, HealthcareService res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("providedBy")) {
        res.setProvidedBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.getLocation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extraDetails")) {
        res.setExtraDetailsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
        res.setPhoto(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
        res.getCoverageArea().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceProvisionCode")) {
        res.getServiceProvisionCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eligibility")) {
        res.getEligibility().add(parseHealthcareServiceHealthcareServiceEligibilityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("program")) {
        res.getProgram().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
        res.getCharacteristic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communication")) {
        res.getCommunication().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referralMethod")) {
        res.getReferralMethod().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentRequired")) {
        res.setAppointmentRequiredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableTime")) {
        res.getAvailableTime().add(parseHealthcareServiceHealthcareServiceAvailableTimeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notAvailable")) {
        res.getNotAvailable().add(parseHealthcareServiceHealthcareServiceNotAvailableComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availabilityExceptions")) {
        res.setAvailabilityExceptionsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceHealthcareServiceEligibilityComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceHealthcareServiceEligibilityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceHealthcareServiceEligibilityComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceEligibilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysOfWeek")) {
        res.getDaysOfWeek().add(parseEnumeration(xpp, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allDay")) {
        res.setAllDayElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableStartTime")) {
        res.setAvailableStartTimeElement(parseTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableEndTime")) {
        res.setAvailableEndTimeElement(parseTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("during")) {
        res.setDuring(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyContent(int eventType, XmlPullParser xpp, ImagingStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modality")) {
        res.getModality().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("started")) {
        res.setStartedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referrer")) {
        res.setReferrer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpreter")) {
        res.getInterpreter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfSeries")) {
        res.setNumberOfSeriesElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfInstances")) {
        res.setNumberOfInstancesElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureReference")) {
        res.setProcedureReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureCode")) {
        res.getProcedureCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.getSeries().add(parseImagingStudyImagingStudySeriesComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyImagingStudySeriesComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyImagingStudySeriesComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modality")) {
        res.setModality(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfInstances")) {
        res.setNumberOfInstancesElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("laterality")) {
        res.setLaterality(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.getSpecimen().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("started")) {
        res.setStartedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseImagingStudyImagingStudySeriesPerformerComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseImagingStudyImagingStudySeriesInstanceComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudyImagingStudySeriesPerformerComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyImagingStudySeriesPerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyImagingStudySeriesPerformerComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
        res.setFunction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyImagingStudySeriesInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyImagingStudySeriesInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sopClass")) {
        res.setSopClass(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationContent(int eventType, XmlPullParser xpp, Immunization res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccineCode")) {
        res.setVaccineCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
        res.setRecordedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("primarySource")) {
        res.setPrimarySourceElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "informationSource")) {
        res.setInformationSource(parseType("informationSource", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
        res.setLotNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
        res.setExpirationDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
        res.setRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseQuantity")) {
        res.setDoseQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseImmunizationImmunizationPerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isSubpotent")) {
        res.setIsSubpotentElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subpotentReason")) {
        res.getSubpotentReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("education")) {
        res.getEducation().add(parseImmunizationImmunizationEducationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programEligibility")) {
        res.getProgramEligibility().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundingSource")) {
        res.setFundingSource(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reaction")) {
        res.getReaction().add(parseImmunizationImmunizationReactionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocolApplied")) {
        res.getProtocolApplied().add(parseImmunizationImmunizationProtocolAppliedComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationPerformerComponent parseImmunizationImmunizationPerformerComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationPerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationPerformerComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
        res.setFunction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationEducationComponent parseImmunizationImmunizationEducationComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationEducationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationEducationComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationEducationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentType")) {
        res.setDocumentTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationDate")) {
        res.setPublicationDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentationDate")) {
        res.setPresentationDateElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationReactionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationReactionComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetail(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reported")) {
        res.setReportedElement(parseBoolean(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationImmunizationProtocolAppliedComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationProtocolAppliedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationProtocolAppliedComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationProtocolAppliedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.setSeriesElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthority(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
        res.getTargetDisease().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "doseNumber")) {
        res.setDoseNumber(parseType("doseNumber", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "seriesDoses")) {
        res.setSeriesDoses(parseType("seriesDoses", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationEvaluation parseImmunizationEvaluation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationEvaluation res = new ImmunizationEvaluation();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationEvaluationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationEvaluationContent(int eventType, XmlPullParser xpp, ImmunizationEvaluation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ImmunizationEvaluation.ImmunizationEvaluationStatus.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthority(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
        res.setTargetDisease(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("immunizationEvent")) {
        res.setImmunizationEvent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseStatus")) {
        res.setDoseStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseStatusReason")) {
        res.getDoseStatusReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.setSeriesElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "doseNumber")) {
        res.setDoseNumber(parseType("doseNumber", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "seriesDoses")) {
        res.setSeriesDoses(parseType("seriesDoses", xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthority(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recommendation")) {
        res.getRecommendation().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccineCode")) {
        res.getVaccineCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
        res.getTargetDisease().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contraindicatedVaccineCode")) {
        res.getContraindicatedVaccineCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("forecastStatus")) {
        res.setForecastStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("forecastReason")) {
        res.getForecastReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateCriterion")) {
        res.getDateCriterion().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.setSeriesElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "doseNumber")) {
        res.setDoseNumber(parseType("doseNumber", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "seriesDoses")) {
        res.setSeriesDoses(parseType("seriesDoses", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingImmunization")) {
        res.getSupportingImmunization().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingPatientInformation")) {
        res.getSupportingPatientInformation().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideContent(int eventType, XmlPullParser xpp, ImplementationGuide res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageId")) {
        res.setPackageIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("license")) {
        res.setLicenseElement(parseEnumeration(xpp, ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.getFhirVersion().add(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependsOn")) {
        res.getDependsOn().add(parseImplementationGuideImplementationGuideDependsOnComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("global")) {
        res.getGlobal().add(parseImplementationGuideImplementationGuideGlobalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseImplementationGuideImplementationGuideDefinitionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manifest")) {
        res.setManifest(parseImplementationGuideImplementationGuideManifestComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideImplementationGuideDependsOnComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDependsOnComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDependsOnComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageId")) {
        res.setPackageIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideGlobalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideGlobalComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideImplementationGuideDefinitionComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDefinitionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDefinitionComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("grouping")) {
        res.getGrouping().add(parseImplementationGuideImplementationGuideDefinitionGroupingComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseImplementationGuideImplementationGuideDefinitionResourceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
        res.setPage(parseImplementationGuideImplementationGuideDefinitionPageComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseImplementationGuideImplementationGuideDefinitionParameterComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("template")) {
        res.getTemplate().add(parseImplementationGuideImplementationGuideDefinitionTemplateComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideImplementationGuideDefinitionGroupingComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDefinitionGroupingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDefinitionGroupingComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideImplementationGuideDefinitionResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDefinitionResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.getFhirVersion().add(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "example")) {
        res.setExample(parseType("example", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupingId")) {
        res.setGroupingIdElement(parseId(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideImplementationGuideDefinitionPageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDefinitionPageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDefinitionPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "name")) {
        res.setName(parseType("name", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("generation")) {
        res.setGenerationElement(parseEnumeration(xpp, ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
        res.getPage().add(parseImplementationGuideImplementationGuideDefinitionPageComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideImplementationGuideDefinitionParameterComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDefinitionParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideImplementationGuideDefinitionTemplateComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDefinitionTemplateComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDefinitionTemplateComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
        res.setScopeElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideImplementationGuideManifestComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideManifestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideManifestComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideManifestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rendering")) {
        res.setRenderingElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseImplementationGuideManifestResourceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
        res.getPage().add(parseImplementationGuideManifestPageComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
        res.getImage().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("other")) {
        res.getOther().add(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideManifestResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideManifestResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ManifestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "example")) {
        res.setExample(parseType("example", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relativePath")) {
        res.setRelativePathElement(parseUrl(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideManifestPageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideManifestPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ManifestPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("anchor")) {
        res.getAnchor().add(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ingredient parseIngredient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient res = new Ingredient();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIngredientContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientContent(int eventType, XmlPullParser xpp, Ingredient res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergenicIndicator")) {
        res.setAllergenicIndicatorElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.getManufacturer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specifiedSubstance")) {
        res.getSpecifiedSubstance().add(parseIngredientIngredientSpecifiedSubstanceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
        res.setSubstance(parseIngredientIngredientSubstanceComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ingredient.IngredientSpecifiedSubstanceComponent parseIngredientIngredientSpecifiedSubstanceComponent(XmlPullParser xpp, Ingredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSpecifiedSubstanceComponent res = new Ingredient.IngredientSpecifiedSubstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIngredientIngredientSpecifiedSubstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientIngredientSpecifiedSubstanceComponentContent(int eventType, XmlPullParser xpp, Ingredient owner, Ingredient.IngredientSpecifiedSubstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "code")) {
        res.setCode(parseType("code", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.setGroup(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("confidentiality")) {
        res.setConfidentiality(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.getStrength().add(parseIngredientIngredientSpecifiedSubstanceStrengthComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ingredient.IngredientSpecifiedSubstanceStrengthComponent parseIngredientIngredientSpecifiedSubstanceStrengthComponent(XmlPullParser xpp, Ingredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSpecifiedSubstanceStrengthComponent res = new Ingredient.IngredientSpecifiedSubstanceStrengthComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIngredientIngredientSpecifiedSubstanceStrengthComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientIngredientSpecifiedSubstanceStrengthComponentContent(int eventType, XmlPullParser xpp, Ingredient owner, Ingredient.IngredientSpecifiedSubstanceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentation")) {
        res.setPresentation(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentationHighLimit")) {
        res.setPresentationHighLimit(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concentration")) {
        res.setConcentration(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concentrationHighLimit")) {
        res.setConcentrationHighLimit(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPoint")) {
        res.setMeasurementPointElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
        res.getCountry().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceStrength")) {
        res.getReferenceStrength().add(parseIngredientIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent parseIngredientIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(XmlPullParser xpp, Ingredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res = new Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIngredientIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentContent(int eventType, XmlPullParser xpp, Ingredient owner, Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "substance")) {
        res.setSubstance(parseType("substance", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.setStrength(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strengthHighLimit")) {
        res.setStrengthHighLimit(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPoint")) {
        res.setMeasurementPointElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
        res.getCountry().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ingredient.IngredientSubstanceComponent parseIngredientIngredientSubstanceComponent(XmlPullParser xpp, Ingredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceComponent res = new Ingredient.IngredientSubstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIngredientIngredientSubstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientIngredientSubstanceComponentContent(int eventType, XmlPullParser xpp, Ingredient owner, Ingredient.IngredientSubstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "code")) {
        res.setCode(parseType("code", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.getStrength().add(parseIngredientIngredientSpecifiedSubstanceStrengthComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan parseInsurancePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan res = new InsurancePlan();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanContent(int eventType, XmlPullParser xpp, InsurancePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ownedBy")) {
        res.setOwnedBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administeredBy")) {
        res.setAdministeredBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
        res.getCoverageArea().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseInsurancePlanInsurancePlanContactComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.getNetwork().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.getCoverage().add(parseInsurancePlanInsurancePlanCoverageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("plan")) {
        res.getPlan().add(parseInsurancePlanInsurancePlanPlanComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.InsurancePlanContactComponent parseInsurancePlanInsurancePlanContactComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanContactComponent res = new InsurancePlan.InsurancePlanContactComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanInsurancePlanContactComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanInsurancePlanContactComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurpose(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setName(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddress(parseAddress(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanInsurancePlanCoverageComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanInsurancePlanCoverageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanInsurancePlanCoverageComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanCoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.getNetwork().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefit")) {
        res.getBenefit().add(parseInsurancePlanCoverageBenefitComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanCoverageBenefitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanCoverageBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.CoverageBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirement")) {
        res.setRequirementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("limit")) {
        res.getLimit().add(parseInsurancePlanCoverageBenefitLimitComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanCoverageBenefitLimitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanCoverageBenefitLimitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.CoverageBenefitLimitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValue(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanInsurancePlanPlanComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanInsurancePlanPlanComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanInsurancePlanPlanComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanPlanComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
        res.getCoverageArea().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.getNetwork().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("generalCost")) {
        res.getGeneralCost().add(parseInsurancePlanInsurancePlanPlanGeneralCostComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specificCost")) {
        res.getSpecificCost().add(parseInsurancePlanInsurancePlanPlanSpecificCostComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanInsurancePlanPlanGeneralCostComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanInsurancePlanPlanGeneralCostComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanInsurancePlanPlanGeneralCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupSize")) {
        res.setGroupSizeElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
        res.setCost(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanInsurancePlanPlanSpecificCostComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanInsurancePlanPlanSpecificCostComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanInsurancePlanPlanSpecificCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefit")) {
        res.getBenefit().add(parseInsurancePlanPlanBenefitComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanPlanBenefitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.PlanBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
        res.getCost().add(parseInsurancePlanPlanBenefitCostComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInsurancePlanPlanBenefitCostComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanBenefitCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.PlanBenefitCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applicability")) {
        res.setApplicability(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualifiers")) {
        res.getQualifiers().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValue(parseQuantity(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Invoice parseInvoice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice res = new Invoice();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInvoiceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceContent(int eventType, XmlPullParser xpp, Invoice res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cancelledReason")) {
        res.setCancelledReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.setRecipient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseInvoiceInvoiceParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
        res.setIssuer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.setAccount(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lineItem")) {
        res.getLineItem().add(parseInvoiceInvoiceLineItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalPriceComponent")) {
        res.getTotalPriceComponent().add(parseInvoiceInvoiceLineItemPriceComponentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalNet")) {
        res.setTotalNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalGross")) {
        res.setTotalGross(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("paymentTerms")) {
        res.setPaymentTermsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Invoice.InvoiceParticipantComponent parseInvoiceInvoiceParticipantComponent(XmlPullParser xpp, Invoice owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInvoiceInvoiceParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceInvoiceParticipantComponentContent(int eventType, XmlPullParser xpp, Invoice owner, Invoice.InvoiceParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Invoice.InvoiceLineItemComponent parseInvoiceInvoiceLineItemComponent(XmlPullParser xpp, Invoice owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInvoiceInvoiceLineItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceInvoiceLineItemComponentContent(int eventType, XmlPullParser xpp, Invoice owner, Invoice.InvoiceLineItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "chargeItem")) {
        res.setChargeItem(parseType("chargeItem", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceComponent")) {
        res.getPriceComponent().add(parseInvoiceInvoiceLineItemPriceComponentComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Invoice.InvoiceLineItemPriceComponentComponent parseInvoiceInvoiceLineItemPriceComponentComponent(XmlPullParser xpp, Invoice owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice.InvoiceLineItemPriceComponentComponent res = new Invoice.InvoiceLineItemPriceComponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseInvoiceInvoiceLineItemPriceComponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceInvoiceLineItemPriceComponentComponentContent(int eventType, XmlPullParser xpp, Invoice owner, Invoice.InvoiceLineItemPriceComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Invoice.InvoicePriceComponentType.NULL, new Invoice.InvoicePriceComponentTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Library res = new Library();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLibraryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLibraryContent(int eventType, XmlPullParser xpp, Library res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
        res.setSubject(parseType("subject", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
        res.getEditor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
        res.getReviewer().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
        res.getEndorser().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseParameterDefinition(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
        res.getDataRequirement().add(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseAttachment(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLinkageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLinkageContent(int eventType, XmlPullParser xpp, Linkage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseLinkageLinkageItemComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(XmlPullParser xpp, Linkage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLinkageLinkageItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLinkageLinkageItemComponentContent(int eventType, XmlPullParser xpp, Linkage owner, Linkage.LinkageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseListResourceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseListResourceContent(int eventType, XmlPullParser xpp, ListResource res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
        res.setOrderedBy(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
        res.getEntry().add(parseListResourceListEntryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
        res.setEmptyReason(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ListResource.ListEntryComponent parseListResourceListEntryComponent(XmlPullParser xpp, ListResource owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseListResourceListEntryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseListResourceListEntryComponentContent(int eventType, XmlPullParser xpp, ListResource owner, ListResource.ListEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("flag")) {
        res.setFlag(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deleted")) {
        res.setDeletedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.setItem(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Location res = new Location();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLocationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationContent(int eventType, XmlPullParser xpp, Location res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
        res.setOperationalStatus(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddress(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalType")) {
        res.setPhysicalType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("position")) {
        res.setPosition(parseLocationLocationPositionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.setPartOf(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hoursOfOperation")) {
        res.getHoursOfOperation().add(parseLocationLocationHoursOfOperationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availabilityExceptions")) {
        res.setAvailabilityExceptionsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLocationLocationPositionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationLocationPositionComponentContent(int eventType, XmlPullParser xpp, Location owner, Location.LocationPositionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("longitude")) {
        res.setLongitudeElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("latitude")) {
        res.setLatitudeElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("altitude")) {
        res.setAltitudeElement(parseDecimal(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Location.LocationHoursOfOperationComponent parseLocationLocationHoursOfOperationComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Location.LocationHoursOfOperationComponent res = new Location.LocationHoursOfOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLocationLocationHoursOfOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationLocationHoursOfOperationComponentContent(int eventType, XmlPullParser xpp, Location owner, Location.LocationHoursOfOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysOfWeek")) {
        res.getDaysOfWeek().add(parseEnumeration(xpp, Location.DaysOfWeek.NULL, new Location.DaysOfWeekEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allDay")) {
        res.setAllDayElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("openingTime")) {
        res.setOpeningTimeElement(parseTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("closingTime")) {
        res.setClosingTimeElement(parseTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ManufacturedItemDefinition parseManufacturedItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ManufacturedItemDefinition res = new ManufacturedItemDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseManufacturedItemDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseManufacturedItemDefinitionContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturedDoseForm")) {
        res.setManufacturedDoseForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitOfPresentation")) {
        res.setUnitOfPresentation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.getManufacturer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalCharacteristics")) {
        res.setPhysicalCharacteristics(parseProdCharacteristic(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("otherCharacteristics")) {
        res.getOtherCharacteristics().add(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure res = new Measure();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureContent(int eventType, XmlPullParser xpp, Measure res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
        res.setSubtitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
        res.setSubject(parseType("subject", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
        res.getEditor().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
        res.getReviewer().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
        res.getEndorser().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
        res.getLibrary().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disclaimer")) {
        res.setDisclaimerElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scoring")) {
        res.setScoring(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compositeScoring")) {
        res.setCompositeScoring(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("riskAdjustment")) {
        res.setRiskAdjustmentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rateAggregation")) {
        res.setRateAggregationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rationale")) {
        res.setRationaleElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalRecommendationStatement")) {
        res.setClinicalRecommendationStatementElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("improvementNotation")) {
        res.setImprovementNotation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("guidance")) {
        res.setGuidanceElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseMeasureMeasureGroupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplementalData")) {
        res.getSupplementalData().add(parseMeasureMeasureSupplementalDataComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parseMeasureMeasureGroupPopulationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratifier")) {
        res.getStratifier().add(parseMeasureMeasureGroupStratifierComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupPopulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupPopulationComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteria(parseExpression(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupStratifierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupStratifierComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteria(parseExpression(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
        res.getComponent().add(parseMeasureMeasureGroupStratifierComponentComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupStratifierComponentComponent parseMeasureMeasureGroupStratifierComponentComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponentComponent res = new Measure.MeasureGroupStratifierComponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupStratifierComponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupStratifierComponentComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupStratifierComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteria(parseExpression(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureSupplementalDataComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureSupplementalDataComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureSupplementalDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.getUsage().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteria(parseExpression(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport parseMeasureReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportContent(int eventType, XmlPullParser xpp, MeasureReport res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
        res.setMeasureElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reporter")) {
        res.setReporter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("improvementNotation")) {
        res.setImprovementNotation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseMeasureReportMeasureReportGroupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evaluatedResource")) {
        res.getEvaluatedResource().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportMeasureReportGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportMeasureReportGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parseMeasureReportMeasureReportGroupPopulationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measureScore")) {
        res.setMeasureScore(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratifier")) {
        res.getStratifier().add(parseMeasureReportMeasureReportGroupStratifierComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportMeasureReportGroupPopulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportMeasureReportGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectResults")) {
        res.setSubjectResults(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportMeasureReportGroupStratifierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportMeasureReportGroupStratifierComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratum")) {
        res.getStratum().add(parseMeasureReportStratifierGroupComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportStratifierGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
        res.getComponent().add(parseMeasureReportStratifierGroupComponentComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measureScore")) {
        res.setMeasureScore(parseQuantity(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.StratifierGroupComponentComponent parseMeasureReportStratifierGroupComponentComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponentComponent res = new MeasureReport.StratifierGroupComponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportStratifierGroupComponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupComponentComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValue(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportStratifierGroupPopulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectResults")) {
        res.setSubjectResults(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication res = new Medication();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationContent(int eventType, XmlPullParser xpp, Medication res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseForm")) {
        res.setDoseForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseMedicationMedicationIngredientComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("batch")) {
        res.setBatch(parseMedicationMedicationBatchComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationMedicationIngredientComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationMedicationIngredientComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isActive")) {
        res.setIsActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "strength")) {
        res.setStrength(parseType("strength", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication.MedicationBatchComponent parseMedicationMedicationBatchComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationBatchComponent res = new Medication.MedicationBatchComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationMedicationBatchComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationMedicationBatchComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationBatchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
        res.setLotNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
        res.setExpirationDateElement(parseDateTime(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationAdministrationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationContent(int eventType, XmlPullParser xpp, MedicationAdministration res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.getStatusReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurence")) {
        res.setOccurence(parseType("occurence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
        res.setRecordedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseMedicationAdministrationMedicationAdministrationPerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.getDevice().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.setDosage(parseMedicationAdministrationMedicationAdministrationDosageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
        res.getEventHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
        res.setFunction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationAdministrationMedicationAdministrationDosageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationMedicationAdministrationDosageComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
        res.setRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dose")) {
        res.setDose(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
        res.setRate(parseType("rate", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationDispenseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseContent(int eventType, XmlPullParser xpp, MedicationDispense res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "statusReason")) {
        res.setStatusReason(parseType("statusReason", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseMedicationDispenseMedicationDispensePerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizingPrescription")) {
        res.getAuthorizingPrescription().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysSupply")) {
        res.setDaysSupply(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenPrepared")) {
        res.setWhenPreparedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenHandedOver")) {
        res.setWhenHandedOverElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.setDestination(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.getReceiver().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosageInstruction")) {
        res.getDosageInstruction().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
        res.setSubstitution(parseMedicationDispenseMedicationDispenseSubstitutionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detectedIssue")) {
        res.getDetectedIssue().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
        res.getEventHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationDispenseMedicationDispensePerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseMedicationDispensePerformerComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
        res.setFunction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("wasSubstituted")) {
        res.setWasSubstitutedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsibleParty")) {
        res.setResponsibleParty(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge parseMedicationKnowledge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge res = new MedicationKnowledge();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeContent(int eventType, XmlPullParser xpp, MedicationKnowledge res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationKnowledge.MedicationKnowledgeStatus.NULL, new MedicationKnowledge.MedicationKnowledgeStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseForm")) {
        res.setDoseForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("synonym")) {
        res.getSynonym().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedMedicationKnowledge")) {
        res.getRelatedMedicationKnowledge().add(parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("associatedMedication")) {
        res.getAssociatedMedication().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productType")) {
        res.getProductType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("monograph")) {
        res.getMonograph().add(parseMedicationKnowledgeMedicationKnowledgeMonographComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.getDevice().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preparationInstruction")) {
        res.setPreparationInstructionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedRoute")) {
        res.getIntendedRoute().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
        res.getCost().add(parseMedicationKnowledgeMedicationKnowledgeCostComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("monitoringProgram")) {
        res.getMonitoringProgram().add(parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrationGuideline")) {
        res.getAdministrationGuideline().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medicineClassification")) {
        res.getMedicineClassification().add(parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packaging")) {
        res.setPackaging(parseMedicationKnowledgeMedicationKnowledgePackagingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("drugCharacteristic")) {
        res.getDrugCharacteristic().add(parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalUseIssue")) {
        res.getClinicalUseIssue().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("regulatory")) {
        res.getRegulatory().add(parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kineticCharacteristic")) {
        res.getKineticCharacteristic().add(parseMedicationKnowledgeMedicationKnowledgeKineticCharacteristicComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.getReference().add(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeMonographComponent parseMedicationKnowledgeMedicationKnowledgeMonographComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonographComponent res = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeMonographComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeMonographComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonographComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeIngredientComponent parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeIngredientComponent res = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeIngredientComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeIngredientComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isActive")) {
        res.setIsActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.setStrength(parseRatio(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeCostComponent parseMedicationKnowledgeMedicationKnowledgeCostComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeCostComponent res = new MedicationKnowledge.MedicationKnowledgeCostComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeCostComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeCostComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
        res.setCost(parseMoney(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.getDosage().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineDosageComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "indication")) {
        res.setIndication(parseType("indication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientCharacteristic")) {
        res.getPatientCharacteristic().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineDosageComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineDosageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelineDosageComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.getDosage().add(parseDosage(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "characteristic")) {
        res.setCharacteristic(parseType("characteristic", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.getValue().add(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
        res.getClassification().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgePackagingComponent parseMedicationKnowledgeMedicationKnowledgePackagingComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgePackagingComponent res = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgePackagingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgePackagingComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgePackagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("material")) {
        res.setMaterial(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packaging")) {
        res.getPackaging().add(parseMedicationKnowledgeMedicationKnowledgePackagingComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("regulatoryAuthority")) {
        res.setRegulatoryAuthority(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
        res.getSubstitution().add(parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.getSchedule().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDispense")) {
        res.setMaxDispense(parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allowed")) {
        res.setAllowedElement(parseBoolean(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parseDuration(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent parseMedicationKnowledgeMedicationKnowledgeKineticCharacteristicComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationKnowledgeMedicationKnowledgeKineticCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicationKnowledgeKineticCharacteristicComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest parseMedicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestContent(int eventType, XmlPullParser xpp, MedicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
        res.setDoNotPerformElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reported")) {
        res.setReportedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSource")) {
        res.setInformationSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
        res.setPerformerType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("courseOfTherapyType")) {
        res.setCourseOfTherapyType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosageInstruction")) {
        res.getDosageInstruction().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dispenseRequest")) {
        res.setDispenseRequest(parseMedicationRequestMedicationRequestDispenseRequestComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
        res.setSubstitution(parseMedicationRequestMedicationRequestSubstitutionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priorPrescription")) {
        res.setPriorPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detectedIssue")) {
        res.getDetectedIssue().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
        res.getEventHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestMedicationRequestDispenseRequestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestMedicationRequestDispenseRequestComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initialFill")) {
        res.setInitialFill(parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dispenseInterval")) {
        res.setDispenseInterval(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validityPeriod")) {
        res.setValidityPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfRepeatsAllowed")) {
        res.setNumberOfRepeatsAllowedElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expectedSupplyDuration")) {
        res.setExpectedSupplyDuration(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDuration(parseDuration(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestMedicationRequestSubstitutionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestMedicationRequestSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
        res.setAllowed(parseType("allowed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationUsage parseMedicationUsage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationUsage res = new MedicationUsage();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationUsageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationUsageContent(int eventType, XmlPullParser xpp, MedicationUsage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationUsage.MedicationUsageStatus.NULL, new MedicationUsage.MedicationUsageStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.getStatusReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateAsserted")) {
        res.setDateAssertedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSource")) {
        res.setInformationSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
        res.getDerivedFrom().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.getDosage().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("takenAsOrdered")) {
        res.setTakenAsOrderedElement(parseBoolean(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition parseMedicinalProductDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition res = new MedicinalProductDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("domain")) {
        res.setDomain(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("combinedPharmaceuticalDoseForm")) {
        res.setCombinedPharmaceuticalDoseForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
        res.setIndicationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legalStatusOfSupply")) {
        res.setLegalStatusOfSupply(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalMonitoringIndicator")) {
        res.setAdditionalMonitoringIndicator(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialMeasure")) {
        res.getSpecialMeasure().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("paediatricUseIndicator")) {
        res.setPaediatricUseIndicator(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productClassification")) {
        res.getProductClassification().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("marketingStatus")) {
        res.getMarketingStatus().add(parseMarketingStatus(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pharmaceuticalProduct")) {
        res.getPharmaceuticalProduct().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packagedMedicinalProduct")) {
        res.getPackagedMedicinalProduct().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attachedDocument")) {
        res.getAttachedDocument().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterFile")) {
        res.getMasterFile().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseMedicinalProductDefinitionMedicinalProductDefinitionContactComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalTrial")) {
        res.getClinicalTrial().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.getName().add(parseMedicinalProductDefinitionMedicinalProductDefinitionNameComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("crossReference")) {
        res.getCrossReference().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturingBusinessOperation")) {
        res.getManufacturingBusinessOperation().add(parseMedicinalProductDefinitionMedicinalProductDefinitionManufacturingBusinessOperationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialDesignation")) {
        res.getSpecialDesignation().add(parseMedicinalProductDefinitionMedicinalProductDefinitionSpecialDesignationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionContactComponent parseMedicinalProductDefinitionMedicinalProductDefinitionContactComponent(XmlPullParser xpp, MedicinalProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionContactComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionContactComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionMedicinalProductDefinitionContactComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionMedicinalProductDefinitionContactComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition owner, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.setContact(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameComponent parseMedicinalProductDefinitionMedicinalProductDefinitionNameComponent(XmlPullParser xpp, MedicinalProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionMedicinalProductDefinitionNameComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionMedicinalProductDefinitionNameComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition owner, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productName")) {
        res.setProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("namePart")) {
        res.getNamePart().add(parseMedicinalProductDefinitionMedicinalProductDefinitionNameNamePartComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("countryLanguage")) {
        res.getCountryLanguage().add(parseMedicinalProductDefinitionMedicinalProductDefinitionNameCountryLanguageComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent parseMedicinalProductDefinitionMedicinalProductDefinitionNameNamePartComponent(XmlPullParser xpp, MedicinalProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionMedicinalProductDefinitionNameNamePartComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionMedicinalProductDefinitionNameNamePartComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition owner, MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
        res.setPartElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent parseMedicinalProductDefinitionMedicinalProductDefinitionNameCountryLanguageComponent(XmlPullParser xpp, MedicinalProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionMedicinalProductDefinitionNameCountryLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionMedicinalProductDefinitionNameCountryLanguageComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition owner, MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
        res.setCountry(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.setJurisdiction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguage(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent parseMedicinalProductDefinitionMedicinalProductDefinitionManufacturingBusinessOperationComponent(XmlPullParser xpp, MedicinalProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionMedicinalProductDefinitionManufacturingBusinessOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionMedicinalProductDefinitionManufacturingBusinessOperationComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition owner, MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationType")) {
        res.setOperationType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorisationReferenceNumber")) {
        res.setAuthorisationReferenceNumber(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectiveDate")) {
        res.setEffectiveDate(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("confidentialityIndicator")) {
        res.setConfidentialityIndicator(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.getManufacturer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("regulator")) {
        res.setRegulator(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionSpecialDesignationComponent parseMedicinalProductDefinitionMedicinalProductDefinitionSpecialDesignationComponent(XmlPullParser xpp, MedicinalProductDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionSpecialDesignationComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionSpecialDesignationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicinalProductDefinitionMedicinalProductDefinitionSpecialDesignationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionMedicinalProductDefinitionSpecialDesignationComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition owner, MedicinalProductDefinition.MedicinalProductDefinitionSpecialDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedUse")) {
        res.setIntendedUse(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "indication")) {
        res.setIndication(parseType("indication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("species")) {
        res.setSpecies(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageDefinition parseMessageDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionContent(int eventType, XmlPullParser xpp, MessageDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
        res.setBaseElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.getParent().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "event")) {
        res.setEvent(parseType("event", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategoryElement(parseEnumeration(xpp, MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.getFocus().add(parseMessageDefinitionMessageDefinitionFocusComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responseRequired")) {
        res.setResponseRequiredElement(parseEnumeration(xpp, MessageDefinition.MessageheaderResponseRequest.NULL, new MessageDefinition.MessageheaderResponseRequestEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allowedResponse")) {
        res.getAllowedResponse().add(parseMessageDefinitionMessageDefinitionAllowedResponseComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("graph")) {
        res.getGraph().add(parseCanonical(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageDefinitionMessageDefinitionFocusComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionMessageDefinitionFocusComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("message")) {
        res.setMessageElement(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("situation")) {
        res.setSituationElement(parseMarkdown(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderContent(int eventType, XmlPullParser xpp, MessageHeader res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "event")) {
        res.setEvent(parseType("event", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
        res.setSender(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseMessageHeaderMessageSourceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsible(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseMessageHeaderMessageHeaderResponseComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.getFocus().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseCanonical(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderMessageDestinationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageDestinationComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.setEndpointElement(parseUrl(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.setReceiver(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderMessageSourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageSourceComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
        res.setSoftwareElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.setContact(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.setEndpointElement(parseUrl(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderMessageHeaderResponseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageHeaderResponseComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifierElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("details")) {
        res.setDetails(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence parseMolecularSequence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence res = new MolecularSequence();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceContent(int eventType, XmlPullParser xpp, MolecularSequence res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, MolecularSequence.SequenceType.NULL, new MolecularSequence.SequenceTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coordinateSystem")) {
        res.setCoordinateSystemElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.setSpecimen(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeq")) {
        res.setReferenceSeq(parseMolecularSequenceMolecularSequenceReferenceSeqComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variant")) {
        res.getVariant().add(parseMolecularSequenceMolecularSequenceVariantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observedSeq")) {
        res.setObservedSeqElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quality")) {
        res.getQuality().add(parseMolecularSequenceMolecularSequenceQualityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readCoverage")) {
        res.setReadCoverageElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repository")) {
        res.getRepository().add(parseMolecularSequenceMolecularSequenceRepositoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pointer")) {
        res.getPointer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("structureVariant")) {
        res.getStructureVariant().add(parseMolecularSequenceMolecularSequenceStructureVariantComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceReferenceSeqComponent parseMolecularSequenceMolecularSequenceReferenceSeqComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceReferenceSeqComponent res = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceReferenceSeqComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceReferenceSeqComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceReferenceSeqComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("chromosome")) {
        res.setChromosome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("genomeBuild")) {
        res.setGenomeBuildElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orientation")) {
        res.setOrientationElement(parseEnumeration(xpp, MolecularSequence.OrientationType.NULL, new MolecularSequence.OrientationTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqId")) {
        res.setReferenceSeqId(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqPointer")) {
        res.setReferenceSeqPointer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqString")) {
        res.setReferenceSeqStringElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strand")) {
        res.setStrandElement(parseEnumeration(xpp, MolecularSequence.StrandType.NULL, new MolecularSequence.StrandTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("windowStart")) {
        res.setWindowStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("windowEnd")) {
        res.setWindowEndElement(parseInteger(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceVariantComponent parseMolecularSequenceMolecularSequenceVariantComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceVariantComponent res = new MolecularSequence.MolecularSequenceVariantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceVariantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceVariantComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observedAllele")) {
        res.setObservedAlleleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceAllele")) {
        res.setReferenceAlleleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cigar")) {
        res.setCigarElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantPointer")) {
        res.setVariantPointer(parseReference(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceQualityComponent parseMolecularSequenceMolecularSequenceQualityComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityComponent res = new MolecularSequence.MolecularSequenceQualityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceQualityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceQualityComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceQualityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, MolecularSequence.QualityType.NULL, new MolecularSequence.QualityTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("standardSequence")) {
        res.setStandardSequence(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.setScore(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("truthTP")) {
        res.setTruthTPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("queryTP")) {
        res.setQueryTPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("truthFN")) {
        res.setTruthFNElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("queryFP")) {
        res.setQueryFPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gtFP")) {
        res.setGtFPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
        res.setPrecisionElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recall")) {
        res.setRecallElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fScore")) {
        res.setFScoreElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("roc")) {
        res.setRoc(parseMolecularSequenceMolecularSequenceQualityRocComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceQualityRocComponent parseMolecularSequenceMolecularSequenceQualityRocComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityRocComponent res = new MolecularSequence.MolecularSequenceQualityRocComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceQualityRocComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceQualityRocComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceQualityRocComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.getScore().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numTP")) {
        res.getNumTP().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numFP")) {
        res.getNumFP().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numFN")) {
        res.getNumFN().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
        res.getPrecision().add(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sensitivity")) {
        res.getSensitivity().add(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fMeasure")) {
        res.getFMeasure().add(parseDecimal(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceRepositoryComponent parseMolecularSequenceMolecularSequenceRepositoryComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceRepositoryComponent res = new MolecularSequence.MolecularSequenceRepositoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceRepositoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceRepositoryComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceRepositoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, MolecularSequence.RepositoryType.NULL, new MolecularSequence.RepositoryTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("datasetId")) {
        res.setDatasetIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantsetId")) {
        res.setVariantsetIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readsetId")) {
        res.setReadsetIdElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceStructureVariantComponent parseMolecularSequenceMolecularSequenceStructureVariantComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantComponent res = new MolecularSequence.MolecularSequenceStructureVariantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceStructureVariantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceStructureVariantComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantType")) {
        res.setVariantType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exact")) {
        res.setExactElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("length")) {
        res.setLengthElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outer")) {
        res.setOuter(parseMolecularSequenceMolecularSequenceStructureVariantOuterComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inner")) {
        res.setInner(parseMolecularSequenceMolecularSequenceStructureVariantInnerComponent(xpp, owner));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceStructureVariantOuterComponent parseMolecularSequenceMolecularSequenceStructureVariantOuterComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantOuterComponent res = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceStructureVariantOuterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceStructureVariantOuterComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantOuterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MolecularSequence.MolecularSequenceStructureVariantInnerComponent parseMolecularSequenceMolecularSequenceStructureVariantInnerComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantInnerComponent res = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMolecularSequenceMolecularSequenceStructureVariantInnerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceMolecularSequenceStructureVariantInnerComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantInnerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNamingSystemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNamingSystemContent(int eventType, XmlPullParser xpp, NamingSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsibleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uniqueId")) {
        res.getUniqueId().add(parseNamingSystemNamingSystemUniqueIdComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNamingSystemNamingSystemUniqueIdComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNamingSystemNamingSystemUniqueIdComponentContent(int eventType, XmlPullParser xpp, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preferred")) {
        res.setPreferredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionIntake parseNutritionIntake(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionIntake res = new NutritionIntake();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionIntakeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionIntakeContent(int eventType, XmlPullParser xpp, NutritionIntake res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, NutritionIntake.NutritionIntakeStatus.NULL, new NutritionIntake.NutritionIntakeStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.getStatusReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("consumedItem")) {
        res.getConsumedItem().add(parseNutritionIntakeNutritionIntakeConsumedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredientLabel")) {
        res.getIngredientLabel().add(parseNutritionIntakeNutritionIntakeIngredientLabelComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateAsserted")) {
        res.setDateAssertedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSource")) {
        res.setInformationSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
        res.getDerivedFrom().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionIntake.NutritionIntakeConsumedItemComponent parseNutritionIntakeNutritionIntakeConsumedItemComponent(XmlPullParser xpp, NutritionIntake owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionIntake.NutritionIntakeConsumedItemComponent res = new NutritionIntake.NutritionIntakeConsumedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionIntakeNutritionIntakeConsumedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionIntakeNutritionIntakeConsumedItemComponentContent(int eventType, XmlPullParser xpp, NutritionIntake owner, NutritionIntake.NutritionIntakeConsumedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nutritionProduct")) {
        res.setNutritionProduct(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.setSchedule(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rate")) {
        res.setRate(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notConsumed")) {
        res.setNotConsumedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notConsumedReason")) {
        res.setNotConsumedReason(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionIntake.NutritionIntakeIngredientLabelComponent parseNutritionIntakeNutritionIntakeIngredientLabelComponent(XmlPullParser xpp, NutritionIntake owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionIntake.NutritionIntakeIngredientLabelComponent res = new NutritionIntake.NutritionIntakeIngredientLabelComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionIntakeNutritionIntakeIngredientLabelComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionIntakeNutritionIntakeIngredientLabelComponentContent(int eventType, XmlPullParser xpp, NutritionIntake owner, NutritionIntake.NutritionIntakeIngredientLabelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nutrient")) {
        res.setNutrient(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseQuantity(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderContent(int eventType, XmlPullParser xpp, NutritionOrder res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
        res.getInstantiatesCanonical().add(parseCanonical(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
        res.getInstantiatesUri().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
        res.getInstantiates().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, NutritionOrder.NutritiionOrderIntent.NULL, new NutritionOrder.NutritiionOrderIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateTime")) {
        res.setDateTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderer")) {
        res.setOrderer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergyIntolerance")) {
        res.getAllergyIntolerance().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("foodPreferenceModifier")) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludeFoodModifier")) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("oralDiet")) {
        res.setOralDiet(parseNutritionOrderNutritionOrderOralDietComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplement")) {
        res.getSupplement().add(parseNutritionOrderNutritionOrderSupplementComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enteralFormula")) {
        res.setEnteralFormula(parseNutritionOrderNutritionOrderEnteralFormulaComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderOralDietComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderOralDietComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.getSchedule().add(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nutrient")) {
        res.getNutrient().add(parseNutritionOrderNutritionOrderOralDietNutrientComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("texture")) {
        res.getTexture().add(parseNutritionOrderNutritionOrderOralDietTextureComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fluidConsistencyType")) {
        res.getFluidConsistencyType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
        res.setInstructionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.setModifier(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseQuantity(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderOralDietTextureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderOralDietTextureComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.setModifier(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("foodType")) {
        res.setFoodType(parseCodeableConcept(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderSupplementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderSupplementComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productName")) {
        res.setProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.getSchedule().add(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
        res.setInstructionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseFormulaType")) {
        res.setBaseFormulaType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseFormulaProductName")) {
        res.setBaseFormulaProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additiveType")) {
        res.setAdditiveType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additiveProductName")) {
        res.setAdditiveProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("caloricDensity")) {
        res.setCaloricDensity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("routeofAdministration")) {
        res.setRouteofAdministration(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administration")) {
        res.getAdministration().add(parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxVolumeToDeliver")) {
        res.setMaxVolumeToDeliver(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrationInstruction")) {
        res.setAdministrationInstructionElement(parseString(xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.setSchedule(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
        res.setRate(parseType("rate", xpp));
      } else if (!parseBackboneElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Observation parseObservation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation res = new Observation();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseObservationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationContent(int eventType, XmlPullParser xpp, Observation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.getFocus().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
        res.setDataAbsentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpretation")) {
        res.getInterpretation().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.setSpecimen(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceRange")) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hasMember")) {
        res.getHasMember().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
        res.getDerivedFrom().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
        res.getComponent().add(parseObservationObservationComponentComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

 