/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.client.network;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.utils.client.EFhirClientException;
import org.hl7.fhir.r4.utils.client.network.ByteUtils;
import org.hl7.fhir.r4.utils.client.network.FhirRequestBuilder;
import org.hl7.fhir.r4.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPRequest;

public class Client {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private ToolingClientLogger logger;
    private int retryCount;
    private String base;

    public <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI optionsUri, String resourceFormat, String message, long timeout) throws IOException {
        HTTPRequest request = new HTTPRequest().withUrl(optionsUri.toURL()).withMethod(HTTPRequest.HttpMethod.OPTIONS);
        return this.executeFhirRequest(request, resourceFormat, Collections.emptyList(), message, this.retryCount, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI resourceUri, String resourceFormat, Iterable<HTTPHeader> headers, String message, long timeout) throws IOException {
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.GET);
        return this.executeFhirRequest(request, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, long timeout) throws IOException {
        return this.issuePutRequest(resourceUri, payload, resourceFormat, Collections.emptyList(), message, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, Iterable<HTTPHeader> headers, String message, long timeout) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("PUT requests require a non-null payload");
        }
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.PUT).withBody(payload).withContentType(Client.getContentTypeWithDefaultCharset(resourceFormat));
        return this.executeFhirRequest(request, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, long timeout) throws IOException {
        return this.issuePostRequest(resourceUri, payload, resourceFormat, Collections.emptyList(), message, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, Iterable<HTTPHeader> headers, String message, long timeout) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("POST requests require a non-null payload");
        }
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.POST).withBody(payload).withContentType(Client.getContentTypeWithDefaultCharset(resourceFormat));
        return this.executeFhirRequest(request, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public boolean issueDeleteRequest(URI resourceUri, int timeout) throws IOException {
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.DELETE);
        return this.executeFhirRequest(request, null, Collections.emptyList(), null, this.retryCount, timeout).isSuccessfulRequest();
    }

    public Bundle issueGetFeedRequest(URI resourceUri, String resourceFormat, int timeout) throws IOException {
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.GET);
        return this.executeBundleRequest(request, resourceFormat, Collections.emptyList(), null, this.retryCount, timeout);
    }

    public Bundle issuePostFeedRequest(URI resourceUri, Map<String, String> parameters, String resourceName, Resource resource, String resourceFormat, int timeout) throws IOException {
        String boundary = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        byte[] payload = ByteUtils.encodeFormSubmission(parameters, resourceName, resource, boundary);
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.POST).withBody(payload).withContentType(Client.getContentTypeWithDefaultCharset(resourceFormat));
        return this.executeBundleRequest(request, resourceFormat, Collections.emptyList(), null, this.retryCount, timeout);
    }

    public Bundle postBatchRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, int timeout) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("POST requests require a non-null payload");
        }
        HTTPRequest request = new HTTPRequest().withUrl(resourceUri.toURL()).withMethod(HTTPRequest.HttpMethod.POST).withBody(payload).withContentType(Client.getContentTypeWithDefaultCharset(resourceFormat));
        return this.executeBundleRequest(request, resourceFormat, Collections.emptyList(), message, this.retryCount, timeout);
    }

    private static String getContentTypeWithDefaultCharset(String resourceFormat) {
        return resourceFormat + ";charset=UTF-8";
    }

    public <T extends Resource> Bundle executeBundleRequest(HTTPRequest request, String resourceFormat, Iterable<HTTPHeader> headers, String message, int retryCount, long timeout) throws IOException {
        return new FhirRequestBuilder(request, this.base).withLogger(this.logger).withResourceFormat(resourceFormat).withRetryCount(retryCount).withMessage(message).withHeaders(headers == null ? Collections.emptyList() : headers).withTimeout(timeout, TimeUnit.MILLISECONDS).executeAsBatch();
    }

    public <T extends Resource> ResourceRequest<T> executeFhirRequest(HTTPRequest request, String resourceFormat, Iterable<HTTPHeader> headers, String message, int retryCount, long timeout) throws IOException {
        return new FhirRequestBuilder(request, this.base).withLogger(this.logger).withResourceFormat(resourceFormat).withRetryCount(retryCount).withMessage(message).withHeaders(headers == null ? Collections.emptyList() : headers).withTimeout(timeout, TimeUnit.MILLISECONDS).execute();
    }

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ToolingClientLogger logger) {
        this.logger = logger;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }
}

