/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.UdiEntryType;

public class UdiEntryTypeEnumFactory
implements EnumFactory<UdiEntryType> {
    @Override
    public UdiEntryType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("barcode".equals(codeString)) {
            return UdiEntryType.BARCODE;
        }
        if ("rfid".equals(codeString)) {
            return UdiEntryType.RFID;
        }
        if ("manual".equals(codeString)) {
            return UdiEntryType.MANUAL;
        }
        if ("card".equals(codeString)) {
            return UdiEntryType.CARD;
        }
        if ("self-reported".equals(codeString)) {
            return UdiEntryType.SELFREPORTED;
        }
        if ("unknown".equals(codeString)) {
            return UdiEntryType.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown UdiEntryType code '" + codeString + "'");
    }

    @Override
    public String toCode(UdiEntryType code) {
        if (code == UdiEntryType.NULL) {
            return null;
        }
        if (code == UdiEntryType.BARCODE) {
            return "barcode";
        }
        if (code == UdiEntryType.RFID) {
            return "rfid";
        }
        if (code == UdiEntryType.MANUAL) {
            return "manual";
        }
        if (code == UdiEntryType.CARD) {
            return "card";
        }
        if (code == UdiEntryType.SELFREPORTED) {
            return "self-reported";
        }
        if (code == UdiEntryType.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(UdiEntryType code) {
        return code.getSystem();
    }
}

