/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ExpressionLanguage;

public class ExpressionLanguageEnumFactory
implements EnumFactory<ExpressionLanguage> {
    @Override
    public ExpressionLanguage fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("text/cql".equals(codeString)) {
            return ExpressionLanguage.TEXT_CQL;
        }
        if ("text/fhirpath".equals(codeString)) {
            return ExpressionLanguage.TEXT_FHIRPATH;
        }
        if ("application/x-fhir-query".equals(codeString)) {
            return ExpressionLanguage.APPLICATION_XFHIRQUERY;
        }
        throw new IllegalArgumentException("Unknown ExpressionLanguage code '" + codeString + "'");
    }

    @Override
    public String toCode(ExpressionLanguage code) {
        if (code == ExpressionLanguage.NULL) {
            return null;
        }
        if (code == ExpressionLanguage.TEXT_CQL) {
            return "text/cql";
        }
        if (code == ExpressionLanguage.TEXT_FHIRPATH) {
            return "text/fhirpath";
        }
        if (code == ExpressionLanguage.APPLICATION_XFHIRQUERY) {
            return "application/x-fhir-query";
        }
        return "?";
    }

    @Override
    public String toSystem(ExpressionLanguage code) {
        return code.getSystem();
    }
}

