/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExamplescenarioActorType {
    PERSON,
    ENTITY,
    NULL;


    public static ExamplescenarioActorType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("person".equals(codeString)) {
            return PERSON;
        }
        if ("entity".equals(codeString)) {
            return ENTITY;
        }
        throw new FHIRException("Unknown ExamplescenarioActorType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PERSON: {
                return "person";
            }
            case ENTITY: {
                return "entity";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/examplescenario-actor-type";
    }

    public String getDefinition() {
        switch (this) {
            case PERSON: {
                return "A person.";
            }
            case ENTITY: {
                return "A system.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PERSON: {
                return "Person";
            }
            case ENTITY: {
                return "System";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

