/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.DiagnosisRole;

public class DiagnosisRoleEnumFactory
implements EnumFactory<DiagnosisRole> {
    @Override
    public DiagnosisRole fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AD".equals(codeString)) {
            return DiagnosisRole.AD;
        }
        if ("DD".equals(codeString)) {
            return DiagnosisRole.DD;
        }
        if ("CC".equals(codeString)) {
            return DiagnosisRole.CC;
        }
        if ("CM".equals(codeString)) {
            return DiagnosisRole.CM;
        }
        if ("pre-op".equals(codeString)) {
            return DiagnosisRole.PREOP;
        }
        if ("post-op".equals(codeString)) {
            return DiagnosisRole.POSTOP;
        }
        if ("billing".equals(codeString)) {
            return DiagnosisRole.BILLING;
        }
        throw new IllegalArgumentException("Unknown DiagnosisRole code '" + codeString + "'");
    }

    @Override
    public String toCode(DiagnosisRole code) {
        if (code == DiagnosisRole.NULL) {
            return null;
        }
        if (code == DiagnosisRole.AD) {
            return "AD";
        }
        if (code == DiagnosisRole.DD) {
            return "DD";
        }
        if (code == DiagnosisRole.CC) {
            return "CC";
        }
        if (code == DiagnosisRole.CM) {
            return "CM";
        }
        if (code == DiagnosisRole.PREOP) {
            return "pre-op";
        }
        if (code == DiagnosisRole.POSTOP) {
            return "post-op";
        }
        if (code == DiagnosisRole.BILLING) {
            return "billing";
        }
        return "?";
    }

    @Override
    public String toSystem(DiagnosisRole code) {
        return code.getSystem();
    }
}

