/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ActivityDefinitionCategory;

public class ActivityDefinitionCategoryEnumFactory
implements EnumFactory<ActivityDefinitionCategory> {
    @Override
    public ActivityDefinitionCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("treatment".equals(codeString)) {
            return ActivityDefinitionCategory.TREATMENT;
        }
        if ("education".equals(codeString)) {
            return ActivityDefinitionCategory.EDUCATION;
        }
        if ("assessment".equals(codeString)) {
            return ActivityDefinitionCategory.ASSESSMENT;
        }
        throw new IllegalArgumentException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ActivityDefinitionCategory code) {
        if (code == ActivityDefinitionCategory.NULL) {
            return null;
        }
        if (code == ActivityDefinitionCategory.TREATMENT) {
            return "treatment";
        }
        if (code == ActivityDefinitionCategory.EDUCATION) {
            return "education";
        }
        if (code == ActivityDefinitionCategory.ASSESSMENT) {
            return "assessment";
        }
        return "?";
    }

    @Override
    public String toSystem(ActivityDefinitionCategory code) {
        return code.getSystem();
    }
}

