/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActivityDefinitionCategory {
    TREATMENT,
    EDUCATION,
    ASSESSMENT,
    NULL;


    public static ActivityDefinitionCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("treatment".equals(codeString)) {
            return TREATMENT;
        }
        if ("education".equals(codeString)) {
            return EDUCATION;
        }
        if ("assessment".equals(codeString)) {
            return ASSESSMENT;
        }
        throw new FHIRException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TREATMENT: {
                return "treatment";
            }
            case EDUCATION: {
                return "education";
            }
            case ASSESSMENT: {
                return "assessment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/activity-definition-category";
    }

    public String getDefinition() {
        switch (this) {
            case TREATMENT: {
                return "The activity is intended to provide or is related to treatment of the patient.";
            }
            case EDUCATION: {
                return "The activity is intended to provide or is related to education of the patient.";
            }
            case ASSESSMENT: {
                return "The activity is intended to perform or is related to assessment of the patient.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TREATMENT: {
                return "Treatment";
            }
            case EDUCATION: {
                return "Education";
            }
            case ASSESSMENT: {
                return "Assessment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

