/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MessageDefinition", profile="http://hl7.org/fhir/StructureDefinition/MessageDefinition")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "replaces", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "copyright", "base", "parent", "event[x]", "category", "focus", "responseRequired", "allowedResponse", "graph"})
public class MessageDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Primary key for the message definition on a given server", formalDefinition="A formal identifier that is used to identify this message definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="replaces", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Takes the place of", formalDefinition="A MessageDefinition that is superseded by this definition.")
    protected List<CanonicalType> replaces;
    @Child(name="purpose", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why this message definition is defined", formalDefinition="Explanation of why this message definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the message definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the message definition.")
    protected MarkdownType copyright;
    @Child(name="base", type={CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Definition this one is based on", formalDefinition="The MessageDefinition that is the basis for the contents of this resource.")
    protected CanonicalType base;
    @Child(name="parent", type={CanonicalType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Protocol/workflow this is part of", formalDefinition="Identifies a protocol or workflow that this MessageDefinition represents a step in.")
    protected List<CanonicalType> parent;
    @Child(name="event", type={Coding.class, UriType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Event code  or link to the EventDefinition", formalDefinition="Event code or link to the EventDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-events")
    protected Type event;
    @Child(name="category", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="consequence | currency | notification", formalDefinition="The impact of the content of the message.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-significance-category")
    protected Enumeration<MessageSignificanceCategory> category;
    @Child(name="focus", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource(s) that are the subject of the event", formalDefinition="Identifies the resource (or resources) that are being addressed by the event.  For example, the Encounter for an admit message or two Account records for a merge.")
    protected List<MessageDefinitionFocusComponent> focus;
    @Child(name="responseRequired", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="always | on-error | never | on-success", formalDefinition="Declare at a message definition level whether a response is required or only upon error or success, or never.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/messageheader-response-request")
    protected Enumeration<MessageheaderResponseRequest> responseRequired;
    @Child(name="allowedResponse", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Responses to this message", formalDefinition="Indicates what types of messages may be sent as an application-level response to this message.")
    protected List<MessageDefinitionAllowedResponseComponent> allowedResponse;
    @Child(name="graph", type={CanonicalType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Canonical reference to a GraphDefinition", formalDefinition="Canonical reference to a GraphDefinition. If a URL is provided, it is the canonical reference to a [[[GraphDefinition]]] that it controls what resources are to be added to the bundle when building the document. The GraphDefinition can also specify profiles that apply to the various resources.")
    protected List<CanonicalType> graph;
    private static final long serialVersionUID = 927775347L;
    @SearchParamDefinition(name="date", path="MessageDefinition.date", description="The message definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="MessageDefinition.identifier", description="External identifier for the message definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="parent", path="MessageDefinition.parent", description="A resource that is the parent of the definition", type="reference", target={ActivityDefinition.class, PlanDefinition.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("MessageDefinition:parent").toLocked();
    @SearchParamDefinition(name="context-type-value", path="MessageDefinition.useContext", description="A use context type and value assigned to the message definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="MessageDefinition.jurisdiction", description="Intended jurisdiction for the message definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="MessageDefinition.description", description="The description of the message definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="focus", path="MessageDefinition.focus.code", description="A resource that is a permitted focus of the message", type="token")
    public static final String SP_FOCUS = "focus";
    public static final TokenClientParam FOCUS = new TokenClientParam("focus");
    @SearchParamDefinition(name="context-type", path="MessageDefinition.useContext.code", description="A type of use context assigned to the message definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="MessageDefinition.title", description="The human-friendly name of the message definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="MessageDefinition.version", description="The business version of the message definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="MessageDefinition.url", description="The uri that identifies the message definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the message definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="name", path="MessageDefinition.name", description="Computationally friendly name of the message definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(MessageDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the message definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="MessageDefinition.publisher", description="Name of the publisher of the message definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="event", path="MessageDefinition.event", description="The event that triggers the message or link to the event definition.", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="category", path="MessageDefinition.category", description="The behavior associated with the message", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="context-type-quantity", path="MessageDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the message definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="MessageDefinition.status", description="The current status of the message definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MessageDefinition() {
    }

    public MessageDefinition(Enumeration<Enumerations.PublicationStatus> status, DateTimeType date, Type event) {
        this.status = status;
        this.date = date;
        this.event = event;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public MessageDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public MessageDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MessageDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MessageDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public MessageDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public MessageDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public MessageDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public MessageDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public MessageDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public MessageDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        return this.replaces;
    }

    public MessageDefinition setReplaces(List<CanonicalType> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (CanonicalType item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addReplacesElement() {
        CanonicalType t = new CanonicalType();
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        this.replaces.add(t);
        return t;
    }

    public MessageDefinition addReplaces(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        this.replaces.add(t);
        return this;
    }

    public boolean hasReplaces(String value) {
        if (this.replaces == null) {
            return false;
        }
        for (CanonicalType v : this.replaces) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public MessageDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public MessageDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public MessageDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public MessageDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public MessageDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public MessageDefinition setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public MessageDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public MessageDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public MessageDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public MessageDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public MessageDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public MessageDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public MessageDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public MessageDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public MessageDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public MessageDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public MessageDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public MessageDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public MessageDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public MessageDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public CanonicalType getBaseElement() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new CanonicalType();
            }
        }
        return this.base;
    }

    public boolean hasBaseElement() {
        return this.base != null && !this.base.isEmpty();
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public MessageDefinition setBaseElement(CanonicalType value) {
        this.base = value;
        return this;
    }

    public String getBase() {
        return this.base == null ? null : (String)this.base.getValue();
    }

    public MessageDefinition setBase(String value) {
        if (Utilities.noString((String)value)) {
            this.base = null;
        } else {
            if (this.base == null) {
                this.base = new CanonicalType();
            }
            this.base.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<CanonicalType>();
        }
        return this.parent;
    }

    public MessageDefinition setParent(List<CanonicalType> theParent) {
        this.parent = theParent;
        return this;
    }

    public boolean hasParent() {
        if (this.parent == null) {
            return false;
        }
        for (CanonicalType item : this.parent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addParentElement() {
        CanonicalType t = new CanonicalType();
        if (this.parent == null) {
            this.parent = new ArrayList<CanonicalType>();
        }
        this.parent.add(t);
        return t;
    }

    public MessageDefinition addParent(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.parent == null) {
            this.parent = new ArrayList<CanonicalType>();
        }
        this.parent.add(t);
        return this;
    }

    public boolean hasParent(String value) {
        if (this.parent == null) {
            return false;
        }
        for (CanonicalType v : this.parent) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Type getEvent() {
        return this.event;
    }

    public Coding getEventCoding() throws FHIRException {
        if (this.event == null) {
            this.event = new Coding();
        }
        if (!(this.event instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.event.getClass().getName() + " was encountered");
        }
        return (Coding)this.event;
    }

    public boolean hasEventCoding() {
        return this.event instanceof Coding;
    }

    public UriType getEventUriType() throws FHIRException {
        if (this.event == null) {
            this.event = new UriType();
        }
        if (!(this.event instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.event.getClass().getName() + " was encountered");
        }
        return (UriType)this.event;
    }

    public boolean hasEventUriType() {
        return this.event instanceof UriType;
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public MessageDefinition setEvent(Type value) {
        if (value != null && !(value instanceof Coding) && !(value instanceof UriType)) {
            throw new Error("Not the right type for MessageDefinition.event[x]: " + value.fhirType());
        }
        this.event = value;
        return this;
    }

    public Enumeration<MessageSignificanceCategory> getCategoryElement() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new Enumeration<MessageSignificanceCategory>(new MessageSignificanceCategoryEnumFactory());
            }
        }
        return this.category;
    }

    public boolean hasCategoryElement() {
        return this.category != null && !this.category.isEmpty();
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public MessageDefinition setCategoryElement(Enumeration<MessageSignificanceCategory> value) {
        this.category = value;
        return this;
    }

    public MessageSignificanceCategory getCategory() {
        return this.category == null ? null : (MessageSignificanceCategory)((Object)this.category.getValue());
    }

    public MessageDefinition setCategory(MessageSignificanceCategory value) {
        if (value == null) {
            this.category = null;
        } else {
            if (this.category == null) {
                this.category = new Enumeration<MessageSignificanceCategory>(new MessageSignificanceCategoryEnumFactory());
            }
            this.category.setValue((Object)value);
        }
        return this;
    }

    public List<MessageDefinitionFocusComponent> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<MessageDefinitionFocusComponent>();
        }
        return this.focus;
    }

    public MessageDefinition setFocus(List<MessageDefinitionFocusComponent> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (MessageDefinitionFocusComponent item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MessageDefinitionFocusComponent addFocus() {
        MessageDefinitionFocusComponent t = new MessageDefinitionFocusComponent();
        if (this.focus == null) {
            this.focus = new ArrayList<MessageDefinitionFocusComponent>();
        }
        this.focus.add(t);
        return t;
    }

    public MessageDefinition addFocus(MessageDefinitionFocusComponent t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<MessageDefinitionFocusComponent>();
        }
        this.focus.add(t);
        return this;
    }

    public MessageDefinitionFocusComponent getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public Enumeration<MessageheaderResponseRequest> getResponseRequiredElement() {
        if (this.responseRequired == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageDefinition.responseRequired");
            }
            if (Configuration.doAutoCreate()) {
                this.responseRequired = new Enumeration<MessageheaderResponseRequest>(new MessageheaderResponseRequestEnumFactory());
            }
        }
        return this.responseRequired;
    }

    public boolean hasResponseRequiredElement() {
        return this.responseRequired != null && !this.responseRequired.isEmpty();
    }

    public boolean hasResponseRequired() {
        return this.responseRequired != null && !this.responseRequired.isEmpty();
    }

    public MessageDefinition setResponseRequiredElement(Enumeration<MessageheaderResponseRequest> value) {
        this.responseRequired = value;
        return this;
    }

    public MessageheaderResponseRequest getResponseRequired() {
        return this.responseRequired == null ? null : (MessageheaderResponseRequest)((Object)this.responseRequired.getValue());
    }

    public MessageDefinition setResponseRequired(MessageheaderResponseRequest value) {
        if (value == null) {
            this.responseRequired = null;
        } else {
            if (this.responseRequired == null) {
                this.responseRequired = new Enumeration<MessageheaderResponseRequest>(new MessageheaderResponseRequestEnumFactory());
            }
            this.responseRequired.setValue((Object)value);
        }
        return this;
    }

    public List<MessageDefinitionAllowedResponseComponent> getAllowedResponse() {
        if (this.allowedResponse == null) {
            this.allowedResponse = new ArrayList<MessageDefinitionAllowedResponseComponent>();
        }
        return this.allowedResponse;
    }

    public MessageDefinition setAllowedResponse(List<MessageDefinitionAllowedResponseComponent> theAllowedResponse) {
        this.allowedResponse = theAllowedResponse;
        return this;
    }

    public boolean hasAllowedResponse() {
        if (this.allowedResponse == null) {
            return false;
        }
        for (MessageDefinitionAllowedResponseComponent item : this.allowedResponse) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MessageDefinitionAllowedResponseComponent addAllowedResponse() {
        MessageDefinitionAllowedResponseComponent t = new MessageDefinitionAllowedResponseComponent();
        if (this.allowedResponse == null) {
            this.allowedResponse = new ArrayList<MessageDefinitionAllowedResponseComponent>();
        }
        this.allowedResponse.add(t);
        return t;
    }

    public MessageDefinition addAllowedResponse(MessageDefinitionAllowedResponseComponent t) {
        if (t == null) {
            return this;
        }
        if (this.allowedResponse == null) {
            this.allowedResponse = new ArrayList<MessageDefinitionAllowedResponseComponent>();
        }
        this.allowedResponse.add(t);
        return this;
    }

    public MessageDefinitionAllowedResponseComponent getAllowedResponseFirstRep() {
        if (this.getAllowedResponse().isEmpty()) {
            this.addAllowedResponse();
        }
        return this.getAllowedResponse().get(0);
    }

    public List<CanonicalType> getGraph() {
        if (this.graph == null) {
            this.graph = new ArrayList<CanonicalType>();
        }
        return this.graph;
    }

    public MessageDefinition setGraph(List<CanonicalType> theGraph) {
        this.graph = theGraph;
        return this;
    }

    public boolean hasGraph() {
        if (this.graph == null) {
            return false;
        }
        for (CanonicalType item : this.graph) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addGraphElement() {
        CanonicalType t = new CanonicalType();
        if (this.graph == null) {
            this.graph = new ArrayList<CanonicalType>();
        }
        this.graph.add(t);
        return t;
    }

    public MessageDefinition addGraph(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.graph == null) {
            this.graph = new ArrayList<CanonicalType>();
        }
        this.graph.add(t);
        return this;
    }

    public boolean hasGraph(String value) {
        if (this.graph == null) {
            return false;
        }
        for (CanonicalType v : this.graph) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "The business identifier that is used to reference the MessageDefinition and *is* expected to be consistent from server to server.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this message definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the message definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the message definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the message definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the message definition.", 0, 1, this.title));
        children.add(new Property("replaces", "canonical(MessageDefinition)", "A MessageDefinition that is superseded by this definition.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property(SP_STATUS, "code", "The status of this message definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this message definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the message definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the message definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the message definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the message definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate message definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the message definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this message definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the message definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the message definition.", 0, 1, this.copyright));
        children.add(new Property("base", "canonical(MessageDefinition)", "The MessageDefinition that is the basis for the contents of this resource.", 0, 1, this.base));
        children.add(new Property(SP_PARENT, "canonical(ActivityDefinition|PlanDefinition)", "Identifies a protocol or workflow that this MessageDefinition represents a step in.", 0, Integer.MAX_VALUE, this.parent));
        children.add(new Property("event[x]", "Coding|uri", "Event code or link to the EventDefinition.", 0, 1, this.event));
        children.add(new Property(SP_CATEGORY, "code", "The impact of the content of the message.", 0, 1, this.category));
        children.add(new Property(SP_FOCUS, "", "Identifies the resource (or resources) that are being addressed by the event.  For example, the Encounter for an admit message or two Account records for a merge.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property("responseRequired", "code", "Declare at a message definition level whether a response is required or only upon error or success, or never.", 0, 1, this.responseRequired));
        children.add(new Property("allowedResponse", "", "Indicates what types of messages may be sent as an application-level response to this message.", 0, Integer.MAX_VALUE, this.allowedResponse));
        children.add(new Property("graph", "canonical(GraphDefinition)", "Canonical reference to a GraphDefinition. If a URL is provided, it is the canonical reference to a [[[GraphDefinition]]] that it controls what resources are to be added to the bundle when building the document. The GraphDefinition can also specify profiles that apply to the various resources.", 0, Integer.MAX_VALUE, this.graph));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "The business identifier that is used to reference the MessageDefinition and *is* expected to be consistent from server to server.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this message definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the message definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the message definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the message definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the message definition.", 0, 1, this.title);
            }
            case -430332865: {
                return new Property("replaces", "canonical(MessageDefinition)", "A MessageDefinition that is superseded by this definition.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this message definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this message definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the message definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the message definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the message definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the message definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate message definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the message definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this message definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the message definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the message definition.", 0, 1, this.copyright);
            }
            case 3016401: {
                return new Property("base", "canonical(MessageDefinition)", "The MessageDefinition that is the basis for the contents of this resource.", 0, 1, this.base);
            }
            case -995424086: {
                return new Property(SP_PARENT, "canonical(ActivityDefinition|PlanDefinition)", "Identifies a protocol or workflow that this MessageDefinition represents a step in.", 0, Integer.MAX_VALUE, this.parent);
            }
            case 278115238: {
                return new Property("event[x]", "Coding|uri", "Event code or link to the EventDefinition.", 0, 1, this.event);
            }
            case 96891546: {
                return new Property("event[x]", "Coding|uri", "Event code or link to the EventDefinition.", 0, 1, this.event);
            }
            case -355957084: {
                return new Property("event[x]", "Coding|uri", "Event code or link to the EventDefinition.", 0, 1, this.event);
            }
            case 278109298: {
                return new Property("event[x]", "Coding|uri", "Event code or link to the EventDefinition.", 0, 1, this.event);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "code", "The impact of the content of the message.", 0, 1, this.category);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "", "Identifies the resource (or resources) that are being addressed by the event.  For example, the Encounter for an admit message or two Account records for a merge.", 0, Integer.MAX_VALUE, this.focus);
            }
            case 791597824: {
                return new Property("responseRequired", "code", "Declare at a message definition level whether a response is required or only upon error or success, or never.", 0, 1, this.responseRequired);
            }
            case -1130933751: {
                return new Property("allowedResponse", "", "Indicates what types of messages may be sent as an application-level response to this message.", 0, Integer.MAX_VALUE, this.allowedResponse);
            }
            case 98615630: {
                return new Property("graph", "canonical(GraphDefinition)", "Canonical reference to a GraphDefinition. If a URL is provided, it is the canonical reference to a [[[GraphDefinition]]] that it controls what resources are to be added to the bundle when building the document. The GraphDefinition can also specify profiles that apply to the various resources.", 0, Integer.MAX_VALUE, this.graph);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 3016401: {
                Base[] baseArray;
                if (this.base == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.base;
                }
                return baseArray;
            }
            case -995424086: {
                return this.parent == null ? new Base[]{} : this.parent.toArray(new Base[this.parent.size()]);
            }
            case 96891546: {
                Base[] baseArray;
                if (this.event == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.event;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.category;
                }
                return baseArray;
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case 791597824: {
                Base[] baseArray;
                if (this.responseRequired == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.responseRequired;
                }
                return baseArray;
            }
            case -1130933751: {
                return this.allowedResponse == null ? new Base[]{} : this.allowedResponse.toArray(new Base[this.allowedResponse.size()]);
            }
            case 98615630: {
                return this.graph == null ? new Base[]{} : this.graph.toArray(new Base[this.graph.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -430332865: {
                this.getReplaces().add(this.castToCanonical(value));
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 3016401: {
                this.base = this.castToCanonical(value);
                return value;
            }
            case -995424086: {
                this.getParent().add(this.castToCanonical(value));
                return value;
            }
            case 96891546: {
                this.event = this.castToType(value);
                return value;
            }
            case 50511102: {
                value = new MessageSignificanceCategoryEnumFactory().fromType(this.castToCode(value));
                this.category = value;
                return value;
            }
            case 97604824: {
                this.getFocus().add((MessageDefinitionFocusComponent)((Object)value));
                return value;
            }
            case 791597824: {
                value = new MessageheaderResponseRequestEnumFactory().fromType(this.castToCode(value));
                this.responseRequired = value;
                return value;
            }
            case -1130933751: {
                this.getAllowedResponse().add((MessageDefinitionAllowedResponseComponent)((Object)value));
                return value;
            }
            case 98615630: {
                this.getGraph().add(this.castToCanonical(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("replaces")) {
            this.getReplaces().add(this.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("base")) {
            this.base = this.castToCanonical(value);
        } else if (name.equals(SP_PARENT)) {
            this.getParent().add(this.castToCanonical(value));
        } else if (name.equals("event[x]")) {
            this.event = this.castToType(value);
        } else if (name.equals(SP_CATEGORY)) {
            value = new MessageSignificanceCategoryEnumFactory().fromType(this.castToCode(value));
            this.category = value;
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add((MessageDefinitionFocusComponent)((Object)value));
        } else if (name.equals("responseRequired")) {
            value = new MessageheaderResponseRequestEnumFactory().fromType(this.castToCode(value));
            this.responseRequired = value;
        } else if (name.equals("allowedResponse")) {
            this.getAllowedResponse().add((MessageDefinitionAllowedResponseComponent)((Object)value));
        } else if (name.equals("graph")) {
            this.getGraph().add(this.castToCanonical(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals("replaces")) {
            this.getReplaces().remove(this.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("base")) {
            this.base = null;
        } else if (name.equals(SP_PARENT)) {
            this.getParent().remove(this.castToCanonical(value));
        } else if (name.equals("event[x]")) {
            this.event = null;
        } else if (name.equals(SP_CATEGORY)) {
            this.category = null;
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().remove((MessageDefinitionFocusComponent)value);
        } else if (name.equals("responseRequired")) {
            this.responseRequired = null;
        } else if (name.equals("allowedResponse")) {
            this.getAllowedResponse().remove((MessageDefinitionAllowedResponseComponent)value);
        } else if (name.equals("graph")) {
            this.getGraph().remove(this.castToCanonical(value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -430332865: {
                return this.addReplacesElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 3016401: {
                return this.getBaseElement();
            }
            case -995424086: {
                return this.addParentElement();
            }
            case 278115238: {
                return this.getEvent();
            }
            case 96891546: {
                return this.getEvent();
            }
            case 50511102: {
                return this.getCategoryElement();
            }
            case 97604824: {
                return this.addFocus();
            }
            case 791597824: {
                return this.getResponseRequiredElement();
            }
            case -1130933751: {
                return this.addAllowedResponse();
            }
            case 98615630: {
                return this.addGraphElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -430332865: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 3016401: {
                return new String[]{"canonical"};
            }
            case -995424086: {
                return new String[]{"canonical"};
            }
            case 96891546: {
                return new String[]{"Coding", "uri"};
            }
            case 50511102: {
                return new String[]{"code"};
            }
            case 97604824: {
                return new String[0];
            }
            case 791597824: {
                return new String[]{"code"};
            }
            case -1130933751: {
                return new String[0];
            }
            case 98615630: {
                return new String[]{"canonical"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.title");
        }
        if (name.equals("replaces")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.replaces");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.copyright");
        }
        if (name.equals("base")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.base");
        }
        if (name.equals(SP_PARENT)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.parent");
        }
        if (name.equals("eventCoding")) {
            this.event = new Coding();
            return this.event;
        }
        if (name.equals("eventUri")) {
            this.event = new UriType();
            return this.event;
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.category");
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals("responseRequired")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.responseRequired");
        }
        if (name.equals("allowedResponse")) {
            return this.addAllowedResponse();
        }
        if (name.equals("graph")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.graph");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MessageDefinition";
    }

    @Override
    public MessageDefinition copy() {
        MessageDefinition dst = new MessageDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MessageDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.replaces != null) {
            dst.replaces = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.replaces) {
                dst.replaces.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        CanonicalType canonicalType = dst.base = this.base == null ? null : this.base.copy();
        if (this.parent != null) {
            dst.parent = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType2 : this.parent) {
                dst.parent.add(canonicalType2.copy());
            }
        }
        dst.event = this.event == null ? null : this.event.copy();
        Enumeration<MessageSignificanceCategory> enumeration = dst.category = this.category == null ? null : this.category.copy();
        if (this.focus != null) {
            dst.focus = new ArrayList<MessageDefinitionFocusComponent>();
            for (MessageDefinitionFocusComponent messageDefinitionFocusComponent : this.focus) {
                dst.focus.add(messageDefinitionFocusComponent.copy());
            }
        }
        Enumeration<MessageheaderResponseRequest> enumeration2 = dst.responseRequired = this.responseRequired == null ? null : this.responseRequired.copy();
        if (this.allowedResponse != null) {
            dst.allowedResponse = new ArrayList<MessageDefinitionAllowedResponseComponent>();
            for (MessageDefinitionAllowedResponseComponent messageDefinitionAllowedResponseComponent : this.allowedResponse) {
                dst.allowedResponse.add(messageDefinitionAllowedResponseComponent.copy());
            }
        }
        if (this.graph != null) {
            dst.graph = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType3 : this.graph) {
                dst.graph.add(canonicalType3.copy());
            }
        }
    }

    protected MessageDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MessageDefinition)) {
            return false;
        }
        MessageDefinition o = (MessageDefinition)other_;
        return MessageDefinition.compareDeep(this.identifier, o.identifier, true) && MessageDefinition.compareDeep(this.replaces, o.replaces, true) && MessageDefinition.compareDeep(this.purpose, o.purpose, true) && MessageDefinition.compareDeep(this.copyright, o.copyright, true) && MessageDefinition.compareDeep(this.base, o.base, true) && MessageDefinition.compareDeep(this.parent, o.parent, true) && MessageDefinition.compareDeep(this.event, o.event, true) && MessageDefinition.compareDeep(this.category, o.category, true) && MessageDefinition.compareDeep(this.focus, o.focus, true) && MessageDefinition.compareDeep(this.responseRequired, o.responseRequired, true) && MessageDefinition.compareDeep(this.allowedResponse, o.allowedResponse, true) && MessageDefinition.compareDeep(this.graph, o.graph, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MessageDefinition)) {
            return false;
        }
        MessageDefinition o = (MessageDefinition)other_;
        return MessageDefinition.compareValues(this.purpose, o.purpose, true) && MessageDefinition.compareValues(this.copyright, o.copyright, true) && MessageDefinition.compareValues(this.category, o.category, true) && MessageDefinition.compareValues(this.responseRequired, o.responseRequired, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.replaces, this.purpose, this.copyright, this.base, this.parent, this.event, this.category, this.focus, this.responseRequired, this.allowedResponse, this.graph});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MessageDefinition;
    }

    public static class MessageSignificanceCategoryEnumFactory
    implements EnumFactory<MessageSignificanceCategory> {
        @Override
        public MessageSignificanceCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("consequence".equals(codeString)) {
                return MessageSignificanceCategory.CONSEQUENCE;
            }
            if ("currency".equals(codeString)) {
                return MessageSignificanceCategory.CURRENCY;
            }
            if ("notification".equals(codeString)) {
                return MessageSignificanceCategory.NOTIFICATION;
            }
            throw new IllegalArgumentException("Unknown MessageSignificanceCategory code '" + codeString + "'");
        }

        public Enumeration<MessageSignificanceCategory> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.NULL, code);
            }
            if ("consequence".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.CONSEQUENCE, code);
            }
            if ("currency".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.CURRENCY, code);
            }
            if ("notification".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.NOTIFICATION, code);
            }
            throw new FHIRException("Unknown MessageSignificanceCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(MessageSignificanceCategory code) {
            if (code == MessageSignificanceCategory.NULL) {
                return null;
            }
            if (code == MessageSignificanceCategory.CONSEQUENCE) {
                return "consequence";
            }
            if (code == MessageSignificanceCategory.CURRENCY) {
                return "currency";
            }
            if (code == MessageSignificanceCategory.NOTIFICATION) {
                return "notification";
            }
            return "?";
        }

        @Override
        public String toSystem(MessageSignificanceCategory code) {
            return code.getSystem();
        }
    }

    public static enum MessageSignificanceCategory {
        CONSEQUENCE,
        CURRENCY,
        NOTIFICATION,
        NULL;


        public static MessageSignificanceCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("consequence".equals(codeString)) {
                return CONSEQUENCE;
            }
            if ("currency".equals(codeString)) {
                return CURRENCY;
            }
            if ("notification".equals(codeString)) {
                return NOTIFICATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MessageSignificanceCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CONSEQUENCE: {
                    return "consequence";
                }
                case CURRENCY: {
                    return "currency";
                }
                case NOTIFICATION: {
                    return "notification";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CONSEQUENCE: {
                    return "http://hl7.org/fhir/message-significance-category";
                }
                case CURRENCY: {
                    return "http://hl7.org/fhir/message-significance-category";
                }
                case NOTIFICATION: {
                    return "http://hl7.org/fhir/message-significance-category";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CONSEQUENCE: {
                    return "The message represents/requests a change that should not be processed more than once; e.g., making a booking for an appointment.";
                }
                case CURRENCY: {
                    return "The message represents a response to query for current information. Retrospective processing is wrong and/or wasteful.";
                }
                case NOTIFICATION: {
                    return "The content is not necessarily intended to be current, and it can be reprocessed, though there may be version issues created by processing old notifications.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CONSEQUENCE: {
                    return "Consequence";
                }
                case CURRENCY: {
                    return "Currency";
                }
                case NOTIFICATION: {
                    return "Notification";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class MessageDefinitionFocusComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of resource", formalDefinition="The kind of resource that must be the focus for this message.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType code;
        @Child(name="profile", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile that must be adhered to by focus", formalDefinition="A profile that reflects constraints for the focal resource (and potentially for related resources).")
        protected CanonicalType profile;
        @Child(name="min", type={UnsignedIntType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Minimum number of focuses of this type", formalDefinition="Identifies the minimum number of resources of this type that must be pointed to by a message in order for it to be valid against this MessageDefinition.")
        protected UnsignedIntType min;
        @Child(name="max", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum number of focuses of this type", formalDefinition="Identifies the maximum number of resources of this type that must be pointed to by a message in order for it to be valid against this MessageDefinition.")
        protected StringType max;
        private static final long serialVersionUID = -68504836L;

        public MessageDefinitionFocusComponent() {
        }

        public MessageDefinitionFocusComponent(CodeType code, UnsignedIntType min) {
            this.code = code;
            this.min = min;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDefinitionFocusComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MessageDefinitionFocusComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public MessageDefinitionFocusComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDefinitionFocusComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public MessageDefinitionFocusComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public MessageDefinitionFocusComponent setProfile(String value) {
            if (Utilities.noString((String)value)) {
                this.profile = null;
            } else {
                if (this.profile == null) {
                    this.profile = new CanonicalType();
                }
                this.profile.setValue(value);
            }
            return this;
        }

        public UnsignedIntType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDefinitionFocusComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new UnsignedIntType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public MessageDefinitionFocusComponent setMinElement(UnsignedIntType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public MessageDefinitionFocusComponent setMin(int value) {
            if (this.min == null) {
                this.min = new UnsignedIntType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDefinitionFocusComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public MessageDefinitionFocusComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public MessageDefinitionFocusComponent setMax(String value) {
            if (Utilities.noString((String)value)) {
                this.max = null;
            } else {
                if (this.max == null) {
                    this.max = new StringType();
                }
                this.max.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "The kind of resource that must be the focus for this message.", 0, 1, this.code));
            children.add(new Property("profile", "canonical(StructureDefinition)", "A profile that reflects constraints for the focal resource (and potentially for related resources).", 0, 1, this.profile));
            children.add(new Property("min", "unsignedInt", "Identifies the minimum number of resources of this type that must be pointed to by a message in order for it to be valid against this MessageDefinition.", 0, 1, this.min));
            children.add(new Property("max", "string", "Identifies the maximum number of resources of this type that must be pointed to by a message in order for it to be valid against this MessageDefinition.", 0, 1, this.max));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "The kind of resource that must be the focus for this message.", 0, 1, this.code);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "A profile that reflects constraints for the focal resource (and potentially for related resources).", 0, 1, this.profile);
                }
                case 108114: {
                    return new Property("min", "unsignedInt", "Identifies the minimum number of resources of this type that must be pointed to by a message in order for it to be valid against this MessageDefinition.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "Identifies the maximum number of resources of this type that must be pointed to by a message in order for it to be valid against this MessageDefinition.", 0, 1, this.max);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.max;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = this.castToCanonical(value);
                    return value;
                }
                case 108114: {
                    this.min = this.castToUnsignedInt(value);
                    return value;
                }
                case 107876: {
                    this.max = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToCanonical(value);
            } else if (name.equals("min")) {
                this.min = this.castToUnsignedInt(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("profile")) {
                this.profile = null;
            } else if (name.equals("min")) {
                this.min = null;
            } else if (name.equals("max")) {
                this.max = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
                case 108114: {
                    return new String[]{"unsignedInt"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.code");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.profile");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.max");
            }
            return super.addChild(name);
        }

        @Override
        public MessageDefinitionFocusComponent copy() {
            MessageDefinitionFocusComponent dst = new MessageDefinitionFocusComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MessageDefinitionFocusComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDefinitionFocusComponent)) {
                return false;
            }
            MessageDefinitionFocusComponent o = (MessageDefinitionFocusComponent)other_;
            return MessageDefinitionFocusComponent.compareDeep(this.code, o.code, true) && MessageDefinitionFocusComponent.compareDeep(this.profile, o.profile, true) && MessageDefinitionFocusComponent.compareDeep(this.min, o.min, true) && MessageDefinitionFocusComponent.compareDeep(this.max, o.max, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDefinitionFocusComponent)) {
                return false;
            }
            MessageDefinitionFocusComponent o = (MessageDefinitionFocusComponent)other_;
            return MessageDefinitionFocusComponent.compareValues(this.code, o.code, true) && MessageDefinitionFocusComponent.compareValues(this.min, o.min, true) && MessageDefinitionFocusComponent.compareValues(this.max, o.max, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.profile, this.min, this.max});
        }

        @Override
        public String fhirType() {
            return "MessageDefinition.focus";
        }
    }

    public static class MessageheaderResponseRequestEnumFactory
    implements EnumFactory<MessageheaderResponseRequest> {
        @Override
        public MessageheaderResponseRequest fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("always".equals(codeString)) {
                return MessageheaderResponseRequest.ALWAYS;
            }
            if ("on-error".equals(codeString)) {
                return MessageheaderResponseRequest.ONERROR;
            }
            if ("never".equals(codeString)) {
                return MessageheaderResponseRequest.NEVER;
            }
            if ("on-success".equals(codeString)) {
                return MessageheaderResponseRequest.ONSUCCESS;
            }
            throw new IllegalArgumentException("Unknown MessageheaderResponseRequest code '" + codeString + "'");
        }

        public Enumeration<MessageheaderResponseRequest> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MessageheaderResponseRequest>(this, MessageheaderResponseRequest.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MessageheaderResponseRequest>(this, MessageheaderResponseRequest.NULL, code);
            }
            if ("always".equals(codeString)) {
                return new Enumeration<MessageheaderResponseRequest>(this, MessageheaderResponseRequest.ALWAYS, code);
            }
            if ("on-error".equals(codeString)) {
                return new Enumeration<MessageheaderResponseRequest>(this, MessageheaderResponseRequest.ONERROR, code);
            }
            if ("never".equals(codeString)) {
                return new Enumeration<MessageheaderResponseRequest>(this, MessageheaderResponseRequest.NEVER, code);
            }
            if ("on-success".equals(codeString)) {
                return new Enumeration<MessageheaderResponseRequest>(this, MessageheaderResponseRequest.ONSUCCESS, code);
            }
            throw new FHIRException("Unknown MessageheaderResponseRequest code '" + codeString + "'");
        }

        @Override
        public String toCode(MessageheaderResponseRequest code) {
            if (code == MessageheaderResponseRequest.NULL) {
                return null;
            }
            if (code == MessageheaderResponseRequest.ALWAYS) {
                return "always";
            }
            if (code == MessageheaderResponseRequest.ONERROR) {
                return "on-error";
            }
            if (code == MessageheaderResponseRequest.NEVER) {
                return "never";
            }
            if (code == MessageheaderResponseRequest.ONSUCCESS) {
                return "on-success";
            }
            return "?";
        }

        @Override
        public String toSystem(MessageheaderResponseRequest code) {
            return code.getSystem();
        }
    }

    public static enum MessageheaderResponseRequest {
        ALWAYS,
        ONERROR,
        NEVER,
        ONSUCCESS,
        NULL;


        public static MessageheaderResponseRequest fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("always".equals(codeString)) {
                return ALWAYS;
            }
            if ("on-error".equals(codeString)) {
                return ONERROR;
            }
            if ("never".equals(codeString)) {
                return NEVER;
            }
            if ("on-success".equals(codeString)) {
                return ONSUCCESS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MessageheaderResponseRequest code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ALWAYS: {
                    return "always";
                }
                case ONERROR: {
                    return "on-error";
                }
                case NEVER: {
                    return "never";
                }
                case ONSUCCESS: {
                    return "on-success";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ALWAYS: {
                    return "http://hl7.org/fhir/messageheader-response-request";
                }
                case ONERROR: {
                    return "http://hl7.org/fhir/messageheader-response-request";
                }
                case NEVER: {
                    return "http://hl7.org/fhir/messageheader-response-request";
                }
                case ONSUCCESS: {
                    return "http://hl7.org/fhir/messageheader-response-request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ALWAYS: {
                    return "initiator expects a response for this message.";
                }
                case ONERROR: {
                    return "initiator expects a response only if in error.";
                }
                case NEVER: {
                    return "initiator does not expect a response.";
                }
                case ONSUCCESS: {
                    return "initiator expects a response only if successful.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ALWAYS: {
                    return "Always";
                }
                case ONERROR: {
                    return "Error/reject conditions only";
                }
                case NEVER: {
                    return "Never";
                }
                case ONSUCCESS: {
                    return "Successful completion only";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class MessageDefinitionAllowedResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="message", type={CanonicalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to allowed message definition response", formalDefinition="A reference to the message definition that must be adhered to by this supported response.")
        protected CanonicalType message;
        @Child(name="situation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When should this response be used", formalDefinition="Provides a description of the circumstances in which this response should be used (as opposed to one of the alternative responses).")
        protected MarkdownType situation;
        private static final long serialVersionUID = -1943810550L;

        public MessageDefinitionAllowedResponseComponent() {
        }

        public MessageDefinitionAllowedResponseComponent(CanonicalType message) {
            this.message = message;
        }

        public CanonicalType getMessageElement() {
            if (this.message == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDefinitionAllowedResponseComponent.message");
                }
                if (Configuration.doAutoCreate()) {
                    this.message = new CanonicalType();
                }
            }
            return this.message;
        }

        public boolean hasMessageElement() {
            return this.message != null && !this.message.isEmpty();
        }

        public boolean hasMessage() {
            return this.message != null && !this.message.isEmpty();
        }

        public MessageDefinitionAllowedResponseComponent setMessageElement(CanonicalType value) {
            this.message = value;
            return this;
        }

        public String getMessage() {
            return this.message == null ? null : (String)this.message.getValue();
        }

        public MessageDefinitionAllowedResponseComponent setMessage(String value) {
            if (this.message == null) {
                this.message = new CanonicalType();
            }
            this.message.setValue(value);
            return this;
        }

        public MarkdownType getSituationElement() {
            if (this.situation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDefinitionAllowedResponseComponent.situation");
                }
                if (Configuration.doAutoCreate()) {
                    this.situation = new MarkdownType();
                }
            }
            return this.situation;
        }

        public boolean hasSituationElement() {
            return this.situation != null && !this.situation.isEmpty();
        }

        public boolean hasSituation() {
            return this.situation != null && !this.situation.isEmpty();
        }

        public MessageDefinitionAllowedResponseComponent setSituationElement(MarkdownType value) {
            this.situation = value;
            return this;
        }

        public String getSituation() {
            return this.situation == null ? null : (String)this.situation.getValue();
        }

        public MessageDefinitionAllowedResponseComponent setSituation(String value) {
            if (value == null) {
                this.situation = null;
            } else {
                if (this.situation == null) {
                    this.situation = new MarkdownType();
                }
                this.situation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("message", "canonical(MessageDefinition)", "A reference to the message definition that must be adhered to by this supported response.", 0, 1, this.message));
            children.add(new Property("situation", "markdown", "Provides a description of the circumstances in which this response should be used (as opposed to one of the alternative responses).", 0, 1, this.situation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 954925063: {
                    return new Property("message", "canonical(MessageDefinition)", "A reference to the message definition that must be adhered to by this supported response.", 0, 1, this.message);
                }
                case -73377282: {
                    return new Property("situation", "markdown", "Provides a description of the circumstances in which this response should be used (as opposed to one of the alternative responses).", 0, 1, this.situation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 954925063: {
                    Base[] baseArray;
                    if (this.message == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.message;
                    }
                    return baseArray;
                }
                case -73377282: {
                    Base[] baseArray;
                    if (this.situation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.situation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 954925063: {
                    this.message = this.castToCanonical(value);
                    return value;
                }
                case -73377282: {
                    this.situation = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("message")) {
                this.message = this.castToCanonical(value);
            } else if (name.equals("situation")) {
                this.situation = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("message")) {
                this.message = null;
            } else if (name.equals("situation")) {
                this.situation = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 954925063: {
                    return this.getMessageElement();
                }
                case -73377282: {
                    return this.getSituationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 954925063: {
                    return new String[]{"canonical"};
                }
                case -73377282: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("message")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.message");
            }
            if (name.equals("situation")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageDefinition.situation");
            }
            return super.addChild(name);
        }

        @Override
        public MessageDefinitionAllowedResponseComponent copy() {
            MessageDefinitionAllowedResponseComponent dst = new MessageDefinitionAllowedResponseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MessageDefinitionAllowedResponseComponent dst) {
            super.copyValues(dst);
            dst.message = this.message == null ? null : this.message.copy();
            dst.situation = this.situation == null ? null : this.situation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDefinitionAllowedResponseComponent)) {
                return false;
            }
            MessageDefinitionAllowedResponseComponent o = (MessageDefinitionAllowedResponseComponent)other_;
            return MessageDefinitionAllowedResponseComponent.compareDeep(this.message, o.message, true) && MessageDefinitionAllowedResponseComponent.compareDeep(this.situation, o.situation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDefinitionAllowedResponseComponent)) {
                return false;
            }
            MessageDefinitionAllowedResponseComponent o = (MessageDefinitionAllowedResponseComponent)other_;
            return MessageDefinitionAllowedResponseComponent.compareValues(this.situation, o.situation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.message, this.situation});
        }

        @Override
        public String fhirType() {
            return "MessageDefinition.allowedResponse";
        }
    }
}

