/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EvidenceVariable", profile="http://hl7.org/fhir/StructureDefinition/EvidenceVariable")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "shortTitle", "subtitle", "status", "date", "publisher", "contact", "description", "note", "useContext", "jurisdiction", "copyright", "approvalDate", "lastReviewDate", "effectivePeriod", "topic", "author", "editor", "reviewer", "endorser", "relatedArtifact", "type", "characteristic"})
public class EvidenceVariable
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the evidence variable", formalDefinition="A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="shortTitle", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Title for use in informal contexts", formalDefinition="The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.")
    protected StringType shortTitle;
    @Child(name="subtitle", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the EvidenceVariable", formalDefinition="An explanatory or alternate title for the EvidenceVariable giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="note", type={Annotation.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
    protected List<Annotation> note;
    @Child(name="copyright", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the evidence variable and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence variable.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the evidence variable was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the evidence variable was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the evidence variable is expected to be used", formalDefinition="The period during which the evidence variable content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the EvidenceVariable, such as Education, Treatment, Assessment, etc.", formalDefinition="Descriptive topics related to the content of the EvidenceVariable. Topics provide a high-level categorization grouping types of EvidenceVariables that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="type", type={CodeType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="dichotomous | continuous | descriptive", formalDefinition="The type of evidence element, a population, an exposure, or an outcome.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-type")
    protected Enumeration<EvidenceVariableType> type;
    @Child(name="characteristic", type={}, order=15, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What defines the members of the evidence element", formalDefinition="A characteristic that defines the members of the evidence element. Multiple characteristics are applied with \"and\" semantics.")
    protected List<EvidenceVariableCharacteristicComponent> characteristic;
    private static final long serialVersionUID = -317280154L;
    @SearchParamDefinition(name="date", path="EvidenceVariable.date", description="The evidence variable publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="EvidenceVariable.identifier", description="External identifier for the evidence variable", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="successor", path="EvidenceVariable.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("EvidenceVariable:successor").toLocked();
    @SearchParamDefinition(name="context-type-value", path="EvidenceVariable.useContext", description="A use context type and value assigned to the evidence variable", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="EvidenceVariable.jurisdiction", description="Intended jurisdiction for the evidence variable", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="EvidenceVariable.description", description="The description of the evidence variable", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="EvidenceVariable.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("EvidenceVariable:derived-from").toLocked();
    @SearchParamDefinition(name="context-type", path="EvidenceVariable.useContext.code", description="A type of use context assigned to the evidence variable", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="predecessor", path="EvidenceVariable.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("EvidenceVariable:predecessor").toLocked();
    @SearchParamDefinition(name="title", path="EvidenceVariable.title", description="The human-friendly name of the evidence variable", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="composed-of", path="EvidenceVariable.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference")
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("EvidenceVariable:composed-of").toLocked();
    @SearchParamDefinition(name="version", path="EvidenceVariable.version", description="The business version of the evidence variable", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="EvidenceVariable.url", description="The uri that identifies the evidence variable", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(EvidenceVariable.useContext.value as Quantity) | (EvidenceVariable.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the evidence variable", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="effective", path="EvidenceVariable.effectivePeriod", description="The time during which the evidence variable is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="depends-on", path="EvidenceVariable.relatedArtifact.where(type='depends-on').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("EvidenceVariable:depends-on").toLocked();
    @SearchParamDefinition(name="name", path="EvidenceVariable.name", description="Computationally friendly name of the evidence variable", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(EvidenceVariable.useContext.value as CodeableConcept)", description="A use context assigned to the evidence variable", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="EvidenceVariable.publisher", description="Name of the publisher of the evidence variable", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="topic", path="EvidenceVariable.topic", description="Topics associated with the EvidenceVariable", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="context-type-quantity", path="EvidenceVariable.useContext", description="A use context type and quantity- or range-based value assigned to the evidence variable", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="EvidenceVariable.status", description="The current status of the evidence variable", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public EvidenceVariable() {
    }

    public EvidenceVariable(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public EvidenceVariable setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public EvidenceVariable setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EvidenceVariable setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EvidenceVariable addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public EvidenceVariable setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public EvidenceVariable setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public EvidenceVariable setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public EvidenceVariable setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public EvidenceVariable setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public EvidenceVariable setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getShortTitleElement() {
        if (this.shortTitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.shortTitle");
            }
            if (Configuration.doAutoCreate()) {
                this.shortTitle = new StringType();
            }
        }
        return this.shortTitle;
    }

    public boolean hasShortTitleElement() {
        return this.shortTitle != null && !this.shortTitle.isEmpty();
    }

    public boolean hasShortTitle() {
        return this.shortTitle != null && !this.shortTitle.isEmpty();
    }

    public EvidenceVariable setShortTitleElement(StringType value) {
        this.shortTitle = value;
        return this;
    }

    public String getShortTitle() {
        return this.shortTitle == null ? null : (String)this.shortTitle.getValue();
    }

    public EvidenceVariable setShortTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.shortTitle = null;
        } else {
            if (this.shortTitle == null) {
                this.shortTitle = new StringType();
            }
            this.shortTitle.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public EvidenceVariable setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public EvidenceVariable setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public EvidenceVariable setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public EvidenceVariable setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public EvidenceVariable setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public EvidenceVariable setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public EvidenceVariable setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public EvidenceVariable setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public EvidenceVariable setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public EvidenceVariable setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public EvidenceVariable setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public EvidenceVariable setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public EvidenceVariable addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public EvidenceVariable setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public EvidenceVariable setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public EvidenceVariable setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public EvidenceVariable setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public EvidenceVariable setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public EvidenceVariable setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public EvidenceVariable setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public EvidenceVariable setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public EvidenceVariable setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public EvidenceVariable setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public EvidenceVariable addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    public EvidenceVariable setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    public EvidenceVariable addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    public EvidenceVariable setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    public EvidenceVariable addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    public EvidenceVariable setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    public EvidenceVariable addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    public EvidenceVariable setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    public EvidenceVariable addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public EvidenceVariable setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public EvidenceVariable addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public Enumeration<EvidenceVariableType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<EvidenceVariableType>(new EvidenceVariableTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public EvidenceVariable setTypeElement(Enumeration<EvidenceVariableType> value) {
        this.type = value;
        return this;
    }

    public EvidenceVariableType getType() {
        return this.type == null ? null : (EvidenceVariableType)((Object)this.type.getValue());
    }

    public EvidenceVariable setType(EvidenceVariableType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<EvidenceVariableType>(new EvidenceVariableTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public List<EvidenceVariableCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public EvidenceVariable setCharacteristic(List<EvidenceVariableCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (EvidenceVariableCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceVariableCharacteristicComponent addCharacteristic() {
        EvidenceVariableCharacteristicComponent t = new EvidenceVariableCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public EvidenceVariable addCharacteristic(EvidenceVariableCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public EvidenceVariableCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence variable when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this evidence variable is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence variable is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the evidence variable when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence variable author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the evidence variable. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the evidence variable.", 0, 1, this.title));
        children.add(new Property("shortTitle", "string", "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.", 0, 1, this.shortTitle));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the EvidenceVariable giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this evidence variable. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the evidence variable was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence variable changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the evidence variable.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence variable from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence variable instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the evidence variable is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the evidence variable and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence variable.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the evidence variable content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the EvidenceVariable. Topics provide a high-level categorization grouping types of EvidenceVariables that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("type", "code", "The type of evidence element, a population, an exposure, or an outcome.", 0, 1, this.type));
        children.add(new Property("characteristic", "", "A characteristic that defines the members of the evidence element. Multiple characteristics are applied with \"and\" semantics.", 0, Integer.MAX_VALUE, this.characteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence variable when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this evidence variable is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence variable is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the evidence variable when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence variable author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the evidence variable. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the evidence variable.", 0, 1, this.title);
            }
            case 1555503932: {
                return new Property("shortTitle", "string", "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.", 0, 1, this.shortTitle);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the EvidenceVariable giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this evidence variable. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the evidence variable was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence variable changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the evidence variable.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence variable from a consumer's perspective.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence variable instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the evidence variable is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the evidence variable and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence variable.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the evidence variable content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the EvidenceVariable. Topics provide a high-level categorization grouping types of EvidenceVariables that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 3575610: {
                return new Property("type", "code", "The type of evidence element, a population, an exposure, or an outcome.", 0, 1, this.type);
            }
            case 366313883: {
                return new Property("characteristic", "", "A characteristic that defines the members of the evidence element. Multiple characteristics are applied with \"and\" semantics.", 0, Integer.MAX_VALUE, this.characteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 1555503932: {
                Base[] baseArray;
                if (this.shortTitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.shortTitle;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.type;
                }
                return baseArray;
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case 1555503932: {
                this.shortTitle = this.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(this.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(this.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 3575610: {
                value = new EvidenceVariableTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((EvidenceVariableCharacteristicComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("shortTitle")) {
            this.shortTitle = this.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(this.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(this.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("type")) {
            value = new EvidenceVariableTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((EvidenceVariableCharacteristicComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals("shortTitle")) {
            this.shortTitle = null;
        } else if (name.equals("subtitle")) {
            this.subtitle = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("note")) {
            this.getNote().remove(this.castToAnnotation(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = null;
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().remove(this.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().remove(this.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().remove(this.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().remove(this.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().remove(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().remove(this.castToRelatedArtifact(value));
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().remove((EvidenceVariableCharacteristicComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1555503932: {
                return this.getShortTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1555503932: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 366313883: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.title");
        }
        if (name.equals("shortTitle")) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.shortTitle");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.type");
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EvidenceVariable";
    }

    @Override
    public EvidenceVariable copy() {
        EvidenceVariable dst = new EvidenceVariable();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EvidenceVariable dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.shortTitle = this.shortTitle == null ? null : this.shortTitle.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        Enumeration<EvidenceVariableType> enumeration = dst.type = this.type == null ? null : this.type.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
            for (EvidenceVariableCharacteristicComponent evidenceVariableCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(evidenceVariableCharacteristicComponent.copy());
            }
        }
    }

    protected EvidenceVariable typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceVariable)) {
            return false;
        }
        EvidenceVariable o = (EvidenceVariable)other_;
        return EvidenceVariable.compareDeep(this.identifier, o.identifier, true) && EvidenceVariable.compareDeep(this.shortTitle, o.shortTitle, true) && EvidenceVariable.compareDeep(this.subtitle, o.subtitle, true) && EvidenceVariable.compareDeep(this.note, o.note, true) && EvidenceVariable.compareDeep(this.copyright, o.copyright, true) && EvidenceVariable.compareDeep(this.approvalDate, o.approvalDate, true) && EvidenceVariable.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && EvidenceVariable.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && EvidenceVariable.compareDeep(this.topic, o.topic, true) && EvidenceVariable.compareDeep(this.author, o.author, true) && EvidenceVariable.compareDeep(this.editor, o.editor, true) && EvidenceVariable.compareDeep(this.reviewer, o.reviewer, true) && EvidenceVariable.compareDeep(this.endorser, o.endorser, true) && EvidenceVariable.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && EvidenceVariable.compareDeep(this.type, o.type, true) && EvidenceVariable.compareDeep(this.characteristic, o.characteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceVariable)) {
            return false;
        }
        EvidenceVariable o = (EvidenceVariable)other_;
        return EvidenceVariable.compareValues(this.shortTitle, o.shortTitle, true) && EvidenceVariable.compareValues(this.subtitle, o.subtitle, true) && EvidenceVariable.compareValues(this.copyright, o.copyright, true) && EvidenceVariable.compareValues(this.approvalDate, o.approvalDate, true) && EvidenceVariable.compareValues(this.lastReviewDate, o.lastReviewDate, true) && EvidenceVariable.compareValues(this.type, o.type, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.shortTitle, this.subtitle, this.note, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.type, this.characteristic});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EvidenceVariable;
    }

    public static class EvidenceVariableTypeEnumFactory
    implements EnumFactory<EvidenceVariableType> {
        @Override
        public EvidenceVariableType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("dichotomous".equals(codeString)) {
                return EvidenceVariableType.DICHOTOMOUS;
            }
            if ("continuous".equals(codeString)) {
                return EvidenceVariableType.CONTINUOUS;
            }
            if ("descriptive".equals(codeString)) {
                return EvidenceVariableType.DESCRIPTIVE;
            }
            throw new IllegalArgumentException("Unknown EvidenceVariableType code '" + codeString + "'");
        }

        public Enumeration<EvidenceVariableType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EvidenceVariableType>(this, EvidenceVariableType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EvidenceVariableType>(this, EvidenceVariableType.NULL, code);
            }
            if ("dichotomous".equals(codeString)) {
                return new Enumeration<EvidenceVariableType>(this, EvidenceVariableType.DICHOTOMOUS, code);
            }
            if ("continuous".equals(codeString)) {
                return new Enumeration<EvidenceVariableType>(this, EvidenceVariableType.CONTINUOUS, code);
            }
            if ("descriptive".equals(codeString)) {
                return new Enumeration<EvidenceVariableType>(this, EvidenceVariableType.DESCRIPTIVE, code);
            }
            throw new FHIRException("Unknown EvidenceVariableType code '" + codeString + "'");
        }

        @Override
        public String toCode(EvidenceVariableType code) {
            if (code == EvidenceVariableType.NULL) {
                return null;
            }
            if (code == EvidenceVariableType.DICHOTOMOUS) {
                return "dichotomous";
            }
            if (code == EvidenceVariableType.CONTINUOUS) {
                return "continuous";
            }
            if (code == EvidenceVariableType.DESCRIPTIVE) {
                return "descriptive";
            }
            return "?";
        }

        @Override
        public String toSystem(EvidenceVariableType code) {
            return code.getSystem();
        }
    }

    public static enum EvidenceVariableType {
        DICHOTOMOUS,
        CONTINUOUS,
        DESCRIPTIVE,
        NULL;


        public static EvidenceVariableType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("dichotomous".equals(codeString)) {
                return DICHOTOMOUS;
            }
            if ("continuous".equals(codeString)) {
                return CONTINUOUS;
            }
            if ("descriptive".equals(codeString)) {
                return DESCRIPTIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EvidenceVariableType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "dichotomous";
                }
                case CONTINUOUS: {
                    return "continuous";
                }
                case DESCRIPTIVE: {
                    return "descriptive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "http://hl7.org/fhir/variable-type";
                }
                case CONTINUOUS: {
                    return "http://hl7.org/fhir/variable-type";
                }
                case DESCRIPTIVE: {
                    return "http://hl7.org/fhir/variable-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "The variable is dichotomous, such as present or absent.";
                }
                case CONTINUOUS: {
                    return "The variable is a continuous result such as a quantity.";
                }
                case DESCRIPTIVE: {
                    return "The variable is described narratively rather than quantitatively.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "Dichotomous";
                }
                case CONTINUOUS: {
                    return "Continuous";
                }
                case DESCRIPTIVE: {
                    return "Descriptive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class EvidenceVariableCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the characteristic", formalDefinition="A short, natural language description of the characteristic that could be used to communicate the criteria to an end-user.")
        protected StringType description;
        @Child(name="definition", type={Group.class, CanonicalType.class, CodeableConcept.class, Expression.class, DataRequirement.class, TriggerDefinition.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What code or expression defines members?", formalDefinition="Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).")
        protected Type definition;
        @Child(name="usageContext", type={UsageContext.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What code/value pairs define members?", formalDefinition="Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.")
        protected List<UsageContext> usageContext;
        @Child(name="exclude", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the characteristic includes or excludes members", formalDefinition="When true, members with this characteristic are excluded from the element.")
        protected BooleanType exclude;
        @Child(name="participantEffective", type={DateTimeType.class, Period.class, Duration.class, Timing.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What time period do participants cover", formalDefinition="Indicates what effective period the study covers.")
        protected Type participantEffective;
        @Child(name="timeFromStart", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Observation time from study start", formalDefinition="Indicates duration from the participant's study entry.")
        protected Duration timeFromStart;
        @Child(name="groupMeasure", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mean | median | mean-of-mean | mean-of-median | median-of-mean | median-of-median", formalDefinition="Indicates how elements are aggregated within the study effective period.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/group-measure")
        protected Enumeration<GroupMeasure> groupMeasure;
        private static final long serialVersionUID = 1901961318L;

        public EvidenceVariableCharacteristicComponent() {
        }

        public EvidenceVariableCharacteristicComponent(Type definition) {
            this.definition = definition;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceVariableCharacteristicComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Type getDefinition() {
            return this.definition;
        }

        public Reference getDefinitionReference() throws FHIRException {
            if (this.definition == null) {
                this.definition = new Reference();
            }
            if (!(this.definition instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (Reference)this.definition;
        }

        public boolean hasDefinitionReference() {
            return this.definition instanceof Reference;
        }

        public CanonicalType getDefinitionCanonicalType() throws FHIRException {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            if (!(this.definition instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.definition;
        }

        public boolean hasDefinitionCanonicalType() {
            return this.definition instanceof CanonicalType;
        }

        public CodeableConcept getDefinitionCodeableConcept() throws FHIRException {
            if (this.definition == null) {
                this.definition = new CodeableConcept();
            }
            if (!(this.definition instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.definition;
        }

        public boolean hasDefinitionCodeableConcept() {
            return this.definition instanceof CodeableConcept;
        }

        public Expression getDefinitionExpression() throws FHIRException {
            if (this.definition == null) {
                this.definition = new Expression();
            }
            if (!(this.definition instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (Expression)this.definition;
        }

        public boolean hasDefinitionExpression() {
            return this.definition instanceof Expression;
        }

        public DataRequirement getDefinitionDataRequirement() throws FHIRException {
            if (this.definition == null) {
                this.definition = new DataRequirement();
            }
            if (!(this.definition instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.definition;
        }

        public boolean hasDefinitionDataRequirement() {
            return this.definition instanceof DataRequirement;
        }

        public TriggerDefinition getDefinitionTriggerDefinition() throws FHIRException {
            if (this.definition == null) {
                this.definition = new TriggerDefinition();
            }
            if (!(this.definition instanceof TriggerDefinition)) {
                throw new FHIRException("Type mismatch: the type TriggerDefinition was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (TriggerDefinition)this.definition;
        }

        public boolean hasDefinitionTriggerDefinition() {
            return this.definition instanceof TriggerDefinition;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinition(Type value) {
            if (!(value == null || value instanceof Reference || value instanceof CanonicalType || value instanceof CodeableConcept || value instanceof Expression || value instanceof DataRequirement || value instanceof TriggerDefinition)) {
                throw new Error("Not the right type for EvidenceVariable.characteristic.definition[x]: " + value.fhirType());
            }
            this.definition = value;
            return this;
        }

        public List<UsageContext> getUsageContext() {
            if (this.usageContext == null) {
                this.usageContext = new ArrayList<UsageContext>();
            }
            return this.usageContext;
        }

        public EvidenceVariableCharacteristicComponent setUsageContext(List<UsageContext> theUsageContext) {
            this.usageContext = theUsageContext;
            return this;
        }

        public boolean hasUsageContext() {
            if (this.usageContext == null) {
                return false;
            }
            for (UsageContext item : this.usageContext) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UsageContext addUsageContext() {
            UsageContext t = new UsageContext();
            if (this.usageContext == null) {
                this.usageContext = new ArrayList<UsageContext>();
            }
            this.usageContext.add(t);
            return t;
        }

        public EvidenceVariableCharacteristicComponent addUsageContext(UsageContext t) {
            if (t == null) {
                return this;
            }
            if (this.usageContext == null) {
                this.usageContext = new ArrayList<UsageContext>();
            }
            this.usageContext.add(t);
            return this;
        }

        public UsageContext getUsageContextFirstRep() {
            if (this.getUsageContext().isEmpty()) {
                this.addUsageContext();
            }
            return this.getUsageContext().get(0);
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public EvidenceVariableCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public Type getParticipantEffective() {
            return this.participantEffective;
        }

        public DateTimeType getParticipantEffectiveDateTimeType() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new DateTimeType();
            }
            if (!(this.participantEffective instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.participantEffective;
        }

        public boolean hasParticipantEffectiveDateTimeType() {
            return this.participantEffective instanceof DateTimeType;
        }

        public Period getParticipantEffectivePeriod() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new Period();
            }
            if (!(this.participantEffective instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (Period)this.participantEffective;
        }

        public boolean hasParticipantEffectivePeriod() {
            return this.participantEffective instanceof Period;
        }

        public Duration getParticipantEffectiveDuration() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new Duration();
            }
            if (!(this.participantEffective instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (Duration)this.participantEffective;
        }

        public boolean hasParticipantEffectiveDuration() {
            return this.participantEffective instanceof Duration;
        }

        public Timing getParticipantEffectiveTiming() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new Timing();
            }
            if (!(this.participantEffective instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (Timing)this.participantEffective;
        }

        public boolean hasParticipantEffectiveTiming() {
            return this.participantEffective instanceof Timing;
        }

        public boolean hasParticipantEffective() {
            return this.participantEffective != null && !this.participantEffective.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setParticipantEffective(Type value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration || value instanceof Timing)) {
                throw new Error("Not the right type for EvidenceVariable.characteristic.participantEffective[x]: " + value.fhirType());
            }
            this.participantEffective = value;
            return this;
        }

        public Duration getTimeFromStart() {
            if (this.timeFromStart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.timeFromStart");
                }
                if (Configuration.doAutoCreate()) {
                    this.timeFromStart = new Duration();
                }
            }
            return this.timeFromStart;
        }

        public boolean hasTimeFromStart() {
            return this.timeFromStart != null && !this.timeFromStart.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setTimeFromStart(Duration value) {
            this.timeFromStart = value;
            return this;
        }

        public Enumeration<GroupMeasure> getGroupMeasureElement() {
            if (this.groupMeasure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.groupMeasure");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupMeasure = new Enumeration<GroupMeasure>(new GroupMeasureEnumFactory());
                }
            }
            return this.groupMeasure;
        }

        public boolean hasGroupMeasureElement() {
            return this.groupMeasure != null && !this.groupMeasure.isEmpty();
        }

        public boolean hasGroupMeasure() {
            return this.groupMeasure != null && !this.groupMeasure.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setGroupMeasureElement(Enumeration<GroupMeasure> value) {
            this.groupMeasure = value;
            return this;
        }

        public GroupMeasure getGroupMeasure() {
            return this.groupMeasure == null ? null : (GroupMeasure)((Object)this.groupMeasure.getValue());
        }

        public EvidenceVariableCharacteristicComponent setGroupMeasure(GroupMeasure value) {
            if (value == null) {
                this.groupMeasure = null;
            } else {
                if (this.groupMeasure == null) {
                    this.groupMeasure = new Enumeration<GroupMeasure>(new GroupMeasureEnumFactory());
                }
                this.groupMeasure.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EvidenceVariable.SP_DESCRIPTION, "string", "A short, natural language description of the characteristic that could be used to communicate the criteria to an end-user.", 0, 1, this.description));
            children.add(new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition));
            children.add(new Property("usageContext", "UsageContext", "Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.", 0, Integer.MAX_VALUE, this.usageContext));
            children.add(new Property("exclude", "boolean", "When true, members with this characteristic are excluded from the element.", 0, 1, this.exclude));
            children.add(new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective));
            children.add(new Property("timeFromStart", "Duration", "Indicates duration from the participant's study entry.", 0, 1, this.timeFromStart));
            children.add(new Property("groupMeasure", "code", "Indicates how elements are aggregated within the study effective period.", 0, 1, this.groupMeasure));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(EvidenceVariable.SP_DESCRIPTION, "string", "A short, natural language description of the characteristic that could be used to communicate the criteria to an end-user.", 0, 1, this.description);
                }
                case -1139422643: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -1014418093: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -820021448: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case 933485793: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -1446002226: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case 1463703627: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -660350874: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -1130324968: {
                    return new Property("definition[x]", "Reference(Group)|canonical(ActivityDefinition)|CodeableConcept|Expression|DataRequirement|TriggerDefinition", "Define members of the evidence element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case 907012302: {
                    return new Property("usageContext", "UsageContext", "Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.", 0, Integer.MAX_VALUE, this.usageContext);
                }
                case -1321148966: {
                    return new Property("exclude", "boolean", "When true, members with this characteristic are excluded from the element.", 0, 1, this.exclude);
                }
                case 1777308748: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case 1376306100: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -1721146513: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -883650923: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -1210941080: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -765589218: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case 2100140683: {
                    return new Property("timeFromStart", "Duration", "Indicates duration from the participant's study entry.", 0, 1, this.timeFromStart);
                }
                case 588892639: {
                    return new Property("groupMeasure", "code", "Indicates how elements are aggregated within the study effective period.", 0, 1, this.groupMeasure);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 907012302: {
                    return this.usageContext == null ? new Base[]{} : this.usageContext.toArray(new Base[this.usageContext.size()]);
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.exclude;
                    }
                    return baseArray;
                }
                case 1376306100: {
                    Base[] baseArray;
                    if (this.participantEffective == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.participantEffective;
                    }
                    return baseArray;
                }
                case 2100140683: {
                    Base[] baseArray;
                    if (this.timeFromStart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.timeFromStart;
                    }
                    return baseArray;
                }
                case 588892639: {
                    Base[] baseArray;
                    if (this.groupMeasure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.groupMeasure;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = this.castToType(value);
                    return value;
                }
                case 907012302: {
                    this.getUsageContext().add(this.castToUsageContext(value));
                    return value;
                }
                case -1321148966: {
                    this.exclude = this.castToBoolean(value);
                    return value;
                }
                case 1376306100: {
                    this.participantEffective = this.castToType(value);
                    return value;
                }
                case 2100140683: {
                    this.timeFromStart = this.castToDuration(value);
                    return value;
                }
                case 588892639: {
                    value = new GroupMeasureEnumFactory().fromType(this.castToCode(value));
                    this.groupMeasure = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("definition[x]")) {
                this.definition = this.castToType(value);
            } else if (name.equals("usageContext")) {
                this.getUsageContext().add(this.castToUsageContext(value));
            } else if (name.equals("exclude")) {
                this.exclude = this.castToBoolean(value);
            } else if (name.equals("participantEffective[x]")) {
                this.participantEffective = this.castToType(value);
            } else if (name.equals("timeFromStart")) {
                this.timeFromStart = this.castToDuration(value);
            } else if (name.equals("groupMeasure")) {
                value = new GroupMeasureEnumFactory().fromType(this.castToCode(value));
                this.groupMeasure = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                this.description = null;
            } else if (name.equals("definition[x]")) {
                this.definition = null;
            } else if (name.equals("usageContext")) {
                this.getUsageContext().remove(this.castToUsageContext(value));
            } else if (name.equals("exclude")) {
                this.exclude = null;
            } else if (name.equals("participantEffective[x]")) {
                this.participantEffective = null;
            } else if (name.equals("timeFromStart")) {
                this.timeFromStart = null;
            } else if (name.equals("groupMeasure")) {
                this.groupMeasure = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1139422643: {
                    return this.getDefinition();
                }
                case -1014418093: {
                    return this.getDefinition();
                }
                case 907012302: {
                    return this.addUsageContext();
                }
                case -1321148966: {
                    return this.getExcludeElement();
                }
                case 1777308748: {
                    return this.getParticipantEffective();
                }
                case 1376306100: {
                    return this.getParticipantEffective();
                }
                case 2100140683: {
                    return this.getTimeFromStart();
                }
                case 588892639: {
                    return this.getGroupMeasureElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"Reference", "canonical", "CodeableConcept", "Expression", "DataRequirement", "TriggerDefinition"};
                }
                case 907012302: {
                    return new String[]{"UsageContext"};
                }
                case -1321148966: {
                    return new String[]{"boolean"};
                }
                case 1376306100: {
                    return new String[]{"dateTime", "Period", "Duration", "Timing"};
                }
                case 2100140683: {
                    return new String[]{"Duration"};
                }
                case 588892639: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.description");
            }
            if (name.equals("definitionReference")) {
                this.definition = new Reference();
                return this.definition;
            }
            if (name.equals("definitionCanonical")) {
                this.definition = new CanonicalType();
                return this.definition;
            }
            if (name.equals("definitionCodeableConcept")) {
                this.definition = new CodeableConcept();
                return this.definition;
            }
            if (name.equals("definitionExpression")) {
                this.definition = new Expression();
                return this.definition;
            }
            if (name.equals("definitionDataRequirement")) {
                this.definition = new DataRequirement();
                return this.definition;
            }
            if (name.equals("definitionTriggerDefinition")) {
                this.definition = new TriggerDefinition();
                return this.definition;
            }
            if (name.equals("usageContext")) {
                return this.addUsageContext();
            }
            if (name.equals("exclude")) {
                throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.exclude");
            }
            if (name.equals("participantEffectiveDateTime")) {
                this.participantEffective = new DateTimeType();
                return this.participantEffective;
            }
            if (name.equals("participantEffectivePeriod")) {
                this.participantEffective = new Period();
                return this.participantEffective;
            }
            if (name.equals("participantEffectiveDuration")) {
                this.participantEffective = new Duration();
                return this.participantEffective;
            }
            if (name.equals("participantEffectiveTiming")) {
                this.participantEffective = new Timing();
                return this.participantEffective;
            }
            if (name.equals("timeFromStart")) {
                this.timeFromStart = new Duration();
                return this.timeFromStart;
            }
            if (name.equals("groupMeasure")) {
                throw new FHIRException("Cannot call addChild on a singleton property EvidenceVariable.groupMeasure");
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableCharacteristicComponent copy() {
            EvidenceVariableCharacteristicComponent dst = new EvidenceVariableCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            Type type = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.usageContext != null) {
                dst.usageContext = new ArrayList<UsageContext>();
                for (UsageContext i : this.usageContext) {
                    dst.usageContext.add(i.copy());
                }
            }
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.participantEffective = this.participantEffective == null ? null : this.participantEffective.copy();
            dst.timeFromStart = this.timeFromStart == null ? null : this.timeFromStart.copy();
            dst.groupMeasure = this.groupMeasure == null ? null : this.groupMeasure.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicComponent o = (EvidenceVariableCharacteristicComponent)other_;
            return EvidenceVariableCharacteristicComponent.compareDeep(this.description, o.description, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definition, o.definition, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.usageContext, o.usageContext, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.participantEffective, o.participantEffective, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.timeFromStart, o.timeFromStart, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.groupMeasure, o.groupMeasure, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicComponent o = (EvidenceVariableCharacteristicComponent)other_;
            return EvidenceVariableCharacteristicComponent.compareValues(this.description, o.description, true) && EvidenceVariableCharacteristicComponent.compareValues(this.exclude, o.exclude, true) && EvidenceVariableCharacteristicComponent.compareValues(this.groupMeasure, o.groupMeasure, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.definition, this.usageContext, this.exclude, this.participantEffective, this.timeFromStart, this.groupMeasure});
        }

        @Override
        public String fhirType() {
            return "EvidenceVariable.characteristic";
        }
    }

    public static class GroupMeasureEnumFactory
    implements EnumFactory<GroupMeasure> {
        @Override
        public GroupMeasure fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mean".equals(codeString)) {
                return GroupMeasure.MEAN;
            }
            if ("median".equals(codeString)) {
                return GroupMeasure.MEDIAN;
            }
            if ("mean-of-mean".equals(codeString)) {
                return GroupMeasure.MEANOFMEAN;
            }
            if ("mean-of-median".equals(codeString)) {
                return GroupMeasure.MEANOFMEDIAN;
            }
            if ("median-of-mean".equals(codeString)) {
                return GroupMeasure.MEDIANOFMEAN;
            }
            if ("median-of-median".equals(codeString)) {
                return GroupMeasure.MEDIANOFMEDIAN;
            }
            throw new IllegalArgumentException("Unknown GroupMeasure code '" + codeString + "'");
        }

        public Enumeration<GroupMeasure> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.NULL, code);
            }
            if ("mean".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEAN, code);
            }
            if ("median".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEDIAN, code);
            }
            if ("mean-of-mean".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEANOFMEAN, code);
            }
            if ("mean-of-median".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEANOFMEDIAN, code);
            }
            if ("median-of-mean".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEDIANOFMEAN, code);
            }
            if ("median-of-median".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEDIANOFMEDIAN, code);
            }
            throw new FHIRException("Unknown GroupMeasure code '" + codeString + "'");
        }

        @Override
        public String toCode(GroupMeasure code) {
            if (code == GroupMeasure.NULL) {
                return null;
            }
            if (code == GroupMeasure.MEAN) {
                return "mean";
            }
            if (code == GroupMeasure.MEDIAN) {
                return "median";
            }
            if (code == GroupMeasure.MEANOFMEAN) {
                return "mean-of-mean";
            }
            if (code == GroupMeasure.MEANOFMEDIAN) {
                return "mean-of-median";
            }
            if (code == GroupMeasure.MEDIANOFMEAN) {
                return "median-of-mean";
            }
            if (code == GroupMeasure.MEDIANOFMEDIAN) {
                return "median-of-median";
            }
            return "?";
        }

        @Override
        public String toSystem(GroupMeasure code) {
            return code.getSystem();
        }
    }

    public static enum GroupMeasure {
        MEAN,
        MEDIAN,
        MEANOFMEAN,
        MEANOFMEDIAN,
        MEDIANOFMEAN,
        MEDIANOFMEDIAN,
        NULL;


        public static GroupMeasure fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mean".equals(codeString)) {
                return MEAN;
            }
            if ("median".equals(codeString)) {
                return MEDIAN;
            }
            if ("mean-of-mean".equals(codeString)) {
                return MEANOFMEAN;
            }
            if ("mean-of-median".equals(codeString)) {
                return MEANOFMEDIAN;
            }
            if ("median-of-mean".equals(codeString)) {
                return MEDIANOFMEAN;
            }
            if ("median-of-median".equals(codeString)) {
                return MEDIANOFMEDIAN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GroupMeasure code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MEAN: {
                    return "mean";
                }
                case MEDIAN: {
                    return "median";
                }
                case MEANOFMEAN: {
                    return "mean-of-mean";
                }
                case MEANOFMEDIAN: {
                    return "mean-of-median";
                }
                case MEDIANOFMEAN: {
                    return "median-of-mean";
                }
                case MEDIANOFMEDIAN: {
                    return "median-of-median";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MEAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEDIAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEANOFMEAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEANOFMEDIAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEDIANOFMEAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEDIANOFMEDIAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MEAN: {
                    return "Aggregated using Mean of participant values.";
                }
                case MEDIAN: {
                    return "Aggregated using Median of participant values.";
                }
                case MEANOFMEAN: {
                    return "Aggregated using Mean of study mean values.";
                }
                case MEANOFMEDIAN: {
                    return "Aggregated using Mean of study median values.";
                }
                case MEDIANOFMEAN: {
                    return "Aggregated using Median of study mean values.";
                }
                case MEDIANOFMEDIAN: {
                    return "Aggregated using Median of study median values.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MEAN: {
                    return "Mean";
                }
                case MEDIAN: {
                    return "Median";
                }
                case MEANOFMEAN: {
                    return "Mean of Study Means";
                }
                case MEANOFMEDIAN: {
                    return "Mean of Study Medins";
                }
                case MEDIANOFMEAN: {
                    return "Median of Study Means";
                }
                case MEDIANOFMEDIAN: {
                    return "Median of Study Medians";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

