/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.SimpleWorkerContext;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class ConceptMapEngine {
    private SimpleWorkerContext context;

    public ConceptMapEngine(SimpleWorkerContext context) {
        this.context = context;
    }

    public Coding translate(Coding source, String url) throws FHIRException {
        ConceptMap cm = this.context.fetchResource(ConceptMap.class, url);
        if (cm == null) {
            throw new FHIRException("Unable to find ConceptMap '" + url + "'");
        }
        if (source.hasSystem()) {
            return this.translateBySystem(cm, source.getSystem(), source.getCode());
        }
        return this.translateByJustCode(cm, source.getCode());
    }

    private Coding translateByJustCode(ConceptMap cm, String code) throws FHIRException {
        ConceptMap.SourceElementComponent ct = null;
        ConceptMap.ConceptMapGroupComponent cg = null;
        for (ConceptMap.ConceptMapGroupComponent g : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent e : g.getElement()) {
                if (!code.equals(e.getCode())) continue;
                if (ct != null) {
                    throw new FHIRException("Unable to process translate " + code + " because multiple candidate matches were found in concept map " + cm.getUrl());
                }
                ct = e;
                cg = g;
            }
        }
        if (ct == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tt = null;
        for (ConceptMap.TargetElementComponent t : ct.getTarget()) {
            if (t.hasDependsOn() || t.hasProduct() || !this.isOkEquivalence(t.getEquivalence())) continue;
            if (tt != null) {
                throw new FHIRException("Unable to process translate " + code + " because multiple targets were found in concept map " + cm.getUrl());
            }
            tt = t;
        }
        if (tt == null) {
            return null;
        }
        return new Coding().setSystem(cg.getTarget()).setVersion(cg.getTargetVersion()).setCode(tt.getCode()).setDisplay(tt.getDisplay());
    }

    private boolean isOkEquivalence(Enumerations.ConceptMapEquivalence equivalence) {
        return equivalence != null && equivalence != Enumerations.ConceptMapEquivalence.DISJOINT && equivalence != Enumerations.ConceptMapEquivalence.UNMATCHED;
    }

    private Coding translateBySystem(ConceptMap cm, String system, String code) {
        throw new Error("Not done yet");
    }
}

