/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.GoalStatus;

public class GoalStatusEnumFactory
implements EnumFactory<GoalStatus> {
    @Override
    public GoalStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return GoalStatus.PROPOSED;
        }
        if ("planned".equals(codeString)) {
            return GoalStatus.PLANNED;
        }
        if ("accepted".equals(codeString)) {
            return GoalStatus.ACCEPTED;
        }
        if ("active".equals(codeString)) {
            return GoalStatus.ACTIVE;
        }
        if ("on-hold".equals(codeString)) {
            return GoalStatus.ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return GoalStatus.COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return GoalStatus.CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return GoalStatus.ENTEREDINERROR;
        }
        if ("rejected".equals(codeString)) {
            return GoalStatus.REJECTED;
        }
        throw new IllegalArgumentException("Unknown GoalStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(GoalStatus code) {
        if (code == GoalStatus.NULL) {
            return null;
        }
        if (code == GoalStatus.PROPOSED) {
            return "proposed";
        }
        if (code == GoalStatus.PLANNED) {
            return "planned";
        }
        if (code == GoalStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == GoalStatus.ACTIVE) {
            return "active";
        }
        if (code == GoalStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == GoalStatus.COMPLETED) {
            return "completed";
        }
        if (code == GoalStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == GoalStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == GoalStatus.REJECTED) {
            return "rejected";
        }
        return "?";
    }

    @Override
    public String toSystem(GoalStatus code) {
        return code.getSystem();
    }
}

