/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.EffectEstimateType;

public class EffectEstimateTypeEnumFactory
implements EnumFactory<EffectEstimateType> {
    @Override
    public EffectEstimateType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("relative-RR".equals(codeString)) {
            return EffectEstimateType.RELATIVERR;
        }
        if ("relative-OR".equals(codeString)) {
            return EffectEstimateType.RELATIVEOR;
        }
        if ("relative-HR".equals(codeString)) {
            return EffectEstimateType.RELATIVEHR;
        }
        if ("absolute-ARD".equals(codeString)) {
            return EffectEstimateType.ABSOLUTEARD;
        }
        if ("absolute-MeanDiff".equals(codeString)) {
            return EffectEstimateType.ABSOLUTEMEANDIFF;
        }
        if ("absolute-SMD".equals(codeString)) {
            return EffectEstimateType.ABSOLUTESMD;
        }
        if ("absolute-MedianDiff".equals(codeString)) {
            return EffectEstimateType.ABSOLUTEMEDIANDIFF;
        }
        throw new IllegalArgumentException("Unknown EffectEstimateType code '" + codeString + "'");
    }

    @Override
    public String toCode(EffectEstimateType code) {
        if (code == EffectEstimateType.NULL) {
            return null;
        }
        if (code == EffectEstimateType.RELATIVERR) {
            return "relative-RR";
        }
        if (code == EffectEstimateType.RELATIVEOR) {
            return "relative-OR";
        }
        if (code == EffectEstimateType.RELATIVEHR) {
            return "relative-HR";
        }
        if (code == EffectEstimateType.ABSOLUTEARD) {
            return "absolute-ARD";
        }
        if (code == EffectEstimateType.ABSOLUTEMEANDIFF) {
            return "absolute-MeanDiff";
        }
        if (code == EffectEstimateType.ABSOLUTESMD) {
            return "absolute-SMD";
        }
        if (code == EffectEstimateType.ABSOLUTEMEDIANDIFF) {
            return "absolute-MedianDiff";
        }
        return "?";
    }

    @Override
    public String toSystem(EffectEstimateType code) {
        return code.getSystem();
    }
}

