/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class OperationOutcomeUtilities {
    public static OperationOutcome.OperationOutcomeIssueComponent convertToIssue(ValidationMessage message, OperationOutcome op) {
        OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent();
        issue.setCode(OperationOutcomeUtilities.convert(message.getType()));
        if (message.getLocation() != null) {
            issue.addExpression(message.getLocation());
        }
        if (message.getLine() != 0) {
            issue.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line").setValue(new IntegerType(message.getLine()));
        }
        if (message.getCol() != 0) {
            issue.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col").setValue(new IntegerType(message.getCol()));
        }
        issue.setSeverity(OperationOutcomeUtilities.convert(message.getLevel()));
        CodeableConcept c = new CodeableConcept();
        c.setText(message.getMessage());
        issue.setDetails(c);
        if (message.getSource() != null) {
            issue.getExtension().add(ToolingExtensions.makeIssueSource(message.getSource()));
        }
        return issue;
    }

    private static OperationOutcome.IssueSeverity convert(ValidationMessage.IssueSeverity level) {
        switch (level) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
            case NULL: {
                return OperationOutcome.IssueSeverity.NULL;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    private static OperationOutcome.IssueType convert(ValidationMessage.IssueType type) {
        switch (type) {
            case INVALID: 
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
            case NULL: {
                return OperationOutcome.IssueType.NULL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    public static OperationOutcome outcomeFromTextError(String text) {
        OperationOutcome oo = new OperationOutcome();
        oo.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        oo.getText().setDiv(new XhtmlNode(NodeType.Element, "div"));
        oo.getText().getDiv().tx(text);
        OperationOutcome.OperationOutcomeIssueComponent issue = oo.addIssue();
        issue.setSeverity(OperationOutcome.IssueSeverity.ERROR);
        issue.setCode(OperationOutcome.IssueType.EXCEPTION);
        issue.getDetails().setText(text);
        return oo;
    }
}

