/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QuestionnaireUsageMode {
    CAPTUREDISPLAY,
    CAPTURE,
    DISPLAY,
    DISPLAYNONEMPTY,
    CAPTUREDISPLAYNONEMPTY,
    NULL;


    public static QuestionnaireUsageMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("capture-display".equals(codeString)) {
            return CAPTUREDISPLAY;
        }
        if ("capture".equals(codeString)) {
            return CAPTURE;
        }
        if ("display".equals(codeString)) {
            return DISPLAY;
        }
        if ("display-non-empty".equals(codeString)) {
            return DISPLAYNONEMPTY;
        }
        if ("capture-display-non-empty".equals(codeString)) {
            return CAPTUREDISPLAYNONEMPTY;
        }
        throw new FHIRException("Unknown QuestionnaireUsageMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CAPTUREDISPLAY: {
                return "capture-display";
            }
            case CAPTURE: {
                return "capture";
            }
            case DISPLAY: {
                return "display";
            }
            case DISPLAYNONEMPTY: {
                return "display-non-empty";
            }
            case CAPTUREDISPLAYNONEMPTY: {
                return "capture-display-non-empty";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/questionnaire-usage-mode";
    }

    public String getDefinition() {
        switch (this) {
            case CAPTUREDISPLAY: {
                return "Render the item regardless of usage mode.";
            }
            case CAPTURE: {
                return "Render the item only when capturing data.";
            }
            case DISPLAY: {
                return "Render the item only when displaying a completed form.";
            }
            case DISPLAYNONEMPTY: {
                return "Render the item only when displaying a completed form and the item has been answered (or has child items that have been answered).";
            }
            case CAPTUREDISPLAYNONEMPTY: {
                return "Render the item when capturing data or when displaying a completed form and the item has been answered (or has child items that have been answered).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CAPTUREDISPLAY: {
                return "Capture & Display";
            }
            case CAPTURE: {
                return "Capture Only";
            }
            case DISPLAY: {
                return "Display Only";
            }
            case DISPLAYNONEMPTY: {
                return "Display when Answered";
            }
            case CAPTUREDISPLAYNONEMPTY: {
                return "Capture or, if answered, Display";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

