/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.OrganizationRole;

public class OrganizationRoleEnumFactory
implements EnumFactory<OrganizationRole> {
    @Override
    public OrganizationRole fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("provider".equals(codeString)) {
            return OrganizationRole.PROVIDER;
        }
        if ("agency".equals(codeString)) {
            return OrganizationRole.AGENCY;
        }
        if ("research".equals(codeString)) {
            return OrganizationRole.RESEARCH;
        }
        if ("payer".equals(codeString)) {
            return OrganizationRole.PAYER;
        }
        if ("diagnostics".equals(codeString)) {
            return OrganizationRole.DIAGNOSTICS;
        }
        if ("supplier".equals(codeString)) {
            return OrganizationRole.SUPPLIER;
        }
        if ("HIE/HIO".equals(codeString)) {
            return OrganizationRole.HIE_HIO;
        }
        if ("member".equals(codeString)) {
            return OrganizationRole.MEMBER;
        }
        throw new IllegalArgumentException("Unknown OrganizationRole code '" + codeString + "'");
    }

    @Override
    public String toCode(OrganizationRole code) {
        if (code == OrganizationRole.NULL) {
            return null;
        }
        if (code == OrganizationRole.PROVIDER) {
            return "provider";
        }
        if (code == OrganizationRole.AGENCY) {
            return "agency";
        }
        if (code == OrganizationRole.RESEARCH) {
            return "research";
        }
        if (code == OrganizationRole.PAYER) {
            return "payer";
        }
        if (code == OrganizationRole.DIAGNOSTICS) {
            return "diagnostics";
        }
        if (code == OrganizationRole.SUPPLIER) {
            return "supplier";
        }
        if (code == OrganizationRole.HIE_HIO) {
            return "HIE/HIO";
        }
        if (code == OrganizationRole.MEMBER) {
            return "member";
        }
        return "?";
    }

    @Override
    public String toSystem(OrganizationRole code) {
        return code.getSystem();
    }
}

