/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CareTeamStatus {
    PROPOSED,
    ACTIVE,
    SUSPENDED,
    INACTIVE,
    ENTEREDINERROR,
    NULL;


    public static CareTeamStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return PROPOSED;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown CareTeamStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSED: {
                return "proposed";
            }
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case INACTIVE: {
                return "inactive";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-team-status";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSED: {
                return "The care team has been drafted and proposed, but not yet participating in the coordination and delivery of patient care.";
            }
            case ACTIVE: {
                return "The care team is currently participating in the coordination and delivery of care.";
            }
            case SUSPENDED: {
                return "The care team is temporarily on hold or suspended and not participating in the coordination and delivery of care.";
            }
            case INACTIVE: {
                return "The care team was, but is no longer, participating in the coordination and delivery of care.";
            }
            case ENTEREDINERROR: {
                return "The care team should have never existed.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSED: {
                return "Proposed";
            }
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

