/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.AdverseEventCategory;

public class AdverseEventCategoryEnumFactory
implements EnumFactory<AdverseEventCategory> {
    @Override
    public AdverseEventCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("product-problem".equals(codeString)) {
            return AdverseEventCategory.PRODUCTPROBLEM;
        }
        if ("product-quality".equals(codeString)) {
            return AdverseEventCategory.PRODUCTQUALITY;
        }
        if ("product-use-error".equals(codeString)) {
            return AdverseEventCategory.PRODUCTUSEERROR;
        }
        if ("wrong-dose".equals(codeString)) {
            return AdverseEventCategory.WRONGDOSE;
        }
        if ("incorrect-prescribing-information".equals(codeString)) {
            return AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION;
        }
        if ("wrong-technique".equals(codeString)) {
            return AdverseEventCategory.WRONGTECHNIQUE;
        }
        if ("wrong-route-of-administration".equals(codeString)) {
            return AdverseEventCategory.WRONGROUTEOFADMINISTRATION;
        }
        if ("wrong-rate".equals(codeString)) {
            return AdverseEventCategory.WRONGRATE;
        }
        if ("wrong-duration".equals(codeString)) {
            return AdverseEventCategory.WRONGDURATION;
        }
        if ("wrong-time".equals(codeString)) {
            return AdverseEventCategory.WRONGTIME;
        }
        if ("expired-drug".equals(codeString)) {
            return AdverseEventCategory.EXPIREDDRUG;
        }
        if ("medical-device-use-error".equals(codeString)) {
            return AdverseEventCategory.MEDICALDEVICEUSEERROR;
        }
        if ("problem-different-manufacturer".equals(codeString)) {
            return AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER;
        }
        if ("unsafe-physical-environment".equals(codeString)) {
            return AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT;
        }
        throw new IllegalArgumentException("Unknown AdverseEventCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(AdverseEventCategory code) {
        if (code == AdverseEventCategory.NULL) {
            return null;
        }
        if (code == AdverseEventCategory.PRODUCTPROBLEM) {
            return "product-problem";
        }
        if (code == AdverseEventCategory.PRODUCTQUALITY) {
            return "product-quality";
        }
        if (code == AdverseEventCategory.PRODUCTUSEERROR) {
            return "product-use-error";
        }
        if (code == AdverseEventCategory.WRONGDOSE) {
            return "wrong-dose";
        }
        if (code == AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION) {
            return "incorrect-prescribing-information";
        }
        if (code == AdverseEventCategory.WRONGTECHNIQUE) {
            return "wrong-technique";
        }
        if (code == AdverseEventCategory.WRONGROUTEOFADMINISTRATION) {
            return "wrong-route-of-administration";
        }
        if (code == AdverseEventCategory.WRONGRATE) {
            return "wrong-rate";
        }
        if (code == AdverseEventCategory.WRONGDURATION) {
            return "wrong-duration";
        }
        if (code == AdverseEventCategory.WRONGTIME) {
            return "wrong-time";
        }
        if (code == AdverseEventCategory.EXPIREDDRUG) {
            return "expired-drug";
        }
        if (code == AdverseEventCategory.MEDICALDEVICEUSEERROR) {
            return "medical-device-use-error";
        }
        if (code == AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER) {
            return "problem-different-manufacturer";
        }
        if (code == AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT) {
            return "unsafe-physical-environment";
        }
        return "?";
    }

    @Override
    public String toSystem(AdverseEventCategory code) {
        return code.getSystem();
    }
}

