/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductIngredient", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductIngredient")
public class MedicinalProductIngredient
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for the ingredient", formalDefinition="The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected Identifier identifier;
    @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Ingredient role e.g. Active ingredient, excipient", formalDefinition="Ingredient role e.g. Active ingredient, excipient.")
    protected CodeableConcept role;
    @Child(name="allergenicIndicator", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the ingredient is a known or suspected allergen", formalDefinition="If the ingredient is a known or suspected allergen.")
    protected BooleanType allergenicIndicator;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this Ingredient", formalDefinition="Manufacturer of this Ingredient.")
    protected List<Reference> manufacturer;
    protected List<Organization> manufacturerTarget;
    @Child(name="specifiedSubstance", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A specified substance that comprises this ingredient", formalDefinition="A specified substance that comprises this ingredient.")
    protected List<MedicinalProductIngredientSpecifiedSubstanceComponent> specifiedSubstance;
    @Child(name="substance", type={}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredient substance", formalDefinition="The ingredient substance.")
    protected MedicinalProductIngredientSubstanceComponent substance;
    private static final long serialVersionUID = -1454686641L;

    public MedicinalProductIngredient() {
    }

    public MedicinalProductIngredient(CodeableConcept role) {
        this.role = role;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIngredient.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public MedicinalProductIngredient setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getRole() {
        if (this.role == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIngredient.role");
            }
            if (Configuration.doAutoCreate()) {
                this.role = new CodeableConcept();
            }
        }
        return this.role;
    }

    public boolean hasRole() {
        return this.role != null && !this.role.isEmpty();
    }

    public MedicinalProductIngredient setRole(CodeableConcept value) {
        this.role = value;
        return this;
    }

    public BooleanType getAllergenicIndicatorElement() {
        if (this.allergenicIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIngredient.allergenicIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.allergenicIndicator = new BooleanType();
            }
        }
        return this.allergenicIndicator;
    }

    public boolean hasAllergenicIndicatorElement() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public boolean hasAllergenicIndicator() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public MedicinalProductIngredient setAllergenicIndicatorElement(BooleanType value) {
        this.allergenicIndicator = value;
        return this;
    }

    public boolean getAllergenicIndicator() {
        return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
    }

    public MedicinalProductIngredient setAllergenicIndicator(boolean value) {
        if (this.allergenicIndicator == null) {
            this.allergenicIndicator = new BooleanType();
        }
        this.allergenicIndicator.setValue((Object)value);
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public MedicinalProductIngredient setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public MedicinalProductIngredient addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    @Deprecated
    public List<Organization> getManufacturerTarget() {
        if (this.manufacturerTarget == null) {
            this.manufacturerTarget = new ArrayList<Organization>();
        }
        return this.manufacturerTarget;
    }

    @Deprecated
    public Organization addManufacturerTarget() {
        Organization r = new Organization();
        if (this.manufacturerTarget == null) {
            this.manufacturerTarget = new ArrayList<Organization>();
        }
        this.manufacturerTarget.add(r);
        return r;
    }

    public List<MedicinalProductIngredientSpecifiedSubstanceComponent> getSpecifiedSubstance() {
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceComponent>();
        }
        return this.specifiedSubstance;
    }

    public MedicinalProductIngredient setSpecifiedSubstance(List<MedicinalProductIngredientSpecifiedSubstanceComponent> theSpecifiedSubstance) {
        this.specifiedSubstance = theSpecifiedSubstance;
        return this;
    }

    public boolean hasSpecifiedSubstance() {
        if (this.specifiedSubstance == null) {
            return false;
        }
        for (MedicinalProductIngredientSpecifiedSubstanceComponent item : this.specifiedSubstance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductIngredientSpecifiedSubstanceComponent addSpecifiedSubstance() {
        MedicinalProductIngredientSpecifiedSubstanceComponent t = new MedicinalProductIngredientSpecifiedSubstanceComponent();
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceComponent>();
        }
        this.specifiedSubstance.add(t);
        return t;
    }

    public MedicinalProductIngredient addSpecifiedSubstance(MedicinalProductIngredientSpecifiedSubstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceComponent>();
        }
        this.specifiedSubstance.add(t);
        return this;
    }

    public MedicinalProductIngredientSpecifiedSubstanceComponent getSpecifiedSubstanceFirstRep() {
        if (this.getSpecifiedSubstance().isEmpty()) {
            this.addSpecifiedSubstance();
        }
        return this.getSpecifiedSubstance().get(0);
    }

    public MedicinalProductIngredientSubstanceComponent getSubstance() {
        if (this.substance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIngredient.substance");
            }
            if (Configuration.doAutoCreate()) {
                this.substance = new MedicinalProductIngredientSubstanceComponent();
            }
        }
        return this.substance;
    }

    public boolean hasSubstance() {
        return this.substance != null && !this.substance.isEmpty();
    }

    public MedicinalProductIngredient setSubstance(MedicinalProductIngredientSubstanceComponent value) {
        this.substance = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier));
        children.add(new Property("role", "CodeableConcept", "Ingredient role e.g. Active ingredient, excipient.", 0, 1, this.role));
        children.add(new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen.", 0, 1, this.allergenicIndicator));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Ingredient.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("specifiedSubstance", "", "A specified substance that comprises this ingredient.", 0, Integer.MAX_VALUE, this.specifiedSubstance));
        children.add(new Property("substance", "", "The ingredient substance.", 0, 1, this.substance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier);
            }
            case 3506294: {
                return new Property("role", "CodeableConcept", "Ingredient role e.g. Active ingredient, excipient.", 0, 1, this.role);
            }
            case 75406931: {
                return new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen.", 0, 1, this.allergenicIndicator);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Ingredient.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -331477600: {
                return new Property("specifiedSubstance", "", "A specified substance that comprises this ingredient.", 0, Integer.MAX_VALUE, this.specifiedSubstance);
            }
            case 530040176: {
                return new Property("substance", "", "The ingredient substance.", 0, 1, this.substance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3506294: {
                Base[] baseArray;
                if (this.role == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.role;
                }
                return baseArray;
            }
            case 75406931: {
                Base[] baseArray;
                if (this.allergenicIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.allergenicIndicator;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -331477600: {
                return this.specifiedSubstance == null ? new Base[]{} : this.specifiedSubstance.toArray(new Base[this.specifiedSubstance.size()]);
            }
            case 530040176: {
                Base[] baseArray;
                if (this.substance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.substance;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3506294: {
                this.role = this.castToCodeableConcept(value);
                return value;
            }
            case 75406931: {
                this.allergenicIndicator = this.castToBoolean(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(this.castToReference(value));
                return value;
            }
            case -331477600: {
                this.getSpecifiedSubstance().add((MedicinalProductIngredientSpecifiedSubstanceComponent)value);
                return value;
            }
            case 530040176: {
                this.substance = (MedicinalProductIngredientSubstanceComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("role")) {
            this.role = this.castToCodeableConcept(value);
        } else if (name.equals("allergenicIndicator")) {
            this.allergenicIndicator = this.castToBoolean(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(this.castToReference(value));
        } else if (name.equals("specifiedSubstance")) {
            this.getSpecifiedSubstance().add((MedicinalProductIngredientSpecifiedSubstanceComponent)value);
        } else if (name.equals("substance")) {
            this.substance = (MedicinalProductIngredientSubstanceComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = null;
        } else if (name.equals("role")) {
            this.role = null;
        } else if (name.equals("allergenicIndicator")) {
            this.allergenicIndicator = null;
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().remove(this.castToReference(value));
        } else if (name.equals("specifiedSubstance")) {
            this.getSpecifiedSubstance().remove((MedicinalProductIngredientSpecifiedSubstanceComponent)value);
        } else if (name.equals("substance")) {
            this.substance = (MedicinalProductIngredientSubstanceComponent)value;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3506294: {
                return this.getRole();
            }
            case 75406931: {
                return this.getAllergenicIndicatorElement();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -331477600: {
                return this.addSpecifiedSubstance();
            }
            case 530040176: {
                return this.getSubstance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3506294: {
                return new String[]{"CodeableConcept"};
            }
            case 75406931: {
                return new String[]{"boolean"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -331477600: {
                return new String[0];
            }
            case 530040176: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("role")) {
            this.role = new CodeableConcept();
            return this.role;
        }
        if (name.equals("allergenicIndicator")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductIngredient.allergenicIndicator");
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("specifiedSubstance")) {
            return this.addSpecifiedSubstance();
        }
        if (name.equals("substance")) {
            this.substance = new MedicinalProductIngredientSubstanceComponent();
            return this.substance;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductIngredient";
    }

    @Override
    public MedicinalProductIngredient copy() {
        MedicinalProductIngredient dst = new MedicinalProductIngredient();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicinalProductIngredient dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.role = this.role == null ? null : this.role.copy();
        BooleanType booleanType = dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.specifiedSubstance != null) {
            dst.specifiedSubstance = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceComponent>();
            for (MedicinalProductIngredientSpecifiedSubstanceComponent medicinalProductIngredientSpecifiedSubstanceComponent : this.specifiedSubstance) {
                dst.specifiedSubstance.add(medicinalProductIngredientSpecifiedSubstanceComponent.copy());
            }
        }
        dst.substance = this.substance == null ? null : this.substance.copy();
    }

    protected MedicinalProductIngredient typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductIngredient)) {
            return false;
        }
        MedicinalProductIngredient o = (MedicinalProductIngredient)other_;
        return MedicinalProductIngredient.compareDeep(this.identifier, o.identifier, true) && MedicinalProductIngredient.compareDeep(this.role, o.role, true) && MedicinalProductIngredient.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true) && MedicinalProductIngredient.compareDeep(this.manufacturer, o.manufacturer, true) && MedicinalProductIngredient.compareDeep(this.specifiedSubstance, o.specifiedSubstance, true) && MedicinalProductIngredient.compareDeep(this.substance, o.substance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductIngredient)) {
            return false;
        }
        MedicinalProductIngredient o = (MedicinalProductIngredient)other_;
        return MedicinalProductIngredient.compareValues(this.allergenicIndicator, o.allergenicIndicator, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.role, this.allergenicIndicator, this.manufacturer, this.specifiedSubstance, this.substance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductIngredient;
    }

    @Block
    public static class MedicinalProductIngredientSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The ingredient substance", formalDefinition="The ingredient substance.")
        protected CodeableConcept code;
        @Child(name="strength", type={MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product", formalDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.")
        protected List<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = 1325868149L;

        public MedicinalProductIngredientSubstanceComponent() {
        }

        public MedicinalProductIngredientSubstanceComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSubstanceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicinalProductIngredientSubstanceComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public MedicinalProductIngredientSubstanceComponent setStrength(List<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (MedicinalProductIngredientSpecifiedSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent addStrength() {
            MedicinalProductIngredientSpecifiedSubstanceStrengthComponent t = new MedicinalProductIngredientSpecifiedSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public MedicinalProductIngredientSubstanceComponent addStrength(MedicinalProductIngredientSpecifiedSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The ingredient substance.", 0, 1, this.code));
            children.add(new Property("strength", "@MedicinalProductIngredient.specifiedSubstance.strength", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The ingredient substance.", 0, 1, this.code);
                }
                case 1791316033: {
                    return new Property("strength", "@MedicinalProductIngredient.specifiedSubstance.strength", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("strength")) {
                this.getStrength().remove((MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1791316033: {
                    return new String[]{"@MedicinalProductIngredient.specifiedSubstance.strength"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductIngredientSubstanceComponent copy() {
            MedicinalProductIngredientSubstanceComponent dst = new MedicinalProductIngredientSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductIngredientSubstanceComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
                for (MedicinalProductIngredientSpecifiedSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSubstanceComponent)) {
                return false;
            }
            MedicinalProductIngredientSubstanceComponent o = (MedicinalProductIngredientSubstanceComponent)other_;
            return MedicinalProductIngredientSubstanceComponent.compareDeep(this.code, o.code, true) && MedicinalProductIngredientSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSubstanceComponent)) {
                return false;
            }
            MedicinalProductIngredientSubstanceComponent o = (MedicinalProductIngredientSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.strength});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductIngredient.substance";
        }
    }

    @Block
    public static class MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Relevant reference substance", formalDefinition="Relevant reference substance.")
        protected CodeableConcept substance;
        @Child(name="strength", type={Ratio.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected Ratio strength;
        @Child(name="strengthLowLimit", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected Ratio strengthLowLimit;
        @Child(name="measurementPoint", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For when strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The country or countries for which the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        protected List<CodeableConcept> country;
        private static final long serialVersionUID = -839485716L;

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent() {
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(Ratio strength) {
            this.strength = strength;
        }

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public Ratio getStrength() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Ratio();
                }
            }
            return this.strength;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setStrength(Ratio value) {
            this.strength = value;
            return this;
        }

        public Ratio getStrengthLowLimit() {
            if (this.strengthLowLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.strengthLowLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.strengthLowLimit = new Ratio();
                }
            }
            return this.strengthLowLimit;
        }

        public boolean hasStrengthLowLimit() {
            return this.strengthLowLimit != null && !this.strengthLowLimit.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setStrengthLowLimit(Ratio value) {
            this.strengthLowLimit = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance", "CodeableConcept", "Relevant reference substance.", 0, 1, this.substance));
            children.add(new Property("strength", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strength));
            children.add(new Property("strengthLowLimit", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strengthLowLimit));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property("substance", "CodeableConcept", "Relevant reference substance.", 0, 1, this.substance);
                }
                case 1791316033: {
                    return new Property("strength", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case 1945341992: {
                    return new Property("strengthLowLimit", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strengthLowLimit);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.strength;
                    }
                    return baseArray;
                }
                case 1945341992: {
                    Base[] baseArray;
                    if (this.strengthLowLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strengthLowLimit;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToCodeableConcept(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = this.castToRatio(value);
                    return value;
                }
                case 1945341992: {
                    this.strengthLowLimit = this.castToRatio(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = this.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = this.castToCodeableConcept(value);
            } else if (name.equals("strength")) {
                this.strength = this.castToRatio(value);
            } else if (name.equals("strengthLowLimit")) {
                this.strengthLowLimit = this.castToRatio(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = this.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = null;
            } else if (name.equals("strength")) {
                this.strength = null;
            } else if (name.equals("strengthLowLimit")) {
                this.strengthLowLimit = null;
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = null;
            } else if (name.equals("country")) {
                this.getCountry().remove(this.castToCodeableConcept(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case 1791316033: {
                    return this.getStrength();
                }
                case 1945341992: {
                    return this.getStrengthLowLimit();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept"};
                }
                case 1791316033: {
                    return new String[]{"Ratio"};
                }
                case 1945341992: {
                    return new String[]{"Ratio"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("strength")) {
                this.strength = new Ratio();
                return this.strength;
            }
            if (name.equals("strengthLowLimit")) {
                this.strengthLowLimit = new Ratio();
                return this.strengthLowLimit;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductIngredient.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent copy() {
            MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent dst = new MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.strengthLowLimit = this.strengthLowLimit == null ? null : this.strengthLowLimit.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.country) {
                    dst.country.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent o = (MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)other_;
            return MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.substance, o.substance, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strength, o.strength, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strengthLowLimit, o.strengthLowLimit, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.country, o.country, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent o = (MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)other_;
            return MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substance, this.strength, this.strengthLowLimit, this.measurementPoint, this.country});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductIngredient.specifiedSubstance.strength.referenceStrength";
        }
    }

    @Block
    public static class MedicinalProductIngredientSpecifiedSubstanceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="presentation", type={Ratio.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item", formalDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.")
        protected Ratio presentation;
        @Child(name="presentationLowLimit", type={Ratio.class}, order=2, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="A lower limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the lower limit, with the presentation attribute becoming the upper limit", formalDefinition="A lower limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the lower limit, with the presentation attribute becoming the upper limit.")
        protected Ratio presentationLowLimit;
        @Child(name="concentration", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The strength per unitary volume (or mass)", formalDefinition="The strength per unitary volume (or mass).")
        protected Ratio concentration;
        @Child(name="concentrationLowLimit", type={Ratio.class}, order=4, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="A lower limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the upper limit", formalDefinition="A lower limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the upper limit.")
        protected Ratio concentrationLowLimit;
        @Child(name="measurementPoint", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For when strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The country or countries for which the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        protected List<CodeableConcept> country;
        @Child(name="referenceStrength", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected List<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent> referenceStrength;
        private static final long serialVersionUID = 1981438822L;

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent() {
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent(Ratio presentation) {
            this.presentation = presentation;
        }

        public Ratio getPresentation() {
            if (this.presentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.presentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.presentation = new Ratio();
                }
            }
            return this.presentation;
        }

        public boolean hasPresentation() {
            return this.presentation != null && !this.presentation.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setPresentation(Ratio value) {
            this.presentation = value;
            return this;
        }

        public Ratio getPresentationLowLimit() {
            if (this.presentationLowLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.presentationLowLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.presentationLowLimit = new Ratio();
                }
            }
            return this.presentationLowLimit;
        }

        public boolean hasPresentationLowLimit() {
            return this.presentationLowLimit != null && !this.presentationLowLimit.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setPresentationLowLimit(Ratio value) {
            this.presentationLowLimit = value;
            return this;
        }

        public Ratio getConcentration() {
            if (this.concentration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.concentration");
                }
                if (Configuration.doAutoCreate()) {
                    this.concentration = new Ratio();
                }
            }
            return this.concentration;
        }

        public boolean hasConcentration() {
            return this.concentration != null && !this.concentration.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setConcentration(Ratio value) {
            this.concentration = value;
            return this;
        }

        public Ratio getConcentrationLowLimit() {
            if (this.concentrationLowLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.concentrationLowLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.concentrationLowLimit = new Ratio();
                }
            }
            return this.concentrationLowLimit;
        }

        public boolean hasConcentrationLowLimit() {
            return this.concentrationLowLimit != null && !this.concentrationLowLimit.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setConcentrationLowLimit(Ratio value) {
            this.concentrationLowLimit = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        public List<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent> getReferenceStrength() {
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
            }
            return this.referenceStrength;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent setReferenceStrength(List<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent> theReferenceStrength) {
            this.referenceStrength = theReferenceStrength;
            return this;
        }

        public boolean hasReferenceStrength() {
            if (this.referenceStrength == null) {
                return false;
            }
            for (MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent item : this.referenceStrength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent addReferenceStrength() {
            MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent t = new MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return t;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent addReferenceStrength(MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return this;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent getReferenceStrengthFirstRep() {
            if (this.getReferenceStrength().isEmpty()) {
                this.addReferenceStrength();
            }
            return this.getReferenceStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("presentation", "Ratio", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation));
            children.add(new Property("presentationLowLimit", "Ratio", "A lower limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the lower limit, with the presentation attribute becoming the upper limit.", 0, 1, this.presentationLowLimit));
            children.add(new Property("concentration", "Ratio", "The strength per unitary volume (or mass).", 0, 1, this.concentration));
            children.add(new Property("concentrationLowLimit", "Ratio", "A lower limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the upper limit.", 0, 1, this.concentrationLowLimit));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
            children.add(new Property("referenceStrength", "", "Strength expressed in terms of a reference substance.", 0, Integer.MAX_VALUE, this.referenceStrength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 696975130: {
                    return new Property("presentation", "Ratio", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case -819112447: {
                    return new Property("presentationLowLimit", "Ratio", "A lower limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the lower limit, with the presentation attribute becoming the upper limit.", 0, 1, this.presentationLowLimit);
                }
                case -410557331: {
                    return new Property("concentration", "Ratio", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -484132780: {
                    return new Property("concentrationLowLimit", "Ratio", "A lower limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the upper limit.", 0, 1, this.concentrationLowLimit);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
                case 1943566508: {
                    return new Property("referenceStrength", "", "Strength expressed in terms of a reference substance.", 0, Integer.MAX_VALUE, this.referenceStrength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    Base[] baseArray;
                    if (this.presentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.presentation;
                    }
                    return baseArray;
                }
                case -819112447: {
                    Base[] baseArray;
                    if (this.presentationLowLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.presentationLowLimit;
                    }
                    return baseArray;
                }
                case -410557331: {
                    Base[] baseArray;
                    if (this.concentration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.concentration;
                    }
                    return baseArray;
                }
                case -484132780: {
                    Base[] baseArray;
                    if (this.concentrationLowLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.concentrationLowLimit;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
                case 1943566508: {
                    return this.referenceStrength == null ? new Base[]{} : this.referenceStrength.toArray(new Base[this.referenceStrength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    this.presentation = this.castToRatio(value);
                    return value;
                }
                case -819112447: {
                    this.presentationLowLimit = this.castToRatio(value);
                    return value;
                }
                case -410557331: {
                    this.concentration = this.castToRatio(value);
                    return value;
                }
                case -484132780: {
                    this.concentrationLowLimit = this.castToRatio(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = this.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1943566508: {
                    this.getReferenceStrength().add((MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("presentation")) {
                this.presentation = this.castToRatio(value);
            } else if (name.equals("presentationLowLimit")) {
                this.presentationLowLimit = this.castToRatio(value);
            } else if (name.equals("concentration")) {
                this.concentration = this.castToRatio(value);
            } else if (name.equals("concentrationLowLimit")) {
                this.concentrationLowLimit = this.castToRatio(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = this.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(this.castToCodeableConcept(value));
            } else if (name.equals("referenceStrength")) {
                this.getReferenceStrength().add((MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("presentation")) {
                this.presentation = null;
            } else if (name.equals("presentationLowLimit")) {
                this.presentationLowLimit = null;
            } else if (name.equals("concentration")) {
                this.concentration = null;
            } else if (name.equals("concentrationLowLimit")) {
                this.concentrationLowLimit = null;
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = null;
            } else if (name.equals("country")) {
                this.getCountry().remove(this.castToCodeableConcept(value));
            } else if (name.equals("referenceStrength")) {
                this.getReferenceStrength().remove((MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    return this.getPresentation();
                }
                case -819112447: {
                    return this.getPresentationLowLimit();
                }
                case -410557331: {
                    return this.getConcentration();
                }
                case -484132780: {
                    return this.getConcentrationLowLimit();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
                case 1943566508: {
                    return this.addReferenceStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    return new String[]{"Ratio"};
                }
                case -819112447: {
                    return new String[]{"Ratio"};
                }
                case -410557331: {
                    return new String[]{"Ratio"};
                }
                case -484132780: {
                    return new String[]{"Ratio"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case 1943566508: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("presentation")) {
                this.presentation = new Ratio();
                return this.presentation;
            }
            if (name.equals("presentationLowLimit")) {
                this.presentationLowLimit = new Ratio();
                return this.presentationLowLimit;
            }
            if (name.equals("concentration")) {
                this.concentration = new Ratio();
                return this.concentration;
            }
            if (name.equals("concentrationLowLimit")) {
                this.concentrationLowLimit = new Ratio();
                return this.concentrationLowLimit;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductIngredient.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            if (name.equals("referenceStrength")) {
                return this.addReferenceStrength();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent copy() {
            MedicinalProductIngredientSpecifiedSubstanceStrengthComponent dst = new MedicinalProductIngredientSpecifiedSubstanceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductIngredientSpecifiedSubstanceStrengthComponent dst) {
            super.copyValues(dst);
            dst.presentation = this.presentation == null ? null : this.presentation.copy();
            dst.presentationLowLimit = this.presentationLowLimit == null ? null : this.presentationLowLimit.copy();
            dst.concentration = this.concentration == null ? null : this.concentration.copy();
            dst.concentrationLowLimit = this.concentrationLowLimit == null ? null : this.concentrationLowLimit.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.country) {
                    dst.country.add(codeableConcept.copy());
                }
            }
            if (this.referenceStrength != null) {
                dst.referenceStrength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
                for (MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent medicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent : this.referenceStrength) {
                    dst.referenceStrength.add(medicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)) {
                return false;
            }
            MedicinalProductIngredientSpecifiedSubstanceStrengthComponent o = (MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)other_;
            return MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.presentation, o.presentation, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.presentationLowLimit, o.presentationLowLimit, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.concentration, o.concentration, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.concentrationLowLimit, o.concentrationLowLimit, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.country, o.country, true) && MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.referenceStrength, o.referenceStrength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)) {
                return false;
            }
            MedicinalProductIngredientSpecifiedSubstanceStrengthComponent o = (MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)other_;
            return MedicinalProductIngredientSpecifiedSubstanceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.presentation, this.presentationLowLimit, this.concentration, this.concentrationLowLimit, this.measurementPoint, this.country, this.referenceStrength});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductIngredient.specifiedSubstance.strength";
        }
    }

    @Block
    public static class MedicinalProductIngredientSpecifiedSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specified substance", formalDefinition="The specified substance.")
        protected CodeableConcept code;
        @Child(name="group", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The group of specified substance, e.g. group 1 to 4", formalDefinition="The group of specified substance, e.g. group 1 to 4.")
        protected CodeableConcept group;
        @Child(name="confidentiality", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Confidentiality level of the specified substance as the ingredient", formalDefinition="Confidentiality level of the specified substance as the ingredient.")
        protected CodeableConcept confidentiality;
        @Child(name="strength", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product", formalDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.")
        protected List<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = -272590200L;

        public MedicinalProductIngredientSpecifiedSubstanceComponent() {
        }

        public MedicinalProductIngredientSpecifiedSubstanceComponent(CodeableConcept code, CodeableConcept group) {
            this.code = code;
            this.group = group;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getGroup() {
            if (this.group == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceComponent.group");
                }
                if (Configuration.doAutoCreate()) {
                    this.group = new CodeableConcept();
                }
            }
            return this.group;
        }

        public boolean hasGroup() {
            return this.group != null && !this.group.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceComponent setGroup(CodeableConcept value) {
            this.group = value;
            return this;
        }

        public CodeableConcept getConfidentiality() {
            if (this.confidentiality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIngredientSpecifiedSubstanceComponent.confidentiality");
                }
                if (Configuration.doAutoCreate()) {
                    this.confidentiality = new CodeableConcept();
                }
            }
            return this.confidentiality;
        }

        public boolean hasConfidentiality() {
            return this.confidentiality != null && !this.confidentiality.isEmpty();
        }

        public MedicinalProductIngredientSpecifiedSubstanceComponent setConfidentiality(CodeableConcept value) {
            this.confidentiality = value;
            return this;
        }

        public List<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public MedicinalProductIngredientSpecifiedSubstanceComponent setStrength(List<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (MedicinalProductIngredientSpecifiedSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent addStrength() {
            MedicinalProductIngredientSpecifiedSubstanceStrengthComponent t = new MedicinalProductIngredientSpecifiedSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public MedicinalProductIngredientSpecifiedSubstanceComponent addStrength(MedicinalProductIngredientSpecifiedSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public MedicinalProductIngredientSpecifiedSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The specified substance.", 0, 1, this.code));
            children.add(new Property("group", "CodeableConcept", "The group of specified substance, e.g. group 1 to 4.", 0, 1, this.group));
            children.add(new Property("confidentiality", "CodeableConcept", "Confidentiality level of the specified substance as the ingredient.", 0, 1, this.confidentiality));
            children.add(new Property("strength", "", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The specified substance.", 0, 1, this.code);
                }
                case 98629247: {
                    return new Property("group", "CodeableConcept", "The group of specified substance, e.g. group 1 to 4.", 0, 1, this.group);
                }
                case -1923018202: {
                    return new Property("confidentiality", "CodeableConcept", "Confidentiality level of the specified substance as the ingredient.", 0, 1, this.confidentiality);
                }
                case 1791316033: {
                    return new Property("strength", "", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 98629247: {
                    Base[] baseArray;
                    if (this.group == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.group;
                    }
                    return baseArray;
                }
                case -1923018202: {
                    Base[] baseArray;
                    if (this.confidentiality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.confidentiality;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 98629247: {
                    this.group = this.castToCodeableConcept(value);
                    return value;
                }
                case -1923018202: {
                    this.confidentiality = this.castToCodeableConcept(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("group")) {
                this.group = this.castToCodeableConcept(value);
            } else if (name.equals("confidentiality")) {
                this.confidentiality = this.castToCodeableConcept(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("group")) {
                this.group = null;
            } else if (name.equals("confidentiality")) {
                this.confidentiality = null;
            } else if (name.equals("strength")) {
                this.getStrength().remove((MedicinalProductIngredientSpecifiedSubstanceStrengthComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 98629247: {
                    return this.getGroup();
                }
                case -1923018202: {
                    return this.getConfidentiality();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 98629247: {
                    return new String[]{"CodeableConcept"};
                }
                case -1923018202: {
                    return new String[]{"CodeableConcept"};
                }
                case 1791316033: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("group")) {
                this.group = new CodeableConcept();
                return this.group;
            }
            if (name.equals("confidentiality")) {
                this.confidentiality = new CodeableConcept();
                return this.confidentiality;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductIngredientSpecifiedSubstanceComponent copy() {
            MedicinalProductIngredientSpecifiedSubstanceComponent dst = new MedicinalProductIngredientSpecifiedSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductIngredientSpecifiedSubstanceComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.group = this.group == null ? null : this.group.copy();
            CodeableConcept codeableConcept = dst.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<MedicinalProductIngredientSpecifiedSubstanceStrengthComponent>();
                for (MedicinalProductIngredientSpecifiedSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSpecifiedSubstanceComponent)) {
                return false;
            }
            MedicinalProductIngredientSpecifiedSubstanceComponent o = (MedicinalProductIngredientSpecifiedSubstanceComponent)other_;
            return MedicinalProductIngredientSpecifiedSubstanceComponent.compareDeep(this.code, o.code, true) && MedicinalProductIngredientSpecifiedSubstanceComponent.compareDeep(this.group, o.group, true) && MedicinalProductIngredientSpecifiedSubstanceComponent.compareDeep(this.confidentiality, o.confidentiality, true) && MedicinalProductIngredientSpecifiedSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIngredientSpecifiedSubstanceComponent)) {
                return false;
            }
            MedicinalProductIngredientSpecifiedSubstanceComponent o = (MedicinalProductIngredientSpecifiedSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.group, this.confidentiality, this.strength});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductIngredient.specifiedSubstance";
        }
    }
}

