/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class Unbundler {
    public static void main(String[] args) throws Exception {
        Unbundler.unbundle(args[0]);
    }

    private static void unbundle(String src) throws FHIRFormatError, FileNotFoundException, IOException {
        String folder = Utilities.getDirectoryForFile((String)src);
        Bundle bnd = (Bundle)new JsonParser().parse(ManagedFileAccess.inStream((String)src));
        for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
            String tgt;
            Resource r = be.getResource();
            if (r == null) continue;
            if (StringUtils.isBlank((CharSequence)r.getId()) && r instanceof MetadataResource) {
                r.setId(Unbundler.tail((MetadataResource)r));
            }
            if (StringUtils.isBlank((CharSequence)r.getId()) || ManagedFileAccess.file((String)(tgt = Utilities.path((String[])new String[]{folder, r.fhirType() + "-" + r.getId() + ".json"}))).exists()) continue;
            new JsonParser().compose(ManagedFileAccess.outStream((String)tgt), r);
        }
    }

    private static String tail(MetadataResource r) {
        return r.getUrl().contains("/") ? r.getUrl().substring(r.getUrl().lastIndexOf("/") + 1) : null;
    }
}

