/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MessageSignificanceCategory {
    CONSEQUENCE,
    CURRENCY,
    NOTIFICATION,
    NULL;


    public static MessageSignificanceCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("consequence".equals(codeString)) {
            return CONSEQUENCE;
        }
        if ("currency".equals(codeString)) {
            return CURRENCY;
        }
        if ("notification".equals(codeString)) {
            return NOTIFICATION;
        }
        throw new FHIRException("Unknown MessageSignificanceCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CONSEQUENCE: {
                return "consequence";
            }
            case CURRENCY: {
                return "currency";
            }
            case NOTIFICATION: {
                return "notification";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/message-significance-category";
    }

    public String getDefinition() {
        switch (this) {
            case CONSEQUENCE: {
                return "The message represents/requests a change that should not be processed more than once; e.g., making a booking for an appointment.";
            }
            case CURRENCY: {
                return "The message represents a response to query for current information. Retrospective processing is wrong and/or wasteful.";
            }
            case NOTIFICATION: {
                return "The content is not necessarily intended to be current, and it can be reprocessed, though there may be version issues created by processing old notifications.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CONSEQUENCE: {
                return "Consequence";
            }
            case CURRENCY: {
                return "Currency";
            }
            case NOTIFICATION: {
                return "Notification";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

