/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractExpirationType {
    BREACH,
    NULL;


    public static ContractExpirationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("breach".equals(codeString)) {
            return BREACH;
        }
        throw new FHIRException("Unknown ContractExpirationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BREACH: {
                return "breach";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-expiration-type";
    }

    public String getDefinition() {
        switch (this) {
            case BREACH: {
                return "To be completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BREACH: {
                return "Breach";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

