/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceReferenceInformation", profile="http://hl7.org/fhir/StructureDefinition/SubstanceReferenceInformation")
public class SubstanceReferenceInformation
extends DomainResource {
    @Child(name="comment", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected StringType comment;
    @Child(name="gene", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<SubstanceReferenceInformationGeneComponent> gene;
    @Child(name="geneElement", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<SubstanceReferenceInformationGeneElementComponent> geneElement;
    @Child(name="classification", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<SubstanceReferenceInformationClassificationComponent> classification;
    @Child(name="target", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<SubstanceReferenceInformationTargetComponent> target;
    private static final long serialVersionUID = 890303332L;

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceReferenceInformation.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public SubstanceReferenceInformation setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public SubstanceReferenceInformation setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public List<SubstanceReferenceInformationGeneComponent> getGene() {
        if (this.gene == null) {
            this.gene = new ArrayList<SubstanceReferenceInformationGeneComponent>();
        }
        return this.gene;
    }

    public SubstanceReferenceInformation setGene(List<SubstanceReferenceInformationGeneComponent> theGene) {
        this.gene = theGene;
        return this;
    }

    public boolean hasGene() {
        if (this.gene == null) {
            return false;
        }
        for (SubstanceReferenceInformationGeneComponent item : this.gene) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceReferenceInformationGeneComponent addGene() {
        SubstanceReferenceInformationGeneComponent t = new SubstanceReferenceInformationGeneComponent();
        if (this.gene == null) {
            this.gene = new ArrayList<SubstanceReferenceInformationGeneComponent>();
        }
        this.gene.add(t);
        return t;
    }

    public SubstanceReferenceInformation addGene(SubstanceReferenceInformationGeneComponent t) {
        if (t == null) {
            return this;
        }
        if (this.gene == null) {
            this.gene = new ArrayList<SubstanceReferenceInformationGeneComponent>();
        }
        this.gene.add(t);
        return this;
    }

    public SubstanceReferenceInformationGeneComponent getGeneFirstRep() {
        if (this.getGene().isEmpty()) {
            this.addGene();
        }
        return this.getGene().get(0);
    }

    public List<SubstanceReferenceInformationGeneElementComponent> getGeneElement() {
        if (this.geneElement == null) {
            this.geneElement = new ArrayList<SubstanceReferenceInformationGeneElementComponent>();
        }
        return this.geneElement;
    }

    public SubstanceReferenceInformation setGeneElement(List<SubstanceReferenceInformationGeneElementComponent> theGeneElement) {
        this.geneElement = theGeneElement;
        return this;
    }

    public boolean hasGeneElement() {
        if (this.geneElement == null) {
            return false;
        }
        for (SubstanceReferenceInformationGeneElementComponent item : this.geneElement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceReferenceInformationGeneElementComponent addGeneElement() {
        SubstanceReferenceInformationGeneElementComponent t = new SubstanceReferenceInformationGeneElementComponent();
        if (this.geneElement == null) {
            this.geneElement = new ArrayList<SubstanceReferenceInformationGeneElementComponent>();
        }
        this.geneElement.add(t);
        return t;
    }

    public SubstanceReferenceInformation addGeneElement(SubstanceReferenceInformationGeneElementComponent t) {
        if (t == null) {
            return this;
        }
        if (this.geneElement == null) {
            this.geneElement = new ArrayList<SubstanceReferenceInformationGeneElementComponent>();
        }
        this.geneElement.add(t);
        return this;
    }

    public SubstanceReferenceInformationGeneElementComponent getGeneElementFirstRep() {
        if (this.getGeneElement().isEmpty()) {
            this.addGeneElement();
        }
        return this.getGeneElement().get(0);
    }

    public List<SubstanceReferenceInformationClassificationComponent> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<SubstanceReferenceInformationClassificationComponent>();
        }
        return this.classification;
    }

    public SubstanceReferenceInformation setClassification(List<SubstanceReferenceInformationClassificationComponent> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (SubstanceReferenceInformationClassificationComponent item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceReferenceInformationClassificationComponent addClassification() {
        SubstanceReferenceInformationClassificationComponent t = new SubstanceReferenceInformationClassificationComponent();
        if (this.classification == null) {
            this.classification = new ArrayList<SubstanceReferenceInformationClassificationComponent>();
        }
        this.classification.add(t);
        return t;
    }

    public SubstanceReferenceInformation addClassification(SubstanceReferenceInformationClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<SubstanceReferenceInformationClassificationComponent>();
        }
        this.classification.add(t);
        return this;
    }

    public SubstanceReferenceInformationClassificationComponent getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public List<SubstanceReferenceInformationTargetComponent> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<SubstanceReferenceInformationTargetComponent>();
        }
        return this.target;
    }

    public SubstanceReferenceInformation setTarget(List<SubstanceReferenceInformationTargetComponent> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (SubstanceReferenceInformationTargetComponent item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceReferenceInformationTargetComponent addTarget() {
        SubstanceReferenceInformationTargetComponent t = new SubstanceReferenceInformationTargetComponent();
        if (this.target == null) {
            this.target = new ArrayList<SubstanceReferenceInformationTargetComponent>();
        }
        this.target.add(t);
        return t;
    }

    public SubstanceReferenceInformation addTarget(SubstanceReferenceInformationTargetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.target == null) {
            this.target = new ArrayList<SubstanceReferenceInformationTargetComponent>();
        }
        this.target.add(t);
        return this;
    }

    public SubstanceReferenceInformationTargetComponent getTargetFirstRep() {
        if (this.getTarget().isEmpty()) {
            this.addTarget();
        }
        return this.getTarget().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("comment", "string", "Todo.", 0, 1, this.comment));
        children.add(new Property("gene", "", "Todo.", 0, Integer.MAX_VALUE, this.gene));
        children.add(new Property("geneElement", "", "Todo.", 0, Integer.MAX_VALUE, this.geneElement));
        children.add(new Property("classification", "", "Todo.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("target", "", "Todo.", 0, Integer.MAX_VALUE, this.target));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 950398559: {
                return new Property("comment", "string", "Todo.", 0, 1, this.comment);
            }
            case 3169045: {
                return new Property("gene", "", "Todo.", 0, Integer.MAX_VALUE, this.gene);
            }
            case -94918105: {
                return new Property("geneElement", "", "Todo.", 0, Integer.MAX_VALUE, this.geneElement);
            }
            case 382350310: {
                return new Property("classification", "", "Todo.", 0, Integer.MAX_VALUE, this.classification);
            }
            case -880905839: {
                return new Property("target", "", "Todo.", 0, Integer.MAX_VALUE, this.target);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.comment;
                }
                return baseArray;
            }
            case 3169045: {
                return this.gene == null ? new Base[]{} : this.gene.toArray(new Base[this.gene.size()]);
            }
            case -94918105: {
                return this.geneElement == null ? new Base[]{} : this.geneElement.toArray(new Base[this.geneElement.size()]);
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
            case 3169045: {
                this.getGene().add((SubstanceReferenceInformationGeneComponent)value);
                return value;
            }
            case -94918105: {
                this.getGeneElement().add((SubstanceReferenceInformationGeneElementComponent)value);
                return value;
            }
            case 382350310: {
                this.getClassification().add((SubstanceReferenceInformationClassificationComponent)value);
                return value;
            }
            case -880905839: {
                this.getTarget().add((SubstanceReferenceInformationTargetComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("gene")) {
            this.getGene().add((SubstanceReferenceInformationGeneComponent)value);
        } else if (name.equals("geneElement")) {
            this.getGeneElement().add((SubstanceReferenceInformationGeneElementComponent)value);
        } else if (name.equals("classification")) {
            this.getClassification().add((SubstanceReferenceInformationClassificationComponent)value);
        } else if (name.equals("target")) {
            this.getTarget().add((SubstanceReferenceInformationTargetComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("comment")) {
            this.comment = null;
        } else if (name.equals("gene")) {
            this.getGene().remove((SubstanceReferenceInformationGeneComponent)value);
        } else if (name.equals("geneElement")) {
            this.getGeneElement().remove((SubstanceReferenceInformationGeneElementComponent)value);
        } else if (name.equals("classification")) {
            this.getClassification().remove((SubstanceReferenceInformationClassificationComponent)value);
        } else if (name.equals("target")) {
            this.getTarget().remove((SubstanceReferenceInformationTargetComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 950398559: {
                return this.getCommentElement();
            }
            case 3169045: {
                return this.addGene();
            }
            case -94918105: {
                return this.addGeneElement();
            }
            case 382350310: {
                return this.addClassification();
            }
            case -880905839: {
                return this.addTarget();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 950398559: {
                return new String[]{"string"};
            }
            case 3169045: {
                return new String[0];
            }
            case -94918105: {
                return new String[0];
            }
            case 382350310: {
                return new String[0];
            }
            case -880905839: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubstanceReferenceInformation.comment");
        }
        if (name.equals("gene")) {
            return this.addGene();
        }
        if (name.equals("geneElement")) {
            return this.addGeneElement();
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals("target")) {
            return this.addTarget();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceReferenceInformation";
    }

    @Override
    public SubstanceReferenceInformation copy() {
        SubstanceReferenceInformation dst = new SubstanceReferenceInformation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceReferenceInformation dst) {
        super.copyValues(dst);
        StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
        if (this.gene != null) {
            dst.gene = new ArrayList<SubstanceReferenceInformationGeneComponent>();
            for (SubstanceReferenceInformationGeneComponent substanceReferenceInformationGeneComponent : this.gene) {
                dst.gene.add(substanceReferenceInformationGeneComponent.copy());
            }
        }
        if (this.geneElement != null) {
            dst.geneElement = new ArrayList<SubstanceReferenceInformationGeneElementComponent>();
            for (SubstanceReferenceInformationGeneElementComponent substanceReferenceInformationGeneElementComponent : this.geneElement) {
                dst.geneElement.add(substanceReferenceInformationGeneElementComponent.copy());
            }
        }
        if (this.classification != null) {
            dst.classification = new ArrayList<SubstanceReferenceInformationClassificationComponent>();
            for (SubstanceReferenceInformationClassificationComponent substanceReferenceInformationClassificationComponent : this.classification) {
                dst.classification.add(substanceReferenceInformationClassificationComponent.copy());
            }
        }
        if (this.target != null) {
            dst.target = new ArrayList<SubstanceReferenceInformationTargetComponent>();
            for (SubstanceReferenceInformationTargetComponent substanceReferenceInformationTargetComponent : this.target) {
                dst.target.add(substanceReferenceInformationTargetComponent.copy());
            }
        }
    }

    protected SubstanceReferenceInformation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceReferenceInformation)) {
            return false;
        }
        SubstanceReferenceInformation o = (SubstanceReferenceInformation)other_;
        return SubstanceReferenceInformation.compareDeep(this.comment, o.comment, true) && SubstanceReferenceInformation.compareDeep(this.gene, o.gene, true) && SubstanceReferenceInformation.compareDeep(this.geneElement, o.geneElement, true) && SubstanceReferenceInformation.compareDeep(this.classification, o.classification, true) && SubstanceReferenceInformation.compareDeep(this.target, o.target, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceReferenceInformation)) {
            return false;
        }
        SubstanceReferenceInformation o = (SubstanceReferenceInformation)other_;
        return SubstanceReferenceInformation.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.comment, this.gene, this.geneElement, this.classification, this.target});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceReferenceInformation;
    }

    @Block
    public static class SubstanceReferenceInformationTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="target", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected Identifier target;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept type;
        @Child(name="interaction", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept interaction;
        @Child(name="organism", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept organism;
        @Child(name="organismType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept organismType;
        @Child(name="amount", type={Quantity.class, Range.class, StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected Type amount;
        @Child(name="amountType", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept amountType;
        @Child(name="source", type={DocumentReference.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = -1682270197L;

        public Identifier getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationTargetComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Identifier();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setTarget(Identifier value) {
            this.target = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationTargetComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getInteraction() {
            if (this.interaction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationTargetComponent.interaction");
                }
                if (Configuration.doAutoCreate()) {
                    this.interaction = new CodeableConcept();
                }
            }
            return this.interaction;
        }

        public boolean hasInteraction() {
            return this.interaction != null && !this.interaction.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setInteraction(CodeableConcept value) {
            this.interaction = value;
            return this;
        }

        public CodeableConcept getOrganism() {
            if (this.organism == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationTargetComponent.organism");
                }
                if (Configuration.doAutoCreate()) {
                    this.organism = new CodeableConcept();
                }
            }
            return this.organism;
        }

        public boolean hasOrganism() {
            return this.organism != null && !this.organism.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setOrganism(CodeableConcept value) {
            this.organism = value;
            return this;
        }

        public CodeableConcept getOrganismType() {
            if (this.organismType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationTargetComponent.organismType");
                }
                if (Configuration.doAutoCreate()) {
                    this.organismType = new CodeableConcept();
                }
            }
            return this.organismType;
        }

        public boolean hasOrganismType() {
            return this.organismType != null && !this.organismType.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setOrganismType(CodeableConcept value) {
            this.organismType = value;
            return this;
        }

        public Type getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public Range getAmountRange() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Range();
            }
            if (!(this.amount instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Range)this.amount;
        }

        public boolean hasAmountRange() {
            return this != null && this.amount instanceof Range;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setAmount(Type value) {
            if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceReferenceInformation.target.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        public CodeableConcept getAmountType() {
            if (this.amountType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationTargetComponent.amountType");
                }
                if (Configuration.doAutoCreate()) {
                    this.amountType = new CodeableConcept();
                }
            }
            return this.amountType;
        }

        public boolean hasAmountType() {
            return this.amountType != null && !this.amountType.isEmpty();
        }

        public SubstanceReferenceInformationTargetComponent setAmountType(CodeableConcept value) {
            this.amountType = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceReferenceInformationTargetComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceReferenceInformationTargetComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("target", "Identifier", "Todo.", 0, 1, this.target));
            children.add(new Property("type", "CodeableConcept", "Todo.", 0, 1, this.type));
            children.add(new Property("interaction", "CodeableConcept", "Todo.", 0, 1, this.interaction));
            children.add(new Property("organism", "CodeableConcept", "Todo.", 0, 1, this.organism));
            children.add(new Property("organismType", "CodeableConcept", "Todo.", 0, 1, this.organismType));
            children.add(new Property("amount[x]", "Quantity|Range|string", "Todo.", 0, 1, this.amount));
            children.add(new Property("amountType", "CodeableConcept", "Todo.", 0, 1, this.amountType));
            children.add(new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -880905839: {
                    return new Property("target", "Identifier", "Todo.", 0, 1, this.target);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Todo.", 0, 1, this.type);
                }
                case 1844104722: {
                    return new Property("interaction", "CodeableConcept", "Todo.", 0, 1, this.interaction);
                }
                case 1316389074: {
                    return new Property("organism", "CodeableConcept", "Todo.", 0, 1, this.organism);
                }
                case 988662572: {
                    return new Property("organismType", "CodeableConcept", "Todo.", 0, 1, this.organismType);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|Range|string", "Todo.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|Range|string", "Todo.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity|Range|string", "Todo.", 0, 1, this.amount);
                }
                case -1223462971: {
                    return new Property("amount[x]", "Quantity|Range|string", "Todo.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "Quantity|Range|string", "Todo.", 0, 1, this.amount);
                }
                case -1424857166: {
                    return new Property("amountType", "CodeableConcept", "Todo.", 0, 1, this.amountType);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.target;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1844104722: {
                    Base[] baseArray;
                    if (this.interaction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.interaction;
                    }
                    return baseArray;
                }
                case 1316389074: {
                    Base[] baseArray;
                    if (this.organism == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.organism;
                    }
                    return baseArray;
                }
                case 988662572: {
                    Base[] baseArray;
                    if (this.organismType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.organismType;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1424857166: {
                    Base[] baseArray;
                    if (this.amountType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.amountType;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -880905839: {
                    this.target = this.castToIdentifier(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1844104722: {
                    this.interaction = this.castToCodeableConcept(value);
                    return value;
                }
                case 1316389074: {
                    this.organism = this.castToCodeableConcept(value);
                    return value;
                }
                case 988662572: {
                    this.organismType = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToType(value);
                    return value;
                }
                case -1424857166: {
                    this.amountType = this.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("target")) {
                this.target = this.castToIdentifier(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("interaction")) {
                this.interaction = this.castToCodeableConcept(value);
            } else if (name.equals("organism")) {
                this.organism = this.castToCodeableConcept(value);
            } else if (name.equals("organismType")) {
                this.organismType = this.castToCodeableConcept(value);
            } else if (name.equals("amount[x]")) {
                this.amount = this.castToType(value);
            } else if (name.equals("amountType")) {
                this.amountType = this.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("target")) {
                this.target = null;
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("interaction")) {
                this.interaction = null;
            } else if (name.equals("organism")) {
                this.organism = null;
            } else if (name.equals("organismType")) {
                this.organismType = null;
            } else if (name.equals("amount[x]")) {
                this.amount = null;
            } else if (name.equals("amountType")) {
                this.amountType = null;
            } else if (name.equals("source")) {
                this.getSource().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -880905839: {
                    return this.getTarget();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1844104722: {
                    return this.getInteraction();
                }
                case 1316389074: {
                    return this.getOrganism();
                }
                case 988662572: {
                    return this.getOrganismType();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1424857166: {
                    return this.getAmountType();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -880905839: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1844104722: {
                    return new String[]{"CodeableConcept"};
                }
                case 1316389074: {
                    return new String[]{"CodeableConcept"};
                }
                case 988662572: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "Range", "string"};
                }
                case -1424857166: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("target")) {
                this.target = new Identifier();
                return this.target;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("interaction")) {
                this.interaction = new CodeableConcept();
                return this.interaction;
            }
            if (name.equals("organism")) {
                this.organism = new CodeableConcept();
                return this.organism;
            }
            if (name.equals("organismType")) {
                this.organismType = new CodeableConcept();
                return this.organismType;
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountRange")) {
                this.amount = new Range();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            if (name.equals("amountType")) {
                this.amountType = new CodeableConcept();
                return this.amountType;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceReferenceInformationTargetComponent copy() {
            SubstanceReferenceInformationTargetComponent dst = new SubstanceReferenceInformationTargetComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceReferenceInformationTargetComponent dst) {
            super.copyValues(dst);
            dst.target = this.target == null ? null : this.target.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.interaction = this.interaction == null ? null : this.interaction.copy();
            dst.organism = this.organism == null ? null : this.organism.copy();
            dst.organismType = this.organismType == null ? null : this.organismType.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            CodeableConcept codeableConcept = dst.amountType = this.amountType == null ? null : this.amountType.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationTargetComponent)) {
                return false;
            }
            SubstanceReferenceInformationTargetComponent o = (SubstanceReferenceInformationTargetComponent)other_;
            return SubstanceReferenceInformationTargetComponent.compareDeep(this.target, o.target, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.type, o.type, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.interaction, o.interaction, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.organism, o.organism, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.organismType, o.organismType, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.amount, o.amount, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.amountType, o.amountType, true) && SubstanceReferenceInformationTargetComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationTargetComponent)) {
                return false;
            }
            SubstanceReferenceInformationTargetComponent o = (SubstanceReferenceInformationTargetComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.target, this.type, this.interaction, this.organism, this.organismType, this.amount, this.amountType, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceReferenceInformation.target";
        }
    }

    @Block
    public static class SubstanceReferenceInformationClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="domain", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept domain;
        @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept classification;
        @Child(name="subtype", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<CodeableConcept> subtype;
        @Child(name="source", type={DocumentReference.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = -430084579L;

        public CodeableConcept getDomain() {
            if (this.domain == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationClassificationComponent.domain");
                }
                if (Configuration.doAutoCreate()) {
                    this.domain = new CodeableConcept();
                }
            }
            return this.domain;
        }

        public boolean hasDomain() {
            return this.domain != null && !this.domain.isEmpty();
        }

        public SubstanceReferenceInformationClassificationComponent setDomain(CodeableConcept value) {
            this.domain = value;
            return this;
        }

        public CodeableConcept getClassification() {
            if (this.classification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationClassificationComponent.classification");
                }
                if (Configuration.doAutoCreate()) {
                    this.classification = new CodeableConcept();
                }
            }
            return this.classification;
        }

        public boolean hasClassification() {
            return this.classification != null && !this.classification.isEmpty();
        }

        public SubstanceReferenceInformationClassificationComponent setClassification(CodeableConcept value) {
            this.classification = value;
            return this;
        }

        public List<CodeableConcept> getSubtype() {
            if (this.subtype == null) {
                this.subtype = new ArrayList<CodeableConcept>();
            }
            return this.subtype;
        }

        public SubstanceReferenceInformationClassificationComponent setSubtype(List<CodeableConcept> theSubtype) {
            this.subtype = theSubtype;
            return this;
        }

        public boolean hasSubtype() {
            if (this.subtype == null) {
                return false;
            }
            for (CodeableConcept item : this.subtype) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubtype() {
            CodeableConcept t = new CodeableConcept();
            if (this.subtype == null) {
                this.subtype = new ArrayList<CodeableConcept>();
            }
            this.subtype.add(t);
            return t;
        }

        public SubstanceReferenceInformationClassificationComponent addSubtype(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subtype == null) {
                this.subtype = new ArrayList<CodeableConcept>();
            }
            this.subtype.add(t);
            return this;
        }

        public CodeableConcept getSubtypeFirstRep() {
            if (this.getSubtype().isEmpty()) {
                this.addSubtype();
            }
            return this.getSubtype().get(0);
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceReferenceInformationClassificationComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceReferenceInformationClassificationComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("domain", "CodeableConcept", "Todo.", 0, 1, this.domain));
            children.add(new Property("classification", "CodeableConcept", "Todo.", 0, 1, this.classification));
            children.add(new Property("subtype", "CodeableConcept", "Todo.", 0, Integer.MAX_VALUE, this.subtype));
            children.add(new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1326197564: {
                    return new Property("domain", "CodeableConcept", "Todo.", 0, 1, this.domain);
                }
                case 382350310: {
                    return new Property("classification", "CodeableConcept", "Todo.", 0, 1, this.classification);
                }
                case -1867567750: {
                    return new Property("subtype", "CodeableConcept", "Todo.", 0, Integer.MAX_VALUE, this.subtype);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1326197564: {
                    Base[] baseArray;
                    if (this.domain == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.domain;
                    }
                    return baseArray;
                }
                case 382350310: {
                    Base[] baseArray;
                    if (this.classification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.classification;
                    }
                    return baseArray;
                }
                case -1867567750: {
                    return this.subtype == null ? new Base[]{} : this.subtype.toArray(new Base[this.subtype.size()]);
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1326197564: {
                    this.domain = this.castToCodeableConcept(value);
                    return value;
                }
                case 382350310: {
                    this.classification = this.castToCodeableConcept(value);
                    return value;
                }
                case -1867567750: {
                    this.getSubtype().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("domain")) {
                this.domain = this.castToCodeableConcept(value);
            } else if (name.equals("classification")) {
                this.classification = this.castToCodeableConcept(value);
            } else if (name.equals("subtype")) {
                this.getSubtype().add(this.castToCodeableConcept(value));
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("domain")) {
                this.domain = null;
            } else if (name.equals("classification")) {
                this.classification = null;
            } else if (name.equals("subtype")) {
                this.getSubtype().remove(this.castToCodeableConcept(value));
            } else if (name.equals("source")) {
                this.getSource().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326197564: {
                    return this.getDomain();
                }
                case 382350310: {
                    return this.getClassification();
                }
                case -1867567750: {
                    return this.addSubtype();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326197564: {
                    return new String[]{"CodeableConcept"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
                case -1867567750: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("domain")) {
                this.domain = new CodeableConcept();
                return this.domain;
            }
            if (name.equals("classification")) {
                this.classification = new CodeableConcept();
                return this.classification;
            }
            if (name.equals("subtype")) {
                return this.addSubtype();
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceReferenceInformationClassificationComponent copy() {
            SubstanceReferenceInformationClassificationComponent dst = new SubstanceReferenceInformationClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceReferenceInformationClassificationComponent dst) {
            super.copyValues(dst);
            dst.domain = this.domain == null ? null : this.domain.copy();
            CodeableConcept codeableConcept = dst.classification = this.classification == null ? null : this.classification.copy();
            if (this.subtype != null) {
                dst.subtype = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.subtype) {
                    dst.subtype.add(codeableConcept2.copy());
                }
            }
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference reference : this.source) {
                    dst.source.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationClassificationComponent)) {
                return false;
            }
            SubstanceReferenceInformationClassificationComponent o = (SubstanceReferenceInformationClassificationComponent)other_;
            return SubstanceReferenceInformationClassificationComponent.compareDeep(this.domain, o.domain, true) && SubstanceReferenceInformationClassificationComponent.compareDeep(this.classification, o.classification, true) && SubstanceReferenceInformationClassificationComponent.compareDeep(this.subtype, o.subtype, true) && SubstanceReferenceInformationClassificationComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationClassificationComponent)) {
                return false;
            }
            SubstanceReferenceInformationClassificationComponent o = (SubstanceReferenceInformationClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.domain, this.classification, this.subtype, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceReferenceInformation.classification";
        }
    }

    @Block
    public static class SubstanceReferenceInformationGeneElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept type;
        @Child(name="element", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected Identifier element;
        @Child(name="source", type={DocumentReference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = 2055145950L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationGeneElementComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceReferenceInformationGeneElementComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Identifier getElement() {
            if (this.element == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationGeneElementComponent.element");
                }
                if (Configuration.doAutoCreate()) {
                    this.element = new Identifier();
                }
            }
            return this.element;
        }

        public boolean hasElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public SubstanceReferenceInformationGeneElementComponent setElement(Identifier value) {
            this.element = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceReferenceInformationGeneElementComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceReferenceInformationGeneElementComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Todo.", 0, 1, this.type));
            children.add(new Property("element", "Identifier", "Todo.", 0, 1, this.element));
            children.add(new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Todo.", 0, 1, this.type);
                }
                case -1662836996: {
                    return new Property("element", "Identifier", "Todo.", 0, 1, this.element);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    Base[] baseArray;
                    if (this.element == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.element;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1662836996: {
                    this.element = this.castToIdentifier(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("element")) {
                this.element = this.castToIdentifier(value);
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("element")) {
                this.element = null;
            } else if (name.equals("source")) {
                this.getSource().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1662836996: {
                    return this.getElement();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1662836996: {
                    return new String[]{"Identifier"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("element")) {
                this.element = new Identifier();
                return this.element;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceReferenceInformationGeneElementComponent copy() {
            SubstanceReferenceInformationGeneElementComponent dst = new SubstanceReferenceInformationGeneElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceReferenceInformationGeneElementComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Identifier identifier = dst.element = this.element == null ? null : this.element.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationGeneElementComponent)) {
                return false;
            }
            SubstanceReferenceInformationGeneElementComponent o = (SubstanceReferenceInformationGeneElementComponent)other_;
            return SubstanceReferenceInformationGeneElementComponent.compareDeep(this.type, o.type, true) && SubstanceReferenceInformationGeneElementComponent.compareDeep(this.element, o.element, true) && SubstanceReferenceInformationGeneElementComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationGeneElementComponent)) {
                return false;
            }
            SubstanceReferenceInformationGeneElementComponent o = (SubstanceReferenceInformationGeneElementComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.element, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceReferenceInformation.geneElement";
        }
    }

    @Block
    public static class SubstanceReferenceInformationGeneComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="geneSequenceOrigin", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept geneSequenceOrigin;
        @Child(name="gene", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept gene;
        @Child(name="source", type={DocumentReference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = 1615185105L;

        public CodeableConcept getGeneSequenceOrigin() {
            if (this.geneSequenceOrigin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationGeneComponent.geneSequenceOrigin");
                }
                if (Configuration.doAutoCreate()) {
                    this.geneSequenceOrigin = new CodeableConcept();
                }
            }
            return this.geneSequenceOrigin;
        }

        public boolean hasGeneSequenceOrigin() {
            return this.geneSequenceOrigin != null && !this.geneSequenceOrigin.isEmpty();
        }

        public SubstanceReferenceInformationGeneComponent setGeneSequenceOrigin(CodeableConcept value) {
            this.geneSequenceOrigin = value;
            return this;
        }

        public CodeableConcept getGene() {
            if (this.gene == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceReferenceInformationGeneComponent.gene");
                }
                if (Configuration.doAutoCreate()) {
                    this.gene = new CodeableConcept();
                }
            }
            return this.gene;
        }

        public boolean hasGene() {
            return this.gene != null && !this.gene.isEmpty();
        }

        public SubstanceReferenceInformationGeneComponent setGene(CodeableConcept value) {
            this.gene = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceReferenceInformationGeneComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceReferenceInformationGeneComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("geneSequenceOrigin", "CodeableConcept", "Todo.", 0, 1, this.geneSequenceOrigin));
            children.add(new Property("gene", "CodeableConcept", "Todo.", 0, 1, this.gene));
            children.add(new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1089463108: {
                    return new Property("geneSequenceOrigin", "CodeableConcept", "Todo.", 0, 1, this.geneSequenceOrigin);
                }
                case 3169045: {
                    return new Property("gene", "CodeableConcept", "Todo.", 0, 1, this.gene);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Todo.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1089463108: {
                    Base[] baseArray;
                    if (this.geneSequenceOrigin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.geneSequenceOrigin;
                    }
                    return baseArray;
                }
                case 3169045: {
                    Base[] baseArray;
                    if (this.gene == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.gene;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1089463108: {
                    this.geneSequenceOrigin = this.castToCodeableConcept(value);
                    return value;
                }
                case 3169045: {
                    this.gene = this.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("geneSequenceOrigin")) {
                this.geneSequenceOrigin = this.castToCodeableConcept(value);
            } else if (name.equals("gene")) {
                this.gene = this.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("geneSequenceOrigin")) {
                this.geneSequenceOrigin = null;
            } else if (name.equals("gene")) {
                this.gene = null;
            } else if (name.equals("source")) {
                this.getSource().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1089463108: {
                    return this.getGeneSequenceOrigin();
                }
                case 3169045: {
                    return this.getGene();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1089463108: {
                    return new String[]{"CodeableConcept"};
                }
                case 3169045: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("geneSequenceOrigin")) {
                this.geneSequenceOrigin = new CodeableConcept();
                return this.geneSequenceOrigin;
            }
            if (name.equals("gene")) {
                this.gene = new CodeableConcept();
                return this.gene;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceReferenceInformationGeneComponent copy() {
            SubstanceReferenceInformationGeneComponent dst = new SubstanceReferenceInformationGeneComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceReferenceInformationGeneComponent dst) {
            super.copyValues(dst);
            dst.geneSequenceOrigin = this.geneSequenceOrigin == null ? null : this.geneSequenceOrigin.copy();
            CodeableConcept codeableConcept = dst.gene = this.gene == null ? null : this.gene.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationGeneComponent)) {
                return false;
            }
            SubstanceReferenceInformationGeneComponent o = (SubstanceReferenceInformationGeneComponent)other_;
            return SubstanceReferenceInformationGeneComponent.compareDeep(this.geneSequenceOrigin, o.geneSequenceOrigin, true) && SubstanceReferenceInformationGeneComponent.compareDeep(this.gene, o.gene, true) && SubstanceReferenceInformationGeneComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceReferenceInformationGeneComponent)) {
                return false;
            }
            SubstanceReferenceInformationGeneComponent o = (SubstanceReferenceInformationGeneComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.geneSequenceOrigin, this.gene, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceReferenceInformation.gene";
        }
    }
}

