/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="NamingSystem", profile="http://hl7.org/fhir/StructureDefinition/NamingSystem")
@ChildOrder(names={"name", "status", "kind", "date", "publisher", "contact", "responsible", "type", "description", "useContext", "jurisdiction", "usage", "uniqueId"})
public class NamingSystem
extends MetadataResource {
    @Child(name="kind", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="codesystem | identifier | root", formalDefinition="Indicates the purpose for the naming system - what kinds of things does it make unique?")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/namingsystem-type")
    protected Enumeration<NamingSystemType> kind;
    @Child(name="responsible", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who maintains system namespace?", formalDefinition="The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.")
    protected StringType responsible;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="e.g. driver,  provider,  patient, bank etc.", formalDefinition="Categorizes a naming system for easier search by grouping related naming systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/identifier-type")
    protected CodeableConcept type;
    @Child(name="usage", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How/where is it used", formalDefinition="Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.")
    protected StringType usage;
    @Child(name="uniqueId", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifiers used for system", formalDefinition="Indicates how the system may be identified when referenced in electronic exchange.")
    protected List<NamingSystemUniqueIdComponent> uniqueId;
    private static final long serialVersionUID = 1686086580L;
    @SearchParamDefinition(name="date", path="NamingSystem.date", description="The naming system publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="period", path="NamingSystem.uniqueId.period", description="When is identifier valid?", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="context-type-value", path="NamingSystem.useContext", description="A use context type and value assigned to the naming system", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="kind", path="NamingSystem.kind", description="codesystem | identifier | root", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="jurisdiction", path="NamingSystem.jurisdiction", description="Intended jurisdiction for the naming system", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="NamingSystem.description", description="The description of the naming system", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="NamingSystem.useContext.code", description="A type of use context assigned to the naming system", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="type", path="NamingSystem.type", description="e.g. driver,  provider,  patient, bank etc.", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="id-type", path="NamingSystem.uniqueId.type", description="oid | uuid | uri | other", type="token")
    public static final String SP_ID_TYPE = "id-type";
    public static final TokenClientParam ID_TYPE = new TokenClientParam("id-type");
    @SearchParamDefinition(name="context-quantity", path="(NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the naming system", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="responsible", path="NamingSystem.responsible", description="Who maintains system namespace?", type="string")
    public static final String SP_RESPONSIBLE = "responsible";
    public static final StringClientParam RESPONSIBLE = new StringClientParam("responsible");
    @SearchParamDefinition(name="contact", path="NamingSystem.contact.name", description="Name of an individual to contact", type="string")
    public static final String SP_CONTACT = "contact";
    public static final StringClientParam CONTACT = new StringClientParam("contact");
    @SearchParamDefinition(name="name", path="NamingSystem.name", description="Computationally friendly name of the naming system", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(NamingSystem.useContext.value as CodeableConcept)", description="A use context assigned to the naming system", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="NamingSystem.publisher", description="Name of the publisher of the naming system", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="telecom", path="NamingSystem.contact.telecom", description="Contact details for individual or organization", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="value", path="NamingSystem.uniqueId.value", description="The unique identifier", type="string")
    public static final String SP_VALUE = "value";
    public static final StringClientParam VALUE = new StringClientParam("value");
    @SearchParamDefinition(name="context-type-quantity", path="NamingSystem.useContext", description="A use context type and quantity- or range-based value assigned to the naming system", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="NamingSystem.status", description="The current status of the naming system", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public NamingSystem() {
    }

    public NamingSystem(StringType name, Enumeration<Enumerations.PublicationStatus> status, Enumeration<NamingSystemType> kind, DateTimeType date) {
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.date = date;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public NamingSystem setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public NamingSystem setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public NamingSystem setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public NamingSystem setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<NamingSystemType> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<NamingSystemType>(new NamingSystemTypeEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public NamingSystem setKindElement(Enumeration<NamingSystemType> value) {
        this.kind = value;
        return this;
    }

    public NamingSystemType getKind() {
        return this.kind == null ? null : (NamingSystemType)((Object)this.kind.getValue());
    }

    public NamingSystem setKind(NamingSystemType value) {
        if (this.kind == null) {
            this.kind = new Enumeration<NamingSystemType>(new NamingSystemTypeEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public NamingSystem setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public NamingSystem setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public NamingSystem setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public NamingSystem setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public NamingSystem setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public NamingSystem addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public StringType getResponsibleElement() {
        if (this.responsible == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.responsible");
            }
            if (Configuration.doAutoCreate()) {
                this.responsible = new StringType();
            }
        }
        return this.responsible;
    }

    public boolean hasResponsibleElement() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public boolean hasResponsible() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public NamingSystem setResponsibleElement(StringType value) {
        this.responsible = value;
        return this;
    }

    public String getResponsible() {
        return this.responsible == null ? null : (String)this.responsible.getValue();
    }

    public NamingSystem setResponsible(String value) {
        if (Utilities.noString((String)value)) {
            this.responsible = null;
        } else {
            if (this.responsible == null) {
                this.responsible = new StringType();
            }
            this.responsible.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public NamingSystem setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public NamingSystem setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public NamingSystem setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public NamingSystem setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public NamingSystem addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public NamingSystem setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public NamingSystem addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NamingSystem.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public NamingSystem setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public NamingSystem setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public List<NamingSystemUniqueIdComponent> getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
        }
        return this.uniqueId;
    }

    public NamingSystem setUniqueId(List<NamingSystemUniqueIdComponent> theUniqueId) {
        this.uniqueId = theUniqueId;
        return this;
    }

    public boolean hasUniqueId() {
        if (this.uniqueId == null) {
            return false;
        }
        for (NamingSystemUniqueIdComponent item : this.uniqueId) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NamingSystemUniqueIdComponent addUniqueId() {
        NamingSystemUniqueIdComponent t = new NamingSystemUniqueIdComponent();
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
        }
        this.uniqueId.add(t);
        return t;
    }

    public NamingSystem addUniqueId(NamingSystemUniqueIdComponent t) {
        if (t == null) {
            return this;
        }
        if (this.uniqueId == null) {
            this.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
        }
        this.uniqueId.add(t);
        return this;
    }

    public NamingSystemUniqueIdComponent getUniqueIdFirstRep() {
        if (this.getUniqueId().isEmpty()) {
            this.addUniqueId();
        }
        return this.getUniqueId().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the naming system. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this naming system. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_KIND, "code", "Indicates the purpose for the naming system - what kinds of things does it make unique?", 0, 1, this.kind));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the naming system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the naming system changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the naming system.", 0, 1, this.publisher));
        children.add(new Property(SP_CONTACT, "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_RESPONSIBLE, "string", "The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.", 0, 1, this.responsible));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Categorizes a naming system for easier search by grouping related naming systems.", 0, 1, this.type));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the naming system from a consumer's perspective. Details about what the namespace identifies including scope, granularity, version labeling, etc.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate naming system instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the naming system is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("usage", "string", "Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.", 0, 1, this.usage));
        children.add(new Property("uniqueId", "", "Indicates how the system may be identified when referenced in electronic exchange.", 0, Integer.MAX_VALUE, this.uniqueId));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the naming system. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this naming system. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3292052: {
                return new Property(SP_KIND, "code", "Indicates the purpose for the naming system - what kinds of things does it make unique?", 0, 1, this.kind);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the naming system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the naming system changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the naming system.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property(SP_CONTACT, "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1847674614: {
                return new Property(SP_RESPONSIBLE, "string", "The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.", 0, 1, this.responsible);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Categorizes a naming system for easier search by grouping related naming systems.", 0, 1, this.type);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the naming system from a consumer's perspective. Details about what the namespace identifies including scope, granularity, version labeling, etc.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate naming system instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the naming system is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 111574433: {
                return new Property("usage", "string", "Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.", 0, 1, this.usage);
            }
            case -294460212: {
                return new Property("uniqueId", "", "Indicates how the system may be identified when referenced in electronic exchange.", 0, Integer.MAX_VALUE, this.uniqueId);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.kind;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1847674614: {
                Base[] baseArray;
                if (this.responsible == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.responsible;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.type;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.usage;
                }
                return baseArray;
            }
            case -294460212: {
                return this.uniqueId == null ? new Base[]{} : this.uniqueId.toArray(new Base[this.uniqueId.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case 3292052: {
                value = new NamingSystemTypeEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case 1847674614: {
                this.responsible = this.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                return value;
            }
            case -294460212: {
                this.getUniqueId().add((NamingSystemUniqueIdComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_KIND)) {
            value = new NamingSystemTypeEnumFactory().fromType(this.castToCode(value));
            this.kind = value;
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = this.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("uniqueId")) {
            this.getUniqueId().add((NamingSystemUniqueIdComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals(SP_KIND)) {
            this.kind = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().remove(this.castToContactDetail(value));
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = null;
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(this.castToCodeableConcept(value));
        } else if (name.equals("usage")) {
            this.usage = null;
        } else if (name.equals("uniqueId")) {
            this.getUniqueId().remove((NamingSystemUniqueIdComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1847674614: {
                return this.getResponsibleElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case -294460212: {
                return this.addUniqueId();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case 1847674614: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case -294460212: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.status");
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.kind");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.publisher");
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals(SP_RESPONSIBLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.responsible");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.usage");
        }
        if (name.equals("uniqueId")) {
            return this.addUniqueId();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NamingSystem";
    }

    @Override
    public NamingSystem copy() {
        NamingSystem dst = new NamingSystem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(NamingSystem dst) {
        super.copyValues(dst);
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        dst.responsible = this.responsible == null ? null : this.responsible.copy();
        dst.type = this.type == null ? null : this.type.copy();
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        StringType stringType2 = dst.usage = this.usage == null ? null : this.usage.copy();
        if (this.uniqueId != null) {
            dst.uniqueId = new ArrayList<NamingSystemUniqueIdComponent>();
            for (NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : this.uniqueId) {
                dst.uniqueId.add(namingSystemUniqueIdComponent.copy());
            }
        }
    }

    protected NamingSystem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof NamingSystem)) {
            return false;
        }
        NamingSystem o = (NamingSystem)other_;
        return NamingSystem.compareDeep(this.kind, o.kind, true) && NamingSystem.compareDeep(this.responsible, o.responsible, true) && NamingSystem.compareDeep(this.type, o.type, true) && NamingSystem.compareDeep(this.usage, o.usage, true) && NamingSystem.compareDeep(this.uniqueId, o.uniqueId, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof NamingSystem)) {
            return false;
        }
        NamingSystem o = (NamingSystem)other_;
        return NamingSystem.compareValues(this.kind, o.kind, true) && NamingSystem.compareValues(this.responsible, o.responsible, true) && NamingSystem.compareValues(this.usage, o.usage, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.kind, this.responsible, this.type, this.usage, this.uniqueId});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NamingSystem;
    }

    @Block
    public static class NamingSystemUniqueIdComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="oid | uuid | uri | other", formalDefinition="Identifies the unique identifier scheme used for this particular identifier.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/namingsystem-identifier-type")
        protected Enumeration<NamingSystemIdentifierType> type;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The unique identifier", formalDefinition="The string that should be sent over the wire to identify the code system or identifier system.")
        protected StringType value;
        @Child(name="preferred", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is this the id that should be used for this type", formalDefinition="Indicates whether this identifier is the \"preferred\" identifier of this type.")
        protected BooleanType preferred;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Notes about identifier usage", formalDefinition="Notes about the past or intended usage of this identifier.")
        protected StringType comment;
        @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When is identifier valid?", formalDefinition="Identifies the period of time over which this identifier is considered appropriate to refer to the naming system.  Outside of this window, the identifier might be non-deterministic.")
        protected Period period;
        private static final long serialVersionUID = -1458889328L;

        public NamingSystemUniqueIdComponent() {
        }

        public NamingSystemUniqueIdComponent(Enumeration<NamingSystemIdentifierType> type, StringType value) {
            this.type = type;
            this.value = value;
        }

        public Enumeration<NamingSystemIdentifierType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<NamingSystemIdentifierType>(new NamingSystemIdentifierTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NamingSystemUniqueIdComponent setTypeElement(Enumeration<NamingSystemIdentifierType> value) {
            this.type = value;
            return this;
        }

        public NamingSystemIdentifierType getType() {
            return this.type == null ? null : (NamingSystemIdentifierType)((Object)this.type.getValue());
        }

        public NamingSystemUniqueIdComponent setType(NamingSystemIdentifierType value) {
            if (this.type == null) {
                this.type = new Enumeration<NamingSystemIdentifierType>(new NamingSystemIdentifierTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public NamingSystemUniqueIdComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public NamingSystemUniqueIdComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public NamingSystemUniqueIdComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public NamingSystemUniqueIdComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public NamingSystemUniqueIdComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public NamingSystemUniqueIdComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NamingSystemUniqueIdComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public NamingSystemUniqueIdComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(NamingSystem.SP_TYPE, "code", "Identifies the unique identifier scheme used for this particular identifier.", 0, 1, this.type));
            children.add(new Property(NamingSystem.SP_VALUE, "string", "The string that should be sent over the wire to identify the code system or identifier system.", 0, 1, this.value));
            children.add(new Property("preferred", "boolean", "Indicates whether this identifier is the \"preferred\" identifier of this type.", 0, 1, this.preferred));
            children.add(new Property("comment", "string", "Notes about the past or intended usage of this identifier.", 0, 1, this.comment));
            children.add(new Property(NamingSystem.SP_PERIOD, "Period", "Identifies the period of time over which this identifier is considered appropriate to refer to the naming system.  Outside of this window, the identifier might be non-deterministic.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(NamingSystem.SP_TYPE, "code", "Identifies the unique identifier scheme used for this particular identifier.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property(NamingSystem.SP_VALUE, "string", "The string that should be sent over the wire to identify the code system or identifier system.", 0, 1, this.value);
                }
                case -1294005119: {
                    return new Property("preferred", "boolean", "Indicates whether this identifier is the \"preferred\" identifier of this type.", 0, 1, this.preferred);
                }
                case 950398559: {
                    return new Property("comment", "string", "Notes about the past or intended usage of this identifier.", 0, 1, this.comment);
                }
                case -991726143: {
                    return new Property(NamingSystem.SP_PERIOD, "Period", "Identifies the period of time over which this identifier is considered appropriate to refer to the naming system.  Outside of this window, the identifier might be non-deterministic.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1294005119: {
                    Base[] baseArray;
                    if (this.preferred == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preferred;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new NamingSystemIdentifierTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    return value;
                }
                case -1294005119: {
                    this.preferred = this.castToBoolean(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(NamingSystem.SP_TYPE)) {
                value = new NamingSystemIdentifierTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals(NamingSystem.SP_VALUE)) {
                this.value = this.castToString(value);
            } else if (name.equals("preferred")) {
                this.preferred = this.castToBoolean(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else if (name.equals(NamingSystem.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(NamingSystem.SP_TYPE)) {
                this.type = null;
            } else if (name.equals(NamingSystem.SP_VALUE)) {
                this.value = null;
            } else if (name.equals("preferred")) {
                this.preferred = null;
            } else if (name.equals("comment")) {
                this.comment = null;
            } else if (name.equals(NamingSystem.SP_PERIOD)) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case -1294005119: {
                    return this.getPreferredElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case -1294005119: {
                    return new String[]{"boolean"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(NamingSystem.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.type");
            }
            if (name.equals(NamingSystem.SP_VALUE)) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.value");
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.preferred");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property NamingSystem.comment");
            }
            if (name.equals(NamingSystem.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public NamingSystemUniqueIdComponent copy() {
            NamingSystemUniqueIdComponent dst = new NamingSystemUniqueIdComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NamingSystemUniqueIdComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.preferred = this.preferred == null ? null : this.preferred.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NamingSystemUniqueIdComponent)) {
                return false;
            }
            NamingSystemUniqueIdComponent o = (NamingSystemUniqueIdComponent)other_;
            return NamingSystemUniqueIdComponent.compareDeep(this.type, o.type, true) && NamingSystemUniqueIdComponent.compareDeep(this.value, o.value, true) && NamingSystemUniqueIdComponent.compareDeep(this.preferred, o.preferred, true) && NamingSystemUniqueIdComponent.compareDeep(this.comment, o.comment, true) && NamingSystemUniqueIdComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NamingSystemUniqueIdComponent)) {
                return false;
            }
            NamingSystemUniqueIdComponent o = (NamingSystemUniqueIdComponent)other_;
            return NamingSystemUniqueIdComponent.compareValues(this.type, o.type, true) && NamingSystemUniqueIdComponent.compareValues(this.value, o.value, true) && NamingSystemUniqueIdComponent.compareValues(this.preferred, o.preferred, true) && NamingSystemUniqueIdComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value, this.preferred, this.comment, this.period});
        }

        @Override
        public String fhirType() {
            return "NamingSystem.uniqueId";
        }
    }

    public static class NamingSystemIdentifierTypeEnumFactory
    implements EnumFactory<NamingSystemIdentifierType> {
        @Override
        public NamingSystemIdentifierType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("oid".equals(codeString)) {
                return NamingSystemIdentifierType.OID;
            }
            if ("uuid".equals(codeString)) {
                return NamingSystemIdentifierType.UUID;
            }
            if ("uri".equals(codeString)) {
                return NamingSystemIdentifierType.URI;
            }
            if ("other".equals(codeString)) {
                return NamingSystemIdentifierType.OTHER;
            }
            throw new IllegalArgumentException("Unknown NamingSystemIdentifierType code '" + codeString + "'");
        }

        public Enumeration<NamingSystemIdentifierType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.NULL, code);
            }
            if ("oid".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.OID, code);
            }
            if ("uuid".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.UUID, code);
            }
            if ("uri".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.URI, code);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<NamingSystemIdentifierType>(this, NamingSystemIdentifierType.OTHER, code);
            }
            throw new FHIRException("Unknown NamingSystemIdentifierType code '" + codeString + "'");
        }

        @Override
        public String toCode(NamingSystemIdentifierType code) {
            if (code == NamingSystemIdentifierType.OID) {
                return "oid";
            }
            if (code == NamingSystemIdentifierType.UUID) {
                return "uuid";
            }
            if (code == NamingSystemIdentifierType.URI) {
                return "uri";
            }
            if (code == NamingSystemIdentifierType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(NamingSystemIdentifierType code) {
            return code.getSystem();
        }
    }

    public static enum NamingSystemIdentifierType {
        OID,
        UUID,
        URI,
        OTHER,
        NULL;


        public static NamingSystemIdentifierType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("oid".equals(codeString)) {
                return OID;
            }
            if ("uuid".equals(codeString)) {
                return UUID;
            }
            if ("uri".equals(codeString)) {
                return URI;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown NamingSystemIdentifierType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OID: {
                    return "oid";
                }
                case UUID: {
                    return "uuid";
                }
                case URI: {
                    return "uri";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OID: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case UUID: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case URI: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/namingsystem-identifier-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OID: {
                    return "An ISO object identifier; e.g. 1.2.3.4.5.";
                }
                case UUID: {
                    return "A universally unique identifier of the form a5afddf4-e880-459b-876e-e4591b0acc11.";
                }
                case URI: {
                    return "A uniform resource identifier (ideally a URL - uniform resource locator); e.g. http://unitsofmeasure.org.";
                }
                case OTHER: {
                    return "Some other type of unique identifier; e.g. HL7-assigned reserved string such as LN for LOINC.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OID: {
                    return "OID";
                }
                case UUID: {
                    return "UUID";
                }
                case URI: {
                    return "URI";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class NamingSystemTypeEnumFactory
    implements EnumFactory<NamingSystemType> {
        @Override
        public NamingSystemType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("codesystem".equals(codeString)) {
                return NamingSystemType.CODESYSTEM;
            }
            if ("identifier".equals(codeString)) {
                return NamingSystemType.IDENTIFIER;
            }
            if ("root".equals(codeString)) {
                return NamingSystemType.ROOT;
            }
            throw new IllegalArgumentException("Unknown NamingSystemType code '" + codeString + "'");
        }

        public Enumeration<NamingSystemType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.NULL, code);
            }
            if ("codesystem".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.CODESYSTEM, code);
            }
            if ("identifier".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.IDENTIFIER, code);
            }
            if ("root".equals(codeString)) {
                return new Enumeration<NamingSystemType>(this, NamingSystemType.ROOT, code);
            }
            throw new FHIRException("Unknown NamingSystemType code '" + codeString + "'");
        }

        @Override
        public String toCode(NamingSystemType code) {
            if (code == NamingSystemType.CODESYSTEM) {
                return "codesystem";
            }
            if (code == NamingSystemType.IDENTIFIER) {
                return "identifier";
            }
            if (code == NamingSystemType.ROOT) {
                return "root";
            }
            return "?";
        }

        @Override
        public String toSystem(NamingSystemType code) {
            return code.getSystem();
        }
    }

    public static enum NamingSystemType {
        CODESYSTEM,
        IDENTIFIER,
        ROOT,
        NULL;


        public static NamingSystemType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("codesystem".equals(codeString)) {
                return CODESYSTEM;
            }
            if ("identifier".equals(codeString)) {
                return IDENTIFIER;
            }
            if ("root".equals(codeString)) {
                return ROOT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown NamingSystemType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CODESYSTEM: {
                    return "codesystem";
                }
                case IDENTIFIER: {
                    return "identifier";
                }
                case ROOT: {
                    return "root";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CODESYSTEM: {
                    return "http://hl7.org/fhir/namingsystem-type";
                }
                case IDENTIFIER: {
                    return "http://hl7.org/fhir/namingsystem-type";
                }
                case ROOT: {
                    return "http://hl7.org/fhir/namingsystem-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CODESYSTEM: {
                    return "The naming system is used to define concepts and symbols to represent those concepts; e.g. UCUM, LOINC, NDC code, local lab codes, etc.";
                }
                case IDENTIFIER: {
                    return "The naming system is used to manage identifiers (e.g. license numbers, order numbers, etc.).";
                }
                case ROOT: {
                    return "The naming system is used as the root for other identifiers and naming systems.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CODESYSTEM: {
                    return "Code System";
                }
                case IDENTIFIER: {
                    return "Identifier";
                }
                case ROOT: {
                    return "Root";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

