package org.hl7.fhir.r4.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0

import org.hl7.fhir.exceptions.FHIRException;

public enum Program {

  /**
   * null
   */
  _1,
  /**
   * null
   */
  _2,
  /**
   * null
   */
  _3,
  /**
   * null
   */
  _4,
  /**
   * null
   */
  _5,
  /**
   * null
   */
  _6,
  /**
   * null
   */
  _7,
  /**
   * null
   */
  _8,
  /**
   * null
   */
  _9,
  /**
   * null
   */
  _10,
  /**
   * null
   */
  _11,
  /**
   * null
   */
  _12,
  /**
   * null
   */
  _13,
  /**
   * null
   */
  _14,
  /**
   * null
   */
  _15,
  /**
   * null
   */
  _16,
  /**
   * null
   */
  _17,
  /**
   * null
   */
  _18,
  /**
   * null
   */
  _19,
  /**
   * null
   */
  _20,
  /**
   * null
   */
  _21,
  /**
   * null
   */
  _22,
  /**
   * null
   */
  _23,
  /**
   * null
   */
  _24,
  /**
   * null
   */
  _25,
  /**
   * null
   */
  _26,
  /**
   * null
   */
  _27,
  /**
   * null
   */
  _28,
  /**
   * null
   */
  _29,
  /**
   * null
   */
  _30,
  /**
   * null
   */
  _31,
  /**
   * null
   */
  _32,
  /**
   * null
   */
  _33,
  /**
   * null
   */
  _34,
  /**
   * null
   */
  _35,
  /**
   * null
   */
  _36,
  /**
   * null
   */
  _37,
  /**
   * null
   */
  _38,
  /**
   * null
   */
  _39,
  /**
   * null
   */
  _40,
  /**
   * null
   */
  _41,
  /**
   * null
   */
  _42,
  /**
   * null
   */
  _43,
  /**
   * null
   */
  _44,
  /**
   * null
   */
  _45,
  /**
   * added to help the parsers
   */
  NULL;

  public static Program fromCode(String codeString) throws FHIRException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("1".equals(codeString))
      return _1;
    if ("2".equals(codeString))
      return _2;
    if ("3".equals(codeString))
      return _3;
    if ("4".equals(codeString))
      return _4;
    if ("5".equals(codeString))
      return _5;
    if ("6".equals(codeString))
      return _6;
    if ("7".equals(codeString))
      return _7;
    if ("8".equals(codeString))
      return _8;
    if ("9".equals(codeString))
      return _9;
    if ("10".equals(codeString))
      return _10;
    if ("11".equals(codeString))
      return _11;
    if ("12".equals(codeString))
      return _12;
    if ("13".equals(codeString))
      return _13;
    if ("14".equals(codeString))
      return _14;
    if ("15".equals(codeString))
      return _15;
    if ("16".equals(codeString))
      return _16;
    if ("17".equals(codeString))
      return _17;
    if ("18".equals(codeString))
      return _18;
    if ("19".equals(codeString))
      return _19;
    if ("20".equals(codeString))
      return _20;
    if ("21".equals(codeString))
      return _21;
    if ("22".equals(codeString))
      return _22;
    if ("23".equals(codeString))
      return _23;
    if ("24".equals(codeString))
      return _24;
    if ("25".equals(codeString))
      return _25;
    if ("26".equals(codeString))
      return _26;
    if ("27".equals(codeString))
      return _27;
    if ("28".equals(codeString))
      return _28;
    if ("29".equals(codeString))
      return _29;
    if ("30".equals(codeString))
      return _30;
    if ("31".equals(codeString))
      return _31;
    if ("32".equals(codeString))
      return _32;
    if ("33".equals(codeString))
      return _33;
    if ("34".equals(codeString))
      return _34;
    if ("35".equals(codeString))
      return _35;
    if ("36".equals(codeString))
      return _36;
    if ("37".equals(codeString))
      return _37;
    if ("38".equals(codeString))
      return _38;
    if ("39".equals(codeString))
      return _39;
    if ("40".equals(codeString))
      return _40;
    if ("41".equals(codeString))
      return _41;
    if ("42".equals(codeString))
      return _42;
    if ("43".equals(codeString))
      return _43;
    if ("44".equals(codeString))
      return _44;
    if ("45".equals(codeString))
      return _45;
    throw new FHIRException("Unknown Program code '" + codeString + "'");
  }

  public String toCode() {
    switch (this) {
    case _1:
      return "1";
    case _2:
      return "2";
    case _3:
      return "3";
    case _4:
      return "4";
    case _5:
      return "5";
    case _6:
      return "6";
    case _7:
      return "7";
    case _8:
      return "8";
    case _9:
      return "9";
    case _10:
      return "10";
    case _11:
      return "11";
    case _12:
      return "12";
    case _13:
      return "13";
    case _14:
      return "14";
    case _15:
      return "15";
    case _16:
      return "16";
    case _17:
      return "17";
    case _18:
      return "18";
    case _19:
      return "19";
    case _20:
      return "20";
    case _21:
      return "21";
    case _22:
      return "22";
    case _23:
      return "23";
    case _24:
      return "24";
    case _25:
      return "25";
    case _26:
      return "26";
    case _27:
      return "27";
    case _28:
      return "28";
    case _29:
      return "29";
    case _30:
      return "30";
    case _31:
      return "31";
    case _32:
      return "32";
    case _33:
      return "33";
    case _34:
      return "34";
    case _35:
      return "35";
    case _36:
      return "36";
    case _37:
      return "37";
    case _38:
      return "38";
    case _39:
      return "39";
    case _40:
      return "40";
    case _41:
      return "41";
    case _42:
      return "42";
    case _43:
      return "43";
    case _44:
      return "44";
    case _45:
      return "45";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getSystem() {
    return "http://terminology.hl7.org/CodeSystem/program";
  }

  public String getDefinition() {
    switch (this) {
    case _1:
      return "";
    case _2:
      return "";
    case _3:
      return "";
    case _4:
      return "";
    case _5:
      return "";
    case _6:
      return "";
    case _7:
      return "";
    case _8:
      return "";
    case _9:
      return "";
    case _10:
      return "";
    case _11:
      return "";
    case _12:
      return "";
    case _13:
      return "";
    case _14:
      return "";
    case _15:
      return "";
    case _16:
      return "";
    case _17:
      return "";
    case _18:
      return "";
    case _19:
      return "";
    case _20:
      return "";
    case _21:
      return "";
    case _22:
      return "";
    case _23:
      return "";
    case _24:
      return "";
    case _25:
      return "";
    case _26:
      return "";
    case _27:
      return "";
    case _28:
      return "";
    case _29:
      return "";
    case _30:
      return "";
    case _31:
      return "";
    case _32:
      return "";
    case _33:
      return "";
    case _34:
      return "";
    case _35:
      return "";
    case _36:
      return "";
    case _37:
      return "";
    case _38:
      return "";
    case _39:
      return "";
    case _40:
      return "";
    case _41:
      return "";
    case _42:
      return "";
    case _43:
      return "";
    case _44:
      return "";
    case _45:
      return "";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getDisplay() {
    switch (this) {
    case _1:
      return "Acquired Brain Injury (ABI) Program ";
    case _2:
      return "ABI Slow To Recover (ABI STR) Program";
    case _3:
      return "Access Programs";
    case _4:
      return "Adult and Further Education (ACFE) Program";
    case _5:
      return "Adult Day Activity and Support Services (ADASS) Program";
    case _6:
      return "Adult Day Care Program";
    case _7:
      return "ATSS (Adult Training Support Service)";
    case _8:
      return "Community Aged Care Packages (CACP)";
    case _9:
      return "Care Coordination & Supplementary Services (CCSS)";
    case _10:
      return "Cognitive Dementia Memory Service (CDAMS)";
    case _11:
      return "ChildFIRST";
    case _12:
      return "Children's Contact Services";
    case _13:
      return "Community Visitors Scheme";
    case _14:
      return "CPP (Community Partners Program)";
    case _15:
      return "Closing the Gap (CTG)";
    case _16:
      return "Coordinated Veterans' Care (CVC) Program";
    case _17:
      return "Day Program";
    case _18:
      return "Drop In Program";
    case _19:
      return "Early Years Program";
    case _20:
      return "Employee Assistance Program";
    case _21:
      return "Home And Community Care (HACC)";
    case _22:
      return "Hospital Admission Risk Program (HARP)";
    case _23:
      return "Hospital in the Home (HITH) Program";
    case _24:
      return "ICTP (Intensive Community Treatment Program)";
    case _25:
      return "IFSS (Intensive Family Support Program)";
    case _26:
      return "JPET (Job Placement, Education and Training)";
    case _27:
      return "Koori Juvenile Justice Program";
    case _28:
      return "Language Literacy and Numeracy Program";
    case _29:
      return "Life Skills Program";
    case _30:
      return "LMP (Lifestyle Modification Program)";
    case _31:
      return "MedsCheck Program";
    case _32:
      return "Methadone/Buprenorphine Program";
    case _33:
      return "National Disabilities Insurance Scheme (NDIS)";
    case _34:
      return "National Diabetes Services Scheme (NDSS)";
    case _35:
      return "Needle/Syringe Program";
    case _36:
      return "nPEP Program";
    case _37:
      return "Personal Support Program";
    case _38:
      return "Partners in Recovery (PIR) Program";
    case _39:
      return "Pre-employment Program";
    case _40:
      return "Reconnect Program";
    case _41:
      return "Sexual Abuse Counselling and Prevention Program (SACPP)";
    case _42:
      return "Social Support Programs";
    case _43:
      return "Supported Residential Service (SRS)";
    case _44:
      return "Tasmanian Aboriginal Centre (TAC)";
    case _45:
      return "Victim's Assistance Program";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

}