/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GroupMeasure {
    MEAN,
    MEDIAN,
    MEANOFMEAN,
    MEANOFMEDIAN,
    MEDIANOFMEAN,
    MEDIANOFMEDIAN,
    NULL;


    public static GroupMeasure fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mean".equals(codeString)) {
            return MEAN;
        }
        if ("median".equals(codeString)) {
            return MEDIAN;
        }
        if ("mean-of-mean".equals(codeString)) {
            return MEANOFMEAN;
        }
        if ("mean-of-median".equals(codeString)) {
            return MEANOFMEDIAN;
        }
        if ("median-of-mean".equals(codeString)) {
            return MEDIANOFMEAN;
        }
        if ("median-of-median".equals(codeString)) {
            return MEDIANOFMEDIAN;
        }
        throw new FHIRException("Unknown GroupMeasure code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MEAN: {
                return "mean";
            }
            case MEDIAN: {
                return "median";
            }
            case MEANOFMEAN: {
                return "mean-of-mean";
            }
            case MEANOFMEDIAN: {
                return "mean-of-median";
            }
            case MEDIANOFMEAN: {
                return "median-of-mean";
            }
            case MEDIANOFMEDIAN: {
                return "median-of-median";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/group-measure";
    }

    public String getDefinition() {
        switch (this) {
            case MEAN: {
                return "Aggregated using Mean of participant values.";
            }
            case MEDIAN: {
                return "Aggregated using Median of participant values.";
            }
            case MEANOFMEAN: {
                return "Aggregated using Mean of study mean values.";
            }
            case MEANOFMEDIAN: {
                return "Aggregated using Mean of study median values.";
            }
            case MEDIANOFMEAN: {
                return "Aggregated using Median of study mean values.";
            }
            case MEDIANOFMEDIAN: {
                return "Aggregated using Median of study median values.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MEAN: {
                return "Mean";
            }
            case MEDIAN: {
                return "Median";
            }
            case MEANOFMEAN: {
                return "Mean of Study Means";
            }
            case MEANOFMEDIAN: {
                return "Mean of Study Medins";
            }
            case MEDIANOFMEAN: {
                return "Median of Study Means";
            }
            case MEDIANOFMEDIAN: {
                return "Median of Study Medians";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

