/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

public abstract class Resource
extends BaseResource
implements IAnyResource {
    @Child(name="id", type={IdType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id of this artifact", formalDefinition="The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.")
    protected IdType id;
    @Child(name="meta", type={Meta.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Metadata about the resource", formalDefinition="The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.")
    protected Meta meta;
    @Child(name="implicitRules", type={UriType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="A set of rules under which this content was created", formalDefinition="A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.")
    protected UriType implicitRules;
    @Child(name="language", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Language of the resource content", formalDefinition="The base language in which the resource is written.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected CodeType language;
    private static final long serialVersionUID = -559462759L;

    public IdType getIdElement() {
        if (this.id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.id");
            }
            if (Configuration.doAutoCreate()) {
                this.id = new IdType();
            }
        }
        return this.id;
    }

    public boolean hasIdElement() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    @Override
    public Resource setIdElement(IdType value) {
        this.id = value;
        return this;
    }

    public String getId() {
        return this.id == null ? null : this.id.getValue();
    }

    public Resource setId(String value) {
        if (Utilities.noString((String)value)) {
            this.id = null;
        } else {
            if (this.id == null) {
                this.id = new IdType();
            }
            this.id.setValue(value);
        }
        return this;
    }

    public String getIdPart() {
        return this.getIdElement().getIdPart();
    }

    public Meta getMeta() {
        if (this.meta == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.meta");
            }
            if (Configuration.doAutoCreate()) {
                this.meta = new Meta();
            }
        }
        return this.meta;
    }

    public boolean hasMeta() {
        return this.meta != null && !this.meta.isEmpty();
    }

    public Resource setMeta(Meta value) {
        this.meta = value;
        return this;
    }

    public UriType getImplicitRulesElement() {
        if (this.implicitRules == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.implicitRules");
            }
            if (Configuration.doAutoCreate()) {
                this.implicitRules = new UriType();
            }
        }
        return this.implicitRules;
    }

    public boolean hasImplicitRulesElement() {
        return this.implicitRules != null && !this.implicitRules.isEmpty();
    }

    public boolean hasImplicitRules() {
        return this.implicitRules != null && !this.implicitRules.isEmpty();
    }

    public Resource setImplicitRulesElement(UriType value) {
        this.implicitRules = value;
        return this;
    }

    public String getImplicitRules() {
        return this.implicitRules == null ? null : (String)this.implicitRules.getValue();
    }

    public Resource setImplicitRules(String value) {
        if (Utilities.noString((String)value)) {
            this.implicitRules = null;
        } else {
            if (this.implicitRules == null) {
                this.implicitRules = new UriType();
            }
            this.implicitRules.setValue(value);
        }
        return this;
    }

    public CodeType getLanguageElement() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CodeType();
            }
        }
        return this.language;
    }

    public boolean hasLanguageElement() {
        return this.language != null && !this.language.isEmpty();
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public Resource setLanguageElement(CodeType value) {
        this.language = value;
        return this;
    }

    public String getLanguage() {
        return this.language == null ? null : (String)this.language.getValue();
    }

    public Resource setLanguage(String value) {
        if (Utilities.noString((String)value)) {
            this.language = null;
        } else {
            if (this.language == null) {
                this.language = new CodeType();
            }
            this.language.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        children.add(new Property("id", "id", "The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.", 0, 1, this.id));
        children.add(new Property("meta", "Meta", "The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.", 0, 1, this.meta));
        children.add(new Property("implicitRules", "uri", "A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.", 0, 1, this.implicitRules));
        children.add(new Property("language", "code", "The base language in which the resource is written.", 0, 1, this.language));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3355: {
                return new Property("id", "id", "The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.", 0, 1, this.id);
            }
            case 3347973: {
                return new Property("meta", "Meta", "The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.", 0, 1, this.meta);
            }
            case -961826286: {
                return new Property("implicitRules", "uri", "A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.", 0, 1, this.implicitRules);
            }
            case -1613589672: {
                return new Property("language", "code", "The base language in which the resource is written.", 0, 1, this.language);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3355: {
                Base[] baseArray;
                if (this.id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.id;
                }
                return baseArray;
            }
            case 3347973: {
                Base[] baseArray;
                if (this.meta == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.meta;
                }
                return baseArray;
            }
            case -961826286: {
                Base[] baseArray;
                if (this.implicitRules == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.implicitRules;
                }
                return baseArray;
            }
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.language;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3355: {
                this.id = this.castToId(value);
                return value;
            }
            case 3347973: {
                this.meta = this.castToMeta(value);
                return value;
            }
            case -961826286: {
                this.implicitRules = this.castToUri(value);
                return value;
            }
            case -1613589672: {
                this.language = this.castToCode(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("id")) {
            this.id = this.castToId(value);
        } else if (name.equals("meta")) {
            this.meta = this.castToMeta(value);
        } else if (name.equals("implicitRules")) {
            this.implicitRules = this.castToUri(value);
        } else if (name.equals("language")) {
            this.language = this.castToCode(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3355: {
                return this.getIdElement();
            }
            case 3347973: {
                return this.getMeta();
            }
            case -961826286: {
                return this.getImplicitRulesElement();
            }
            case -1613589672: {
                return this.getLanguageElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3355: {
                return new String[]{"id"};
            }
            case 3347973: {
                return new String[]{"Meta"};
            }
            case -961826286: {
                return new String[]{"uri"};
            }
            case -1613589672: {
                return new String[]{"code"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on a primitive type Resource.id");
        }
        if (name.equals("meta")) {
            this.meta = new Meta();
            return this.meta;
        }
        if (name.equals("implicitRules")) {
            throw new FHIRException("Cannot call addChild on a primitive type Resource.implicitRules");
        }
        if (name.equals("language")) {
            throw new FHIRException("Cannot call addChild on a primitive type Resource.language");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Resource";
    }

    public abstract Resource copy();

    public void copyValues(Resource dst) {
        dst.id = this.id == null ? null : this.id.copy();
        dst.meta = this.meta == null ? null : this.meta.copy();
        dst.implicitRules = this.implicitRules == null ? null : this.implicitRules.copy();
        dst.language = this.language == null ? null : this.language.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Resource)) {
            return false;
        }
        Resource o = (Resource)other_;
        return Resource.compareDeep(this.id, o.id, true) && Resource.compareDeep(this.meta, o.meta, true) && Resource.compareDeep(this.implicitRules, o.implicitRules, true) && Resource.compareDeep(this.language, o.language, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Resource)) {
            return false;
        }
        Resource o = (Resource)other_;
        return Resource.compareValues(this.id, o.id, true) && Resource.compareValues(this.implicitRules, o.implicitRules, true) && Resource.compareValues(this.language, o.language, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.id, this.meta, this.implicitRules, this.language});
    }

    @Override
    public String getIdBase() {
        return this.getId();
    }

    @Override
    public void setIdBase(String value) {
        this.setId(value);
    }

    public abstract ResourceType getResourceType();

    public String getLanguage(String defValue) {
        return this.hasLanguage() ? this.getLanguage() : defValue;
    }
}

