/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.r4.model.IntegerType;

@DatatypeDef(name="positiveInt", profileOf=IntegerType.class)
public class PositiveIntType
extends IntegerType {
    private static final long serialVersionUID = 1686497884249402429L;

    public PositiveIntType() {
    }

    public PositiveIntType(int theInteger) {
        this.setValue((Object)theInteger);
    }

    public PositiveIntType(String theIntegerAsString) {
        this.setValueAsString(theIntegerAsString);
    }

    public PositiveIntType(Long theValue) {
        if (theValue < 1L || theValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(theValue + " cannot be cast to int without changing its value.");
        }
        if (theValue != null) {
            this.setValue((Object)((int)theValue.longValue()));
        }
    }

    @Override
    public PositiveIntType copy() {
        PositiveIntType ret = this.getValue() == null ? new PositiveIntType() : new PositiveIntType((Integer)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "positiveInt";
    }
}

