/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.RequestStatus;

public class RequestStatusEnumFactory
implements EnumFactory<RequestStatus> {
    @Override
    public RequestStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return RequestStatus.DRAFT;
        }
        if ("active".equals(codeString)) {
            return RequestStatus.ACTIVE;
        }
        if ("on-hold".equals(codeString)) {
            return RequestStatus.ONHOLD;
        }
        if ("revoked".equals(codeString)) {
            return RequestStatus.REVOKED;
        }
        if ("completed".equals(codeString)) {
            return RequestStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return RequestStatus.ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return RequestStatus.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown RequestStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(RequestStatus code) {
        if (code == RequestStatus.DRAFT) {
            return "draft";
        }
        if (code == RequestStatus.ACTIVE) {
            return "active";
        }
        if (code == RequestStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == RequestStatus.REVOKED) {
            return "revoked";
        }
        if (code == RequestStatus.COMPLETED) {
            return "completed";
        }
        if (code == RequestStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == RequestStatus.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(RequestStatus code) {
        return code.getSystem();
    }
}

