/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProductStatus {
    AVAILABLE,
    UNAVAILABLE,
    NULL;


    public static ProductStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("available".equals(codeString)) {
            return AVAILABLE;
        }
        if ("unavailable".equals(codeString)) {
            return UNAVAILABLE;
        }
        throw new FHIRException("Unknown ProductStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AVAILABLE: {
                return "available";
            }
            case UNAVAILABLE: {
                return "unavailable";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/product-status";
    }

    public String getDefinition() {
        switch (this) {
            case AVAILABLE: {
                return "Product is currently available for use.";
            }
            case UNAVAILABLE: {
                return "Product is not currently available for use.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AVAILABLE: {
                return "Available";
            }
            case UNAVAILABLE: {
                return "Unavailable";
            }
        }
        return "?";
    }
}

