/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AssetAvailability {
    LEASE,
    NULL;


    public static AssetAvailability fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("lease".equals(codeString)) {
            return LEASE;
        }
        throw new FHIRException("Unknown AssetAvailability code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LEASE: {
                return "lease";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/asset-availability";
    }

    public String getDefinition() {
        switch (this) {
            case LEASE: {
                return "To be completed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LEASE: {
                return "Lease";
            }
        }
        return "?";
    }
}

