/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.BackboneType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Property;

@DatatypeDef(name="MarketingStatus")
public class MarketingStatus
extends BackboneType
implements ICompositeType {
    @Child(name="country", type={CodeableConcept.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The country in which the marketing authorisation has been granted shall be specified It should be specified using the ISO 3166 \u2011 1 alpha-2 code elements", formalDefinition="The country in which the marketing authorisation has been granted shall be specified It should be specified using the ISO 3166 \u2011 1 alpha-2 code elements.")
    protected CodeableConcept country;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where a Medicines Regulatory Agency has granted a marketing authorisation for which specific provisions within a jurisdiction apply, the jurisdiction can be specified using an appropriate controlled terminology The controlled term and the controlled term identifier shall be specified", formalDefinition="Where a Medicines Regulatory Agency has granted a marketing authorisation for which specific provisions within a jurisdiction apply, the jurisdiction can be specified using an appropriate controlled terminology The controlled term and the controlled term identifier shall be specified.")
    protected CodeableConcept jurisdiction;
    @Child(name="status", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This attribute provides information on the status of the marketing of the medicinal product See ISO/TS 20443 for more information and examples", formalDefinition="This attribute provides information on the status of the marketing of the medicinal product See ISO/TS 20443 for more information and examples.")
    protected CodeableConcept status;
    @Child(name="dateRange", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain", formalDefinition="The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain.")
    protected Period dateRange;
    @Child(name="restoreDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain", formalDefinition="The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain.")
    protected DateTimeType restoreDate;
    private static final long serialVersionUID = -1445736863L;

    public MarketingStatus() {
    }

    public MarketingStatus(CodeableConcept country, CodeableConcept status, Period dateRange) {
        this.country = country;
        this.status = status;
        this.dateRange = dateRange;
    }

    public CodeableConcept getCountry() {
        if (this.country == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MarketingStatus.country");
            }
            if (Configuration.doAutoCreate()) {
                this.country = new CodeableConcept();
            }
        }
        return this.country;
    }

    public boolean hasCountry() {
        return this.country != null && !this.country.isEmpty();
    }

    public MarketingStatus setCountry(CodeableConcept value) {
        this.country = value;
        return this;
    }

    public CodeableConcept getJurisdiction() {
        if (this.jurisdiction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MarketingStatus.jurisdiction");
            }
            if (Configuration.doAutoCreate()) {
                this.jurisdiction = new CodeableConcept();
            }
        }
        return this.jurisdiction;
    }

    public boolean hasJurisdiction() {
        return this.jurisdiction != null && !this.jurisdiction.isEmpty();
    }

    public MarketingStatus setJurisdiction(CodeableConcept value) {
        this.jurisdiction = value;
        return this;
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MarketingStatus.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MarketingStatus setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public Period getDateRange() {
        if (this.dateRange == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MarketingStatus.dateRange");
            }
            if (Configuration.doAutoCreate()) {
                this.dateRange = new Period();
            }
        }
        return this.dateRange;
    }

    public boolean hasDateRange() {
        return this.dateRange != null && !this.dateRange.isEmpty();
    }

    public MarketingStatus setDateRange(Period value) {
        this.dateRange = value;
        return this;
    }

    public DateTimeType getRestoreDateElement() {
        if (this.restoreDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MarketingStatus.restoreDate");
            }
            if (Configuration.doAutoCreate()) {
                this.restoreDate = new DateTimeType();
            }
        }
        return this.restoreDate;
    }

    public boolean hasRestoreDateElement() {
        return this.restoreDate != null && !this.restoreDate.isEmpty();
    }

    public boolean hasRestoreDate() {
        return this.restoreDate != null && !this.restoreDate.isEmpty();
    }

    public MarketingStatus setRestoreDateElement(DateTimeType value) {
        this.restoreDate = value;
        return this;
    }

    public Date getRestoreDate() {
        return this.restoreDate == null ? null : (Date)this.restoreDate.getValue();
    }

    public MarketingStatus setRestoreDate(Date value) {
        if (value == null) {
            this.restoreDate = null;
        } else {
            if (this.restoreDate == null) {
                this.restoreDate = new DateTimeType();
            }
            this.restoreDate.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("country", "CodeableConcept", "The country in which the marketing authorisation has been granted shall be specified It should be specified using the ISO 3166 \u2011 1 alpha-2 code elements.", 0, 1, this.country));
        children.add(new Property("jurisdiction", "CodeableConcept", "Where a Medicines Regulatory Agency has granted a marketing authorisation for which specific provisions within a jurisdiction apply, the jurisdiction can be specified using an appropriate controlled terminology The controlled term and the controlled term identifier shall be specified.", 0, 1, this.jurisdiction));
        children.add(new Property("status", "CodeableConcept", "This attribute provides information on the status of the marketing of the medicinal product See ISO/TS 20443 for more information and examples.", 0, 1, this.status));
        children.add(new Property("dateRange", "Period", "The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain.", 0, 1, this.dateRange));
        children.add(new Property("restoreDate", "dateTime", "The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain.", 0, 1, this.restoreDate));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 957831062: {
                return new Property("country", "CodeableConcept", "The country in which the marketing authorisation has been granted shall be specified It should be specified using the ISO 3166 \u2011 1 alpha-2 code elements.", 0, 1, this.country);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "Where a Medicines Regulatory Agency has granted a marketing authorisation for which specific provisions within a jurisdiction apply, the jurisdiction can be specified using an appropriate controlled terminology The controlled term and the controlled term identifier shall be specified.", 0, 1, this.jurisdiction);
            }
            case -892481550: {
                return new Property("status", "CodeableConcept", "This attribute provides information on the status of the marketing of the medicinal product See ISO/TS 20443 for more information and examples.", 0, 1, this.status);
            }
            case -261425617: {
                return new Property("dateRange", "Period", "The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain.", 0, 1, this.dateRange);
            }
            case 329465692: {
                return new Property("restoreDate", "dateTime", "The date when the Medicinal Product is placed on the market by the Marketing Authorisation Holder (or where applicable, the manufacturer/distributor) in a country and/or jurisdiction shall be provided A complete date consisting of day, month and year shall be specified using the ISO 8601 date format NOTE \u201cPlaced on the market\u201d refers to the release of the Medicinal Product into the distribution chain.", 0, 1, this.restoreDate);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 957831062: {
                Base[] baseArray;
                if (this.country == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.country;
                }
                return baseArray;
            }
            case -507075711: {
                Base[] baseArray;
                if (this.jurisdiction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.jurisdiction;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -261425617: {
                Base[] baseArray;
                if (this.dateRange == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.dateRange;
                }
                return baseArray;
            }
            case 329465692: {
                Base[] baseArray;
                if (this.restoreDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.restoreDate;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 957831062: {
                this.country = this.castToCodeableConcept(value);
                return value;
            }
            case -507075711: {
                this.jurisdiction = this.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                this.status = this.castToCodeableConcept(value);
                return value;
            }
            case -261425617: {
                this.dateRange = this.castToPeriod(value);
                return value;
            }
            case 329465692: {
                this.restoreDate = this.castToDateTime(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("country")) {
            this.country = this.castToCodeableConcept(value);
        } else if (name.equals("jurisdiction")) {
            this.jurisdiction = this.castToCodeableConcept(value);
        } else if (name.equals("status")) {
            this.status = this.castToCodeableConcept(value);
        } else if (name.equals("dateRange")) {
            this.dateRange = this.castToPeriod(value);
        } else if (name.equals("restoreDate")) {
            this.restoreDate = this.castToDateTime(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 957831062: {
                return this.getCountry();
            }
            case -507075711: {
                return this.getJurisdiction();
            }
            case -892481550: {
                return this.getStatus();
            }
            case -261425617: {
                return this.getDateRange();
            }
            case 329465692: {
                return this.getRestoreDateElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 957831062: {
                return new String[]{"CodeableConcept"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case -261425617: {
                return new String[]{"Period"};
            }
            case 329465692: {
                return new String[]{"dateTime"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("country")) {
            this.country = new CodeableConcept();
            return this.country;
        }
        if (name.equals("jurisdiction")) {
            this.jurisdiction = new CodeableConcept();
            return this.jurisdiction;
        }
        if (name.equals("status")) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("dateRange")) {
            this.dateRange = new Period();
            return this.dateRange;
        }
        if (name.equals("restoreDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type MarketingStatus.restoreDate");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MarketingStatus";
    }

    @Override
    public MarketingStatus copy() {
        MarketingStatus dst = new MarketingStatus();
        this.copyValues(dst);
        dst.country = this.country == null ? null : this.country.copy();
        dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.dateRange = this.dateRange == null ? null : this.dateRange.copy();
        dst.restoreDate = this.restoreDate == null ? null : this.restoreDate.copy();
        return dst;
    }

    @Override
    protected MarketingStatus typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MarketingStatus)) {
            return false;
        }
        MarketingStatus o = (MarketingStatus)other_;
        return MarketingStatus.compareDeep(this.country, o.country, true) && MarketingStatus.compareDeep(this.jurisdiction, o.jurisdiction, true) && MarketingStatus.compareDeep(this.status, o.status, true) && MarketingStatus.compareDeep(this.dateRange, o.dateRange, true) && MarketingStatus.compareDeep(this.restoreDate, o.restoreDate, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MarketingStatus)) {
            return false;
        }
        MarketingStatus o = (MarketingStatus)other_;
        return MarketingStatus.compareValues(this.restoreDate, o.restoreDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.country, this.jurisdiction, this.status, this.dateRange, this.restoreDate});
    }
}

