/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetChecker;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValueSetCheckerSimple
implements ValueSetChecker {
    private ValueSet valueset;
    private IWorkerContext context;
    private Map<String, ValueSetCheckerSimple> inner = new HashMap<String, ValueSetCheckerSimple>();
    private TerminologyServiceOptions options;

    public ValueSetCheckerSimple(TerminologyServiceOptions options, ValueSet source, IWorkerContext context) {
        this.valueset = source;
        this.context = context;
        this.options = options;
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        for (Coding c : code.getCoding()) {
            CodeSystem cs;
            if (!c.hasSystem()) {
                warnings.add("Coding has no system");
            }
            if ((cs = this.context.fetchCodeSystem(c.getSystem())) == null) {
                warnings.add("Unsupported system " + c.getSystem() + " - system is not specified or implicit");
                continue;
            }
            if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
                warnings.add("Unable to resolve system " + c.getSystem() + " - system is not complete");
                continue;
            }
            IWorkerContext.ValidationResult res = this.validateCode(c, cs);
            if (!res.isOk()) {
                errors.add(res.getMessage());
                continue;
            }
            if (res.getMessage() == null) continue;
            warnings.add(res.getMessage());
        }
        if (this.valueset != null) {
            boolean ok = false;
            for (Coding c : code.getCoding()) {
                ok = ok || this.codeInValueSet(c.getSystem(), c.getCode());
            }
            if (!ok) {
                errors.add(0, "None of the provided codes are in the value set " + this.valueset.getUrl());
            }
        }
        if (errors.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)errors).toString());
        }
        if (warnings.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, ((Object)warnings).toString());
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.INFORMATION, null);
    }

    public IWorkerContext.ValidationResult validateCode(Coding code) throws FHIRException {
        String system;
        String warningMessage = null;
        String string = system = code.hasSystem() ? code.getSystem() : this.getValueSetSystem();
        if (system == null && !code.hasDisplay()) {
            system = this.systemForCodeInValueSet(code.getCode());
        }
        if (!code.hasSystem()) {
            code.setSystem(system);
        }
        boolean inExpansion = this.checkExpansion(code);
        CodeSystem cs = this.context.fetchCodeSystem(system);
        if (cs == null) {
            warningMessage = "Unable to resolve system " + system + " - system is not specified or implicit";
            if (!inExpansion) {
                throw new FHIRException(warningMessage);
            }
        }
        if (cs != null && cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            warningMessage = "Unable to resolve system " + system + " - system is not complete";
            if (!inExpansion) {
                throw new FHIRException(warningMessage);
            }
        }
        IWorkerContext.ValidationResult res = null;
        if (cs != null) {
            res = this.validateCode(code, cs);
        }
        if ((res == null || res.isOk()) && this.valueset != null && !this.codeInValueSet(system, code.getCode())) {
            if (!inExpansion) {
                res.setMessage("Not in value set " + this.valueset.getUrl()).setSeverity(ValidationMessage.IssueSeverity.ERROR);
            } else if (warningMessage != null) {
                res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Code found in expansion, however: " + warningMessage);
            } else {
                res.setMessage("Code found in expansion, however: " + res.getMessage());
            }
        }
        return res;
    }

    boolean checkExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return false;
        }
        return this.checkExpansion(code, this.valueset.getExpansion().getContains());
    }

    boolean checkExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                return true;
            }
            if (!containsComponent.hasContains() || !this.checkExpansion(code, containsComponent.getContains())) continue;
            return true;
        }
        return false;
    }

    private IWorkerContext.ValidationResult validateCode(Coding code, CodeSystem cs) {
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code.getCode());
        if (cc == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + this.gen(code) + " in " + cs.getUrl());
        }
        if (code.getDisplay() == null) {
            return new IWorkerContext.ValidationResult(cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(cc);
        }
        ValueSet.ConceptReferenceComponent vs = this.findValueSetRef(code.getSystem(), code.getCode());
        if (vs != null && (vs.hasDisplay() || vs.hasDesignation())) {
            if (vs.hasDisplay()) {
                b.append(vs.getDisplay());
                if (code.getDisplay().equalsIgnoreCase(vs.getDisplay())) {
                    return new IWorkerContext.ValidationResult(cc);
                }
            }
            for (ValueSet.ConceptReferenceDesignationComponent ds : vs.getDesignation()) {
                b.append(ds.getValue());
                if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Display Name for " + code.getSystem() + "#" + code.getCode() + " should be one of '" + b.toString() + "'", cc);
    }

    private ValueSet.ConceptReferenceComponent findValueSetRef(String system, String code) {
        if (this.valueset == null) {
            return null;
        }
        for (ValueSet.ValueSetExpansionContainsComponent exp : this.valueset.getExpansion().getContains()) {
            if (!system.equals(exp.getSystem()) || !code.equals(exp.getCode())) continue;
            ValueSet.ConceptReferenceComponent cc = new ValueSet.ConceptReferenceComponent();
            cc.setDisplay(exp.getDisplay());
            cc.setDesignation(exp.getDesignation());
            return cc;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (system.equals(inc.getSystem())) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    if (!cc.getCode().equals(code)) continue;
                    return cc;
                }
            }
            for (CanonicalType url : inc.getValueSet()) {
                ValueSet.ConceptReferenceComponent cc = this.getVs(url.asStringValue()).findValueSetRef(system, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private String gen(Coding code) {
        if (code.hasSystem()) {
            return code.getSystem() + "#" + code.getCode();
        }
        return null;
    }

    private String getValueSetSystem() throws FHIRException {
        if (this.valueset == null) {
            throw new FHIRException("Unable to resolve system - no value set");
        }
        if (this.valueset.getCompose().hasExclude()) {
            throw new FHIRException("Unable to resolve system - value set has excludes");
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            if (!this.valueset.hasExpansion() || this.valueset.getExpansion().getContains().size() == 0) {
                throw new FHIRException("Unable to resolve system - value set has no includes or expansion");
            }
            String cs = this.valueset.getExpansion().getContains().get(0).getSystem();
            if (cs != null && this.checkSystem(this.valueset.getExpansion().getContains(), cs)) {
                return cs;
            }
            throw new FHIRException("Unable to resolve system - value set expansion has multiple systems");
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                throw new FHIRException("Unable to resolve system - value set has imports");
            }
            if (inc.hasSystem()) continue;
            throw new FHIRException("Unable to resolve system - value set has include with no system");
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private boolean checkSystem(List<ValueSet.ValueSetExpansionContainsComponent> containsList, String system) {
        for (ValueSet.ValueSetExpansionContainsComponent contains : containsList) {
            if (contains.getSystem().equals(system) && (!contains.hasContains() || this.checkSystem(contains.getContains(), system))) continue;
            return false;
        }
        return true;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc.getConcept(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String systemForCodeInValueSet(String code) {
        String sys = null;
        if (this.valueset.hasCompose()) {
            if (this.valueset.getCompose().hasExclude()) {
                return null;
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                if (vsi.hasValueSet()) {
                    return null;
                }
                if (!vsi.hasSystem()) {
                    return null;
                }
                if (vsi.hasFilter()) {
                    return null;
                }
                CodeSystem cs = this.context.fetchCodeSystem(vsi.getSystem());
                if (cs == null) {
                    return null;
                }
                if (vsi.hasConcept()) {
                    for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                        boolean match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                        if (!match) continue;
                        if (sys == null) {
                            sys = vsi.getSystem();
                            continue;
                        }
                        if (sys.equals(vsi.getSystem())) continue;
                        return null;
                    }
                    continue;
                }
                CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code);
                if (cc == null) continue;
                if (sys == null) {
                    sys = vsi.getSystem();
                    continue;
                }
                if (sys.equals(vsi.getSystem())) continue;
                return null;
            }
        }
        return sys;
    }

    @Override
    public boolean codeInValueSet(String system, String code) throws FHIRException {
        if (this.valueset.hasExpansion()) {
            return this.checkExpansion(new Coding(system, code, null));
        }
        if (this.valueset.hasCompose()) {
            boolean ok = false;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                ok = ok || this.inComponent(vsi, system, code, this.valueset.getCompose().getInclude().size() == 1);
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                ok = ok && !this.inComponent(vsi, system, code, this.valueset.getCompose().getInclude().size() == 1);
            }
            return ok;
        }
        return false;
    }

    private boolean inComponent(ValueSet.ConceptSetComponent vsi, String system, String code, boolean only) throws FHIRException {
        CodeSystem def;
        for (UriType uriType : vsi.getValueSet()) {
            if (!this.inImport((String)uriType.getValue(), system, code)) continue;
            return true;
        }
        if (!vsi.hasSystem()) {
            return false;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (!system.equals(vsi.getSystem())) {
            return false;
        }
        if (vsi.hasFilter()) {
            boolean ok = true;
            for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
                if (this.codeInFilter(system, f, code)) continue;
                ok = false;
                break;
            }
            if (ok) {
                return true;
            }
        }
        if ((def = this.context.fetchCodeSystem(system)).getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            throw new FHIRException("Unable to resolve system " + vsi.getSystem() + " - system is not complete");
        }
        List<CodeSystem.ConceptDefinitionComponent> list = def.getConcept();
        boolean ok = this.validateCodeInConceptList(code, def, list);
        if (ok && vsi.hasConcept()) {
            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                if (!cc.getCode().equals(code)) continue;
                return true;
            }
            return false;
        }
        return ok;
    }

    private boolean codeInFilter(String system, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        CodeSystem cs = this.context.fetchCodeSystem(system);
        if (cs == null) {
            throw new FHIRException("Unable to evaluate filters on unknown code system '" + system + "'");
        }
        if ("concept".equals(f.getProperty())) {
            return this.codeInConceptFilter(cs, f, code);
        }
        System.out.println("todo: handle filters with property = " + f.getProperty());
        throw new FHIRException("Unable to handle system " + cs.getUrl() + " filter with property = " + f.getProperty());
    }

    private boolean codeInConceptFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        switch (f.getOp()) {
            case ISA: {
                return this.codeInConceptIsAFilter(cs, f, code);
            }
            case ISNOTA: {
                return !this.codeInConceptIsAFilter(cs, f, code);
            }
        }
        System.out.println("todo: handle concept filters with op = " + (Object)((Object)f.getOp()));
        throw new FHIRException("Unable to handle system " + cs.getUrl() + " concept filter with op = " + (Object)((Object)f.getOp()));
    }

    private boolean codeInConceptIsAFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        if (code.equals(f.getProperty())) {
            return true;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), f.getValue());
        if (cc == null) {
            return false;
        }
        return (cc = this.findCodeInConcept(cc.getConcept(), code)) != null;
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list) {
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSetCheckerSimple getVs(String url) {
        if (this.inner.containsKey(url)) {
            return this.inner.get(url);
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, url);
        ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(this.options, vs, this.context);
        this.inner.put(url, vsc);
        return vsc;
    }

    private boolean inImport(String uri, String system, String code) throws FHIRException {
        return this.getVs(uri).codeInValueSet(system, code);
    }
}

