/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3TableCellHorizontalAlign {
    CENTER,
    CHAR,
    JUSTIFY,
    LEFT,
    RIGHT,
    NULL;


    public static V3TableCellHorizontalAlign fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("center".equals(codeString)) {
            return CENTER;
        }
        if ("char".equals(codeString)) {
            return CHAR;
        }
        if ("justify".equals(codeString)) {
            return JUSTIFY;
        }
        if ("left".equals(codeString)) {
            return LEFT;
        }
        if ("right".equals(codeString)) {
            return RIGHT;
        }
        throw new FHIRException("Unknown V3TableCellHorizontalAlign code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CENTER: {
                return "center";
            }
            case CHAR: {
                return "char";
            }
            case JUSTIFY: {
                return "justify";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-TableCellHorizontalAlign";
    }

    public String getDefinition() {
        switch (this) {
            case CENTER: {
                return "center";
            }
            case CHAR: {
                return "char";
            }
            case JUSTIFY: {
                return "justify";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CENTER: {
                return "center";
            }
            case CHAR: {
                return "char";
            }
            case JUSTIFY: {
                return "justify";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        return "?";
    }
}

