/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QuestionnaireEnableBehavior {
    ALL,
    ANY,
    NULL;


    public static QuestionnaireEnableBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("all".equals(codeString)) {
            return ALL;
        }
        if ("any".equals(codeString)) {
            return ANY;
        }
        throw new FHIRException("Unknown QuestionnaireEnableBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ALL: {
                return "all";
            }
            case ANY: {
                return "any";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/questionnaire-enable-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case ALL: {
                return "Enable the question when all the enableWhen criteria are satisfied.";
            }
            case ANY: {
                return "Enable the question when any of the enableWhen criteria are satisfied.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ALL: {
                return "All";
            }
            case ANY: {
                return "Any";
            }
        }
        return "?";
    }
}

