/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GenderIdentity {
    TRANSGENDERFEMALE,
    TRANSGENDERMALE,
    NONBINARY,
    MALE,
    FEMALE,
    OTHER,
    NONDISCLOSE,
    NULL;


    public static GenderIdentity fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("transgender-female".equals(codeString)) {
            return TRANSGENDERFEMALE;
        }
        if ("transgender-male".equals(codeString)) {
            return TRANSGENDERMALE;
        }
        if ("non-binary".equals(codeString)) {
            return NONBINARY;
        }
        if ("male".equals(codeString)) {
            return MALE;
        }
        if ("female".equals(codeString)) {
            return FEMALE;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        if ("non-disclose".equals(codeString)) {
            return NONDISCLOSE;
        }
        throw new FHIRException("Unknown GenderIdentity code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TRANSGENDERFEMALE: {
                return "transgender-female";
            }
            case TRANSGENDERMALE: {
                return "transgender-male";
            }
            case NONBINARY: {
                return "non-binary";
            }
            case MALE: {
                return "male";
            }
            case FEMALE: {
                return "female";
            }
            case OTHER: {
                return "other";
            }
            case NONDISCLOSE: {
                return "non-disclose";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/gender-identity";
    }

    public String getDefinition() {
        switch (this) {
            case TRANSGENDERFEMALE: {
                return "the patient identifies as transgender male-to-female";
            }
            case TRANSGENDERMALE: {
                return "the patient identifies as transgender female-to-male";
            }
            case NONBINARY: {
                return "the patient identifies with neither/both female and male";
            }
            case MALE: {
                return "the patient identifies as male";
            }
            case FEMALE: {
                return "the patient identifies as female";
            }
            case OTHER: {
                return "other gender identity";
            }
            case NONDISCLOSE: {
                return "the patient does not wish to disclose his gender identity";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TRANSGENDERFEMALE: {
                return "transgender female";
            }
            case TRANSGENDERMALE: {
                return "transgender male";
            }
            case NONBINARY: {
                return "non-binary";
            }
            case MALE: {
                return "male";
            }
            case FEMALE: {
                return "female";
            }
            case OTHER: {
                return "other";
            }
            case NONDISCLOSE: {
                return "does not wish to disclose";
            }
        }
        return "?";
    }
}

