/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractDefinitionSubtype {
    TEMP,
    NULL;


    public static ContractDefinitionSubtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("temp".equals(codeString)) {
            return TEMP;
        }
        throw new FHIRException("Unknown ContractDefinitionSubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TEMP: {
                return "temp";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-definition-subtype";
    }

    public String getDefinition() {
        switch (this) {
            case TEMP: {
                return "To be completed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TEMP: {
                return "Temporary Value";
            }
        }
        return "?";
    }
}

