/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="TestReport", profile="http://hl7.org/fhir/StructureDefinition/TestReport")
public class TestReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier for the TestScript assigned for external purposes outside the context of FHIR.")
    protected Identifier identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name of the executed TestScript", formalDefinition="A free text natural language name identifying the executed TestScript.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="completed | in-progress | waiting | stopped | entered-in-error", formalDefinition="The current state of this test report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-status-codes")
    protected Enumeration<TestReportStatus> status;
    @Child(name="testScript", type={TestScript.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the  version-specific TestScript that was executed to produce this TestReport", formalDefinition="Ideally this is an absolute URL that is used to identify the version-specific TestScript that was executed, matching the `TestScript.url`.")
    protected Reference testScript;
    protected TestScript testScriptTarget;
    @Child(name="result", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="pass | fail | pending", formalDefinition="The overall result from the execution of the TestScript.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-result-codes")
    protected Enumeration<TestReportResult> result;
    @Child(name="score", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The final score (percentage of tests passed) resulting from the execution of the TestScript", formalDefinition="The final score (percentage of tests passed) resulting from the execution of the TestScript.")
    protected DecimalType score;
    @Child(name="tester", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the tester producing this report (Organization or individual)", formalDefinition="Name of the tester producing this report (Organization or individual).")
    protected StringType tester;
    @Child(name="issued", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the TestScript was executed and this TestReport was generated", formalDefinition="When the TestScript was executed and this TestReport was generated.")
    protected DateTimeType issued;
    @Child(name="participant", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A participant in the test execution, either the execution engine, a client, or a server", formalDefinition="A participant in the test execution, either the execution engine, a client, or a server.")
    protected List<TestReportParticipantComponent> participant;
    @Child(name="setup", type={}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The results of the series of required setup operations before the tests were executed", formalDefinition="The results of the series of required setup operations before the tests were executed.")
    protected TestReportSetupComponent setup;
    @Child(name="test", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A test executed from the test script", formalDefinition="A test executed from the test script.")
    protected List<TestReportTestComponent> test;
    @Child(name="teardown", type={}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The results of running the series of required clean up steps", formalDefinition="The results of the series of operations required to clean up after all the tests were executed (successfully or otherwise).")
    protected TestReportTeardownComponent teardown;
    private static final long serialVersionUID = 79474516L;
    @SearchParamDefinition(name="result", path="TestReport.result", description="The result disposition of the test execution", type="token")
    public static final String SP_RESULT = "result";
    public static final TokenClientParam RESULT = new TokenClientParam("result");
    @SearchParamDefinition(name="identifier", path="TestReport.identifier", description="An external identifier for the test report", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="tester", path="TestReport.tester", description="The name of the testing organization", type="string")
    public static final String SP_TESTER = "tester";
    public static final StringClientParam TESTER = new StringClientParam("tester");
    @SearchParamDefinition(name="testscript", path="TestReport.testScript", description="The test script executed to produce this report", type="reference", target={TestScript.class})
    public static final String SP_TESTSCRIPT = "testscript";
    public static final ReferenceClientParam TESTSCRIPT = new ReferenceClientParam("testscript");
    public static final Include INCLUDE_TESTSCRIPT = new Include("TestReport:testscript").toLocked();
    @SearchParamDefinition(name="issued", path="TestReport.issued", description="The test report generation date", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="participant", path="TestReport.participant.uri", description="The reference to a participant in the test execution", type="uri")
    public static final String SP_PARTICIPANT = "participant";
    public static final UriClientParam PARTICIPANT = new UriClientParam("participant");

    public TestReport() {
    }

    public TestReport(Enumeration<TestReportStatus> status, Reference testScript, Enumeration<TestReportResult> result) {
        this.status = status;
        this.testScript = testScript;
        this.result = result;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public TestReport setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public TestReport setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public TestReport setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<TestReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<TestReportStatus>(new TestReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public TestReport setStatusElement(Enumeration<TestReportStatus> value) {
        this.status = value;
        return this;
    }

    public TestReportStatus getStatus() {
        return this.status == null ? null : (TestReportStatus)((Object)this.status.getValue());
    }

    public TestReport setStatus(TestReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<TestReportStatus>(new TestReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getTestScript() {
        if (this.testScript == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.testScript");
            }
            if (Configuration.doAutoCreate()) {
                this.testScript = new Reference();
            }
        }
        return this.testScript;
    }

    public boolean hasTestScript() {
        return this.testScript != null && !this.testScript.isEmpty();
    }

    public TestReport setTestScript(Reference value) {
        this.testScript = value;
        return this;
    }

    public TestScript getTestScriptTarget() {
        if (this.testScriptTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.testScript");
            }
            if (Configuration.doAutoCreate()) {
                this.testScriptTarget = new TestScript();
            }
        }
        return this.testScriptTarget;
    }

    public TestReport setTestScriptTarget(TestScript value) {
        this.testScriptTarget = value;
        return this;
    }

    public Enumeration<TestReportResult> getResultElement() {
        if (this.result == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.result");
            }
            if (Configuration.doAutoCreate()) {
                this.result = new Enumeration<TestReportResult>(new TestReportResultEnumFactory());
            }
        }
        return this.result;
    }

    public boolean hasResultElement() {
        return this.result != null && !this.result.isEmpty();
    }

    public boolean hasResult() {
        return this.result != null && !this.result.isEmpty();
    }

    public TestReport setResultElement(Enumeration<TestReportResult> value) {
        this.result = value;
        return this;
    }

    public TestReportResult getResult() {
        return this.result == null ? null : (TestReportResult)((Object)this.result.getValue());
    }

    public TestReport setResult(TestReportResult value) {
        if (this.result == null) {
            this.result = new Enumeration<TestReportResult>(new TestReportResultEnumFactory());
        }
        this.result.setValue((Object)value);
        return this;
    }

    public DecimalType getScoreElement() {
        if (this.score == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.score");
            }
            if (Configuration.doAutoCreate()) {
                this.score = new DecimalType();
            }
        }
        return this.score;
    }

    public boolean hasScoreElement() {
        return this.score != null && !this.score.isEmpty();
    }

    public boolean hasScore() {
        return this.score != null && !this.score.isEmpty();
    }

    public TestReport setScoreElement(DecimalType value) {
        this.score = value;
        return this;
    }

    public BigDecimal getScore() {
        return this.score == null ? null : (BigDecimal)this.score.getValue();
    }

    public TestReport setScore(BigDecimal value) {
        if (value == null) {
            this.score = null;
        } else {
            if (this.score == null) {
                this.score = new DecimalType();
            }
            this.score.setValue(value);
        }
        return this;
    }

    public TestReport setScore(long value) {
        this.score = new DecimalType();
        this.score.setValue(value);
        return this;
    }

    public TestReport setScore(double value) {
        this.score = new DecimalType();
        this.score.setValue(value);
        return this;
    }

    public StringType getTesterElement() {
        if (this.tester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.tester");
            }
            if (Configuration.doAutoCreate()) {
                this.tester = new StringType();
            }
        }
        return this.tester;
    }

    public boolean hasTesterElement() {
        return this.tester != null && !this.tester.isEmpty();
    }

    public boolean hasTester() {
        return this.tester != null && !this.tester.isEmpty();
    }

    public TestReport setTesterElement(StringType value) {
        this.tester = value;
        return this;
    }

    public String getTester() {
        return this.tester == null ? null : (String)this.tester.getValue();
    }

    public TestReport setTester(String value) {
        if (Utilities.noString((String)value)) {
            this.tester = null;
        } else {
            if (this.tester == null) {
                this.tester = new StringType();
            }
            this.tester.setValue(value);
        }
        return this;
    }

    public DateTimeType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new DateTimeType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public TestReport setIssuedElement(DateTimeType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public TestReport setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new DateTimeType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<TestReportParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<TestReportParticipantComponent>();
        }
        return this.participant;
    }

    public TestReport setParticipant(List<TestReportParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (TestReportParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestReportParticipantComponent addParticipant() {
        TestReportParticipantComponent t = new TestReportParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<TestReportParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public TestReport addParticipant(TestReportParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<TestReportParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public TestReportParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public TestReportSetupComponent getSetup() {
        if (this.setup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.setup");
            }
            if (Configuration.doAutoCreate()) {
                this.setup = new TestReportSetupComponent();
            }
        }
        return this.setup;
    }

    public boolean hasSetup() {
        return this.setup != null && !this.setup.isEmpty();
    }

    public TestReport setSetup(TestReportSetupComponent value) {
        this.setup = value;
        return this;
    }

    public List<TestReportTestComponent> getTest() {
        if (this.test == null) {
            this.test = new ArrayList<TestReportTestComponent>();
        }
        return this.test;
    }

    public TestReport setTest(List<TestReportTestComponent> theTest) {
        this.test = theTest;
        return this;
    }

    public boolean hasTest() {
        if (this.test == null) {
            return false;
        }
        for (TestReportTestComponent item : this.test) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestReportTestComponent addTest() {
        TestReportTestComponent t = new TestReportTestComponent();
        if (this.test == null) {
            this.test = new ArrayList<TestReportTestComponent>();
        }
        this.test.add(t);
        return t;
    }

    public TestReport addTest(TestReportTestComponent t) {
        if (t == null) {
            return this;
        }
        if (this.test == null) {
            this.test = new ArrayList<TestReportTestComponent>();
        }
        this.test.add(t);
        return this;
    }

    public TestReportTestComponent getTestFirstRep() {
        if (this.getTest().isEmpty()) {
            this.addTest();
        }
        return this.getTest().get(0);
    }

    public TestReportTeardownComponent getTeardown() {
        if (this.teardown == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestReport.teardown");
            }
            if (Configuration.doAutoCreate()) {
                this.teardown = new TestReportTeardownComponent();
            }
        }
        return this.teardown;
    }

    public boolean hasTeardown() {
        return this.teardown != null && !this.teardown.isEmpty();
    }

    public TestReport setTeardown(TestReportTeardownComponent value) {
        this.teardown = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the TestScript assigned for external purposes outside the context of FHIR.", 0, 1, this.identifier));
        children.add(new Property("name", "string", "A free text natural language name identifying the executed TestScript.", 0, 1, this.name));
        children.add(new Property("status", "code", "The current state of this test report.", 0, 1, this.status));
        children.add(new Property("testScript", "Reference(TestScript)", "Ideally this is an absolute URL that is used to identify the version-specific TestScript that was executed, matching the `TestScript.url`.", 0, 1, this.testScript));
        children.add(new Property(SP_RESULT, "code", "The overall result from the execution of the TestScript.", 0, 1, this.result));
        children.add(new Property("score", "decimal", "The final score (percentage of tests passed) resulting from the execution of the TestScript.", 0, 1, this.score));
        children.add(new Property(SP_TESTER, "string", "Name of the tester producing this report (Organization or individual).", 0, 1, this.tester));
        children.add(new Property(SP_ISSUED, "dateTime", "When the TestScript was executed and this TestReport was generated.", 0, 1, this.issued));
        children.add(new Property(SP_PARTICIPANT, "", "A participant in the test execution, either the execution engine, a client, or a server.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("setup", "", "The results of the series of required setup operations before the tests were executed.", 0, 1, this.setup));
        children.add(new Property("test", "", "A test executed from the test script.", 0, Integer.MAX_VALUE, this.test));
        children.add(new Property("teardown", "", "The results of the series of operations required to clean up after all the tests were executed (successfully or otherwise).", 0, 1, this.teardown));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the TestScript assigned for external purposes outside the context of FHIR.", 0, 1, this.identifier);
            }
            case 3373707: {
                return new Property("name", "string", "A free text natural language name identifying the executed TestScript.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property("status", "code", "The current state of this test report.", 0, 1, this.status);
            }
            case 1712049149: {
                return new Property("testScript", "Reference(TestScript)", "Ideally this is an absolute URL that is used to identify the version-specific TestScript that was executed, matching the `TestScript.url`.", 0, 1, this.testScript);
            }
            case -934426595: {
                return new Property(SP_RESULT, "code", "The overall result from the execution of the TestScript.", 0, 1, this.result);
            }
            case 109264530: {
                return new Property("score", "decimal", "The final score (percentage of tests passed) resulting from the execution of the TestScript.", 0, 1, this.score);
            }
            case -877169473: {
                return new Property(SP_TESTER, "string", "Name of the tester producing this report (Organization or individual).", 0, 1, this.tester);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "dateTime", "When the TestScript was executed and this TestReport was generated.", 0, 1, this.issued);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "A participant in the test execution, either the execution engine, a client, or a server.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 109329021: {
                return new Property("setup", "", "The results of the series of required setup operations before the tests were executed.", 0, 1, this.setup);
            }
            case 3556498: {
                return new Property("test", "", "A test executed from the test script.", 0, Integer.MAX_VALUE, this.test);
            }
            case -1663474172: {
                return new Property("teardown", "", "The results of the series of operations required to clean up after all the tests were executed (successfully or otherwise).", 0, 1, this.teardown);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 1712049149: {
                Base[] baseArray;
                if (this.testScript == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.testScript;
                }
                return baseArray;
            }
            case -934426595: {
                Base[] baseArray;
                if (this.result == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.result;
                }
                return baseArray;
            }
            case 109264530: {
                Base[] baseArray;
                if (this.score == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.score;
                }
                return baseArray;
            }
            case -877169473: {
                Base[] baseArray;
                if (this.tester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.tester;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.issued;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 109329021: {
                Base[] baseArray;
                if (this.setup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.setup;
                }
                return baseArray;
            }
            case 3556498: {
                return this.test == null ? new Base[]{} : this.test.toArray(new Base[this.test.size()]);
            }
            case -1663474172: {
                Base[] baseArray;
                if (this.teardown == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.teardown;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                value = new TestReportStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1712049149: {
                this.testScript = this.castToReference(value);
                return value;
            }
            case -934426595: {
                value = new TestReportResultEnumFactory().fromType(this.castToCode(value));
                this.result = value;
                return value;
            }
            case 109264530: {
                this.score = this.castToDecimal(value);
                return value;
            }
            case -877169473: {
                this.tester = this.castToString(value);
                return value;
            }
            case -1179159893: {
                this.issued = this.castToDateTime(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((TestReportParticipantComponent)((Object)value));
                return value;
            }
            case 109329021: {
                this.setup = (TestReportSetupComponent)((Object)value);
                return value;
            }
            case 3556498: {
                this.getTest().add((TestReportTestComponent)((Object)value));
                return value;
            }
            case -1663474172: {
                this.teardown = (TestReportTeardownComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("status")) {
            value = new TestReportStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("testScript")) {
            this.testScript = this.castToReference(value);
        } else if (name.equals(SP_RESULT)) {
            value = new TestReportResultEnumFactory().fromType(this.castToCode(value));
            this.result = value;
        } else if (name.equals("score")) {
            this.score = this.castToDecimal(value);
        } else if (name.equals(SP_TESTER)) {
            this.tester = this.castToString(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = this.castToDateTime(value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((TestReportParticipantComponent)((Object)value));
        } else if (name.equals("setup")) {
            this.setup = (TestReportSetupComponent)((Object)value);
        } else if (name.equals("test")) {
            this.getTest().add((TestReportTestComponent)((Object)value));
        } else if (name.equals("teardown")) {
            this.teardown = (TestReportTeardownComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1712049149: {
                return this.getTestScript();
            }
            case -934426595: {
                return this.getResultElement();
            }
            case 109264530: {
                return this.getScoreElement();
            }
            case -877169473: {
                return this.getTesterElement();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 109329021: {
                return this.getSetup();
            }
            case 3556498: {
                return this.addTest();
            }
            case -1663474172: {
                return this.getTeardown();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1712049149: {
                return new String[]{"Reference"};
            }
            case -934426595: {
                return new String[]{"code"};
            }
            case 109264530: {
                return new String[]{"decimal"};
            }
            case -877169473: {
                return new String[]{"string"};
            }
            case -1179159893: {
                return new String[]{"dateTime"};
            }
            case 767422259: {
                return new String[0];
            }
            case 109329021: {
                return new String[0];
            }
            case 3556498: {
                return new String[0];
            }
            case -1663474172: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestReport.name");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestReport.status");
        }
        if (name.equals("testScript")) {
            this.testScript = new Reference();
            return this.testScript;
        }
        if (name.equals(SP_RESULT)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestReport.result");
        }
        if (name.equals("score")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestReport.score");
        }
        if (name.equals(SP_TESTER)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestReport.tester");
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestReport.issued");
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals("setup")) {
            this.setup = new TestReportSetupComponent();
            return this.setup;
        }
        if (name.equals("test")) {
            return this.addTest();
        }
        if (name.equals("teardown")) {
            this.teardown = new TestReportTeardownComponent();
            return this.teardown;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TestReport";
    }

    @Override
    public TestReport copy() {
        TestReport dst = new TestReport();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.testScript = this.testScript == null ? null : this.testScript.copy();
        dst.result = this.result == null ? null : this.result.copy();
        dst.score = this.score == null ? null : this.score.copy();
        dst.tester = this.tester == null ? null : this.tester.copy();
        DateTimeType dateTimeType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<TestReportParticipantComponent>();
            for (TestReportParticipantComponent testReportParticipantComponent : this.participant) {
                dst.participant.add(testReportParticipantComponent.copy());
            }
        }
        TestReportSetupComponent testReportSetupComponent = dst.setup = this.setup == null ? null : this.setup.copy();
        if (this.test != null) {
            dst.test = new ArrayList<TestReportTestComponent>();
            for (TestReportTestComponent testReportTestComponent : this.test) {
                dst.test.add(testReportTestComponent.copy());
            }
        }
        dst.teardown = this.teardown == null ? null : this.teardown.copy();
        return dst;
    }

    protected TestReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TestReport)) {
            return false;
        }
        TestReport o = (TestReport)other_;
        return TestReport.compareDeep(this.identifier, o.identifier, true) && TestReport.compareDeep(this.name, o.name, true) && TestReport.compareDeep(this.status, o.status, true) && TestReport.compareDeep(this.testScript, o.testScript, true) && TestReport.compareDeep(this.result, o.result, true) && TestReport.compareDeep(this.score, o.score, true) && TestReport.compareDeep(this.tester, o.tester, true) && TestReport.compareDeep(this.issued, o.issued, true) && TestReport.compareDeep(this.participant, o.participant, true) && TestReport.compareDeep(this.setup, o.setup, true) && TestReport.compareDeep(this.test, o.test, true) && TestReport.compareDeep(this.teardown, o.teardown, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TestReport)) {
            return false;
        }
        TestReport o = (TestReport)other_;
        return TestReport.compareValues(this.name, o.name, true) && TestReport.compareValues(this.status, o.status, true) && TestReport.compareValues(this.result, o.result, true) && TestReport.compareValues(this.score, o.score, true) && TestReport.compareValues(this.tester, o.tester, true) && TestReport.compareValues(this.issued, o.issued, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.name, this.status, this.testScript, this.result, this.score, this.tester, this.issued, this.participant, this.setup, this.test, this.teardown});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TestReport;
    }

    @Block
    public static class TeardownActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={SetupActionOperationComponent.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The teardown operation performed", formalDefinition="An operation would involve a REST request to a server.")
        protected SetupActionOperationComponent operation;
        private static final long serialVersionUID = -1099598054L;

        public TeardownActionComponent() {
        }

        public TeardownActionComponent(SetupActionOperationComponent operation) {
            this.operation = operation;
        }

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TeardownActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TeardownActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operation", "@TestReport.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1662702951: {
                    return new Property("operation", "@TestReport.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("operation")) {
                return super.setProperty(name, value);
            }
            this.operation = (SetupActionOperationComponent)value;
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return new String[]{"@TestReport.setup.action.operation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            return super.addChild(name);
        }

        @Override
        public TeardownActionComponent copy() {
            TeardownActionComponent dst = new TeardownActionComponent();
            this.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TeardownActionComponent)) {
                return false;
            }
            TeardownActionComponent o = (TeardownActionComponent)other_;
            return TeardownActionComponent.compareDeep(this.operation, o.operation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TeardownActionComponent)) {
                return false;
            }
            TeardownActionComponent o = (TeardownActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.operation});
        }

        @Override
        public String fhirType() {
            return "TestReport.teardown.action";
        }
    }

    @Block
    public static class TestReportTeardownComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="One or more teardown operations performed", formalDefinition="The teardown action will only contain an operation.")
        protected List<TeardownActionComponent> action;
        private static final long serialVersionUID = 1168638089L;

        public List<TeardownActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            return this.action;
        }

        public TestReportTeardownComponent setAction(List<TeardownActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (TeardownActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TeardownActionComponent addAction() {
            TeardownActionComponent t = new TeardownActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestReportTeardownComponent addAction(TeardownActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public TeardownActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "", "The teardown action will only contain an operation.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "", "The teardown action will only contain an operation.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.getAction().add((TeardownActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("action")) {
                return super.setProperty(name, value);
            }
            this.getAction().add((TeardownActionComponent)value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestReportTeardownComponent copy() {
            TestReportTeardownComponent dst = new TestReportTeardownComponent();
            this.copyValues(dst);
            if (this.action != null) {
                dst.action = new ArrayList<TeardownActionComponent>();
                for (TeardownActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportTeardownComponent)) {
                return false;
            }
            TestReportTeardownComponent o = (TestReportTeardownComponent)other_;
            return TestReportTeardownComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportTeardownComponent)) {
                return false;
            }
            TestReportTeardownComponent o = (TestReportTeardownComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.action);
        }

        @Override
        public String fhirType() {
            return "TestReport.teardown";
        }
    }

    @Block
    public static class TestActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={SetupActionOperationComponent.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The operation performed", formalDefinition="An operation would involve a REST request to a server.")
        protected SetupActionOperationComponent operation;
        @Child(name="assert", type={SetupActionAssertComponent.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The assertion performed", formalDefinition="The results of the assertion performed on the previous operations.")
        protected SetupActionAssertComponent assert_;
        private static final long serialVersionUID = -252088305L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TestActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        public SetupActionAssertComponent getAssert() {
            if (this.assert_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestActionComponent.assert_");
                }
                if (Configuration.doAutoCreate()) {
                    this.assert_ = new SetupActionAssertComponent();
                }
            }
            return this.assert_;
        }

        public boolean hasAssert() {
            return this.assert_ != null && !this.assert_.isEmpty();
        }

        public TestActionComponent setAssert(SetupActionAssertComponent value) {
            this.assert_ = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operation", "@TestReport.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation));
            children.add(new Property("assert", "@TestReport.setup.action.assert", "The results of the assertion performed on the previous operations.", 0, 1, this.assert_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1662702951: {
                    return new Property("operation", "@TestReport.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation);
                }
                case -1408208058: {
                    return new Property("assert", "@TestReport.setup.action.assert", "The results of the assertion performed on the previous operations.", 0, 1, this.assert_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
                case -1408208058: {
                    Base[] baseArray;
                    if (this.assert_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.assert_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    return value;
                }
                case -1408208058: {
                    this.assert_ = (SetupActionAssertComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else if (name.equals("assert")) {
                this.assert_ = (SetupActionAssertComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
                case -1408208058: {
                    return this.getAssert();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return new String[]{"@TestReport.setup.action.operation"};
                }
                case -1408208058: {
                    return new String[]{"@TestReport.setup.action.assert"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            if (name.equals("assert")) {
                this.assert_ = new SetupActionAssertComponent();
                return this.assert_;
            }
            return super.addChild(name);
        }

        @Override
        public TestActionComponent copy() {
            TestActionComponent dst = new TestActionComponent();
            this.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            dst.assert_ = this.assert_ == null ? null : this.assert_.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestActionComponent)) {
                return false;
            }
            TestActionComponent o = (TestActionComponent)other_;
            return TestActionComponent.compareDeep(this.operation, o.operation, true) && TestActionComponent.compareDeep(this.assert_, o.assert_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestActionComponent)) {
                return false;
            }
            TestActionComponent o = (TestActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.operation, this.assert_});
        }

        @Override
        public String fhirType() {
            return "TestReport.test.action";
        }
    }

    @Block
    public static class TestReportTestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging name of this test", formalDefinition="The name of this test used for tracking/logging purposes by test engines.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting short description of the test", formalDefinition="A short description of the test used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="action", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A test operation or assert that was performed", formalDefinition="Action would contain either an operation or an assertion.")
        protected List<TestActionComponent> action;
        private static final long serialVersionUID = -865006110L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestReportTestComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestReportTestComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestReportTestComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestReportTestComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestReportTestComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestReportTestComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<TestActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            return this.action;
        }

        public TestReportTestComponent setAction(List<TestActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (TestActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestActionComponent addAction() {
            TestActionComponent t = new TestActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestReportTestComponent addAction(TestActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public TestActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name of this test used for tracking/logging purposes by test engines.", 0, 1, this.name));
            children.add(new Property("description", "string", "A short description of the test used by test engines for tracking and reporting purposes.", 0, 1, this.description));
            children.add(new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name of this test used for tracking/logging purposes by test engines.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "A short description of the test used by test engines for tracking and reporting purposes.", 0, 1, this.description);
                }
                case -1422950858: {
                    return new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((TestActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("action")) {
                this.getAction().add((TestActionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1422950858: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.description");
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestReportTestComponent copy() {
            TestReportTestComponent dst = new TestReportTestComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.action != null) {
                dst.action = new ArrayList<TestActionComponent>();
                for (TestActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportTestComponent)) {
                return false;
            }
            TestReportTestComponent o = (TestReportTestComponent)other_;
            return TestReportTestComponent.compareDeep(this.name, o.name, true) && TestReportTestComponent.compareDeep(this.description, o.description, true) && TestReportTestComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportTestComponent)) {
                return false;
            }
            TestReportTestComponent o = (TestReportTestComponent)other_;
            return TestReportTestComponent.compareValues(this.name, o.name, true) && TestReportTestComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.description, this.action});
        }

        @Override
        public String fhirType() {
            return "TestReport.test";
        }
    }

    @Block
    public static class SetupActionAssertComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="result", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="pass | skip | fail | warning | error", formalDefinition="The result of this assertion.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-action-result-codes")
        protected Enumeration<TestReportActionResult> result;
        @Child(name="message", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A message associated with the result", formalDefinition="An explanatory message associated with the result.")
        protected MarkdownType message;
        @Child(name="detail", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A link to further details on the result", formalDefinition="A link to further details on the result.")
        protected StringType detail;
        private static final long serialVersionUID = 467968193L;

        public SetupActionAssertComponent() {
        }

        public SetupActionAssertComponent(Enumeration<TestReportActionResult> result) {
            this.result = result;
        }

        public Enumeration<TestReportActionResult> getResultElement() {
            if (this.result == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.result");
                }
                if (Configuration.doAutoCreate()) {
                    this.result = new Enumeration<TestReportActionResult>(new TestReportActionResultEnumFactory());
                }
            }
            return this.result;
        }

        public boolean hasResultElement() {
            return this.result != null && !this.result.isEmpty();
        }

        public boolean hasResult() {
            return this.result != null && !this.result.isEmpty();
        }

        public SetupActionAssertComponent setResultElement(Enumeration<TestReportActionResult> value) {
            this.result = value;
            return this;
        }

        public TestReportActionResult getResult() {
            return this.result == null ? null : (TestReportActionResult)((Object)this.result.getValue());
        }

        public SetupActionAssertComponent setResult(TestReportActionResult value) {
            if (this.result == null) {
                this.result = new Enumeration<TestReportActionResult>(new TestReportActionResultEnumFactory());
            }
            this.result.setValue((Object)value);
            return this;
        }

        public MarkdownType getMessageElement() {
            if (this.message == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.message");
                }
                if (Configuration.doAutoCreate()) {
                    this.message = new MarkdownType();
                }
            }
            return this.message;
        }

        public boolean hasMessageElement() {
            return this.message != null && !this.message.isEmpty();
        }

        public boolean hasMessage() {
            return this.message != null && !this.message.isEmpty();
        }

        public SetupActionAssertComponent setMessageElement(MarkdownType value) {
            this.message = value;
            return this;
        }

        public String getMessage() {
            return this.message == null ? null : (String)this.message.getValue();
        }

        public SetupActionAssertComponent setMessage(String value) {
            if (value == null) {
                this.message = null;
            } else {
                if (this.message == null) {
                    this.message = new MarkdownType();
                }
                this.message.setValue(value);
            }
            return this;
        }

        public StringType getDetailElement() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new StringType();
                }
            }
            return this.detail;
        }

        public boolean hasDetailElement() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public SetupActionAssertComponent setDetailElement(StringType value) {
            this.detail = value;
            return this;
        }

        public String getDetail() {
            return this.detail == null ? null : (String)this.detail.getValue();
        }

        public SetupActionAssertComponent setDetail(String value) {
            if (Utilities.noString((String)value)) {
                this.detail = null;
            } else {
                if (this.detail == null) {
                    this.detail = new StringType();
                }
                this.detail.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TestReport.SP_RESULT, "code", "The result of this assertion.", 0, 1, this.result));
            children.add(new Property("message", "markdown", "An explanatory message associated with the result.", 0, 1, this.message));
            children.add(new Property("detail", "string", "A link to further details on the result.", 0, 1, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -934426595: {
                    return new Property(TestReport.SP_RESULT, "code", "The result of this assertion.", 0, 1, this.result);
                }
                case 954925063: {
                    return new Property("message", "markdown", "An explanatory message associated with the result.", 0, 1, this.message);
                }
                case -1335224239: {
                    return new Property("detail", "string", "A link to further details on the result.", 0, 1, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    Base[] baseArray;
                    if (this.result == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.result;
                    }
                    return baseArray;
                }
                case 954925063: {
                    Base[] baseArray;
                    if (this.message == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.message;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.detail;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    value = new TestReportActionResultEnumFactory().fromType(this.castToCode(value));
                    this.result = value;
                    return value;
                }
                case 954925063: {
                    this.message = this.castToMarkdown(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestReport.SP_RESULT)) {
                value = new TestReportActionResultEnumFactory().fromType(this.castToCode(value));
                this.result = value;
            } else if (name.equals("message")) {
                this.message = this.castToMarkdown(value);
            } else if (name.equals("detail")) {
                this.detail = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    return this.getResultElement();
                }
                case 954925063: {
                    return this.getMessageElement();
                }
                case -1335224239: {
                    return this.getDetailElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    return new String[]{"code"};
                }
                case 954925063: {
                    return new String[]{"markdown"};
                }
                case -1335224239: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestReport.SP_RESULT)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.result");
            }
            if (name.equals("message")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.message");
            }
            if (name.equals("detail")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.detail");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertComponent copy() {
            SetupActionAssertComponent dst = new SetupActionAssertComponent();
            this.copyValues(dst);
            dst.result = this.result == null ? null : this.result.copy();
            dst.message = this.message == null ? null : this.message.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionAssertComponent)) {
                return false;
            }
            SetupActionAssertComponent o = (SetupActionAssertComponent)other_;
            return SetupActionAssertComponent.compareDeep(this.result, o.result, true) && SetupActionAssertComponent.compareDeep(this.message, o.message, true) && SetupActionAssertComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionAssertComponent)) {
                return false;
            }
            SetupActionAssertComponent o = (SetupActionAssertComponent)other_;
            return SetupActionAssertComponent.compareValues(this.result, o.result, true) && SetupActionAssertComponent.compareValues(this.message, o.message, true) && SetupActionAssertComponent.compareValues(this.detail, o.detail, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.result, this.message, this.detail});
        }

        @Override
        public String fhirType() {
            return "TestReport.setup.action.assert";
        }
    }

    @Block
    public static class SetupActionOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="result", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="pass | skip | fail | warning | error", formalDefinition="The result of this operation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-action-result-codes")
        protected Enumeration<TestReportActionResult> result;
        @Child(name="message", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A message associated with the result", formalDefinition="An explanatory message associated with the result.")
        protected MarkdownType message;
        @Child(name="detail", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A link to further details on the result", formalDefinition="A link to further details on the result.")
        protected UriType detail;
        private static final long serialVersionUID = 269088798L;

        public SetupActionOperationComponent() {
        }

        public SetupActionOperationComponent(Enumeration<TestReportActionResult> result) {
            this.result = result;
        }

        public Enumeration<TestReportActionResult> getResultElement() {
            if (this.result == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.result");
                }
                if (Configuration.doAutoCreate()) {
                    this.result = new Enumeration<TestReportActionResult>(new TestReportActionResultEnumFactory());
                }
            }
            return this.result;
        }

        public boolean hasResultElement() {
            return this.result != null && !this.result.isEmpty();
        }

        public boolean hasResult() {
            return this.result != null && !this.result.isEmpty();
        }

        public SetupActionOperationComponent setResultElement(Enumeration<TestReportActionResult> value) {
            this.result = value;
            return this;
        }

        public TestReportActionResult getResult() {
            return this.result == null ? null : (TestReportActionResult)((Object)this.result.getValue());
        }

        public SetupActionOperationComponent setResult(TestReportActionResult value) {
            if (this.result == null) {
                this.result = new Enumeration<TestReportActionResult>(new TestReportActionResultEnumFactory());
            }
            this.result.setValue((Object)value);
            return this;
        }

        public MarkdownType getMessageElement() {
            if (this.message == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.message");
                }
                if (Configuration.doAutoCreate()) {
                    this.message = new MarkdownType();
                }
            }
            return this.message;
        }

        public boolean hasMessageElement() {
            return this.message != null && !this.message.isEmpty();
        }

        public boolean hasMessage() {
            return this.message != null && !this.message.isEmpty();
        }

        public SetupActionOperationComponent setMessageElement(MarkdownType value) {
            this.message = value;
            return this;
        }

        public String getMessage() {
            return this.message == null ? null : (String)this.message.getValue();
        }

        public SetupActionOperationComponent setMessage(String value) {
            if (value == null) {
                this.message = null;
            } else {
                if (this.message == null) {
                    this.message = new MarkdownType();
                }
                this.message.setValue(value);
            }
            return this;
        }

        public UriType getDetailElement() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new UriType();
                }
            }
            return this.detail;
        }

        public boolean hasDetailElement() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public SetupActionOperationComponent setDetailElement(UriType value) {
            this.detail = value;
            return this;
        }

        public String getDetail() {
            return this.detail == null ? null : (String)this.detail.getValue();
        }

        public SetupActionOperationComponent setDetail(String value) {
            if (Utilities.noString((String)value)) {
                this.detail = null;
            } else {
                if (this.detail == null) {
                    this.detail = new UriType();
                }
                this.detail.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TestReport.SP_RESULT, "code", "The result of this operation.", 0, 1, this.result));
            children.add(new Property("message", "markdown", "An explanatory message associated with the result.", 0, 1, this.message));
            children.add(new Property("detail", "uri", "A link to further details on the result.", 0, 1, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -934426595: {
                    return new Property(TestReport.SP_RESULT, "code", "The result of this operation.", 0, 1, this.result);
                }
                case 954925063: {
                    return new Property("message", "markdown", "An explanatory message associated with the result.", 0, 1, this.message);
                }
                case -1335224239: {
                    return new Property("detail", "uri", "A link to further details on the result.", 0, 1, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    Base[] baseArray;
                    if (this.result == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.result;
                    }
                    return baseArray;
                }
                case 954925063: {
                    Base[] baseArray;
                    if (this.message == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.message;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.detail;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    value = new TestReportActionResultEnumFactory().fromType(this.castToCode(value));
                    this.result = value;
                    return value;
                }
                case 954925063: {
                    this.message = this.castToMarkdown(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestReport.SP_RESULT)) {
                value = new TestReportActionResultEnumFactory().fromType(this.castToCode(value));
                this.result = value;
            } else if (name.equals("message")) {
                this.message = this.castToMarkdown(value);
            } else if (name.equals("detail")) {
                this.detail = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    return this.getResultElement();
                }
                case 954925063: {
                    return this.getMessageElement();
                }
                case -1335224239: {
                    return this.getDetailElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    return new String[]{"code"};
                }
                case 954925063: {
                    return new String[]{"markdown"};
                }
                case -1335224239: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestReport.SP_RESULT)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.result");
            }
            if (name.equals("message")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.message");
            }
            if (name.equals("detail")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.detail");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionOperationComponent copy() {
            SetupActionOperationComponent dst = new SetupActionOperationComponent();
            this.copyValues(dst);
            dst.result = this.result == null ? null : this.result.copy();
            dst.message = this.message == null ? null : this.message.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionOperationComponent)) {
                return false;
            }
            SetupActionOperationComponent o = (SetupActionOperationComponent)other_;
            return SetupActionOperationComponent.compareDeep(this.result, o.result, true) && SetupActionOperationComponent.compareDeep(this.message, o.message, true) && SetupActionOperationComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionOperationComponent)) {
                return false;
            }
            SetupActionOperationComponent o = (SetupActionOperationComponent)other_;
            return SetupActionOperationComponent.compareValues(this.result, o.result, true) && SetupActionOperationComponent.compareValues(this.message, o.message, true) && SetupActionOperationComponent.compareValues(this.detail, o.detail, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.result, this.message, this.detail});
        }

        @Override
        public String fhirType() {
            return "TestReport.setup.action.operation";
        }
    }

    @Block
    public static class SetupActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The operation to perform", formalDefinition="The operation performed.")
        protected SetupActionOperationComponent operation;
        @Child(name="assert", type={}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The assertion to perform", formalDefinition="The results of the assertion performed on the previous operations.")
        protected SetupActionAssertComponent assert_;
        private static final long serialVersionUID = -252088305L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public SetupActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        public SetupActionAssertComponent getAssert() {
            if (this.assert_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionComponent.assert_");
                }
                if (Configuration.doAutoCreate()) {
                    this.assert_ = new SetupActionAssertComponent();
                }
            }
            return this.assert_;
        }

        public boolean hasAssert() {
            return this.assert_ != null && !this.assert_.isEmpty();
        }

        public SetupActionComponent setAssert(SetupActionAssertComponent value) {
            this.assert_ = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operation", "", "The operation performed.", 0, 1, this.operation));
            children.add(new Property("assert", "", "The results of the assertion performed on the previous operations.", 0, 1, this.assert_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1662702951: {
                    return new Property("operation", "", "The operation performed.", 0, 1, this.operation);
                }
                case -1408208058: {
                    return new Property("assert", "", "The results of the assertion performed on the previous operations.", 0, 1, this.assert_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
                case -1408208058: {
                    Base[] baseArray;
                    if (this.assert_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.assert_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    return value;
                }
                case -1408208058: {
                    this.assert_ = (SetupActionAssertComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else if (name.equals("assert")) {
                this.assert_ = (SetupActionAssertComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
                case -1408208058: {
                    return this.getAssert();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return new String[0];
                }
                case -1408208058: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            if (name.equals("assert")) {
                this.assert_ = new SetupActionAssertComponent();
                return this.assert_;
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionComponent copy() {
            SetupActionComponent dst = new SetupActionComponent();
            this.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            dst.assert_ = this.assert_ == null ? null : this.assert_.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionComponent)) {
                return false;
            }
            SetupActionComponent o = (SetupActionComponent)other_;
            return SetupActionComponent.compareDeep(this.operation, o.operation, true) && SetupActionComponent.compareDeep(this.assert_, o.assert_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionComponent)) {
                return false;
            }
            SetupActionComponent o = (SetupActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.operation, this.assert_});
        }

        @Override
        public String fhirType() {
            return "TestReport.setup.action";
        }
    }

    @Block
    public static class TestReportSetupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A setup operation or assert that was executed", formalDefinition="Action would contain either an operation or an assertion.")
        protected List<SetupActionComponent> action;
        private static final long serialVersionUID = -123374486L;

        public List<SetupActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            return this.action;
        }

        public TestReportSetupComponent setAction(List<SetupActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (SetupActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionComponent addAction() {
            SetupActionComponent t = new SetupActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestReportSetupComponent addAction(SetupActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public SetupActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.getAction().add((SetupActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("action")) {
                return super.setProperty(name, value);
            }
            this.getAction().add((SetupActionComponent)value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestReportSetupComponent copy() {
            TestReportSetupComponent dst = new TestReportSetupComponent();
            this.copyValues(dst);
            if (this.action != null) {
                dst.action = new ArrayList<SetupActionComponent>();
                for (SetupActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportSetupComponent)) {
                return false;
            }
            TestReportSetupComponent o = (TestReportSetupComponent)other_;
            return TestReportSetupComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportSetupComponent)) {
                return false;
            }
            TestReportSetupComponent o = (TestReportSetupComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.action);
        }

        @Override
        public String fhirType() {
            return "TestReport.setup";
        }
    }

    @Block
    public static class TestReportParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="test-engine | client | server", formalDefinition="The type of participant.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-participant-type")
        protected Enumeration<TestReportParticipantType> type;
        @Child(name="uri", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The uri of the participant. An absolute URL is preferred", formalDefinition="The uri of the participant. An absolute URL is preferred.")
        protected UriType uri;
        @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The display name of the participant", formalDefinition="The display name of the participant.")
        protected StringType display;
        private static final long serialVersionUID = 577488357L;

        public TestReportParticipantComponent() {
        }

        public TestReportParticipantComponent(Enumeration<TestReportParticipantType> type, UriType uri) {
            this.type = type;
            this.uri = uri;
        }

        public Enumeration<TestReportParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestReportParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<TestReportParticipantType>(new TestReportParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TestReportParticipantComponent setTypeElement(Enumeration<TestReportParticipantType> value) {
            this.type = value;
            return this;
        }

        public TestReportParticipantType getType() {
            return this.type == null ? null : (TestReportParticipantType)((Object)this.type.getValue());
        }

        public TestReportParticipantComponent setType(TestReportParticipantType value) {
            if (this.type == null) {
                this.type = new Enumeration<TestReportParticipantType>(new TestReportParticipantTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestReportParticipantComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public TestReportParticipantComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public TestReportParticipantComponent setUri(String value) {
            if (this.uri == null) {
                this.uri = new UriType();
            }
            this.uri.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestReportParticipantComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public TestReportParticipantComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public TestReportParticipantComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of participant.", 0, 1, this.type));
            children.add(new Property("uri", "uri", "The uri of the participant. An absolute URL is preferred.", 0, 1, this.uri));
            children.add(new Property("display", "string", "The display name of the participant.", 0, 1, this.display));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of participant.", 0, 1, this.type);
                }
                case 116076: {
                    return new Property("uri", "uri", "The uri of the participant. An absolute URL is preferred.", 0, 1, this.uri);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display name of the participant.", 0, 1, this.display);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.display;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new TestReportParticipantTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new TestReportParticipantTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.type");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.uri");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestReport.display");
            }
            return super.addChild(name);
        }

        @Override
        public TestReportParticipantComponent copy() {
            TestReportParticipantComponent dst = new TestReportParticipantComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.display = this.display == null ? null : this.display.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportParticipantComponent)) {
                return false;
            }
            TestReportParticipantComponent o = (TestReportParticipantComponent)other_;
            return TestReportParticipantComponent.compareDeep(this.type, o.type, true) && TestReportParticipantComponent.compareDeep(this.uri, o.uri, true) && TestReportParticipantComponent.compareDeep(this.display, o.display, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestReportParticipantComponent)) {
                return false;
            }
            TestReportParticipantComponent o = (TestReportParticipantComponent)other_;
            return TestReportParticipantComponent.compareValues(this.type, o.type, true) && TestReportParticipantComponent.compareValues(this.uri, o.uri, true) && TestReportParticipantComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.uri, this.display});
        }

        @Override
        public String fhirType() {
            return "TestReport.participant";
        }
    }

    public static class TestReportActionResultEnumFactory
    implements EnumFactory<TestReportActionResult> {
        @Override
        public TestReportActionResult fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("pass".equals(codeString)) {
                return TestReportActionResult.PASS;
            }
            if ("skip".equals(codeString)) {
                return TestReportActionResult.SKIP;
            }
            if ("fail".equals(codeString)) {
                return TestReportActionResult.FAIL;
            }
            if ("warning".equals(codeString)) {
                return TestReportActionResult.WARNING;
            }
            if ("error".equals(codeString)) {
                return TestReportActionResult.ERROR;
            }
            throw new IllegalArgumentException("Unknown TestReportActionResult code '" + codeString + "'");
        }

        public Enumeration<TestReportActionResult> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TestReportActionResult>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("pass".equals(codeString)) {
                return new Enumeration<TestReportActionResult>(this, TestReportActionResult.PASS);
            }
            if ("skip".equals(codeString)) {
                return new Enumeration<TestReportActionResult>(this, TestReportActionResult.SKIP);
            }
            if ("fail".equals(codeString)) {
                return new Enumeration<TestReportActionResult>(this, TestReportActionResult.FAIL);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<TestReportActionResult>(this, TestReportActionResult.WARNING);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<TestReportActionResult>(this, TestReportActionResult.ERROR);
            }
            throw new FHIRException("Unknown TestReportActionResult code '" + codeString + "'");
        }

        @Override
        public String toCode(TestReportActionResult code) {
            if (code == TestReportActionResult.PASS) {
                return "pass";
            }
            if (code == TestReportActionResult.SKIP) {
                return "skip";
            }
            if (code == TestReportActionResult.FAIL) {
                return "fail";
            }
            if (code == TestReportActionResult.WARNING) {
                return "warning";
            }
            if (code == TestReportActionResult.ERROR) {
                return "error";
            }
            return "?";
        }

        @Override
        public String toSystem(TestReportActionResult code) {
            return code.getSystem();
        }
    }

    public static enum TestReportActionResult {
        PASS,
        SKIP,
        FAIL,
        WARNING,
        ERROR,
        NULL;


        public static TestReportActionResult fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("pass".equals(codeString)) {
                return PASS;
            }
            if ("skip".equals(codeString)) {
                return SKIP;
            }
            if ("fail".equals(codeString)) {
                return FAIL;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TestReportActionResult code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PASS: {
                    return "pass";
                }
                case SKIP: {
                    return "skip";
                }
                case FAIL: {
                    return "fail";
                }
                case WARNING: {
                    return "warning";
                }
                case ERROR: {
                    return "error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PASS: {
                    return "http://hl7.org/fhir/report-action-result-codes";
                }
                case SKIP: {
                    return "http://hl7.org/fhir/report-action-result-codes";
                }
                case FAIL: {
                    return "http://hl7.org/fhir/report-action-result-codes";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/report-action-result-codes";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/report-action-result-codes";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PASS: {
                    return "The action was successful.";
                }
                case SKIP: {
                    return "The action was skipped.";
                }
                case FAIL: {
                    return "The action failed.";
                }
                case WARNING: {
                    return "The action passed but with warnings.";
                }
                case ERROR: {
                    return "The action encountered a fatal error and the engine was unable to process.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PASS: {
                    return "Pass";
                }
                case SKIP: {
                    return "Skip";
                }
                case FAIL: {
                    return "Fail";
                }
                case WARNING: {
                    return "Warning";
                }
                case ERROR: {
                    return "Error";
                }
            }
            return "?";
        }
    }

    public static class TestReportParticipantTypeEnumFactory
    implements EnumFactory<TestReportParticipantType> {
        @Override
        public TestReportParticipantType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("test-engine".equals(codeString)) {
                return TestReportParticipantType.TESTENGINE;
            }
            if ("client".equals(codeString)) {
                return TestReportParticipantType.CLIENT;
            }
            if ("server".equals(codeString)) {
                return TestReportParticipantType.SERVER;
            }
            throw new IllegalArgumentException("Unknown TestReportParticipantType code '" + codeString + "'");
        }

        public Enumeration<TestReportParticipantType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TestReportParticipantType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("test-engine".equals(codeString)) {
                return new Enumeration<TestReportParticipantType>(this, TestReportParticipantType.TESTENGINE);
            }
            if ("client".equals(codeString)) {
                return new Enumeration<TestReportParticipantType>(this, TestReportParticipantType.CLIENT);
            }
            if ("server".equals(codeString)) {
                return new Enumeration<TestReportParticipantType>(this, TestReportParticipantType.SERVER);
            }
            throw new FHIRException("Unknown TestReportParticipantType code '" + codeString + "'");
        }

        @Override
        public String toCode(TestReportParticipantType code) {
            if (code == TestReportParticipantType.TESTENGINE) {
                return "test-engine";
            }
            if (code == TestReportParticipantType.CLIENT) {
                return "client";
            }
            if (code == TestReportParticipantType.SERVER) {
                return "server";
            }
            return "?";
        }

        @Override
        public String toSystem(TestReportParticipantType code) {
            return code.getSystem();
        }
    }

    public static enum TestReportParticipantType {
        TESTENGINE,
        CLIENT,
        SERVER,
        NULL;


        public static TestReportParticipantType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("test-engine".equals(codeString)) {
                return TESTENGINE;
            }
            if ("client".equals(codeString)) {
                return CLIENT;
            }
            if ("server".equals(codeString)) {
                return SERVER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TestReportParticipantType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TESTENGINE: {
                    return "test-engine";
                }
                case CLIENT: {
                    return "client";
                }
                case SERVER: {
                    return "server";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TESTENGINE: {
                    return "http://hl7.org/fhir/report-participant-type";
                }
                case CLIENT: {
                    return "http://hl7.org/fhir/report-participant-type";
                }
                case SERVER: {
                    return "http://hl7.org/fhir/report-participant-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TESTENGINE: {
                    return "The test execution engine.";
                }
                case CLIENT: {
                    return "A FHIR Client.";
                }
                case SERVER: {
                    return "A FHIR Server.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TESTENGINE: {
                    return "Test Engine";
                }
                case CLIENT: {
                    return "Client";
                }
                case SERVER: {
                    return "Server";
                }
            }
            return "?";
        }
    }

    public static class TestReportResultEnumFactory
    implements EnumFactory<TestReportResult> {
        @Override
        public TestReportResult fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("pass".equals(codeString)) {
                return TestReportResult.PASS;
            }
            if ("fail".equals(codeString)) {
                return TestReportResult.FAIL;
            }
            if ("pending".equals(codeString)) {
                return TestReportResult.PENDING;
            }
            throw new IllegalArgumentException("Unknown TestReportResult code '" + codeString + "'");
        }

        public Enumeration<TestReportResult> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TestReportResult>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("pass".equals(codeString)) {
                return new Enumeration<TestReportResult>(this, TestReportResult.PASS);
            }
            if ("fail".equals(codeString)) {
                return new Enumeration<TestReportResult>(this, TestReportResult.FAIL);
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<TestReportResult>(this, TestReportResult.PENDING);
            }
            throw new FHIRException("Unknown TestReportResult code '" + codeString + "'");
        }

        @Override
        public String toCode(TestReportResult code) {
            if (code == TestReportResult.PASS) {
                return "pass";
            }
            if (code == TestReportResult.FAIL) {
                return "fail";
            }
            if (code == TestReportResult.PENDING) {
                return "pending";
            }
            return "?";
        }

        @Override
        public String toSystem(TestReportResult code) {
            return code.getSystem();
        }
    }

    public static enum TestReportResult {
        PASS,
        FAIL,
        PENDING,
        NULL;


        public static TestReportResult fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("pass".equals(codeString)) {
                return PASS;
            }
            if ("fail".equals(codeString)) {
                return FAIL;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TestReportResult code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PASS: {
                    return "pass";
                }
                case FAIL: {
                    return "fail";
                }
                case PENDING: {
                    return "pending";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PASS: {
                    return "http://hl7.org/fhir/report-result-codes";
                }
                case FAIL: {
                    return "http://hl7.org/fhir/report-result-codes";
                }
                case PENDING: {
                    return "http://hl7.org/fhir/report-result-codes";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PASS: {
                    return "All test operations successfully passed all asserts.";
                }
                case FAIL: {
                    return "One or more test operations failed one or more asserts.";
                }
                case PENDING: {
                    return "One or more test operations is pending execution completion.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PASS: {
                    return "Pass";
                }
                case FAIL: {
                    return "Fail";
                }
                case PENDING: {
                    return "Pending";
                }
            }
            return "?";
        }
    }

    public static class TestReportStatusEnumFactory
    implements EnumFactory<TestReportStatus> {
        @Override
        public TestReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return TestReportStatus.COMPLETED;
            }
            if ("in-progress".equals(codeString)) {
                return TestReportStatus.INPROGRESS;
            }
            if ("waiting".equals(codeString)) {
                return TestReportStatus.WAITING;
            }
            if ("stopped".equals(codeString)) {
                return TestReportStatus.STOPPED;
            }
            if ("entered-in-error".equals(codeString)) {
                return TestReportStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown TestReportStatus code '" + codeString + "'");
        }

        public Enumeration<TestReportStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TestReportStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<TestReportStatus>(this, TestReportStatus.COMPLETED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<TestReportStatus>(this, TestReportStatus.INPROGRESS);
            }
            if ("waiting".equals(codeString)) {
                return new Enumeration<TestReportStatus>(this, TestReportStatus.WAITING);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<TestReportStatus>(this, TestReportStatus.STOPPED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<TestReportStatus>(this, TestReportStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown TestReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(TestReportStatus code) {
            if (code == TestReportStatus.COMPLETED) {
                return "completed";
            }
            if (code == TestReportStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == TestReportStatus.WAITING) {
                return "waiting";
            }
            if (code == TestReportStatus.STOPPED) {
                return "stopped";
            }
            if (code == TestReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(TestReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum TestReportStatus {
        COMPLETED,
        INPROGRESS,
        WAITING,
        STOPPED,
        ENTEREDINERROR,
        NULL;


        public static TestReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("waiting".equals(codeString)) {
                return WAITING;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TestReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETED: {
                    return "completed";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case WAITING: {
                    return "waiting";
                }
                case STOPPED: {
                    return "stopped";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETED: {
                    return "http://hl7.org/fhir/report-status-codes";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/report-status-codes";
                }
                case WAITING: {
                    return "http://hl7.org/fhir/report-status-codes";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/report-status-codes";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/report-status-codes";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETED: {
                    return "All test operations have completed.";
                }
                case INPROGRESS: {
                    return "A test operations is currently executing.";
                }
                case WAITING: {
                    return "A test operation is waiting for an external client request.";
                }
                case STOPPED: {
                    return "The test script execution was manually stopped.";
                }
                case ENTEREDINERROR: {
                    return "This test report was entered or created in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETED: {
                    return "Completed";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case WAITING: {
                    return "Waiting";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
            }
            return "?";
        }
    }
}

