/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Count;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ElementDefinition")
public class ElementDefinition
extends BackboneType
implements ICompositeType {
    @Child(name="path", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Path of the element in the hierarchy of elements", formalDefinition="The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource or extension.")
    protected StringType path;
    @Child(name="representation", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="xmlAttr | xmlText | typeAttr | cdaText | xhtml", formalDefinition="Codes that define how this element is represented in instances, when the deviation varies from the normal case.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/property-representation")
    protected List<Enumeration<PropertyRepresentation>> representation;
    @Child(name="sliceName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this particular element (in a set of slices)", formalDefinition="The name of this element definition slice, when slicing is working. The name must be a token with no dots or spaces. This is a unique name referring to a specific set of constraints applied to this element, used to provide a name to different slices of the same element.")
    protected StringType sliceName;
    @Child(name="sliceIsConstraining", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this slice definition constrains an inherited slice definition (or not)", formalDefinition="If true, indicates that this slice definition is constraining a slice definition with the same name in an inherited profile. If false, the slice is not overriding any slice in an inherited profile. If missing, the slice might or might not be overriding a slice in an inherited profile, depending on the sliceName.")
    protected BooleanType sliceIsConstraining;
    @Child(name="label", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for element to display with or prompt for element", formalDefinition="A single preferred label which is the text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.")
    protected StringType label;
    @Child(name="code", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Corresponding codes in terminologies", formalDefinition="A code that has the same meaning as the element in a particular terminology.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    protected List<Coding> code;
    @Child(name="slicing", type={}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This element is sliced - slices follow", formalDefinition="Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).")
    protected ElementDefinitionSlicingComponent slicing;
    @Child(name="short", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Concise definition for space-constrained presentation", formalDefinition="A concise description of what this element means (e.g. for use in autogenerated summaries).")
    protected StringType short_;
    @Child(name="definition", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Full formal definition as narrative text", formalDefinition="Provides a complete explanation of the meaning of the data element for human readability.  For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource. (Note: The text you are reading is specified in ElementDefinition.definition).")
    protected MarkdownType definition;
    @Child(name="comment", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Comments about the use of this element", formalDefinition="Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc. (Note: The text you are reading is specified in ElementDefinition.comment).")
    protected MarkdownType comment;
    @Child(name="requirements", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why this resource has been created", formalDefinition="This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.")
    protected MarkdownType requirements;
    @Child(name="alias", type={StringType.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other names", formalDefinition="Identifies additional names by which this element might also be known.")
    protected List<StringType> alias;
    @Child(name="min", type={UnsignedIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Minimum Cardinality", formalDefinition="The minimum number of times this element SHALL appear in the instance.")
    protected UnsignedIntType min;
    @Child(name="max", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum Cardinality (a number or *)", formalDefinition="The maximum number of times this element is permitted to appear in the instance.")
    protected StringType max;
    @Child(name="base", type={}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Base definition information for tools", formalDefinition="Information about the base definition of the element, provided to make it unnecessary for tools to trace the deviation of the element through the derived and related profiles. When the element definition is not the original definition of an element - i.g. either in a constraint on another type, or for elements from a super type in a snap shot - then the information in provided in the element definition may be different to the base definition. On the original definition of the element, it will be same.")
    protected ElementDefinitionBaseComponent base;
    @Child(name="contentReference", type={UriType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to definition of content for the element", formalDefinition="Identifies an element defined elsewhere in the definition whose content rules should be applied to the current element. ContentReferences bring across all the rules that are in the ElementDefinition for the element, including definitions, cardinality constraints, bindings, invariants etc.")
    protected UriType contentReference;
    @Child(name="type", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Data type and Profile for this element", formalDefinition="The data type or resource that the value of this element is permitted to be.")
    protected List<TypeRefComponent> type;
    @Child(name="defaultValue", type={}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specified value if missing from instance", formalDefinition="The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').")
    protected Type defaultValue;
    @Child(name="meaningWhenMissing", type={MarkdownType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Implicit meaning when this element is missing", formalDefinition="The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing').")
    protected MarkdownType meaningWhenMissing;
    @Child(name="orderMeaning", type={StringType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What the order of the elements means", formalDefinition="If present, indicates that the order of the repeating element has meaning and describes what that meaning is.  If absent, it means that the order of the element has no meaning.")
    protected StringType orderMeaning;
    @Child(name="fixed", type={}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Value must be exactly this", formalDefinition="Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.")
    protected Type fixed;
    @Child(name="pattern", type={}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Value must have at least these property values", formalDefinition="Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.")
    protected Type pattern;
    @Child(name="example", type={}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Example value (as defined for type)", formalDefinition="A sample value for this element demonstrating the type of information that would typically be found in the element.")
    protected List<ElementDefinitionExampleComponent> example;
    @Child(name="minValue", type={DateType.class, DateTimeType.class, InstantType.class, TimeType.class, DecimalType.class, IntegerType.class, PositiveIntType.class, UnsignedIntType.class, Quantity.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Minimum Allowed Value (for some types)", formalDefinition="The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.")
    protected Type minValue;
    @Child(name="maxValue", type={DateType.class, DateTimeType.class, InstantType.class, TimeType.class, DecimalType.class, IntegerType.class, PositiveIntType.class, UnsignedIntType.class, Quantity.class}, order=24, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum Allowed Value (for some types)", formalDefinition="The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.")
    protected Type maxValue;
    @Child(name="maxLength", type={IntegerType.class}, order=25, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Max length for strings", formalDefinition="Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element.")
    protected IntegerType maxLength;
    @Child(name="condition", type={IdType.class}, order=26, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to invariant about presence", formalDefinition="A reference to an invariant that may make additional statements about the cardinality or value in the instance.")
    protected List<IdType> condition;
    @Child(name="constraint", type={}, order=27, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition that must evaluate to true", formalDefinition="Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.")
    protected List<ElementDefinitionConstraintComponent> constraint;
    @Child(name="mustSupport", type={BooleanType.class}, order=28, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the element must be supported", formalDefinition="If true, implementations that produce or consume resources SHALL provide \"support\" for the element in some meaningful way.  If false, the element may be ignored and not supported. If false, whether to populate or use the data element in any way is at the discretion of the implementation.")
    protected BooleanType mustSupport;
    @Child(name="isModifier", type={BooleanType.class}, order=29, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this modifies the meaning of other elements", formalDefinition="If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.")
    protected BooleanType isModifier;
    @Child(name="isModifierReason", type={StringType.class}, order=30, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason that this element is marked as a modifier", formalDefinition="Explains how that element affects the interpretation of the resource or element that contains it.")
    protected StringType isModifierReason;
    @Child(name="isSummary", type={BooleanType.class}, order=31, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include when _summary = true?", formalDefinition="Whether the element should be included if a client requests a search with the parameter _summary=true.")
    protected BooleanType isSummary;
    @Child(name="binding", type={}, order=32, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ValueSet details if this is coded", formalDefinition="Binds to a value set if this element is coded (code, Coding, CodeableConcept, Quantity), or the data types (string, uri).")
    protected ElementDefinitionBindingComponent binding;
    @Child(name="mapping", type={}, order=33, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Map element to another set of definitions", formalDefinition="Identifies a concept from an external specification that roughly corresponds to this element.")
    protected List<ElementDefinitionMappingComponent> mapping;
    private static final long serialVersionUID = 1482114790L;
    public static final boolean NOT_MODIFIER = false;
    public static final boolean NOT_IN_SUMMARY = false;
    public static final boolean IS_MODIFIER = true;
    public static final boolean IS_IN_SUMMARY = true;

    public ElementDefinition() {
    }

    public ElementDefinition(StringType path) {
        this.path = path;
    }

    public StringType getPathElement() {
        if (this.path == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.path");
            }
            if (Configuration.doAutoCreate()) {
                this.path = new StringType();
            }
        }
        return this.path;
    }

    public boolean hasPathElement() {
        return this.path != null && !this.path.isEmpty();
    }

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public ElementDefinition setPathElement(StringType value) {
        this.path = value;
        return this;
    }

    public String getPath() {
        return this.path == null ? null : (String)this.path.getValue();
    }

    public ElementDefinition setPath(String value) {
        if (this.path == null) {
            this.path = new StringType();
        }
        this.path.setValue(value);
        return this;
    }

    public List<Enumeration<PropertyRepresentation>> getRepresentation() {
        if (this.representation == null) {
            this.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        }
        return this.representation;
    }

    public ElementDefinition setRepresentation(List<Enumeration<PropertyRepresentation>> theRepresentation) {
        this.representation = theRepresentation;
        return this;
    }

    public boolean hasRepresentation() {
        if (this.representation == null) {
            return false;
        }
        for (Enumeration<PropertyRepresentation> item : this.representation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<PropertyRepresentation> addRepresentationElement() {
        Enumeration<PropertyRepresentation> t = new Enumeration<PropertyRepresentation>(new PropertyRepresentationEnumFactory());
        if (this.representation == null) {
            this.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        }
        this.representation.add(t);
        return t;
    }

    public ElementDefinition addRepresentation(PropertyRepresentation value) {
        Enumeration<PropertyRepresentation> t = new Enumeration<PropertyRepresentation>(new PropertyRepresentationEnumFactory());
        t.setValue((Object)value);
        if (this.representation == null) {
            this.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        }
        this.representation.add(t);
        return this;
    }

    public boolean hasRepresentation(PropertyRepresentation value) {
        if (this.representation == null) {
            return false;
        }
        for (Enumeration<PropertyRepresentation> v : this.representation) {
            if (!((PropertyRepresentation)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public StringType getSliceNameElement() {
        if (this.sliceName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.sliceName");
            }
            if (Configuration.doAutoCreate()) {
                this.sliceName = new StringType();
            }
        }
        return this.sliceName;
    }

    public boolean hasSliceNameElement() {
        return this.sliceName != null && !this.sliceName.isEmpty();
    }

    public boolean hasSliceName() {
        return this.sliceName != null && !this.sliceName.isEmpty();
    }

    public ElementDefinition setSliceNameElement(StringType value) {
        this.sliceName = value;
        return this;
    }

    public String getSliceName() {
        return this.sliceName == null ? null : (String)this.sliceName.getValue();
    }

    public ElementDefinition setSliceName(String value) {
        if (Utilities.noString((String)value)) {
            this.sliceName = null;
        } else {
            if (this.sliceName == null) {
                this.sliceName = new StringType();
            }
            this.sliceName.setValue(value);
        }
        return this;
    }

    public BooleanType getSliceIsConstrainingElement() {
        if (this.sliceIsConstraining == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.sliceIsConstraining");
            }
            if (Configuration.doAutoCreate()) {
                this.sliceIsConstraining = new BooleanType();
            }
        }
        return this.sliceIsConstraining;
    }

    public boolean hasSliceIsConstrainingElement() {
        return this.sliceIsConstraining != null && !this.sliceIsConstraining.isEmpty();
    }

    public boolean hasSliceIsConstraining() {
        return this.sliceIsConstraining != null && !this.sliceIsConstraining.isEmpty();
    }

    public ElementDefinition setSliceIsConstrainingElement(BooleanType value) {
        this.sliceIsConstraining = value;
        return this;
    }

    public boolean getSliceIsConstraining() {
        return this.sliceIsConstraining == null || this.sliceIsConstraining.isEmpty() ? false : (Boolean)this.sliceIsConstraining.getValue();
    }

    public ElementDefinition setSliceIsConstraining(boolean value) {
        if (this.sliceIsConstraining == null) {
            this.sliceIsConstraining = new BooleanType();
        }
        this.sliceIsConstraining.setValue((Object)value);
        return this;
    }

    public StringType getLabelElement() {
        if (this.label == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.label");
            }
            if (Configuration.doAutoCreate()) {
                this.label = new StringType();
            }
        }
        return this.label;
    }

    public boolean hasLabelElement() {
        return this.label != null && !this.label.isEmpty();
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    public ElementDefinition setLabelElement(StringType value) {
        this.label = value;
        return this;
    }

    public String getLabel() {
        return this.label == null ? null : (String)this.label.getValue();
    }

    public ElementDefinition setLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
        }
        return this;
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public ElementDefinition setCode(List<Coding> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (Coding item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCode() {
        Coding t = new Coding();
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return t;
    }

    public ElementDefinition addCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return this;
    }

    public Coding getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public ElementDefinitionSlicingComponent getSlicing() {
        if (this.slicing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.slicing");
            }
            if (Configuration.doAutoCreate()) {
                this.slicing = new ElementDefinitionSlicingComponent();
            }
        }
        return this.slicing;
    }

    public boolean hasSlicing() {
        return this.slicing != null && !this.slicing.isEmpty();
    }

    public ElementDefinition setSlicing(ElementDefinitionSlicingComponent value) {
        this.slicing = value;
        return this;
    }

    public StringType getShortElement() {
        if (this.short_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.short_");
            }
            if (Configuration.doAutoCreate()) {
                this.short_ = new StringType();
            }
        }
        return this.short_;
    }

    public boolean hasShortElement() {
        return this.short_ != null && !this.short_.isEmpty();
    }

    public boolean hasShort() {
        return this.short_ != null && !this.short_.isEmpty();
    }

    public ElementDefinition setShortElement(StringType value) {
        this.short_ = value;
        return this;
    }

    public String getShort() {
        return this.short_ == null ? null : (String)this.short_.getValue();
    }

    public ElementDefinition setShort(String value) {
        if (Utilities.noString((String)value)) {
            this.short_ = null;
        } else {
            if (this.short_ == null) {
                this.short_ = new StringType();
            }
            this.short_.setValue(value);
        }
        return this;
    }

    public MarkdownType getDefinitionElement() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new MarkdownType();
            }
        }
        return this.definition;
    }

    public boolean hasDefinitionElement() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public ElementDefinition setDefinitionElement(MarkdownType value) {
        this.definition = value;
        return this;
    }

    public String getDefinition() {
        return this.definition == null ? null : (String)this.definition.getValue();
    }

    public ElementDefinition setDefinition(String value) {
        if (value == null) {
            this.definition = null;
        } else {
            if (this.definition == null) {
                this.definition = new MarkdownType();
            }
            this.definition.setValue(value);
        }
        return this;
    }

    public MarkdownType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new MarkdownType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public ElementDefinition setCommentElement(MarkdownType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public ElementDefinition setComment(String value) {
        if (value == null) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new MarkdownType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public MarkdownType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new MarkdownType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public ElementDefinition setRequirementsElement(MarkdownType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public ElementDefinition setRequirements(String value) {
        if (value == null) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new MarkdownType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public ElementDefinition setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public ElementDefinition addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public UnsignedIntType getMinElement() {
        if (this.min == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.min");
            }
            if (Configuration.doAutoCreate()) {
                this.min = new UnsignedIntType();
            }
        }
        return this.min;
    }

    public boolean hasMinElement() {
        return this.min != null && !this.min.isEmpty();
    }

    public boolean hasMin() {
        return this.min != null && !this.min.isEmpty();
    }

    public ElementDefinition setMinElement(UnsignedIntType value) {
        this.min = value;
        return this;
    }

    public int getMin() {
        return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
    }

    public ElementDefinition setMin(int value) {
        if (this.min == null) {
            this.min = new UnsignedIntType();
        }
        this.min.setValue((Object)value);
        return this;
    }

    public StringType getMaxElement() {
        if (this.max == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.max");
            }
            if (Configuration.doAutoCreate()) {
                this.max = new StringType();
            }
        }
        return this.max;
    }

    public boolean hasMaxElement() {
        return this.max != null && !this.max.isEmpty();
    }

    public boolean hasMax() {
        return this.max != null && !this.max.isEmpty();
    }

    public ElementDefinition setMaxElement(StringType value) {
        this.max = value;
        return this;
    }

    public String getMax() {
        return this.max == null ? null : (String)this.max.getValue();
    }

    public ElementDefinition setMax(String value) {
        if (Utilities.noString((String)value)) {
            this.max = null;
        } else {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
        }
        return this;
    }

    public ElementDefinitionBaseComponent getBase() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new ElementDefinitionBaseComponent();
            }
        }
        return this.base;
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public ElementDefinition setBase(ElementDefinitionBaseComponent value) {
        this.base = value;
        return this;
    }

    public UriType getContentReferenceElement() {
        if (this.contentReference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.contentReference");
            }
            if (Configuration.doAutoCreate()) {
                this.contentReference = new UriType();
            }
        }
        return this.contentReference;
    }

    public boolean hasContentReferenceElement() {
        return this.contentReference != null && !this.contentReference.isEmpty();
    }

    public boolean hasContentReference() {
        return this.contentReference != null && !this.contentReference.isEmpty();
    }

    public ElementDefinition setContentReferenceElement(UriType value) {
        this.contentReference = value;
        return this;
    }

    public String getContentReference() {
        return this.contentReference == null ? null : (String)this.contentReference.getValue();
    }

    public ElementDefinition setContentReference(String value) {
        if (Utilities.noString((String)value)) {
            this.contentReference = null;
        } else {
            if (this.contentReference == null) {
                this.contentReference = new UriType();
            }
            this.contentReference.setValue(value);
        }
        return this;
    }

    public List<TypeRefComponent> getType() {
        if (this.type == null) {
            this.type = new ArrayList<TypeRefComponent>();
        }
        return this.type;
    }

    public ElementDefinition setType(List<TypeRefComponent> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (TypeRefComponent item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TypeRefComponent addType() {
        TypeRefComponent t = new TypeRefComponent();
        if (this.type == null) {
            this.type = new ArrayList<TypeRefComponent>();
        }
        this.type.add(t);
        return t;
    }

    public ElementDefinition addType(TypeRefComponent t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<TypeRefComponent>();
        }
        this.type.add(t);
        return this;
    }

    public TypeRefComponent getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public Type getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && !this.defaultValue.isEmpty();
    }

    public ElementDefinition setDefaultValue(Type value) {
        this.defaultValue = value;
        return this;
    }

    public MarkdownType getMeaningWhenMissingElement() {
        if (this.meaningWhenMissing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.meaningWhenMissing");
            }
            if (Configuration.doAutoCreate()) {
                this.meaningWhenMissing = new MarkdownType();
            }
        }
        return this.meaningWhenMissing;
    }

    public boolean hasMeaningWhenMissingElement() {
        return this.meaningWhenMissing != null && !this.meaningWhenMissing.isEmpty();
    }

    public boolean hasMeaningWhenMissing() {
        return this.meaningWhenMissing != null && !this.meaningWhenMissing.isEmpty();
    }

    public ElementDefinition setMeaningWhenMissingElement(MarkdownType value) {
        this.meaningWhenMissing = value;
        return this;
    }

    public String getMeaningWhenMissing() {
        return this.meaningWhenMissing == null ? null : (String)this.meaningWhenMissing.getValue();
    }

    public ElementDefinition setMeaningWhenMissing(String value) {
        if (value == null) {
            this.meaningWhenMissing = null;
        } else {
            if (this.meaningWhenMissing == null) {
                this.meaningWhenMissing = new MarkdownType();
            }
            this.meaningWhenMissing.setValue(value);
        }
        return this;
    }

    public StringType getOrderMeaningElement() {
        if (this.orderMeaning == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.orderMeaning");
            }
            if (Configuration.doAutoCreate()) {
                this.orderMeaning = new StringType();
            }
        }
        return this.orderMeaning;
    }

    public boolean hasOrderMeaningElement() {
        return this.orderMeaning != null && !this.orderMeaning.isEmpty();
    }

    public boolean hasOrderMeaning() {
        return this.orderMeaning != null && !this.orderMeaning.isEmpty();
    }

    public ElementDefinition setOrderMeaningElement(StringType value) {
        this.orderMeaning = value;
        return this;
    }

    public String getOrderMeaning() {
        return this.orderMeaning == null ? null : (String)this.orderMeaning.getValue();
    }

    public ElementDefinition setOrderMeaning(String value) {
        if (Utilities.noString((String)value)) {
            this.orderMeaning = null;
        } else {
            if (this.orderMeaning == null) {
                this.orderMeaning = new StringType();
            }
            this.orderMeaning.setValue(value);
        }
        return this;
    }

    public Type getFixed() {
        return this.fixed;
    }

    public boolean hasFixed() {
        return this.fixed != null && !this.fixed.isEmpty();
    }

    public ElementDefinition setFixed(Type value) {
        this.fixed = value;
        return this;
    }

    public Type getPattern() {
        return this.pattern;
    }

    public boolean hasPattern() {
        return this.pattern != null && !this.pattern.isEmpty();
    }

    public ElementDefinition setPattern(Type value) {
        this.pattern = value;
        return this;
    }

    public List<ElementDefinitionExampleComponent> getExample() {
        if (this.example == null) {
            this.example = new ArrayList<ElementDefinitionExampleComponent>();
        }
        return this.example;
    }

    public ElementDefinition setExample(List<ElementDefinitionExampleComponent> theExample) {
        this.example = theExample;
        return this;
    }

    public boolean hasExample() {
        if (this.example == null) {
            return false;
        }
        for (ElementDefinitionExampleComponent item : this.example) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinitionExampleComponent addExample() {
        ElementDefinitionExampleComponent t = new ElementDefinitionExampleComponent();
        if (this.example == null) {
            this.example = new ArrayList<ElementDefinitionExampleComponent>();
        }
        this.example.add(t);
        return t;
    }

    public ElementDefinition addExample(ElementDefinitionExampleComponent t) {
        if (t == null) {
            return this;
        }
        if (this.example == null) {
            this.example = new ArrayList<ElementDefinitionExampleComponent>();
        }
        this.example.add(t);
        return this;
    }

    public ElementDefinitionExampleComponent getExampleFirstRep() {
        if (this.getExample().isEmpty()) {
            this.addExample();
        }
        return this.getExample().get(0);
    }

    public Type getMinValue() {
        return this.minValue;
    }

    public DateType getMinValueDateType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new DateType();
        }
        if (!(this.minValue instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (DateType)this.minValue;
    }

    public boolean hasMinValueDateType() {
        return this != null && this.minValue instanceof DateType;
    }

    public DateTimeType getMinValueDateTimeType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new DateTimeType();
        }
        if (!(this.minValue instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.minValue;
    }

    public boolean hasMinValueDateTimeType() {
        return this != null && this.minValue instanceof DateTimeType;
    }

    public InstantType getMinValueInstantType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new InstantType();
        }
        if (!(this.minValue instanceof InstantType)) {
            throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (InstantType)this.minValue;
    }

    public boolean hasMinValueInstantType() {
        return this != null && this.minValue instanceof InstantType;
    }

    public TimeType getMinValueTimeType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new TimeType();
        }
        if (!(this.minValue instanceof TimeType)) {
            throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (TimeType)this.minValue;
    }

    public boolean hasMinValueTimeType() {
        return this != null && this.minValue instanceof TimeType;
    }

    public DecimalType getMinValueDecimalType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new DecimalType();
        }
        if (!(this.minValue instanceof DecimalType)) {
            throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (DecimalType)this.minValue;
    }

    public boolean hasMinValueDecimalType() {
        return this != null && this.minValue instanceof DecimalType;
    }

    public IntegerType getMinValueIntegerType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new IntegerType();
        }
        if (!(this.minValue instanceof IntegerType)) {
            throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (IntegerType)this.minValue;
    }

    public boolean hasMinValueIntegerType() {
        return this != null && this.minValue instanceof IntegerType;
    }

    public PositiveIntType getMinValuePositiveIntType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new PositiveIntType();
        }
        if (!(this.minValue instanceof PositiveIntType)) {
            throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (PositiveIntType)this.minValue;
    }

    public boolean hasMinValuePositiveIntType() {
        return this != null && this.minValue instanceof PositiveIntType;
    }

    public UnsignedIntType getMinValueUnsignedIntType() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new UnsignedIntType();
        }
        if (!(this.minValue instanceof UnsignedIntType)) {
            throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (UnsignedIntType)this.minValue;
    }

    public boolean hasMinValueUnsignedIntType() {
        return this != null && this.minValue instanceof UnsignedIntType;
    }

    public Quantity getMinValueQuantity() throws FHIRException {
        if (this.minValue == null) {
            this.minValue = new Quantity();
        }
        if (!(this.minValue instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.minValue.getClass().getName() + " was encountered");
        }
        return (Quantity)this.minValue;
    }

    public boolean hasMinValueQuantity() {
        return this != null && this.minValue instanceof Quantity;
    }

    public boolean hasMinValue() {
        return this.minValue != null && !this.minValue.isEmpty();
    }

    public ElementDefinition setMinValue(Type value) {
        if (!(value == null || value instanceof DateType || value instanceof DateTimeType || value instanceof InstantType || value instanceof TimeType || value instanceof DecimalType || value instanceof IntegerType || value instanceof PositiveIntType || value instanceof UnsignedIntType || value instanceof Quantity)) {
            throw new Error("Not the right type for ElementDefinition.minValue[x]: " + value.fhirType());
        }
        this.minValue = value;
        return this;
    }

    public Type getMaxValue() {
        return this.maxValue;
    }

    public DateType getMaxValueDateType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new DateType();
        }
        if (!(this.maxValue instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (DateType)this.maxValue;
    }

    public boolean hasMaxValueDateType() {
        return this != null && this.maxValue instanceof DateType;
    }

    public DateTimeType getMaxValueDateTimeType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new DateTimeType();
        }
        if (!(this.maxValue instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.maxValue;
    }

    public boolean hasMaxValueDateTimeType() {
        return this != null && this.maxValue instanceof DateTimeType;
    }

    public InstantType getMaxValueInstantType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new InstantType();
        }
        if (!(this.maxValue instanceof InstantType)) {
            throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (InstantType)this.maxValue;
    }

    public boolean hasMaxValueInstantType() {
        return this != null && this.maxValue instanceof InstantType;
    }

    public TimeType getMaxValueTimeType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new TimeType();
        }
        if (!(this.maxValue instanceof TimeType)) {
            throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (TimeType)this.maxValue;
    }

    public boolean hasMaxValueTimeType() {
        return this != null && this.maxValue instanceof TimeType;
    }

    public DecimalType getMaxValueDecimalType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new DecimalType();
        }
        if (!(this.maxValue instanceof DecimalType)) {
            throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (DecimalType)this.maxValue;
    }

    public boolean hasMaxValueDecimalType() {
        return this != null && this.maxValue instanceof DecimalType;
    }

    public IntegerType getMaxValueIntegerType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new IntegerType();
        }
        if (!(this.maxValue instanceof IntegerType)) {
            throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (IntegerType)this.maxValue;
    }

    public boolean hasMaxValueIntegerType() {
        return this != null && this.maxValue instanceof IntegerType;
    }

    public PositiveIntType getMaxValuePositiveIntType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new PositiveIntType();
        }
        if (!(this.maxValue instanceof PositiveIntType)) {
            throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (PositiveIntType)this.maxValue;
    }

    public boolean hasMaxValuePositiveIntType() {
        return this != null && this.maxValue instanceof PositiveIntType;
    }

    public UnsignedIntType getMaxValueUnsignedIntType() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new UnsignedIntType();
        }
        if (!(this.maxValue instanceof UnsignedIntType)) {
            throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (UnsignedIntType)this.maxValue;
    }

    public boolean hasMaxValueUnsignedIntType() {
        return this != null && this.maxValue instanceof UnsignedIntType;
    }

    public Quantity getMaxValueQuantity() throws FHIRException {
        if (this.maxValue == null) {
            this.maxValue = new Quantity();
        }
        if (!(this.maxValue instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.maxValue.getClass().getName() + " was encountered");
        }
        return (Quantity)this.maxValue;
    }

    public boolean hasMaxValueQuantity() {
        return this != null && this.maxValue instanceof Quantity;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null && !this.maxValue.isEmpty();
    }

    public ElementDefinition setMaxValue(Type value) {
        if (!(value == null || value instanceof DateType || value instanceof DateTimeType || value instanceof InstantType || value instanceof TimeType || value instanceof DecimalType || value instanceof IntegerType || value instanceof PositiveIntType || value instanceof UnsignedIntType || value instanceof Quantity)) {
            throw new Error("Not the right type for ElementDefinition.maxValue[x]: " + value.fhirType());
        }
        this.maxValue = value;
        return this;
    }

    public IntegerType getMaxLengthElement() {
        if (this.maxLength == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.maxLength");
            }
            if (Configuration.doAutoCreate()) {
                this.maxLength = new IntegerType();
            }
        }
        return this.maxLength;
    }

    public boolean hasMaxLengthElement() {
        return this.maxLength != null && !this.maxLength.isEmpty();
    }

    public boolean hasMaxLength() {
        return this.maxLength != null && !this.maxLength.isEmpty();
    }

    public ElementDefinition setMaxLengthElement(IntegerType value) {
        this.maxLength = value;
        return this;
    }

    public int getMaxLength() {
        return this.maxLength == null || this.maxLength.isEmpty() ? 0 : (Integer)this.maxLength.getValue();
    }

    public ElementDefinition setMaxLength(int value) {
        if (this.maxLength == null) {
            this.maxLength = new IntegerType();
        }
        this.maxLength.setValue((Object)value);
        return this;
    }

    public List<IdType> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<IdType>();
        }
        return this.condition;
    }

    public ElementDefinition setCondition(List<IdType> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (IdType item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IdType addConditionElement() {
        IdType t = new IdType();
        if (this.condition == null) {
            this.condition = new ArrayList<IdType>();
        }
        this.condition.add(t);
        return t;
    }

    public ElementDefinition addCondition(String value) {
        IdType t = new IdType();
        t.setValue(value);
        if (this.condition == null) {
            this.condition = new ArrayList<IdType>();
        }
        this.condition.add(t);
        return this;
    }

    public boolean hasCondition(String value) {
        if (this.condition == null) {
            return false;
        }
        for (IdType v : this.condition) {
            if (!v.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<ElementDefinitionConstraintComponent> getConstraint() {
        if (this.constraint == null) {
            this.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        }
        return this.constraint;
    }

    public ElementDefinition setConstraint(List<ElementDefinitionConstraintComponent> theConstraint) {
        this.constraint = theConstraint;
        return this;
    }

    public boolean hasConstraint() {
        if (this.constraint == null) {
            return false;
        }
        for (ElementDefinitionConstraintComponent item : this.constraint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinitionConstraintComponent addConstraint() {
        ElementDefinitionConstraintComponent t = new ElementDefinitionConstraintComponent();
        if (this.constraint == null) {
            this.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        }
        this.constraint.add(t);
        return t;
    }

    public ElementDefinition addConstraint(ElementDefinitionConstraintComponent t) {
        if (t == null) {
            return this;
        }
        if (this.constraint == null) {
            this.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        }
        this.constraint.add(t);
        return this;
    }

    public ElementDefinitionConstraintComponent getConstraintFirstRep() {
        if (this.getConstraint().isEmpty()) {
            this.addConstraint();
        }
        return this.getConstraint().get(0);
    }

    public BooleanType getMustSupportElement() {
        if (this.mustSupport == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.mustSupport");
            }
            if (Configuration.doAutoCreate()) {
                this.mustSupport = new BooleanType();
            }
        }
        return this.mustSupport;
    }

    public boolean hasMustSupportElement() {
        return this.mustSupport != null && !this.mustSupport.isEmpty();
    }

    public boolean hasMustSupport() {
        return this.mustSupport != null && !this.mustSupport.isEmpty();
    }

    public ElementDefinition setMustSupportElement(BooleanType value) {
        this.mustSupport = value;
        return this;
    }

    public boolean getMustSupport() {
        return this.mustSupport == null || this.mustSupport.isEmpty() ? false : (Boolean)this.mustSupport.getValue();
    }

    public ElementDefinition setMustSupport(boolean value) {
        if (this.mustSupport == null) {
            this.mustSupport = new BooleanType();
        }
        this.mustSupport.setValue((Object)value);
        return this;
    }

    public BooleanType getIsModifierElement() {
        if (this.isModifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.isModifier");
            }
            if (Configuration.doAutoCreate()) {
                this.isModifier = new BooleanType();
            }
        }
        return this.isModifier;
    }

    public boolean hasIsModifierElement() {
        return this.isModifier != null && !this.isModifier.isEmpty();
    }

    public boolean hasIsModifier() {
        return this.isModifier != null && !this.isModifier.isEmpty();
    }

    public ElementDefinition setIsModifierElement(BooleanType value) {
        this.isModifier = value;
        return this;
    }

    public boolean getIsModifier() {
        return this.isModifier == null || this.isModifier.isEmpty() ? false : (Boolean)this.isModifier.getValue();
    }

    public ElementDefinition setIsModifier(boolean value) {
        if (this.isModifier == null) {
            this.isModifier = new BooleanType();
        }
        this.isModifier.setValue((Object)value);
        return this;
    }

    public StringType getIsModifierReasonElement() {
        if (this.isModifierReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.isModifierReason");
            }
            if (Configuration.doAutoCreate()) {
                this.isModifierReason = new StringType();
            }
        }
        return this.isModifierReason;
    }

    public boolean hasIsModifierReasonElement() {
        return this.isModifierReason != null && !this.isModifierReason.isEmpty();
    }

    public boolean hasIsModifierReason() {
        return this.isModifierReason != null && !this.isModifierReason.isEmpty();
    }

    public ElementDefinition setIsModifierReasonElement(StringType value) {
        this.isModifierReason = value;
        return this;
    }

    public String getIsModifierReason() {
        return this.isModifierReason == null ? null : (String)this.isModifierReason.getValue();
    }

    public ElementDefinition setIsModifierReason(String value) {
        if (Utilities.noString((String)value)) {
            this.isModifierReason = null;
        } else {
            if (this.isModifierReason == null) {
                this.isModifierReason = new StringType();
            }
            this.isModifierReason.setValue(value);
        }
        return this;
    }

    public BooleanType getIsSummaryElement() {
        if (this.isSummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.isSummary");
            }
            if (Configuration.doAutoCreate()) {
                this.isSummary = new BooleanType();
            }
        }
        return this.isSummary;
    }

    public boolean hasIsSummaryElement() {
        return this.isSummary != null && !this.isSummary.isEmpty();
    }

    public boolean hasIsSummary() {
        return this.isSummary != null && !this.isSummary.isEmpty();
    }

    public ElementDefinition setIsSummaryElement(BooleanType value) {
        this.isSummary = value;
        return this;
    }

    public boolean getIsSummary() {
        return this.isSummary == null || this.isSummary.isEmpty() ? false : (Boolean)this.isSummary.getValue();
    }

    public ElementDefinition setIsSummary(boolean value) {
        if (this.isSummary == null) {
            this.isSummary = new BooleanType();
        }
        this.isSummary.setValue((Object)value);
        return this;
    }

    public ElementDefinitionBindingComponent getBinding() {
        if (this.binding == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.binding");
            }
            if (Configuration.doAutoCreate()) {
                this.binding = new ElementDefinitionBindingComponent();
            }
        }
        return this.binding;
    }

    public boolean hasBinding() {
        return this.binding != null && !this.binding.isEmpty();
    }

    public ElementDefinition setBinding(ElementDefinitionBindingComponent value) {
        this.binding = value;
        return this;
    }

    public List<ElementDefinitionMappingComponent> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<ElementDefinitionMappingComponent>();
        }
        return this.mapping;
    }

    public ElementDefinition setMapping(List<ElementDefinitionMappingComponent> theMapping) {
        this.mapping = theMapping;
        return this;
    }

    public boolean hasMapping() {
        if (this.mapping == null) {
            return false;
        }
        for (ElementDefinitionMappingComponent item : this.mapping) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinitionMappingComponent addMapping() {
        ElementDefinitionMappingComponent t = new ElementDefinitionMappingComponent();
        if (this.mapping == null) {
            this.mapping = new ArrayList<ElementDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return t;
    }

    public ElementDefinition addMapping(ElementDefinitionMappingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mapping == null) {
            this.mapping = new ArrayList<ElementDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return this;
    }

    public ElementDefinitionMappingComponent getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            this.addMapping();
        }
        return this.getMapping().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("path", "string", "The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource or extension.", 0, 1, this.path));
        children.add(new Property("representation", "code", "Codes that define how this element is represented in instances, when the deviation varies from the normal case.", 0, Integer.MAX_VALUE, this.representation));
        children.add(new Property("sliceName", "string", "The name of this element definition slice, when slicing is working. The name must be a token with no dots or spaces. This is a unique name referring to a specific set of constraints applied to this element, used to provide a name to different slices of the same element.", 0, 1, this.sliceName));
        children.add(new Property("sliceIsConstraining", "boolean", "If true, indicates that this slice definition is constraining a slice definition with the same name in an inherited profile. If false, the slice is not overriding any slice in an inherited profile. If missing, the slice might or might not be overriding a slice in an inherited profile, depending on the sliceName.", 0, 1, this.sliceIsConstraining));
        children.add(new Property("label", "string", "A single preferred label which is the text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.", 0, 1, this.label));
        children.add(new Property("code", "Coding", "A code that has the same meaning as the element in a particular terminology.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property("slicing", "", "Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).", 0, 1, this.slicing));
        children.add(new Property("short", "string", "A concise description of what this element means (e.g. for use in autogenerated summaries).", 0, 1, this.short_));
        children.add(new Property("definition", "markdown", "Provides a complete explanation of the meaning of the data element for human readability.  For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource. (Note: The text you are reading is specified in ElementDefinition.definition).", 0, 1, this.definition));
        children.add(new Property("comment", "markdown", "Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc. (Note: The text you are reading is specified in ElementDefinition.comment).", 0, 1, this.comment));
        children.add(new Property("requirements", "markdown", "This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.", 0, 1, this.requirements));
        children.add(new Property("alias", "string", "Identifies additional names by which this element might also be known.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("min", "unsignedInt", "The minimum number of times this element SHALL appear in the instance.", 0, 1, this.min));
        children.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the instance.", 0, 1, this.max));
        children.add(new Property("base", "", "Information about the base definition of the element, provided to make it unnecessary for tools to trace the deviation of the element through the derived and related profiles. When the element definition is not the original definition of an element - i.g. either in a constraint on another type, or for elements from a super type in a snap shot - then the information in provided in the element definition may be different to the base definition. On the original definition of the element, it will be same.", 0, 1, this.base));
        children.add(new Property("contentReference", "uri", "Identifies an element defined elsewhere in the definition whose content rules should be applied to the current element. ContentReferences bring across all the rules that are in the ElementDefinition for the element, including definitions, cardinality constraints, bindings, invariants etc.", 0, 1, this.contentReference));
        children.add(new Property("type", "", "The data type or resource that the value of this element is permitted to be.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue));
        children.add(new Property("meaningWhenMissing", "markdown", "The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing').", 0, 1, this.meaningWhenMissing));
        children.add(new Property("orderMeaning", "string", "If present, indicates that the order of the repeating element has meaning and describes what that meaning is.  If absent, it means that the order of the element has no meaning.", 0, 1, this.orderMeaning));
        children.add(new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed));
        children.add(new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern));
        children.add(new Property("example", "", "A sample value for this element demonstrating the type of information that would typically be found in the element.", 0, Integer.MAX_VALUE, this.example));
        children.add(new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue));
        children.add(new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue));
        children.add(new Property("maxLength", "integer", "Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element.", 0, 1, this.maxLength));
        children.add(new Property("condition", "id", "A reference to an invariant that may make additional statements about the cardinality or value in the instance.", 0, Integer.MAX_VALUE, this.condition));
        children.add(new Property("constraint", "", "Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.", 0, Integer.MAX_VALUE, this.constraint));
        children.add(new Property("mustSupport", "boolean", "If true, implementations that produce or consume resources SHALL provide \"support\" for the element in some meaningful way.  If false, the element may be ignored and not supported. If false, whether to populate or use the data element in any way is at the discretion of the implementation.", 0, 1, this.mustSupport));
        children.add(new Property("isModifier", "boolean", "If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.", 0, 1, this.isModifier));
        children.add(new Property("isModifierReason", "string", "Explains how that element affects the interpretation of the resource or element that contains it.", 0, 1, this.isModifierReason));
        children.add(new Property("isSummary", "boolean", "Whether the element should be included if a client requests a search with the parameter _summary=true.", 0, 1, this.isSummary));
        children.add(new Property("binding", "", "Binds to a value set if this element is coded (code, Coding, CodeableConcept, Quantity), or the data types (string, uri).", 0, 1, this.binding));
        children.add(new Property("mapping", "", "Identifies a concept from an external specification that roughly corresponds to this element.", 0, Integer.MAX_VALUE, this.mapping));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3433509: {
                return new Property("path", "string", "The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource or extension.", 0, 1, this.path);
            }
            case -671065907: {
                return new Property("representation", "code", "Codes that define how this element is represented in instances, when the deviation varies from the normal case.", 0, Integer.MAX_VALUE, this.representation);
            }
            case -825289923: {
                return new Property("sliceName", "string", "The name of this element definition slice, when slicing is working. The name must be a token with no dots or spaces. This is a unique name referring to a specific set of constraints applied to this element, used to provide a name to different slices of the same element.", 0, 1, this.sliceName);
            }
            case 333040519: {
                return new Property("sliceIsConstraining", "boolean", "If true, indicates that this slice definition is constraining a slice definition with the same name in an inherited profile. If false, the slice is not overriding any slice in an inherited profile. If missing, the slice might or might not be overriding a slice in an inherited profile, depending on the sliceName.", 0, 1, this.sliceIsConstraining);
            }
            case 102727412: {
                return new Property("label", "string", "A single preferred label which is the text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.", 0, 1, this.label);
            }
            case 3059181: {
                return new Property("code", "Coding", "A code that has the same meaning as the element in a particular terminology.", 0, Integer.MAX_VALUE, this.code);
            }
            case -2119287345: {
                return new Property("slicing", "", "Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).", 0, 1, this.slicing);
            }
            case 109413500: {
                return new Property("short", "string", "A concise description of what this element means (e.g. for use in autogenerated summaries).", 0, 1, this.short_);
            }
            case -1014418093: {
                return new Property("definition", "markdown", "Provides a complete explanation of the meaning of the data element for human readability.  For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource. (Note: The text you are reading is specified in ElementDefinition.definition).", 0, 1, this.definition);
            }
            case 950398559: {
                return new Property("comment", "markdown", "Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc. (Note: The text you are reading is specified in ElementDefinition.comment).", 0, 1, this.comment);
            }
            case -1619874672: {
                return new Property("requirements", "markdown", "This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.", 0, 1, this.requirements);
            }
            case 92902992: {
                return new Property("alias", "string", "Identifies additional names by which this element might also be known.", 0, Integer.MAX_VALUE, this.alias);
            }
            case 108114: {
                return new Property("min", "unsignedInt", "The minimum number of times this element SHALL appear in the instance.", 0, 1, this.min);
            }
            case 107876: {
                return new Property("max", "string", "The maximum number of times this element is permitted to appear in the instance.", 0, 1, this.max);
            }
            case 3016401: {
                return new Property("base", "", "Information about the base definition of the element, provided to make it unnecessary for tools to trace the deviation of the element through the derived and related profiles. When the element definition is not the original definition of an element - i.g. either in a constraint on another type, or for elements from a super type in a snap shot - then the information in provided in the element definition may be different to the base definition. On the original definition of the element, it will be same.", 0, 1, this.base);
            }
            case 1193747154: {
                return new Property("contentReference", "uri", "Identifies an element defined elsewhere in the definition whose content rules should be applied to the current element. ContentReferences bring across all the rules that are in the ElementDefinition for the element, including definitions, cardinality constraints, bindings, invariants etc.", 0, 1, this.contentReference);
            }
            case 3575610: {
                return new Property("type", "", "The data type or resource that the value of this element is permitted to be.", 0, Integer.MAX_VALUE, this.type);
            }
            case 587922128: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -659125328: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1470297600: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 600437336: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 264593188: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1044993469: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1045010302: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1220374379: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 2077989249: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -2059245333: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1801671663: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1801189522: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -325436225: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 587910138: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -737344154: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -320515103: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1045494429: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 539117290: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 587916188: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 587916191: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1045535627: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -611966428: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1851689217: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 2034820339: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -410434095: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -783616198: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -344740576: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -975393912: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1915078535: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -420255343: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1857379237: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1951495315: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1951489477: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -1488914053: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -449641228: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 509825768: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -302193638: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case -754548089: {
                return new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, 1, this.defaultValue);
            }
            case 1857257103: {
                return new Property("meaningWhenMissing", "markdown", "The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing').", 0, 1, this.meaningWhenMissing);
            }
            case 1828196047: {
                return new Property("orderMeaning", "string", "If present, indicates that the order of the repeating element has meaning and describes what that meaning is.  If absent, it means that the order of the element has no meaning.", 0, 1, this.orderMeaning);
            }
            case -391522164: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 97445748: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -799290428: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 520851988: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1092485088: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 746991489: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 747008322: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -1246771409: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1998403901: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -843914321: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -1881257011: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -1880774870: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1502385283: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -391534154: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 297821986: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1062390949: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 747492449: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1574283430: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -391528104: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -391528101: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 747533647: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -691551776: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -1956844093: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1929665463: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1962764685: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 599289854: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1680638692: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -147502012: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -2020233411: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 962650709: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -29557729: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1695345193: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1695351031: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -661022153: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 585524912: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1337717668: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 1080712414: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case 628357963: {
                return new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, 1, this.fixed);
            }
            case -885125392: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -791090288: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 2127857120: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1776945544: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 522246980: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1669806691: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1669789858: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 535949131: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -299393631: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -28553013: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 115912753: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 116394894: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1009861473: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -885137382: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 2054814086: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 2096647105: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1669305731: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -963691766: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -885131332: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -885131329: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1669264533: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1305617988: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1840611039: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1432153299: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -400610831: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1633546010: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 312818944: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -717740120: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1777221721: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1996906865: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1753162811: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -210954355: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -210948517: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1231260261: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1952450284: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 767479560: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 2114968570: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case 1662614119: {
                return new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  \n\nWhen pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly.\n\nWhen pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array.\n\nWhen pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e.,\n\n1. If primitive: it must match exactly the pattern value\n2. If a complex object: it must match (recursively) the pattern value\n3. If an array: it must match (recursively) the pattern value.", 0, 1, this.pattern);
            }
            case -1322970774: {
                return new Property("example", "", "A sample value for this element demonstrating the type of information that would typically be found in the element.", 0, Integer.MAX_VALUE, this.example);
            }
            case -55301663: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case -1376969153: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case -1715058035: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case 1635517178: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case 151382690: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case -1714573908: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case -263923694: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case 151864831: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case 1570935671: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case -1447570181: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case -1442236438: {
                return new Property("minValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.minValue);
            }
            case 622130931: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 399227501: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 2105483195: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 1699385640: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 1261821620: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 2105967322: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 846515236: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 1262303761: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case 1605774985: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case -1412730867: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case -1378367976: {
                return new Property("maxValue[x]", "date|dateTime|instant|time|decimal|integer|positiveInt|unsignedInt|Quantity", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, 1, this.maxValue);
            }
            case -791400086: {
                return new Property("maxLength", "integer", "Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element.", 0, 1, this.maxLength);
            }
            case -861311717: {
                return new Property("condition", "id", "A reference to an invariant that may make additional statements about the cardinality or value in the instance.", 0, Integer.MAX_VALUE, this.condition);
            }
            case -190376483: {
                return new Property("constraint", "", "Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.", 0, Integer.MAX_VALUE, this.constraint);
            }
            case -1402857082: {
                return new Property("mustSupport", "boolean", "If true, implementations that produce or consume resources SHALL provide \"support\" for the element in some meaningful way.  If false, the element may be ignored and not supported. If false, whether to populate or use the data element in any way is at the discretion of the implementation.", 0, 1, this.mustSupport);
            }
            case -1408783839: {
                return new Property("isModifier", "boolean", "If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.", 0, 1, this.isModifier);
            }
            case -1854387259: {
                return new Property("isModifierReason", "string", "Explains how that element affects the interpretation of the resource or element that contains it.", 0, 1, this.isModifierReason);
            }
            case 1857548060: {
                return new Property("isSummary", "boolean", "Whether the element should be included if a client requests a search with the parameter _summary=true.", 0, 1, this.isSummary);
            }
            case -108220795: {
                return new Property("binding", "", "Binds to a value set if this element is coded (code, Coding, CodeableConcept, Quantity), or the data types (string, uri).", 0, 1, this.binding);
            }
            case 837556430: {
                return new Property("mapping", "", "Identifies a concept from an external specification that roughly corresponds to this element.", 0, Integer.MAX_VALUE, this.mapping);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3433509: {
                Base[] baseArray;
                if (this.path == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.path;
                }
                return baseArray;
            }
            case -671065907: {
                return this.representation == null ? new Base[]{} : this.representation.toArray(new Base[this.representation.size()]);
            }
            case -825289923: {
                Base[] baseArray;
                if (this.sliceName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.sliceName;
                }
                return baseArray;
            }
            case 333040519: {
                Base[] baseArray;
                if (this.sliceIsConstraining == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.sliceIsConstraining;
                }
                return baseArray;
            }
            case 102727412: {
                Base[] baseArray;
                if (this.label == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.label;
                }
                return baseArray;
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case -2119287345: {
                Base[] baseArray;
                if (this.slicing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.slicing;
                }
                return baseArray;
            }
            case 109413500: {
                Base[] baseArray;
                if (this.short_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.short_;
                }
                return baseArray;
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.definition;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.comment;
                }
                return baseArray;
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.requirements;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case 108114: {
                Base[] baseArray;
                if (this.min == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.min;
                }
                return baseArray;
            }
            case 107876: {
                Base[] baseArray;
                if (this.max == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.max;
                }
                return baseArray;
            }
            case 3016401: {
                Base[] baseArray;
                if (this.base == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.base;
                }
                return baseArray;
            }
            case 1193747154: {
                Base[] baseArray;
                if (this.contentReference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.contentReference;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -659125328: {
                Base[] baseArray;
                if (this.defaultValue == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.defaultValue;
                }
                return baseArray;
            }
            case 1857257103: {
                Base[] baseArray;
                if (this.meaningWhenMissing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.meaningWhenMissing;
                }
                return baseArray;
            }
            case 1828196047: {
                Base[] baseArray;
                if (this.orderMeaning == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.orderMeaning;
                }
                return baseArray;
            }
            case 97445748: {
                Base[] baseArray;
                if (this.fixed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.fixed;
                }
                return baseArray;
            }
            case -791090288: {
                Base[] baseArray;
                if (this.pattern == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.pattern;
                }
                return baseArray;
            }
            case -1322970774: {
                return this.example == null ? new Base[]{} : this.example.toArray(new Base[this.example.size()]);
            }
            case -1376969153: {
                Base[] baseArray;
                if (this.minValue == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.minValue;
                }
                return baseArray;
            }
            case 399227501: {
                Base[] baseArray;
                if (this.maxValue == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.maxValue;
                }
                return baseArray;
            }
            case -791400086: {
                Base[] baseArray;
                if (this.maxLength == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.maxLength;
                }
                return baseArray;
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case -190376483: {
                return this.constraint == null ? new Base[]{} : this.constraint.toArray(new Base[this.constraint.size()]);
            }
            case -1402857082: {
                Base[] baseArray;
                if (this.mustSupport == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.mustSupport;
                }
                return baseArray;
            }
            case -1408783839: {
                Base[] baseArray;
                if (this.isModifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.isModifier;
                }
                return baseArray;
            }
            case -1854387259: {
                Base[] baseArray;
                if (this.isModifierReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray25 = new Base[1];
                    baseArray = baseArray25;
                    baseArray25[0] = this.isModifierReason;
                }
                return baseArray;
            }
            case 1857548060: {
                Base[] baseArray;
                if (this.isSummary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray26 = new Base[1];
                    baseArray = baseArray26;
                    baseArray26[0] = this.isSummary;
                }
                return baseArray;
            }
            case -108220795: {
                Base[] baseArray;
                if (this.binding == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray27 = new Base[1];
                    baseArray = baseArray27;
                    baseArray27[0] = this.binding;
                }
                return baseArray;
            }
            case 837556430: {
                return this.mapping == null ? new Base[]{} : this.mapping.toArray(new Base[this.mapping.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3433509: {
                this.path = this.castToString(value);
                return value;
            }
            case -671065907: {
                value = new PropertyRepresentationEnumFactory().fromType(this.castToCode(value));
                this.getRepresentation().add(value);
                return value;
            }
            case -825289923: {
                this.sliceName = this.castToString(value);
                return value;
            }
            case 333040519: {
                this.sliceIsConstraining = this.castToBoolean(value);
                return value;
            }
            case 102727412: {
                this.label = this.castToString(value);
                return value;
            }
            case 3059181: {
                this.getCode().add(this.castToCoding(value));
                return value;
            }
            case -2119287345: {
                this.slicing = (ElementDefinitionSlicingComponent)((Object)value);
                return value;
            }
            case 109413500: {
                this.short_ = this.castToString(value);
                return value;
            }
            case -1014418093: {
                this.definition = this.castToMarkdown(value);
                return value;
            }
            case 950398559: {
                this.comment = this.castToMarkdown(value);
                return value;
            }
            case -1619874672: {
                this.requirements = this.castToMarkdown(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(this.castToString(value));
                return value;
            }
            case 108114: {
                this.min = this.castToUnsignedInt(value);
                return value;
            }
            case 107876: {
                this.max = this.castToString(value);
                return value;
            }
            case 3016401: {
                this.base = (ElementDefinitionBaseComponent)((Object)value);
                return value;
            }
            case 1193747154: {
                this.contentReference = this.castToUri(value);
                return value;
            }
            case 3575610: {
                this.getType().add((TypeRefComponent)((Object)value));
                return value;
            }
            case -659125328: {
                this.defaultValue = this.castToType(value);
                return value;
            }
            case 1857257103: {
                this.meaningWhenMissing = this.castToMarkdown(value);
                return value;
            }
            case 1828196047: {
                this.orderMeaning = this.castToString(value);
                return value;
            }
            case 97445748: {
                this.fixed = this.castToType(value);
                return value;
            }
            case -791090288: {
                this.pattern = this.castToType(value);
                return value;
            }
            case -1322970774: {
                this.getExample().add((ElementDefinitionExampleComponent)((Object)value));
                return value;
            }
            case -1376969153: {
                this.minValue = this.castToType(value);
                return value;
            }
            case 399227501: {
                this.maxValue = this.castToType(value);
                return value;
            }
            case -791400086: {
                this.maxLength = this.castToInteger(value);
                return value;
            }
            case -861311717: {
                this.getCondition().add(this.castToId(value));
                return value;
            }
            case -190376483: {
                this.getConstraint().add((ElementDefinitionConstraintComponent)((Object)value));
                return value;
            }
            case -1402857082: {
                this.mustSupport = this.castToBoolean(value);
                return value;
            }
            case -1408783839: {
                this.isModifier = this.castToBoolean(value);
                return value;
            }
            case -1854387259: {
                this.isModifierReason = this.castToString(value);
                return value;
            }
            case 1857548060: {
                this.isSummary = this.castToBoolean(value);
                return value;
            }
            case -108220795: {
                this.binding = (ElementDefinitionBindingComponent)((Object)value);
                return value;
            }
            case 837556430: {
                this.getMapping().add((ElementDefinitionMappingComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("path")) {
            this.path = this.castToString(value);
        } else if (name.equals("representation")) {
            value = new PropertyRepresentationEnumFactory().fromType(this.castToCode(value));
            this.getRepresentation().add(value);
        } else if (name.equals("sliceName")) {
            this.sliceName = this.castToString(value);
        } else if (name.equals("sliceIsConstraining")) {
            this.sliceIsConstraining = this.castToBoolean(value);
        } else if (name.equals("label")) {
            this.label = this.castToString(value);
        } else if (name.equals("code")) {
            this.getCode().add(this.castToCoding(value));
        } else if (name.equals("slicing")) {
            this.slicing = (ElementDefinitionSlicingComponent)((Object)value);
        } else if (name.equals("short")) {
            this.short_ = this.castToString(value);
        } else if (name.equals("definition")) {
            this.definition = this.castToMarkdown(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToMarkdown(value);
        } else if (name.equals("requirements")) {
            this.requirements = this.castToMarkdown(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("min")) {
            this.min = this.castToUnsignedInt(value);
        } else if (name.equals("max")) {
            this.max = this.castToString(value);
        } else if (name.equals("base")) {
            this.base = (ElementDefinitionBaseComponent)((Object)value);
        } else if (name.equals("contentReference")) {
            this.contentReference = this.castToUri(value);
        } else if (name.equals("type")) {
            this.getType().add((TypeRefComponent)((Object)value));
        } else if (name.equals("defaultValue[x]")) {
            this.defaultValue = this.castToType(value);
        } else if (name.equals("meaningWhenMissing")) {
            this.meaningWhenMissing = this.castToMarkdown(value);
        } else if (name.equals("orderMeaning")) {
            this.orderMeaning = this.castToString(value);
        } else if (name.equals("fixed[x]")) {
            this.fixed = this.castToType(value);
        } else if (name.equals("pattern[x]")) {
            this.pattern = this.castToType(value);
        } else if (name.equals("example")) {
            this.getExample().add((ElementDefinitionExampleComponent)((Object)value));
        } else if (name.equals("minValue[x]")) {
            this.minValue = this.castToType(value);
        } else if (name.equals("maxValue[x]")) {
            this.maxValue = this.castToType(value);
        } else if (name.equals("maxLength")) {
            this.maxLength = this.castToInteger(value);
        } else if (name.equals("condition")) {
            this.getCondition().add(this.castToId(value));
        } else if (name.equals("constraint")) {
            this.getConstraint().add((ElementDefinitionConstraintComponent)((Object)value));
        } else if (name.equals("mustSupport")) {
            this.mustSupport = this.castToBoolean(value);
        } else if (name.equals("isModifier")) {
            this.isModifier = this.castToBoolean(value);
        } else if (name.equals("isModifierReason")) {
            this.isModifierReason = this.castToString(value);
        } else if (name.equals("isSummary")) {
            this.isSummary = this.castToBoolean(value);
        } else if (name.equals("binding")) {
            this.binding = (ElementDefinitionBindingComponent)((Object)value);
        } else if (name.equals("mapping")) {
            this.getMapping().add((ElementDefinitionMappingComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3433509: {
                return this.getPathElement();
            }
            case -671065907: {
                return this.addRepresentationElement();
            }
            case -825289923: {
                return this.getSliceNameElement();
            }
            case 333040519: {
                return this.getSliceIsConstrainingElement();
            }
            case 102727412: {
                return this.getLabelElement();
            }
            case 3059181: {
                return this.addCode();
            }
            case -2119287345: {
                return this.getSlicing();
            }
            case 109413500: {
                return this.getShortElement();
            }
            case -1014418093: {
                return this.getDefinitionElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case -1619874672: {
                return this.getRequirementsElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case 108114: {
                return this.getMinElement();
            }
            case 107876: {
                return this.getMaxElement();
            }
            case 3016401: {
                return this.getBase();
            }
            case 1193747154: {
                return this.getContentReferenceElement();
            }
            case 3575610: {
                return this.addType();
            }
            case 587922128: {
                return this.getDefaultValue();
            }
            case -659125328: {
                return this.getDefaultValue();
            }
            case 1857257103: {
                return this.getMeaningWhenMissingElement();
            }
            case 1828196047: {
                return this.getOrderMeaningElement();
            }
            case -391522164: {
                return this.getFixed();
            }
            case 97445748: {
                return this.getFixed();
            }
            case -885125392: {
                return this.getPattern();
            }
            case -791090288: {
                return this.getPattern();
            }
            case -1322970774: {
                return this.addExample();
            }
            case -55301663: {
                return this.getMinValue();
            }
            case -1376969153: {
                return this.getMinValue();
            }
            case 622130931: {
                return this.getMaxValue();
            }
            case 399227501: {
                return this.getMaxValue();
            }
            case -791400086: {
                return this.getMaxLengthElement();
            }
            case -861311717: {
                return this.addConditionElement();
            }
            case -190376483: {
                return this.addConstraint();
            }
            case -1402857082: {
                return this.getMustSupportElement();
            }
            case -1408783839: {
                return this.getIsModifierElement();
            }
            case -1854387259: {
                return this.getIsModifierReasonElement();
            }
            case 1857548060: {
                return this.getIsSummaryElement();
            }
            case -108220795: {
                return this.getBinding();
            }
            case 837556430: {
                return this.addMapping();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3433509: {
                return new String[]{"string"};
            }
            case -671065907: {
                return new String[]{"code"};
            }
            case -825289923: {
                return new String[]{"string"};
            }
            case 333040519: {
                return new String[]{"boolean"};
            }
            case 102727412: {
                return new String[]{"string"};
            }
            case 3059181: {
                return new String[]{"Coding"};
            }
            case -2119287345: {
                return new String[0];
            }
            case 109413500: {
                return new String[]{"string"};
            }
            case -1014418093: {
                return new String[]{"markdown"};
            }
            case 950398559: {
                return new String[]{"markdown"};
            }
            case -1619874672: {
                return new String[]{"markdown"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case 108114: {
                return new String[]{"unsignedInt"};
            }
            case 107876: {
                return new String[]{"string"};
            }
            case 3016401: {
                return new String[0];
            }
            case 1193747154: {
                return new String[]{"uri"};
            }
            case 3575610: {
                return new String[0];
            }
            case -659125328: {
                return new String[]{"*"};
            }
            case 1857257103: {
                return new String[]{"markdown"};
            }
            case 1828196047: {
                return new String[]{"string"};
            }
            case 97445748: {
                return new String[]{"*"};
            }
            case -791090288: {
                return new String[]{"*"};
            }
            case -1322970774: {
                return new String[0];
            }
            case -1376969153: {
                return new String[]{"date", "dateTime", "instant", "time", "decimal", "integer", "positiveInt", "unsignedInt", "Quantity"};
            }
            case 399227501: {
                return new String[]{"date", "dateTime", "instant", "time", "decimal", "integer", "positiveInt", "unsignedInt", "Quantity"};
            }
            case -791400086: {
                return new String[]{"integer"};
            }
            case -861311717: {
                return new String[]{"id"};
            }
            case -190376483: {
                return new String[0];
            }
            case -1402857082: {
                return new String[]{"boolean"};
            }
            case -1408783839: {
                return new String[]{"boolean"};
            }
            case -1854387259: {
                return new String[]{"string"};
            }
            case 1857548060: {
                return new String[]{"boolean"};
            }
            case -108220795: {
                return new String[0];
            }
            case 837556430: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("path")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.path");
        }
        if (name.equals("representation")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.representation");
        }
        if (name.equals("sliceName")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.sliceName");
        }
        if (name.equals("sliceIsConstraining")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.sliceIsConstraining");
        }
        if (name.equals("label")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.label");
        }
        if (name.equals("code")) {
            return this.addCode();
        }
        if (name.equals("slicing")) {
            this.slicing = new ElementDefinitionSlicingComponent();
            return this.slicing;
        }
        if (name.equals("short")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.short");
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.definition");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.comment");
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.requirements");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.alias");
        }
        if (name.equals("min")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.min");
        }
        if (name.equals("max")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.max");
        }
        if (name.equals("base")) {
            this.base = new ElementDefinitionBaseComponent();
            return this.base;
        }
        if (name.equals("contentReference")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.contentReference");
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("defaultValueBase64Binary")) {
            this.defaultValue = new Base64BinaryType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueBoolean")) {
            this.defaultValue = new BooleanType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCanonical")) {
            this.defaultValue = new CanonicalType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCode")) {
            this.defaultValue = new CodeType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDate")) {
            this.defaultValue = new DateType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDateTime")) {
            this.defaultValue = new DateTimeType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDecimal")) {
            this.defaultValue = new DecimalType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueId")) {
            this.defaultValue = new IdType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueInstant")) {
            this.defaultValue = new InstantType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueInteger")) {
            this.defaultValue = new IntegerType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueMarkdown")) {
            this.defaultValue = new MarkdownType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueOid")) {
            this.defaultValue = new OidType();
            return this.defaultValue;
        }
        if (name.equals("defaultValuePositiveInt")) {
            this.defaultValue = new PositiveIntType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueString")) {
            this.defaultValue = new StringType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueTime")) {
            this.defaultValue = new TimeType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUnsignedInt")) {
            this.defaultValue = new UnsignedIntType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUri")) {
            this.defaultValue = new UriType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUrl")) {
            this.defaultValue = new UrlType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUuid")) {
            this.defaultValue = new UuidType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAddress")) {
            this.defaultValue = new Address();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAge")) {
            this.defaultValue = new Age();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAnnotation")) {
            this.defaultValue = new Annotation();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAttachment")) {
            this.defaultValue = new Attachment();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCodeableConcept")) {
            this.defaultValue = new CodeableConcept();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCoding")) {
            this.defaultValue = new Coding();
            return this.defaultValue;
        }
        if (name.equals("defaultValueContactPoint")) {
            this.defaultValue = new ContactPoint();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCount")) {
            this.defaultValue = new Count();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDistance")) {
            this.defaultValue = new Distance();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDuration")) {
            this.defaultValue = new Duration();
            return this.defaultValue;
        }
        if (name.equals("defaultValueHumanName")) {
            this.defaultValue = new HumanName();
            return this.defaultValue;
        }
        if (name.equals("defaultValueIdentifier")) {
            this.defaultValue = new Identifier();
            return this.defaultValue;
        }
        if (name.equals("defaultValueMoney")) {
            this.defaultValue = new Money();
            return this.defaultValue;
        }
        if (name.equals("defaultValuePeriod")) {
            this.defaultValue = new Period();
            return this.defaultValue;
        }
        if (name.equals("defaultValueQuantity")) {
            this.defaultValue = new Quantity();
            return this.defaultValue;
        }
        if (name.equals("defaultValueRange")) {
            this.defaultValue = new Range();
            return this.defaultValue;
        }
        if (name.equals("defaultValueRatio")) {
            this.defaultValue = new Ratio();
            return this.defaultValue;
        }
        if (name.equals("defaultValueReference")) {
            this.defaultValue = new Reference();
            return this.defaultValue;
        }
        if (name.equals("defaultValueSampledData")) {
            this.defaultValue = new SampledData();
            return this.defaultValue;
        }
        if (name.equals("defaultValueSignature")) {
            this.defaultValue = new Signature();
            return this.defaultValue;
        }
        if (name.equals("defaultValueTiming")) {
            this.defaultValue = new Timing();
            return this.defaultValue;
        }
        if (name.equals("defaultValueContactDetail")) {
            this.defaultValue = new ContactDetail();
            return this.defaultValue;
        }
        if (name.equals("defaultValueContributor")) {
            this.defaultValue = new Contributor();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDataRequirement")) {
            this.defaultValue = new DataRequirement();
            return this.defaultValue;
        }
        if (name.equals("defaultValueExpression")) {
            this.defaultValue = new Expression();
            return this.defaultValue;
        }
        if (name.equals("defaultValueParameterDefinition")) {
            this.defaultValue = new ParameterDefinition();
            return this.defaultValue;
        }
        if (name.equals("defaultValueRelatedArtifact")) {
            this.defaultValue = new RelatedArtifact();
            return this.defaultValue;
        }
        if (name.equals("defaultValueTriggerDefinition")) {
            this.defaultValue = new TriggerDefinition();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUsageContext")) {
            this.defaultValue = new UsageContext();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDosage")) {
            this.defaultValue = new Dosage();
            return this.defaultValue;
        }
        if (name.equals("meaningWhenMissing")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.meaningWhenMissing");
        }
        if (name.equals("orderMeaning")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.orderMeaning");
        }
        if (name.equals("fixedBase64Binary")) {
            this.fixed = new Base64BinaryType();
            return this.fixed;
        }
        if (name.equals("fixedBoolean")) {
            this.fixed = new BooleanType();
            return this.fixed;
        }
        if (name.equals("fixedCanonical")) {
            this.fixed = new CanonicalType();
            return this.fixed;
        }
        if (name.equals("fixedCode")) {
            this.fixed = new CodeType();
            return this.fixed;
        }
        if (name.equals("fixedDate")) {
            this.fixed = new DateType();
            return this.fixed;
        }
        if (name.equals("fixedDateTime")) {
            this.fixed = new DateTimeType();
            return this.fixed;
        }
        if (name.equals("fixedDecimal")) {
            this.fixed = new DecimalType();
            return this.fixed;
        }
        if (name.equals("fixedId")) {
            this.fixed = new IdType();
            return this.fixed;
        }
        if (name.equals("fixedInstant")) {
            this.fixed = new InstantType();
            return this.fixed;
        }
        if (name.equals("fixedInteger")) {
            this.fixed = new IntegerType();
            return this.fixed;
        }
        if (name.equals("fixedMarkdown")) {
            this.fixed = new MarkdownType();
            return this.fixed;
        }
        if (name.equals("fixedOid")) {
            this.fixed = new OidType();
            return this.fixed;
        }
        if (name.equals("fixedPositiveInt")) {
            this.fixed = new PositiveIntType();
            return this.fixed;
        }
        if (name.equals("fixedString")) {
            this.fixed = new StringType();
            return this.fixed;
        }
        if (name.equals("fixedTime")) {
            this.fixed = new TimeType();
            return this.fixed;
        }
        if (name.equals("fixedUnsignedInt")) {
            this.fixed = new UnsignedIntType();
            return this.fixed;
        }
        if (name.equals("fixedUri")) {
            this.fixed = new UriType();
            return this.fixed;
        }
        if (name.equals("fixedUrl")) {
            this.fixed = new UrlType();
            return this.fixed;
        }
        if (name.equals("fixedUuid")) {
            this.fixed = new UuidType();
            return this.fixed;
        }
        if (name.equals("fixedAddress")) {
            this.fixed = new Address();
            return this.fixed;
        }
        if (name.equals("fixedAge")) {
            this.fixed = new Age();
            return this.fixed;
        }
        if (name.equals("fixedAnnotation")) {
            this.fixed = new Annotation();
            return this.fixed;
        }
        if (name.equals("fixedAttachment")) {
            this.fixed = new Attachment();
            return this.fixed;
        }
        if (name.equals("fixedCodeableConcept")) {
            this.fixed = new CodeableConcept();
            return this.fixed;
        }
        if (name.equals("fixedCoding")) {
            this.fixed = new Coding();
            return this.fixed;
        }
        if (name.equals("fixedContactPoint")) {
            this.fixed = new ContactPoint();
            return this.fixed;
        }
        if (name.equals("fixedCount")) {
            this.fixed = new Count();
            return this.fixed;
        }
        if (name.equals("fixedDistance")) {
            this.fixed = new Distance();
            return this.fixed;
        }
        if (name.equals("fixedDuration")) {
            this.fixed = new Duration();
            return this.fixed;
        }
        if (name.equals("fixedHumanName")) {
            this.fixed = new HumanName();
            return this.fixed;
        }
        if (name.equals("fixedIdentifier")) {
            this.fixed = new Identifier();
            return this.fixed;
        }
        if (name.equals("fixedMoney")) {
            this.fixed = new Money();
            return this.fixed;
        }
        if (name.equals("fixedPeriod")) {
            this.fixed = new Period();
            return this.fixed;
        }
        if (name.equals("fixedQuantity")) {
            this.fixed = new Quantity();
            return this.fixed;
        }
        if (name.equals("fixedRange")) {
            this.fixed = new Range();
            return this.fixed;
        }
        if (name.equals("fixedRatio")) {
            this.fixed = new Ratio();
            return this.fixed;
        }
        if (name.equals("fixedReference")) {
            this.fixed = new Reference();
            return this.fixed;
        }
        if (name.equals("fixedSampledData")) {
            this.fixed = new SampledData();
            return this.fixed;
        }
        if (name.equals("fixedSignature")) {
            this.fixed = new Signature();
            return this.fixed;
        }
        if (name.equals("fixedTiming")) {
            this.fixed = new Timing();
            return this.fixed;
        }
        if (name.equals("fixedContactDetail")) {
            this.fixed = new ContactDetail();
            return this.fixed;
        }
        if (name.equals("fixedContributor")) {
            this.fixed = new Contributor();
            return this.fixed;
        }
        if (name.equals("fixedDataRequirement")) {
            this.fixed = new DataRequirement();
            return this.fixed;
        }
        if (name.equals("fixedExpression")) {
            this.fixed = new Expression();
            return this.fixed;
        }
        if (name.equals("fixedParameterDefinition")) {
            this.fixed = new ParameterDefinition();
            return this.fixed;
        }
        if (name.equals("fixedRelatedArtifact")) {
            this.fixed = new RelatedArtifact();
            return this.fixed;
        }
        if (name.equals("fixedTriggerDefinition")) {
            this.fixed = new TriggerDefinition();
            return this.fixed;
        }
        if (name.equals("fixedUsageContext")) {
            this.fixed = new UsageContext();
            return this.fixed;
        }
        if (name.equals("fixedDosage")) {
            this.fixed = new Dosage();
            return this.fixed;
        }
        if (name.equals("patternBase64Binary")) {
            this.pattern = new Base64BinaryType();
            return this.pattern;
        }
        if (name.equals("patternBoolean")) {
            this.pattern = new BooleanType();
            return this.pattern;
        }
        if (name.equals("patternCanonical")) {
            this.pattern = new CanonicalType();
            return this.pattern;
        }
        if (name.equals("patternCode")) {
            this.pattern = new CodeType();
            return this.pattern;
        }
        if (name.equals("patternDate")) {
            this.pattern = new DateType();
            return this.pattern;
        }
        if (name.equals("patternDateTime")) {
            this.pattern = new DateTimeType();
            return this.pattern;
        }
        if (name.equals("patternDecimal")) {
            this.pattern = new DecimalType();
            return this.pattern;
        }
        if (name.equals("patternId")) {
            this.pattern = new IdType();
            return this.pattern;
        }
        if (name.equals("patternInstant")) {
            this.pattern = new InstantType();
            return this.pattern;
        }
        if (name.equals("patternInteger")) {
            this.pattern = new IntegerType();
            return this.pattern;
        }
        if (name.equals("patternMarkdown")) {
            this.pattern = new MarkdownType();
            return this.pattern;
        }
        if (name.equals("patternOid")) {
            this.pattern = new OidType();
            return this.pattern;
        }
        if (name.equals("patternPositiveInt")) {
            this.pattern = new PositiveIntType();
            return this.pattern;
        }
        if (name.equals("patternString")) {
            this.pattern = new StringType();
            return this.pattern;
        }
        if (name.equals("patternTime")) {
            this.pattern = new TimeType();
            return this.pattern;
        }
        if (name.equals("patternUnsignedInt")) {
            this.pattern = new UnsignedIntType();
            return this.pattern;
        }
        if (name.equals("patternUri")) {
            this.pattern = new UriType();
            return this.pattern;
        }
        if (name.equals("patternUrl")) {
            this.pattern = new UrlType();
            return this.pattern;
        }
        if (name.equals("patternUuid")) {
            this.pattern = new UuidType();
            return this.pattern;
        }
        if (name.equals("patternAddress")) {
            this.pattern = new Address();
            return this.pattern;
        }
        if (name.equals("patternAge")) {
            this.pattern = new Age();
            return this.pattern;
        }
        if (name.equals("patternAnnotation")) {
            this.pattern = new Annotation();
            return this.pattern;
        }
        if (name.equals("patternAttachment")) {
            this.pattern = new Attachment();
            return this.pattern;
        }
        if (name.equals("patternCodeableConcept")) {
            this.pattern = new CodeableConcept();
            return this.pattern;
        }
        if (name.equals("patternCoding")) {
            this.pattern = new Coding();
            return this.pattern;
        }
        if (name.equals("patternContactPoint")) {
            this.pattern = new ContactPoint();
            return this.pattern;
        }
        if (name.equals("patternCount")) {
            this.pattern = new Count();
            return this.pattern;
        }
        if (name.equals("patternDistance")) {
            this.pattern = new Distance();
            return this.pattern;
        }
        if (name.equals("patternDuration")) {
            this.pattern = new Duration();
            return this.pattern;
        }
        if (name.equals("patternHumanName")) {
            this.pattern = new HumanName();
            return this.pattern;
        }
        if (name.equals("patternIdentifier")) {
            this.pattern = new Identifier();
            return this.pattern;
        }
        if (name.equals("patternMoney")) {
            this.pattern = new Money();
            return this.pattern;
        }
        if (name.equals("patternPeriod")) {
            this.pattern = new Period();
            return this.pattern;
        }
        if (name.equals("patternQuantity")) {
            this.pattern = new Quantity();
            return this.pattern;
        }
        if (name.equals("patternRange")) {
            this.pattern = new Range();
            return this.pattern;
        }
        if (name.equals("patternRatio")) {
            this.pattern = new Ratio();
            return this.pattern;
        }
        if (name.equals("patternReference")) {
            this.pattern = new Reference();
            return this.pattern;
        }
        if (name.equals("patternSampledData")) {
            this.pattern = new SampledData();
            return this.pattern;
        }
        if (name.equals("patternSignature")) {
            this.pattern = new Signature();
            return this.pattern;
        }
        if (name.equals("patternTiming")) {
            this.pattern = new Timing();
            return this.pattern;
        }
        if (name.equals("patternContactDetail")) {
            this.pattern = new ContactDetail();
            return this.pattern;
        }
        if (name.equals("patternContributor")) {
            this.pattern = new Contributor();
            return this.pattern;
        }
        if (name.equals("patternDataRequirement")) {
            this.pattern = new DataRequirement();
            return this.pattern;
        }
        if (name.equals("patternExpression")) {
            this.pattern = new Expression();
            return this.pattern;
        }
        if (name.equals("patternParameterDefinition")) {
            this.pattern = new ParameterDefinition();
            return this.pattern;
        }
        if (name.equals("patternRelatedArtifact")) {
            this.pattern = new RelatedArtifact();
            return this.pattern;
        }
        if (name.equals("patternTriggerDefinition")) {
            this.pattern = new TriggerDefinition();
            return this.pattern;
        }
        if (name.equals("patternUsageContext")) {
            this.pattern = new UsageContext();
            return this.pattern;
        }
        if (name.equals("patternDosage")) {
            this.pattern = new Dosage();
            return this.pattern;
        }
        if (name.equals("example")) {
            return this.addExample();
        }
        if (name.equals("minValueDate")) {
            this.minValue = new DateType();
            return this.minValue;
        }
        if (name.equals("minValueDateTime")) {
            this.minValue = new DateTimeType();
            return this.minValue;
        }
        if (name.equals("minValueInstant")) {
            this.minValue = new InstantType();
            return this.minValue;
        }
        if (name.equals("minValueTime")) {
            this.minValue = new TimeType();
            return this.minValue;
        }
        if (name.equals("minValueDecimal")) {
            this.minValue = new DecimalType();
            return this.minValue;
        }
        if (name.equals("minValueInteger")) {
            this.minValue = new IntegerType();
            return this.minValue;
        }
        if (name.equals("minValuePositiveInt")) {
            this.minValue = new PositiveIntType();
            return this.minValue;
        }
        if (name.equals("minValueUnsignedInt")) {
            this.minValue = new UnsignedIntType();
            return this.minValue;
        }
        if (name.equals("minValueQuantity")) {
            this.minValue = new Quantity();
            return this.minValue;
        }
        if (name.equals("maxValueDate")) {
            this.maxValue = new DateType();
            return this.maxValue;
        }
        if (name.equals("maxValueDateTime")) {
            this.maxValue = new DateTimeType();
            return this.maxValue;
        }
        if (name.equals("maxValueInstant")) {
            this.maxValue = new InstantType();
            return this.maxValue;
        }
        if (name.equals("maxValueTime")) {
            this.maxValue = new TimeType();
            return this.maxValue;
        }
        if (name.equals("maxValueDecimal")) {
            this.maxValue = new DecimalType();
            return this.maxValue;
        }
        if (name.equals("maxValueInteger")) {
            this.maxValue = new IntegerType();
            return this.maxValue;
        }
        if (name.equals("maxValuePositiveInt")) {
            this.maxValue = new PositiveIntType();
            return this.maxValue;
        }
        if (name.equals("maxValueUnsignedInt")) {
            this.maxValue = new UnsignedIntType();
            return this.maxValue;
        }
        if (name.equals("maxValueQuantity")) {
            this.maxValue = new Quantity();
            return this.maxValue;
        }
        if (name.equals("maxLength")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.maxLength");
        }
        if (name.equals("condition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.condition");
        }
        if (name.equals("constraint")) {
            return this.addConstraint();
        }
        if (name.equals("mustSupport")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.mustSupport");
        }
        if (name.equals("isModifier")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.isModifier");
        }
        if (name.equals("isModifierReason")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.isModifierReason");
        }
        if (name.equals("isSummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.isSummary");
        }
        if (name.equals("binding")) {
            this.binding = new ElementDefinitionBindingComponent();
            return this.binding;
        }
        if (name.equals("mapping")) {
            return this.addMapping();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ElementDefinition";
    }

    @Override
    public ElementDefinition copy() {
        ElementDefinition dst = new ElementDefinition();
        this.copyValues(dst);
        StringType stringType = dst.path = this.path == null ? null : this.path.copy();
        if (this.representation != null) {
            dst.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
            for (Enumeration<PropertyRepresentation> enumeration : this.representation) {
                dst.representation.add((Enumeration<PropertyRepresentation>)enumeration.copy());
            }
        }
        dst.sliceName = this.sliceName == null ? null : this.sliceName.copy();
        dst.sliceIsConstraining = this.sliceIsConstraining == null ? null : this.sliceIsConstraining.copy();
        StringType stringType2 = dst.label = this.label == null ? null : this.label.copy();
        if (this.code != null) {
            dst.code = new ArrayList<Coding>();
            for (Coding coding : this.code) {
                dst.code.add(coding.copy());
            }
        }
        dst.slicing = this.slicing == null ? null : this.slicing.copy();
        dst.short_ = this.short_ == null ? null : this.short_.copy();
        dst.definition = this.definition == null ? null : this.definition.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        MarkdownType markdownType = dst.requirements = this.requirements == null ? null : this.requirements.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType3 : this.alias) {
                dst.alias.add(stringType3.copy());
            }
        }
        dst.min = this.min == null ? null : this.min.copy();
        dst.max = this.max == null ? null : this.max.copy();
        dst.base = this.base == null ? null : this.base.copy();
        UriType uriType = dst.contentReference = this.contentReference == null ? null : this.contentReference.copy();
        if (this.type != null) {
            dst.type = new ArrayList<TypeRefComponent>();
            for (TypeRefComponent typeRefComponent : this.type) {
                dst.type.add(typeRefComponent.copy());
            }
        }
        dst.defaultValue = this.defaultValue == null ? null : this.defaultValue.copy();
        dst.meaningWhenMissing = this.meaningWhenMissing == null ? null : this.meaningWhenMissing.copy();
        dst.orderMeaning = this.orderMeaning == null ? null : this.orderMeaning.copy();
        dst.fixed = this.fixed == null ? null : this.fixed.copy();
        Type type = dst.pattern = this.pattern == null ? null : this.pattern.copy();
        if (this.example != null) {
            dst.example = new ArrayList<ElementDefinitionExampleComponent>();
            for (ElementDefinitionExampleComponent elementDefinitionExampleComponent : this.example) {
                dst.example.add(elementDefinitionExampleComponent.copy());
            }
        }
        dst.minValue = this.minValue == null ? null : this.minValue.copy();
        dst.maxValue = this.maxValue == null ? null : this.maxValue.copy();
        IntegerType integerType = dst.maxLength = this.maxLength == null ? null : this.maxLength.copy();
        if (this.condition != null) {
            dst.condition = new ArrayList<IdType>();
            for (IdType idType : this.condition) {
                dst.condition.add(idType.copy());
            }
        }
        if (this.constraint != null) {
            dst.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
            for (ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : this.constraint) {
                dst.constraint.add(elementDefinitionConstraintComponent.copy());
            }
        }
        dst.mustSupport = this.mustSupport == null ? null : this.mustSupport.copy();
        dst.isModifier = this.isModifier == null ? null : this.isModifier.copy();
        dst.isModifierReason = this.isModifierReason == null ? null : this.isModifierReason.copy();
        dst.isSummary = this.isSummary == null ? null : this.isSummary.copy();
        ElementDefinitionBindingComponent elementDefinitionBindingComponent = dst.binding = this.binding == null ? null : this.binding.copy();
        if (this.mapping != null) {
            dst.mapping = new ArrayList<ElementDefinitionMappingComponent>();
            for (ElementDefinitionMappingComponent elementDefinitionMappingComponent : this.mapping) {
                dst.mapping.add(elementDefinitionMappingComponent.copy());
            }
        }
        return dst;
    }

    @Override
    protected ElementDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ElementDefinition)) {
            return false;
        }
        ElementDefinition o = (ElementDefinition)other_;
        return ElementDefinition.compareDeep(this.path, o.path, true) && ElementDefinition.compareDeep(this.representation, o.representation, true) && ElementDefinition.compareDeep(this.sliceName, o.sliceName, true) && ElementDefinition.compareDeep(this.sliceIsConstraining, o.sliceIsConstraining, true) && ElementDefinition.compareDeep(this.label, o.label, true) && ElementDefinition.compareDeep(this.code, o.code, true) && ElementDefinition.compareDeep(this.slicing, o.slicing, true) && ElementDefinition.compareDeep(this.short_, o.short_, true) && ElementDefinition.compareDeep(this.definition, o.definition, true) && ElementDefinition.compareDeep(this.comment, o.comment, true) && ElementDefinition.compareDeep(this.requirements, o.requirements, true) && ElementDefinition.compareDeep(this.alias, o.alias, true) && ElementDefinition.compareDeep(this.min, o.min, true) && ElementDefinition.compareDeep(this.max, o.max, true) && ElementDefinition.compareDeep(this.base, o.base, true) && ElementDefinition.compareDeep(this.contentReference, o.contentReference, true) && ElementDefinition.compareDeep(this.type, o.type, true) && ElementDefinition.compareDeep(this.defaultValue, o.defaultValue, true) && ElementDefinition.compareDeep(this.meaningWhenMissing, o.meaningWhenMissing, true) && ElementDefinition.compareDeep(this.orderMeaning, o.orderMeaning, true) && ElementDefinition.compareDeep(this.fixed, o.fixed, true) && ElementDefinition.compareDeep(this.pattern, o.pattern, true) && ElementDefinition.compareDeep(this.example, o.example, true) && ElementDefinition.compareDeep(this.minValue, o.minValue, true) && ElementDefinition.compareDeep(this.maxValue, o.maxValue, true) && ElementDefinition.compareDeep(this.maxLength, o.maxLength, true) && ElementDefinition.compareDeep(this.condition, o.condition, true) && ElementDefinition.compareDeep(this.constraint, o.constraint, true) && ElementDefinition.compareDeep(this.mustSupport, o.mustSupport, true) && ElementDefinition.compareDeep(this.isModifier, o.isModifier, true) && ElementDefinition.compareDeep(this.isModifierReason, o.isModifierReason, true) && ElementDefinition.compareDeep(this.isSummary, o.isSummary, true) && ElementDefinition.compareDeep(this.binding, o.binding, true) && ElementDefinition.compareDeep(this.mapping, o.mapping, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ElementDefinition)) {
            return false;
        }
        ElementDefinition o = (ElementDefinition)other_;
        return ElementDefinition.compareValues(this.path, o.path, true) && ElementDefinition.compareValues(this.representation, o.representation, true) && ElementDefinition.compareValues(this.sliceName, o.sliceName, true) && ElementDefinition.compareValues(this.sliceIsConstraining, o.sliceIsConstraining, true) && ElementDefinition.compareValues(this.label, o.label, true) && ElementDefinition.compareValues(this.short_, o.short_, true) && ElementDefinition.compareValues(this.definition, o.definition, true) && ElementDefinition.compareValues(this.comment, o.comment, true) && ElementDefinition.compareValues(this.requirements, o.requirements, true) && ElementDefinition.compareValues(this.alias, o.alias, true) && ElementDefinition.compareValues(this.min, o.min, true) && ElementDefinition.compareValues(this.max, o.max, true) && ElementDefinition.compareValues(this.contentReference, o.contentReference, true) && ElementDefinition.compareValues(this.meaningWhenMissing, o.meaningWhenMissing, true) && ElementDefinition.compareValues(this.orderMeaning, o.orderMeaning, true) && ElementDefinition.compareValues(this.maxLength, o.maxLength, true) && ElementDefinition.compareValues(this.condition, o.condition, true) && ElementDefinition.compareValues(this.mustSupport, o.mustSupport, true) && ElementDefinition.compareValues(this.isModifier, o.isModifier, true) && ElementDefinition.compareValues(this.isModifierReason, o.isModifierReason, true) && ElementDefinition.compareValues(this.isSummary, o.isSummary, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.path, this.representation, this.sliceName, this.sliceIsConstraining, this.label, this.code, this.slicing, this.short_, this.definition, this.comment, this.requirements, this.alias, this.min, this.max, this.base, this.contentReference, this.type, this.defaultValue, this.meaningWhenMissing, this.orderMeaning, this.fixed, this.pattern, this.example, this.minValue, this.maxValue, this.maxLength, this.condition, this.constraint, this.mustSupport, this.isModifier, this.isModifierReason, this.isSummary, this.binding, this.mapping});
    }

    public String toString() {
        if (this.hasId()) {
            return this.getId();
        }
        if (this.hasSliceName()) {
            return this.getPath() + ":" + this.getSliceName();
        }
        return this.getPath();
    }

    public void makeBase(String path, int min, String max) {
        ElementDefinitionBaseComponent self = this.getBase();
        self.setPath(path);
        self.setMin(min);
        self.setMax(max);
    }

    public void makeBase() {
        ElementDefinitionBaseComponent self = this.getBase();
        self.setPath(this.getPath());
        self.setMin(this.getMin());
        self.setMax(this.getMax());
    }

    public String typeSummary() {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (TypeRefComponent tr : this.type) {
            if (!tr.hasCode()) continue;
            b.append(tr.getCode());
        }
        return b.toString();
    }

    public TypeRefComponent getType(String code) {
        for (TypeRefComponent tr : this.getType()) {
            if (!tr.getCode().equals(code)) continue;
            return tr;
        }
        TypeRefComponent tr = new TypeRefComponent();
        tr.setCode(code);
        this.type.add(tr);
        return tr;
    }

    public ElementDefinition(boolean defaults, boolean modifier, boolean inSummary) {
        if (defaults) {
            this.setIsModifier(modifier);
            this.setIsSummary(inSummary);
        }
    }

    public String present() {
        return this.hasId() ? this.getId() : this.getPath();
    }

    @Block
    public static class ElementDefinitionMappingComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="identity", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to mapping declaration", formalDefinition="An internal reference to the definition of a mapping.")
        protected IdType identity;
        @Child(name="language", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Computable language of mapping", formalDefinition="Identifies the computable language in which mapping.map is expressed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
        protected CodeType language;
        @Child(name="map", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Details of the mapping", formalDefinition="Expresses what part of the target specification corresponds to this element.")
        protected StringType map;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Comments about the mapping or its use", formalDefinition="Comments that provide information about the mapping or its use.")
        protected StringType comment;
        private static final long serialVersionUID = 1386816887L;

        public ElementDefinitionMappingComponent() {
        }

        public ElementDefinitionMappingComponent(IdType identity, StringType map) {
            this.identity = identity;
            this.map = map;
        }

        public IdType getIdentityElement() {
            if (this.identity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.identity");
                }
                if (Configuration.doAutoCreate()) {
                    this.identity = new IdType();
                }
            }
            return this.identity;
        }

        public boolean hasIdentityElement() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public boolean hasIdentity() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public ElementDefinitionMappingComponent setIdentityElement(IdType value) {
            this.identity = value;
            return this;
        }

        public String getIdentity() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public ElementDefinitionMappingComponent setIdentity(String value) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(value);
            return this;
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ElementDefinitionMappingComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ElementDefinitionMappingComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getMapElement() {
            if (this.map == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.map");
                }
                if (Configuration.doAutoCreate()) {
                    this.map = new StringType();
                }
            }
            return this.map;
        }

        public boolean hasMapElement() {
            return this.map != null && !this.map.isEmpty();
        }

        public boolean hasMap() {
            return this.map != null && !this.map.isEmpty();
        }

        public ElementDefinitionMappingComponent setMapElement(StringType value) {
            this.map = value;
            return this;
        }

        public String getMap() {
            return this.map == null ? null : (String)this.map.getValue();
        }

        public ElementDefinitionMappingComponent setMap(String value) {
            if (this.map == null) {
                this.map = new StringType();
            }
            this.map.setValue(value);
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public ElementDefinitionMappingComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public ElementDefinitionMappingComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identity", "id", "An internal reference to the definition of a mapping.", 0, 1, this.identity));
            children.add(new Property("language", "code", "Identifies the computable language in which mapping.map is expressed.", 0, 1, this.language));
            children.add(new Property("map", "string", "Expresses what part of the target specification corresponds to this element.", 0, 1, this.map));
            children.add(new Property("comment", "string", "Comments that provide information about the mapping or its use.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -135761730: {
                    return new Property("identity", "id", "An internal reference to the definition of a mapping.", 0, 1, this.identity);
                }
                case -1613589672: {
                    return new Property("language", "code", "Identifies the computable language in which mapping.map is expressed.", 0, 1, this.language);
                }
                case 107868: {
                    return new Property("map", "string", "Expresses what part of the target specification corresponds to this element.", 0, 1, this.map);
                }
                case 950398559: {
                    return new Property("comment", "string", "Comments that provide information about the mapping or its use.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    Base[] baseArray;
                    if (this.identity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identity;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 107868: {
                    Base[] baseArray;
                    if (this.map == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.map;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    this.identity = this.castToId(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToCode(value);
                    return value;
                }
                case 107868: {
                    this.map = this.castToString(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identity")) {
                this.identity = this.castToId(value);
            } else if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("map")) {
                this.map = this.castToString(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    return this.getIdentityElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 107868: {
                    return this.getMapElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    return new String[]{"id"};
                }
                case -1613589672: {
                    return new String[]{"code"};
                }
                case 107868: {
                    return new String[]{"string"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identity")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.identity");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.language");
            }
            if (name.equals("map")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.map");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.comment");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionMappingComponent copy() {
            ElementDefinitionMappingComponent dst = new ElementDefinitionMappingComponent();
            this.copyValues(dst);
            dst.identity = this.identity == null ? null : this.identity.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.map = this.map == null ? null : this.map.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionMappingComponent)) {
                return false;
            }
            ElementDefinitionMappingComponent o = (ElementDefinitionMappingComponent)other_;
            return ElementDefinitionMappingComponent.compareDeep(this.identity, o.identity, true) && ElementDefinitionMappingComponent.compareDeep(this.language, o.language, true) && ElementDefinitionMappingComponent.compareDeep(this.map, o.map, true) && ElementDefinitionMappingComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionMappingComponent)) {
                return false;
            }
            ElementDefinitionMappingComponent o = (ElementDefinitionMappingComponent)other_;
            return ElementDefinitionMappingComponent.compareValues(this.identity, o.identity, true) && ElementDefinitionMappingComponent.compareValues(this.language, o.language, true) && ElementDefinitionMappingComponent.compareValues(this.map, o.map, true) && ElementDefinitionMappingComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identity, this.language, this.map, this.comment});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.mapping";
        }
    }

    @Block
    public static class ElementDefinitionBindingComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="strength", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="required | extensible | preferred | example", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/binding-strength")
        protected Enumeration<Enumerations.BindingStrength> strength;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human explanation of the value set", formalDefinition="Describes the intended use of this particular set of codes.")
        protected StringType description;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Source of value set", formalDefinition="Refers to the value set that identifies the set of codes the binding refers to.")
        protected CanonicalType valueSet;
        private static final long serialVersionUID = -514477030L;

        public ElementDefinitionBindingComponent() {
        }

        public ElementDefinitionBindingComponent(Enumeration<Enumerations.BindingStrength> strength) {
            this.strength = strength;
        }

        public Enumeration<Enumerations.BindingStrength> getStrengthElement() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBindingComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
                }
            }
            return this.strength;
        }

        public boolean hasStrengthElement() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public ElementDefinitionBindingComponent setStrengthElement(Enumeration<Enumerations.BindingStrength> value) {
            this.strength = value;
            return this;
        }

        public Enumerations.BindingStrength getStrength() {
            return this.strength == null ? null : (Enumerations.BindingStrength)((Object)this.strength.getValue());
        }

        public ElementDefinitionBindingComponent setStrength(Enumerations.BindingStrength value) {
            if (this.strength == null) {
                this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
            }
            this.strength.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBindingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ElementDefinitionBindingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ElementDefinitionBindingComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBindingComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public ElementDefinitionBindingComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public ElementDefinitionBindingComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("strength", "code", "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, 1, this.strength));
            children.add(new Property("description", "string", "Describes the intended use of this particular set of codes.", 0, 1, this.description));
            children.add(new Property("valueSet", "canonical(ValueSet)", "Refers to the value set that identifies the set of codes the binding refers to.", 0, 1, this.valueSet));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1791316033: {
                    return new Property("strength", "code", "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, 1, this.strength);
                }
                case -1724546052: {
                    return new Property("description", "string", "Describes the intended use of this particular set of codes.", 0, 1, this.description);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "Refers to the value set that identifies the set of codes the binding refers to.", 0, 1, this.valueSet);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.strength;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    value = new Enumerations.BindingStrengthEnumFactory().fromType(this.castToCode(value));
                    this.strength = value;
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = this.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("strength")) {
                value = new Enumerations.BindingStrengthEnumFactory().fromType(this.castToCode(value));
                this.strength = value;
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = this.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    return this.getStrengthElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    return new String[]{"code"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("strength")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.strength");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.description");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.valueSet");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionBindingComponent copy() {
            ElementDefinitionBindingComponent dst = new ElementDefinitionBindingComponent();
            this.copyValues(dst);
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionBindingComponent)) {
                return false;
            }
            ElementDefinitionBindingComponent o = (ElementDefinitionBindingComponent)other_;
            return ElementDefinitionBindingComponent.compareDeep(this.strength, o.strength, true) && ElementDefinitionBindingComponent.compareDeep(this.description, o.description, true) && ElementDefinitionBindingComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionBindingComponent)) {
                return false;
            }
            ElementDefinitionBindingComponent o = (ElementDefinitionBindingComponent)other_;
            return ElementDefinitionBindingComponent.compareValues(this.strength, o.strength, true) && ElementDefinitionBindingComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.strength, this.description, this.valueSet});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.binding";
        }
    }

    @Block
    public static class ElementDefinitionConstraintComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="key", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Target of 'condition' reference above", formalDefinition="Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality.")
        protected IdType key;
        @Child(name="requirements", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why this constraint is necessary or appropriate", formalDefinition="Description of why this constraint is necessary or appropriate.")
        protected StringType requirements;
        @Child(name="severity", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="error | warning", formalDefinition="Identifies the impact constraint violation has on the conformance of the instance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/constraint-severity")
        protected Enumeration<ConstraintSeverity> severity;
        @Child(name="human", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human description of constraint", formalDefinition="Text that can be used to describe the constraint in messages identifying that the constraint has been violated.")
        protected StringType human;
        @Child(name="expression", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath expression of constraint", formalDefinition="A [FHIRPath](fhirpath.html) expression of constraint that can be executed to see if this constraint is met.")
        protected StringType expression;
        @Child(name="xpath", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="XPath expression of constraint", formalDefinition="An XPath expression of constraint that can be executed to see if this constraint is met.")
        protected StringType xpath;
        @Child(name="source", type={CanonicalType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to original source of constraint", formalDefinition="A reference to the original source of the constraint, for traceability purposes.")
        protected CanonicalType source;
        private static final long serialVersionUID = 1048354565L;

        public ElementDefinitionConstraintComponent() {
        }

        public ElementDefinitionConstraintComponent(IdType key, Enumeration<ConstraintSeverity> severity, StringType human) {
            this.key = key;
            this.severity = severity;
            this.human = human;
        }

        public IdType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new IdType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public ElementDefinitionConstraintComponent setKeyElement(IdType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : this.key.getValue();
        }

        public ElementDefinitionConstraintComponent setKey(String value) {
            if (this.key == null) {
                this.key = new IdType();
            }
            this.key.setValue(value);
            return this;
        }

        public StringType getRequirementsElement() {
            if (this.requirements == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.requirements");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirements = new StringType();
                }
            }
            return this.requirements;
        }

        public boolean hasRequirementsElement() {
            return this.requirements != null && !this.requirements.isEmpty();
        }

        public boolean hasRequirements() {
            return this.requirements != null && !this.requirements.isEmpty();
        }

        public ElementDefinitionConstraintComponent setRequirementsElement(StringType value) {
            this.requirements = value;
            return this;
        }

        public String getRequirements() {
            return this.requirements == null ? null : (String)this.requirements.getValue();
        }

        public ElementDefinitionConstraintComponent setRequirements(String value) {
            if (Utilities.noString((String)value)) {
                this.requirements = null;
            } else {
                if (this.requirements == null) {
                    this.requirements = new StringType();
                }
                this.requirements.setValue(value);
            }
            return this;
        }

        public Enumeration<ConstraintSeverity> getSeverityElement() {
            if (this.severity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.severity");
                }
                if (Configuration.doAutoCreate()) {
                    this.severity = new Enumeration<ConstraintSeverity>(new ConstraintSeverityEnumFactory());
                }
            }
            return this.severity;
        }

        public boolean hasSeverityElement() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public boolean hasSeverity() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public ElementDefinitionConstraintComponent setSeverityElement(Enumeration<ConstraintSeverity> value) {
            this.severity = value;
            return this;
        }

        public ConstraintSeverity getSeverity() {
            return this.severity == null ? null : (ConstraintSeverity)((Object)this.severity.getValue());
        }

        public ElementDefinitionConstraintComponent setSeverity(ConstraintSeverity value) {
            if (this.severity == null) {
                this.severity = new Enumeration<ConstraintSeverity>(new ConstraintSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
            return this;
        }

        public StringType getHumanElement() {
            if (this.human == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.human");
                }
                if (Configuration.doAutoCreate()) {
                    this.human = new StringType();
                }
            }
            return this.human;
        }

        public boolean hasHumanElement() {
            return this.human != null && !this.human.isEmpty();
        }

        public boolean hasHuman() {
            return this.human != null && !this.human.isEmpty();
        }

        public ElementDefinitionConstraintComponent setHumanElement(StringType value) {
            this.human = value;
            return this;
        }

        public String getHuman() {
            return this.human == null ? null : (String)this.human.getValue();
        }

        public ElementDefinitionConstraintComponent setHuman(String value) {
            if (this.human == null) {
                this.human = new StringType();
            }
            this.human.setValue(value);
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public ElementDefinitionConstraintComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public ElementDefinitionConstraintComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        public StringType getXpathElement() {
            if (this.xpath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.xpath");
                }
                if (Configuration.doAutoCreate()) {
                    this.xpath = new StringType();
                }
            }
            return this.xpath;
        }

        public boolean hasXpathElement() {
            return this.xpath != null && !this.xpath.isEmpty();
        }

        public boolean hasXpath() {
            return this.xpath != null && !this.xpath.isEmpty();
        }

        public ElementDefinitionConstraintComponent setXpathElement(StringType value) {
            this.xpath = value;
            return this;
        }

        public String getXpath() {
            return this.xpath == null ? null : (String)this.xpath.getValue();
        }

        public ElementDefinitionConstraintComponent setXpath(String value) {
            if (Utilities.noString((String)value)) {
                this.xpath = null;
            } else {
                if (this.xpath == null) {
                    this.xpath = new StringType();
                }
                this.xpath.setValue(value);
            }
            return this;
        }

        public CanonicalType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new CanonicalType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ElementDefinitionConstraintComponent setSourceElement(CanonicalType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ElementDefinitionConstraintComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new CanonicalType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("key", "id", "Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality.", 0, 1, this.key));
            children.add(new Property("requirements", "string", "Description of why this constraint is necessary or appropriate.", 0, 1, this.requirements));
            children.add(new Property("severity", "code", "Identifies the impact constraint violation has on the conformance of the instance.", 0, 1, this.severity));
            children.add(new Property("human", "string", "Text that can be used to describe the constraint in messages identifying that the constraint has been violated.", 0, 1, this.human));
            children.add(new Property("expression", "string", "A [FHIRPath](fhirpath.html) expression of constraint that can be executed to see if this constraint is met.", 0, 1, this.expression));
            children.add(new Property("xpath", "string", "An XPath expression of constraint that can be executed to see if this constraint is met.", 0, 1, this.xpath));
            children.add(new Property("source", "canonical(StructureDefinition)", "A reference to the original source of the constraint, for traceability purposes.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106079: {
                    return new Property("key", "id", "Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality.", 0, 1, this.key);
                }
                case -1619874672: {
                    return new Property("requirements", "string", "Description of why this constraint is necessary or appropriate.", 0, 1, this.requirements);
                }
                case 1478300413: {
                    return new Property("severity", "code", "Identifies the impact constraint violation has on the conformance of the instance.", 0, 1, this.severity);
                }
                case 99639597: {
                    return new Property("human", "string", "Text that can be used to describe the constraint in messages identifying that the constraint has been violated.", 0, 1, this.human);
                }
                case -1795452264: {
                    return new Property("expression", "string", "A [FHIRPath](fhirpath.html) expression of constraint that can be executed to see if this constraint is met.", 0, 1, this.expression);
                }
                case 114256029: {
                    return new Property("xpath", "string", "An XPath expression of constraint that can be executed to see if this constraint is met.", 0, 1, this.xpath);
                }
                case -896505829: {
                    return new Property("source", "canonical(StructureDefinition)", "A reference to the original source of the constraint, for traceability purposes.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106079: {
                    Base[] baseArray;
                    if (this.key == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.key;
                    }
                    return baseArray;
                }
                case -1619874672: {
                    Base[] baseArray;
                    if (this.requirements == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirements;
                    }
                    return baseArray;
                }
                case 1478300413: {
                    Base[] baseArray;
                    if (this.severity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.severity;
                    }
                    return baseArray;
                }
                case 99639597: {
                    Base[] baseArray;
                    if (this.human == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.human;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.expression;
                    }
                    return baseArray;
                }
                case 114256029: {
                    Base[] baseArray;
                    if (this.xpath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.xpath;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106079: {
                    this.key = this.castToId(value);
                    return value;
                }
                case -1619874672: {
                    this.requirements = this.castToString(value);
                    return value;
                }
                case 1478300413: {
                    value = new ConstraintSeverityEnumFactory().fromType(this.castToCode(value));
                    this.severity = value;
                    return value;
                }
                case 99639597: {
                    this.human = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
                case 114256029: {
                    this.xpath = this.castToString(value);
                    return value;
                }
                case -896505829: {
                    this.source = this.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = this.castToId(value);
            } else if (name.equals("requirements")) {
                this.requirements = this.castToString(value);
            } else if (name.equals("severity")) {
                value = new ConstraintSeverityEnumFactory().fromType(this.castToCode(value));
                this.severity = value;
            } else if (name.equals("human")) {
                this.human = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else if (name.equals("xpath")) {
                this.xpath = this.castToString(value);
            } else if (name.equals("source")) {
                this.source = this.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return this.getKeyElement();
                }
                case -1619874672: {
                    return this.getRequirementsElement();
                }
                case 1478300413: {
                    return this.getSeverityElement();
                }
                case 99639597: {
                    return this.getHumanElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
                case 114256029: {
                    return this.getXpathElement();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return new String[]{"id"};
                }
                case -1619874672: {
                    return new String[]{"string"};
                }
                case 1478300413: {
                    return new String[]{"code"};
                }
                case 99639597: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
                case 114256029: {
                    return new String[]{"string"};
                }
                case -896505829: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.key");
            }
            if (name.equals("requirements")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.requirements");
            }
            if (name.equals("severity")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.severity");
            }
            if (name.equals("human")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.human");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.expression");
            }
            if (name.equals("xpath")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.xpath");
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.source");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionConstraintComponent copy() {
            ElementDefinitionConstraintComponent dst = new ElementDefinitionConstraintComponent();
            this.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.requirements = this.requirements == null ? null : this.requirements.copy();
            dst.severity = this.severity == null ? null : this.severity.copy();
            dst.human = this.human == null ? null : this.human.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            dst.xpath = this.xpath == null ? null : this.xpath.copy();
            dst.source = this.source == null ? null : this.source.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionConstraintComponent)) {
                return false;
            }
            ElementDefinitionConstraintComponent o = (ElementDefinitionConstraintComponent)other_;
            return ElementDefinitionConstraintComponent.compareDeep(this.key, o.key, true) && ElementDefinitionConstraintComponent.compareDeep(this.requirements, o.requirements, true) && ElementDefinitionConstraintComponent.compareDeep(this.severity, o.severity, true) && ElementDefinitionConstraintComponent.compareDeep(this.human, o.human, true) && ElementDefinitionConstraintComponent.compareDeep(this.expression, o.expression, true) && ElementDefinitionConstraintComponent.compareDeep(this.xpath, o.xpath, true) && ElementDefinitionConstraintComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionConstraintComponent)) {
                return false;
            }
            ElementDefinitionConstraintComponent o = (ElementDefinitionConstraintComponent)other_;
            return ElementDefinitionConstraintComponent.compareValues(this.key, o.key, true) && ElementDefinitionConstraintComponent.compareValues(this.requirements, o.requirements, true) && ElementDefinitionConstraintComponent.compareValues(this.severity, o.severity, true) && ElementDefinitionConstraintComponent.compareValues(this.human, o.human, true) && ElementDefinitionConstraintComponent.compareValues(this.expression, o.expression, true) && ElementDefinitionConstraintComponent.compareValues(this.xpath, o.xpath, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.key, this.requirements, this.severity, this.human, this.expression, this.xpath, this.source});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.constraint";
        }
    }

    @Block
    public static class ElementDefinitionExampleComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="label", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Describes the purpose of this example", formalDefinition="Describes the purpose of this example amoung the set of examples.")
        protected StringType label;
        @Child(name="value", type={}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Value of Example (one of allowed types)", formalDefinition="The actual value for the element, which must be one of the types allowed for this element.")
        protected Type value;
        private static final long serialVersionUID = 457572481L;

        public ElementDefinitionExampleComponent() {
        }

        public ElementDefinitionExampleComponent(StringType label, Type value) {
            this.label = label;
            this.value = value;
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionExampleComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public ElementDefinitionExampleComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public ElementDefinitionExampleComponent setLabel(String value) {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ElementDefinitionExampleComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "Describes the purpose of this example amoung the set of examples.", 0, 1, this.label));
            children.add(new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "Describes the purpose of this example amoung the set of examples.", 0, 1, this.label);
                }
                case -1410166417: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "*", "The actual value for the element, which must be one of the types allowed for this element.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = this.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"*"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.label");
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueUuid")) {
                this.value = new UuidType();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueAge")) {
                this.value = new Age();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueCount")) {
                this.value = new Count();
                return this.value;
            }
            if (name.equals("valueDistance")) {
                this.value = new Distance();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueContactDetail")) {
                this.value = new ContactDetail();
                return this.value;
            }
            if (name.equals("valueContributor")) {
                this.value = new Contributor();
                return this.value;
            }
            if (name.equals("valueDataRequirement")) {
                this.value = new DataRequirement();
                return this.value;
            }
            if (name.equals("valueExpression")) {
                this.value = new Expression();
                return this.value;
            }
            if (name.equals("valueParameterDefinition")) {
                this.value = new ParameterDefinition();
                return this.value;
            }
            if (name.equals("valueRelatedArtifact")) {
                this.value = new RelatedArtifact();
                return this.value;
            }
            if (name.equals("valueTriggerDefinition")) {
                this.value = new TriggerDefinition();
                return this.value;
            }
            if (name.equals("valueUsageContext")) {
                this.value = new UsageContext();
                return this.value;
            }
            if (name.equals("valueDosage")) {
                this.value = new Dosage();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionExampleComponent copy() {
            ElementDefinitionExampleComponent dst = new ElementDefinitionExampleComponent();
            this.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionExampleComponent)) {
                return false;
            }
            ElementDefinitionExampleComponent o = (ElementDefinitionExampleComponent)other_;
            return ElementDefinitionExampleComponent.compareDeep(this.label, o.label, true) && ElementDefinitionExampleComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionExampleComponent)) {
                return false;
            }
            ElementDefinitionExampleComponent o = (ElementDefinitionExampleComponent)other_;
            return ElementDefinitionExampleComponent.compareValues(this.label, o.label, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.label, this.value});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.example";
        }
    }

    @Block
    public static class TypeRefComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="code", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Data type or Resource (reference to definition)", formalDefinition="URL of Data type or Resource that is a(or the) type used for this element. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition e.g. \"string\" is a reference to http://hl7.org/fhir/StructureDefinition/string. Absolute URLs are only allowed in logical models.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected UriType code;
        @Child(name="profile", type={CanonicalType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Profiles (StructureDefinition or IG) - one must apply", formalDefinition="Identifies a profile structure or implementation Guide that applies to the datatype this element refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the type SHALL conform to at least one profile defined in the implementation guide.")
        protected List<CanonicalType> profile;
        @Child(name="targetProfile", type={CanonicalType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Profile (StructureDefinition or IG) on the Reference/canonical target - one must apply", formalDefinition="Used when the type is \"Reference\" or \"canonical\", and identifies a profile structure or implementation Guide that applies to the target of the reference this element refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.")
        protected List<CanonicalType> targetProfile;
        @Child(name="aggregation", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="contained | referenced | bundled - how aggregated", formalDefinition="If the type is a reference to another resource, how the resource is or can be aggregated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-aggregation-mode")
        protected List<Enumeration<AggregationMode>> aggregation;
        @Child(name="versioning", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="either | independent | specific", formalDefinition="Whether this reference needs to be version specific or version independent, or whether either can be used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/reference-version-rules")
        protected Enumeration<ReferenceVersionRules> versioning;
        private static final long serialVersionUID = 957891653L;

        public TypeRefComponent() {
        }

        public TypeRefComponent(UriType code) {
            this.code = code;
        }

        public UriType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TypeRefComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new UriType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TypeRefComponent setCodeElement(UriType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TypeRefComponent setCode(String value) {
            if (this.code == null) {
                this.code = new UriType();
            }
            this.code.setValue(value);
            return this;
        }

        public List<CanonicalType> getProfile() {
            if (this.profile == null) {
                this.profile = new ArrayList<CanonicalType>();
            }
            return this.profile;
        }

        public TypeRefComponent setProfile(List<CanonicalType> theProfile) {
            this.profile = theProfile;
            return this;
        }

        public boolean hasProfile() {
            if (this.profile == null) {
                return false;
            }
            for (CanonicalType item : this.profile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.profile == null) {
                this.profile = new ArrayList<CanonicalType>();
            }
            this.profile.add(t);
            return t;
        }

        public TypeRefComponent addProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.profile == null) {
                this.profile = new ArrayList<CanonicalType>();
            }
            this.profile.add(t);
            return this;
        }

        public boolean hasProfile(String value) {
            if (this.profile == null) {
                return false;
            }
            for (CanonicalType v : this.profile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<CanonicalType> getTargetProfile() {
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            return this.targetProfile;
        }

        public TypeRefComponent setTargetProfile(List<CanonicalType> theTargetProfile) {
            this.targetProfile = theTargetProfile;
            return this;
        }

        public boolean hasTargetProfile() {
            if (this.targetProfile == null) {
                return false;
            }
            for (CanonicalType item : this.targetProfile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addTargetProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            this.targetProfile.add(t);
            return t;
        }

        public TypeRefComponent addTargetProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            this.targetProfile.add(t);
            return this;
        }

        public boolean hasTargetProfile(String value) {
            if (this.targetProfile == null) {
                return false;
            }
            for (CanonicalType v : this.targetProfile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Enumeration<AggregationMode>> getAggregation() {
            if (this.aggregation == null) {
                this.aggregation = new ArrayList<Enumeration<AggregationMode>>();
            }
            return this.aggregation;
        }

        public TypeRefComponent setAggregation(List<Enumeration<AggregationMode>> theAggregation) {
            this.aggregation = theAggregation;
            return this;
        }

        public boolean hasAggregation() {
            if (this.aggregation == null) {
                return false;
            }
            for (Enumeration<AggregationMode> item : this.aggregation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<AggregationMode> addAggregationElement() {
            Enumeration<AggregationMode> t = new Enumeration<AggregationMode>(new AggregationModeEnumFactory());
            if (this.aggregation == null) {
                this.aggregation = new ArrayList<Enumeration<AggregationMode>>();
            }
            this.aggregation.add(t);
            return t;
        }

        public TypeRefComponent addAggregation(AggregationMode value) {
            Enumeration<AggregationMode> t = new Enumeration<AggregationMode>(new AggregationModeEnumFactory());
            t.setValue((Object)value);
            if (this.aggregation == null) {
                this.aggregation = new ArrayList<Enumeration<AggregationMode>>();
            }
            this.aggregation.add(t);
            return this;
        }

        public boolean hasAggregation(AggregationMode value) {
            if (this.aggregation == null) {
                return false;
            }
            for (Enumeration<AggregationMode> v : this.aggregation) {
                if (!((AggregationMode)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public Enumeration<ReferenceVersionRules> getVersioningElement() {
            if (this.versioning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TypeRefComponent.versioning");
                }
                if (Configuration.doAutoCreate()) {
                    this.versioning = new Enumeration<ReferenceVersionRules>(new ReferenceVersionRulesEnumFactory());
                }
            }
            return this.versioning;
        }

        public boolean hasVersioningElement() {
            return this.versioning != null && !this.versioning.isEmpty();
        }

        public boolean hasVersioning() {
            return this.versioning != null && !this.versioning.isEmpty();
        }

        public TypeRefComponent setVersioningElement(Enumeration<ReferenceVersionRules> value) {
            this.versioning = value;
            return this;
        }

        public ReferenceVersionRules getVersioning() {
            return this.versioning == null ? null : (ReferenceVersionRules)((Object)this.versioning.getValue());
        }

        public TypeRefComponent setVersioning(ReferenceVersionRules value) {
            if (value == null) {
                this.versioning = null;
            } else {
                if (this.versioning == null) {
                    this.versioning = new Enumeration<ReferenceVersionRules>(new ReferenceVersionRulesEnumFactory());
                }
                this.versioning.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "uri", "URL of Data type or Resource that is a(or the) type used for this element. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition e.g. \"string\" is a reference to http://hl7.org/fhir/StructureDefinition/string. Absolute URLs are only allowed in logical models.", 0, 1, this.code));
            children.add(new Property("profile", "canonical(StructureDefinition|ImplementationGuide)", "Identifies a profile structure or implementation Guide that applies to the datatype this element refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the type SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.profile));
            children.add(new Property("targetProfile", "canonical(StructureDefinition|ImplementationGuide)", "Used when the type is \"Reference\" or \"canonical\", and identifies a profile structure or implementation Guide that applies to the target of the reference this element refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.targetProfile));
            children.add(new Property("aggregation", "code", "If the type is a reference to another resource, how the resource is or can be aggregated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.", 0, Integer.MAX_VALUE, this.aggregation));
            children.add(new Property("versioning", "code", "Whether this reference needs to be version specific or version independent, or whether either can be used.", 0, 1, this.versioning));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "uri", "URL of Data type or Resource that is a(or the) type used for this element. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition e.g. \"string\" is a reference to http://hl7.org/fhir/StructureDefinition/string. Absolute URLs are only allowed in logical models.", 0, 1, this.code);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition|ImplementationGuide)", "Identifies a profile structure or implementation Guide that applies to the datatype this element refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the type SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.profile);
                }
                case 1994521304: {
                    return new Property("targetProfile", "canonical(StructureDefinition|ImplementationGuide)", "Used when the type is \"Reference\" or \"canonical\", and identifies a profile structure or implementation Guide that applies to the target of the reference this element refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.targetProfile);
                }
                case 841524962: {
                    return new Property("aggregation", "code", "If the type is a reference to another resource, how the resource is or can be aggregated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.", 0, Integer.MAX_VALUE, this.aggregation);
                }
                case -670487542: {
                    return new Property("versioning", "code", "Whether this reference needs to be version specific or version independent, or whether either can be used.", 0, 1, this.versioning);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -309425751: {
                    return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
                }
                case 1994521304: {
                    return this.targetProfile == null ? new Base[]{} : this.targetProfile.toArray(new Base[this.targetProfile.size()]);
                }
                case 841524962: {
                    return this.aggregation == null ? new Base[]{} : this.aggregation.toArray(new Base[this.aggregation.size()]);
                }
                case -670487542: {
                    Base[] baseArray;
                    if (this.versioning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.versioning;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToUri(value);
                    return value;
                }
                case -309425751: {
                    this.getProfile().add(this.castToCanonical(value));
                    return value;
                }
                case 1994521304: {
                    this.getTargetProfile().add(this.castToCanonical(value));
                    return value;
                }
                case 841524962: {
                    value = new AggregationModeEnumFactory().fromType(this.castToCode(value));
                    this.getAggregation().add(value);
                    return value;
                }
                case -670487542: {
                    value = new ReferenceVersionRulesEnumFactory().fromType(this.castToCode(value));
                    this.versioning = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToUri(value);
            } else if (name.equals("profile")) {
                this.getProfile().add(this.castToCanonical(value));
            } else if (name.equals("targetProfile")) {
                this.getTargetProfile().add(this.castToCanonical(value));
            } else if (name.equals("aggregation")) {
                value = new AggregationModeEnumFactory().fromType(this.castToCode(value));
                this.getAggregation().add(value);
            } else if (name.equals("versioning")) {
                value = new ReferenceVersionRulesEnumFactory().fromType(this.castToCode(value));
                this.versioning = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -309425751: {
                    return this.addProfileElement();
                }
                case 1994521304: {
                    return this.addTargetProfileElement();
                }
                case 841524962: {
                    return this.addAggregationElement();
                }
                case -670487542: {
                    return this.getVersioningElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"uri"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
                case 1994521304: {
                    return new String[]{"canonical"};
                }
                case 841524962: {
                    return new String[]{"code"};
                }
                case -670487542: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.code");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.profile");
            }
            if (name.equals("targetProfile")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.targetProfile");
            }
            if (name.equals("aggregation")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.aggregation");
            }
            if (name.equals("versioning")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.versioning");
            }
            return super.addChild(name);
        }

        @Override
        public TypeRefComponent copy() {
            TypeRefComponent dst = new TypeRefComponent();
            this.copyValues(dst);
            UriType uriType = dst.code = this.code == null ? null : this.code.copy();
            if (this.profile != null) {
                dst.profile = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.profile) {
                    dst.profile.add(canonicalType.copy());
                }
            }
            if (this.targetProfile != null) {
                dst.targetProfile = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.targetProfile) {
                    dst.targetProfile.add(canonicalType.copy());
                }
            }
            if (this.aggregation != null) {
                dst.aggregation = new ArrayList<Enumeration<AggregationMode>>();
                for (Enumeration enumeration : this.aggregation) {
                    dst.aggregation.add((Enumeration<AggregationMode>)enumeration.copy());
                }
            }
            dst.versioning = this.versioning == null ? null : this.versioning.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TypeRefComponent)) {
                return false;
            }
            TypeRefComponent o = (TypeRefComponent)other_;
            return TypeRefComponent.compareDeep(this.code, o.code, true) && TypeRefComponent.compareDeep(this.profile, o.profile, true) && TypeRefComponent.compareDeep(this.targetProfile, o.targetProfile, true) && TypeRefComponent.compareDeep(this.aggregation, o.aggregation, true) && TypeRefComponent.compareDeep(this.versioning, o.versioning, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TypeRefComponent)) {
                return false;
            }
            TypeRefComponent o = (TypeRefComponent)other_;
            return TypeRefComponent.compareValues(this.code, o.code, true) && TypeRefComponent.compareValues(this.aggregation, o.aggregation, true) && TypeRefComponent.compareValues(this.versioning, o.versioning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.profile, this.targetProfile, this.aggregation, this.versioning});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.type";
        }

        public boolean hasTarget() {
            return Utilities.existsInList((String)this.getCode(), (String[])new String[]{"Reference", "canonical"});
        }

        public String getWorkingCode() {
            if (this.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type")) {
                return this.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
            }
            if (!this.hasCodeElement()) {
                return null;
            }
            if (this.getCodeElement().hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-type")) {
                String s = this.getCodeElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-type");
                if ("xsd:gYear OR xsd:gYearMonth OR xsd:date OR xsd:dateTime".equals(s)) {
                    return "dateTime";
                }
                if ("xsd:gYear OR xsd:gYearMonth OR xsd:date".equals(s)) {
                    return "date";
                }
                if ("xsd:dateTime".equals(s)) {
                    return "instant";
                }
                if ("xsd:token".equals(s)) {
                    return "code";
                }
                if ("xsd:boolean".equals(s)) {
                    return "boolean";
                }
                if ("xsd:string".equals(s)) {
                    return "string";
                }
                if ("xsd:time".equals(s)) {
                    return "time";
                }
                if ("xsd:int".equals(s)) {
                    return "integer";
                }
                if ("xsd:decimal OR xsd:double".equals(s)) {
                    return "decimal";
                }
                if ("xsd:base64Binary".equals(s)) {
                    return "base64Binary";
                }
                if ("xsd:positiveInteger".equals(s)) {
                    return "positiveInt";
                }
                if ("xsd:nonNegativeInteger".equals(s)) {
                    return "unsignedInt";
                }
                if ("xsd:anyURI".equals(s)) {
                    return "uri";
                }
                throw new Error("Unknown xml type '" + s + "'");
            }
            return this.getCode();
        }
    }

    @Block
    public static class ElementDefinitionBaseComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Path that identifies the base element", formalDefinition="The Path that identifies the base element - this matches the ElementDefinition.path for that element. Across FHIR, there is only one base definition of any element - that is, an element definition on a [[[StructureDefinition]]] without a StructureDefinition.base.")
        protected StringType path;
        @Child(name="min", type={UnsignedIntType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Min cardinality of the base element", formalDefinition="Minimum cardinality of the base element identified by the path.")
        protected UnsignedIntType min;
        @Child(name="max", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Max cardinality of the base element", formalDefinition="Maximum cardinality of the base element identified by the path.")
        protected StringType max;
        private static final long serialVersionUID = -1412704221L;

        public ElementDefinitionBaseComponent() {
        }

        public ElementDefinitionBaseComponent(StringType path, UnsignedIntType min, StringType max) {
            this.path = path;
            this.min = min;
            this.max = max;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBaseComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ElementDefinitionBaseComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ElementDefinitionBaseComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public UnsignedIntType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBaseComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new UnsignedIntType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public ElementDefinitionBaseComponent setMinElement(UnsignedIntType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public ElementDefinitionBaseComponent setMin(int value) {
            if (this.min == null) {
                this.min = new UnsignedIntType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBaseComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public ElementDefinitionBaseComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public ElementDefinitionBaseComponent setMax(String value) {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The Path that identifies the base element - this matches the ElementDefinition.path for that element. Across FHIR, there is only one base definition of any element - that is, an element definition on a [[[StructureDefinition]]] without a StructureDefinition.base.", 0, 1, this.path));
            children.add(new Property("min", "unsignedInt", "Minimum cardinality of the base element identified by the path.", 0, 1, this.min));
            children.add(new Property("max", "string", "Maximum cardinality of the base element identified by the path.", 0, 1, this.max));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The Path that identifies the base element - this matches the ElementDefinition.path for that element. Across FHIR, there is only one base definition of any element - that is, an element definition on a [[[StructureDefinition]]] without a StructureDefinition.base.", 0, 1, this.path);
                }
                case 108114: {
                    return new Property("min", "unsignedInt", "Minimum cardinality of the base element identified by the path.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "Maximum cardinality of the base element identified by the path.", 0, 1, this.max);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.max;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case 108114: {
                    this.min = this.castToUnsignedInt(value);
                    return value;
                }
                case 107876: {
                    this.max = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("min")) {
                this.min = this.castToUnsignedInt(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case 108114: {
                    return new String[]{"unsignedInt"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.path");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.max");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionBaseComponent copy() {
            ElementDefinitionBaseComponent dst = new ElementDefinitionBaseComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionBaseComponent)) {
                return false;
            }
            ElementDefinitionBaseComponent o = (ElementDefinitionBaseComponent)other_;
            return ElementDefinitionBaseComponent.compareDeep(this.path, o.path, true) && ElementDefinitionBaseComponent.compareDeep(this.min, o.min, true) && ElementDefinitionBaseComponent.compareDeep(this.max, o.max, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionBaseComponent)) {
                return false;
            }
            ElementDefinitionBaseComponent o = (ElementDefinitionBaseComponent)other_;
            return ElementDefinitionBaseComponent.compareValues(this.path, o.path, true) && ElementDefinitionBaseComponent.compareValues(this.min, o.min, true) && ElementDefinitionBaseComponent.compareValues(this.max, o.max, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.min, this.max});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.base";
        }
    }

    @Block
    public static class ElementDefinitionSlicingDiscriminatorComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="value | exists | pattern | type | profile", formalDefinition="How the element value is interpreted when discrimination is evaluated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/discriminator-type")
        protected Enumeration<DiscriminatorType> type;
        @Child(name="path", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Path to element value", formalDefinition="A FHIRPath expression, using [the simple subset of FHIRPath](fhirpath.html#simple), that is used to identify the element on which discrimination is based.")
        protected StringType path;
        private static final long serialVersionUID = 1151159293L;

        public ElementDefinitionSlicingDiscriminatorComponent() {
        }

        public ElementDefinitionSlicingDiscriminatorComponent(Enumeration<DiscriminatorType> type, StringType path) {
            this.type = type;
            this.path = path;
        }

        public Enumeration<DiscriminatorType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingDiscriminatorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DiscriminatorType>(new DiscriminatorTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ElementDefinitionSlicingDiscriminatorComponent setTypeElement(Enumeration<DiscriminatorType> value) {
            this.type = value;
            return this;
        }

        public DiscriminatorType getType() {
            return this.type == null ? null : (DiscriminatorType)((Object)this.type.getValue());
        }

        public ElementDefinitionSlicingDiscriminatorComponent setType(DiscriminatorType value) {
            if (this.type == null) {
                this.type = new Enumeration<DiscriminatorType>(new DiscriminatorTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingDiscriminatorComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ElementDefinitionSlicingDiscriminatorComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ElementDefinitionSlicingDiscriminatorComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "How the element value is interpreted when discrimination is evaluated.", 0, 1, this.type));
            children.add(new Property("path", "string", "A FHIRPath expression, using [the simple subset of FHIRPath](fhirpath.html#simple), that is used to identify the element on which discrimination is based.", 0, 1, this.path));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "How the element value is interpreted when discrimination is evaluated.", 0, 1, this.type);
                }
                case 3433509: {
                    return new Property("path", "string", "A FHIRPath expression, using [the simple subset of FHIRPath](fhirpath.html#simple), that is used to identify the element on which discrimination is based.", 0, 1, this.path);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.path;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new DiscriminatorTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new DiscriminatorTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.type");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.path");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionSlicingDiscriminatorComponent copy() {
            ElementDefinitionSlicingDiscriminatorComponent dst = new ElementDefinitionSlicingDiscriminatorComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.path = this.path == null ? null : this.path.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionSlicingDiscriminatorComponent)) {
                return false;
            }
            ElementDefinitionSlicingDiscriminatorComponent o = (ElementDefinitionSlicingDiscriminatorComponent)other_;
            return ElementDefinitionSlicingDiscriminatorComponent.compareDeep(this.type, o.type, true) && ElementDefinitionSlicingDiscriminatorComponent.compareDeep(this.path, o.path, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionSlicingDiscriminatorComponent)) {
                return false;
            }
            ElementDefinitionSlicingDiscriminatorComponent o = (ElementDefinitionSlicingDiscriminatorComponent)other_;
            return ElementDefinitionSlicingDiscriminatorComponent.compareValues(this.type, o.type, true) && ElementDefinitionSlicingDiscriminatorComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.path});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.slicing.discriminator";
        }
    }

    @Block
    public static class ElementDefinitionSlicingComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="discriminator", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Element values that are used to distinguish the slices", formalDefinition="Designates which child elements are used to discriminate between the slices when processing an instance. If one or more discriminators are provided, the value of the child elements in the instance data SHALL completely distinguish which slice the element in the resource matches based on the allowed values for those elements in each of the slices.")
        protected List<ElementDefinitionSlicingDiscriminatorComponent> discriminator;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text description of how slicing works (or not)", formalDefinition="A human-readable text description of how the slicing works. If there is no discriminator, this is required to be present to provide whatever information is possible about how the slices can be differentiated.")
        protected StringType description;
        @Child(name="ordered", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If elements must be in same order as slices", formalDefinition="If the matching elements have to occur in the same order as defined in the profile.")
        protected BooleanType ordered;
        @Child(name="rules", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="closed | open | openAtEnd", formalDefinition="Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-slicing-rules")
        protected Enumeration<SlicingRules> rules;
        private static final long serialVersionUID = -311635839L;

        public ElementDefinitionSlicingComponent() {
        }

        public ElementDefinitionSlicingComponent(Enumeration<SlicingRules> rules) {
            this.rules = rules;
        }

        public List<ElementDefinitionSlicingDiscriminatorComponent> getDiscriminator() {
            if (this.discriminator == null) {
                this.discriminator = new ArrayList<ElementDefinitionSlicingDiscriminatorComponent>();
            }
            return this.discriminator;
        }

        public ElementDefinitionSlicingComponent setDiscriminator(List<ElementDefinitionSlicingDiscriminatorComponent> theDiscriminator) {
            this.discriminator = theDiscriminator;
            return this;
        }

        public boolean hasDiscriminator() {
            if (this.discriminator == null) {
                return false;
            }
            for (ElementDefinitionSlicingDiscriminatorComponent item : this.discriminator) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ElementDefinitionSlicingDiscriminatorComponent addDiscriminator() {
            ElementDefinitionSlicingDiscriminatorComponent t = new ElementDefinitionSlicingDiscriminatorComponent();
            if (this.discriminator == null) {
                this.discriminator = new ArrayList<ElementDefinitionSlicingDiscriminatorComponent>();
            }
            this.discriminator.add(t);
            return t;
        }

        public ElementDefinitionSlicingComponent addDiscriminator(ElementDefinitionSlicingDiscriminatorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.discriminator == null) {
                this.discriminator = new ArrayList<ElementDefinitionSlicingDiscriminatorComponent>();
            }
            this.discriminator.add(t);
            return this;
        }

        public ElementDefinitionSlicingDiscriminatorComponent getDiscriminatorFirstRep() {
            if (this.getDiscriminator().isEmpty()) {
                this.addDiscriminator();
            }
            return this.getDiscriminator().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ElementDefinitionSlicingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ElementDefinitionSlicingComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public BooleanType getOrderedElement() {
            if (this.ordered == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingComponent.ordered");
                }
                if (Configuration.doAutoCreate()) {
                    this.ordered = new BooleanType();
                }
            }
            return this.ordered;
        }

        public boolean hasOrderedElement() {
            return this.ordered != null && !this.ordered.isEmpty();
        }

        public boolean hasOrdered() {
            return this.ordered != null && !this.ordered.isEmpty();
        }

        public ElementDefinitionSlicingComponent setOrderedElement(BooleanType value) {
            this.ordered = value;
            return this;
        }

        public boolean getOrdered() {
            return this.ordered == null || this.ordered.isEmpty() ? false : (Boolean)this.ordered.getValue();
        }

        public ElementDefinitionSlicingComponent setOrdered(boolean value) {
            if (this.ordered == null) {
                this.ordered = new BooleanType();
            }
            this.ordered.setValue((Object)value);
            return this;
        }

        public Enumeration<SlicingRules> getRulesElement() {
            if (this.rules == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingComponent.rules");
                }
                if (Configuration.doAutoCreate()) {
                    this.rules = new Enumeration<SlicingRules>(new SlicingRulesEnumFactory());
                }
            }
            return this.rules;
        }

        public boolean hasRulesElement() {
            return this.rules != null && !this.rules.isEmpty();
        }

        public boolean hasRules() {
            return this.rules != null && !this.rules.isEmpty();
        }

        public ElementDefinitionSlicingComponent setRulesElement(Enumeration<SlicingRules> value) {
            this.rules = value;
            return this;
        }

        public SlicingRules getRules() {
            return this.rules == null ? null : (SlicingRules)((Object)this.rules.getValue());
        }

        public ElementDefinitionSlicingComponent setRules(SlicingRules value) {
            if (this.rules == null) {
                this.rules = new Enumeration<SlicingRules>(new SlicingRulesEnumFactory());
            }
            this.rules.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("discriminator", "", "Designates which child elements are used to discriminate between the slices when processing an instance. If one or more discriminators are provided, the value of the child elements in the instance data SHALL completely distinguish which slice the element in the resource matches based on the allowed values for those elements in each of the slices.", 0, Integer.MAX_VALUE, this.discriminator));
            children.add(new Property("description", "string", "A human-readable text description of how the slicing works. If there is no discriminator, this is required to be present to provide whatever information is possible about how the slices can be differentiated.", 0, 1, this.description));
            children.add(new Property("ordered", "boolean", "If the matching elements have to occur in the same order as defined in the profile.", 0, 1, this.ordered));
            children.add(new Property("rules", "code", "Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end.", 0, 1, this.rules));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1888270692: {
                    return new Property("discriminator", "", "Designates which child elements are used to discriminate between the slices when processing an instance. If one or more discriminators are provided, the value of the child elements in the instance data SHALL completely distinguish which slice the element in the resource matches based on the allowed values for those elements in each of the slices.", 0, Integer.MAX_VALUE, this.discriminator);
                }
                case -1724546052: {
                    return new Property("description", "string", "A human-readable text description of how the slicing works. If there is no discriminator, this is required to be present to provide whatever information is possible about how the slices can be differentiated.", 0, 1, this.description);
                }
                case -1207109523: {
                    return new Property("ordered", "boolean", "If the matching elements have to occur in the same order as defined in the profile.", 0, 1, this.ordered);
                }
                case 108873975: {
                    return new Property("rules", "code", "Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end.", 0, 1, this.rules);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1888270692: {
                    return this.discriminator == null ? new Base[]{} : this.discriminator.toArray(new Base[this.discriminator.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1207109523: {
                    Base[] baseArray;
                    if (this.ordered == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.ordered;
                    }
                    return baseArray;
                }
                case 108873975: {
                    Base[] baseArray;
                    if (this.rules == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rules;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1888270692: {
                    this.getDiscriminator().add((ElementDefinitionSlicingDiscriminatorComponent)((Object)value));
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1207109523: {
                    this.ordered = this.castToBoolean(value);
                    return value;
                }
                case 108873975: {
                    value = new SlicingRulesEnumFactory().fromType(this.castToCode(value));
                    this.rules = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("discriminator")) {
                this.getDiscriminator().add((ElementDefinitionSlicingDiscriminatorComponent)((Object)value));
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("ordered")) {
                this.ordered = this.castToBoolean(value);
            } else if (name.equals("rules")) {
                value = new SlicingRulesEnumFactory().fromType(this.castToCode(value));
                this.rules = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1888270692: {
                    return this.addDiscriminator();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1207109523: {
                    return this.getOrderedElement();
                }
                case 108873975: {
                    return this.getRulesElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1888270692: {
                    return new String[0];
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1207109523: {
                    return new String[]{"boolean"};
                }
                case 108873975: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("discriminator")) {
                return this.addDiscriminator();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.description");
            }
            if (name.equals("ordered")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.ordered");
            }
            if (name.equals("rules")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.rules");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionSlicingComponent copy() {
            ElementDefinitionSlicingComponent dst = new ElementDefinitionSlicingComponent();
            this.copyValues(dst);
            if (this.discriminator != null) {
                dst.discriminator = new ArrayList<ElementDefinitionSlicingDiscriminatorComponent>();
                for (ElementDefinitionSlicingDiscriminatorComponent i : this.discriminator) {
                    dst.discriminator.add(i.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.ordered = this.ordered == null ? null : this.ordered.copy();
            dst.rules = this.rules == null ? null : this.rules.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionSlicingComponent)) {
                return false;
            }
            ElementDefinitionSlicingComponent o = (ElementDefinitionSlicingComponent)other_;
            return ElementDefinitionSlicingComponent.compareDeep(this.discriminator, o.discriminator, true) && ElementDefinitionSlicingComponent.compareDeep(this.description, o.description, true) && ElementDefinitionSlicingComponent.compareDeep(this.ordered, o.ordered, true) && ElementDefinitionSlicingComponent.compareDeep(this.rules, o.rules, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ElementDefinitionSlicingComponent)) {
                return false;
            }
            ElementDefinitionSlicingComponent o = (ElementDefinitionSlicingComponent)other_;
            return ElementDefinitionSlicingComponent.compareValues(this.description, o.description, true) && ElementDefinitionSlicingComponent.compareValues(this.ordered, o.ordered, true) && ElementDefinitionSlicingComponent.compareValues(this.rules, o.rules, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.discriminator, this.description, this.ordered, this.rules});
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.slicing";
        }
    }

    public static class ConstraintSeverityEnumFactory
    implements EnumFactory<ConstraintSeverity> {
        @Override
        public ConstraintSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("error".equals(codeString)) {
                return ConstraintSeverity.ERROR;
            }
            if ("warning".equals(codeString)) {
                return ConstraintSeverity.WARNING;
            }
            throw new IllegalArgumentException("Unknown ConstraintSeverity code '" + codeString + "'");
        }

        public Enumeration<ConstraintSeverity> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConstraintSeverity>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return new Enumeration<ConstraintSeverity>(this, ConstraintSeverity.ERROR);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<ConstraintSeverity>(this, ConstraintSeverity.WARNING);
            }
            throw new FHIRException("Unknown ConstraintSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(ConstraintSeverity code) {
            if (code == ConstraintSeverity.ERROR) {
                return "error";
            }
            if (code == ConstraintSeverity.WARNING) {
                return "warning";
            }
            return "?";
        }

        @Override
        public String toSystem(ConstraintSeverity code) {
            return code.getSystem();
        }
    }

    public static enum ConstraintSeverity {
        ERROR,
        WARNING,
        NULL;


        public static ConstraintSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConstraintSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ERROR: {
                    return "http://hl7.org/fhir/constraint-severity";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/constraint-severity";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ERROR: {
                    return "If the constraint is violated, the resource is not conformant.";
                }
                case WARNING: {
                    return "If the constraint is violated, the resource is conformant, but it is not necessarily following best practice.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ERROR: {
                    return "Error";
                }
                case WARNING: {
                    return "Warning";
                }
            }
            return "?";
        }
    }

    public static class ReferenceVersionRulesEnumFactory
    implements EnumFactory<ReferenceVersionRules> {
        @Override
        public ReferenceVersionRules fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("either".equals(codeString)) {
                return ReferenceVersionRules.EITHER;
            }
            if ("independent".equals(codeString)) {
                return ReferenceVersionRules.INDEPENDENT;
            }
            if ("specific".equals(codeString)) {
                return ReferenceVersionRules.SPECIFIC;
            }
            throw new IllegalArgumentException("Unknown ReferenceVersionRules code '" + codeString + "'");
        }

        public Enumeration<ReferenceVersionRules> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReferenceVersionRules>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("either".equals(codeString)) {
                return new Enumeration<ReferenceVersionRules>(this, ReferenceVersionRules.EITHER);
            }
            if ("independent".equals(codeString)) {
                return new Enumeration<ReferenceVersionRules>(this, ReferenceVersionRules.INDEPENDENT);
            }
            if ("specific".equals(codeString)) {
                return new Enumeration<ReferenceVersionRules>(this, ReferenceVersionRules.SPECIFIC);
            }
            throw new FHIRException("Unknown ReferenceVersionRules code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferenceVersionRules code) {
            if (code == ReferenceVersionRules.EITHER) {
                return "either";
            }
            if (code == ReferenceVersionRules.INDEPENDENT) {
                return "independent";
            }
            if (code == ReferenceVersionRules.SPECIFIC) {
                return "specific";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferenceVersionRules code) {
            return code.getSystem();
        }
    }

    public static enum ReferenceVersionRules {
        EITHER,
        INDEPENDENT,
        SPECIFIC,
        NULL;


        public static ReferenceVersionRules fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("either".equals(codeString)) {
                return EITHER;
            }
            if ("independent".equals(codeString)) {
                return INDEPENDENT;
            }
            if ("specific".equals(codeString)) {
                return SPECIFIC;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReferenceVersionRules code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EITHER: {
                    return "either";
                }
                case INDEPENDENT: {
                    return "independent";
                }
                case SPECIFIC: {
                    return "specific";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EITHER: {
                    return "http://hl7.org/fhir/reference-version-rules";
                }
                case INDEPENDENT: {
                    return "http://hl7.org/fhir/reference-version-rules";
                }
                case SPECIFIC: {
                    return "http://hl7.org/fhir/reference-version-rules";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EITHER: {
                    return "The reference may be either version independent or version specific.";
                }
                case INDEPENDENT: {
                    return "The reference must be version independent.";
                }
                case SPECIFIC: {
                    return "The reference must be version specific.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EITHER: {
                    return "Either Specific or independent";
                }
                case INDEPENDENT: {
                    return "Version independent";
                }
                case SPECIFIC: {
                    return "Version Specific";
                }
            }
            return "?";
        }
    }

    public static class AggregationModeEnumFactory
    implements EnumFactory<AggregationMode> {
        @Override
        public AggregationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("contained".equals(codeString)) {
                return AggregationMode.CONTAINED;
            }
            if ("referenced".equals(codeString)) {
                return AggregationMode.REFERENCED;
            }
            if ("bundled".equals(codeString)) {
                return AggregationMode.BUNDLED;
            }
            throw new IllegalArgumentException("Unknown AggregationMode code '" + codeString + "'");
        }

        public Enumeration<AggregationMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AggregationMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("contained".equals(codeString)) {
                return new Enumeration<AggregationMode>(this, AggregationMode.CONTAINED);
            }
            if ("referenced".equals(codeString)) {
                return new Enumeration<AggregationMode>(this, AggregationMode.REFERENCED);
            }
            if ("bundled".equals(codeString)) {
                return new Enumeration<AggregationMode>(this, AggregationMode.BUNDLED);
            }
            throw new FHIRException("Unknown AggregationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(AggregationMode code) {
            if (code == AggregationMode.CONTAINED) {
                return "contained";
            }
            if (code == AggregationMode.REFERENCED) {
                return "referenced";
            }
            if (code == AggregationMode.BUNDLED) {
                return "bundled";
            }
            return "?";
        }

        @Override
        public String toSystem(AggregationMode code) {
            return code.getSystem();
        }
    }

    public static enum AggregationMode {
        CONTAINED,
        REFERENCED,
        BUNDLED,
        NULL;


        public static AggregationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("contained".equals(codeString)) {
                return CONTAINED;
            }
            if ("referenced".equals(codeString)) {
                return REFERENCED;
            }
            if ("bundled".equals(codeString)) {
                return BUNDLED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AggregationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CONTAINED: {
                    return "contained";
                }
                case REFERENCED: {
                    return "referenced";
                }
                case BUNDLED: {
                    return "bundled";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CONTAINED: {
                    return "http://hl7.org/fhir/resource-aggregation-mode";
                }
                case REFERENCED: {
                    return "http://hl7.org/fhir/resource-aggregation-mode";
                }
                case BUNDLED: {
                    return "http://hl7.org/fhir/resource-aggregation-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CONTAINED: {
                    return "The reference is a local reference to a contained resource.";
                }
                case REFERENCED: {
                    return "The reference to a resource that has to be resolved externally to the resource that includes the reference.";
                }
                case BUNDLED: {
                    return "The resource the reference points to will be found in the same bundle as the resource that includes the reference.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CONTAINED: {
                    return "Contained";
                }
                case REFERENCED: {
                    return "Referenced";
                }
                case BUNDLED: {
                    return "Bundled";
                }
            }
            return "?";
        }
    }

    public static class SlicingRulesEnumFactory
    implements EnumFactory<SlicingRules> {
        @Override
        public SlicingRules fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("closed".equals(codeString)) {
                return SlicingRules.CLOSED;
            }
            if ("open".equals(codeString)) {
                return SlicingRules.OPEN;
            }
            if ("openAtEnd".equals(codeString)) {
                return SlicingRules.OPENATEND;
            }
            throw new IllegalArgumentException("Unknown SlicingRules code '" + codeString + "'");
        }

        public Enumeration<SlicingRules> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SlicingRules>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("closed".equals(codeString)) {
                return new Enumeration<SlicingRules>(this, SlicingRules.CLOSED);
            }
            if ("open".equals(codeString)) {
                return new Enumeration<SlicingRules>(this, SlicingRules.OPEN);
            }
            if ("openAtEnd".equals(codeString)) {
                return new Enumeration<SlicingRules>(this, SlicingRules.OPENATEND);
            }
            throw new FHIRException("Unknown SlicingRules code '" + codeString + "'");
        }

        @Override
        public String toCode(SlicingRules code) {
            if (code == SlicingRules.CLOSED) {
                return "closed";
            }
            if (code == SlicingRules.OPEN) {
                return "open";
            }
            if (code == SlicingRules.OPENATEND) {
                return "openAtEnd";
            }
            return "?";
        }

        @Override
        public String toSystem(SlicingRules code) {
            return code.getSystem();
        }
    }

    public static enum SlicingRules {
        CLOSED,
        OPEN,
        OPENATEND,
        NULL;


        public static SlicingRules fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("closed".equals(codeString)) {
                return CLOSED;
            }
            if ("open".equals(codeString)) {
                return OPEN;
            }
            if ("openAtEnd".equals(codeString)) {
                return OPENATEND;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SlicingRules code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLOSED: {
                    return "closed";
                }
                case OPEN: {
                    return "open";
                }
                case OPENATEND: {
                    return "openAtEnd";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLOSED: {
                    return "http://hl7.org/fhir/resource-slicing-rules";
                }
                case OPEN: {
                    return "http://hl7.org/fhir/resource-slicing-rules";
                }
                case OPENATEND: {
                    return "http://hl7.org/fhir/resource-slicing-rules";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLOSED: {
                    return "No additional content is allowed other than that described by the slices in this profile.";
                }
                case OPEN: {
                    return "Additional content is allowed anywhere in the list.";
                }
                case OPENATEND: {
                    return "Additional content is allowed, but only at the end of the list. Note that using this requires that the slices be ordered, which makes it hard to share uses. This should only be done where absolutely required.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLOSED: {
                    return "Closed";
                }
                case OPEN: {
                    return "Open";
                }
                case OPENATEND: {
                    return "Open at End";
                }
            }
            return "?";
        }
    }

    public static class DiscriminatorTypeEnumFactory
    implements EnumFactory<DiscriminatorType> {
        @Override
        public DiscriminatorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("value".equals(codeString)) {
                return DiscriminatorType.VALUE;
            }
            if ("exists".equals(codeString)) {
                return DiscriminatorType.EXISTS;
            }
            if ("pattern".equals(codeString)) {
                return DiscriminatorType.PATTERN;
            }
            if ("type".equals(codeString)) {
                return DiscriminatorType.TYPE;
            }
            if ("profile".equals(codeString)) {
                return DiscriminatorType.PROFILE;
            }
            throw new IllegalArgumentException("Unknown DiscriminatorType code '" + codeString + "'");
        }

        public Enumeration<DiscriminatorType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DiscriminatorType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("value".equals(codeString)) {
                return new Enumeration<DiscriminatorType>(this, DiscriminatorType.VALUE);
            }
            if ("exists".equals(codeString)) {
                return new Enumeration<DiscriminatorType>(this, DiscriminatorType.EXISTS);
            }
            if ("pattern".equals(codeString)) {
                return new Enumeration<DiscriminatorType>(this, DiscriminatorType.PATTERN);
            }
            if ("type".equals(codeString)) {
                return new Enumeration<DiscriminatorType>(this, DiscriminatorType.TYPE);
            }
            if ("profile".equals(codeString)) {
                return new Enumeration<DiscriminatorType>(this, DiscriminatorType.PROFILE);
            }
            throw new FHIRException("Unknown DiscriminatorType code '" + codeString + "'");
        }

        @Override
        public String toCode(DiscriminatorType code) {
            if (code == DiscriminatorType.VALUE) {
                return "value";
            }
            if (code == DiscriminatorType.EXISTS) {
                return "exists";
            }
            if (code == DiscriminatorType.PATTERN) {
                return "pattern";
            }
            if (code == DiscriminatorType.TYPE) {
                return "type";
            }
            if (code == DiscriminatorType.PROFILE) {
                return "profile";
            }
            return "?";
        }

        @Override
        public String toSystem(DiscriminatorType code) {
            return code.getSystem();
        }
    }

    public static enum DiscriminatorType {
        VALUE,
        EXISTS,
        PATTERN,
        TYPE,
        PROFILE,
        NULL;


        public static DiscriminatorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("value".equals(codeString)) {
                return VALUE;
            }
            if ("exists".equals(codeString)) {
                return EXISTS;
            }
            if ("pattern".equals(codeString)) {
                return PATTERN;
            }
            if ("type".equals(codeString)) {
                return TYPE;
            }
            if ("profile".equals(codeString)) {
                return PROFILE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DiscriminatorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case VALUE: {
                    return "value";
                }
                case EXISTS: {
                    return "exists";
                }
                case PATTERN: {
                    return "pattern";
                }
                case TYPE: {
                    return "type";
                }
                case PROFILE: {
                    return "profile";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case VALUE: {
                    return "http://hl7.org/fhir/discriminator-type";
                }
                case EXISTS: {
                    return "http://hl7.org/fhir/discriminator-type";
                }
                case PATTERN: {
                    return "http://hl7.org/fhir/discriminator-type";
                }
                case TYPE: {
                    return "http://hl7.org/fhir/discriminator-type";
                }
                case PROFILE: {
                    return "http://hl7.org/fhir/discriminator-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case VALUE: {
                    return "The slices have different values in the nominated element.";
                }
                case EXISTS: {
                    return "The slices are differentiated by the presence or absence of the nominated element.";
                }
                case PATTERN: {
                    return "The slices have different values in the nominated element, as determined by testing them against the applicable ElementDefinition.pattern[x].";
                }
                case TYPE: {
                    return "The slices are differentiated by type of the nominated element.";
                }
                case PROFILE: {
                    return "The slices are differentiated by conformance of the nominated element to a specified profile. Note that if the path specifies .resolve() then the profile is the target profile on the reference. In this case, validation by the possible profiles is required to differentiate the slices.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case VALUE: {
                    return "Value";
                }
                case EXISTS: {
                    return "Exists";
                }
                case PATTERN: {
                    return "Pattern";
                }
                case TYPE: {
                    return "Type";
                }
                case PROFILE: {
                    return "Profile";
                }
            }
            return "?";
        }
    }

    public static class PropertyRepresentationEnumFactory
    implements EnumFactory<PropertyRepresentation> {
        @Override
        public PropertyRepresentation fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("xmlAttr".equals(codeString)) {
                return PropertyRepresentation.XMLATTR;
            }
            if ("xmlText".equals(codeString)) {
                return PropertyRepresentation.XMLTEXT;
            }
            if ("typeAttr".equals(codeString)) {
                return PropertyRepresentation.TYPEATTR;
            }
            if ("cdaText".equals(codeString)) {
                return PropertyRepresentation.CDATEXT;
            }
            if ("xhtml".equals(codeString)) {
                return PropertyRepresentation.XHTML;
            }
            throw new IllegalArgumentException("Unknown PropertyRepresentation code '" + codeString + "'");
        }

        public Enumeration<PropertyRepresentation> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PropertyRepresentation>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("xmlAttr".equals(codeString)) {
                return new Enumeration<PropertyRepresentation>(this, PropertyRepresentation.XMLATTR);
            }
            if ("xmlText".equals(codeString)) {
                return new Enumeration<PropertyRepresentation>(this, PropertyRepresentation.XMLTEXT);
            }
            if ("typeAttr".equals(codeString)) {
                return new Enumeration<PropertyRepresentation>(this, PropertyRepresentation.TYPEATTR);
            }
            if ("cdaText".equals(codeString)) {
                return new Enumeration<PropertyRepresentation>(this, PropertyRepresentation.CDATEXT);
            }
            if ("xhtml".equals(codeString)) {
                return new Enumeration<PropertyRepresentation>(this, PropertyRepresentation.XHTML);
            }
            throw new FHIRException("Unknown PropertyRepresentation code '" + codeString + "'");
        }

        @Override
        public String toCode(PropertyRepresentation code) {
            if (code == PropertyRepresentation.XMLATTR) {
                return "xmlAttr";
            }
            if (code == PropertyRepresentation.XMLTEXT) {
                return "xmlText";
            }
            if (code == PropertyRepresentation.TYPEATTR) {
                return "typeAttr";
            }
            if (code == PropertyRepresentation.CDATEXT) {
                return "cdaText";
            }
            if (code == PropertyRepresentation.XHTML) {
                return "xhtml";
            }
            return "?";
        }

        @Override
        public String toSystem(PropertyRepresentation code) {
            return code.getSystem();
        }
    }

    public static enum PropertyRepresentation {
        XMLATTR,
        XMLTEXT,
        TYPEATTR,
        CDATEXT,
        XHTML,
        NULL;


        public static PropertyRepresentation fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("xmlAttr".equals(codeString)) {
                return XMLATTR;
            }
            if ("xmlText".equals(codeString)) {
                return XMLTEXT;
            }
            if ("typeAttr".equals(codeString)) {
                return TYPEATTR;
            }
            if ("cdaText".equals(codeString)) {
                return CDATEXT;
            }
            if ("xhtml".equals(codeString)) {
                return XHTML;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PropertyRepresentation code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case XMLATTR: {
                    return "xmlAttr";
                }
                case XMLTEXT: {
                    return "xmlText";
                }
                case TYPEATTR: {
                    return "typeAttr";
                }
                case CDATEXT: {
                    return "cdaText";
                }
                case XHTML: {
                    return "xhtml";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case XMLATTR: {
                    return "http://hl7.org/fhir/property-representation";
                }
                case XMLTEXT: {
                    return "http://hl7.org/fhir/property-representation";
                }
                case TYPEATTR: {
                    return "http://hl7.org/fhir/property-representation";
                }
                case CDATEXT: {
                    return "http://hl7.org/fhir/property-representation";
                }
                case XHTML: {
                    return "http://hl7.org/fhir/property-representation";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case XMLATTR: {
                    return "In XML, this property is represented as an attribute not an element.";
                }
                case XMLTEXT: {
                    return "This element is represented using the XML text attribute (primitives only).";
                }
                case TYPEATTR: {
                    return "The type of this element is indicated using xsi:type.";
                }
                case CDATEXT: {
                    return "Use CDA narrative instead of XHTML.";
                }
                case XHTML: {
                    return "The property is represented using XHTML.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case XMLATTR: {
                    return "XML Attribute";
                }
                case XMLTEXT: {
                    return "XML Text";
                }
                case TYPEATTR: {
                    return "Type Attribute";
                }
                case CDATEXT: {
                    return "CDA Text Format";
                }
                case XHTML: {
                    return "XHTML";
                }
            }
            return "?";
        }
    }
}

