package org.hl7.fhir.r4.model.codesystems;

/*-
 * #%L
 * org.hl7.fhir.r4
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0


import org.hl7.fhir.exceptions.FHIRException;

public enum SpdxLicense {

        /**
         * Not an open source license.
         */
        NOTOPENSOURCE, 
        /**
         * BSD Zero Clause License.
         */
        _0BSD, 
        /**
         * Attribution Assurance License.
         */
        AAL, 
        /**
         * Abstyles License.
         */
        ABSTYLES, 
        /**
         * Adobe Systems Incorporated Source Code License Agreement.
         */
        ADOBE2006, 
        /**
         * Adobe Glyph List License.
         */
        ADOBEGLYPH, 
        /**
         * Amazon Digital Services License.
         */
        ADSL, 
        /**
         * Academic Free License v1.1.
         */
        AFL1_1, 
        /**
         * Academic Free License v1.2.
         */
        AFL1_2, 
        /**
         * Academic Free License v2.0.
         */
        AFL2_0, 
        /**
         * Academic Free License v2.1.
         */
        AFL2_1, 
        /**
         * Academic Free License v3.0.
         */
        AFL3_0, 
        /**
         * Afmparse License.
         */
        AFMPARSE, 
        /**
         * Affero General Public License v1.0 only.
         */
        AGPL1_0ONLY, 
        /**
         * Affero General Public License v1.0 or later.
         */
        AGPL1_0ORLATER, 
        /**
         * GNU Affero General Public License v3.0 only.
         */
        AGPL3_0ONLY, 
        /**
         * GNU Affero General Public License v3.0 or later.
         */
        AGPL3_0ORLATER, 
        /**
         * Aladdin Free Public License.
         */
        ALADDIN, 
        /**
         * AMD's plpa_map.c License.
         */
        AMDPLPA, 
        /**
         * Apple MIT License.
         */
        AML, 
        /**
         * Academy of Motion Picture Arts and Sciences BSD.
         */
        AMPAS, 
        /**
         * ANTLR Software Rights Notice.
         */
        ANTLRPD, 
        /**
         * Apache License 1.0.
         */
        APACHE1_0, 
        /**
         * Apache License 1.1.
         */
        APACHE1_1, 
        /**
         * Apache License 2.0.
         */
        APACHE2_0, 
        /**
         * Adobe Postscript AFM License.
         */
        APAFML, 
        /**
         * Adaptive Public License 1.0.
         */
        APL1_0, 
        /**
         * Apple Public Source License 1.0.
         */
        APSL1_0, 
        /**
         * Apple Public Source License 1.1.
         */
        APSL1_1, 
        /**
         * Apple Public Source License 1.2.
         */
        APSL1_2, 
        /**
         * Apple Public Source License 2.0.
         */
        APSL2_0, 
        /**
         * Artistic License 1.0 w/clause 8.
         */
        ARTISTIC1_0CL8, 
        /**
         * Artistic License 1.0 (Perl).
         */
        ARTISTIC1_0PERL, 
        /**
         * Artistic License 1.0.
         */
        ARTISTIC1_0, 
        /**
         * Artistic License 2.0.
         */
        ARTISTIC2_0, 
        /**
         * Bahyph License.
         */
        BAHYPH, 
        /**
         * Barr License.
         */
        BARR, 
        /**
         * Beerware License.
         */
        BEERWARE, 
        /**
         * BitTorrent Open Source License v1.0.
         */
        BITTORRENT1_0, 
        /**
         * BitTorrent Open Source License v1.1.
         */
        BITTORRENT1_1, 
        /**
         * Borceux license.
         */
        BORCEUX, 
        /**
         * BSD 1-Clause License.
         */
        BSD1CLAUSE, 
        /**
         * BSD 2-Clause FreeBSD License.
         */
        BSD2CLAUSEFREEBSD, 
        /**
         * BSD 2-Clause NetBSD License.
         */
        BSD2CLAUSENETBSD, 
        /**
         * BSD-2-Clause Plus Patent License.
         */
        BSD2CLAUSEPATENT, 
        /**
         * BSD 2-Clause "Simplified" License.
         */
        BSD2CLAUSE, 
        /**
         * BSD with attribution.
         */
        BSD3CLAUSEATTRIBUTION, 
        /**
         * BSD 3-Clause Clear License.
         */
        BSD3CLAUSECLEAR, 
        /**
         * Lawrence Berkeley National Labs BSD variant license.
         */
        BSD3CLAUSELBNL, 
        /**
         * BSD 3-Clause No Nuclear License 2014.
         */
        BSD3CLAUSENONUCLEARLICENSE2014, 
        /**
         * BSD 3-Clause No Nuclear License.
         */
        BSD3CLAUSENONUCLEARLICENSE, 
        /**
         * BSD 3-Clause No Nuclear Warranty.
         */
        BSD3CLAUSENONUCLEARWARRANTY, 
        /**
         * BSD 3-Clause "New" or "Revised" License.
         */
        BSD3CLAUSE, 
        /**
         * BSD-4-Clause (University of California-Specific).
         */
        BSD4CLAUSEUC, 
        /**
         * BSD 4-Clause "Original" or "Old" License.
         */
        BSD4CLAUSE, 
        /**
         * BSD Protection License.
         */
        BSDPROTECTION, 
        /**
         * BSD Source Code Attribution.
         */
        BSDSOURCECODE, 
        /**
         * Boost Software License 1.0.
         */
        BSL1_0, 
        /**
         * bzip2 and libbzip2 License v1.0.5.
         */
        BZIP21_0_5, 
        /**
         * bzip2 and libbzip2 License v1.0.6.
         */
        BZIP21_0_6, 
        /**
         * Caldera License.
         */
        CALDERA, 
        /**
         * Computer Associates Trusted Open Source License 1.1.
         */
        CATOSL1_1, 
        /**
         * Creative Commons Attribution 1.0 Generic.
         */
        CCBY1_0, 
        /**
         * Creative Commons Attribution 2.0 Generic.
         */
        CCBY2_0, 
        /**
         * Creative Commons Attribution 2.5 Generic.
         */
        CCBY2_5, 
        /**
         * Creative Commons Attribution 3.0 Unported.
         */
        CCBY3_0, 
        /**
         * Creative Commons Attribution 4.0 International.
         */
        CCBY4_0, 
        /**
         * Creative Commons Attribution Non Commercial 1.0 Generic.
         */
        CCBYNC1_0, 
        /**
         * Creative Commons Attribution Non Commercial 2.0 Generic.
         */
        CCBYNC2_0, 
        /**
         * Creative Commons Attribution Non Commercial 2.5 Generic.
         */
        CCBYNC2_5, 
        /**
         * Creative Commons Attribution Non Commercial 3.0 Unported.
         */
        CCBYNC3_0, 
        /**
         * Creative Commons Attribution Non Commercial 4.0 International.
         */
        CCBYNC4_0, 
        /**
         * Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic.
         */
        CCBYNCND1_0, 
        /**
         * Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic.
         */
        CCBYNCND2_0, 
        /**
         * Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic.
         */
        CCBYNCND2_5, 
        /**
         * Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported.
         */
        CCBYNCND3_0, 
        /**
         * Creative Commons Attribution Non Commercial No Derivatives 4.0 International.
         */
        CCBYNCND4_0, 
        /**
         * Creative Commons Attribution Non Commercial Share Alike 1.0 Generic.
         */
        CCBYNCSA1_0, 
        /**
         * Creative Commons Attribution Non Commercial Share Alike 2.0 Generic.
         */
        CCBYNCSA2_0, 
        /**
         * Creative Commons Attribution Non Commercial Share Alike 2.5 Generic.
         */
        CCBYNCSA2_5, 
        /**
         * Creative Commons Attribution Non Commercial Share Alike 3.0 Unported.
         */
        CCBYNCSA3_0, 
        /**
         * Creative Commons Attribution Non Commercial Share Alike 4.0 International.
         */
        CCBYNCSA4_0, 
        /**
         * Creative Commons Attribution No Derivatives 1.0 Generic.
         */
        CCBYND1_0, 
        /**
         * Creative Commons Attribution No Derivatives 2.0 Generic.
         */
        CCBYND2_0, 
        /**
         * Creative Commons Attribution No Derivatives 2.5 Generic.
         */
        CCBYND2_5, 
        /**
         * Creative Commons Attribution No Derivatives 3.0 Unported.
         */
        CCBYND3_0, 
        /**
         * Creative Commons Attribution No Derivatives 4.0 International.
         */
        CCBYND4_0, 
        /**
         * Creative Commons Attribution Share Alike 1.0 Generic.
         */
        CCBYSA1_0, 
        /**
         * Creative Commons Attribution Share Alike 2.0 Generic.
         */
        CCBYSA2_0, 
        /**
         * Creative Commons Attribution Share Alike 2.5 Generic.
         */
        CCBYSA2_5, 
        /**
         * Creative Commons Attribution Share Alike 3.0 Unported.
         */
        CCBYSA3_0, 
        /**
         * Creative Commons Attribution Share Alike 4.0 International.
         */
        CCBYSA4_0, 
        /**
         * Creative Commons Zero v1.0 Universal.
         */
        CC01_0, 
        /**
         * Common Development and Distribution License 1.0.
         */
        CDDL1_0, 
        /**
         * Common Development and Distribution License 1.1.
         */
        CDDL1_1, 
        /**
         * Community Data License Agreement Permissive 1.0.
         */
        CDLAPERMISSIVE1_0, 
        /**
         * Community Data License Agreement Sharing 1.0.
         */
        CDLASHARING1_0, 
        /**
         * CeCILL Free Software License Agreement v1.0.
         */
        CECILL1_0, 
        /**
         * CeCILL Free Software License Agreement v1.1.
         */
        CECILL1_1, 
        /**
         * CeCILL Free Software License Agreement v2.0.
         */
        CECILL2_0, 
        /**
         * CeCILL Free Software License Agreement v2.1.
         */
        CECILL2_1, 
        /**
         * CeCILL-B Free Software License Agreement.
         */
        CECILLB, 
        /**
         * CeCILL-C Free Software License Agreement.
         */
        CECILLC, 
        /**
         * Clarified Artistic License.
         */
        CLARTISTIC, 
        /**
         * CNRI Jython License.
         */
        CNRIJYTHON, 
        /**
         * CNRI Python Open Source GPL Compatible License Agreement.
         */
        CNRIPYTHONGPLCOMPATIBLE, 
        /**
         * CNRI Python License.
         */
        CNRIPYTHON, 
        /**
         * Condor Public License v1.1.
         */
        CONDOR1_1, 
        /**
         * Common Public Attribution License 1.0.
         */
        CPAL1_0, 
        /**
         * Common Public License 1.0.
         */
        CPL1_0, 
        /**
         * Code Project Open License 1.02.
         */
        CPOL1_02, 
        /**
         * Crossword License.
         */
        CROSSWORD, 
        /**
         * CrystalStacker License.
         */
        CRYSTALSTACKER, 
        /**
         * CUA Office Public License v1.0.
         */
        CUAOPL1_0, 
        /**
         * Cube License.
         */
        CUBE, 
        /**
         * curl License.
         */
        CURL, 
        /**
         * Deutsche Freie Software Lizenz.
         */
        DFSL1_0, 
        /**
         * diffmark license.
         */
        DIFFMARK, 
        /**
         * DOC License.
         */
        DOC, 
        /**
         * Dotseqn License.
         */
        DOTSEQN, 
        /**
         * DSDP License.
         */
        DSDP, 
        /**
         * dvipdfm License.
         */
        DVIPDFM, 
        /**
         * Educational Community License v1.0.
         */
        ECL1_0, 
        /**
         * Educational Community License v2.0.
         */
        ECL2_0, 
        /**
         * Eiffel Forum License v1.0.
         */
        EFL1_0, 
        /**
         * Eiffel Forum License v2.0.
         */
        EFL2_0, 
        /**
         * eGenix.com Public License 1.1.0.
         */
        EGENIX, 
        /**
         * Entessa Public License v1.0.
         */
        ENTESSA, 
        /**
         * Eclipse Public License 1.0.
         */
        EPL1_0, 
        /**
         * Eclipse Public License 2.0.
         */
        EPL2_0, 
        /**
         * Erlang Public License v1.1.
         */
        ERLPL1_1, 
        /**
         * EU DataGrid Software License.
         */
        EUDATAGRID, 
        /**
         * European Union Public License 1.0.
         */
        EUPL1_0, 
        /**
         * European Union Public License 1.1.
         */
        EUPL1_1, 
        /**
         * European Union Public License 1.2.
         */
        EUPL1_2, 
        /**
         * Eurosym License.
         */
        EUROSYM, 
        /**
         * Fair License.
         */
        FAIR, 
        /**
         * Frameworx Open License 1.0.
         */
        FRAMEWORX1_0, 
        /**
         * FreeImage Public License v1.0.
         */
        FREEIMAGE, 
        /**
         * FSF All Permissive License.
         */
        FSFAP, 
        /**
         * FSF Unlimited License.
         */
        FSFUL, 
        /**
         * FSF Unlimited License (with License Retention).
         */
        FSFULLR, 
        /**
         * Freetype Project License.
         */
        FTL, 
        /**
         * GNU Free Documentation License v1.1 only.
         */
        GFDL1_1ONLY, 
        /**
         * GNU Free Documentation License v1.1 or later.
         */
        GFDL1_1ORLATER, 
        /**
         * GNU Free Documentation License v1.2 only.
         */
        GFDL1_2ONLY, 
        /**
         * GNU Free Documentation License v1.2 or later.
         */
        GFDL1_2ORLATER, 
        /**
         * GNU Free Documentation License v1.3 only.
         */
        GFDL1_3ONLY, 
        /**
         * GNU Free Documentation License v1.3 or later.
         */
        GFDL1_3ORLATER, 
        /**
         * Giftware License.
         */
        GIFTWARE, 
        /**
         * GL2PS License.
         */
        GL2PS, 
        /**
         * 3dfx Glide License.
         */
        GLIDE, 
        /**
         * Glulxe License.
         */
        GLULXE, 
        /**
         * gnuplot License.
         */
        GNUPLOT, 
        /**
         * GNU General Public License v1.0 only.
         */
        GPL1_0ONLY, 
        /**
         * GNU General Public License v1.0 or later.
         */
        GPL1_0ORLATER, 
        /**
         * GNU General Public License v2.0 only.
         */
        GPL2_0ONLY, 
        /**
         * GNU General Public License v2.0 or later.
         */
        GPL2_0ORLATER, 
        /**
         * GNU General Public License v3.0 only.
         */
        GPL3_0ONLY, 
        /**
         * GNU General Public License v3.0 or later.
         */
        GPL3_0ORLATER, 
        /**
         * gSOAP Public License v1.3b.
         */
        GSOAP1_3B, 
        /**
         * Haskell Language Report License.
         */
        HASKELLREPORT, 
        /**
         * Historical Permission Notice and Disclaimer.
         */
        HPND, 
        /**
         * IBM PowerPC Initialization and Boot Software.
         */
        IBMPIBS, 
        /**
         * ICU License.
         */
        ICU, 
        /**
         * Independent JPEG Group License.
         */
        IJG, 
        /**
         * ImageMagick License.
         */
        IMAGEMAGICK, 
        /**
         * iMatix Standard Function Library Agreement.
         */
        IMATIX, 
        /**
         * Imlib2 License.
         */
        IMLIB2, 
        /**
         * Info-ZIP License.
         */
        INFOZIP, 
        /**
         * Intel ACPI Software License Agreement.
         */
        INTELACPI, 
        /**
         * Intel Open Source License.
         */
        INTEL, 
        /**
         * Interbase Public License v1.0.
         */
        INTERBASE1_0, 
        /**
         * IPA Font License.
         */
        IPA, 
        /**
         * IBM Public License v1.0.
         */
        IPL1_0, 
        /**
         * ISC License.
         */
        ISC, 
        /**
         * JasPer License.
         */
        JASPER2_0, 
        /**
         * JSON License.
         */
        JSON, 
        /**
         * Licence Art Libre 1.2.
         */
        LAL1_2, 
        /**
         * Licence Art Libre 1.3.
         */
        LAL1_3, 
        /**
         * Latex2e License.
         */
        LATEX2E, 
        /**
         * Leptonica License.
         */
        LEPTONICA, 
        /**
         * GNU Library General Public License v2 only.
         */
        LGPL2_0ONLY, 
        /**
         * GNU Library General Public License v2 or later.
         */
        LGPL2_0ORLATER, 
        /**
         * GNU Lesser General Public License v2.1 only.
         */
        LGPL2_1ONLY, 
        /**
         * GNU Lesser General Public License v2.1 or later.
         */
        LGPL2_1ORLATER, 
        /**
         * GNU Lesser General Public License v3.0 only.
         */
        LGPL3_0ONLY, 
        /**
         * GNU Lesser General Public License v3.0 or later.
         */
        LGPL3_0ORLATER, 
        /**
         * Lesser General Public License For Linguistic Resources.
         */
        LGPLLR, 
        /**
         * libpng License.
         */
        LIBPNG, 
        /**
         * libtiff License.
         */
        LIBTIFF, 
        /**
         * Licence Libre du Québec – Permissive version 1.1.
         */
        LILIQP1_1, 
        /**
         * Licence Libre du Québec – Réciprocité version 1.1.
         */
        LILIQR1_1, 
        /**
         * Licence Libre du Québec – Réciprocité forte version 1.1.
         */
        LILIQRPLUS1_1, 
        /**
         * Linux Kernel Variant of OpenIB.org license.
         */
        LINUXOPENIB, 
        /**
         * Lucent Public License Version 1.0.
         */
        LPL1_0, 
        /**
         * Lucent Public License v1.02.
         */
        LPL1_02, 
        /**
         * LaTeX Project Public License v1.0.
         */
        LPPL1_0, 
        /**
         * LaTeX Project Public License v1.1.
         */
        LPPL1_1, 
        /**
         * LaTeX Project Public License v1.2.
         */
        LPPL1_2, 
        /**
         * LaTeX Project Public License v1.3a.
         */
        LPPL1_3A, 
        /**
         * LaTeX Project Public License v1.3c.
         */
        LPPL1_3C, 
        /**
         * MakeIndex License.
         */
        MAKEINDEX, 
        /**
         * MirOS License.
         */
        MIROS, 
        /**
         * MIT No Attribution.
         */
        MIT0, 
        /**
         * Enlightenment License (e16).
         */
        MITADVERTISING, 
        /**
         * CMU License.
         */
        MITCMU, 
        /**
         * enna License.
         */
        MITENNA, 
        /**
         * feh License.
         */
        MITFEH, 
        /**
         * MIT License.
         */
        MIT, 
        /**
         * MIT +no-false-attribs license.
         */
        MITNFA, 
        /**
         * Motosoto License.
         */
        MOTOSOTO, 
        /**
         * mpich2 License.
         */
        MPICH2, 
        /**
         * Mozilla Public License 1.0.
         */
        MPL1_0, 
        /**
         * Mozilla Public License 1.1.
         */
        MPL1_1, 
        /**
         * Mozilla Public License 2.0 (no copyleft exception).
         */
        MPL2_0NOCOPYLEFTEXCEPTION, 
        /**
         * Mozilla Public License 2.0.
         */
        MPL2_0, 
        /**
         * Microsoft Public License.
         */
        MSPL, 
        /**
         * Microsoft Reciprocal License.
         */
        MSRL, 
        /**
         * Matrix Template Library License.
         */
        MTLL, 
        /**
         * Multics License.
         */
        MULTICS, 
        /**
         * Mup License.
         */
        MUP, 
        /**
         * NASA Open Source Agreement 1.3.
         */
        NASA1_3, 
        /**
         * Naumen Public License.
         */
        NAUMEN, 
        /**
         * Net Boolean Public License v1.
         */
        NBPL1_0, 
        /**
         * University of Illinois/NCSA Open Source License.
         */
        NCSA, 
        /**
         * Net-SNMP License.
         */
        NETSNMP, 
        /**
         * NetCDF license.
         */
        NETCDF, 
        /**
         * Newsletr License.
         */
        NEWSLETR, 
        /**
         * Nethack General Public License.
         */
        NGPL, 
        /**
         * Norwegian Licence for Open Government Data.
         */
        NLOD1_0, 
        /**
         * No Limit Public License.
         */
        NLPL, 
        /**
         * Nokia Open Source License.
         */
        NOKIA, 
        /**
         * Netizen Open Source License.
         */
        NOSL, 
        /**
         * Noweb License.
         */
        NOWEB, 
        /**
         * Netscape Public License v1.0.
         */
        NPL1_0, 
        /**
         * Netscape Public License v1.1.
         */
        NPL1_1, 
        /**
         * Non-Profit Open Software License 3.0.
         */
        NPOSL3_0, 
        /**
         * NRL License.
         */
        NRL, 
        /**
         * NTP License.
         */
        NTP, 
        /**
         * Open CASCADE Technology Public License.
         */
        OCCTPL, 
        /**
         * OCLC Research Public License 2.0.
         */
        OCLC2_0, 
        /**
         * ODC Open Database License v1.0.
         */
        ODBL1_0, 
        /**
         * SIL Open Font License 1.0.
         */
        OFL1_0, 
        /**
         * SIL Open Font License 1.1.
         */
        OFL1_1, 
        /**
         * Open Group Test Suite License.
         */
        OGTSL, 
        /**
         * Open LDAP Public License v1.1.
         */
        OLDAP1_1, 
        /**
         * Open LDAP Public License v1.2.
         */
        OLDAP1_2, 
        /**
         * Open LDAP Public License v1.3.
         */
        OLDAP1_3, 
        /**
         * Open LDAP Public License v1.4.
         */
        OLDAP1_4, 
        /**
         * Open LDAP Public License v2.0.1.
         */
        OLDAP2_0_1, 
        /**
         * Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B).
         */
        OLDAP2_0, 
        /**
         * Open LDAP Public License v2.1.
         */
        OLDAP2_1, 
        /**
         * Open LDAP Public License v2.2.1.
         */
        OLDAP2_2_1, 
        /**
         * Open LDAP Public License 2.2.2.
         */
        OLDAP2_2_2, 
        /**
         * Open LDAP Public License v2.2.
         */
        OLDAP2_2, 
        /**
         * Open LDAP Public License v2.3.
         */
        OLDAP2_3, 
        /**
         * Open LDAP Public License v2.4.
         */
        OLDAP2_4, 
        /**
         * Open LDAP Public License v2.5.
         */
        OLDAP2_5, 
        /**
         * Open LDAP Public License v2.6.
         */
        OLDAP2_6, 
        /**
         * Open LDAP Public License v2.7.
         */
        OLDAP2_7, 
        /**
         * Open LDAP Public License v2.8.
         */
        OLDAP2_8, 
        /**
         * Open Market License.
         */
        OML, 
        /**
         * OpenSSL License.
         */
        OPENSSL, 
        /**
         * Open Public License v1.0.
         */
        OPL1_0, 
        /**
         * OSET Public License version 2.1.
         */
        OSETPL2_1, 
        /**
         * Open Software License 1.0.
         */
        OSL1_0, 
        /**
         * Open Software License 1.1.
         */
        OSL1_1, 
        /**
         * Open Software License 2.0.
         */
        OSL2_0, 
        /**
         * Open Software License 2.1.
         */
        OSL2_1, 
        /**
         * Open Software License 3.0.
         */
        OSL3_0, 
        /**
         * ODC Public Domain Dedication & License 1.0.
         */
        PDDL1_0, 
        /**
         * PHP License v3.0.
         */
        PHP3_0, 
        /**
         * PHP License v3.01.
         */
        PHP3_01, 
        /**
         * Plexus Classworlds License.
         */
        PLEXUS, 
        /**
         * PostgreSQL License.
         */
        POSTGRESQL, 
        /**
         * psfrag License.
         */
        PSFRAG, 
        /**
         * psutils License.
         */
        PSUTILS, 
        /**
         * Python License 2.0.
         */
        PYTHON2_0, 
        /**
         * Qhull License.
         */
        QHULL, 
        /**
         * Q Public License 1.0.
         */
        QPL1_0, 
        /**
         * Rdisc License.
         */
        RDISC, 
        /**
         * Red Hat eCos Public License v1.1.
         */
        RHECOS1_1, 
        /**
         * Reciprocal Public License 1.1.
         */
        RPL1_1, 
        /**
         * Reciprocal Public License 1.5.
         */
        RPL1_5, 
        /**
         * RealNetworks Public Source License v1.0.
         */
        RPSL1_0, 
        /**
         * RSA Message-Digest License.
         */
        RSAMD, 
        /**
         * Ricoh Source Code Public License.
         */
        RSCPL, 
        /**
         * Ruby License.
         */
        RUBY, 
        /**
         * Sax Public Domain Notice.
         */
        SAXPD, 
        /**
         * Saxpath License.
         */
        SAXPATH, 
        /**
         * SCEA Shared Source License.
         */
        SCEA, 
        /**
         * Sendmail License.
         */
        SENDMAIL, 
        /**
         * SGI Free Software License B v1.0.
         */
        SGIB1_0, 
        /**
         * SGI Free Software License B v1.1.
         */
        SGIB1_1, 
        /**
         * SGI Free Software License B v2.0.
         */
        SGIB2_0, 
        /**
         * Simple Public License 2.0.
         */
        SIMPL2_0, 
        /**
         * Sun Industry Standards Source License v1.2.
         */
        SISSL1_2, 
        /**
         * Sun Industry Standards Source License v1.1.
         */
        SISSL, 
        /**
         * Sleepycat License.
         */
        SLEEPYCAT, 
        /**
         * Standard ML of New Jersey License.
         */
        SMLNJ, 
        /**
         * Secure Messaging Protocol Public License.
         */
        SMPPL, 
        /**
         * SNIA Public License 1.1.
         */
        SNIA, 
        /**
         * Spencer License 86.
         */
        SPENCER86, 
        /**
         * Spencer License 94.
         */
        SPENCER94, 
        /**
         * Spencer License 99.
         */
        SPENCER99, 
        /**
         * Sun Public License v1.0.
         */
        SPL1_0, 
        /**
         * SugarCRM Public License v1.1.3.
         */
        SUGARCRM1_1_3, 
        /**
         * Scheme Widget Library (SWL) Software License Agreement.
         */
        SWL, 
        /**
         * TCL/TK License.
         */
        TCL, 
        /**
         * TCP Wrappers License.
         */
        TCPWRAPPERS, 
        /**
         * TMate Open Source License.
         */
        TMATE, 
        /**
         * TORQUE v2.5+ Software License v1.1.
         */
        TORQUE1_1, 
        /**
         * Trusster Open Source License.
         */
        TOSL, 
        /**
         * Unicode License Agreement - Data Files and Software (2015).
         */
        UNICODEDFS2015, 
        /**
         * Unicode License Agreement - Data Files and Software (2016).
         */
        UNICODEDFS2016, 
        /**
         * Unicode Terms of Use.
         */
        UNICODETOU, 
        /**
         * The Unlicense.
         */
        UNLICENSE, 
        /**
         * Universal Permissive License v1.0.
         */
        UPL1_0, 
        /**
         * Vim License.
         */
        VIM, 
        /**
         * VOSTROM Public License for Open Source.
         */
        VOSTROM, 
        /**
         * Vovida Software License v1.0.
         */
        VSL1_0, 
        /**
         * W3C Software Notice and License (1998-07-20).
         */
        W3C19980720, 
        /**
         * W3C Software Notice and Document License (2015-05-13).
         */
        W3C20150513, 
        /**
         * W3C Software Notice and License (2002-12-31).
         */
        W3C, 
        /**
         * Sybase Open Watcom Public License 1.0.
         */
        WATCOM1_0, 
        /**
         * Wsuipa License.
         */
        WSUIPA, 
        /**
         * Do What The F*ck You Want To Public License.
         */
        WTFPL, 
        /**
         * X11 License.
         */
        X11, 
        /**
         * Xerox License.
         */
        XEROX, 
        /**
         * XFree86 License 1.1.
         */
        XFREE861_1, 
        /**
         * xinetd License.
         */
        XINETD, 
        /**
         * X.Net License.
         */
        XNET, 
        /**
         * XPP License.
         */
        XPP, 
        /**
         * XSkat License.
         */
        XSKAT, 
        /**
         * Yahoo! Public License v1.0.
         */
        YPL1_0, 
        /**
         * Yahoo! Public License v1.1.
         */
        YPL1_1, 
        /**
         * Zed License.
         */
        ZED, 
        /**
         * Zend License v2.0.
         */
        ZEND2_0, 
        /**
         * Zimbra Public License v1.3.
         */
        ZIMBRA1_3, 
        /**
         * Zimbra Public License v1.4.
         */
        ZIMBRA1_4, 
        /**
         * zlib/libpng License with Acknowledgement.
         */
        ZLIBACKNOWLEDGEMENT, 
        /**
         * zlib License.
         */
        ZLIB, 
        /**
         * Zope Public License 1.1.
         */
        ZPL1_1, 
        /**
         * Zope Public License 2.0.
         */
        ZPL2_0, 
        /**
         * Zope Public License 2.1.
         */
        ZPL2_1, 
        /**
         * added to help the parsers
         */
        NULL;
        public static SpdxLicense fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("not-open-source".equals(codeString))
          return NOTOPENSOURCE;
        if ("0BSD".equals(codeString))
          return _0BSD;
        if ("AAL".equals(codeString))
          return AAL;
        if ("Abstyles".equals(codeString))
          return ABSTYLES;
        if ("Adobe-2006".equals(codeString))
          return ADOBE2006;
        if ("Adobe-Glyph".equals(codeString))
          return ADOBEGLYPH;
        if ("ADSL".equals(codeString))
          return ADSL;
        if ("AFL-1.1".equals(codeString))
          return AFL1_1;
        if ("AFL-1.2".equals(codeString))
          return AFL1_2;
        if ("AFL-2.0".equals(codeString))
          return AFL2_0;
        if ("AFL-2.1".equals(codeString))
          return AFL2_1;
        if ("AFL-3.0".equals(codeString))
          return AFL3_0;
        if ("Afmparse".equals(codeString))
          return AFMPARSE;
        if ("AGPL-1.0-only".equals(codeString))
          return AGPL1_0ONLY;
        if ("AGPL-1.0-or-later".equals(codeString))
          return AGPL1_0ORLATER;
        if ("AGPL-3.0-only".equals(codeString))
          return AGPL3_0ONLY;
        if ("AGPL-3.0-or-later".equals(codeString))
          return AGPL3_0ORLATER;
        if ("Aladdin".equals(codeString))
          return ALADDIN;
        if ("AMDPLPA".equals(codeString))
          return AMDPLPA;
        if ("AML".equals(codeString))
          return AML;
        if ("AMPAS".equals(codeString))
          return AMPAS;
        if ("ANTLR-PD".equals(codeString))
          return ANTLRPD;
        if ("Apache-1.0".equals(codeString))
          return APACHE1_0;
        if ("Apache-1.1".equals(codeString))
          return APACHE1_1;
        if ("Apache-2.0".equals(codeString))
          return APACHE2_0;
        if ("APAFML".equals(codeString))
          return APAFML;
        if ("APL-1.0".equals(codeString))
          return APL1_0;
        if ("APSL-1.0".equals(codeString))
          return APSL1_0;
        if ("APSL-1.1".equals(codeString))
          return APSL1_1;
        if ("APSL-1.2".equals(codeString))
          return APSL1_2;
        if ("APSL-2.0".equals(codeString))
          return APSL2_0;
        if ("Artistic-1.0-cl8".equals(codeString))
          return ARTISTIC1_0CL8;
        if ("Artistic-1.0-Perl".equals(codeString))
          return ARTISTIC1_0PERL;
        if ("Artistic-1.0".equals(codeString))
          return ARTISTIC1_0;
        if ("Artistic-2.0".equals(codeString))
          return ARTISTIC2_0;
        if ("Bahyph".equals(codeString))
          return BAHYPH;
        if ("Barr".equals(codeString))
          return BARR;
        if ("Beerware".equals(codeString))
          return BEERWARE;
        if ("BitTorrent-1.0".equals(codeString))
          return BITTORRENT1_0;
        if ("BitTorrent-1.1".equals(codeString))
          return BITTORRENT1_1;
        if ("Borceux".equals(codeString))
          return BORCEUX;
        if ("BSD-1-Clause".equals(codeString))
          return BSD1CLAUSE;
        if ("BSD-2-Clause-FreeBSD".equals(codeString))
          return BSD2CLAUSEFREEBSD;
        if ("BSD-2-Clause-NetBSD".equals(codeString))
          return BSD2CLAUSENETBSD;
        if ("BSD-2-Clause-Patent".equals(codeString))
          return BSD2CLAUSEPATENT;
        if ("BSD-2-Clause".equals(codeString))
          return BSD2CLAUSE;
        if ("BSD-3-Clause-Attribution".equals(codeString))
          return BSD3CLAUSEATTRIBUTION;
        if ("BSD-3-Clause-Clear".equals(codeString))
          return BSD3CLAUSECLEAR;
        if ("BSD-3-Clause-LBNL".equals(codeString))
          return BSD3CLAUSELBNL;
        if ("BSD-3-Clause-No-Nuclear-License-2014".equals(codeString))
          return BSD3CLAUSENONUCLEARLICENSE2014;
        if ("BSD-3-Clause-No-Nuclear-License".equals(codeString))
          return BSD3CLAUSENONUCLEARLICENSE;
        if ("BSD-3-Clause-No-Nuclear-Warranty".equals(codeString))
          return BSD3CLAUSENONUCLEARWARRANTY;
        if ("BSD-3-Clause".equals(codeString))
          return BSD3CLAUSE;
        if ("BSD-4-Clause-UC".equals(codeString))
          return BSD4CLAUSEUC;
        if ("BSD-4-Clause".equals(codeString))
          return BSD4CLAUSE;
        if ("BSD-Protection".equals(codeString))
          return BSDPROTECTION;
        if ("BSD-Source-Code".equals(codeString))
          return BSDSOURCECODE;
        if ("BSL-1.0".equals(codeString))
          return BSL1_0;
        if ("bzip2-1.0.5".equals(codeString))
          return BZIP21_0_5;
        if ("bzip2-1.0.6".equals(codeString))
          return BZIP21_0_6;
        if ("Caldera".equals(codeString))
          return CALDERA;
        if ("CATOSL-1.1".equals(codeString))
          return CATOSL1_1;
        if ("CC-BY-1.0".equals(codeString))
          return CCBY1_0;
        if ("CC-BY-2.0".equals(codeString))
          return CCBY2_0;
        if ("CC-BY-2.5".equals(codeString))
          return CCBY2_5;
        if ("CC-BY-3.0".equals(codeString))
          return CCBY3_0;
        if ("CC-BY-4.0".equals(codeString))
          return CCBY4_0;
        if ("CC-BY-NC-1.0".equals(codeString))
          return CCBYNC1_0;
        if ("CC-BY-NC-2.0".equals(codeString))
          return CCBYNC2_0;
        if ("CC-BY-NC-2.5".equals(codeString))
          return CCBYNC2_5;
        if ("CC-BY-NC-3.0".equals(codeString))
          return CCBYNC3_0;
        if ("CC-BY-NC-4.0".equals(codeString))
          return CCBYNC4_0;
        if ("CC-BY-NC-ND-1.0".equals(codeString))
          return CCBYNCND1_0;
        if ("CC-BY-NC-ND-2.0".equals(codeString))
          return CCBYNCND2_0;
        if ("CC-BY-NC-ND-2.5".equals(codeString))
          return CCBYNCND2_5;
        if ("CC-BY-NC-ND-3.0".equals(codeString))
          return CCBYNCND3_0;
        if ("CC-BY-NC-ND-4.0".equals(codeString))
          return CCBYNCND4_0;
        if ("CC-BY-NC-SA-1.0".equals(codeString))
          return CCBYNCSA1_0;
        if ("CC-BY-NC-SA-2.0".equals(codeString))
          return CCBYNCSA2_0;
        if ("CC-BY-NC-SA-2.5".equals(codeString))
          return CCBYNCSA2_5;
        if ("CC-BY-NC-SA-3.0".equals(codeString))
          return CCBYNCSA3_0;
        if ("CC-BY-NC-SA-4.0".equals(codeString))
          return CCBYNCSA4_0;
        if ("CC-BY-ND-1.0".equals(codeString))
          return CCBYND1_0;
        if ("CC-BY-ND-2.0".equals(codeString))
          return CCBYND2_0;
        if ("CC-BY-ND-2.5".equals(codeString))
          return CCBYND2_5;
        if ("CC-BY-ND-3.0".equals(codeString))
          return CCBYND3_0;
        if ("CC-BY-ND-4.0".equals(codeString))
          return CCBYND4_0;
        if ("CC-BY-SA-1.0".equals(codeString))
          return CCBYSA1_0;
        if ("CC-BY-SA-2.0".equals(codeString))
          return CCBYSA2_0;
        if ("CC-BY-SA-2.5".equals(codeString))
          return CCBYSA2_5;
        if ("CC-BY-SA-3.0".equals(codeString))
          return CCBYSA3_0;
        if ("CC-BY-SA-4.0".equals(codeString))
          return CCBYSA4_0;
        if ("CC0-1.0".equals(codeString))
          return CC01_0;
        if ("CDDL-1.0".equals(codeString))
          return CDDL1_0;
        if ("CDDL-1.1".equals(codeString))
          return CDDL1_1;
        if ("CDLA-Permissive-1.0".equals(codeString))
          return CDLAPERMISSIVE1_0;
        if ("CDLA-Sharing-1.0".equals(codeString))
          return CDLASHARING1_0;
        if ("CECILL-1.0".equals(codeString))
          return CECILL1_0;
        if ("CECILL-1.1".equals(codeString))
          return CECILL1_1;
        if ("CECILL-2.0".equals(codeString))
          return CECILL2_0;
        if ("CECILL-2.1".equals(codeString))
          return CECILL2_1;
        if ("CECILL-B".equals(codeString))
          return CECILLB;
        if ("CECILL-C".equals(codeString))
          return CECILLC;
        if ("ClArtistic".equals(codeString))
          return CLARTISTIC;
        if ("CNRI-Jython".equals(codeString))
          return CNRIJYTHON;
        if ("CNRI-Python-GPL-Compatible".equals(codeString))
          return CNRIPYTHONGPLCOMPATIBLE;
        if ("CNRI-Python".equals(codeString))
          return CNRIPYTHON;
        if ("Condor-1.1".equals(codeString))
          return CONDOR1_1;
        if ("CPAL-1.0".equals(codeString))
          return CPAL1_0;
        if ("CPL-1.0".equals(codeString))
          return CPL1_0;
        if ("CPOL-1.02".equals(codeString))
          return CPOL1_02;
        if ("Crossword".equals(codeString))
          return CROSSWORD;
        if ("CrystalStacker".equals(codeString))
          return CRYSTALSTACKER;
        if ("CUA-OPL-1.0".equals(codeString))
          return CUAOPL1_0;
        if ("Cube".equals(codeString))
          return CUBE;
        if ("curl".equals(codeString))
          return CURL;
        if ("D-FSL-1.0".equals(codeString))
          return DFSL1_0;
        if ("diffmark".equals(codeString))
          return DIFFMARK;
        if ("DOC".equals(codeString))
          return DOC;
        if ("Dotseqn".equals(codeString))
          return DOTSEQN;
        if ("DSDP".equals(codeString))
          return DSDP;
        if ("dvipdfm".equals(codeString))
          return DVIPDFM;
        if ("ECL-1.0".equals(codeString))
          return ECL1_0;
        if ("ECL-2.0".equals(codeString))
          return ECL2_0;
        if ("EFL-1.0".equals(codeString))
          return EFL1_0;
        if ("EFL-2.0".equals(codeString))
          return EFL2_0;
        if ("eGenix".equals(codeString))
          return EGENIX;
        if ("Entessa".equals(codeString))
          return ENTESSA;
        if ("EPL-1.0".equals(codeString))
          return EPL1_0;
        if ("EPL-2.0".equals(codeString))
          return EPL2_0;
        if ("ErlPL-1.1".equals(codeString))
          return ERLPL1_1;
        if ("EUDatagrid".equals(codeString))
          return EUDATAGRID;
        if ("EUPL-1.0".equals(codeString))
          return EUPL1_0;
        if ("EUPL-1.1".equals(codeString))
          return EUPL1_1;
        if ("EUPL-1.2".equals(codeString))
          return EUPL1_2;
        if ("Eurosym".equals(codeString))
          return EUROSYM;
        if ("Fair".equals(codeString))
          return FAIR;
        if ("Frameworx-1.0".equals(codeString))
          return FRAMEWORX1_0;
        if ("FreeImage".equals(codeString))
          return FREEIMAGE;
        if ("FSFAP".equals(codeString))
          return FSFAP;
        if ("FSFUL".equals(codeString))
          return FSFUL;
        if ("FSFULLR".equals(codeString))
          return FSFULLR;
        if ("FTL".equals(codeString))
          return FTL;
        if ("GFDL-1.1-only".equals(codeString))
          return GFDL1_1ONLY;
        if ("GFDL-1.1-or-later".equals(codeString))
          return GFDL1_1ORLATER;
        if ("GFDL-1.2-only".equals(codeString))
          return GFDL1_2ONLY;
        if ("GFDL-1.2-or-later".equals(codeString))
          return GFDL1_2ORLATER;
        if ("GFDL-1.3-only".equals(codeString))
          return GFDL1_3ONLY;
        if ("GFDL-1.3-or-later".equals(codeString))
          return GFDL1_3ORLATER;
        if ("Giftware".equals(codeString))
          return GIFTWARE;
        if ("GL2PS".equals(codeString))
          return GL2PS;
        if ("Glide".equals(codeString))
          return GLIDE;
        if ("Glulxe".equals(codeString))
          return GLULXE;
        if ("gnuplot".equals(codeString))
          return GNUPLOT;
        if ("GPL-1.0-only".equals(codeString))
          return GPL1_0ONLY;
        if ("GPL-1.0-or-later".equals(codeString))
          return GPL1_0ORLATER;
        if ("GPL-2.0-only".equals(codeString))
          return GPL2_0ONLY;
        if ("GPL-2.0-or-later".equals(codeString))
          return GPL2_0ORLATER;
        if ("GPL-3.0-only".equals(codeString))
          return GPL3_0ONLY;
        if ("GPL-3.0-or-later".equals(codeString))
          return GPL3_0ORLATER;
        if ("gSOAP-1.3b".equals(codeString))
          return GSOAP1_3B;
        if ("HaskellReport".equals(codeString))
          return HASKELLREPORT;
        if ("HPND".equals(codeString))
          return HPND;
        if ("IBM-pibs".equals(codeString))
          return IBMPIBS;
        if ("ICU".equals(codeString))
          return ICU;
        if ("IJG".equals(codeString))
          return IJG;
        if ("ImageMagick".equals(codeString))
          return IMAGEMAGICK;
        if ("iMatix".equals(codeString))
          return IMATIX;
        if ("Imlib2".equals(codeString))
          return IMLIB2;
        if ("Info-ZIP".equals(codeString))
          return INFOZIP;
        if ("Intel-ACPI".equals(codeString))
          return INTELACPI;
        if ("Intel".equals(codeString))
          return INTEL;
        if ("Interbase-1.0".equals(codeString))
          return INTERBASE1_0;
        if ("IPA".equals(codeString))
          return IPA;
        if ("IPL-1.0".equals(codeString))
          return IPL1_0;
        if ("ISC".equals(codeString))
          return ISC;
        if ("JasPer-2.0".equals(codeString))
          return JASPER2_0;
        if ("JSON".equals(codeString))
          return JSON;
        if ("LAL-1.2".equals(codeString))
          return LAL1_2;
        if ("LAL-1.3".equals(codeString))
          return LAL1_3;
        if ("Latex2e".equals(codeString))
          return LATEX2E;
        if ("Leptonica".equals(codeString))
          return LEPTONICA;
        if ("LGPL-2.0-only".equals(codeString))
          return LGPL2_0ONLY;
        if ("LGPL-2.0-or-later".equals(codeString))
          return LGPL2_0ORLATER;
        if ("LGPL-2.1-only".equals(codeString))
          return LGPL2_1ONLY;
        if ("LGPL-2.1-or-later".equals(codeString))
          return LGPL2_1ORLATER;
        if ("LGPL-3.0-only".equals(codeString))
          return LGPL3_0ONLY;
        if ("LGPL-3.0-or-later".equals(codeString))
          return LGPL3_0ORLATER;
        if ("LGPLLR".equals(codeString))
          return LGPLLR;
        if ("Libpng".equals(codeString))
          return LIBPNG;
        if ("libtiff".equals(codeString))
          return LIBTIFF;
        if ("LiLiQ-P-1.1".equals(codeString))
          return LILIQP1_1;
        if ("LiLiQ-R-1.1".equals(codeString))
          return LILIQR1_1;
        if ("LiLiQ-Rplus-1.1".equals(codeString))
          return LILIQRPLUS1_1;
        if ("Linux-OpenIB".equals(codeString))
          return LINUXOPENIB;
        if ("LPL-1.0".equals(codeString))
          return LPL1_0;
        if ("LPL-1.02".equals(codeString))
          return LPL1_02;
        if ("LPPL-1.0".equals(codeString))
          return LPPL1_0;
        if ("LPPL-1.1".equals(codeString))
          return LPPL1_1;
        if ("LPPL-1.2".equals(codeString))
          return LPPL1_2;
        if ("LPPL-1.3a".equals(codeString))
          return LPPL1_3A;
        if ("LPPL-1.3c".equals(codeString))
          return LPPL1_3C;
        if ("MakeIndex".equals(codeString))
          return MAKEINDEX;
        if ("MirOS".equals(codeString))
          return MIROS;
        if ("MIT-0".equals(codeString))
          return MIT0;
        if ("MIT-advertising".equals(codeString))
          return MITADVERTISING;
        if ("MIT-CMU".equals(codeString))
          return MITCMU;
        if ("MIT-enna".equals(codeString))
          return MITENNA;
        if ("MIT-feh".equals(codeString))
          return MITFEH;
        if ("MIT".equals(codeString))
          return MIT;
        if ("MITNFA".equals(codeString))
          return MITNFA;
        if ("Motosoto".equals(codeString))
          return MOTOSOTO;
        if ("mpich2".equals(codeString))
          return MPICH2;
        if ("MPL-1.0".equals(codeString))
          return MPL1_0;
        if ("MPL-1.1".equals(codeString))
          return MPL1_1;
        if ("MPL-2.0-no-copyleft-exception".equals(codeString))
          return MPL2_0NOCOPYLEFTEXCEPTION;
        if ("MPL-2.0".equals(codeString))
          return MPL2_0;
        if ("MS-PL".equals(codeString))
          return MSPL;
        if ("MS-RL".equals(codeString))
          return MSRL;
        if ("MTLL".equals(codeString))
          return MTLL;
        if ("Multics".equals(codeString))
          return MULTICS;
        if ("Mup".equals(codeString))
          return MUP;
        if ("NASA-1.3".equals(codeString))
          return NASA1_3;
        if ("Naumen".equals(codeString))
          return NAUMEN;
        if ("NBPL-1.0".equals(codeString))
          return NBPL1_0;
        if ("NCSA".equals(codeString))
          return NCSA;
        if ("Net-SNMP".equals(codeString))
          return NETSNMP;
        if ("NetCDF".equals(codeString))
          return NETCDF;
        if ("Newsletr".equals(codeString))
          return NEWSLETR;
        if ("NGPL".equals(codeString))
          return NGPL;
        if ("NLOD-1.0".equals(codeString))
          return NLOD1_0;
        if ("NLPL".equals(codeString))
          return NLPL;
        if ("Nokia".equals(codeString))
          return NOKIA;
        if ("NOSL".equals(codeString))
          return NOSL;
        if ("Noweb".equals(codeString))
          return NOWEB;
        if ("NPL-1.0".equals(codeString))
          return NPL1_0;
        if ("NPL-1.1".equals(codeString))
          return NPL1_1;
        if ("NPOSL-3.0".equals(codeString))
          return NPOSL3_0;
        if ("NRL".equals(codeString))
          return NRL;
        if ("NTP".equals(codeString))
          return NTP;
        if ("OCCT-PL".equals(codeString))
          return OCCTPL;
        if ("OCLC-2.0".equals(codeString))
          return OCLC2_0;
        if ("ODbL-1.0".equals(codeString))
          return ODBL1_0;
        if ("OFL-1.0".equals(codeString))
          return OFL1_0;
        if ("OFL-1.1".equals(codeString))
          return OFL1_1;
        if ("OGTSL".equals(codeString))
          return OGTSL;
        if ("OLDAP-1.1".equals(codeString))
          return OLDAP1_1;
        if ("OLDAP-1.2".equals(codeString))
          return OLDAP1_2;
        if ("OLDAP-1.3".equals(codeString))
          return OLDAP1_3;
        if ("OLDAP-1.4".equals(codeString))
          return OLDAP1_4;
        if ("OLDAP-2.0.1".equals(codeString))
          return OLDAP2_0_1;
        if ("OLDAP-2.0".equals(codeString))
          return OLDAP2_0;
        if ("OLDAP-2.1".equals(codeString))
          return OLDAP2_1;
        if ("OLDAP-2.2.1".equals(codeString))
          return OLDAP2_2_1;
        if ("OLDAP-2.2.2".equals(codeString))
          return OLDAP2_2_2;
        if ("OLDAP-2.2".equals(codeString))
          return OLDAP2_2;
        if ("OLDAP-2.3".equals(codeString))
          return OLDAP2_3;
        if ("OLDAP-2.4".equals(codeString))
          return OLDAP2_4;
        if ("OLDAP-2.5".equals(codeString))
          return OLDAP2_5;
        if ("OLDAP-2.6".equals(codeString))
          return OLDAP2_6;
        if ("OLDAP-2.7".equals(codeString))
          return OLDAP2_7;
        if ("OLDAP-2.8".equals(codeString))
          return OLDAP2_8;
        if ("OML".equals(codeString))
          return OML;
        if ("OpenSSL".equals(codeString))
          return OPENSSL;
        if ("OPL-1.0".equals(codeString))
          return OPL1_0;
        if ("OSET-PL-2.1".equals(codeString))
          return OSETPL2_1;
        if ("OSL-1.0".equals(codeString))
          return OSL1_0;
        if ("OSL-1.1".equals(codeString))
          return OSL1_1;
        if ("OSL-2.0".equals(codeString))
          return OSL2_0;
        if ("OSL-2.1".equals(codeString))
          return OSL2_1;
        if ("OSL-3.0".equals(codeString))
          return OSL3_0;
        if ("PDDL-1.0".equals(codeString))
          return PDDL1_0;
        if ("PHP-3.0".equals(codeString))
          return PHP3_0;
        if ("PHP-3.01".equals(codeString))
          return PHP3_01;
        if ("Plexus".equals(codeString))
          return PLEXUS;
        if ("PostgreSQL".equals(codeString))
          return POSTGRESQL;
        if ("psfrag".equals(codeString))
          return PSFRAG;
        if ("psutils".equals(codeString))
          return PSUTILS;
        if ("Python-2.0".equals(codeString))
          return PYTHON2_0;
        if ("Qhull".equals(codeString))
          return QHULL;
        if ("QPL-1.0".equals(codeString))
          return QPL1_0;
        if ("Rdisc".equals(codeString))
          return RDISC;
        if ("RHeCos-1.1".equals(codeString))
          return RHECOS1_1;
        if ("RPL-1.1".equals(codeString))
          return RPL1_1;
        if ("RPL-1.5".equals(codeString))
          return RPL1_5;
        if ("RPSL-1.0".equals(codeString))
          return RPSL1_0;
        if ("RSA-MD".equals(codeString))
          return RSAMD;
        if ("RSCPL".equals(codeString))
          return RSCPL;
        if ("Ruby".equals(codeString))
          return RUBY;
        if ("SAX-PD".equals(codeString))
          return SAXPD;
        if ("Saxpath".equals(codeString))
          return SAXPATH;
        if ("SCEA".equals(codeString))
          return SCEA;
        if ("Sendmail".equals(codeString))
          return SENDMAIL;
        if ("SGI-B-1.0".equals(codeString))
          return SGIB1_0;
        if ("SGI-B-1.1".equals(codeString))
          return SGIB1_1;
        if ("SGI-B-2.0".equals(codeString))
          return SGIB2_0;
        if ("SimPL-2.0".equals(codeString))
          return SIMPL2_0;
        if ("SISSL-1.2".equals(codeString))
          return SISSL1_2;
        if ("SISSL".equals(codeString))
          return SISSL;
        if ("Sleepycat".equals(codeString))
          return SLEEPYCAT;
        if ("SMLNJ".equals(codeString))
          return SMLNJ;
        if ("SMPPL".equals(codeString))
          return SMPPL;
        if ("SNIA".equals(codeString))
          return SNIA;
        if ("Spencer-86".equals(codeString))
          return SPENCER86;
        if ("Spencer-94".equals(codeString))
          return SPENCER94;
        if ("Spencer-99".equals(codeString))
          return SPENCER99;
        if ("SPL-1.0".equals(codeString))
          return SPL1_0;
        if ("SugarCRM-1.1.3".equals(codeString))
          return SUGARCRM1_1_3;
        if ("SWL".equals(codeString))
          return SWL;
        if ("TCL".equals(codeString))
          return TCL;
        if ("TCP-wrappers".equals(codeString))
          return TCPWRAPPERS;
        if ("TMate".equals(codeString))
          return TMATE;
        if ("TORQUE-1.1".equals(codeString))
          return TORQUE1_1;
        if ("TOSL".equals(codeString))
          return TOSL;
        if ("Unicode-DFS-2015".equals(codeString))
          return UNICODEDFS2015;
        if ("Unicode-DFS-2016".equals(codeString))
          return UNICODEDFS2016;
        if ("Unicode-TOU".equals(codeString))
          return UNICODETOU;
        if ("Unlicense".equals(codeString))
          return UNLICENSE;
        if ("UPL-1.0".equals(codeString))
          return UPL1_0;
        if ("Vim".equals(codeString))
          return VIM;
        if ("VOSTROM".equals(codeString))
          return VOSTROM;
        if ("VSL-1.0".equals(codeString))
          return VSL1_0;
        if ("W3C-19980720".equals(codeString))
          return W3C19980720;
        if ("W3C-20150513".equals(codeString))
          return W3C20150513;
        if ("W3C".equals(codeString))
          return W3C;
        if ("Watcom-1.0".equals(codeString))
          return WATCOM1_0;
        if ("Wsuipa".equals(codeString))
          return WSUIPA;
        if ("WTFPL".equals(codeString))
          return WTFPL;
        if ("X11".equals(codeString))
          return X11;
        if ("Xerox".equals(codeString))
          return XEROX;
        if ("XFree86-1.1".equals(codeString))
          return XFREE861_1;
        if ("xinetd".equals(codeString))
          return XINETD;
        if ("Xnet".equals(codeString))
          return XNET;
        if ("xpp".equals(codeString))
          return XPP;
        if ("XSkat".equals(codeString))
          return XSKAT;
        if ("YPL-1.0".equals(codeString))
          return YPL1_0;
        if ("YPL-1.1".equals(codeString))
          return YPL1_1;
        if ("Zed".equals(codeString))
          return ZED;
        if ("Zend-2.0".equals(codeString))
          return ZEND2_0;
        if ("Zimbra-1.3".equals(codeString))
          return ZIMBRA1_3;
        if ("Zimbra-1.4".equals(codeString))
          return ZIMBRA1_4;
        if ("zlib-acknowledgement".equals(codeString))
          return ZLIBACKNOWLEDGEMENT;
        if ("Zlib".equals(codeString))
          return ZLIB;
        if ("ZPL-1.1".equals(codeString))
          return ZPL1_1;
        if ("ZPL-2.0".equals(codeString))
          return ZPL2_0;
        if ("ZPL-2.1".equals(codeString))
          return ZPL2_1;
        throw new FHIRException("Unknown SpdxLicense code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case NOTOPENSOURCE: return "not-open-source";
            case _0BSD: return "0BSD";
            case AAL: return "AAL";
            case ABSTYLES: return "Abstyles";
            case ADOBE2006: return "Adobe-2006";
            case ADOBEGLYPH: return "Adobe-Glyph";
            case ADSL: return "ADSL";
            case AFL1_1: return "AFL-1.1";
            case AFL1_2: return "AFL-1.2";
            case AFL2_0: return "AFL-2.0";
            case AFL2_1: return "AFL-2.1";
            case AFL3_0: return "AFL-3.0";
            case AFMPARSE: return "Afmparse";
            case AGPL1_0ONLY: return "AGPL-1.0-only";
            case AGPL1_0ORLATER: return "AGPL-1.0-or-later";
            case AGPL3_0ONLY: return "AGPL-3.0-only";
            case AGPL3_0ORLATER: return "AGPL-3.0-or-later";
            case ALADDIN: return "Aladdin";
            case AMDPLPA: return "AMDPLPA";
            case AML: return "AML";
            case AMPAS: return "AMPAS";
            case ANTLRPD: return "ANTLR-PD";
            case APACHE1_0: return "Apache-1.0";
            case APACHE1_1: return "Apache-1.1";
            case APACHE2_0: return "Apache-2.0";
            case APAFML: return "APAFML";
            case APL1_0: return "APL-1.0";
            case APSL1_0: return "APSL-1.0";
            case APSL1_1: return "APSL-1.1";
            case APSL1_2: return "APSL-1.2";
            case APSL2_0: return "APSL-2.0";
            case ARTISTIC1_0CL8: return "Artistic-1.0-cl8";
            case ARTISTIC1_0PERL: return "Artistic-1.0-Perl";
            case ARTISTIC1_0: return "Artistic-1.0";
            case ARTISTIC2_0: return "Artistic-2.0";
            case BAHYPH: return "Bahyph";
            case BARR: return "Barr";
            case BEERWARE: return "Beerware";
            case BITTORRENT1_0: return "BitTorrent-1.0";
            case BITTORRENT1_1: return "BitTorrent-1.1";
            case BORCEUX: return "Borceux";
            case BSD1CLAUSE: return "BSD-1-Clause";
            case BSD2CLAUSEFREEBSD: return "BSD-2-Clause-FreeBSD";
            case BSD2CLAUSENETBSD: return "BSD-2-Clause-NetBSD";
            case BSD2CLAUSEPATENT: return "BSD-2-Clause-Patent";
            case BSD2CLAUSE: return "BSD-2-Clause";
            case BSD3CLAUSEATTRIBUTION: return "BSD-3-Clause-Attribution";
            case BSD3CLAUSECLEAR: return "BSD-3-Clause-Clear";
            case BSD3CLAUSELBNL: return "BSD-3-Clause-LBNL";
            case BSD3CLAUSENONUCLEARLICENSE2014: return "BSD-3-Clause-No-Nuclear-License-2014";
            case BSD3CLAUSENONUCLEARLICENSE: return "BSD-3-Clause-No-Nuclear-License";
            case BSD3CLAUSENONUCLEARWARRANTY: return "BSD-3-Clause-No-Nuclear-Warranty";
            case BSD3CLAUSE: return "BSD-3-Clause";
            case BSD4CLAUSEUC: return "BSD-4-Clause-UC";
            case BSD4CLAUSE: return "BSD-4-Clause";
            case BSDPROTECTION: return "BSD-Protection";
            case BSDSOURCECODE: return "BSD-Source-Code";
            case BSL1_0: return "BSL-1.0";
            case BZIP21_0_5: return "bzip2-1.0.5";
            case BZIP21_0_6: return "bzip2-1.0.6";
            case CALDERA: return "Caldera";
            case CATOSL1_1: return "CATOSL-1.1";
            case CCBY1_0: return "CC-BY-1.0";
            case CCBY2_0: return "CC-BY-2.0";
            case CCBY2_5: return "CC-BY-2.5";
            case CCBY3_0: return "CC-BY-3.0";
            case CCBY4_0: return "CC-BY-4.0";
            case CCBYNC1_0: return "CC-BY-NC-1.0";
            case CCBYNC2_0: return "CC-BY-NC-2.0";
            case CCBYNC2_5: return "CC-BY-NC-2.5";
            case CCBYNC3_0: return "CC-BY-NC-3.0";
            case CCBYNC4_0: return "CC-BY-NC-4.0";
            case CCBYNCND1_0: return "CC-BY-NC-ND-1.0";
            case CCBYNCND2_0: return "CC-BY-NC-ND-2.0";
            case CCBYNCND2_5: return "CC-BY-NC-ND-2.5";
            case CCBYNCND3_0: return "CC-BY-NC-ND-3.0";
            case CCBYNCND4_0: return "CC-BY-NC-ND-4.0";
            case CCBYNCSA1_0: return "CC-BY-NC-SA-1.0";
            case CCBYNCSA2_0: return "CC-BY-NC-SA-2.0";
            case CCBYNCSA2_5: return "CC-BY-NC-SA-2.5";
            case CCBYNCSA3_0: return "CC-BY-NC-SA-3.0";
            case CCBYNCSA4_0: return "CC-BY-NC-SA-4.0";
            case CCBYND1_0: return "CC-BY-ND-1.0";
            case CCBYND2_0: return "CC-BY-ND-2.0";
            case CCBYND2_5: return "CC-BY-ND-2.5";
            case CCBYND3_0: return "CC-BY-ND-3.0";
            case CCBYND4_0: return "CC-BY-ND-4.0";
            case CCBYSA1_0: return "CC-BY-SA-1.0";
            case CCBYSA2_0: return "CC-BY-SA-2.0";
            case CCBYSA2_5: return "CC-BY-SA-2.5";
            case CCBYSA3_0: return "CC-BY-SA-3.0";
            case CCBYSA4_0: return "CC-BY-SA-4.0";
            case CC01_0: return "CC0-1.0";
            case CDDL1_0: return "CDDL-1.0";
            case CDDL1_1: return "CDDL-1.1";
            case CDLAPERMISSIVE1_0: return "CDLA-Permissive-1.0";
            case CDLASHARING1_0: return "CDLA-Sharing-1.0";
            case CECILL1_0: return "CECILL-1.0";
            case CECILL1_1: return "CECILL-1.1";
            case CECILL2_0: return "CECILL-2.0";
            case CECILL2_1: return "CECILL-2.1";
            case CECILLB: return "CECILL-B";
            case CECILLC: return "CECILL-C";
            case CLARTISTIC: return "ClArtistic";
            case CNRIJYTHON: return "CNRI-Jython";
            case CNRIPYTHONGPLCOMPATIBLE: return "CNRI-Python-GPL-Compatible";
            case CNRIPYTHON: return "CNRI-Python";
            case CONDOR1_1: return "Condor-1.1";
            case CPAL1_0: return "CPAL-1.0";
            case CPL1_0: return "CPL-1.0";
            case CPOL1_02: return "CPOL-1.02";
            case CROSSWORD: return "Crossword";
            case CRYSTALSTACKER: return "CrystalStacker";
            case CUAOPL1_0: return "CUA-OPL-1.0";
            case CUBE: return "Cube";
            case CURL: return "curl";
            case DFSL1_0: return "D-FSL-1.0";
            case DIFFMARK: return "diffmark";
            case DOC: return "DOC";
            case DOTSEQN: return "Dotseqn";
            case DSDP: return "DSDP";
            case DVIPDFM: return "dvipdfm";
            case ECL1_0: return "ECL-1.0";
            case ECL2_0: return "ECL-2.0";
            case EFL1_0: return "EFL-1.0";
            case EFL2_0: return "EFL-2.0";
            case EGENIX: return "eGenix";
            case ENTESSA: return "Entessa";
            case EPL1_0: return "EPL-1.0";
            case EPL2_0: return "EPL-2.0";
            case ERLPL1_1: return "ErlPL-1.1";
            case EUDATAGRID: return "EUDatagrid";
            case EUPL1_0: return "EUPL-1.0";
            case EUPL1_1: return "EUPL-1.1";
            case EUPL1_2: return "EUPL-1.2";
            case EUROSYM: return "Eurosym";
            case FAIR: return "Fair";
            case FRAMEWORX1_0: return "Frameworx-1.0";
            case FREEIMAGE: return "FreeImage";
            case FSFAP: return "FSFAP";
            case FSFUL: return "FSFUL";
            case FSFULLR: return "FSFULLR";
            case FTL: return "FTL";
            case GFDL1_1ONLY: return "GFDL-1.1-only";
            case GFDL1_1ORLATER: return "GFDL-1.1-or-later";
            case GFDL1_2ONLY: return "GFDL-1.2-only";
            case GFDL1_2ORLATER: return "GFDL-1.2-or-later";
            case GFDL1_3ONLY: return "GFDL-1.3-only";
            case GFDL1_3ORLATER: return "GFDL-1.3-or-later";
            case GIFTWARE: return "Giftware";
            case GL2PS: return "GL2PS";
            case GLIDE: return "Glide";
            case GLULXE: return "Glulxe";
            case GNUPLOT: return "gnuplot";
            case GPL1_0ONLY: return "GPL-1.0-only";
            case GPL1_0ORLATER: return "GPL-1.0-or-later";
            case GPL2_0ONLY: return "GPL-2.0-only";
            case GPL2_0ORLATER: return "GPL-2.0-or-later";
            case GPL3_0ONLY: return "GPL-3.0-only";
            case GPL3_0ORLATER: return "GPL-3.0-or-later";
            case GSOAP1_3B: return "gSOAP-1.3b";
            case HASKELLREPORT: return "HaskellReport";
            case HPND: return "HPND";
            case IBMPIBS: return "IBM-pibs";
            case ICU: return "ICU";
            case IJG: return "IJG";
            case IMAGEMAGICK: return "ImageMagick";
            case IMATIX: return "iMatix";
            case IMLIB2: return "Imlib2";
            case INFOZIP: return "Info-ZIP";
            case INTELACPI: return "Intel-ACPI";
            case INTEL: return "Intel";
            case INTERBASE1_0: return "Interbase-1.0";
            case IPA: return "IPA";
            case IPL1_0: return "IPL-1.0";
            case ISC: return "ISC";
            case JASPER2_0: return "JasPer-2.0";
            case JSON: return "JSON";
            case LAL1_2: return "LAL-1.2";
            case LAL1_3: return "LAL-1.3";
            case LATEX2E: return "Latex2e";
            case LEPTONICA: return "Leptonica";
            case LGPL2_0ONLY: return "LGPL-2.0-only";
            case LGPL2_0ORLATER: return "LGPL-2.0-or-later";
            case LGPL2_1ONLY: return "LGPL-2.1-only";
            case LGPL2_1ORLATER: return "LGPL-2.1-or-later";
            case LGPL3_0ONLY: return "LGPL-3.0-only";
            case LGPL3_0ORLATER: return "LGPL-3.0-or-later";
            case LGPLLR: return "LGPLLR";
            case LIBPNG: return "Libpng";
            case LIBTIFF: return "libtiff";
            case LILIQP1_1: return "LiLiQ-P-1.1";
            case LILIQR1_1: return "LiLiQ-R-1.1";
            case LILIQRPLUS1_1: return "LiLiQ-Rplus-1.1";
            case LINUXOPENIB: return "Linux-OpenIB";
            case LPL1_0: return "LPL-1.0";
            case LPL1_02: return "LPL-1.02";
            case LPPL1_0: return "LPPL-1.0";
            case LPPL1_1: return "LPPL-1.1";
            case LPPL1_2: return "LPPL-1.2";
            case LPPL1_3A: return "LPPL-1.3a";
            case LPPL1_3C: return "LPPL-1.3c";
            case MAKEINDEX: return "MakeIndex";
            case MIROS: return "MirOS";
            case MIT0: return "MIT-0";
            case MITADVERTISING: return "MIT-advertising";
            case MITCMU: return "MIT-CMU";
            case MITENNA: return "MIT-enna";
            case MITFEH: return "MIT-feh";
            case MIT: return "MIT";
            case MITNFA: return "MITNFA";
            case MOTOSOTO: return "Motosoto";
            case MPICH2: return "mpich2";
            case MPL1_0: return "MPL-1.0";
            case MPL1_1: return "MPL-1.1";
            case MPL2_0NOCOPYLEFTEXCEPTION: return "MPL-2.0-no-copyleft-exception";
            case MPL2_0: return "MPL-2.0";
            case MSPL: return "MS-PL";
            case MSRL: return "MS-RL";
            case MTLL: return "MTLL";
            case MULTICS: return "Multics";
            case MUP: return "Mup";
            case NASA1_3: return "NASA-1.3";
            case NAUMEN: return "Naumen";
            case NBPL1_0: return "NBPL-1.0";
            case NCSA: return "NCSA";
            case NETSNMP: return "Net-SNMP";
            case NETCDF: return "NetCDF";
            case NEWSLETR: return "Newsletr";
            case NGPL: return "NGPL";
            case NLOD1_0: return "NLOD-1.0";
            case NLPL: return "NLPL";
            case NOKIA: return "Nokia";
            case NOSL: return "NOSL";
            case NOWEB: return "Noweb";
            case NPL1_0: return "NPL-1.0";
            case NPL1_1: return "NPL-1.1";
            case NPOSL3_0: return "NPOSL-3.0";
            case NRL: return "NRL";
            case NTP: return "NTP";
            case OCCTPL: return "OCCT-PL";
            case OCLC2_0: return "OCLC-2.0";
            case ODBL1_0: return "ODbL-1.0";
            case OFL1_0: return "OFL-1.0";
            case OFL1_1: return "OFL-1.1";
            case OGTSL: return "OGTSL";
            case OLDAP1_1: return "OLDAP-1.1";
            case OLDAP1_2: return "OLDAP-1.2";
            case OLDAP1_3: return "OLDAP-1.3";
            case OLDAP1_4: return "OLDAP-1.4";
            case OLDAP2_0_1: return "OLDAP-2.0.1";
            case OLDAP2_0: return "OLDAP-2.0";
            case OLDAP2_1: return "OLDAP-2.1";
            case OLDAP2_2_1: return "OLDAP-2.2.1";
            case OLDAP2_2_2: return "OLDAP-2.2.2";
            case OLDAP2_2: return "OLDAP-2.2";
            case OLDAP2_3: return "OLDAP-2.3";
            case OLDAP2_4: return "OLDAP-2.4";
            case OLDAP2_5: return "OLDAP-2.5";
            case OLDAP2_6: return "OLDAP-2.6";
            case OLDAP2_7: return "OLDAP-2.7";
            case OLDAP2_8: return "OLDAP-2.8";
            case OML: return "OML";
            case OPENSSL: return "OpenSSL";
            case OPL1_0: return "OPL-1.0";
            case OSETPL2_1: return "OSET-PL-2.1";
            case OSL1_0: return "OSL-1.0";
            case OSL1_1: return "OSL-1.1";
            case OSL2_0: return "OSL-2.0";
            case OSL2_1: return "OSL-2.1";
            case OSL3_0: return "OSL-3.0";
            case PDDL1_0: return "PDDL-1.0";
            case PHP3_0: return "PHP-3.0";
            case PHP3_01: return "PHP-3.01";
            case PLEXUS: return "Plexus";
            case POSTGRESQL: return "PostgreSQL";
            case PSFRAG: return "psfrag";
            case PSUTILS: return "psutils";
            case PYTHON2_0: return "Python-2.0";
            case QHULL: return "Qhull";
            case QPL1_0: return "QPL-1.0";
            case RDISC: return "Rdisc";
            case RHECOS1_1: return "RHeCos-1.1";
            case RPL1_1: return "RPL-1.1";
            case RPL1_5: return "RPL-1.5";
            case RPSL1_0: return "RPSL-1.0";
            case RSAMD: return "RSA-MD";
            case RSCPL: return "RSCPL";
            case RUBY: return "Ruby";
            case SAXPD: return "SAX-PD";
            case SAXPATH: return "Saxpath";
            case SCEA: return "SCEA";
            case SENDMAIL: return "Sendmail";
            case SGIB1_0: return "SGI-B-1.0";
            case SGIB1_1: return "SGI-B-1.1";
            case SGIB2_0: return "SGI-B-2.0";
            case SIMPL2_0: return "SimPL-2.0";
            case SISSL1_2: return "SISSL-1.2";
            case SISSL: return "SISSL";
            case SLEEPYCAT: return "Sleepycat";
            case SMLNJ: return "SMLNJ";
            case SMPPL: return "SMPPL";
            case SNIA: return "SNIA";
            case SPENCER86: return "Spencer-86";
            case SPENCER94: return "Spencer-94";
            case SPENCER99: return "Spencer-99";
            case SPL1_0: return "SPL-1.0";
            case SUGARCRM1_1_3: return "SugarCRM-1.1.3";
            case SWL: return "SWL";
            case TCL: return "TCL";
            case TCPWRAPPERS: return "TCP-wrappers";
            case TMATE: return "TMate";
            case TORQUE1_1: return "TORQUE-1.1";
            case TOSL: return "TOSL";
            case UNICODEDFS2015: return "Unicode-DFS-2015";
            case UNICODEDFS2016: return "Unicode-DFS-2016";
            case UNICODETOU: return "Unicode-TOU";
            case UNLICENSE: return "Unlicense";
            case UPL1_0: return "UPL-1.0";
            case VIM: return "Vim";
            case VOSTROM: return "VOSTROM";
            case VSL1_0: return "VSL-1.0";
            case W3C19980720: return "W3C-19980720";
            case W3C20150513: return "W3C-20150513";
            case W3C: return "W3C";
            case WATCOM1_0: return "Watcom-1.0";
            case WSUIPA: return "Wsuipa";
            case WTFPL: return "WTFPL";
            case X11: return "X11";
            case XEROX: return "Xerox";
            case XFREE861_1: return "XFree86-1.1";
            case XINETD: return "xinetd";
            case XNET: return "Xnet";
            case XPP: return "xpp";
            case XSKAT: return "XSkat";
            case YPL1_0: return "YPL-1.0";
            case YPL1_1: return "YPL-1.1";
            case ZED: return "Zed";
            case ZEND2_0: return "Zend-2.0";
            case ZIMBRA1_3: return "Zimbra-1.3";
            case ZIMBRA1_4: return "Zimbra-1.4";
            case ZLIBACKNOWLEDGEMENT: return "zlib-acknowledgement";
            case ZLIB: return "Zlib";
            case ZPL1_1: return "ZPL-1.1";
            case ZPL2_0: return "ZPL-2.0";
            case ZPL2_1: return "ZPL-2.1";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/spdx-license";
        }
        public String getDefinition() {
          switch (this) {
            case NOTOPENSOURCE: return "Not an open source license.";
            case _0BSD: return "BSD Zero Clause License.";
            case AAL: return "Attribution Assurance License.";
            case ABSTYLES: return "Abstyles License.";
            case ADOBE2006: return "Adobe Systems Incorporated Source Code License Agreement.";
            case ADOBEGLYPH: return "Adobe Glyph List License.";
            case ADSL: return "Amazon Digital Services License.";
            case AFL1_1: return "Academic Free License v1.1.";
            case AFL1_2: return "Academic Free License v1.2.";
            case AFL2_0: return "Academic Free License v2.0.";
            case AFL2_1: return "Academic Free License v2.1.";
            case AFL3_0: return "Academic Free License v3.0.";
            case AFMPARSE: return "Afmparse License.";
            case AGPL1_0ONLY: return "Affero General Public License v1.0 only.";
            case AGPL1_0ORLATER: return "Affero General Public License v1.0 or later.";
            case AGPL3_0ONLY: return "GNU Affero General Public License v3.0 only.";
            case AGPL3_0ORLATER: return "GNU Affero General Public License v3.0 or later.";
            case ALADDIN: return "Aladdin Free Public License.";
            case AMDPLPA: return "AMD's plpa_map.c License.";
            case AML: return "Apple MIT License.";
            case AMPAS: return "Academy of Motion Picture Arts and Sciences BSD.";
            case ANTLRPD: return "ANTLR Software Rights Notice.";
            case APACHE1_0: return "Apache License 1.0.";
            case APACHE1_1: return "Apache License 1.1.";
            case APACHE2_0: return "Apache License 2.0.";
            case APAFML: return "Adobe Postscript AFM License.";
            case APL1_0: return "Adaptive Public License 1.0.";
            case APSL1_0: return "Apple Public Source License 1.0.";
            case APSL1_1: return "Apple Public Source License 1.1.";
            case APSL1_2: return "Apple Public Source License 1.2.";
            case APSL2_0: return "Apple Public Source License 2.0.";
            case ARTISTIC1_0CL8: return "Artistic License 1.0 w/clause 8.";
            case ARTISTIC1_0PERL: return "Artistic License 1.0 (Perl).";
            case ARTISTIC1_0: return "Artistic License 1.0.";
            case ARTISTIC2_0: return "Artistic License 2.0.";
            case BAHYPH: return "Bahyph License.";
            case BARR: return "Barr License.";
            case BEERWARE: return "Beerware License.";
            case BITTORRENT1_0: return "BitTorrent Open Source License v1.0.";
            case BITTORRENT1_1: return "BitTorrent Open Source License v1.1.";
            case BORCEUX: return "Borceux license.";
            case BSD1CLAUSE: return "BSD 1-Clause License.";
            case BSD2CLAUSEFREEBSD: return "BSD 2-Clause FreeBSD License.";
            case BSD2CLAUSENETBSD: return "BSD 2-Clause NetBSD License.";
            case BSD2CLAUSEPATENT: return "BSD-2-Clause Plus Patent License.";
            case BSD2CLAUSE: return "BSD 2-Clause \"Simplified\" License.";
            case BSD3CLAUSEATTRIBUTION: return "BSD with attribution.";
            case BSD3CLAUSECLEAR: return "BSD 3-Clause Clear License.";
            case BSD3CLAUSELBNL: return "Lawrence Berkeley National Labs BSD variant license.";
            case BSD3CLAUSENONUCLEARLICENSE2014: return "BSD 3-Clause No Nuclear License 2014.";
            case BSD3CLAUSENONUCLEARLICENSE: return "BSD 3-Clause No Nuclear License.";
            case BSD3CLAUSENONUCLEARWARRANTY: return "BSD 3-Clause No Nuclear Warranty.";
            case BSD3CLAUSE: return "BSD 3-Clause \"New\" or \"Revised\" License.";
            case BSD4CLAUSEUC: return "BSD-4-Clause (University of California-Specific).";
            case BSD4CLAUSE: return "BSD 4-Clause \"Original\" or \"Old\" License.";
            case BSDPROTECTION: return "BSD Protection License.";
            case BSDSOURCECODE: return "BSD Source Code Attribution.";
            case BSL1_0: return "Boost Software License 1.0.";
            case BZIP21_0_5: return "bzip2 and libbzip2 License v1.0.5.";
            case BZIP21_0_6: return "bzip2 and libbzip2 License v1.0.6.";
            case CALDERA: return "Caldera License.";
            case CATOSL1_1: return "Computer Associates Trusted Open Source License 1.1.";
            case CCBY1_0: return "Creative Commons Attribution 1.0 Generic.";
            case CCBY2_0: return "Creative Commons Attribution 2.0 Generic.";
            case CCBY2_5: return "Creative Commons Attribution 2.5 Generic.";
            case CCBY3_0: return "Creative Commons Attribution 3.0 Unported.";
            case CCBY4_0: return "Creative Commons Attribution 4.0 International.";
            case CCBYNC1_0: return "Creative Commons Attribution Non Commercial 1.0 Generic.";
            case CCBYNC2_0: return "Creative Commons Attribution Non Commercial 2.0 Generic.";
            case CCBYNC2_5: return "Creative Commons Attribution Non Commercial 2.5 Generic.";
            case CCBYNC3_0: return "Creative Commons Attribution Non Commercial 3.0 Unported.";
            case CCBYNC4_0: return "Creative Commons Attribution Non Commercial 4.0 International.";
            case CCBYNCND1_0: return "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic.";
            case CCBYNCND2_0: return "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic.";
            case CCBYNCND2_5: return "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic.";
            case CCBYNCND3_0: return "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported.";
            case CCBYNCND4_0: return "Creative Commons Attribution Non Commercial No Derivatives 4.0 International.";
            case CCBYNCSA1_0: return "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic.";
            case CCBYNCSA2_0: return "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic.";
            case CCBYNCSA2_5: return "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic.";
            case CCBYNCSA3_0: return "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported.";
            case CCBYNCSA4_0: return "Creative Commons Attribution Non Commercial Share Alike 4.0 International.";
            case CCBYND1_0: return "Creative Commons Attribution No Derivatives 1.0 Generic.";
            case CCBYND2_0: return "Creative Commons Attribution No Derivatives 2.0 Generic.";
            case CCBYND2_5: return "Creative Commons Attribution No Derivatives 2.5 Generic.";
            case CCBYND3_0: return "Creative Commons Attribution No Derivatives 3.0 Unported.";
            case CCBYND4_0: return "Creative Commons Attribution No Derivatives 4.0 International.";
            case CCBYSA1_0: return "Creative Commons Attribution Share Alike 1.0 Generic.";
            case CCBYSA2_0: return "Creative Commons Attribution Share Alike 2.0 Generic.";
            case CCBYSA2_5: return "Creative Commons Attribution Share Alike 2.5 Generic.";
            case CCBYSA3_0: return "Creative Commons Attribution Share Alike 3.0 Unported.";
            case CCBYSA4_0: return "Creative Commons Attribution Share Alike 4.0 International.";
            case CC01_0: return "Creative Commons Zero v1.0 Universal.";
            case CDDL1_0: return "Common Development and Distribution License 1.0.";
            case CDDL1_1: return "Common Development and Distribution License 1.1.";
            case CDLAPERMISSIVE1_0: return "Community Data License Agreement Permissive 1.0.";
            case CDLASHARING1_0: return "Community Data License Agreement Sharing 1.0.";
            case CECILL1_0: return "CeCILL Free Software License Agreement v1.0.";
            case CECILL1_1: return "CeCILL Free Software License Agreement v1.1.";
            case CECILL2_0: return "CeCILL Free Software License Agreement v2.0.";
            case CECILL2_1: return "CeCILL Free Software License Agreement v2.1.";
            case CECILLB: return "CeCILL-B Free Software License Agreement.";
            case CECILLC: return "CeCILL-C Free Software License Agreement.";
            case CLARTISTIC: return "Clarified Artistic License.";
            case CNRIJYTHON: return "CNRI Jython License.";
            case CNRIPYTHONGPLCOMPATIBLE: return "CNRI Python Open Source GPL Compatible License Agreement.";
            case CNRIPYTHON: return "CNRI Python License.";
            case CONDOR1_1: return "Condor Public License v1.1.";
            case CPAL1_0: return "Common Public Attribution License 1.0.";
            case CPL1_0: return "Common Public License 1.0.";
            case CPOL1_02: return "Code Project Open License 1.02.";
            case CROSSWORD: return "Crossword License.";
            case CRYSTALSTACKER: return "CrystalStacker License.";
            case CUAOPL1_0: return "CUA Office Public License v1.0.";
            case CUBE: return "Cube License.";
            case CURL: return "curl License.";
            case DFSL1_0: return "Deutsche Freie Software Lizenz.";
            case DIFFMARK: return "diffmark license.";
            case DOC: return "DOC License.";
            case DOTSEQN: return "Dotseqn License.";
            case DSDP: return "DSDP License.";
            case DVIPDFM: return "dvipdfm License.";
            case ECL1_0: return "Educational Community License v1.0.";
            case ECL2_0: return "Educational Community License v2.0.";
            case EFL1_0: return "Eiffel Forum License v1.0.";
            case EFL2_0: return "Eiffel Forum License v2.0.";
            case EGENIX: return "eGenix.com Public License 1.1.0.";
            case ENTESSA: return "Entessa Public License v1.0.";
            case EPL1_0: return "Eclipse Public License 1.0.";
            case EPL2_0: return "Eclipse Public License 2.0.";
            case ERLPL1_1: return "Erlang Public License v1.1.";
            case EUDATAGRID: return "EU DataGrid Software License.";
            case EUPL1_0: return "European Union Public License 1.0.";
            case EUPL1_1: return "European Union Public License 1.1.";
            case EUPL1_2: return "European Union Public License 1.2.";
            case EUROSYM: return "Eurosym License.";
            case FAIR: return "Fair License.";
            case FRAMEWORX1_0: return "Frameworx Open License 1.0.";
            case FREEIMAGE: return "FreeImage Public License v1.0.";
            case FSFAP: return "FSF All Permissive License.";
            case FSFUL: return "FSF Unlimited License.";
            case FSFULLR: return "FSF Unlimited License (with License Retention).";
            case FTL: return "Freetype Project License.";
            case GFDL1_1ONLY: return "GNU Free Documentation License v1.1 only.";
            case GFDL1_1ORLATER: return "GNU Free Documentation License v1.1 or later.";
            case GFDL1_2ONLY: return "GNU Free Documentation License v1.2 only.";
            case GFDL1_2ORLATER: return "GNU Free Documentation License v1.2 or later.";
            case GFDL1_3ONLY: return "GNU Free Documentation License v1.3 only.";
            case GFDL1_3ORLATER: return "GNU Free Documentation License v1.3 or later.";
            case GIFTWARE: return "Giftware License.";
            case GL2PS: return "GL2PS License.";
            case GLIDE: return "3dfx Glide License.";
            case GLULXE: return "Glulxe License.";
            case GNUPLOT: return "gnuplot License.";
            case GPL1_0ONLY: return "GNU General Public License v1.0 only.";
            case GPL1_0ORLATER: return "GNU General Public License v1.0 or later.";
            case GPL2_0ONLY: return "GNU General Public License v2.0 only.";
            case GPL2_0ORLATER: return "GNU General Public License v2.0 or later.";
            case GPL3_0ONLY: return "GNU General Public License v3.0 only.";
            case GPL3_0ORLATER: return "GNU General Public License v3.0 or later.";
            case GSOAP1_3B: return "gSOAP Public License v1.3b.";
            case HASKELLREPORT: return "Haskell Language Report License.";
            case HPND: return "Historical Permission Notice and Disclaimer.";
            case IBMPIBS: return "IBM PowerPC Initialization and Boot Software.";
            case ICU: return "ICU License.";
            case IJG: return "Independent JPEG Group License.";
            case IMAGEMAGICK: return "ImageMagick License.";
            case IMATIX: return "iMatix Standard Function Library Agreement.";
            case IMLIB2: return "Imlib2 License.";
            case INFOZIP: return "Info-ZIP License.";
            case INTELACPI: return "Intel ACPI Software License Agreement.";
            case INTEL: return "Intel Open Source License.";
            case INTERBASE1_0: return "Interbase Public License v1.0.";
            case IPA: return "IPA Font License.";
            case IPL1_0: return "IBM Public License v1.0.";
            case ISC: return "ISC License.";
            case JASPER2_0: return "JasPer License.";
            case JSON: return "JSON License.";
            case LAL1_2: return "Licence Art Libre 1.2.";
            case LAL1_3: return "Licence Art Libre 1.3.";
            case LATEX2E: return "Latex2e License.";
            case LEPTONICA: return "Leptonica License.";
            case LGPL2_0ONLY: return "GNU Library General Public License v2 only.";
            case LGPL2_0ORLATER: return "GNU Library General Public License v2 or later.";
            case LGPL2_1ONLY: return "GNU Lesser General Public License v2.1 only.";
            case LGPL2_1ORLATER: return "GNU Lesser General Public License v2.1 or later.";
            case LGPL3_0ONLY: return "GNU Lesser General Public License v3.0 only.";
            case LGPL3_0ORLATER: return "GNU Lesser General Public License v3.0 or later.";
            case LGPLLR: return "Lesser General Public License For Linguistic Resources.";
            case LIBPNG: return "libpng License.";
            case LIBTIFF: return "libtiff License.";
            case LILIQP1_1: return "Licence Libre du Québec – Permissive version 1.1.";
            case LILIQR1_1: return "Licence Libre du Québec – Réciprocité version 1.1.";
            case LILIQRPLUS1_1: return "Licence Libre du Québec – Réciprocité forte version 1.1.";
            case LINUXOPENIB: return "Linux Kernel Variant of OpenIB.org license.";
            case LPL1_0: return "Lucent Public License Version 1.0.";
            case LPL1_02: return "Lucent Public License v1.02.";
            case LPPL1_0: return "LaTeX Project Public License v1.0.";
            case LPPL1_1: return "LaTeX Project Public License v1.1.";
            case LPPL1_2: return "LaTeX Project Public License v1.2.";
            case LPPL1_3A: return "LaTeX Project Public License v1.3a.";
            case LPPL1_3C: return "LaTeX Project Public License v1.3c.";
            case MAKEINDEX: return "MakeIndex License.";
            case MIROS: return "MirOS License.";
            case MIT0: return "MIT No Attribution.";
            case MITADVERTISING: return "Enlightenment License (e16).";
            case MITCMU: return "CMU License.";
            case MITENNA: return "enna License.";
            case MITFEH: return "feh License.";
            case MIT: return "MIT License.";
            case MITNFA: return "MIT +no-false-attribs license.";
            case MOTOSOTO: return "Motosoto License.";
            case MPICH2: return "mpich2 License.";
            case MPL1_0: return "Mozilla Public License 1.0.";
            case MPL1_1: return "Mozilla Public License 1.1.";
            case MPL2_0NOCOPYLEFTEXCEPTION: return "Mozilla Public License 2.0 (no copyleft exception).";
            case MPL2_0: return "Mozilla Public License 2.0.";
            case MSPL: return "Microsoft Public License.";
            case MSRL: return "Microsoft Reciprocal License.";
            case MTLL: return "Matrix Template Library License.";
            case MULTICS: return "Multics License.";
            case MUP: return "Mup License.";
            case NASA1_3: return "NASA Open Source Agreement 1.3.";
            case NAUMEN: return "Naumen Public License.";
            case NBPL1_0: return "Net Boolean Public License v1.";
            case NCSA: return "University of Illinois/NCSA Open Source License.";
            case NETSNMP: return "Net-SNMP License.";
            case NETCDF: return "NetCDF license.";
            case NEWSLETR: return "Newsletr License.";
            case NGPL: return "Nethack General Public License.";
            case NLOD1_0: return "Norwegian Licence for Open Government Data.";
            case NLPL: return "No Limit Public License.";
            case NOKIA: return "Nokia Open Source License.";
            case NOSL: return "Netizen Open Source License.";
            case NOWEB: return "Noweb License.";
            case NPL1_0: return "Netscape Public License v1.0.";
            case NPL1_1: return "Netscape Public License v1.1.";
            case NPOSL3_0: return "Non-Profit Open Software License 3.0.";
            case NRL: return "NRL License.";
            case NTP: return "NTP License.";
            case OCCTPL: return "Open CASCADE Technology Public License.";
            case OCLC2_0: return "OCLC Research Public License 2.0.";
            case ODBL1_0: return "ODC Open Database License v1.0.";
            case OFL1_0: return "SIL Open Font License 1.0.";
            case OFL1_1: return "SIL Open Font License 1.1.";
            case OGTSL: return "Open Group Test Suite License.";
            case OLDAP1_1: return "Open LDAP Public License v1.1.";
            case OLDAP1_2: return "Open LDAP Public License v1.2.";
            case OLDAP1_3: return "Open LDAP Public License v1.3.";
            case OLDAP1_4: return "Open LDAP Public License v1.4.";
            case OLDAP2_0_1: return "Open LDAP Public License v2.0.1.";
            case OLDAP2_0: return "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B).";
            case OLDAP2_1: return "Open LDAP Public License v2.1.";
            case OLDAP2_2_1: return "Open LDAP Public License v2.2.1.";
            case OLDAP2_2_2: return "Open LDAP Public License 2.2.2.";
            case OLDAP2_2: return "Open LDAP Public License v2.2.";
            case OLDAP2_3: return "Open LDAP Public License v2.3.";
            case OLDAP2_4: return "Open LDAP Public License v2.4.";
            case OLDAP2_5: return "Open LDAP Public License v2.5.";
            case OLDAP2_6: return "Open LDAP Public License v2.6.";
            case OLDAP2_7: return "Open LDAP Public License v2.7.";
            case OLDAP2_8: return "Open LDAP Public License v2.8.";
            case OML: return "Open Market License.";
            case OPENSSL: return "OpenSSL License.";
            case OPL1_0: return "Open Public License v1.0.";
            case OSETPL2_1: return "OSET Public License version 2.1.";
            case OSL1_0: return "Open Software License 1.0.";
            case OSL1_1: return "Open Software License 1.1.";
            case OSL2_0: return "Open Software License 2.0.";
            case OSL2_1: return "Open Software License 2.1.";
            case OSL3_0: return "Open Software License 3.0.";
            case PDDL1_0: return "ODC Public Domain Dedication & License 1.0.";
            case PHP3_0: return "PHP License v3.0.";
            case PHP3_01: return "PHP License v3.01.";
            case PLEXUS: return "Plexus Classworlds License.";
            case POSTGRESQL: return "PostgreSQL License.";
            case PSFRAG: return "psfrag License.";
            case PSUTILS: return "psutils License.";
            case PYTHON2_0: return "Python License 2.0.";
            case QHULL: return "Qhull License.";
            case QPL1_0: return "Q Public License 1.0.";
            case RDISC: return "Rdisc License.";
            case RHECOS1_1: return "Red Hat eCos Public License v1.1.";
            case RPL1_1: return "Reciprocal Public License 1.1.";
            case RPL1_5: return "Reciprocal Public License 1.5.";
            case RPSL1_0: return "RealNetworks Public Source License v1.0.";
            case RSAMD: return "RSA Message-Digest License.";
            case RSCPL: return "Ricoh Source Code Public License.";
            case RUBY: return "Ruby License.";
            case SAXPD: return "Sax Public Domain Notice.";
            case SAXPATH: return "Saxpath License.";
            case SCEA: return "SCEA Shared Source License.";
            case SENDMAIL: return "Sendmail License.";
            case SGIB1_0: return "SGI Free Software License B v1.0.";
            case SGIB1_1: return "SGI Free Software License B v1.1.";
            case SGIB2_0: return "SGI Free Software License B v2.0.";
            case SIMPL2_0: return "Simple Public License 2.0.";
            case SISSL1_2: return "Sun Industry Standards Source License v1.2.";
            case SISSL: return "Sun Industry Standards Source License v1.1.";
            case SLEEPYCAT: return "Sleepycat License.";
            case SMLNJ: return "Standard ML of New Jersey License.";
            case SMPPL: return "Secure Messaging Protocol Public License.";
            case SNIA: return "SNIA Public License 1.1.";
            case SPENCER86: return "Spencer License 86.";
            case SPENCER94: return "Spencer License 94.";
            case SPENCER99: return "Spencer License 99.";
            case SPL1_0: return "Sun Public License v1.0.";
            case SUGARCRM1_1_3: return "SugarCRM Public License v1.1.3.";
            case SWL: return "Scheme Widget Library (SWL) Software License Agreement.";
            case TCL: return "TCL/TK License.";
            case TCPWRAPPERS: return "TCP Wrappers License.";
            case TMATE: return "TMate Open Source License.";
            case TORQUE1_1: return "TORQUE v2.5+ Software License v1.1.";
            case TOSL: return "Trusster Open Source License.";
            case UNICODEDFS2015: return "Unicode License Agreement - Data Files and Software (2015).";
            case UNICODEDFS2016: return "Unicode License Agreement - Data Files and Software (2016).";
            case UNICODETOU: return "Unicode Terms of Use.";
            case UNLICENSE: return "The Unlicense.";
            case UPL1_0: return "Universal Permissive License v1.0.";
            case VIM: return "Vim License.";
            case VOSTROM: return "VOSTROM Public License for Open Source.";
            case VSL1_0: return "Vovida Software License v1.0.";
            case W3C19980720: return "W3C Software Notice and License (1998-07-20).";
            case W3C20150513: return "W3C Software Notice and Document License (2015-05-13).";
            case W3C: return "W3C Software Notice and License (2002-12-31).";
            case WATCOM1_0: return "Sybase Open Watcom Public License 1.0.";
            case WSUIPA: return "Wsuipa License.";
            case WTFPL: return "Do What The F*ck You Want To Public License.";
            case X11: return "X11 License.";
            case XEROX: return "Xerox License.";
            case XFREE861_1: return "XFree86 License 1.1.";
            case XINETD: return "xinetd License.";
            case XNET: return "X.Net License.";
            case XPP: return "XPP License.";
            case XSKAT: return "XSkat License.";
            case YPL1_0: return "Yahoo! Public License v1.0.";
            case YPL1_1: return "Yahoo! Public License v1.1.";
            case ZED: return "Zed License.";
            case ZEND2_0: return "Zend License v2.0.";
            case ZIMBRA1_3: return "Zimbra Public License v1.3.";
            case ZIMBRA1_4: return "Zimbra Public License v1.4.";
            case ZLIBACKNOWLEDGEMENT: return "zlib/libpng License with Acknowledgement.";
            case ZLIB: return "zlib License.";
            case ZPL1_1: return "Zope Public License 1.1.";
            case ZPL2_0: return "Zope Public License 2.0.";
            case ZPL2_1: return "Zope Public License 2.1.";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case NOTOPENSOURCE: return "Not open source";
            case _0BSD: return "BSD Zero Clause License";
            case AAL: return "Attribution Assurance License";
            case ABSTYLES: return "Abstyles License";
            case ADOBE2006: return "Adobe Systems Incorporated Source Code License Agreement";
            case ADOBEGLYPH: return "Adobe Glyph List License";
            case ADSL: return "Amazon Digital Services License";
            case AFL1_1: return "Academic Free License v1.1";
            case AFL1_2: return "Academic Free License v1.2";
            case AFL2_0: return "Academic Free License v2.0";
            case AFL2_1: return "Academic Free License v2.1";
            case AFL3_0: return "Academic Free License v3.0";
            case AFMPARSE: return "Afmparse License";
            case AGPL1_0ONLY: return "Affero General Public License v1.0 only";
            case AGPL1_0ORLATER: return "Affero General Public License v1.0 or later";
            case AGPL3_0ONLY: return "GNU Affero General Public License v3.0 only";
            case AGPL3_0ORLATER: return "GNU Affero General Public License v3.0 or later";
            case ALADDIN: return "Aladdin Free Public License";
            case AMDPLPA: return "AMD's plpa_map.c License";
            case AML: return "Apple MIT License";
            case AMPAS: return "Academy of Motion Picture Arts and Sciences BSD";
            case ANTLRPD: return "ANTLR Software Rights Notice";
            case APACHE1_0: return "Apache License 1.0";
            case APACHE1_1: return "Apache License 1.1";
            case APACHE2_0: return "Apache License 2.0";
            case APAFML: return "Adobe Postscript AFM License";
            case APL1_0: return "Adaptive Public License 1.0";
            case APSL1_0: return "Apple Public Source License 1.0";
            case APSL1_1: return "Apple Public Source License 1.1";
            case APSL1_2: return "Apple Public Source License 1.2";
            case APSL2_0: return "Apple Public Source License 2.0";
            case ARTISTIC1_0CL8: return "Artistic License 1.0 w/clause 8";
            case ARTISTIC1_0PERL: return "Artistic License 1.0 (Perl)";
            case ARTISTIC1_0: return "Artistic License 1.0";
            case ARTISTIC2_0: return "Artistic License 2.0";
            case BAHYPH: return "Bahyph License";
            case BARR: return "Barr License";
            case BEERWARE: return "Beerware License";
            case BITTORRENT1_0: return "BitTorrent Open Source License v1.0";
            case BITTORRENT1_1: return "BitTorrent Open Source License v1.1";
            case BORCEUX: return "Borceux license";
            case BSD1CLAUSE: return "BSD 1-Clause License";
            case BSD2CLAUSEFREEBSD: return "BSD 2-Clause FreeBSD License";
            case BSD2CLAUSENETBSD: return "BSD 2-Clause NetBSD License";
            case BSD2CLAUSEPATENT: return "BSD-2-Clause Plus Patent License";
            case BSD2CLAUSE: return "BSD 2-Clause \"Simplified\" License";
            case BSD3CLAUSEATTRIBUTION: return "BSD with attribution";
            case BSD3CLAUSECLEAR: return "BSD 3-Clause Clear License";
            case BSD3CLAUSELBNL: return "Lawrence Berkeley National Labs BSD variant license";
            case BSD3CLAUSENONUCLEARLICENSE2014: return "BSD 3-Clause No Nuclear License 2014";
            case BSD3CLAUSENONUCLEARLICENSE: return "BSD 3-Clause No Nuclear License";
            case BSD3CLAUSENONUCLEARWARRANTY: return "BSD 3-Clause No Nuclear Warranty";
            case BSD3CLAUSE: return "BSD 3-Clause \"New\" or \"Revised\" License";
            case BSD4CLAUSEUC: return "BSD-4-Clause (University of California-Specific)";
            case BSD4CLAUSE: return "BSD 4-Clause \"Original\" or \"Old\" License";
            case BSDPROTECTION: return "BSD Protection License";
            case BSDSOURCECODE: return "BSD Source Code Attribution";
            case BSL1_0: return "Boost Software License 1.0";
            case BZIP21_0_5: return "bzip2 and libbzip2 License v1.0.5";
            case BZIP21_0_6: return "bzip2 and libbzip2 License v1.0.6";
            case CALDERA: return "Caldera License";
            case CATOSL1_1: return "Computer Associates Trusted Open Source License 1.1";
            case CCBY1_0: return "Creative Commons Attribution 1.0 Generic";
            case CCBY2_0: return "Creative Commons Attribution 2.0 Generic";
            case CCBY2_5: return "Creative Commons Attribution 2.5 Generic";
            case CCBY3_0: return "Creative Commons Attribution 3.0 Unported";
            case CCBY4_0: return "Creative Commons Attribution 4.0 International";
            case CCBYNC1_0: return "Creative Commons Attribution Non Commercial 1.0 Generic";
            case CCBYNC2_0: return "Creative Commons Attribution Non Commercial 2.0 Generic";
            case CCBYNC2_5: return "Creative Commons Attribution Non Commercial 2.5 Generic";
            case CCBYNC3_0: return "Creative Commons Attribution Non Commercial 3.0 Unported";
            case CCBYNC4_0: return "Creative Commons Attribution Non Commercial 4.0 International";
            case CCBYNCND1_0: return "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic";
            case CCBYNCND2_0: return "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic";
            case CCBYNCND2_5: return "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic";
            case CCBYNCND3_0: return "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported";
            case CCBYNCND4_0: return "Creative Commons Attribution Non Commercial No Derivatives 4.0 International";
            case CCBYNCSA1_0: return "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic";
            case CCBYNCSA2_0: return "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic";
            case CCBYNCSA2_5: return "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic";
            case CCBYNCSA3_0: return "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported";
            case CCBYNCSA4_0: return "Creative Commons Attribution Non Commercial Share Alike 4.0 International";
            case CCBYND1_0: return "Creative Commons Attribution No Derivatives 1.0 Generic";
            case CCBYND2_0: return "Creative Commons Attribution No Derivatives 2.0 Generic";
            case CCBYND2_5: return "Creative Commons Attribution No Derivatives 2.5 Generic";
            case CCBYND3_0: return "Creative Commons Attribution No Derivatives 3.0 Unported";
            case CCBYND4_0: return "Creative Commons Attribution No Derivatives 4.0 International";
            case CCBYSA1_0: return "Creative Commons Attribution Share Alike 1.0 Generic";
            case CCBYSA2_0: return "Creative Commons Attribution Share Alike 2.0 Generic";
            case CCBYSA2_5: return "Creative Commons Attribution Share Alike 2.5 Generic";
            case CCBYSA3_0: return "Creative Commons Attribution Share Alike 3.0 Unported";
            case CCBYSA4_0: return "Creative Commons Attribution Share Alike 4.0 International";
            case CC01_0: return "Creative Commons Zero v1.0 Universal";
            case CDDL1_0: return "Common Development and Distribution License 1.0";
            case CDDL1_1: return "Common Development and Distribution License 1.1";
            case CDLAPERMISSIVE1_0: return "Community Data License Agreement Permissive 1.0";
            case CDLASHARING1_0: return "Community Data License Agreement Sharing 1.0";
            case CECILL1_0: return "CeCILL Free Software License Agreement v1.0";
            case CECILL1_1: return "CeCILL Free Software License Agreement v1.1";
            case CECILL2_0: return "CeCILL Free Software License Agreement v2.0";
            case CECILL2_1: return "CeCILL Free Software License Agreement v2.1";
            case CECILLB: return "CeCILL-B Free Software License Agreement";
            case CECILLC: return "CeCILL-C Free Software License Agreement";
            case CLARTISTIC: return "Clarified Artistic License";
            case CNRIJYTHON: return "CNRI Jython License";
            case CNRIPYTHONGPLCOMPATIBLE: return "CNRI Python Open Source GPL Compatible License Agreement";
            case CNRIPYTHON: return "CNRI Python License";
            case CONDOR1_1: return "Condor Public License v1.1";
            case CPAL1_0: return "Common Public Attribution License 1.0";
            case CPL1_0: return "Common Public License 1.0";
            case CPOL1_02: return "Code Project Open License 1.02";
            case CROSSWORD: return "Crossword License";
            case CRYSTALSTACKER: return "CrystalStacker License";
            case CUAOPL1_0: return "CUA Office Public License v1.0";
            case CUBE: return "Cube License";
            case CURL: return "curl License";
            case DFSL1_0: return "Deutsche Freie Software Lizenz";
            case DIFFMARK: return "diffmark license";
            case DOC: return "DOC License";
            case DOTSEQN: return "Dotseqn License";
            case DSDP: return "DSDP License";
            case DVIPDFM: return "dvipdfm License";
            case ECL1_0: return "Educational Community License v1.0";
            case ECL2_0: return "Educational Community License v2.0";
            case EFL1_0: return "Eiffel Forum License v1.0";
            case EFL2_0: return "Eiffel Forum License v2.0";
            case EGENIX: return "eGenix.com Public License 1.1.0";
            case ENTESSA: return "Entessa Public License v1.0";
            case EPL1_0: return "Eclipse Public License 1.0";
            case EPL2_0: return "Eclipse Public License 2.0";
            case ERLPL1_1: return "Erlang Public License v1.1";
            case EUDATAGRID: return "EU DataGrid Software License";
            case EUPL1_0: return "European Union Public License 1.0";
            case EUPL1_1: return "European Union Public License 1.1";
            case EUPL1_2: return "European Union Public License 1.2";
            case EUROSYM: return "Eurosym License";
            case FAIR: return "Fair License";
            case FRAMEWORX1_0: return "Frameworx Open License 1.0";
            case FREEIMAGE: return "FreeImage Public License v1.0";
            case FSFAP: return "FSF All Permissive License";
            case FSFUL: return "FSF Unlimited License";
            case FSFULLR: return "FSF Unlimited License (with License Retention)";
            case FTL: return "Freetype Project License";
            case GFDL1_1ONLY: return "GNU Free Documentation License v1.1 only";
            case GFDL1_1ORLATER: return "GNU Free Documentation License v1.1 or later";
            case GFDL1_2ONLY: return "GNU Free Documentation License v1.2 only";
            case GFDL1_2ORLATER: return "GNU Free Documentation License v1.2 or later";
            case GFDL1_3ONLY: return "GNU Free Documentation License v1.3 only";
            case GFDL1_3ORLATER: return "GNU Free Documentation License v1.3 or later";
            case GIFTWARE: return "Giftware License";
            case GL2PS: return "GL2PS License";
            case GLIDE: return "3dfx Glide License";
            case GLULXE: return "Glulxe License";
            case GNUPLOT: return "gnuplot License";
            case GPL1_0ONLY: return "GNU General Public License v1.0 only";
            case GPL1_0ORLATER: return "GNU General Public License v1.0 or later";
            case GPL2_0ONLY: return "GNU General Public License v2.0 only";
            case GPL2_0ORLATER: return "GNU General Public License v2.0 or later";
            case GPL3_0ONLY: return "GNU General Public License v3.0 only";
            case GPL3_0ORLATER: return "GNU General Public License v3.0 or later";
            case GSOAP1_3B: return "gSOAP Public License v1.3b";
            case HASKELLREPORT: return "Haskell Language Report License";
            case HPND: return "Historical Permission Notice and Disclaimer";
            case IBMPIBS: return "IBM PowerPC Initialization and Boot Software";
            case ICU: return "ICU License";
            case IJG: return "Independent JPEG Group License";
            case IMAGEMAGICK: return "ImageMagick License";
            case IMATIX: return "iMatix Standard Function Library Agreement";
            case IMLIB2: return "Imlib2 License";
            case INFOZIP: return "Info-ZIP License";
            case INTELACPI: return "Intel ACPI Software License Agreement";
            case INTEL: return "Intel Open Source License";
            case INTERBASE1_0: return "Interbase Public License v1.0";
            case IPA: return "IPA Font License";
            case IPL1_0: return "IBM Public License v1.0";
            case ISC: return "ISC License";
            case JASPER2_0: return "JasPer License";
            case JSON: return "JSON License";
            case LAL1_2: return "Licence Art Libre 1.2";
            case LAL1_3: return "Licence Art Libre 1.3";
            case LATEX2E: return "Latex2e License";
            case LEPTONICA: return "Leptonica License";
            case LGPL2_0ONLY: return "GNU Library General Public License v2 only";
            case LGPL2_0ORLATER: return "GNU Library General Public License v2 or later";
            case LGPL2_1ONLY: return "GNU Lesser General Public License v2.1 only";
            case LGPL2_1ORLATER: return "GNU Lesser General Public License v2.1 or later";
            case LGPL3_0ONLY: return "GNU Lesser General Public License v3.0 only";
            case LGPL3_0ORLATER: return "GNU Lesser General Public License v3.0 or later";
            case LGPLLR: return "Lesser General Public License For Linguistic Resources";
            case LIBPNG: return "libpng License";
            case LIBTIFF: return "libtiff License";
            case LILIQP1_1: return "Licence Libre du Québec – Permissive version 1.1";
            case LILIQR1_1: return "Licence Libre du Québec – Réciprocité version 1.1";
            case LILIQRPLUS1_1: return "Licence Libre du Québec – Réciprocité forte version 1.1";
            case LINUXOPENIB: return "Linux Kernel Variant of OpenIB.org license";
            case LPL1_0: return "Lucent Public License Version 1.0";
            case LPL1_02: return "Lucent Public License v1.02";
            case LPPL1_0: return "LaTeX Project Public License v1.0";
            case LPPL1_1: return "LaTeX Project Public License v1.1";
            case LPPL1_2: return "LaTeX Project Public License v1.2";
            case LPPL1_3A: return "LaTeX Project Public License v1.3a";
            case LPPL1_3C: return "LaTeX Project Public License v1.3c";
            case MAKEINDEX: return "MakeIndex License";
            case MIROS: return "MirOS License";
            case MIT0: return "MIT No Attribution";
            case MITADVERTISING: return "Enlightenment License (e16)";
            case MITCMU: return "CMU License";
            case MITENNA: return "enna License";
            case MITFEH: return "feh License";
            case MIT: return "MIT License";
            case MITNFA: return "MIT +no-false-attribs license";
            case MOTOSOTO: return "Motosoto License";
            case MPICH2: return "mpich2 License";
            case MPL1_0: return "Mozilla Public License 1.0";
            case MPL1_1: return "Mozilla Public License 1.1";
            case MPL2_0NOCOPYLEFTEXCEPTION: return "Mozilla Public License 2.0 (no copyleft exception)";
            case MPL2_0: return "Mozilla Public License 2.0";
            case MSPL: return "Microsoft Public License";
            case MSRL: return "Microsoft Reciprocal License";
            case MTLL: return "Matrix Template Library License";
            case MULTICS: return "Multics License";
            case MUP: return "Mup License";
            case NASA1_3: return "NASA Open Source Agreement 1.3";
            case NAUMEN: return "Naumen Public License";
            case NBPL1_0: return "Net Boolean Public License v1";
            case NCSA: return "University of Illinois/NCSA Open Source License";
            case NETSNMP: return "Net-SNMP License";
            case NETCDF: return "NetCDF license";
            case NEWSLETR: return "Newsletr License";
            case NGPL: return "Nethack General Public License";
            case NLOD1_0: return "Norwegian Licence for Open Government Data";
            case NLPL: return "No Limit Public License";
            case NOKIA: return "Nokia Open Source License";
            case NOSL: return "Netizen Open Source License";
            case NOWEB: return "Noweb License";
            case NPL1_0: return "Netscape Public License v1.0";
            case NPL1_1: return "Netscape Public License v1.1";
            case NPOSL3_0: return "Non-Profit Open Software License 3.0";
            case NRL: return "NRL License";
            case NTP: return "NTP License";
            case OCCTPL: return "Open CASCADE Technology Public License";
            case OCLC2_0: return "OCLC Research Public License 2.0";
            case ODBL1_0: return "ODC Open Database License v1.0";
            case OFL1_0: return "SIL Open Font License 1.0";
            case OFL1_1: return "SIL Open Font License 1.1";
            case OGTSL: return "Open Group Test Suite License";
            case OLDAP1_1: return "Open LDAP Public License v1.1";
            case OLDAP1_2: return "Open LDAP Public License v1.2";
            case OLDAP1_3: return "Open LDAP Public License v1.3";
            case OLDAP1_4: return "Open LDAP Public License v1.4";
            case OLDAP2_0_1: return "Open LDAP Public License v2.0.1";
            case OLDAP2_0: return "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)";
            case OLDAP2_1: return "Open LDAP Public License v2.1";
            case OLDAP2_2_1: return "Open LDAP Public License v2.2.1";
            case OLDAP2_2_2: return "Open LDAP Public License 2.2.2";
            case OLDAP2_2: return "Open LDAP Public License v2.2";
            case OLDAP2_3: return "Open LDAP Public License v2.3";
            case OLDAP2_4: return "Open LDAP Public License v2.4";
            case OLDAP2_5: return "Open LDAP Public License v2.5";
            case OLDAP2_6: return "Open LDAP Public License v2.6";
            case OLDAP2_7: return "Open LDAP Public License v2.7";
            case OLDAP2_8: return "Open LDAP Public License v2.8";
            case OML: return "Open Market License";
            case OPENSSL: return "OpenSSL License";
            case OPL1_0: return "Open Public License v1.0";
            case OSETPL2_1: return "OSET Public License version 2.1";
            case OSL1_0: return "Open Software License 1.0";
            case OSL1_1: return "Open Software License 1.1";
            case OSL2_0: return "Open Software License 2.0";
            case OSL2_1: return "Open Software License 2.1";
            case OSL3_0: return "Open Software License 3.0";
            case PDDL1_0: return "ODC Public Domain Dedication & License 1.0";
            case PHP3_0: return "PHP License v3.0";
            case PHP3_01: return "PHP License v3.01";
            case PLEXUS: return "Plexus Classworlds License";
            case POSTGRESQL: return "PostgreSQL License";
            case PSFRAG: return "psfrag License";
            case PSUTILS: return "psutils License";
            case PYTHON2_0: return "Python License 2.0";
            case QHULL: return "Qhull License";
            case QPL1_0: return "Q Public License 1.0";
            case RDISC: return "Rdisc License";
            case RHECOS1_1: return "Red Hat eCos Public License v1.1";
            case RPL1_1: return "Reciprocal Public License 1.1";
            case RPL1_5: return "Reciprocal Public License 1.5";
            case RPSL1_0: return "RealNetworks Public Source License v1.0";
            case RSAMD: return "RSA Message-Digest License";
            case RSCPL: return "Ricoh Source Code Public License";
            case RUBY: return "Ruby License";
            case SAXPD: return "Sax Public Domain Notice";
            case SAXPATH: return "Saxpath License";
            case SCEA: return "SCEA Shared Source License";
            case SENDMAIL: return "Sendmail License";
            case SGIB1_0: return "SGI Free Software License B v1.0";
            case SGIB1_1: return "SGI Free Software License B v1.1";
            case SGIB2_0: return "SGI Free Software License B v2.0";
            case SIMPL2_0: return "Simple Public License 2.0";
            case SISSL1_2: return "Sun Industry Standards Source License v1.2";
            case SISSL: return "Sun Industry Standards Source License v1.1";
            case SLEEPYCAT: return "Sleepycat License";
            case SMLNJ: return "Standard ML of New Jersey License";
            case SMPPL: return "Secure Messaging Protocol Public License";
            case SNIA: return "SNIA Public License 1.1";
            case SPENCER86: return "Spencer License 86";
            case SPENCER94: return "Spencer License 94";
            case SPENCER99: return "Spencer License 99";
            case SPL1_0: return "Sun Public License v1.0";
            case SUGARCRM1_1_3: return "SugarCRM Public License v1.1.3";
            case SWL: return "Scheme Widget Library (SWL) Software License Agreement";
            case TCL: return "TCL/TK License";
            case TCPWRAPPERS: return "TCP Wrappers License";
            case TMATE: return "TMate Open Source License";
            case TORQUE1_1: return "TORQUE v2.5+ Software License v1.1";
            case TOSL: return "Trusster Open Source License";
            case UNICODEDFS2015: return "Unicode License Agreement - Data Files and Software (2015)";
            case UNICODEDFS2016: return "Unicode License Agreement - Data Files and Software (2016)";
            case UNICODETOU: return "Unicode Terms of Use";
            case UNLICENSE: return "The Unlicense";
            case UPL1_0: return "Universal Permissive License v1.0";
            case VIM: return "Vim License";
            case VOSTROM: return "VOSTROM Public License for Open Source";
            case VSL1_0: return "Vovida Software License v1.0";
            case W3C19980720: return "W3C Software Notice and License (1998-07-20)";
            case W3C20150513: return "W3C Software Notice and Document License (2015-05-13)";
            case W3C: return "W3C Software Notice and License (2002-12-31)";
            case WATCOM1_0: return "Sybase Open Watcom Public License 1.0";
            case WSUIPA: return "Wsuipa License";
            case WTFPL: return "Do What The F*ck You Want To Public License";
            case X11: return "X11 License";
            case XEROX: return "Xerox License";
            case XFREE861_1: return "XFree86 License 1.1";
            case XINETD: return "xinetd License";
            case XNET: return "X.Net License";
            case XPP: return "XPP License";
            case XSKAT: return "XSkat License";
            case YPL1_0: return "Yahoo! Public License v1.0";
            case YPL1_1: return "Yahoo! Public License v1.1";
            case ZED: return "Zed License";
            case ZEND2_0: return "Zend License v2.0";
            case ZIMBRA1_3: return "Zimbra Public License v1.3";
            case ZIMBRA1_4: return "Zimbra Public License v1.4";
            case ZLIBACKNOWLEDGEMENT: return "zlib/libpng License with Acknowledgement";
            case ZLIB: return "zlib License";
            case ZPL1_1: return "Zope Public License 1.1";
            case ZPL2_0: return "Zope Public License 2.0";
            case ZPL2_1: return "Zope Public License 2.1";
            default: return "?";
          }
    }


}

