/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils.client.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.utils.ResourceUtilities;
import org.hl7.fhir.dstu3.utils.client.EFhirClientException;
import org.hl7.fhir.dstu3.utils.client.ResourceFormat;
import org.hl7.fhir.dstu3.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.MimeType;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPHeaderUtil;
import org.hl7.fhir.utilities.http.HTTPRequest;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedFhirWebAccessor;
import org.hl7.fhir.utilities.http.ManagedWebAccess;

public class FhirRequestBuilder {
    protected static final String LOCATION_HEADER = "location";
    protected static final String CONTENT_LOCATION_HEADER = "content-location";
    protected static final String DEFAULT_CHARSET = "UTF-8";
    private final HTTPRequest httpRequest;
    private String resourceFormat = null;
    private Iterable<HTTPHeader> headers = null;
    private String message = null;
    private int retryCount = 1;
    private long timeout = 5000L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private ToolingClientLogger logger = null;
    private String source;

    public FhirRequestBuilder(HTTPRequest httpRequest, String source) {
        this.httpRequest = httpRequest;
        this.source = source;
    }

    protected static HTTPRequest formatHeaders(HTTPRequest request, String format, Iterable<HTTPHeader> headers) {
        ArrayList allHeaders = new ArrayList();
        request.getHeaders().forEach(allHeaders::add);
        if (format != null) {
            FhirRequestBuilder.getResourceFormatHeaders(request, format).forEach(allHeaders::add);
        }
        if (headers != null) {
            headers.forEach(allHeaders::add);
        }
        return request.withHeaders(allHeaders);
    }

    protected static Iterable<HTTPHeader> getResourceFormatHeaders(HTTPRequest httpRequest, String format) {
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        headers.add(new HTTPHeader("Accept", format));
        if (httpRequest.getMethod() == HTTPRequest.HttpMethod.PUT || httpRequest.getMethod() == HTTPRequest.HttpMethod.POST || httpRequest.getMethod() == HTTPRequest.HttpMethod.PATCH) {
            headers.add(new HTTPHeader("Content-Type", format + ";charset=UTF-8"));
        }
        return headers;
    }

    protected static boolean hasError(OperationOutcome oo) {
        return oo.getIssue().stream().anyMatch(issue -> issue.getSeverity() == OperationOutcome.IssueSeverity.ERROR || issue.getSeverity() == OperationOutcome.IssueSeverity.FATAL);
    }

    protected static String getLocationHeader(Iterable<HTTPHeader> headers) {
        String locationHeader = HTTPHeaderUtil.getSingleHeader(headers, (String)LOCATION_HEADER);
        if (locationHeader != null) {
            return locationHeader;
        }
        return HTTPHeaderUtil.getSingleHeader(headers, (String)CONTENT_LOCATION_HEADER);
    }

    protected ManagedFhirWebAccessor getManagedWebAccessor() {
        return ManagedWebAccess.fhirAccessor().withRetries(this.retryCount).withTimeout(this.timeout, this.timeoutUnit).withLogger(this.logger);
    }

    public FhirRequestBuilder withResourceFormat(String resourceFormat) {
        this.resourceFormat = resourceFormat;
        return this;
    }

    public FhirRequestBuilder withHeaders(Iterable<HTTPHeader> headers) {
        this.headers = headers;
        return this;
    }

    public FhirRequestBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public FhirRequestBuilder withRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public FhirRequestBuilder withLogger(ToolingClientLogger logger) {
        this.logger = logger;
        return this;
    }

    public FhirRequestBuilder withTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    public <T extends Resource> ResourceRequest<T> execute() throws IOException {
        HTTPRequest requestWithHeaders = FhirRequestBuilder.formatHeaders(this.httpRequest, this.resourceFormat, this.headers);
        HTTPResult response = this.getManagedWebAccessor().httpCall(requestWithHeaders);
        T resource = this.unmarshalReference(response, this.resourceFormat);
        return new ResourceRequest<T>(resource, response.getCode(), FhirRequestBuilder.getLocationHeader(response.getHeaders()));
    }

    public Bundle executeAsBatch() throws IOException {
        HTTPRequest requestWithHeaders = FhirRequestBuilder.formatHeaders(this.httpRequest, this.resourceFormat, null);
        HTTPResult response = this.getManagedWebAccessor().httpCall(requestWithHeaders);
        return this.unmarshalFeed(response, this.resourceFormat);
    }

    protected <T extends Resource> T unmarshalReference(HTTPResult response, String format) {
        Resource resource = null;
        OperationOutcome error = null;
        if (response.getContent() != null) {
            try {
                byte[] body = response.getContent();
                resource = this.getParser(format).parse(body);
                if (resource instanceof OperationOutcome && FhirRequestBuilder.hasError((OperationOutcome)resource)) {
                    error = (OperationOutcome)resource;
                }
            }
            catch (IOException ioe) {
                throw new EFhirClientException(0, "Error reading Http Response from " + this.source + ": " + ioe.getMessage(), ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException(0, "Error parsing response message from " + this.source + ": " + e.getMessage(), e);
            }
        }
        if (error != null) {
            throw new EFhirClientException(0, "Error from server: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return (T)resource;
    }

    protected Bundle unmarshalFeed(HTTPResult response, String format) {
        OperationOutcome error;
        Bundle feed;
        block6: {
            feed = null;
            error = null;
            try {
                byte[] body = response.getContent();
                String contentType = HTTPHeaderUtil.getSingleHeader((Iterable)response.getHeaders(), (String)"Content-Type");
                if (body == null || !contentType.contains(ResourceFormat.RESOURCE_XML.getHeader()) && !contentType.contains(ResourceFormat.RESOURCE_JSON.getHeader()) && !contentType.contains("text/xml+fhir")) break block6;
                Resource rf = this.getParser(format).parse(body);
                if (rf instanceof Bundle) {
                    feed = (Bundle)rf;
                    break block6;
                }
                if (rf instanceof OperationOutcome && FhirRequestBuilder.hasError((OperationOutcome)rf)) {
                    error = (OperationOutcome)rf;
                    break block6;
                }
                throw new EFhirClientException("Error reading server response: a resource was returned instead");
            }
            catch (IOException ioe) {
                throw new EFhirClientException(0, "Error reading Http Response from " + this.source + ": " + ioe.getMessage(), ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException(0, "Error parsing response message from " + this.source + ":" + e.getMessage(), e);
            }
        }
        if (error != null) {
            throw new EFhirClientException(0, "Error from " + this.source + ": " + ResourceUtilities.getErrorDescription(error), error);
        }
        return feed;
    }

    protected IParser getParser(String format) {
        MimeType mt;
        if (StringUtils.isBlank((CharSequence)format)) {
            format = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if ((mt = new MimeType(format)).getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader())) {
            return new JsonParser();
        }
        if (mt.getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException("Invalid format: " + format);
    }

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ToolingClientLogger logger) {
        this.logger = logger;
    }
}

