/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.EndpointStatus;

public class EndpointStatusEnumFactory
implements EnumFactory<EndpointStatus> {
    @Override
    public EndpointStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return EndpointStatus.ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return EndpointStatus.SUSPENDED;
        }
        if ("error".equals(codeString)) {
            return EndpointStatus.ERROR;
        }
        if ("off".equals(codeString)) {
            return EndpointStatus.OFF;
        }
        if ("entered-in-error".equals(codeString)) {
            return EndpointStatus.ENTEREDINERROR;
        }
        if ("test".equals(codeString)) {
            return EndpointStatus.TEST;
        }
        throw new IllegalArgumentException("Unknown EndpointStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(EndpointStatus code) {
        if (code == EndpointStatus.NULL) {
            return null;
        }
        if (code == EndpointStatus.ACTIVE) {
            return "active";
        }
        if (code == EndpointStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == EndpointStatus.ERROR) {
            return "error";
        }
        if (code == EndpointStatus.OFF) {
            return "off";
        }
        if (code == EndpointStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == EndpointStatus.TEST) {
            return "test";
        }
        return "?";
    }

    @Override
    public String toSystem(EndpointStatus code) {
        return code.getSystem();
    }
}

