/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCategory {
    AE,
    PAE,
    NULL;


    public static AdverseEventCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AE".equals(codeString)) {
            return AE;
        }
        if ("PAE".equals(codeString)) {
            return PAE;
        }
        throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AE: {
                return "AE";
            }
            case PAE: {
                return "PAE";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-category";
    }

    public String getDefinition() {
        switch (this) {
            case AE: {
                return "";
            }
            case PAE: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AE: {
                return "Adverse Event";
            }
            case PAE: {
                return "Potential Adverse Event";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

