/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.terminologies;

import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetChecker;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu3.utils.EOperationOutcome;

@Deprecated
public class ValueSetCheckerSimple
implements ValueSetChecker {
    private ValueSet valueset;
    private ValueSetExpanderFactory factory;
    private IWorkerContext context;

    public ValueSetCheckerSimple(ValueSet source, ValueSetExpanderFactory factory, IWorkerContext context) {
        this.valueset = source;
        this.factory = factory;
        this.context = context;
    }

    @Override
    public boolean codeInValueSet(String system, String code) throws EOperationOutcome, Exception {
        if (this.valueset.hasCompose()) {
            boolean ok = false;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                ok = ok || this.inComponent(vsi, system, code);
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                ok = ok && !this.inComponent(vsi, system, code);
            }
        }
        return false;
    }

    private boolean inImport(String uri, String system, String code) throws EOperationOutcome, Exception {
        ValueSet vs = this.context.fetchResource(ValueSet.class, uri);
        if (vs == null) {
            return false;
        }
        return this.codeInExpansion(this.factory.getExpander().expand(vs, null), system, code);
    }

    private boolean codeInExpansion(ValueSetExpander.ValueSetExpansionOutcome vso, String system, String code) throws EOperationOutcome, Exception {
        if (vso.getService() != null) {
            return vso.getService().codeInValueSet(system, code);
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : vso.getValueset().getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean inComponent(ValueSet.ConceptSetComponent vsi, String system, String code) throws Exception {
        if (vsi.hasSystem() && !vsi.getSystem().equals(system)) {
            return false;
        }
        for (UriType uriType : vsi.getValueSet()) {
            if (this.inImport((String)uriType.getValue(), system, code)) continue;
            return false;
        }
        if (!vsi.hasSystem()) {
            return false;
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
            if (!conceptReferenceComponent.getCode().equals(code)) continue;
            return true;
        }
        CodeSystem def = this.context.fetchCodeSystem(system);
        if (def != null && def.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE) {
            if (!def.getCaseSensitive()) {
                for (ValueSet.ConceptReferenceComponent cc2 : vsi.getConcept()) {
                    if (!cc2.getCode().equalsIgnoreCase(code)) continue;
                    return false;
                }
            }
            if (vsi.getConcept().isEmpty() && vsi.getFilter().isEmpty()) {
                return this.codeInDefine(def.getConcept(), code, def.getCaseSensitive());
            }
            Iterator<ValueSet.ConceptSetFilterComponent> iterator = vsi.getFilter().iterator();
            if (iterator.hasNext()) {
                ValueSet.ConceptSetFilterComponent f = iterator.next();
                throw new Error("not done yet: " + f.getValue());
            }
            return false;
        }
        if (this.context.supportsSystem(system)) {
            IWorkerContext.ValidationResult validationResult = this.context.validateCode(system, code, null, vsi);
            return validationResult.isOk();
        }
        return false;
    }

    private boolean codeInDefine(List<CodeSystem.ConceptDefinitionComponent> concepts, String code, boolean caseSensitive) {
        for (CodeSystem.ConceptDefinitionComponent c : concepts) {
            if (caseSensitive && code.equals(c.getCode())) {
                return true;
            }
            if (!caseSensitive && code.equalsIgnoreCase(c.getCode())) {
                return true;
            }
            if (!this.codeInDefine(c.getConcept(), code, caseSensitive)) continue;
            return true;
        }
        return false;
    }
}

