/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MetricCategory {
    MEASUREMENT,
    SETTING,
    CALCULATION,
    UNSPECIFIED,
    NULL;


    public static MetricCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("measurement".equals(codeString)) {
            return MEASUREMENT;
        }
        if ("setting".equals(codeString)) {
            return SETTING;
        }
        if ("calculation".equals(codeString)) {
            return CALCULATION;
        }
        if ("unspecified".equals(codeString)) {
            return UNSPECIFIED;
        }
        throw new FHIRException("Unknown MetricCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MEASUREMENT: {
                return "measurement";
            }
            case SETTING: {
                return "setting";
            }
            case CALCULATION: {
                return "calculation";
            }
            case UNSPECIFIED: {
                return "unspecified";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/metric-category";
    }

    public String getDefinition() {
        switch (this) {
            case MEASUREMENT: {
                return "DeviceObservations generated for this DeviceMetric are measured.";
            }
            case SETTING: {
                return "DeviceObservations generated for this DeviceMetric is a setting that will influence the behavior of the Device.";
            }
            case CALCULATION: {
                return "DeviceObservations generated for this DeviceMetric are calculated.";
            }
            case UNSPECIFIED: {
                return "The category of this DeviceMetric is unspecified.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MEASUREMENT: {
                return "Measurement";
            }
            case SETTING: {
                return "Setting";
            }
            case CALCULATION: {
                return "Calculation";
            }
            case UNSPECIFIED: {
                return "Unspecified";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

