/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCausality {
    CAUSALITY1,
    CAUSALITY2,
    NULL;


    public static AdverseEventCausality fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("causality1".equals(codeString)) {
            return CAUSALITY1;
        }
        if ("causality2".equals(codeString)) {
            return CAUSALITY2;
        }
        throw new FHIRException("Unknown AdverseEventCausality code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CAUSALITY1: {
                return "causality1";
            }
            case CAUSALITY2: {
                return "causality2";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-causality";
    }

    public String getDefinition() {
        switch (this) {
            case CAUSALITY1: {
                return "";
            }
            case CAUSALITY2: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CAUSALITY1: {
                return "causality1 placeholder";
            }
            case CAUSALITY2: {
                return "causality2 placeholder";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

