/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;

@ResourceDef(name="MedicationStatement", profile="http://hl7.org/fhir/Profile/MedicationStatement")
public class MedicationStatement
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={MedicationRequest.class, CarePlan.class, ProcedureRequest.class, ReferralRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfils plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="partOf", type={MedicationAdministration.class, MedicationDispense.class, MedicationStatement.class, Procedure.class, Observation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    protected List<Resource> partOfTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter / Episode associated with MedicationStatement", formalDefinition="The encounter or episode of care that establishes the context for this MedicationStatement.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | completed | entered-in-error | intended | stopped | on-hold", formalDefinition="A code representing the patient or other source's judgment about the state of the medication used that this statement is about.  Generally this will be active or completed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-statement-status")
    protected Enumeration<MedicationStatementStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of medication usage", formalDefinition="Indicates where type of medication statement and where the medication is expected to be consumed or administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-statement-category")
    protected CodeableConcept category;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What medication was taken", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected Type medication;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date/time or interval when the medication was taken", formalDefinition="The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).")
    protected Type effective;
    @Child(name="dateAsserted", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the statement was asserted?", formalDefinition="The date when the medication statement was asserted by the information source.")
    protected DateTimeType dateAsserted;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, RelatedPerson.class, Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Person or organization that provided the information about the taking of this medication", formalDefinition="The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g Claim or MedicationRequest.")
    protected Reference informationSource;
    protected Resource informationSourceTarget;
    @Child(name="subject", type={Patient.class, Group.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is/was taking  the medication", formalDefinition="The person, animal or group who is/was taking the medication.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="derivedFrom", type={Reference.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional supporting information", formalDefinition="Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.")
    protected List<Reference> derivedFrom;
    protected List<Resource> derivedFromTarget;
    @Child(name="taken", type={CodeType.class}, order=12, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="y | n | unk | na", formalDefinition="Indicator of the certainty of whether the medication was taken by the patient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-statement-taken")
    protected Enumeration<MedicationStatementTaken> taken;
    @Child(name="reasonNotTaken", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="True if asserting medication was not given", formalDefinition="A code indicating why the medication was not taken.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-not-taken-codes")
    protected List<CodeableConcept> reasonNotTaken;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for why the medication is being/was taken", formalDefinition="A reason for why the medication is being/was taken.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition or observation that supports why the medication is being/was taken", formalDefinition="Condition or observation that supports why the medication is being/was taken.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Further information about the statement", formalDefinition="Provides extra information about the medication statement that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosage", type={Dosage.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details of how medication is/was taken or should be taken", formalDefinition="Indicates how the medication is/was or should be taken by the patient.")
    protected List<Dosage> dosage;
    private static final long serialVersionUID = -1529480075L;
    @SearchParamDefinition(name="identifier", path="MedicationStatement.identifier", description="Return statements with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="effective", path="MedicationStatement.effective", description="Date when patient was taking (or not taking) the medication", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="code", path="MedicationStatement.medication.as(CodeableConcept)", description="Return statements of this medication code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="subject", path="MedicationStatement.subject", description="The identity of a patient, animal or group to list statements for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationStatement:subject").toLocked();
    @SearchParamDefinition(name="patient", path="MedicationStatement.subject", description="Returns statements for a specific patient.", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationStatement:patient").toLocked();
    @SearchParamDefinition(name="context", path="MedicationStatement.context", description="Returns statements for a specific context (episode or episode of Care).", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("MedicationStatement:context").toLocked();
    @SearchParamDefinition(name="medication", path="MedicationStatement.medication.as(Reference)", description="Return statements of this medication reference", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationStatement:medication").toLocked();
    @SearchParamDefinition(name="part-of", path="MedicationStatement.partOf", description="Returns statements that are part of another event.", type="reference", target={MedicationAdministration.class, MedicationDispense.class, MedicationStatement.class, Observation.class, Procedure.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("MedicationStatement:part-of").toLocked();
    @SearchParamDefinition(name="source", path="MedicationStatement.informationSource", description="Who or where the information in the statement came from", type="reference", providesMembershipIn={@Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("MedicationStatement:source").toLocked();
    @SearchParamDefinition(name="category", path="MedicationStatement.category", description="Returns statements of this category of medicationstatement", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="MedicationStatement.status", description="Return statements that match the given status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationStatement() {
    }

    public MedicationStatement(Enumeration<MedicationStatementStatus> status, Type medication, Reference subject, Enumeration<MedicationStatementTaken> taken) {
        this.status = status;
        this.medication = medication;
        this.subject = subject;
        this.taken = taken;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationStatement setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationStatement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public MedicationStatement setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public MedicationStatement addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public MedicationStatement setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public MedicationStatement addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Resource> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Resource>();
        }
        return this.partOfTarget;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public MedicationStatement setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public MedicationStatement setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Enumeration<MedicationStatementStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationStatementStatus>(new MedicationStatementStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationStatement setStatusElement(Enumeration<MedicationStatementStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationStatementStatus getStatus() {
        return this.status == null ? null : (MedicationStatementStatus)((Object)this.status.getValue());
    }

    public MedicationStatement setStatus(MedicationStatementStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationStatementStatus>(new MedicationStatementStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public MedicationStatement setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (this.medication == null) {
            return null;
        }
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this != null && this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (this.medication == null) {
            return null;
        }
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this != null && this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationStatement setMedication(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for MedicationStatement.medication[x]: " + value.fhirType());
        }
        this.medication = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            return null;
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            return null;
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public MedicationStatement setEffective(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRFormatError("Not the right type for MedicationStatement.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public DateTimeType getDateAssertedElement() {
        if (this.dateAsserted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.dateAsserted");
            }
            if (Configuration.doAutoCreate()) {
                this.dateAsserted = new DateTimeType();
            }
        }
        return this.dateAsserted;
    }

    public boolean hasDateAssertedElement() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public boolean hasDateAsserted() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public MedicationStatement setDateAssertedElement(DateTimeType value) {
        this.dateAsserted = value;
        return this;
    }

    public Date getDateAsserted() {
        return this.dateAsserted == null ? null : (Date)this.dateAsserted.getValue();
    }

    public MedicationStatement setDateAsserted(Date value) {
        if (value == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateTimeType();
            }
            this.dateAsserted.setValue(value);
        }
        return this;
    }

    public Reference getInformationSource() {
        if (this.informationSource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.informationSource");
            }
            if (Configuration.doAutoCreate()) {
                this.informationSource = new Reference();
            }
        }
        return this.informationSource;
    }

    public boolean hasInformationSource() {
        return this.informationSource != null && !this.informationSource.isEmpty();
    }

    public MedicationStatement setInformationSource(Reference value) {
        this.informationSource = value;
        return this;
    }

    public Resource getInformationSourceTarget() {
        return this.informationSourceTarget;
    }

    public MedicationStatement setInformationSourceTarget(Resource value) {
        this.informationSourceTarget = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationStatement setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public MedicationStatement setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public MedicationStatement setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public MedicationStatement addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    @Deprecated
    public List<Resource> getDerivedFromTarget() {
        if (this.derivedFromTarget == null) {
            this.derivedFromTarget = new ArrayList<Resource>();
        }
        return this.derivedFromTarget;
    }

    public Enumeration<MedicationStatementTaken> getTakenElement() {
        if (this.taken == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.taken");
            }
            if (Configuration.doAutoCreate()) {
                this.taken = new Enumeration<MedicationStatementTaken>(new MedicationStatementTakenEnumFactory());
            }
        }
        return this.taken;
    }

    public boolean hasTakenElement() {
        return this.taken != null && !this.taken.isEmpty();
    }

    public boolean hasTaken() {
        return this.taken != null && !this.taken.isEmpty();
    }

    public MedicationStatement setTakenElement(Enumeration<MedicationStatementTaken> value) {
        this.taken = value;
        return this;
    }

    public MedicationStatementTaken getTaken() {
        return this.taken == null ? null : (MedicationStatementTaken)((Object)this.taken.getValue());
    }

    public MedicationStatement setTaken(MedicationStatementTaken value) {
        if (this.taken == null) {
            this.taken = new Enumeration<MedicationStatementTaken>(new MedicationStatementTakenEnumFactory());
        }
        this.taken.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getReasonNotTaken() {
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotTaken;
    }

    public MedicationStatement setReasonNotTaken(List<CodeableConcept> theReasonNotTaken) {
        this.reasonNotTaken = theReasonNotTaken;
        return this;
    }

    public boolean hasReasonNotTaken() {
        if (this.reasonNotTaken == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonNotTaken) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonNotTaken() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        this.reasonNotTaken.add(t);
        return t;
    }

    public MedicationStatement addReasonNotTaken(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        this.reasonNotTaken.add(t);
        return this;
    }

    public CodeableConcept getReasonNotTakenFirstRep() {
        if (this.getReasonNotTaken().isEmpty()) {
            this.addReasonNotTaken();
        }
        return this.getReasonNotTaken().get(0);
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public MedicationStatement setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public MedicationStatement addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public MedicationStatement setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public MedicationStatement addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationStatement setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationStatement addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Dosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        return this.dosage;
    }

    public MedicationStatement setDosage(List<Dosage> theDosage) {
        this.dosage = theDosage;
        return this;
    }

    public boolean hasDosage() {
        if (this.dosage == null) {
            return false;
        }
        for (Dosage item : this.dosage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosage() {
        Dosage t = new Dosage();
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return t;
    }

    public MedicationStatement addDosage(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return this;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            this.addDosage();
        }
        return this.getDosage().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(MedicationRequest|CarePlan|ProcedureRequest|ReferralRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(MedicationAdministration|MedicationDispense|MedicationStatement|Procedure|Observation)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this MedicationStatement.", 0, 1, this.context));
        children.add(new Property(SP_STATUS, SP_CODE, "A code representing the patient or other source's judgment about the state of the medication used that this statement is about.  Generally this will be active or completed.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Indicates where type of medication statement and where the medication is expected to be consumed or administered.", 0, 1, this.category));
        children.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).", 0, 1, this.effective));
        children.add(new Property("dateAsserted", "dateTime", "The date when the medication statement was asserted by the information source.", 0, 1, this.dateAsserted));
        children.add(new Property("informationSource", "Reference(Patient|Practitioner|RelatedPerson|Organization)", "The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g Claim or MedicationRequest.", 0, 1, this.informationSource));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was taking the medication.", 0, 1, this.subject));
        children.add(new Property("derivedFrom", "Reference(Any)", "Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("taken", SP_CODE, "Indicator of the certainty of whether the medication was taken by the patient.", 0, 1, this.taken));
        children.add(new Property("reasonNotTaken", "CodeableConcept", "A code indicating why the medication was not taken.", 0, Integer.MAX_VALUE, this.reasonNotTaken));
        children.add(new Property("reasonCode", "CodeableConcept", "A reason for why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation)", "Condition or observation that supports why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("note", "Annotation", "Provides extra information about the medication statement that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("dosage", "Dosage", "Indicates how the medication is/was or should be taken by the patient.", 0, Integer.MAX_VALUE, this.dosage));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(MedicationRequest|CarePlan|ProcedureRequest|ReferralRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(MedicationAdministration|MedicationDispense|MedicationStatement|Procedure|Observation)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this MedicationStatement.", 0, 1, this.context);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code representing the patient or other source's judgment about the state of the medication used that this statement is about.  Generally this will be active or completed.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Indicates where type of medication statement and where the medication is expected to be consumed or administered.", 0, 1, this.category);
            }
            case 1458402129: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 1998965455: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -209845038: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 2104315196: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).", 0, 1, this.effective);
            }
            case -1980855245: {
                return new Property("dateAsserted", "dateTime", "The date when the medication statement was asserted by the information source.", 0, 1, this.dateAsserted);
            }
            case -2123220889: {
                return new Property("informationSource", "Reference(Patient|Practitioner|RelatedPerson|Organization)", "The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g Claim or MedicationRequest.", 0, 1, this.informationSource);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was taking the medication.", 0, 1, this.subject);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(Any)", "Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case 110124231: {
                return new Property("taken", SP_CODE, "Indicator of the certainty of whether the medication was taken by the patient.", 0, 1, this.taken);
            }
            case 2112880664: {
                return new Property("reasonNotTaken", "CodeableConcept", "A code indicating why the medication was not taken.", 0, Integer.MAX_VALUE, this.reasonNotTaken);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "A reason for why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation)", "Condition or observation that supports why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides extra information about the medication statement that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1326018889: {
                return new Property("dosage", "Dosage", "Indicates how the medication is/was or should be taken by the patient.", 0, Integer.MAX_VALUE, this.dosage);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.context;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.medication;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.effective;
                }
                return baseArray;
            }
            case -1980855245: {
                Base[] baseArray;
                if (this.dateAsserted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.dateAsserted;
                }
                return baseArray;
            }
            case -2123220889: {
                Base[] baseArray;
                if (this.informationSource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.informationSource;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.subject;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case 110124231: {
                Base[] baseArray;
                if (this.taken == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.taken;
                }
                return baseArray;
            }
            case 2112880664: {
                return this.reasonNotTaken == null ? new Base[]{} : this.reasonNotTaken.toArray(new Base[this.reasonNotTaken.size()]);
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1326018889: {
                return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -892481550: {
                value = new MedicationStatementStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case 1998965455: {
                this.medication = this.castToType(value);
                return value;
            }
            case -1468651097: {
                this.effective = this.castToType(value);
                return value;
            }
            case -1980855245: {
                this.dateAsserted = this.castToDateTime(value);
                return value;
            }
            case -2123220889: {
                this.informationSource = this.castToReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(this.castToReference(value));
                return value;
            }
            case 110124231: {
                value = new MedicationStatementTakenEnumFactory().fromType(this.castToCode(value));
                this.taken = value;
                return value;
            }
            case 2112880664: {
                this.getReasonNotTaken().add(this.castToCodeableConcept(value));
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1326018889: {
                this.getDosage().add(this.castToDosage(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationStatementStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("medication[x]")) {
            this.medication = this.castToType(value);
        } else if (name.equals("effective[x]")) {
            this.effective = this.castToType(value);
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = this.castToDateTime(value);
        } else if (name.equals("informationSource")) {
            this.informationSource = this.castToReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(this.castToReference(value));
        } else if (name.equals("taken")) {
            value = new MedicationStatementTakenEnumFactory().fromType(this.castToCode(value));
            this.taken = value;
        } else if (name.equals("reasonNotTaken")) {
            this.getReasonNotTaken().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("dosage")) {
            this.getDosage().add(this.castToDosage(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case 951530927: {
                return this.getContext();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 1458402129: {
                return this.getMedication();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1980855245: {
                return this.getDateAssertedElement();
            }
            case -2123220889: {
                return this.getInformationSource();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case 110124231: {
                return this.getTakenElement();
            }
            case 2112880664: {
                return this.addReasonNotTaken();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1326018889: {
                return this.addDosage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1998965455: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case -1980855245: {
                return new String[]{"dateTime"};
            }
            case -2123220889: {
                return new String[]{"Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case 110124231: {
                return new String[]{SP_CODE};
            }
            case 2112880664: {
                return new String[]{"CodeableConcept"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1326018889: {
                return new String[]{"Dosage"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.status");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("dateAsserted")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.dateAsserted");
        }
        if (name.equals("informationSource")) {
            this.informationSource = new Reference();
            return this.informationSource;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("taken")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.taken");
        }
        if (name.equals("reasonNotTaken")) {
            return this.addReasonNotTaken();
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosage")) {
            return this.addDosage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationStatement";
    }

    @Override
    public MedicationStatement copy() {
        MedicationStatement dst = new MedicationStatement();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.context = this.context == null ? null : this.context.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        dst.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        dst.informationSource = this.informationSource == null ? null : this.informationSource.copy();
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference2 : this.derivedFrom) {
                dst.derivedFrom.add(reference2.copy());
            }
        }
        Enumeration<MedicationStatementTaken> enumeration = dst.taken = this.taken == null ? null : this.taken.copy();
        if (this.reasonNotTaken != null) {
            dst.reasonNotTaken = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonNotTaken) {
                dst.reasonNotTaken.add(codeableConcept.copy());
            }
        }
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference3 : this.reasonReference) {
                dst.reasonReference.add(reference3.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.dosage != null) {
            dst.dosage = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosage) {
                dst.dosage.add(dosage.copy());
            }
        }
        return dst;
    }

    protected MedicationStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationStatement)) {
            return false;
        }
        MedicationStatement o = (MedicationStatement)other_;
        return MedicationStatement.compareDeep(this.identifier, o.identifier, true) && MedicationStatement.compareDeep(this.basedOn, o.basedOn, true) && MedicationStatement.compareDeep(this.partOf, o.partOf, true) && MedicationStatement.compareDeep(this.context, o.context, true) && MedicationStatement.compareDeep(this.status, o.status, true) && MedicationStatement.compareDeep(this.category, o.category, true) && MedicationStatement.compareDeep(this.medication, o.medication, true) && MedicationStatement.compareDeep(this.effective, o.effective, true) && MedicationStatement.compareDeep(this.dateAsserted, o.dateAsserted, true) && MedicationStatement.compareDeep(this.informationSource, o.informationSource, true) && MedicationStatement.compareDeep(this.subject, o.subject, true) && MedicationStatement.compareDeep(this.derivedFrom, o.derivedFrom, true) && MedicationStatement.compareDeep(this.taken, o.taken, true) && MedicationStatement.compareDeep(this.reasonNotTaken, o.reasonNotTaken, true) && MedicationStatement.compareDeep(this.reasonCode, o.reasonCode, true) && MedicationStatement.compareDeep(this.reasonReference, o.reasonReference, true) && MedicationStatement.compareDeep(this.note, o.note, true) && MedicationStatement.compareDeep(this.dosage, o.dosage, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationStatement)) {
            return false;
        }
        MedicationStatement o = (MedicationStatement)other_;
        return MedicationStatement.compareValues(this.status, o.status, true) && MedicationStatement.compareValues(this.dateAsserted, o.dateAsserted, true) && MedicationStatement.compareValues(this.taken, o.taken, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.context, this.status, this.category, this.medication, this.effective, this.dateAsserted, this.informationSource, this.subject, this.derivedFrom, this.taken, this.reasonNotTaken, this.reasonCode, this.reasonReference, this.note, this.dosage});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationStatement;
    }

    public static class MedicationStatementTakenEnumFactory
    implements EnumFactory<MedicationStatementTaken> {
        @Override
        public MedicationStatementTaken fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("y".equals(codeString)) {
                return MedicationStatementTaken.Y;
            }
            if ("n".equals(codeString)) {
                return MedicationStatementTaken.N;
            }
            if ("unk".equals(codeString)) {
                return MedicationStatementTaken.UNK;
            }
            if ("na".equals(codeString)) {
                return MedicationStatementTaken.NA;
            }
            throw new IllegalArgumentException("Unknown MedicationStatementTaken code '" + codeString + "'");
        }

        public Enumeration<MedicationStatementTaken> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationStatementTaken>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("y".equals(codeString)) {
                return new Enumeration<MedicationStatementTaken>(this, MedicationStatementTaken.Y);
            }
            if ("n".equals(codeString)) {
                return new Enumeration<MedicationStatementTaken>(this, MedicationStatementTaken.N);
            }
            if ("unk".equals(codeString)) {
                return new Enumeration<MedicationStatementTaken>(this, MedicationStatementTaken.UNK);
            }
            if ("na".equals(codeString)) {
                return new Enumeration<MedicationStatementTaken>(this, MedicationStatementTaken.NA);
            }
            throw new FHIRException("Unknown MedicationStatementTaken code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationStatementTaken code) {
            if (code == MedicationStatementTaken.NULL) {
                return null;
            }
            if (code == MedicationStatementTaken.Y) {
                return "y";
            }
            if (code == MedicationStatementTaken.N) {
                return "n";
            }
            if (code == MedicationStatementTaken.UNK) {
                return "unk";
            }
            if (code == MedicationStatementTaken.NA) {
                return "na";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationStatementTaken code) {
            return code.getSystem();
        }
    }

    public static enum MedicationStatementTaken {
        Y,
        N,
        UNK,
        NA,
        NULL;


        public static MedicationStatementTaken fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("y".equals(codeString)) {
                return Y;
            }
            if ("n".equals(codeString)) {
                return N;
            }
            if ("unk".equals(codeString)) {
                return UNK;
            }
            if ("na".equals(codeString)) {
                return NA;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationStatementTaken code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case Y: {
                    return "y";
                }
                case N: {
                    return "n";
                }
                case UNK: {
                    return "unk";
                }
                case NA: {
                    return "na";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case Y: {
                    return "http://hl7.org/fhir/medication-statement-taken";
                }
                case N: {
                    return "http://hl7.org/fhir/medication-statement-taken";
                }
                case UNK: {
                    return "http://hl7.org/fhir/medication-statement-taken";
                }
                case NA: {
                    return "http://hl7.org/fhir/medication-statement-taken";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case Y: {
                    return "Positive assertion that patient has taken medication";
                }
                case N: {
                    return "Negative assertion that patient has not taken medication";
                }
                case UNK: {
                    return "Unknown assertion if patient has taken medication";
                }
                case NA: {
                    return "Patient reporting does not apply";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case Y: {
                    return "Yes";
                }
                case N: {
                    return "No";
                }
                case UNK: {
                    return "Unknown";
                }
                case NA: {
                    return "Not Applicable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MedicationStatementStatusEnumFactory
    implements EnumFactory<MedicationStatementStatus> {
        @Override
        public MedicationStatementStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationStatementStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return MedicationStatementStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationStatementStatus.ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return MedicationStatementStatus.INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return MedicationStatementStatus.STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationStatementStatus.ONHOLD;
            }
            throw new IllegalArgumentException("Unknown MedicationStatementStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationStatementStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationStatementStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.ACTIVE);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.ENTEREDINERROR);
            }
            if ("intended".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.INTENDED);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.STOPPED);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.ONHOLD);
            }
            throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationStatementStatus code) {
            if (code == MedicationStatementStatus.NULL) {
                return null;
            }
            if (code == MedicationStatementStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationStatementStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationStatementStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationStatementStatus.INTENDED) {
                return "intended";
            }
            if (code == MedicationStatementStatus.STOPPED) {
                return "stopped";
            }
            if (code == MedicationStatementStatus.ONHOLD) {
                return "on-hold";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationStatementStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationStatementStatus {
        ACTIVE,
        COMPLETED,
        ENTEREDINERROR,
        INTENDED,
        STOPPED,
        ONHOLD,
        NULL;


        public static MedicationStatementStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INTENDED: {
                    return "intended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case INTENDED: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is still being taken.";
                }
                case COMPLETED: {
                    return "The medication is no longer being taken.";
                }
                case ENTEREDINERROR: {
                    return "The statement was recorded incorrectly.";
                }
                case INTENDED: {
                    return "The medication may be taken at some time in the future.";
                }
                case STOPPED: {
                    return "Actions implied by the statement have been permanently halted, before all of them occurred.";
                }
                case ONHOLD: {
                    return "Actions implied by the statement have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INTENDED: {
                    return "Intended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

