/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/Profile/Coverage")
public class Coverage
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The primary coverage ID", formalDefinition="The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Certificate number, Personal Health Number or Case ID. May be constructed as the concatination of the Coverage.SubscriberID and the Coverage.dependant.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<CoverageStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of coverage such as medical or accident", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-type")
    protected CodeableConcept type;
    @Child(name="policyHolder", type={Patient.class, RelatedPerson.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Owner of the policy", formalDefinition="The party who 'owns' the insurance policy,  may be an individual, corporation or the subscriber's employer.")
    protected Reference policyHolder;
    protected Resource policyHolderTarget;
    @Child(name="subscriber", type={Patient.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subscriber to the policy", formalDefinition="The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.")
    protected Reference subscriber;
    protected Resource subscriberTarget;
    @Child(name="subscriberId", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ID assigned to the Subscriber", formalDefinition="The insurer assigned ID for the Subscriber.")
    protected StringType subscriberId;
    @Child(name="beneficiary", type={Patient.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Plan Beneficiary", formalDefinition="The party who benefits from the insurance coverage., the patient when services are provided.")
    protected Reference beneficiary;
    protected Patient beneficiaryTarget;
    @Child(name="relationship", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Beneficiary relationship to the Subscriber", formalDefinition="The relationship of beneficiary (patient) to the subscriber.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/policyholder-relationship")
    protected CodeableConcept relationship;
    @Child(name="period", type={Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    protected Period period;
    @Child(name="payor", type={Organization.class, Patient.class, RelatedPerson.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for the plan or agreement issuer", formalDefinition="The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements. May provide multiple identifiers such as insurance company identifier or business identifier (BIN number).")
    protected List<Reference> payor;
    protected List<Resource> payorTarget;
    @Child(name="grouping", type={}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional coverage classifications", formalDefinition="A suite of underwrite specific classifiers, for example may be used to identify a class of coverage or employer group, Policy, Plan.")
    protected GroupComponent grouping;
    @Child(name="dependent", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dependent number", formalDefinition="A unique identifier for a dependent under the coverage.")
    protected StringType dependent;
    @Child(name="sequence", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The plan instance or sequence counter", formalDefinition="An optional counter for a particular instance of the identified coverage which increments upon each renewal.")
    protected StringType sequence;
    @Child(name="order", type={PositiveIntType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relative order of the coverage", formalDefinition="The order of applicability of this coverage relative to other coverages which are currently inforce. Note, there may be gaps in the numbering and this does not imply primary, secondard etc. as the specific positioning of coverages depends upon the episode of care.")
    protected PositiveIntType order;
    @Child(name="network", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer network", formalDefinition="The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.")
    protected StringType network;
    @Child(name="contract", type={Contract.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract details", formalDefinition="The policy(s) which constitute this insurance coverage.")
    protected List<Reference> contract;
    protected List<Contract> contractTarget;
    private static final long serialVersionUID = -1719168406L;
    @SearchParamDefinition(name="identifier", path="Coverage.identifier", description="The primary identifier of the insured and the coverage", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subgroup", path="Coverage.grouping.subGroup", description="Sub-group identifier", type="string")
    public static final String SP_SUBGROUP = "subgroup";
    public static final StringClientParam SUBGROUP = new StringClientParam("subgroup");
    @SearchParamDefinition(name="subscriber", path="Coverage.subscriber", description="Reference to the subscriber", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")}, target={Patient.class, RelatedPerson.class})
    public static final String SP_SUBSCRIBER = "subscriber";
    public static final ReferenceClientParam SUBSCRIBER = new ReferenceClientParam("subscriber");
    public static final Include INCLUDE_SUBSCRIBER = new Include("Coverage:subscriber").toLocked();
    @SearchParamDefinition(name="subplan", path="Coverage.grouping.subPlan", description="Sub-plan identifier", type="string")
    public static final String SP_SUBPLAN = "subplan";
    public static final StringClientParam SUBPLAN = new StringClientParam("subplan");
    @SearchParamDefinition(name="type", path="Coverage.type", description="The kind of coverage (health plan, auto, Workers Compensation)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="sequence", path="Coverage.sequence", description="Sequence number", type="string")
    public static final String SP_SEQUENCE = "sequence";
    public static final StringClientParam SEQUENCE = new StringClientParam("sequence");
    @SearchParamDefinition(name="payor", path="Coverage.payor", description="The identity of the insurer or party paying for services", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_PAYOR = "payor";
    public static final ReferenceClientParam PAYOR = new ReferenceClientParam("payor");
    public static final Include INCLUDE_PAYOR = new Include("Coverage:payor").toLocked();
    @SearchParamDefinition(name="beneficiary", path="Coverage.beneficiary", description="Covered party", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_BENEFICIARY = "beneficiary";
    public static final ReferenceClientParam BENEFICIARY = new ReferenceClientParam("beneficiary");
    public static final Include INCLUDE_BENEFICIARY = new Include("Coverage:beneficiary").toLocked();
    @SearchParamDefinition(name="subclass", path="Coverage.grouping.subClass", description="Sub-class identifier", type="string")
    public static final String SP_SUBCLASS = "subclass";
    public static final StringClientParam SUBCLASS = new StringClientParam("subclass");
    @SearchParamDefinition(name="plan", path="Coverage.grouping.plan", description="A plan or policy identifier", type="string")
    public static final String SP_PLAN = "plan";
    public static final StringClientParam PLAN = new StringClientParam("plan");
    @SearchParamDefinition(name="class", path="Coverage.grouping.class", description="Class identifier", type="string")
    public static final String SP_CLASS = "class";
    public static final StringClientParam CLASS = new StringClientParam("class");
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="string")
    public static final String SP_DEPENDENT = "dependent";
    public static final StringClientParam DEPENDENT = new StringClientParam("dependent");
    @SearchParamDefinition(name="group", path="Coverage.grouping.group", description="Group identifier", type="string")
    public static final String SP_GROUP = "group";
    public static final StringClientParam GROUP = new StringClientParam("group");
    @SearchParamDefinition(name="policy-holder", path="Coverage.policyHolder", description="Reference to the policyholder", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_POLICY_HOLDER = "policy-holder";
    public static final ReferenceClientParam POLICY_HOLDER = new ReferenceClientParam("policy-holder");
    public static final Include INCLUDE_POLICY_HOLDER = new Include("Coverage:policy-holder").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coverage setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Coverage addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<CoverageStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CoverageStatus>(new CoverageStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Coverage setStatusElement(Enumeration<CoverageStatus> value) {
        this.status = value;
        return this;
    }

    public CoverageStatus getStatus() {
        return this.status == null ? null : (CoverageStatus)((Object)this.status.getValue());
    }

    public Coverage setStatus(CoverageStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<CoverageStatus>(new CoverageStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Coverage setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getPolicyHolder() {
        if (this.policyHolder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.policyHolder");
            }
            if (Configuration.doAutoCreate()) {
                this.policyHolder = new Reference();
            }
        }
        return this.policyHolder;
    }

    public boolean hasPolicyHolder() {
        return this.policyHolder != null && !this.policyHolder.isEmpty();
    }

    public Coverage setPolicyHolder(Reference value) {
        this.policyHolder = value;
        return this;
    }

    public Resource getPolicyHolderTarget() {
        return this.policyHolderTarget;
    }

    public Coverage setPolicyHolderTarget(Resource value) {
        this.policyHolderTarget = value;
        return this;
    }

    public Reference getSubscriber() {
        if (this.subscriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriber");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriber = new Reference();
            }
        }
        return this.subscriber;
    }

    public boolean hasSubscriber() {
        return this.subscriber != null && !this.subscriber.isEmpty();
    }

    public Coverage setSubscriber(Reference value) {
        this.subscriber = value;
        return this;
    }

    public Resource getSubscriberTarget() {
        return this.subscriberTarget;
    }

    public Coverage setSubscriberTarget(Resource value) {
        this.subscriberTarget = value;
        return this;
    }

    public StringType getSubscriberIdElement() {
        if (this.subscriberId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriberId");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriberId = new StringType();
            }
        }
        return this.subscriberId;
    }

    public boolean hasSubscriberIdElement() {
        return this.subscriberId != null && !this.subscriberId.isEmpty();
    }

    public boolean hasSubscriberId() {
        return this.subscriberId != null && !this.subscriberId.isEmpty();
    }

    public Coverage setSubscriberIdElement(StringType value) {
        this.subscriberId = value;
        return this;
    }

    public String getSubscriberId() {
        return this.subscriberId == null ? null : (String)this.subscriberId.getValue();
    }

    public Coverage setSubscriberId(String value) {
        if (Utilities.noString((String)value)) {
            this.subscriberId = null;
        } else {
            if (this.subscriberId == null) {
                this.subscriberId = new StringType();
            }
            this.subscriberId.setValue(value);
        }
        return this;
    }

    public Reference getBeneficiary() {
        if (this.beneficiary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.beneficiary");
            }
            if (Configuration.doAutoCreate()) {
                this.beneficiary = new Reference();
            }
        }
        return this.beneficiary;
    }

    public boolean hasBeneficiary() {
        return this.beneficiary != null && !this.beneficiary.isEmpty();
    }

    public Coverage setBeneficiary(Reference value) {
        this.beneficiary = value;
        return this;
    }

    public Patient getBeneficiaryTarget() {
        if (this.beneficiaryTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.beneficiary");
            }
            if (Configuration.doAutoCreate()) {
                this.beneficiaryTarget = new Patient();
            }
        }
        return this.beneficiaryTarget;
    }

    public Coverage setBeneficiaryTarget(Patient value) {
        this.beneficiaryTarget = value;
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public Coverage setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Coverage setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getPayor() {
        if (this.payor == null) {
            this.payor = new ArrayList<Reference>();
        }
        return this.payor;
    }

    public Coverage setPayor(List<Reference> thePayor) {
        this.payor = thePayor;
        return this;
    }

    public boolean hasPayor() {
        if (this.payor == null) {
            return false;
        }
        for (Reference item : this.payor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPayor() {
        Reference t = new Reference();
        if (this.payor == null) {
            this.payor = new ArrayList<Reference>();
        }
        this.payor.add(t);
        return t;
    }

    public Coverage addPayor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.payor == null) {
            this.payor = new ArrayList<Reference>();
        }
        this.payor.add(t);
        return this;
    }

    public Reference getPayorFirstRep() {
        if (this.getPayor().isEmpty()) {
            this.addPayor();
        }
        return this.getPayor().get(0);
    }

    @Deprecated
    public List<Resource> getPayorTarget() {
        if (this.payorTarget == null) {
            this.payorTarget = new ArrayList<Resource>();
        }
        return this.payorTarget;
    }

    public GroupComponent getGrouping() {
        if (this.grouping == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.grouping");
            }
            if (Configuration.doAutoCreate()) {
                this.grouping = new GroupComponent();
            }
        }
        return this.grouping;
    }

    public boolean hasGrouping() {
        return this.grouping != null && !this.grouping.isEmpty();
    }

    public Coverage setGrouping(GroupComponent value) {
        this.grouping = value;
        return this;
    }

    public StringType getDependentElement() {
        if (this.dependent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.dependent");
            }
            if (Configuration.doAutoCreate()) {
                this.dependent = new StringType();
            }
        }
        return this.dependent;
    }

    public boolean hasDependentElement() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public boolean hasDependent() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public Coverage setDependentElement(StringType value) {
        this.dependent = value;
        return this;
    }

    public String getDependent() {
        return this.dependent == null ? null : (String)this.dependent.getValue();
    }

    public Coverage setDependent(String value) {
        if (Utilities.noString((String)value)) {
            this.dependent = null;
        } else {
            if (this.dependent == null) {
                this.dependent = new StringType();
            }
            this.dependent.setValue(value);
        }
        return this;
    }

    public StringType getSequenceElement() {
        if (this.sequence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.sequence");
            }
            if (Configuration.doAutoCreate()) {
                this.sequence = new StringType();
            }
        }
        return this.sequence;
    }

    public boolean hasSequenceElement() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public boolean hasSequence() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public Coverage setSequenceElement(StringType value) {
        this.sequence = value;
        return this;
    }

    public String getSequence() {
        return this.sequence == null ? null : (String)this.sequence.getValue();
    }

    public Coverage setSequence(String value) {
        if (Utilities.noString((String)value)) {
            this.sequence = null;
        } else {
            if (this.sequence == null) {
                this.sequence = new StringType();
            }
            this.sequence.setValue(value);
        }
        return this;
    }

    public PositiveIntType getOrderElement() {
        if (this.order == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.order");
            }
            if (Configuration.doAutoCreate()) {
                this.order = new PositiveIntType();
            }
        }
        return this.order;
    }

    public boolean hasOrderElement() {
        return this.order != null && !this.order.isEmpty();
    }

    public boolean hasOrder() {
        return this.order != null && !this.order.isEmpty();
    }

    public Coverage setOrderElement(PositiveIntType value) {
        this.order = value;
        return this;
    }

    public int getOrder() {
        return this.order == null || this.order.isEmpty() ? 0 : (Integer)this.order.getValue();
    }

    public Coverage setOrder(int value) {
        if (this.order == null) {
            this.order = new PositiveIntType();
        }
        this.order.setValue((Object)value);
        return this;
    }

    public StringType getNetworkElement() {
        if (this.network == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.network");
            }
            if (Configuration.doAutoCreate()) {
                this.network = new StringType();
            }
        }
        return this.network;
    }

    public boolean hasNetworkElement() {
        return this.network != null && !this.network.isEmpty();
    }

    public boolean hasNetwork() {
        return this.network != null && !this.network.isEmpty();
    }

    public Coverage setNetworkElement(StringType value) {
        this.network = value;
        return this;
    }

    public String getNetwork() {
        return this.network == null ? null : (String)this.network.getValue();
    }

    public Coverage setNetwork(String value) {
        if (Utilities.noString((String)value)) {
            this.network = null;
        } else {
            if (this.network == null) {
                this.network = new StringType();
            }
            this.network.setValue(value);
        }
        return this;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public Coverage setContract(List<Reference> theContract) {
        this.contract = theContract;
        return this;
    }

    public boolean hasContract() {
        if (this.contract == null) {
            return false;
        }
        for (Reference item : this.contract) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContract() {
        Reference t = new Reference();
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return t;
    }

    public Coverage addContract(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return this;
    }

    public Reference getContractFirstRep() {
        if (this.getContract().isEmpty()) {
            this.addContract();
        }
        return this.getContract().get(0);
    }

    @Deprecated
    public List<Contract> getContractTarget() {
        if (this.contractTarget == null) {
            this.contractTarget = new ArrayList<Contract>();
        }
        return this.contractTarget;
    }

    @Deprecated
    public Contract addContractTarget() {
        Contract r = new Contract();
        if (this.contractTarget == null) {
            this.contractTarget = new ArrayList<Contract>();
        }
        this.contractTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Certificate number, Personal Health Number or Case ID. May be constructed as the concatination of the Coverage.SubscriberID and the Coverage.dependant.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("status", "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.", 0, 1, this.type));
        children.add(new Property("policyHolder", "Reference(Patient|RelatedPerson|Organization)", "The party who 'owns' the insurance policy,  may be an individual, corporation or the subscriber's employer.", 0, 1, this.policyHolder));
        children.add(new Property(SP_SUBSCRIBER, "Reference(Patient|RelatedPerson)", "The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.", 0, 1, this.subscriber));
        children.add(new Property("subscriberId", "string", "The insurer assigned ID for the Subscriber.", 0, 1, this.subscriberId));
        children.add(new Property(SP_BENEFICIARY, "Reference(Patient)", "The party who benefits from the insurance coverage., the patient when services are provided.", 0, 1, this.beneficiary));
        children.add(new Property("relationship", "CodeableConcept", "The relationship of beneficiary (patient) to the subscriber.", 0, 1, this.relationship));
        children.add(new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, 1, this.period));
        children.add(new Property(SP_PAYOR, "Reference(Organization|Patient|RelatedPerson)", "The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements. May provide multiple identifiers such as insurance company identifier or business identifier (BIN number).", 0, Integer.MAX_VALUE, this.payor));
        children.add(new Property("grouping", "", "A suite of underwrite specific classifiers, for example may be used to identify a class of coverage or employer group, Policy, Plan.", 0, 1, this.grouping));
        children.add(new Property(SP_DEPENDENT, "string", "A unique identifier for a dependent under the coverage.", 0, 1, this.dependent));
        children.add(new Property(SP_SEQUENCE, "string", "An optional counter for a particular instance of the identified coverage which increments upon each renewal.", 0, 1, this.sequence));
        children.add(new Property("order", "positiveInt", "The order of applicability of this coverage relative to other coverages which are currently inforce. Note, there may be gaps in the numbering and this does not imply primary, secondard etc. as the specific positioning of coverages depends upon the episode of care.", 0, 1, this.order));
        children.add(new Property("network", "string", "The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.", 0, 1, this.network));
        children.add(new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Certificate number, Personal Health Number or Case ID. May be constructed as the concatination of the Coverage.SubscriberID and the Coverage.dependant.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.", 0, 1, this.type);
            }
            case 2046898558: {
                return new Property("policyHolder", "Reference(Patient|RelatedPerson|Organization)", "The party who 'owns' the insurance policy,  may be an individual, corporation or the subscriber's employer.", 0, 1, this.policyHolder);
            }
            case -1219769240: {
                return new Property(SP_SUBSCRIBER, "Reference(Patient|RelatedPerson)", "The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.", 0, 1, this.subscriber);
            }
            case 327834531: {
                return new Property("subscriberId", "string", "The insurer assigned ID for the Subscriber.", 0, 1, this.subscriberId);
            }
            case -565102875: {
                return new Property(SP_BENEFICIARY, "Reference(Patient)", "The party who benefits from the insurance coverage., the patient when services are provided.", 0, 1, this.beneficiary);
            }
            case -261851592: {
                return new Property("relationship", "CodeableConcept", "The relationship of beneficiary (patient) to the subscriber.", 0, 1, this.relationship);
            }
            case -991726143: {
                return new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, 1, this.period);
            }
            case 106443915: {
                return new Property(SP_PAYOR, "Reference(Organization|Patient|RelatedPerson)", "The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements. May provide multiple identifiers such as insurance company identifier or business identifier (BIN number).", 0, Integer.MAX_VALUE, this.payor);
            }
            case 506371331: {
                return new Property("grouping", "", "A suite of underwrite specific classifiers, for example may be used to identify a class of coverage or employer group, Policy, Plan.", 0, 1, this.grouping);
            }
            case -1109226753: {
                return new Property(SP_DEPENDENT, "string", "A unique identifier for a dependent under the coverage.", 0, 1, this.dependent);
            }
            case 1349547969: {
                return new Property(SP_SEQUENCE, "string", "An optional counter for a particular instance of the identified coverage which increments upon each renewal.", 0, 1, this.sequence);
            }
            case 106006350: {
                return new Property("order", "positiveInt", "The order of applicability of this coverage relative to other coverages which are currently inforce. Note, there may be gaps in the numbering and this does not imply primary, secondard etc. as the specific positioning of coverages depends upon the episode of care.", 0, 1, this.order);
            }
            case 1843485230: {
                return new Property("network", "string", "The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.", 0, 1, this.network);
            }
            case -566947566: {
                return new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 2046898558: {
                Base[] baseArray;
                if (this.policyHolder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.policyHolder;
                }
                return baseArray;
            }
            case -1219769240: {
                Base[] baseArray;
                if (this.subscriber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subscriber;
                }
                return baseArray;
            }
            case 327834531: {
                Base[] baseArray;
                if (this.subscriberId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subscriberId;
                }
                return baseArray;
            }
            case -565102875: {
                Base[] baseArray;
                if (this.beneficiary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.beneficiary;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.relationship;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.period;
                }
                return baseArray;
            }
            case 106443915: {
                return this.payor == null ? new Base[]{} : this.payor.toArray(new Base[this.payor.size()]);
            }
            case 506371331: {
                Base[] baseArray;
                if (this.grouping == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.grouping;
                }
                return baseArray;
            }
            case -1109226753: {
                Base[] baseArray;
                if (this.dependent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.dependent;
                }
                return baseArray;
            }
            case 1349547969: {
                Base[] baseArray;
                if (this.sequence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.sequence;
                }
                return baseArray;
            }
            case 106006350: {
                Base[] baseArray;
                if (this.order == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.order;
                }
                return baseArray;
            }
            case 1843485230: {
                Base[] baseArray;
                if (this.network == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.network;
                }
                return baseArray;
            }
            case -566947566: {
                return this.contract == null ? new Base[]{} : this.contract.toArray(new Base[this.contract.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new CoverageStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 2046898558: {
                this.policyHolder = this.castToReference(value);
                return value;
            }
            case -1219769240: {
                this.subscriber = this.castToReference(value);
                return value;
            }
            case 327834531: {
                this.subscriberId = this.castToString(value);
                return value;
            }
            case -565102875: {
                this.beneficiary = this.castToReference(value);
                return value;
            }
            case -261851592: {
                this.relationship = this.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case 106443915: {
                this.getPayor().add(this.castToReference(value));
                return value;
            }
            case 506371331: {
                this.grouping = (GroupComponent)((Object)value);
                return value;
            }
            case -1109226753: {
                this.dependent = this.castToString(value);
                return value;
            }
            case 1349547969: {
                this.sequence = this.castToString(value);
                return value;
            }
            case 106006350: {
                this.order = this.castToPositiveInt(value);
                return value;
            }
            case 1843485230: {
                this.network = this.castToString(value);
                return value;
            }
            case -566947566: {
                this.getContract().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new CoverageStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("policyHolder")) {
            this.policyHolder = this.castToReference(value);
        } else if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = this.castToReference(value);
        } else if (name.equals("subscriberId")) {
            this.subscriberId = this.castToString(value);
        } else if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = this.castToReference(value);
        } else if (name.equals("relationship")) {
            this.relationship = this.castToCodeableConcept(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_PAYOR)) {
            this.getPayor().add(this.castToReference(value));
        } else if (name.equals("grouping")) {
            this.grouping = (GroupComponent)((Object)value);
        } else if (name.equals(SP_DEPENDENT)) {
            this.dependent = this.castToString(value);
        } else if (name.equals(SP_SEQUENCE)) {
            this.sequence = this.castToString(value);
        } else if (name.equals("order")) {
            this.order = this.castToPositiveInt(value);
        } else if (name.equals("network")) {
            this.network = this.castToString(value);
        } else if (name.equals("contract")) {
            this.getContract().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 2046898558: {
                return this.getPolicyHolder();
            }
            case -1219769240: {
                return this.getSubscriber();
            }
            case 327834531: {
                return this.getSubscriberIdElement();
            }
            case -565102875: {
                return this.getBeneficiary();
            }
            case -261851592: {
                return this.getRelationship();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 106443915: {
                return this.addPayor();
            }
            case 506371331: {
                return this.getGrouping();
            }
            case -1109226753: {
                return this.getDependentElement();
            }
            case 1349547969: {
                return this.getSequenceElement();
            }
            case 106006350: {
                return this.getOrderElement();
            }
            case 1843485230: {
                return this.getNetworkElement();
            }
            case -566947566: {
                return this.addContract();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 2046898558: {
                return new String[]{"Reference"};
            }
            case -1219769240: {
                return new String[]{"Reference"};
            }
            case 327834531: {
                return new String[]{"string"};
            }
            case -565102875: {
                return new String[]{"Reference"};
            }
            case -261851592: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 106443915: {
                return new String[]{"Reference"};
            }
            case 506371331: {
                return new String[0];
            }
            case -1109226753: {
                return new String[]{"string"};
            }
            case 1349547969: {
                return new String[]{"string"};
            }
            case 106006350: {
                return new String[]{"positiveInt"};
            }
            case 1843485230: {
                return new String[]{"string"};
            }
            case -566947566: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("policyHolder")) {
            this.policyHolder = new Reference();
            return this.policyHolder;
        }
        if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = new Reference();
            return this.subscriber;
        }
        if (name.equals("subscriberId")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.subscriberId");
        }
        if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = new Reference();
            return this.beneficiary;
        }
        if (name.equals("relationship")) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_PAYOR)) {
            return this.addPayor();
        }
        if (name.equals("grouping")) {
            this.grouping = new GroupComponent();
            return this.grouping;
        }
        if (name.equals(SP_DEPENDENT)) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.dependent");
        }
        if (name.equals(SP_SEQUENCE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.sequence");
        }
        if (name.equals("order")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.order");
        }
        if (name.equals("network")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.network");
        }
        if (name.equals("contract")) {
            return this.addContract();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coverage";
    }

    @Override
    public Coverage copy() {
        Coverage dst = new Coverage();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.policyHolder = this.policyHolder == null ? null : this.policyHolder.copy();
        dst.subscriber = this.subscriber == null ? null : this.subscriber.copy();
        dst.subscriberId = this.subscriberId == null ? null : this.subscriberId.copy();
        dst.beneficiary = this.beneficiary == null ? null : this.beneficiary.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.payor != null) {
            dst.payor = new ArrayList<Reference>();
            for (Reference reference : this.payor) {
                dst.payor.add(reference.copy());
            }
        }
        dst.grouping = this.grouping == null ? null : this.grouping.copy();
        dst.dependent = this.dependent == null ? null : this.dependent.copy();
        dst.sequence = this.sequence == null ? null : this.sequence.copy();
        dst.order = this.order == null ? null : this.order.copy();
        StringType stringType = dst.network = this.network == null ? null : this.network.copy();
        if (this.contract != null) {
            dst.contract = new ArrayList<Reference>();
            for (Reference reference : this.contract) {
                dst.contract.add(reference.copy());
            }
        }
        return dst;
    }

    protected Coverage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other_;
        return Coverage.compareDeep(this.identifier, o.identifier, true) && Coverage.compareDeep(this.status, o.status, true) && Coverage.compareDeep(this.type, o.type, true) && Coverage.compareDeep(this.policyHolder, o.policyHolder, true) && Coverage.compareDeep(this.subscriber, o.subscriber, true) && Coverage.compareDeep(this.subscriberId, o.subscriberId, true) && Coverage.compareDeep(this.beneficiary, o.beneficiary, true) && Coverage.compareDeep(this.relationship, o.relationship, true) && Coverage.compareDeep(this.period, o.period, true) && Coverage.compareDeep(this.payor, o.payor, true) && Coverage.compareDeep(this.grouping, o.grouping, true) && Coverage.compareDeep(this.dependent, o.dependent, true) && Coverage.compareDeep(this.sequence, o.sequence, true) && Coverage.compareDeep(this.order, o.order, true) && Coverage.compareDeep(this.network, o.network, true) && Coverage.compareDeep(this.contract, o.contract, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other_;
        return Coverage.compareValues(this.status, o.status, true) && Coverage.compareValues(this.subscriberId, o.subscriberId, true) && Coverage.compareValues(this.dependent, o.dependent, true) && Coverage.compareValues(this.sequence, o.sequence, true) && Coverage.compareValues(this.order, o.order, true) && Coverage.compareValues(this.network, o.network, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.policyHolder, this.subscriber, this.subscriberId, this.beneficiary, this.relationship, this.period, this.payor, this.grouping, this.dependent, this.sequence, this.order, this.network, this.contract});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Coverage;
    }

    @Block
    public static class GroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="group", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier for the group", formalDefinition="Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify an employer group. May also be referred to as a Policy or Group ID.")
        protected StringType group;
        @Child(name="groupDisplay", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Display text for an identifier for the group", formalDefinition="A short description for the group.")
        protected StringType groupDisplay;
        @Child(name="subGroup", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier for the subsection of the group", formalDefinition="Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify a subset of an employer group.")
        protected StringType subGroup;
        @Child(name="subGroupDisplay", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Display text for the subsection of the group", formalDefinition="A short description for the subgroup.")
        protected StringType subGroupDisplay;
        @Child(name="plan", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier for the plan", formalDefinition="Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify a collection of benefits provided to employees. May be referred to as a Section or Division ID.")
        protected StringType plan;
        @Child(name="planDisplay", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Display text for the plan", formalDefinition="A short description for the plan.")
        protected StringType planDisplay;
        @Child(name="subPlan", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier for the subsection of the plan", formalDefinition="Identifies a sub-style or sub-collective of coverage issued by the underwriter, for example may be used to identify a subset of a collection of benefits provided to employees.")
        protected StringType subPlan;
        @Child(name="subPlanDisplay", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Display text for the subsection of the plan", formalDefinition="A short description for the subplan.")
        protected StringType subPlanDisplay;
        @Child(name="class", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier for the class", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage such as a level of deductables or co-payment.")
        protected StringType class_;
        @Child(name="classDisplay", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Display text for the class", formalDefinition="A short description for the class.")
        protected StringType classDisplay;
        @Child(name="subClass", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier for the subsection of the class", formalDefinition="Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a subclass of coverage such as a sub-level of deductables or co-payment.")
        protected StringType subClass;
        @Child(name="subClassDisplay", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Display text for the subsection of the subclass", formalDefinition="A short description for the subclass.")
        protected StringType subClassDisplay;
        private static final long serialVersionUID = -13147121L;

        public StringType getGroupElement() {
            if (this.group == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.group");
                }
                if (Configuration.doAutoCreate()) {
                    this.group = new StringType();
                }
            }
            return this.group;
        }

        public boolean hasGroupElement() {
            return this.group != null && !this.group.isEmpty();
        }

        public boolean hasGroup() {
            return this.group != null && !this.group.isEmpty();
        }

        public GroupComponent setGroupElement(StringType value) {
            this.group = value;
            return this;
        }

        public String getGroup() {
            return this.group == null ? null : (String)this.group.getValue();
        }

        public GroupComponent setGroup(String value) {
            if (Utilities.noString((String)value)) {
                this.group = null;
            } else {
                if (this.group == null) {
                    this.group = new StringType();
                }
                this.group.setValue(value);
            }
            return this;
        }

        public StringType getGroupDisplayElement() {
            if (this.groupDisplay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.groupDisplay");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupDisplay = new StringType();
                }
            }
            return this.groupDisplay;
        }

        public boolean hasGroupDisplayElement() {
            return this.groupDisplay != null && !this.groupDisplay.isEmpty();
        }

        public boolean hasGroupDisplay() {
            return this.groupDisplay != null && !this.groupDisplay.isEmpty();
        }

        public GroupComponent setGroupDisplayElement(StringType value) {
            this.groupDisplay = value;
            return this;
        }

        public String getGroupDisplay() {
            return this.groupDisplay == null ? null : (String)this.groupDisplay.getValue();
        }

        public GroupComponent setGroupDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.groupDisplay = null;
            } else {
                if (this.groupDisplay == null) {
                    this.groupDisplay = new StringType();
                }
                this.groupDisplay.setValue(value);
            }
            return this;
        }

        public StringType getSubGroupElement() {
            if (this.subGroup == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subGroup");
                }
                if (Configuration.doAutoCreate()) {
                    this.subGroup = new StringType();
                }
            }
            return this.subGroup;
        }

        public boolean hasSubGroupElement() {
            return this.subGroup != null && !this.subGroup.isEmpty();
        }

        public boolean hasSubGroup() {
            return this.subGroup != null && !this.subGroup.isEmpty();
        }

        public GroupComponent setSubGroupElement(StringType value) {
            this.subGroup = value;
            return this;
        }

        public String getSubGroup() {
            return this.subGroup == null ? null : (String)this.subGroup.getValue();
        }

        public GroupComponent setSubGroup(String value) {
            if (Utilities.noString((String)value)) {
                this.subGroup = null;
            } else {
                if (this.subGroup == null) {
                    this.subGroup = new StringType();
                }
                this.subGroup.setValue(value);
            }
            return this;
        }

        public StringType getSubGroupDisplayElement() {
            if (this.subGroupDisplay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subGroupDisplay");
                }
                if (Configuration.doAutoCreate()) {
                    this.subGroupDisplay = new StringType();
                }
            }
            return this.subGroupDisplay;
        }

        public boolean hasSubGroupDisplayElement() {
            return this.subGroupDisplay != null && !this.subGroupDisplay.isEmpty();
        }

        public boolean hasSubGroupDisplay() {
            return this.subGroupDisplay != null && !this.subGroupDisplay.isEmpty();
        }

        public GroupComponent setSubGroupDisplayElement(StringType value) {
            this.subGroupDisplay = value;
            return this;
        }

        public String getSubGroupDisplay() {
            return this.subGroupDisplay == null ? null : (String)this.subGroupDisplay.getValue();
        }

        public GroupComponent setSubGroupDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.subGroupDisplay = null;
            } else {
                if (this.subGroupDisplay == null) {
                    this.subGroupDisplay = new StringType();
                }
                this.subGroupDisplay.setValue(value);
            }
            return this;
        }

        public StringType getPlanElement() {
            if (this.plan == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.plan");
                }
                if (Configuration.doAutoCreate()) {
                    this.plan = new StringType();
                }
            }
            return this.plan;
        }

        public boolean hasPlanElement() {
            return this.plan != null && !this.plan.isEmpty();
        }

        public boolean hasPlan() {
            return this.plan != null && !this.plan.isEmpty();
        }

        public GroupComponent setPlanElement(StringType value) {
            this.plan = value;
            return this;
        }

        public String getPlan() {
            return this.plan == null ? null : (String)this.plan.getValue();
        }

        public GroupComponent setPlan(String value) {
            if (Utilities.noString((String)value)) {
                this.plan = null;
            } else {
                if (this.plan == null) {
                    this.plan = new StringType();
                }
                this.plan.setValue(value);
            }
            return this;
        }

        public StringType getPlanDisplayElement() {
            if (this.planDisplay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.planDisplay");
                }
                if (Configuration.doAutoCreate()) {
                    this.planDisplay = new StringType();
                }
            }
            return this.planDisplay;
        }

        public boolean hasPlanDisplayElement() {
            return this.planDisplay != null && !this.planDisplay.isEmpty();
        }

        public boolean hasPlanDisplay() {
            return this.planDisplay != null && !this.planDisplay.isEmpty();
        }

        public GroupComponent setPlanDisplayElement(StringType value) {
            this.planDisplay = value;
            return this;
        }

        public String getPlanDisplay() {
            return this.planDisplay == null ? null : (String)this.planDisplay.getValue();
        }

        public GroupComponent setPlanDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.planDisplay = null;
            } else {
                if (this.planDisplay == null) {
                    this.planDisplay = new StringType();
                }
                this.planDisplay.setValue(value);
            }
            return this;
        }

        public StringType getSubPlanElement() {
            if (this.subPlan == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subPlan");
                }
                if (Configuration.doAutoCreate()) {
                    this.subPlan = new StringType();
                }
            }
            return this.subPlan;
        }

        public boolean hasSubPlanElement() {
            return this.subPlan != null && !this.subPlan.isEmpty();
        }

        public boolean hasSubPlan() {
            return this.subPlan != null && !this.subPlan.isEmpty();
        }

        public GroupComponent setSubPlanElement(StringType value) {
            this.subPlan = value;
            return this;
        }

        public String getSubPlan() {
            return this.subPlan == null ? null : (String)this.subPlan.getValue();
        }

        public GroupComponent setSubPlan(String value) {
            if (Utilities.noString((String)value)) {
                this.subPlan = null;
            } else {
                if (this.subPlan == null) {
                    this.subPlan = new StringType();
                }
                this.subPlan.setValue(value);
            }
            return this;
        }

        public StringType getSubPlanDisplayElement() {
            if (this.subPlanDisplay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subPlanDisplay");
                }
                if (Configuration.doAutoCreate()) {
                    this.subPlanDisplay = new StringType();
                }
            }
            return this.subPlanDisplay;
        }

        public boolean hasSubPlanDisplayElement() {
            return this.subPlanDisplay != null && !this.subPlanDisplay.isEmpty();
        }

        public boolean hasSubPlanDisplay() {
            return this.subPlanDisplay != null && !this.subPlanDisplay.isEmpty();
        }

        public GroupComponent setSubPlanDisplayElement(StringType value) {
            this.subPlanDisplay = value;
            return this;
        }

        public String getSubPlanDisplay() {
            return this.subPlanDisplay == null ? null : (String)this.subPlanDisplay.getValue();
        }

        public GroupComponent setSubPlanDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.subPlanDisplay = null;
            } else {
                if (this.subPlanDisplay == null) {
                    this.subPlanDisplay = new StringType();
                }
                this.subPlanDisplay.setValue(value);
            }
            return this;
        }

        public StringType getClass_Element() {
            if (this.class_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.class_");
                }
                if (Configuration.doAutoCreate()) {
                    this.class_ = new StringType();
                }
            }
            return this.class_;
        }

        public boolean hasClass_Element() {
            return this.class_ != null && !this.class_.isEmpty();
        }

        public boolean hasClass_() {
            return this.class_ != null && !this.class_.isEmpty();
        }

        public GroupComponent setClass_Element(StringType value) {
            this.class_ = value;
            return this;
        }

        public String getClass_() {
            return this.class_ == null ? null : (String)this.class_.getValue();
        }

        public GroupComponent setClass_(String value) {
            if (Utilities.noString((String)value)) {
                this.class_ = null;
            } else {
                if (this.class_ == null) {
                    this.class_ = new StringType();
                }
                this.class_.setValue(value);
            }
            return this;
        }

        public StringType getClassDisplayElement() {
            if (this.classDisplay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.classDisplay");
                }
                if (Configuration.doAutoCreate()) {
                    this.classDisplay = new StringType();
                }
            }
            return this.classDisplay;
        }

        public boolean hasClassDisplayElement() {
            return this.classDisplay != null && !this.classDisplay.isEmpty();
        }

        public boolean hasClassDisplay() {
            return this.classDisplay != null && !this.classDisplay.isEmpty();
        }

        public GroupComponent setClassDisplayElement(StringType value) {
            this.classDisplay = value;
            return this;
        }

        public String getClassDisplay() {
            return this.classDisplay == null ? null : (String)this.classDisplay.getValue();
        }

        public GroupComponent setClassDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.classDisplay = null;
            } else {
                if (this.classDisplay == null) {
                    this.classDisplay = new StringType();
                }
                this.classDisplay.setValue(value);
            }
            return this;
        }

        public StringType getSubClassElement() {
            if (this.subClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.subClass = new StringType();
                }
            }
            return this.subClass;
        }

        public boolean hasSubClassElement() {
            return this.subClass != null && !this.subClass.isEmpty();
        }

        public boolean hasSubClass() {
            return this.subClass != null && !this.subClass.isEmpty();
        }

        public GroupComponent setSubClassElement(StringType value) {
            this.subClass = value;
            return this;
        }

        public String getSubClass() {
            return this.subClass == null ? null : (String)this.subClass.getValue();
        }

        public GroupComponent setSubClass(String value) {
            if (Utilities.noString((String)value)) {
                this.subClass = null;
            } else {
                if (this.subClass == null) {
                    this.subClass = new StringType();
                }
                this.subClass.setValue(value);
            }
            return this;
        }

        public StringType getSubClassDisplayElement() {
            if (this.subClassDisplay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subClassDisplay");
                }
                if (Configuration.doAutoCreate()) {
                    this.subClassDisplay = new StringType();
                }
            }
            return this.subClassDisplay;
        }

        public boolean hasSubClassDisplayElement() {
            return this.subClassDisplay != null && !this.subClassDisplay.isEmpty();
        }

        public boolean hasSubClassDisplay() {
            return this.subClassDisplay != null && !this.subClassDisplay.isEmpty();
        }

        public GroupComponent setSubClassDisplayElement(StringType value) {
            this.subClassDisplay = value;
            return this;
        }

        public String getSubClassDisplay() {
            return this.subClassDisplay == null ? null : (String)this.subClassDisplay.getValue();
        }

        public GroupComponent setSubClassDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.subClassDisplay = null;
            } else {
                if (this.subClassDisplay == null) {
                    this.subClassDisplay = new StringType();
                }
                this.subClassDisplay.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_GROUP, "string", "Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify an employer group. May also be referred to as a Policy or Group ID.", 0, 1, this.group));
            children.add(new Property("groupDisplay", "string", "A short description for the group.", 0, 1, this.groupDisplay));
            children.add(new Property("subGroup", "string", "Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify a subset of an employer group.", 0, 1, this.subGroup));
            children.add(new Property("subGroupDisplay", "string", "A short description for the subgroup.", 0, 1, this.subGroupDisplay));
            children.add(new Property(Coverage.SP_PLAN, "string", "Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify a collection of benefits provided to employees. May be referred to as a Section or Division ID.", 0, 1, this.plan));
            children.add(new Property("planDisplay", "string", "A short description for the plan.", 0, 1, this.planDisplay));
            children.add(new Property("subPlan", "string", "Identifies a sub-style or sub-collective of coverage issued by the underwriter, for example may be used to identify a subset of a collection of benefits provided to employees.", 0, 1, this.subPlan));
            children.add(new Property("subPlanDisplay", "string", "A short description for the subplan.", 0, 1, this.subPlanDisplay));
            children.add(new Property(Coverage.SP_CLASS, "string", "Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage such as a level of deductables or co-payment.", 0, 1, this.class_));
            children.add(new Property("classDisplay", "string", "A short description for the class.", 0, 1, this.classDisplay));
            children.add(new Property("subClass", "string", "Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a subclass of coverage such as a sub-level of deductables or co-payment.", 0, 1, this.subClass));
            children.add(new Property("subClassDisplay", "string", "A short description for the subclass.", 0, 1, this.subClassDisplay));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 98629247: {
                    return new Property(Coverage.SP_GROUP, "string", "Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify an employer group. May also be referred to as a Policy or Group ID.", 0, 1, this.group);
                }
                case 1322335555: {
                    return new Property("groupDisplay", "string", "A short description for the group.", 0, 1, this.groupDisplay);
                }
                case -2101792737: {
                    return new Property("subGroup", "string", "Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify a subset of an employer group.", 0, 1, this.subGroup);
                }
                case 1051914147: {
                    return new Property("subGroupDisplay", "string", "A short description for the subgroup.", 0, 1, this.subGroupDisplay);
                }
                case 3443497: {
                    return new Property(Coverage.SP_PLAN, "string", "Identifies a style or collective of coverage issued by the underwriter, for example may be used to identify a collection of benefits provided to employees. May be referred to as a Section or Division ID.", 0, 1, this.plan);
                }
                case -896076455: {
                    return new Property("planDisplay", "string", "A short description for the plan.", 0, 1, this.planDisplay);
                }
                case -1868653175: {
                    return new Property("subPlan", "string", "Identifies a sub-style or sub-collective of coverage issued by the underwriter, for example may be used to identify a subset of a collection of benefits provided to employees.", 0, 1, this.subPlan);
                }
                case -1736083719: {
                    return new Property("subPlanDisplay", "string", "A short description for the subplan.", 0, 1, this.subPlanDisplay);
                }
                case 94742904: {
                    return new Property(Coverage.SP_CLASS, "string", "Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage such as a level of deductables or co-payment.", 0, 1, this.class_);
                }
                case 1707405354: {
                    return new Property("classDisplay", "string", "A short description for the class.", 0, 1, this.classDisplay);
                }
                case -2105679080: {
                    return new Property("subClass", "string", "Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a subclass of coverage such as a sub-level of deductables or co-payment.", 0, 1, this.subClass);
                }
                case 1436983946: {
                    return new Property("subClassDisplay", "string", "A short description for the subclass.", 0, 1, this.subClassDisplay);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 98629247: {
                    Base[] baseArray;
                    if (this.group == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.group;
                    }
                    return baseArray;
                }
                case 1322335555: {
                    Base[] baseArray;
                    if (this.groupDisplay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.groupDisplay;
                    }
                    return baseArray;
                }
                case -2101792737: {
                    Base[] baseArray;
                    if (this.subGroup == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subGroup;
                    }
                    return baseArray;
                }
                case 1051914147: {
                    Base[] baseArray;
                    if (this.subGroupDisplay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.subGroupDisplay;
                    }
                    return baseArray;
                }
                case 3443497: {
                    Base[] baseArray;
                    if (this.plan == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.plan;
                    }
                    return baseArray;
                }
                case -896076455: {
                    Base[] baseArray;
                    if (this.planDisplay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.planDisplay;
                    }
                    return baseArray;
                }
                case -1868653175: {
                    Base[] baseArray;
                    if (this.subPlan == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.subPlan;
                    }
                    return baseArray;
                }
                case -1736083719: {
                    Base[] baseArray;
                    if (this.subPlanDisplay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.subPlanDisplay;
                    }
                    return baseArray;
                }
                case 94742904: {
                    Base[] baseArray;
                    if (this.class_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.class_;
                    }
                    return baseArray;
                }
                case 1707405354: {
                    Base[] baseArray;
                    if (this.classDisplay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.classDisplay;
                    }
                    return baseArray;
                }
                case -2105679080: {
                    Base[] baseArray;
                    if (this.subClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.subClass;
                    }
                    return baseArray;
                }
                case 1436983946: {
                    Base[] baseArray;
                    if (this.subClassDisplay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.subClassDisplay;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 98629247: {
                    this.group = this.castToString(value);
                    return value;
                }
                case 1322335555: {
                    this.groupDisplay = this.castToString(value);
                    return value;
                }
                case -2101792737: {
                    this.subGroup = this.castToString(value);
                    return value;
                }
                case 1051914147: {
                    this.subGroupDisplay = this.castToString(value);
                    return value;
                }
                case 3443497: {
                    this.plan = this.castToString(value);
                    return value;
                }
                case -896076455: {
                    this.planDisplay = this.castToString(value);
                    return value;
                }
                case -1868653175: {
                    this.subPlan = this.castToString(value);
                    return value;
                }
                case -1736083719: {
                    this.subPlanDisplay = this.castToString(value);
                    return value;
                }
                case 94742904: {
                    this.class_ = this.castToString(value);
                    return value;
                }
                case 1707405354: {
                    this.classDisplay = this.castToString(value);
                    return value;
                }
                case -2105679080: {
                    this.subClass = this.castToString(value);
                    return value;
                }
                case 1436983946: {
                    this.subClassDisplay = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_GROUP)) {
                this.group = this.castToString(value);
            } else if (name.equals("groupDisplay")) {
                this.groupDisplay = this.castToString(value);
            } else if (name.equals("subGroup")) {
                this.subGroup = this.castToString(value);
            } else if (name.equals("subGroupDisplay")) {
                this.subGroupDisplay = this.castToString(value);
            } else if (name.equals(Coverage.SP_PLAN)) {
                this.plan = this.castToString(value);
            } else if (name.equals("planDisplay")) {
                this.planDisplay = this.castToString(value);
            } else if (name.equals("subPlan")) {
                this.subPlan = this.castToString(value);
            } else if (name.equals("subPlanDisplay")) {
                this.subPlanDisplay = this.castToString(value);
            } else if (name.equals(Coverage.SP_CLASS)) {
                this.class_ = this.castToString(value);
            } else if (name.equals("classDisplay")) {
                this.classDisplay = this.castToString(value);
            } else if (name.equals("subClass")) {
                this.subClass = this.castToString(value);
            } else if (name.equals("subClassDisplay")) {
                this.subClassDisplay = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 98629247: {
                    return this.getGroupElement();
                }
                case 1322335555: {
                    return this.getGroupDisplayElement();
                }
                case -2101792737: {
                    return this.getSubGroupElement();
                }
                case 1051914147: {
                    return this.getSubGroupDisplayElement();
                }
                case 3443497: {
                    return this.getPlanElement();
                }
                case -896076455: {
                    return this.getPlanDisplayElement();
                }
                case -1868653175: {
                    return this.getSubPlanElement();
                }
                case -1736083719: {
                    return this.getSubPlanDisplayElement();
                }
                case 94742904: {
                    return this.getClass_Element();
                }
                case 1707405354: {
                    return this.getClassDisplayElement();
                }
                case -2105679080: {
                    return this.getSubClassElement();
                }
                case 1436983946: {
                    return this.getSubClassDisplayElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 98629247: {
                    return new String[]{"string"};
                }
                case 1322335555: {
                    return new String[]{"string"};
                }
                case -2101792737: {
                    return new String[]{"string"};
                }
                case 1051914147: {
                    return new String[]{"string"};
                }
                case 3443497: {
                    return new String[]{"string"};
                }
                case -896076455: {
                    return new String[]{"string"};
                }
                case -1868653175: {
                    return new String[]{"string"};
                }
                case -1736083719: {
                    return new String[]{"string"};
                }
                case 94742904: {
                    return new String[]{"string"};
                }
                case 1707405354: {
                    return new String[]{"string"};
                }
                case -2105679080: {
                    return new String[]{"string"};
                }
                case 1436983946: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_GROUP)) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.group");
            }
            if (name.equals("groupDisplay")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.groupDisplay");
            }
            if (name.equals("subGroup")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.subGroup");
            }
            if (name.equals("subGroupDisplay")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.subGroupDisplay");
            }
            if (name.equals(Coverage.SP_PLAN)) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.plan");
            }
            if (name.equals("planDisplay")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.planDisplay");
            }
            if (name.equals("subPlan")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.subPlan");
            }
            if (name.equals("subPlanDisplay")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.subPlanDisplay");
            }
            if (name.equals(Coverage.SP_CLASS)) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.class");
            }
            if (name.equals("classDisplay")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.classDisplay");
            }
            if (name.equals("subClass")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.subClass");
            }
            if (name.equals("subClassDisplay")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.subClassDisplay");
            }
            return super.addChild(name);
        }

        @Override
        public GroupComponent copy() {
            GroupComponent dst = new GroupComponent();
            this.copyValues(dst);
            dst.group = this.group == null ? null : this.group.copy();
            dst.groupDisplay = this.groupDisplay == null ? null : this.groupDisplay.copy();
            dst.subGroup = this.subGroup == null ? null : this.subGroup.copy();
            dst.subGroupDisplay = this.subGroupDisplay == null ? null : this.subGroupDisplay.copy();
            dst.plan = this.plan == null ? null : this.plan.copy();
            dst.planDisplay = this.planDisplay == null ? null : this.planDisplay.copy();
            dst.subPlan = this.subPlan == null ? null : this.subPlan.copy();
            dst.subPlanDisplay = this.subPlanDisplay == null ? null : this.subPlanDisplay.copy();
            dst.class_ = this.class_ == null ? null : this.class_.copy();
            dst.classDisplay = this.classDisplay == null ? null : this.classDisplay.copy();
            dst.subClass = this.subClass == null ? null : this.subClass.copy();
            dst.subClassDisplay = this.subClassDisplay == null ? null : this.subClassDisplay.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GroupComponent)) {
                return false;
            }
            GroupComponent o = (GroupComponent)other_;
            return GroupComponent.compareDeep(this.group, o.group, true) && GroupComponent.compareDeep(this.groupDisplay, o.groupDisplay, true) && GroupComponent.compareDeep(this.subGroup, o.subGroup, true) && GroupComponent.compareDeep(this.subGroupDisplay, o.subGroupDisplay, true) && GroupComponent.compareDeep(this.plan, o.plan, true) && GroupComponent.compareDeep(this.planDisplay, o.planDisplay, true) && GroupComponent.compareDeep(this.subPlan, o.subPlan, true) && GroupComponent.compareDeep(this.subPlanDisplay, o.subPlanDisplay, true) && GroupComponent.compareDeep(this.class_, o.class_, true) && GroupComponent.compareDeep(this.classDisplay, o.classDisplay, true) && GroupComponent.compareDeep(this.subClass, o.subClass, true) && GroupComponent.compareDeep(this.subClassDisplay, o.subClassDisplay, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GroupComponent)) {
                return false;
            }
            GroupComponent o = (GroupComponent)other_;
            return GroupComponent.compareValues(this.group, o.group, true) && GroupComponent.compareValues(this.groupDisplay, o.groupDisplay, true) && GroupComponent.compareValues(this.subGroup, o.subGroup, true) && GroupComponent.compareValues(this.subGroupDisplay, o.subGroupDisplay, true) && GroupComponent.compareValues(this.plan, o.plan, true) && GroupComponent.compareValues(this.planDisplay, o.planDisplay, true) && GroupComponent.compareValues(this.subPlan, o.subPlan, true) && GroupComponent.compareValues(this.subPlanDisplay, o.subPlanDisplay, true) && GroupComponent.compareValues(this.class_, o.class_, true) && GroupComponent.compareValues(this.classDisplay, o.classDisplay, true) && GroupComponent.compareValues(this.subClass, o.subClass, true) && GroupComponent.compareValues(this.subClassDisplay, o.subClassDisplay, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.group, this.groupDisplay, this.subGroup, this.subGroupDisplay, this.plan, this.planDisplay, this.subPlan, this.subPlanDisplay, this.class_, this.classDisplay, this.subClass, this.subClassDisplay});
        }

        @Override
        public String fhirType() {
            return "Coverage.grouping";
        }
    }

    public static class CoverageStatusEnumFactory
    implements EnumFactory<CoverageStatus> {
        @Override
        public CoverageStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return CoverageStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CoverageStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return CoverageStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return CoverageStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown CoverageStatus code '" + codeString + "'");
        }

        public Enumeration<CoverageStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CoverageStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<CoverageStatus>(this, CoverageStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<CoverageStatus>(this, CoverageStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<CoverageStatus>(this, CoverageStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CoverageStatus>(this, CoverageStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown CoverageStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CoverageStatus code) {
            if (code == CoverageStatus.NULL) {
                return null;
            }
            if (code == CoverageStatus.ACTIVE) {
                return "active";
            }
            if (code == CoverageStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == CoverageStatus.DRAFT) {
                return "draft";
            }
            if (code == CoverageStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(CoverageStatus code) {
            return code.getSystem();
        }
    }

    public static enum CoverageStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static CoverageStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CoverageStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

