/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.conformance;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.Element;
import org.hl7.fhir.dstu3.elementmodel.ObjectConverter;
import org.hl7.fhir.dstu3.elementmodel.Property;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.utils.NarrativeGenerator;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.dstu3.utils.TranslatingUtilities;
import org.hl7.fhir.dstu3.utils.formats.CSVWriter;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.SchematronWriter;

@Deprecated
public class ProfileUtilities
extends TranslatingUtilities {
    private static int nextSliceId = 0;
    private static final String ROW_COLOR_ERROR = "#ffcccc";
    private static final String ROW_COLOR_FATAL = "#ff9999";
    private static final String ROW_COLOR_WARNING = "#ffebcc";
    private static final String ROW_COLOR_HINT = "#ebf5ff";
    private static final String ROW_COLOR_NOT_MUST_SUPPORT = "#d6eaf8";
    public static final int STATUS_OK = 0;
    public static final int STATUS_HINT = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_FATAL = 4;
    private static final String DERIVATION_EQUALS = "derivation.equals";
    public static final String DERIVATION_POINTER = "derived.pointer";
    public static final String IS_DERIVED = "derived.fact";
    public static final String UD_ERROR_STATUS = "error-status";
    private static final String GENERATED_IN_SNAPSHOT = "profileutilities.snapshot.processed";
    private final IWorkerContext context;
    private List<ValidationMessage> messages;
    private List<String> snapshotStack = new ArrayList<String>();
    private ProfileKnowledgeProvider pkp;
    private boolean igmode;
    private static final int AGG_NONE = 0;
    private static final int AGG_IND = 1;
    private static final int AGG_GR = 2;

    public ProfileUtilities(IWorkerContext context, List<ValidationMessage> messages, ProfileKnowledgeProvider pkp) {
        this.context = context;
        this.messages = messages;
        this.pkp = pkp;
    }

    public boolean isIgmode() {
        return this.igmode;
    }

    public void setIgmode(boolean igmode) {
        this.igmode = igmode;
    }

    public static List<ElementDefinition> getChildMap(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        ElementDefinition e;
        if (element.getContentReference() != null) {
            for (ElementDefinition e2 : profile.getSnapshot().getElement()) {
                if (!element.getContentReference().equals("#" + e2.getId())) continue;
                return ProfileUtilities.getChildMap(profile, e2);
            }
            throw new DefinitionException("Unable to resolve name reference " + element.getContentReference() + " at path " + element.getPath());
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        String path = element.getPath();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && (e = elements.get(index)).getPath().startsWith(path + "."); ++index) {
            if (e.getPath().substring(path.length() + 1).contains(".")) continue;
            res.add(e);
        }
        return res;
    }

    public static List<ElementDefinition> getSliceList(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        ElementDefinition e;
        if (!element.hasSlicing()) {
            throw new Error("getSliceList should only be called when the element has slicing");
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        String path = element.getPath();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && ((e = elements.get(index)).getPath().startsWith(path + ".") || e.getPath().equals(path)); ++index) {
            if (!e.getPath().equals(element.getPath())) continue;
            res.add(e);
        }
        return res;
    }

    public static List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id) {
        boolean capturing;
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        boolean bl = capturing = id == null;
        if (id == null && !path.contains(".")) {
            capturing = true;
        }
        for (ElementDefinition e : profile.getSnapshot().getElement()) {
            String tail;
            if (!capturing && id != null && e.getId().equals(id)) {
                capturing = true;
            }
            if (capturing && e.hasId() && id != null && !e.getId().equals(id) && e.getPath().equals(path)) break;
            if (!capturing) continue;
            String p = e.getPath();
            if (!Utilities.noString((String)e.getContentReference()) && path.startsWith(p)) {
                if (path.length() > p.length()) {
                    return ProfileUtilities.getChildList(profile, e.getContentReference() + "." + path.substring(p.length() + 1), null);
                }
                return ProfileUtilities.getChildList(profile, e.getContentReference(), null);
            }
            if (!p.startsWith(path + ".") || p.equals(path) || (tail = p.substring(path.length() + 1)).contains(".")) continue;
            res.add(e);
        }
        return res;
    }

    public static List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element) {
        return ProfileUtilities.getChildList(structure, element.getPath(), element.getId());
    }

    public void updateMaps(StructureDefinition base, StructureDefinition derived) throws DefinitionException {
        if (base == null) {
            throw new DefinitionException("no base profile provided");
        }
        if (derived == null) {
            throw new DefinitionException("no derived structure provided");
        }
        for (StructureDefinition.StructureDefinitionMappingComponent baseMap : base.getMapping()) {
            boolean found = false;
            for (StructureDefinition.StructureDefinitionMappingComponent derivedMap : derived.getMapping()) {
                if (!derivedMap.getUri().equals(baseMap.getUri())) continue;
                found = true;
                break;
            }
            if (found) continue;
            derived.getMapping().add(baseMap);
        }
    }

    public void generateSnapshot(StructureDefinition base, StructureDefinition derived, String url, String profileName) throws DefinitionException, FHIRException {
        if (base == null) {
            throw new DefinitionException("no base profile provided");
        }
        if (derived == null) {
            throw new DefinitionException("no derived structure provided");
        }
        if (this.snapshotStack.contains(derived.getUrl())) {
            throw new DefinitionException("Circular snapshot references detected; cannot generate snapshot (stack = " + this.snapshotStack.toString() + ")");
        }
        this.snapshotStack.add(derived.getUrl());
        derived.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
        int baseCursor = 0;
        int diffCursor = 0;
        if (derived.hasDifferential() && !derived.getDifferential().getElementFirstRep().getPath().contains(".") && !derived.getDifferential().getElementFirstRep().getType().isEmpty()) {
            throw new Error("type on first differential element!");
        }
        for (ElementDefinition e : derived.getDifferential().getElement()) {
            e.clearUserData(GENERATED_IN_SNAPSHOT);
        }
        this.processPaths("", derived.getSnapshot(), base.getSnapshot(), derived.getDifferential(), baseCursor, diffCursor, base.getSnapshot().getElement().size() - 1, derived.getDifferential().hasElement() ? derived.getDifferential().getElement().size() - 1 : -1, url, derived.getId(), null, null, false, base.getUrl(), null, false);
        if (!derived.getSnapshot().getElementFirstRep().getType().isEmpty()) {
            throw new Error("type on first snapshot element for " + derived.getSnapshot().getElementFirstRep().getPath() + " in " + derived.getUrl() + " from " + base.getUrl());
        }
        this.updateMaps(base, derived);
        this.setIds(derived, false);
        for (ElementDefinition e : derived.getDifferential().getElement()) {
            if (e.hasUserData(GENERATED_IN_SNAPSHOT)) continue;
            System.out.println("Error in snapshot generation: Snapshot for " + derived.getUrl() + " does not contain differential element with id: " + e.getId());
            System.out.println("Differential: ");
            for (ElementDefinition ed : derived.getDifferential().getElement()) {
                System.out.println("  " + ed.getPath() + " : " + this.typeSummary(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  id = " + ed.getId());
            }
            System.out.println("Snapshot: ");
            for (ElementDefinition ed : derived.getSnapshot().getElement()) {
                System.out.println("  " + ed.getPath() + " : " + this.typeSummary(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  id = " + ed.getId());
            }
            throw new DefinitionException("Snapshot for " + derived.getUrl() + " does not contain differential element with id: " + e.getId());
        }
    }

    private String sliceSummary(ElementDefinition ed) {
        if (!ed.hasSlicing() && !ed.hasSliceName()) {
            return "";
        }
        if (ed.hasSliceName()) {
            return " (slicename = " + ed.getSliceName() + ")";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : ed.getSlicing().getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(d.getPath());
        }
        return " (slicing by " + b.toString() + ")";
    }

    private String typeSummary(ElementDefinition ed) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(tr.getCode());
        }
        return b.toString();
    }

    private boolean findMatchingElement(String id, List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (ed.getId().equals(id)) {
                return true;
            }
            if (!id.endsWith("[x]") || !ed.getId().startsWith(id.substring(0, id.length() - 3)) || ed.getId().substring(id.length() - 3).contains(".")) continue;
            return true;
        }
        return false;
    }

    private ElementDefinition processPaths(String indent, StructureDefinition.StructureDefinitionSnapshotComponent result, StructureDefinition.StructureDefinitionSnapshotComponent base, StructureDefinition.StructureDefinitionDifferentialComponent differential, int baseCursor, int diffCursor, int baseLimit, int diffLimit, String url, String profileName, String contextPathSrc, String contextPathDst, boolean trimDifferential, String contextName, String resultPathBase, boolean slicingDone) throws DefinitionException, FHIRException {
        ElementDefinition res = null;
        while (baseCursor <= baseLimit) {
            boolean isExtension;
            ElementDefinition currentBase = base.getElement().get(baseCursor);
            String cpath = this.fixedPath(contextPathSrc, currentBase.getPath());
            List<ElementDefinition> diffMatches = this.getDiffMatches(differential, cpath, diffCursor, diffLimit, profileName, url);
            if (!currentBase.hasSlicing()) {
                if (diffMatches.isEmpty()) {
                    ElementDefinition outcome = this.updateURLs(url, currentBase.copy());
                    outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                    this.updateFromBase(outcome, currentBase);
                    this.markDerived(outcome);
                    if (resultPathBase == null) {
                        resultPathBase = outcome.getPath();
                    } else if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    if (this.hasInnerDiffMatches(differential, cpath, diffCursor, diffLimit, base.getElement())) {
                        StructureDefinition dt;
                        if (outcome.getType().size() > 1) {
                            for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                                if (t.getCode().equals("Reference")) continue;
                                throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") and multiple types (" + ProfileUtilities.typeCode(outcome.getType()) + ") in profile " + profileName);
                            }
                        }
                        if ((dt = this.getProfileForDataType(outcome.getType().get(0))) == null) {
                            throw new DefinitionException(cpath + " has children for type " + ProfileUtilities.typeCode(outcome.getType()) + " in profile " + profileName + ", but can't find type");
                        }
                        contextName = dt.getUrl();
                        int start = diffCursor;
                        while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), cpath + ".")) {
                            ++diffCursor;
                        }
                        this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, profileName, cpath, outcome.getPath(), trimDifferential, contextName, resultPathBase, false);
                    }
                    ++baseCursor;
                    continue;
                }
                if (!(diffMatches.size() != 1 || !slicingDone && (diffMatches.get(0).hasSlicing() || this.isExtension(diffMatches.get(0)) && diffMatches.get(0).hasSliceName()))) {
                    String p;
                    StructureDefinition sd;
                    ElementDefinition template = null;
                    if (diffMatches.get(0).hasType() && diffMatches.get(0).getType().size() == 1 && diffMatches.get(0).getType().get(0).hasProfile() && !diffMatches.get(0).getType().get(0).getCode().equals("Reference") && (sd = this.context.fetchResource(StructureDefinition.class, p = diffMatches.get(0).getType().get(0).getProfile())) != null) {
                        if (!sd.hasSnapshot()) {
                            StructureDefinition sdb = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                            if (sdb == null) {
                                throw new DefinitionException("no base for " + sd.getBaseDefinition());
                            }
                            this.generateSnapshot(sdb, sd, sd.getUrl(), sd.getName());
                        }
                        template = sd.getSnapshot().getElement().get(0).copy().setPath(currentBase.getPath());
                        template.setSliceName(null);
                        if (!diffMatches.get(0).getType().get(0).getCode().equals("Extension")) {
                            template.setMin(currentBase.getMin());
                            template.setMax(currentBase.getMax());
                        }
                    }
                    template = template == null ? currentBase.copy() : this.overWriteWithCurrent(template, currentBase);
                    ElementDefinition outcome = this.updateURLs(url, template);
                    outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                    res = outcome;
                    this.updateFromBase(outcome, currentBase);
                    if (diffMatches.get(0).hasSliceName()) {
                        outcome.setSliceName(diffMatches.get(0).getSliceName());
                    }
                    outcome.setSlicing(null);
                    this.updateFromDefinition(outcome, diffMatches.get(0), profileName, trimDifferential, url);
                    if (outcome.getPath().endsWith("[x]") && outcome.getType().size() == 1 && !outcome.getType().get(0).getCode().equals("*")) {
                        outcome.setPath(outcome.getPath().substring(0, outcome.getPath().length() - 3) + Utilities.capitalize((String)outcome.getType().get(0).getCode()));
                    }
                    if (resultPathBase == null) {
                        resultPathBase = outcome.getPath();
                    } else if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    diffCursor = differential.getElement().indexOf(diffMatches.get(0)) + 1;
                    if (differential.getElement().size() <= diffCursor || !outcome.getPath().contains(".") || !this.isDataType(outcome.getType()) && !outcome.hasContentReference() || !this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".") || this.baseWalksInto(base.getElement(), ++baseCursor)) continue;
                    if (outcome.getType().size() > 1) {
                        for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                            if (t.getCode().equals("Reference")) continue;
                            throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") and multiple types (" + ProfileUtilities.typeCode(outcome.getType()) + ") in profile " + profileName);
                        }
                    }
                    int start = diffCursor;
                    while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                        ++diffCursor;
                    }
                    if (outcome.hasContentReference()) {
                        int nbc;
                        int nbl;
                        ElementDefinition tgt = this.getElementById(base.getElement(), outcome.getContentReference());
                        if (tgt == null) {
                            throw new DefinitionException("Unable to resolve reference to " + outcome.getContentReference());
                        }
                        this.replaceFromContentReference(outcome, tgt);
                        for (nbl = nbc = base.getElement().indexOf(tgt) + 1; nbl < base.getElement().size() && base.getElement().get(nbl).getPath().startsWith(tgt.getPath() + "."); ++nbl) {
                        }
                        this.processPaths(indent + "  ", result, base, differential, nbc, start - 1, nbl - 1, diffCursor - 1, url, profileName, tgt.getPath(), diffMatches.get(0).getPath(), trimDifferential, contextName, resultPathBase, false);
                        continue;
                    }
                    StructureDefinition dt = this.getProfileForDataType(outcome.getType().get(0));
                    if (dt == null) {
                        throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") for type " + ProfileUtilities.typeCode(outcome.getType()) + " in profile " + profileName + ", but can't find type");
                    }
                    contextName = dt.getUrl();
                    this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start - 1, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, profileName + this.pathTail(diffMatches, 0), diffMatches.get(0).getPath(), outcome.getPath(), trimDifferential, contextName, resultPathBase, false);
                    continue;
                }
                if (!this.unbounded(currentBase) && !this.isSlicedToOneOnly(diffMatches.get(0))) {
                    throw new DefinitionException("Attempt to a slice an element that does not repeat: " + currentBase.getPath() + "/" + currentBase.getSliceName() + " from " + contextName + " in " + url);
                }
                if (!diffMatches.get(0).hasSlicing() && !this.isExtension(currentBase)) {
                    throw new DefinitionException("differential does not have a slice: " + currentBase.getPath() + " in profile " + url);
                }
                int start = 0;
                int nbl = this.findEndOfElement(base, baseCursor);
                if (diffMatches.size() > 1 && diffMatches.get(0).hasSlicing() && differential.getElement().indexOf(diffMatches.get(1)) > differential.getElement().indexOf(diffMatches.get(0)) + 1) {
                    int ndc = differential.getElement().indexOf(diffMatches.get(0));
                    int ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, profileName + this.pathTail(diffMatches, 0), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true).setSlicing(diffMatches.get(0).getSlicing());
                } else {
                    ElementDefinition outcome = this.updateURLs(url, currentBase.copy());
                    outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                    this.updateFromBase(outcome, currentBase);
                    if (!diffMatches.get(0).hasSlicing()) {
                        outcome.setSlicing(this.makeExtensionSlicing());
                    } else {
                        outcome.setSlicing(diffMatches.get(0).getSlicing().copy());
                    }
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    if (!diffMatches.get(0).hasSliceName()) {
                        this.updateFromDefinition(outcome, diffMatches.get(0), profileName, trimDifferential, url);
                        if (!outcome.hasContentReference() && !outcome.hasType()) {
                            throw new DefinitionException("not done yet");
                        }
                        ++start;
                    } else {
                        this.checkExtensionDoco(outcome);
                    }
                }
                int ndc = diffCursor;
                int ndl = diffCursor;
                for (int i = ++start; i < diffMatches.size(); ++i) {
                    ndc = differential.getElement().indexOf(diffMatches.get(i));
                    ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, profileName + this.pathTail(diffMatches, i), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true);
                }
                baseCursor = nbl + 1;
                diffCursor = ndl + 1;
                continue;
            }
            String path = currentBase.getPath();
            ElementDefinition original = currentBase;
            if (diffMatches.isEmpty()) {
                while (baseCursor < base.getElement().size() && base.getElement().get(baseCursor).getPath().startsWith(path)) {
                    ElementDefinition outcome = this.updateURLs(url, base.getElement().get(baseCursor).copy());
                    outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path in profile " + profileName + ": " + outcome.getPath() + " vs " + resultPathBase);
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                }
                continue;
            }
            boolean closed = currentBase.getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED;
            int diffpos = 0;
            boolean bl = isExtension = cpath.endsWith(".extension") || cpath.endsWith(".modifierExtension");
            if (diffMatches.get(0).hasSlicing()) {
                if (!isExtension) {
                    ++diffpos;
                }
                ElementDefinition.ElementDefinitionSlicingComponent dSlice = diffMatches.get(0).getSlicing();
                ElementDefinition.ElementDefinitionSlicingComponent bSlice = currentBase.getSlicing();
                if (dSlice.hasOrderedElement() && bSlice.hasOrderedElement() && !this.orderMatches(dSlice.getOrderedElement(), bSlice.getOrderedElement())) {
                    throw new DefinitionException("Slicing rules on differential (" + this.summariseSlicing(dSlice) + ") do not match those on base (" + this.summariseSlicing(bSlice) + ") - order @ " + path + " (" + contextName + ")");
                }
                if (!this.discriminatorMatches(dSlice.getDiscriminator(), bSlice.getDiscriminator())) {
                    throw new DefinitionException("Slicing rules on differential (" + this.summariseSlicing(dSlice) + ") do not match those on base (" + this.summariseSlicing(bSlice) + ") - discriminator @ " + path + " (" + contextName + ")");
                }
                if (!this.ruleMatches(dSlice.getRules(), bSlice.getRules())) {
                    throw new DefinitionException("Slicing rules on differential (" + this.summariseSlicing(dSlice) + ") do not match those on base (" + this.summariseSlicing(bSlice) + ") - rule @ " + path + " (" + contextName + ")");
                }
            }
            if (diffMatches.size() > 1 && diffMatches.get(0).hasSlicing() && differential.getElement().indexOf(diffMatches.get(1)) > differential.getElement().indexOf(diffMatches.get(0)) + 1) {
                throw new Error("Not done yet");
            }
            ElementDefinition outcome = this.updateURLs(url, currentBase.copy());
            outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
            this.updateFromBase(outcome, currentBase);
            if (diffMatches.get(0).hasSlicing()) {
                this.updateFromSlicing(outcome.getSlicing(), diffMatches.get(0).getSlicing());
                this.updateFromDefinition(outcome, diffMatches.get(0), profileName, closed, url);
            } else if (!diffMatches.get(0).hasSliceName()) {
                diffMatches.get(0).setUserData(GENERATED_IN_SNAPSHOT, true);
            }
            result.getElement().add(outcome);
            if (!diffMatches.get(0).hasSliceName()) {
                ++diffpos;
            }
            List<ElementDefinition> baseMatches = this.getSiblings(base.getElement(), currentBase);
            for (ElementDefinition elementDefinition : baseMatches) {
                baseCursor = base.getElement().indexOf(elementDefinition);
                outcome = this.updateURLs(url, elementDefinition.copy());
                this.updateFromBase(outcome, currentBase);
                outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                outcome.setSlicing(null);
                if (!outcome.getPath().startsWith(resultPathBase)) {
                    throw new DefinitionException("Adding wrong path");
                }
                if (diffpos < diffMatches.size() && diffMatches.get(diffpos).getSliceName().equals(outcome.getSliceName())) {
                    int nbl = this.findEndOfElement(base, baseCursor);
                    int ndc = differential.getElement().indexOf(diffMatches.get(diffpos));
                    int ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, profileName + this.pathTail(diffMatches, diffpos), contextPathSrc, contextPathDst, closed, contextName, resultPathBase, true);
                    baseCursor = nbl;
                    diffCursor = ndl + 1;
                    ++diffpos;
                    continue;
                }
                result.getElement().add(outcome);
                ++baseCursor;
                while (baseCursor < base.getElement().size() && base.getElement().get(baseCursor).getPath().startsWith(path) && !base.getElement().get(baseCursor).getPath().equals(path)) {
                    outcome = this.updateURLs(url, base.getElement().get(baseCursor).copy());
                    outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                }
                --baseCursor;
            }
            if (closed && diffpos < diffMatches.size()) {
                throw new DefinitionException("The base snapshot marks a slicing as closed, but the differential tries to extend it in " + profileName + " at " + path + " (" + cpath + ")");
            }
            if (diffpos == diffMatches.size()) {
                ++diffCursor;
            } else {
                while (diffpos < diffMatches.size()) {
                    ElementDefinition diffItem = diffMatches.get(diffpos);
                    for (ElementDefinition baseItem2 : baseMatches) {
                        if (!baseItem2.getSliceName().equals(diffItem.getSliceName())) continue;
                        throw new DefinitionException("Named items are out of order in the slice");
                    }
                    outcome = this.updateURLs(url, currentBase.copy());
                    outcome.setPath(this.fixedPath(contextPathDst, outcome.getPath()));
                    this.updateFromBase(outcome, currentBase);
                    outcome.setSlicing(null);
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    this.updateFromDefinition(outcome, diffItem, profileName, trimDifferential, url);
                    diffCursor = differential.getElement().indexOf(diffItem) + 1;
                    if (!outcome.getType().isEmpty() && differential.getElement().size() > diffCursor && outcome.getPath().contains(".") && this.isDataType(outcome.getType()) && !this.baseWalksInto(base.getElement(), baseCursor)) {
                        if (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                            if (outcome.getType().size() > 1) {
                                for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                                    if (t.getCode().equals("Reference")) continue;
                                    throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") and multiple types (" + ProfileUtilities.typeCode(outcome.getType()) + ") in profile " + profileName);
                                }
                            }
                            ElementDefinition.TypeRefComponent typeRefComponent = outcome.getType().get(0);
                            StructureDefinition dt = this.getProfileForDataType(outcome.getType().get(0));
                            if (dt == null) {
                                throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") for type " + ProfileUtilities.typeCode(outcome.getType()) + " in profile " + profileName + ", but can't find type");
                            }
                            contextName = dt.getUrl();
                            int start = diffCursor;
                            while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                                ++diffCursor;
                            }
                            this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start - 1, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, profileName + this.pathTail(diffMatches, 0), diffMatches.get(0).getPath(), outcome.getPath(), trimDifferential, contextName, resultPathBase, false);
                        } else if (outcome.getType().get(0).getCode().equals("Extension")) {
                            StructureDefinition structureDefinition = this.getProfileForDataType(outcome.getType().get(0));
                            for (ElementDefinition extEd : structureDefinition.getSnapshot().getElement()) {
                                if (!extEd.getPath().contains(".")) continue;
                                ElementDefinition extUrlEd = this.updateURLs(url, extEd.copy());
                                extUrlEd.setPath(this.fixedPath(outcome.getPath(), extUrlEd.getPath()));
                                this.markDerived(extUrlEd);
                                result.getElement().add(extUrlEd);
                            }
                        }
                    }
                    ++diffpos;
                }
            }
            ++baseCursor;
        }
        int i = 0;
        for (ElementDefinition e : result.getElement()) {
            ++i;
            if (!e.hasMinElement() || e.getMinElement().getValue() != null) continue;
            throw new Error("null min");
        }
        return res;
    }

    private void replaceFromContentReference(ElementDefinition outcome, ElementDefinition tgt) {
        outcome.setContentReference(null);
        outcome.getType().clear();
        outcome.getType().addAll(tgt.getType());
    }

    private boolean baseWalksInto(List<ElementDefinition> elements, int cursor) {
        if (cursor >= elements.size()) {
            return false;
        }
        String path = elements.get(cursor).getPath();
        String prevPath = elements.get(cursor - 1).getPath();
        return path.startsWith(prevPath + ".");
    }

    private ElementDefinition overWriteWithCurrent(ElementDefinition profile, ElementDefinition usage) throws FHIRFormatError {
        ElementDefinition res = profile.copy();
        if (usage.hasSliceName()) {
            res.setSliceName(usage.getSliceName());
        }
        if (usage.hasLabel()) {
            res.setLabel(usage.getLabel());
        }
        for (Coding coding : usage.getCode()) {
            res.addCode(coding);
        }
        if (usage.hasDefinition()) {
            res.setDefinition(usage.getDefinition());
        }
        if (usage.hasShort()) {
            res.setShort(usage.getShort());
        }
        if (usage.hasComment()) {
            res.setComment(usage.getComment());
        }
        if (usage.hasRequirements()) {
            res.setRequirements(usage.getRequirements());
        }
        for (StringType stringType : usage.getAlias()) {
            res.addAlias((String)stringType.getValue());
        }
        if (usage.hasMin()) {
            res.setMin(usage.getMin());
        }
        if (usage.hasMax()) {
            res.setMax(usage.getMax());
        }
        if (usage.hasFixed()) {
            res.setFixed(usage.getFixed());
        }
        if (usage.hasPattern()) {
            res.setPattern(usage.getPattern());
        }
        if (usage.hasExample()) {
            res.setExample(usage.getExample());
        }
        if (usage.hasMinValue()) {
            res.setMinValue(usage.getMinValue());
        }
        if (usage.hasMaxValue()) {
            res.setMaxValue(usage.getMaxValue());
        }
        if (usage.hasMaxLength()) {
            res.setMaxLength(usage.getMaxLength());
        }
        if (usage.hasMustSupport()) {
            res.setMustSupport(usage.getMustSupport());
        }
        if (usage.hasBinding()) {
            res.setBinding(usage.getBinding().copy());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : usage.getConstraint()) {
            res.addConstraint(elementDefinitionConstraintComponent);
        }
        return res;
    }

    private boolean checkExtensionDoco(ElementDefinition base) {
        boolean isExtension;
        boolean bl = isExtension = base.getPath().equals("Extension") || base.getPath().endsWith(".extension") || base.getPath().endsWith(".modifierExtension");
        if (isExtension) {
            base.setDefinition("An Extension");
            base.setShort("Extension");
            base.setCommentElement(null);
            base.setRequirementsElement(null);
            base.getAlias().clear();
            base.getMapping().clear();
        }
        return isExtension;
    }

    private String pathTail(List<ElementDefinition> diffMatches, int i) {
        ElementDefinition d = diffMatches.get(i);
        String s = d.getPath().contains(".") ? d.getPath().substring(d.getPath().lastIndexOf(".") + 1) : d.getPath();
        return "." + s + (String)(d.hasType() && d.getType().get(0).hasProfile() ? "[" + d.getType().get(0).getProfile() + "]" : "");
    }

    private void markDerived(ElementDefinition outcome) {
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : outcome.getConstraint()) {
            inv.setUserData(IS_DERIVED, true);
        }
    }

    private String summariseSlicing(ElementDefinition.ElementDefinitionSlicingComponent slice) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slice.getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(d);
        }
        b.append("(");
        if (slice.hasOrdered()) {
            b.append(slice.getOrderedElement().asStringValue());
        }
        b.append("/");
        if (slice.hasRules()) {
            b.append(slice.getRules().toCode());
        }
        b.append(")");
        if (slice.hasDescription()) {
            b.append(" \"");
            b.append(slice.getDescription());
            b.append("\"");
        }
        return b.toString();
    }

    private void updateFromBase(ElementDefinition derived, ElementDefinition base) {
        if (base.hasBase()) {
            if (!derived.hasBase()) {
                derived.setBase(new ElementDefinition.ElementDefinitionBaseComponent());
            }
            derived.getBase().setPath(base.getBase().getPath());
            derived.getBase().setMin(base.getBase().getMin());
            derived.getBase().setMax(base.getBase().getMax());
        } else {
            if (!derived.hasBase()) {
                derived.setBase(new ElementDefinition.ElementDefinitionBaseComponent());
            }
            derived.getBase().setPath(base.getPath());
            derived.getBase().setMin(base.getMin());
            derived.getBase().setMax(base.getMax());
        }
    }

    private boolean pathStartsWith(String p1, String p2) {
        return p1.startsWith(p2);
    }

    private boolean pathMatches(String p1, String p2) {
        return p1.equals(p2) || p2.endsWith("[x]") && p1.startsWith(p2.substring(0, p2.length() - 3)) && !p1.substring(p2.length() - 3).contains(".");
    }

    private String fixedPath(String contextPath, String pathSimple) {
        if (contextPath == null) {
            return pathSimple;
        }
        return contextPath + "." + pathSimple.substring(pathSimple.indexOf(".") + 1);
    }

    private StructureDefinition getProfileForDataType(ElementDefinition.TypeRefComponent type) {
        StructureDefinition sd = null;
        if (type.hasProfile() && !type.getCode().equals("Reference")) {
            sd = this.context.fetchResource(StructureDefinition.class, type.getProfile());
        }
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(type.getCode());
        }
        if (sd == null) {
            System.out.println("XX: failed to find profle for type: " + type.getCode());
        }
        return sd;
    }

    public static String typeCode(List<ElementDefinition.TypeRefComponent> types) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent type : types) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(type.getCode());
            if (type.hasTargetProfile()) {
                b.append("{" + type.getTargetProfile() + "}");
                continue;
            }
            if (!type.hasProfile()) continue;
            b.append("{" + type.getProfile() + "}");
        }
        return b.toString();
    }

    private boolean isDataType(List<ElementDefinition.TypeRefComponent> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent type : types) {
            String t = type.getCode();
            if (this.isDataType(t) || this.isPrimitive(t)) continue;
            return false;
        }
        return true;
    }

    private ElementDefinition updateURLs(String url, ElementDefinition element) {
        if (element != null) {
            ElementDefinition defn = element;
            if (defn.hasBinding() && defn.getBinding().getValueSet() instanceof Reference && ((Reference)defn.getBinding().getValueSet()).getReference().startsWith("#")) {
                ((Reference)defn.getBinding().getValueSet()).setReference(url + ((Reference)defn.getBinding().getValueSet()).getReference());
            }
            for (ElementDefinition.TypeRefComponent t : defn.getType()) {
                if (t.hasProfile() && t.getProfile().startsWith("#")) {
                    t.setProfile(url + t.getProfile());
                }
                if (!t.hasTargetProfile() || !t.getTargetProfile().startsWith("#")) continue;
                t.setTargetProfile(url + t.getTargetProfile());
            }
        }
        return element;
    }

    private List<ElementDefinition> getSiblings(List<ElementDefinition> list, ElementDefinition current) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        String path = current.getPath();
        for (int cursor = list.indexOf(current) + 1; cursor < list.size() && list.get(cursor).getPath().length() >= path.length(); ++cursor) {
            if (!this.pathMatches(list.get(cursor).getPath(), path)) continue;
            result.add(list.get(cursor));
        }
        return result;
    }

    private void updateFromSlicing(ElementDefinition.ElementDefinitionSlicingComponent dst, ElementDefinition.ElementDefinitionSlicingComponent src) {
        if (src.hasOrderedElement()) {
            dst.setOrderedElement(src.getOrderedElement().copy());
        }
        if (src.hasDiscriminator()) {
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s : src.getDiscriminator()) {
                boolean found = false;
                for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : dst.getDiscriminator()) {
                    if (!this.matches(d, s)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dst.getDiscriminator().add(s);
            }
        }
        if (src.hasRulesElement()) {
            dst.setRulesElement((Enumeration<ElementDefinition.SlicingRules>)src.getRulesElement().copy());
        }
    }

    private boolean orderMatches(BooleanType diff, BooleanType base) {
        return diff == null || base == null || diff.getValue() == base.getValue();
    }

    private boolean discriminatorMatches(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> diff, List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> base) {
        if (diff.isEmpty() || base.isEmpty()) {
            return true;
        }
        if (diff.size() != base.size()) {
            return false;
        }
        for (int i = 0; i < diff.size(); ++i) {
            if (this.matches(diff.get(i), base.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent c1, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent c2) {
        return c1.getType().equals((Object)c2.getType()) && c1.getPath().equals(c2.getPath());
    }

    private boolean ruleMatches(ElementDefinition.SlicingRules diff, ElementDefinition.SlicingRules base) {
        return diff == null || base == null || diff == base || diff == ElementDefinition.SlicingRules.OPEN || diff == ElementDefinition.SlicingRules.OPENATEND && base == ElementDefinition.SlicingRules.CLOSED;
    }

    private boolean isSlicedToOneOnly(ElementDefinition e) {
        return e.hasSlicing() && e.hasMaxElement() && e.getMax().equals("1");
    }

    private ElementDefinition.ElementDefinitionSlicingComponent makeExtensionSlicing() {
        ElementDefinition.ElementDefinitionSlicingComponent slice = new ElementDefinition.ElementDefinitionSlicingComponent();
        slice.setId(Integer.toString(++nextSliceId));
        slice.addDiscriminator().setPath("url").setType(ElementDefinition.DiscriminatorType.VALUE);
        slice.setOrdered(false);
        slice.setRules(ElementDefinition.SlicingRules.OPEN);
        return slice;
    }

    private boolean isExtension(ElementDefinition currentBase) {
        return currentBase.getPath().endsWith(".extension") || currentBase.getPath().endsWith(".modifierExtension");
    }

    private boolean hasInnerDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, List<ElementDefinition> base) throws DefinitionException {
        for (int i = start; i <= end; ++i) {
            String statedPath = context.getElement().get(i).getPath();
            if (!statedPath.startsWith(path + ".") || statedPath.substring(path.length() + 1).contains(".")) continue;
            boolean found = false;
            for (ElementDefinition ed : base) {
                String ep = ed.getPath();
                if (!ep.equals(statedPath) && (!ep.endsWith("[x]") || statedPath.length() <= ep.length() - 2 || !statedPath.substring(0, ep.length() - 3).equals(ep.substring(0, ep.length() - 3)) || statedPath.substring(ep.length()).contains("."))) continue;
                found = true;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private List<ElementDefinition> getDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, String profileName, String url) throws DefinitionException {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        for (int i = start; i <= end; ++i) {
            String statedPath = context.getElement().get(i).getPath();
            if (!statedPath.equals(path) && (!path.endsWith("[x]") || statedPath.length() <= path.length() - 2 || !statedPath.substring(0, path.length() - 3).equals(path.substring(0, path.length() - 3)) || statedPath.length() >= path.length() && statedPath.substring(path.length()).contains("."))) continue;
            result.add(context.getElement().get(i));
        }
        return result;
    }

    private int findEndOfElement(StructureDefinition.StructureDefinitionDifferentialComponent context, int cursor) {
        int result;
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    private int findEndOfElement(StructureDefinition.StructureDefinitionSnapshotComponent context, int cursor) {
        int result;
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    private boolean unbounded(ElementDefinition definition) {
        StringType max = definition.getMaxElement();
        if (max == null) {
            return false;
        }
        if (((String)max.getValue()).equals("1")) {
            return false;
        }
        return !((String)max.getValue()).equals("0");
    }

    private void updateFromDefinition(ElementDefinition dest, ElementDefinition source, String pn, boolean trimDifferential, String purl) throws DefinitionException, FHIRException {
        StructureDefinition profile;
        source.setUserData(GENERATED_IN_SNAPSHOT, true);
        ElementDefinition base = dest;
        ElementDefinition derived = source;
        derived.setUserData(DERIVATION_POINTER, base);
        StructureDefinition structureDefinition = profile = source.getType().size() == 1 && source.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, source.getTypeFirstRep().getProfile()) : null;
        if (profile != null) {
            ElementDefinition e = profile.getSnapshot().getElement().get(0);
            base.setDefinition(e.getDefinition());
            base.setShort(e.getShort());
            if (e.hasCommentElement()) {
                base.setCommentElement(e.getCommentElement());
            }
            if (e.hasRequirementsElement()) {
                base.setRequirementsElement(e.getRequirementsElement());
            }
            base.getAlias().clear();
            base.getAlias().addAll(e.getAlias());
            base.getMapping().clear();
            base.getMapping().addAll(e.getMapping());
        }
        if (derived != null) {
            boolean isExtension = this.checkExtensionDoco(base);
            if (derived.hasSliceName()) {
                base.setSliceName(derived.getSliceName());
            }
            if (derived.hasShortElement()) {
                if (!Base.compareDeep(derived.getShortElement(), base.getShortElement(), false)) {
                    base.setShortElement(derived.getShortElement().copy());
                } else if (trimDifferential) {
                    derived.setShortElement(null);
                } else if (derived.hasShortElement()) {
                    derived.getShortElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasDefinitionElement()) {
                if (derived.getDefinition().startsWith("...")) {
                    base.setDefinition(Utilities.appendDerivedTextToBase((String)base.getDefinition(), (String)derived.getDefinition()));
                } else if (!Base.compareDeep(derived.getDefinitionElement(), base.getDefinitionElement(), false)) {
                    base.setDefinitionElement(derived.getDefinitionElement().copy());
                } else if (trimDifferential) {
                    derived.setDefinitionElement(null);
                } else if (derived.hasDefinitionElement()) {
                    derived.getDefinitionElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasCommentElement()) {
                if (derived.getComment().startsWith("...")) {
                    base.setComment(Utilities.appendDerivedTextToBase((String)base.getComment(), (String)derived.getComment()));
                } else if (derived.hasCommentElement() != base.hasCommentElement() || !Base.compareDeep(derived.getCommentElement(), base.getCommentElement(), false)) {
                    base.setCommentElement(derived.getCommentElement().copy());
                } else if (trimDifferential) {
                    base.setCommentElement(derived.getCommentElement().copy());
                } else if (derived.hasCommentElement()) {
                    derived.getCommentElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasLabelElement()) {
                if (derived.getLabel().startsWith("...")) {
                    base.setLabel(Utilities.appendDerivedTextToBase((String)base.getLabel(), (String)derived.getLabel()));
                } else if (!base.hasLabelElement() || !Base.compareDeep(derived.getLabelElement(), base.getLabelElement(), false)) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (trimDifferential) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (derived.hasLabelElement()) {
                    derived.getLabelElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirementsElement()) {
                if (derived.getRequirements().startsWith("...")) {
                    base.setRequirements(Utilities.appendDerivedTextToBase((String)base.getRequirements(), (String)derived.getRequirements()));
                } else if (!base.hasRequirementsElement() || !Base.compareDeep(derived.getRequirementsElement(), base.getRequirementsElement(), false)) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (trimDifferential) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (derived.hasRequirementsElement()) {
                    derived.getRequirementsElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirements() && !base.getPath().contains(".")) {
                derived.setRequirements(null);
            }
            if (base.hasRequirements() && !base.getPath().contains(".")) {
                base.setRequirements(null);
            }
            if (derived.hasAlias()) {
                if (!Base.compareDeep(derived.getAlias(), base.getAlias(), false)) {
                    for (StringType stringType : derived.getAlias()) {
                        if (base.hasAlias((String)stringType.getValue())) continue;
                        base.getAlias().add(stringType.copy());
                    }
                } else if (trimDifferential) {
                    derived.getAlias().clear();
                } else {
                    for (StringType stringType : derived.getAlias()) {
                        stringType.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMinElement()) {
                if (!Base.compareDeep(derived.getMinElement(), base.getMinElement(), false)) {
                    if (derived.getMin() < base.getMin()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + source.getPath(), "Derived min  (" + Integer.toString(derived.getMin()) + ") cannot be less than base min (" + Integer.toString(base.getMin()) + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMinElement(derived.getMinElement().copy());
                } else if (trimDifferential) {
                    derived.setMinElement(null);
                } else {
                    derived.getMinElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxElement()) {
                if (!Base.compareDeep(derived.getMaxElement(), base.getMaxElement(), false)) {
                    if (this.isLargerMax(derived.getMax(), base.getMax())) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + source.getPath(), "Derived max (" + derived.getMax() + ") cannot be greater than base max (" + base.getMax() + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMaxElement(derived.getMaxElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxElement(null);
                } else {
                    derived.getMaxElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasFixed()) {
                if (!Base.compareDeep(derived.getFixed(), base.getFixed(), true)) {
                    base.setFixed(derived.getFixed().copy());
                } else if (trimDifferential) {
                    derived.setFixed(null);
                } else {
                    derived.getFixed().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasPattern()) {
                if (!Base.compareDeep(derived.getPattern(), base.getPattern(), false)) {
                    base.setPattern(derived.getPattern().copy());
                } else if (trimDifferential) {
                    derived.setPattern(null);
                } else {
                    derived.getPattern().setUserData(DERIVATION_EQUALS, true);
                }
            }
            for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : derived.getExample()) {
                boolean found = false;
                for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent2 : base.getExample()) {
                    if (!Base.compareDeep(elementDefinitionExampleComponent, elementDefinitionExampleComponent2, false)) continue;
                    found = true;
                }
                if (!found) {
                    base.addExample(elementDefinitionExampleComponent.copy());
                    continue;
                }
                if (trimDifferential) {
                    derived.getExample().remove(elementDefinitionExampleComponent);
                    continue;
                }
                elementDefinitionExampleComponent.setUserData(DERIVATION_EQUALS, true);
            }
            if (derived.hasMaxLengthElement()) {
                if (!Base.compareDeep(derived.getMaxLengthElement(), base.getMaxLengthElement(), false)) {
                    base.setMaxLengthElement(derived.getMaxLengthElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxLengthElement(null);
                } else {
                    derived.getMaxLengthElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxValue()) {
                if (!Base.compareDeep(derived.getMaxValue(), base.getMaxValue(), false)) {
                    base.setMaxValue(derived.getMaxValue().copy());
                } else if (trimDifferential) {
                    derived.setMaxValue(null);
                } else {
                    derived.getMaxValue().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMinValue()) {
                if (!Base.compareDeep(derived.getMinValue(), base.getMinValue(), false)) {
                    base.setMinValue(derived.getMinValue().copy());
                } else if (trimDifferential) {
                    derived.setMinValue(null);
                } else {
                    derived.getMinValue().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMustSupportElement()) {
                if (!base.hasMustSupportElement() || !Base.compareDeep(derived.getMustSupportElement(), base.getMustSupportElement(), false)) {
                    base.setMustSupportElement(derived.getMustSupportElement().copy());
                } else if (trimDifferential) {
                    derived.setMustSupportElement(null);
                } else {
                    derived.getMustSupportElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (isExtension) {
                if (!(!derived.hasIsModifierElement() || base.hasIsModifierElement() && Base.compareDeep(derived.getIsModifierElement(), base.getIsModifierElement(), false))) {
                    base.setIsModifierElement(derived.getIsModifierElement().copy());
                } else if (trimDifferential) {
                    derived.setIsModifierElement(null);
                } else if (derived.hasIsModifierElement()) {
                    derived.getIsModifierElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasBinding()) {
                if (!base.hasBinding() || !Base.compareDeep(derived.getBinding(), base.getBinding(), false)) {
                    if (base.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && derived.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "illegal attempt to change the binding on " + derived.getPath() + " from " + base.getBinding().getStrength().toCode() + " to " + derived.getBinding().getStrength().toCode(), ValidationMessage.IssueSeverity.ERROR));
                    } else if (base.hasBinding() && derived.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && base.getBinding().hasValueSetReference() && derived.getBinding().hasValueSetReference()) {
                        ValueSetExpander.ValueSetExpansionOutcome expBase = this.context.expandVS(this.context.fetchResource(ValueSet.class, base.getBinding().getValueSetReference().getReference()), true, false);
                        ValueSetExpander.ValueSetExpansionOutcome valueSetExpansionOutcome = this.context.expandVS(this.context.fetchResource(ValueSet.class, derived.getBinding().getValueSetReference().getReference()), true, false);
                        if (expBase.getValueset() == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + base.getPath(), "Binding " + base.getBinding().getValueSetReference().getReference() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                        } else if (valueSetExpansionOutcome.getValueset() == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSetReference().getReference() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                        } else if (!this.isSubset(expBase.getValueset(), valueSetExpansionOutcome.getValueset())) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSetReference().getReference() + " is not a subset of binding " + base.getBinding().getValueSetReference().getReference(), ValidationMessage.IssueSeverity.ERROR));
                        }
                    }
                    base.setBinding(derived.getBinding().copy());
                } else if (trimDifferential) {
                    derived.setBinding(null);
                } else {
                    derived.getBinding().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasIsSummaryElement()) {
                if (!Base.compareDeep(derived.getIsSummaryElement(), base.getIsSummaryElement(), false)) {
                    if (base.hasIsSummary()) {
                        throw new Error("Error in profile " + pn + " at " + derived.getPath() + ": Base isSummary = " + base.getIsSummaryElement().asStringValue() + ", derived isSummary = " + derived.getIsSummaryElement().asStringValue());
                    }
                    base.setIsSummaryElement(derived.getIsSummaryElement().copy());
                } else if (trimDifferential) {
                    derived.setIsSummaryElement(null);
                } else {
                    derived.getIsSummaryElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasType()) {
                if (!Base.compareDeep(derived.getType(), base.getType(), false)) {
                    if (base.hasType()) {
                        for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                            boolean ok = false;
                            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                            for (ElementDefinition.TypeRefComponent td : base.getType()) {
                                b.append(td.getCode());
                                if (!td.hasCode() || !td.getCode().equals(typeRefComponent.getCode()) && !td.getCode().equals("Extension") && !td.getCode().equals("Element") && !td.getCode().equals("*") && !td.getCode().equals("Resource") && (!td.getCode().equals("DomainResource") || !this.pkp.isResource(typeRefComponent.getCode()))) continue;
                                ok = true;
                            }
                            if (ok) continue;
                            throw new DefinitionException("StructureDefinition " + pn + " at " + derived.getPath() + ": illegal constrained type " + typeRefComponent.getCode() + " from " + b.toString());
                        }
                    }
                    base.getType().clear();
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        ElementDefinition.TypeRefComponent tt = typeRefComponent.copy();
                        base.getType().add(tt);
                    }
                } else if (trimDifferential) {
                    derived.getType().clear();
                } else {
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        typeRefComponent.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMapping()) {
                if (!Base.compareDeep(derived.getMapping(), base.getMapping(), false)) {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        boolean found = false;
                        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent2 : base.getMapping()) {
                            found = found || elementDefinitionMappingComponent2.getIdentity().equals(elementDefinitionMappingComponent.getIdentity()) && elementDefinitionMappingComponent2.getMap().equals(elementDefinitionMappingComponent.getMap());
                        }
                        if (found) continue;
                        base.getMapping().add(elementDefinitionMappingComponent);
                    }
                } else if (trimDifferential) {
                    derived.getMapping().clear();
                } else {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        elementDefinitionMappingComponent.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : base.getConstraint()) {
                elementDefinitionConstraintComponent.setUserData(IS_DERIVED, true);
                if (elementDefinitionConstraintComponent.hasSource()) continue;
                elementDefinitionConstraintComponent.setSource(base.getId());
            }
            if (derived.hasConstraint()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : derived.getConstraint()) {
                    ElementDefinition.ElementDefinitionConstraintComponent inv = elementDefinitionConstraintComponent.copy();
                    base.getConstraint().add(inv);
                }
            }
            if (dest.hasBinding() && !this.hasBindableType(dest)) {
                dest.setBinding(null);
            }
            for (Extension extension : base.getExtension()) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, extension.getUrl());
                if (sd == null || sd.getSnapshot() == null || sd.getSnapshot().getElementFirstRep().getMax().equals("1")) {
                    ToolingExtensions.removeExtension(dest, extension.getUrl());
                }
                dest.addExtension(extension);
            }
        }
    }

    private boolean hasBindableType(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (!Utilities.existsInList((String)tr.getCode(), (String[])new String[]{"Coding", "CodeableConcept", "Quantity", "url", "string", "code"})) continue;
            return true;
        }
        return false;
    }

    private boolean isLargerMax(String derived, String base) {
        if ("*".equals(base)) {
            return false;
        }
        if ("*".equals(derived)) {
            return true;
        }
        return Integer.parseInt(derived) > Integer.parseInt(base);
    }

    private boolean isSubset(ValueSet expBase, ValueSet expDerived) {
        return this.codesInExpansion(expDerived.getExpansion().getContains(), expBase.getExpansion());
    }

    private boolean codesInExpansion(List<ValueSet.ValueSetExpansionContainsComponent> contains, ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (!this.inExpansion(cc, expansion.getContains())) {
                return false;
            }
            if (this.codesInExpansion(cc.getContains(), expansion)) continue;
            return false;
        }
        return true;
    }

    private boolean inExpansion(ValueSet.ValueSetExpansionContainsComponent cc, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : contains) {
            if (cc.getSystem().equals(cc1.getSystem()) && cc.getCode().equals(cc1.getCode())) {
                return true;
            }
            if (!this.inExpansion(cc, cc1.getContains())) continue;
            return true;
        }
        return false;
    }

    public void closeDifferential(StructureDefinition base, StructureDefinition derived) throws FHIRException {
        for (ElementDefinition edb : base.getSnapshot().getElement()) {
            if (!this.isImmediateChild(edb) || edb.getPath().endsWith(".id")) continue;
            ElementDefinition edm = this.getMatchInDerived(edb, derived.getDifferential().getElement());
            if (edm == null) {
                ElementDefinition edd = derived.getDifferential().addElement();
                edd.setPath(edb.getPath());
                edd.setMax("0");
                continue;
            }
            if (!edb.hasSlicing()) continue;
            this.closeChildren(base, edb, derived, edm);
        }
        this.sortDifferential(base, derived, derived.getName(), new ArrayList<String>());
    }

    private void closeChildren(StructureDefinition base, ElementDefinition edb, StructureDefinition derived, ElementDefinition edm) {
        String path = edb.getPath() + ".";
        int baseStart = base.getSnapshot().getElement().indexOf(edb);
        int baseEnd = this.findEnd(base.getSnapshot().getElement(), edb, baseStart + 1);
        int diffStart = derived.getDifferential().getElement().indexOf(edm);
        int diffEnd = this.findEnd(derived.getDifferential().getElement(), edm, diffStart + 1);
        for (int cBase = baseStart; cBase < baseEnd; ++cBase) {
            ElementDefinition edBase = base.getSnapshot().getElement().get(cBase);
            if (!this.isImmediateChild(edBase, edb)) continue;
            ElementDefinition edMatch = this.getMatchInDerived(edBase, derived.getDifferential().getElement(), diffStart, diffEnd);
            if (edMatch == null) {
                ElementDefinition edd = derived.getDifferential().addElement();
                edd.setPath(edBase.getPath());
                edd.setMax("0");
                continue;
            }
            this.closeChildren(base, edBase, derived, edMatch);
        }
    }

    private int findEnd(List<ElementDefinition> list, ElementDefinition ed, int cursor) {
        String path = ed.getPath() + ".";
        while (cursor < list.size() && list.get(cursor).getPath().startsWith(path)) {
            ++cursor;
        }
        return cursor;
    }

    private ElementDefinition getMatchInDerived(ElementDefinition ed, List<ElementDefinition> list) {
        for (ElementDefinition t : list) {
            if (!t.getPath().equals(ed.getPath())) continue;
            return t;
        }
        return null;
    }

    private ElementDefinition getMatchInDerived(ElementDefinition ed, List<ElementDefinition> list, int start, int end) {
        for (int i = start; i < end; ++i) {
            ElementDefinition t = list.get(i);
            if (!t.getPath().equals(ed.getPath())) continue;
            return t;
        }
        return null;
    }

    private boolean isImmediateChild(ElementDefinition ed) {
        String p = ed.getPath();
        if (!p.contains(".")) {
            return false;
        }
        return !(p = p.substring(p.indexOf(".") + 1)).contains(".");
    }

    private boolean isImmediateChild(ElementDefinition candidate, ElementDefinition base) {
        String p = candidate.getPath();
        if (!p.contains(".")) {
            return false;
        }
        if (!p.startsWith(base.getPath() + ".")) {
            return false;
        }
        return !(p = p.substring(base.getPath().length() + 1)).contains(".");
    }

    public XhtmlNode generateExtensionTable(String defFile, StructureDefinition ed, String imageFolder, boolean inlineGraphics, boolean full, String corePath, String imagePath, Set<String> outputTracker) throws IOException, FHIRException {
        List<ElementDefinition> children;
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(new RenderingI18nContext(), imageFolder, inlineGraphics);
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, ed.getId(), false, HierarchicalTableGenerator.TableGenerationMode.XML);
        boolean deep = false;
        String m = "";
        boolean vdeep = false;
        if (ed.getSnapshot().getElementFirstRep().getIsModifier()) {
            m = "modifier_";
        }
        for (ElementDefinition eld : ed.getSnapshot().getElement()) {
            deep = deep || eld.getPath().contains("Extension.extension.");
            vdeep = vdeep || eld.getPath().contains("Extension.extension.extension.");
        }
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        model.getRows().add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName()), ed.getSnapshot().getElement().get(0).getIsModifier() ? "modifierExtension" : "extension", null, null));
        r.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, this.describeCardinality(ed.getSnapshot().getElement().get(0), null, new UnusedTracker()), null, null));
        ElementDefinition ved = null;
        if (full || vdeep) {
            List list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, "", "", "Extension", null, null));
            r.setIcon((String)(deep ? "icon_" + m + "extension_complex.png" : "icon_extension_simple.png"), deep ? "Complex Extension" : "Simple Extension");
            children = this.getChildren(ed.getSnapshot().getElement(), ed.getSnapshot().getElement().get(0));
            for (ElementDefinition child : children) {
                if (child.getPath().endsWith(".id")) continue;
                this.genElement((String)(defFile == null ? "" : defFile + "-definitions.html#extension."), gen, r.getSubRows(), child, ed.getSnapshot().getElement(), null, true, defFile, true, full, corePath, imagePath, true, false, false, false);
            }
        } else if (deep) {
            children = new ArrayList();
            for (ElementDefinition ted : ed.getSnapshot().getElement()) {
                if (!ted.getPath().equals("Extension.extension")) continue;
                children.add(ted);
            }
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, "", "", "Extension", null, null));
            r.setIcon("icon_" + m + "extension_complex.png", "Complex Extension");
            for (ElementDefinition c : children) {
                ved = this.getValueFor(ed, c);
                ElementDefinition ued = this.getUrlFor(ed, c);
                if (ved == null || ued == null) continue;
                HierarchicalTableGenerator.Row r1 = new HierarchicalTableGenerator.Row(gen);
                r.getSubRows().add(r1);
                List list5 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, (String)(defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName()), (String)((UriType)ued.getFixed()).getValue(), null, null));
                r1.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                List list6 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, this.describeCardinality(c, null, new UnusedTracker()), null, null));
                this.genTypes(gen, r1, ved, defFile, ed, corePath, imagePath);
                List list7 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, c.getDefinition(), null, null));
                r1.setIcon("icon_" + m + "extension_simple.png", "Simple Extension");
            }
        } else {
            for (ElementDefinition ted : ed.getSnapshot().getElement()) {
                if (!ted.getPath().startsWith("Extension.value")) continue;
                ved = ted;
            }
            this.genTypes(gen, r, ved, defFile, ed, corePath, imagePath);
            r.setIcon("icon_" + m + "extension_simple.png", "Simple Extension");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator8);
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, "", "", "URL = " + ed.getUrl(), null, null);
        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator9);
        HierarchicalTableGenerator.Cell cell = c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br"));
        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator10);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ed.getName() + ": " + ed.getDescription(), null));
        if (!full && !deep && !vdeep && ved != null && ved.hasBinding()) {
            HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator11);
            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, "br"));
            ProfileKnowledgeProvider.BindingResolution br = this.pkp.resolveBinding(ed, ved.getBinding(), ved.getPath());
            List list8 = c.getPieces();
            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent = ved.getBinding();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list8.add(this.checkForNoChange(elementDefinitionBindingComponent, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold")));
            List list9 = c.getPieces();
            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent2 = ved.getBinding();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list9.add(this.checkForNoChange(elementDefinitionBindingComponent2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.pkp.prependLinks() ? br.url : corePath + br.url), br.display, null)));
            if (ved.getBinding().hasStrength()) {
                List list10 = c.getPieces();
                ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent3 = ved.getBinding();
                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator14);
                list10.add(this.checkForNoChange(elementDefinitionBindingComponent3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, " (", null)));
                List list11 = c.getPieces();
                ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent4 = ved.getBinding();
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                list11.add(this.checkForNoChange(elementDefinitionBindingComponent4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, corePath + "terminologies.html#" + ved.getBinding().getStrength().toCode(), this.egt(ved.getBinding().getStrengthElement()), ved.getBinding().getStrength().getDefinition())));
                List list12 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator16);
                list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, ")", null));
            }
        }
        HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator17);
        HierarchicalTableGenerator.Cell cell2 = c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, "br"));
        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator18);
        cell2.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, ProfileUtilities.describeExtensionContext(ed), null));
        r.getCells().add(c);
        try {
            return gen.generate(model, corePath, 0, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    private ElementDefinition getUrlFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().equals(c.getPath() + ".url")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    private ElementDefinition getValueFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + ".value")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private HierarchicalTableGenerator.Cell genTypes(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row r, ElementDefinition e, String profileBaseFileName, StructureDefinition profile, String corePath, String imagePath) {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(c);
        List<ElementDefinition.TypeRefComponent> types = e.getType();
        if (!e.hasType()) {
            if (e.hasContentReference()) {
                return c;
            }
            ElementDefinition d = (ElementDefinition)e.getUserData(DERIVATION_POINTER);
            if (d != null && d.hasType()) {
                types = new ArrayList<ElementDefinition.TypeRefComponent>();
                for (ElementDefinition.TypeRefComponent tr : d.getType()) {
                    ElementDefinition.TypeRefComponent tt = tr.copy();
                    tt.setUserData(DERIVATION_EQUALS, true);
                    types.add(tt);
                }
            } else {
                return c;
            }
        }
        boolean first = true;
        org.hl7.fhir.dstu3.model.Element source = types.get(0);
        int aggMode = 0;
        boolean allReference = !types.isEmpty();
        HashSet<ElementDefinition.AggregationMode> aggs = new HashSet<ElementDefinition.AggregationMode>();
        for (ElementDefinition.TypeRefComponent typeRefComponent : types) {
            if (typeRefComponent.getCode() != null && typeRefComponent.getCode().equals("Reference") && typeRefComponent.hasProfile()) {
                for (Enumeration<ElementDefinition.AggregationMode> enumeration : typeRefComponent.getAggregation()) {
                    aggs.add((ElementDefinition.AggregationMode)((Object)enumeration.getValue()));
                }
                continue;
            }
            allReference = false;
        }
        if (allReference) {
            if (aggs.size() > 0) {
                boolean allSame = true;
                for (ElementDefinition.TypeRefComponent t : types) {
                    for (ElementDefinition.AggregationMode agg : aggs) {
                        boolean bl = false;
                        for (Enumeration<ElementDefinition.AggregationMode> en : t.getAggregation()) {
                            if (en.getValue() != agg) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        allSame = false;
                    }
                }
                int n = aggMode = allSame ? 2 : 1;
                if (aggMode != 2) {
                    allReference = false;
                }
            }
        } else {
            int n = aggMode = aggs.size() == 0 ? 0 : 1;
        }
        if (allReference) {
            List list = c.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + "references.html", "Reference", null));
            List list2 = c.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, "(", null));
        }
        ElementDefinition.TypeRefComponent tl = null;
        for (ElementDefinition.TypeRefComponent t : types) {
            if (first) {
                first = false;
            } else if (allReference) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " | ", null)));
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ", ", null)));
            }
            tl = t;
            if (t.getCode() != null && t.getCode().equals("Reference")) {
                Object disp;
                if (!allReference) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + "references.html", "Reference", null));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "(", null));
                }
                if (t.hasTargetProfile() && t.getTargetProfile().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    StructureDefinition structureDefinition = this.context.fetchResource(StructureDefinition.class, t.getTargetProfile());
                    if (structureDefinition != null) {
                        disp = structureDefinition.hasTitle() ? structureDefinition.getTitle() : structureDefinition.getName();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.checkPrepend(corePath, structureDefinition.getUserString("path")), (String)disp, null)));
                    } else {
                        String rn = t.getTargetProfile().substring(40);
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.pkp.getLinkFor(corePath, rn), rn, null)));
                    }
                } else if (t.hasTargetProfile() && Utilities.isAbsoluteUrl((String)t.getTargetProfile())) {
                    StructureDefinition structureDefinition = this.context.fetchResource(StructureDefinition.class, t.getTargetProfile());
                    if (structureDefinition != null) {
                        void var20_41;
                        disp = structureDefinition.hasTitle() ? structureDefinition.getTitle() : structureDefinition.getName();
                        String string = this.pkp.getLinkForProfile(null, structureDefinition.getUrl());
                        if (string.contains("|")) {
                            String string2 = string.substring(0, string.indexOf("|"));
                        }
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (String)var20_41, (String)disp, null)));
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, t.getTargetProfile(), null)));
                    }
                } else if (t.hasTargetProfile() && t.getTargetProfile().startsWith("#")) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + profileBaseFileName + "." + t.getTargetProfile().substring(1).toLowerCase() + ".html", t.getTargetProfile(), null)));
                } else if (t.hasTargetProfile()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + t.getTargetProfile(), t.getTargetProfile(), null)));
                }
                if (allReference) continue;
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ")", null));
                if (t.getAggregation().size() <= 0) continue;
                List list4 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, corePath + "valueset-resource-aggregation-mode.html", " {", null));
                boolean bl = true;
                for (Enumeration enumeration : t.getAggregation()) {
                    boolean bl2 = true;
                    if (true) {
                        bl2 = false;
                    } else {
                        List list5 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator5);
                        list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, corePath + "valueset-resource-aggregation-mode.html", ", ", null));
                    }
                    List list6 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, corePath + "valueset-resource-aggregation-mode.html", this.codeForAggregation((ElementDefinition.AggregationMode)((Object)enumeration.getValue())), null));
                }
                List list7 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, corePath + "valueset-resource-aggregation-mode.html", "}", null));
                continue;
            }
            if (t.hasProfile() && (!t.getCode().equals("Extension") || t.getProfile().contains(":"))) {
                String string = this.pkp.getLinkForProfile(profile, t.getProfile());
                if (string != null) {
                    String[] parts = string.split("\\|");
                    if (parts[0].startsWith("http:") || parts[0].startsWith("https:")) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, parts[0], parts[1], t.getCode())));
                        continue;
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (t.getProfile().startsWith(corePath) ? corePath : "") + parts[0], parts[1], t.getCode())));
                    continue;
                }
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (t.getProfile().startsWith(corePath) ? corePath : "") + string, t.getCode(), null)));
                continue;
            }
            if (this.pkp.hasLinkFor(t.getCode())) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.pkp.getLinkFor(corePath, t.getCode()), t.getCode(), null)));
                continue;
            }
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, t.getCode(), null)));
        }
        if (allReference) {
            List list = c.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ")", null));
            if (aggs.size() > 0) {
                List list8 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, corePath + "valueset-resource-aggregation-mode.html", " {", null));
                boolean bl = true;
                for (ElementDefinition.AggregationMode aggregationMode : aggs) {
                    boolean bl3 = true;
                    if (true) {
                        bl3 = false;
                    } else {
                        List list9 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, corePath + "valueset-resource-aggregation-mode.html", ", ", null));
                    }
                    List list10 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator10);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, corePath + "valueset-resource-aggregation-mode.html", this.codeForAggregation(aggregationMode), null));
                }
                List list11 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator11);
                list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, corePath + "valueset-resource-aggregation-mode.html", "}", null));
            }
        }
        return c;
    }

    private String codeForAggregation(ElementDefinition.AggregationMode a) {
        switch (a) {
            case BUNDLED: {
                return "b";
            }
            case CONTAINED: {
                return "c";
            }
            case REFERENCED: {
                return "r";
            }
        }
        return "?";
    }

    private String checkPrepend(String corePath, String path) {
        if (this.pkp.prependLinks() && !path.startsWith("http:") && !path.startsWith("https:")) {
            return corePath + path;
        }
        return path;
    }

    private ElementDefinition getElementByName(List<ElementDefinition> elements, String contentReference) {
        for (ElementDefinition ed : elements) {
            if (!ed.hasSliceName() || !("#" + ed.getSliceName()).equals(contentReference)) continue;
            return ed;
        }
        return null;
    }

    private ElementDefinition getElementById(List<ElementDefinition> elements, String contentReference) {
        for (ElementDefinition ed : elements) {
            if (!ed.hasId() || !("#" + ed.getId()).equals(contentReference)) continue;
            return ed;
        }
        return null;
    }

    public static String describeExtensionContext(StructureDefinition ext) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (StringType t : ext.getContext()) {
            b.append((String)t.getValue());
        }
        if (!ext.hasContextType()) {
            throw new Error("no context type on " + ext.getUrl());
        }
        switch (ext.getContextType()) {
            case DATATYPE: {
                return "Use on data type: " + b.toString();
            }
            case EXTENSION: {
                return "Use on extension: " + b.toString();
            }
            case RESOURCE: {
                return "Use on element: " + b.toString();
            }
        }
        return "??";
    }

    private String describeCardinality(ElementDefinition definition, ElementDefinition fallback, UnusedTracker tracker) {
        StringType max;
        IntegerType min = definition.hasMinElement() ? definition.getMinElement() : new IntegerType();
        StringType stringType = max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType();
        if (min.isEmpty() && fallback != null) {
            min = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        boolean bl = tracker.used = !max.isEmpty() && !((String)max.getValue()).equals("0");
        if (min.isEmpty() && max.isEmpty()) {
            return null;
        }
        return (!min.hasValue() ? "" : Integer.toString((Integer)min.getValue())) + ".." + (!max.hasValue() ? "" : (String)max.getValue());
    }

    private void genCardinality(HierarchicalTableGenerator gen, ElementDefinition definition, HierarchicalTableGenerator.Row row, boolean hasDef, UnusedTracker tracker, ElementDefinition fallback) {
        ElementDefinition base;
        StringType max;
        IntegerType min;
        IntegerType integerType = !hasDef ? new IntegerType() : (min = definition.hasMinElement() ? definition.getMinElement() : new IntegerType());
        StringType stringType = !hasDef ? new StringType() : (max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType());
        if (min.isEmpty() && definition.getUserData(DERIVATION_POINTER) != null && (base = (ElementDefinition)definition.getUserData(DERIVATION_POINTER)).hasMinElement()) {
            min = base.getMinElement().copy();
            min.setUserData(DERIVATION_EQUALS, true);
        }
        if (max.isEmpty() && definition.getUserData(DERIVATION_POINTER) != null && (base = (ElementDefinition)definition.getUserData(DERIVATION_POINTER)).hasMaxElement()) {
            max = base.getMaxElement().copy();
            max.setUserData(DERIVATION_EQUALS, true);
        }
        if (min.isEmpty() && fallback != null) {
            min = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        if (!max.isEmpty()) {
            tracker.used = !((String)max.getValue()).equals("0");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null);
        row.getCells().add(cell);
        if (!min.isEmpty() || !max.isEmpty()) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            cell.addPiece(this.checkForNoChange(min, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, !min.hasValue() ? "" : Integer.toString((Integer)min.getValue()), null)));
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            cell.addPiece(this.checkForNoChange(min, max, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "..", null)));
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            cell.addPiece(this.checkForNoChange(min, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, !max.hasValue() ? "" : (String)max.getValue(), null)));
        }
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(org.hl7.fhir.dstu3.model.Element source, HierarchicalTableGenerator.Piece piece) {
        if (source.hasUserData(DERIVATION_EQUALS)) {
            piece.addStyle("opacity: 0.4");
        }
        return piece;
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(org.hl7.fhir.dstu3.model.Element src1, org.hl7.fhir.dstu3.model.Element src2, HierarchicalTableGenerator.Piece piece) {
        if (src1.hasUserData(DERIVATION_EQUALS) && src2.hasUserData(DERIVATION_EQUALS)) {
            piece.addStyle("opacity: 0.5");
        }
        return piece;
    }

    public XhtmlNode generateTable(String defFile, StructureDefinition profile, boolean diff, String imageFolder, boolean inlineGraphics, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean logicalModel, boolean allInvariants, Set<String> outputTracker) throws IOException, FHIRException {
        assert (diff != snapshot);
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(new RenderingI18nContext(), imageFolder, inlineGraphics);
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, profile.getId() + (diff ? "d" : "s"), false, HierarchicalTableGenerator.TableGenerationMode.XML);
        List<ElementDefinition> list = diff ? profile.getDifferential().getElement() : profile.getSnapshot().getElement();
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        this.genElement(defFile == null ? null : defFile + "#", gen, model.getRows(), list.get(0), list, profiles, diff, profileBaseFileName, null, snapshot, corePath, imagePath, true, logicalModel, profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && this.usesMustSupport(list), allInvariants);
        try {
            return gen.generate(model, imagePath, 0, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    public XhtmlNode generateGrid(String defFile, StructureDefinition profile, String imageFolder, boolean inlineGraphics, String profileBaseFileName, String corePath, String imagePath, Set<String> outputTracker) throws IOException, FHIRException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(new RenderingI18nContext(), imageFolder, inlineGraphics);
        HierarchicalTableGenerator.TableModel model = gen.initGridTable(corePath, profile.getId());
        List<ElementDefinition> list = profile.getSnapshot().getElement();
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        this.genGridElement(defFile == null ? null : defFile + "#", gen, model.getRows(), list.get(0), list, profiles, true, profileBaseFileName, null, corePath, imagePath, true, profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && this.usesMustSupport(list));
        try {
            return gen.generate(model, imagePath, 1, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean usesMustSupport(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.hasMustSupport() || !ed.getMustSupport()) continue;
            return true;
        }
        return false;
    }

    private void genElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean isConstraintMode, boolean allInvariants) throws IOException {
        block49: {
            HierarchicalTableGenerator.Row row;
            boolean isExtension;
            List<ElementDefinition> children;
            StructureDefinition profile;
            block50: {
                profile = profiles == null ? null : profiles.get(profiles.size() - 1);
                String s = this.tail(element.getPath());
                children = this.getChildren(all, element);
                boolean bl = isExtension = s.equals("extension") || s.equals("modifierExtension");
                if (!snapshot && isExtension && extensions != null && extensions != isExtension) {
                    return;
                }
                if (this.onlyInformationIsMapping(all, element)) break block49;
                row = new HierarchicalTableGenerator.Row(gen);
                row.setAnchor(element.getPath());
                row.setColor(this.getRowColor(element, isConstraintMode));
                boolean hasDef = element != null;
                boolean ext = false;
                if (s.equals("extension")) {
                    if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex(element.getType().get(0).getProfile())) {
                        row.setIcon("icon_extension_complex.png", "Complex Extension");
                    } else {
                        row.setIcon("icon_extension_simple.png", "Simple Extension");
                    }
                    ext = true;
                } else if (s.equals("modifierExtension")) {
                    if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex(element.getType().get(0).getProfile())) {
                        row.setIcon("icon_modifier_extension_complex.png", "Complex Extension");
                    } else {
                        row.setIcon("icon_modifier_extension_simple.png", "Simple Extension");
                    }
                } else if (!hasDef || element.getType().size() == 0) {
                    row.setIcon("icon_element.gif", "Element");
                } else if (hasDef && element.getType().size() > 1) {
                    if (this.allTypesAre(element.getType(), "Reference")) {
                        row.setIcon("icon_reference.png", "Reference to another Resource");
                    } else {
                        row.setIcon("icon_choice.gif", "Choice of Types");
                    }
                } else if (hasDef && element.getType().get(0).getCode() != null && element.getType().get(0).getCode().startsWith("@")) {
                    row.setIcon("icon_reuse.png", "Reference to another Element");
                } else if (hasDef && this.isPrimitive(element.getType().get(0).getCode())) {
                    row.setIcon("icon_primitive.png", "Primitive Data Type");
                } else if (hasDef && this.isReference(element.getType().get(0).getCode())) {
                    row.setIcon("icon_reference.png", "Reference to another Resource");
                } else if (hasDef && this.isDataType(element.getType().get(0).getCode())) {
                    row.setIcon("icon_datatype.gif", "Data Type");
                } else {
                    row.setIcon("icon_resource.png", "Resource");
                }
                String ref = defPath == null ? null : defPath + element.getId();
                UnusedTracker used = new UnusedTracker();
                used.used = true;
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, ref, s, (String)(element.hasSliceName() ? this.translate("sd.table", "Slice") + " " + element.getSliceName() : "") + (hasDef && element.hasSliceName() ? ": " : "") + (!hasDef ? null : this.gt(element.getDefinitionElement())), null);
                row.getCells().add(left);
                HierarchicalTableGenerator.Cell gc = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(gc);
                if (element != null && element.getIsModifier()) {
                    this.checkForNoChange(element.getIsModifierElement(), gc.addStyledText(this.translate("sd.table", "This element is a modifier element"), "?!", null, null, null, false));
                }
                if (element != null && element.getMustSupport()) {
                    this.checkForNoChange(element.getMustSupportElement(), gc.addStyledText(this.translate("sd.table", "This element must be supported"), "S", "white", "red", null, false));
                }
                if (element != null && element.getIsSummary()) {
                    this.checkForNoChange(element.getIsSummaryElement(), gc.addStyledText(this.translate("sd.table", "This element is included in summaries"), "\u03a3", null, null, null, false));
                }
                if (!(element == null || element.getConstraint().isEmpty() && element.getCondition().isEmpty())) {
                    gc.addStyledText(this.translate("sd.table", "This element has or is affected by some invariants"), "I", null, null, null, false);
                }
                ExtensionContext extDefn = null;
                if (ext) {
                    if (element != null && element.getType().size() == 1 && element.getType().get(0).hasProfile()) {
                        extDefn = this.locateExtension(StructureDefinition.class, element.getType().get(0).getProfile());
                        if (extDefn == null) {
                            this.genCardinality(gen, element, row, hasDef, used, null);
                            List list = row.getCells();
                            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator2);
                            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "?? " + element.getType().get(0).getProfile(), null, null));
                            this.generateDescription(gen, row, element, null, used.used, profile.getUrl(), element.getType().get(0).getProfile(), profile, corePath, imagePath, root, logicalModel, allInvariants);
                        } else {
                            String name = this.urltail(element.getType().get(0).getProfile());
                            ((HierarchicalTableGenerator.Piece)left.getPieces().get(0)).setText(name);
                            ((HierarchicalTableGenerator.Piece)left.getPieces().get(0)).setHint(this.translate("sd.table", "Extension URL") + " = " + extDefn.getUrl());
                            this.genCardinality(gen, element, row, hasDef, used, extDefn.getElement());
                            ElementDefinition valueDefn = extDefn.getExtensionValueDefinition();
                            if (valueDefn != null && !"0".equals(valueDefn.getMax())) {
                                this.genTypes(gen, row, valueDefn, profileBaseFileName, profile, corePath, imagePath);
                            } else {
                                List list = row.getCells();
                                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator3);
                                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "(" + this.translate("sd.table", "Complex") + ")", null, null));
                            }
                            this.generateDescription(gen, row, element, extDefn.getElement(), used.used, null, extDefn.getUrl(), profile, corePath, imagePath, root, logicalModel, allInvariants, valueDefn);
                        }
                    } else {
                        this.genCardinality(gen, element, row, hasDef, used, null);
                        if ("0".equals(element.getMax())) {
                            row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                        } else {
                            this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath);
                        }
                        this.generateDescription(gen, row, element, null, used.used, null, null, profile, corePath, imagePath, root, logicalModel, allInvariants);
                    }
                } else {
                    this.genCardinality(gen, element, row, hasDef, used, null);
                    if (hasDef && !"0".equals(element.getMax())) {
                        this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath);
                    } else {
                        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    }
                    this.generateDescription(gen, row, element, null, used.used, null, null, profile, corePath, imagePath, root, logicalModel, allInvariants);
                }
                if (element.hasSlicing()) {
                    if (this.standardExtensionSlicing(element)) {
                        used.used = element.hasType() && element.getType().get(0).hasProfile();
                        showMissing = false;
                    } else {
                        row.setIcon("icon_slice.png", "Slice Definition");
                        ((HierarchicalTableGenerator.Cell)row.getCells().get(2)).getPieces().clear();
                        for (HierarchicalTableGenerator.Cell cell : row.getCells()) {
                            for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                                p.addStyle("font-style: italic");
                            }
                        }
                    }
                }
                if (used.used || showMissing) {
                    rows.add(row);
                }
                if (used.used || element.hasSlicing()) break block50;
                for (HierarchicalTableGenerator.Cell cell : row.getCells()) {
                    for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                        p.setStyle("text-decoration:line-through");
                        p.setReference(null);
                    }
                }
                break block49;
            }
            for (ElementDefinition child : children) {
                if (!logicalModel && child.getPath().endsWith(".id") && (!child.getPath().endsWith(".id") || profile == null || profile.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT)) continue;
                this.genElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, snapshot, corePath, imagePath, false, logicalModel, isConstraintMode, allInvariants);
            }
            if (snapshot || extensions != null && extensions.booleanValue()) break block49;
            for (ElementDefinition child : children) {
                if (!child.getPath().endsWith(".extension") && !child.getPath().endsWith(".modifierExtension")) continue;
                this.genElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, true, false, corePath, imagePath, false, logicalModel, isConstraintMode, allInvariants);
            }
        }
    }

    private void genGridElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, String corePath, String imagePath, boolean root, boolean isConstraintMode) throws IOException {
        boolean isExtension;
        StructureDefinition profile = profiles == null ? null : profiles.get(profiles.size() - 1);
        String s = this.tail(element.getPath());
        List<ElementDefinition> children = this.getChildren(all, element);
        boolean bl = isExtension = s.equals("extension") || s.equals("modifierExtension");
        if (!this.onlyInformationIsMapping(all, element)) {
            HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
            row.setAnchor(element.getPath());
            row.setColor(this.getRowColor(element, isConstraintMode));
            boolean hasDef = element != null;
            String ref = defPath == null ? null : defPath + element.getId();
            UnusedTracker used = new UnusedTracker();
            used.used = true;
            HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(gen);
            if (element.getType().size() == 1 && element.getType().get(0).isPrimitive()) {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, "\u00a0\u00a0" + s, !hasDef ? null : this.gt(element.getDefinitionElement())).addStyle("font-weight:bold"));
            } else {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, "\u00a0\u00a0" + s, !hasDef ? null : this.gt(element.getDefinitionElement())));
            }
            if (element.hasSliceName()) {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                String indent = StringUtils.repeat((char)'\u00a0', (int)(1 + 2 * element.getPath().split("\\.").length));
                List list2 = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, indent + "(" + element.getSliceName() + ")", null));
            }
            row.getCells().add(left);
            Object extDefn = null;
            this.genCardinality(gen, element, row, hasDef, used, null);
            if (hasDef && !"0".equals(element.getMax())) {
                this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath);
            } else {
                row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
            }
            this.generateGridDescription(gen, row, element, null, used.used, null, null, profile, corePath, imagePath, root, null);
            rows.add(row);
            for (ElementDefinition child : children) {
                if (!child.getMustSupport()) continue;
                this.genGridElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, corePath, imagePath, false, isConstraintMode);
            }
        }
    }

    private ExtensionContext locateExtension(Class<StructureDefinition> class1, String value) {
        if (value.contains("#")) {
            StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return null;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getSliceName())) continue;
                ed = ted;
                return new ExtensionContext(ext, ed);
            }
            return null;
        }
        StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value);
        if (ext == null) {
            return null;
        }
        return new ExtensionContext(ext, ext.getSnapshot().getElement().get(0));
    }

    private boolean extensionIsComplex(String value) {
        if (value.contains("#")) {
            int j;
            StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return false;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getSliceName())) continue;
                ed = ted;
                break;
            }
            if (ed == null) {
                return false;
            }
            int i = ext.getSnapshot().getElement().indexOf(ed);
            for (j = i + 1; j < ext.getSnapshot().getElement().size() && !ext.getSnapshot().getElement().get(j).getPath().equals(ed.getPath()); ++j) {
            }
            return j - i > 5;
        }
        StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value);
        return ext != null && ext.getSnapshot().getElement().size() > 5;
    }

    private String getRowColor(ElementDefinition element, boolean isConstraintMode) {
        switch (element.getUserInt(UD_ERROR_STATUS)) {
            case 1: {
                return ROW_COLOR_HINT;
            }
            case 2: {
                return ROW_COLOR_WARNING;
            }
            case 3: {
                return ROW_COLOR_ERROR;
            }
            case 4: {
                return ROW_COLOR_FATAL;
            }
        }
        if (isConstraintMode && !element.getMustSupport() && !element.getIsModifier() && element.getPath().contains(".")) {
            return null;
        }
        return null;
    }

    private String urltail(String path) {
        if (path.contains("#")) {
            return path.substring(path.lastIndexOf(35) + 1);
        }
        if (path.contains("/")) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    private boolean standardExtensionSlicing(ElementDefinition element) {
        String t = this.tail(element.getPath());
        return (t.equals("extension") || t.equals("modifierExtension")) && element.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED && element.getSlicing().getDiscriminator().size() == 1 && element.getSlicing().getDiscriminator().get(0).getPath().equals("url") && element.getSlicing().getDiscriminator().get(0).getType().equals((Object)ElementDefinition.DiscriminatorType.VALUE);
    }

    private HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants) throws IOException {
        return this.generateDescription(gen, row, definition, fallback, used, baseURL, url, profile, corePath, imagePath, root, logicalModel, allInvariants, null);
    }

    private HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, ElementDefinition valueDefn) throws IOException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (logicalModel && ToolingExtensions.hasExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                if (root) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                } else if (!root && ToolingExtensions.hasExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace") && !ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").equals(ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"))) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                }
            }
            if (definition.hasContentReference()) {
                ElementDefinition ed = this.getElementByName(profile.getSnapshot().getElement(), definition.getContentReference());
                if (ed == null) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Unknown reference to %s", new Object[]{definition.getContentReference()}), null));
                } else {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "#" + ed.getPath(), this.translate("sd.table", "See %s", new Object[]{ed.getPath()}), null));
                }
            }
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List list = c.getPieces();
                Type type = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                if (definition != null && definition.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    StringType stringType = definition.getShortElement();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(stringType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.gt(definition.getShortElement()), null)));
                } else if (fallback != null && fallback.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    StringType stringType = fallback.getShortElement();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(stringType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.gt(fallback.getShortElement()), null)));
                }
                if (url != null) {
                    String p;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    String ref = null;
                    if (ed != null && (p = ed.getUserString("path")) != null) {
                        ref = p.startsWith("http:") || this.igmode ? p : Utilities.pathURL((String[])new String[]{corePath, p});
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "URL") + ": ", null).addStyle("font-weight:bold"));
                    List list4 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, ref, fullUrl, null));
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Slice") + ": ", null).addStyle("font-weight:bold"));
                    List list5 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (definition != null) {
                    ElementDefinition.ElementDefinitionBindingComponent binding = null;
                    if (valueDefn != null && valueDefn.hasBinding() && !valueDefn.getBinding().isEmpty()) {
                        binding = valueDefn.getBinding();
                    } else if (definition.hasBinding()) {
                        binding = definition.getBinding();
                    }
                    if (binding != null && !binding.isEmpty()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        ProfileKnowledgeProvider.BindingResolution br = this.pkp.resolveBinding(profile, binding, definition.getPath());
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold")));
                        List list6 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator6);
                        list6.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.pkp.prependLinks() ? br.url : corePath + br.url), br.display, null)));
                        if (binding.hasStrength()) {
                            List list7 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator7);
                            list7.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, " (", null)));
                            List list8 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator8);
                            list8.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, corePath + "terminologies.html#" + binding.getStrength().toCode(), this.egt(binding.getStrengthElement()), binding.getStrength().getDefinition())));
                            List list9 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator9);
                            list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, ")", null));
                        }
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (inv.hasSource() && !allInvariants) continue;
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        List list10 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list10.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, this.gt(inv.getHumanElement()), null)));
                    }
                    if (definition.hasBase() && definition.getBase().getMax().equals("*") || definition.hasMax() && definition.getMax().equals("*")) {
                        if (c.getPieces().size() > 0) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        if (definition.hasOrderMeaning()) {
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This repeating element order: " + definition.getOrderMeaning(), null));
                        }
                    }
                    if (definition.hasFixed()) {
                        HierarchicalTableGenerator.Piece p;
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        Type type = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Fixed Value") + ": ", null).addStyle("font-weight:bold")));
                        List list11 = c.getPieces();
                        Type type2 = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator11);
                        list11.add(this.checkForNoChange(type2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.buildJson(definition.getFixed()), null).addStyle("color: darkgreen")));
                        if (this.isCoded(definition.getFixed()) && !this.hasDescription(definition.getFixed()) && (p = this.describeCoded(gen, definition.getFixed())) != null) {
                            c.getPieces().add(p);
                        }
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        Type type = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Required Pattern") + ": ", null).addStyle("font-weight:bold")));
                        List list12 = c.getPieces();
                        Type type3 = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator12);
                        list12.add(this.checkForNoChange(type3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasExample()) {
                        for (ElementDefinition.ElementDefinitionExampleComponent ex : definition.getExample()) {
                            if (!c.getPieces().isEmpty()) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                            }
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Example") + (String)("".equals("General") ? "" : " " + ex.getLabel() + "'") + ": ", null).addStyle("font-weight:bold")));
                            List list13 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator13);
                            list13.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, this.buildJson(ex.getValue()), null).addStyle("color: darkgreen")));
                        }
                    }
                    if (definition.hasMaxLength() && definition.getMaxLength() != 0) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        IntegerType integerType = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(integerType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Max Length: ", null).addStyle("font-weight:bold")));
                        List list14 = c.getPieces();
                        IntegerType integerType2 = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator14);
                        list14.add(this.checkForNoChange(integerType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, Integer.toString(definition.getMaxLength()), null).addStyle("color: darkgreen")));
                    }
                    if (profile != null) {
                        for (StructureDefinition.StructureDefinitionMappingComponent md : profile.getMapping()) {
                            if (!md.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name")) continue;
                            ElementDefinition.ElementDefinitionMappingComponent map = null;
                            for (ElementDefinition.ElementDefinitionMappingComponent m : definition.getMapping()) {
                                if (!m.getIdentity().equals(md.getIdentity())) continue;
                                map = m;
                            }
                            if (map == null) continue;
                            for (int i = 0; i < definition.getMapping().size(); ++i) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                                List list = c.getPieces();
                                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator15);
                                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, ToolingExtensions.readStringExtension(md, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name") + ": " + map.getMap(), null));
                            }
                        }
                    }
                }
            }
        }
        return c;
    }

    private HierarchicalTableGenerator.Piece describeCoded(HierarchicalTableGenerator gen, Type fixed) {
        if (fixed instanceof Coding) {
            Coding c = (Coding)fixed;
            IWorkerContext.ValidationResult vr = this.context.validateCode(c.getSystem(), c.getCode(), c.getDisplay());
            if (vr.getDisplay() != null) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                return new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " (" + vr.getDisplay() + ")", null).addStyle("color: darkgreen");
            }
        } else if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            for (Coding c : cc.getCoding()) {
                IWorkerContext.ValidationResult vr = this.context.validateCode(c.getSystem(), c.getCode(), c.getDisplay());
                if (vr.getDisplay() == null) continue;
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                return new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " (" + vr.getDisplay() + ")", null).addStyle("color: darkgreen");
            }
        }
        return null;
    }

    private boolean hasDescription(Type fixed) {
        if (fixed instanceof Coding) {
            return ((Coding)fixed).hasDisplay();
        }
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            if (cc.hasText()) {
                return true;
            }
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplay()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCoded(Type fixed) {
        return fixed instanceof Coding || fixed instanceof CodeableConcept || fixed instanceof CodeType || fixed instanceof Quantity;
    }

    private HierarchicalTableGenerator.Cell generateGridDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, ElementDefinition valueDefn) throws IOException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (definition.hasContentReference()) {
                ElementDefinition ed = this.getElementByName(profile.getSnapshot().getElement(), definition.getContentReference());
                if (ed == null) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Unknown reference to " + definition.getContentReference(), null));
                } else {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "#" + ed.getPath(), "See " + ed.getPath(), null));
                }
            }
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List list = c.getPieces();
                Type type = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                if (url != null) {
                    String p;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    String ref = null;
                    if (ed != null && (p = ed.getUserString("path")) != null) {
                        ref = p.startsWith("http:") || this.igmode ? p : Utilities.pathURL((String[])new String[]{corePath, p});
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "URL: ", null).addStyle("font-weight:bold"));
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, ref, fullUrl, null));
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Slice: ", null).addStyle("font-weight:bold"));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (definition != null) {
                    ElementDefinition.ElementDefinitionBindingComponent binding = null;
                    if (valueDefn != null && valueDefn.hasBinding() && !valueDefn.getBinding().isEmpty()) {
                        binding = valueDefn.getBinding();
                    } else if (definition.hasBinding()) {
                        binding = definition.getBinding();
                    }
                    if (binding != null && !binding.isEmpty()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        ProfileKnowledgeProvider.BindingResolution br = this.pkp.resolveBinding(profile, binding, definition.getPath());
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Binding: ", null).addStyle("font-weight:bold")));
                        List list4 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator4);
                        list4.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.pkp.prependLinks() ? br.url : corePath + br.url), br.display, null)));
                        if (binding.hasStrength()) {
                            List list5 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator5);
                            list5.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, " (", null)));
                            List list6 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator6);
                            list6.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, corePath + "terminologies.html#" + binding.getStrength().toCode(), binding.getStrength().toCode(), binding.getStrength().getDefinition())));
                            List list7 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator7);
                            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, ")", null));
                        }
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        List list8 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator8);
                        list8.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, inv.getHuman(), null)));
                    }
                    if (definition.hasFixed()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        Type type = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Fixed Value: ", null).addStyle("font-weight:bold")));
                        List list9 = c.getPieces();
                        Type type2 = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        list9.add(this.checkForNoChange(type2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, this.buildJson(definition.getFixed()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        Type type = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Required Pattern: ", null).addStyle("font-weight:bold")));
                        List list10 = c.getPieces();
                        Type type3 = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list10.add(this.checkForNoChange(type3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasExample()) {
                        for (ElementDefinition.ElementDefinitionExampleComponent ex : definition.getExample()) {
                            if (!c.getPieces().isEmpty()) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                            }
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Example'" + (String)("".equals("General") ? "" : " " + ex.getLabel() + "'") + ": ", null).addStyle("font-weight:bold")));
                            List list11 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator11);
                            list11.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.buildJson(ex.getValue()), null).addStyle("color: darkgreen")));
                        }
                    }
                    if (definition.hasMaxLength() && definition.getMaxLength() != 0) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        IntegerType integerType = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(integerType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Max Length: ", null).addStyle("font-weight:bold")));
                        List list12 = c.getPieces();
                        IntegerType integerType2 = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator12);
                        list12.add(this.checkForNoChange(integerType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, Integer.toString(definition.getMaxLength()), null).addStyle("color: darkgreen")));
                    }
                    if (profile != null) {
                        for (StructureDefinition.StructureDefinitionMappingComponent md : profile.getMapping()) {
                            if (!md.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name")) continue;
                            ElementDefinition.ElementDefinitionMappingComponent map = null;
                            for (ElementDefinition.ElementDefinitionMappingComponent m : definition.getMapping()) {
                                if (!m.getIdentity().equals(md.getIdentity())) continue;
                                map = m;
                            }
                            if (map == null) continue;
                            for (int i = 0; i < definition.getMapping().size(); ++i) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                                List list = c.getPieces();
                                HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator13);
                                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, ToolingExtensions.readStringExtension(md, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name") + ": " + map.getMap(), null));
                            }
                        }
                    }
                    if (definition.getComment() != null) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Comments: ", null).addStyle("font-weight:bold"));
                        HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator14);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, "br"));
                        c.addMarkdown(definition.getComment());
                    }
                }
            }
        }
        return c;
    }

    private String buildJson(Type value) throws IOException {
        if (value instanceof PrimitiveType) {
            return ((PrimitiveType)value).asStringValue();
        }
        IParser json = this.context.newJsonParser();
        return json.composeString(value, null);
    }

    public String describeSlice(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        return this.translate("sd.table", "%s, %s by %s", new Object[]{slicing.getOrdered() ? this.translate("sd.table", "Ordered") : this.translate("sd.table", "Unordered"), this.describe(slicing.getRules()), this.commas(slicing.getDiscriminator())});
    }

    private String commas(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> list) {
        CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent id : list) {
            c.append(id.getType().toCode() + ":" + id.getPath());
        }
        return c.toString();
    }

    private String describe(ElementDefinition.SlicingRules rules) {
        if (rules == null) {
            return this.translate("sd.table", "Unspecified");
        }
        switch (rules) {
            case CLOSED: {
                return this.translate("sd.table", "Closed");
            }
            case OPEN: {
                return this.translate("sd.table", "Open");
            }
            case OPENATEND: {
                return this.translate("sd.table", "Open At End");
            }
        }
        return "??";
    }

    private boolean onlyInformationIsMapping(List<ElementDefinition> list, ElementDefinition e) {
        return !e.hasSliceName() && !e.hasSlicing() && this.onlyInformationIsMapping(e) && this.getChildren(list, e).isEmpty();
    }

    private boolean onlyInformationIsMapping(ElementDefinition d) {
        return !d.hasShort() && !d.hasDefinition() && !d.hasRequirements() && !d.getAlias().isEmpty() && !d.hasMinElement() && !d.hasMax() && !d.getType().isEmpty() && !d.hasContentReference() && !d.hasExample() && !d.hasFixed() && !d.hasMaxLengthElement() && !d.getCondition().isEmpty() && !d.getConstraint().isEmpty() && !d.hasMustSupportElement() && !d.hasBinding();
    }

    private boolean allTypesAre(List<ElementDefinition.TypeRefComponent> types, String name) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.getCode().equals(name)) continue;
            return false;
        }
        return true;
    }

    private List<ElementDefinition> getChildren(List<ElementDefinition> all, ElementDefinition element) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        for (int i = all.indexOf(element) + 1; i < all.size() && all.get(i).getPath().length() > element.getPath().length(); ++i) {
            if (!all.get(i).getPath().substring(0, element.getPath().length() + 1).equals(element.getPath() + ".") || all.get(i).getPath().substring(element.getPath().length() + 1).contains(".")) continue;
            result.add(all.get(i));
        }
        return result;
    }

    private String tail(String path) {
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    private boolean isDataType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE;
    }

    private boolean isReference(String value) {
        return "Reference".equals(value);
    }

    public boolean isPrimitive(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public StructureDefinition getProfile(StructureDefinition source, String url) {
        StructureDefinition profile = null;
        String code = null;
        if (url.startsWith("#")) {
            profile = source;
            code = url.substring(1);
        } else if (this.context != null) {
            String[] parts = url.split("\\#");
            profile = this.context.fetchResource(StructureDefinition.class, parts[0]);
            String string = code = parts.length == 1 ? null : parts[1];
        }
        if (profile == null) {
            return null;
        }
        if (code == null) {
            return profile;
        }
        for (Resource r : profile.getContained()) {
            if (!(r instanceof StructureDefinition) || !r.getId().equals(code)) continue;
            return (StructureDefinition)r;
        }
        return null;
    }

    public void sortDifferential(StructureDefinition base, StructureDefinition diff, String name, List<String> errors) throws FHIRException {
        List<ElementDefinition> diffList = diff.getDifferential().getElement();
        if (diffList.isEmpty()) {
            return;
        }
        ElementDefinitionHolder edh = new ElementDefinitionHolder(diffList.get(0));
        boolean hasSlicing = false;
        ArrayList<String> paths = new ArrayList<String>();
        for (ElementDefinition elt : diffList) {
            if (elt.hasSlicing() || paths.contains(elt.getPath())) {
                hasSlicing = true;
                break;
            }
            paths.add(elt.getPath());
        }
        if (!hasSlicing) {
            Collections.sort(diffList, new ElementNameCompare());
        }
        int i = 1;
        this.processElementsIntoTree(edh, i, diff.getDifferential().getElement());
        ElementDefinitionComparer cmp = new ElementDefinitionComparer(true, base.getSnapshot().getElement(), "", 0, name);
        this.sortElements(edh, cmp, errors);
        diffList.clear();
        this.writeElements(edh, diffList);
    }

    private int processElementsIntoTree(ElementDefinitionHolder edh, int i, List<ElementDefinition> list) {
        String path = edh.getSelf().getPath();
        String prefix = path + ".";
        while (i < list.size() && list.get(i).getPath().startsWith(prefix)) {
            ElementDefinitionHolder child = new ElementDefinitionHolder(list.get(i));
            edh.getChildren().add(child);
            i = this.processElementsIntoTree(child, i + 1, list);
        }
        return i;
    }

    private void sortElements(ElementDefinitionHolder edh, ElementDefinitionComparer cmp, List<String> errors) throws FHIRException {
        if (edh.getChildren().size() == 1) {
            edh.getChildren().get((int)0).baseIndex = cmp.find(edh.getChildren().get(0).getSelf().getPath());
        } else {
            Collections.sort(edh.getChildren(), cmp);
        }
        cmp.checkForErrors(errors);
        for (ElementDefinitionHolder child : edh.getChildren()) {
            StructureDefinition profile;
            ElementDefinitionComparer ccmp;
            if (child.getChildren().size() <= 0) continue;
            ElementDefinition ed = cmp.snapshot.get(child.getBaseIndex());
            if (ed.getType().isEmpty() || this.isAbstract(ed.getType().get(0).getCode()) || ed.getType().get(0).getCode().equals(ed.getPath())) {
                ccmp = new ElementDefinitionComparer(true, cmp.snapshot, cmp.base, cmp.prefixLength, cmp.name);
            } else if (ed.getType().get(0).getCode().equals("Extension") && child.getSelf().getType().size() == 1 && child.getSelf().getType().get(0).hasProfile()) {
                profile = this.context.fetchResource(StructureDefinition.class, child.getSelf().getType().get(0).getProfile());
                ccmp = profile == null ? null : new ElementDefinitionComparer(true, profile.getSnapshot().getElement(), ed.getType().get(0).getCode(), child.getSelf().getPath().length(), cmp.name);
            } else if (ed.getType().size() == 1 && !ed.getType().get(0).getCode().equals("*")) {
                profile = this.context.fetchTypeDefinition(ed.getType().get(0).getCode());
                if (profile == null) {
                    throw new FHIRException("Unable to resolve profile http://hl7.org/fhir/StructureDefinition/" + ed.getType().get(0).getCode() + " in element " + ed.getPath());
                }
                ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), ed.getType().get(0).getCode(), child.getSelf().getPath().length(), cmp.name);
            } else if (child.getSelf().getType().size() == 1) {
                profile = this.context.fetchTypeDefinition(child.getSelf().getType().get(0).getCode());
                if (profile == null) {
                    throw new FHIRException("Unable to resolve profile http://hl7.org/fhir/StructureDefinition/" + ed.getType().get(0).getCode() + " in element " + ed.getPath());
                }
                ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), child.getSelf().getType().get(0).getCode(), child.getSelf().getPath().length(), cmp.name);
            } else if (ed.getPath().endsWith("[x]") && !child.getSelf().getPath().endsWith("[x]")) {
                String edLastNode = ed.getPath().replaceAll("(.*\\.)*(.*)", "$2");
                String childLastNode = child.getSelf().getPath().replaceAll("(.*\\.)*(.*)", "$2");
                String p = childLastNode.substring(edLastNode.length() - 3);
                StructureDefinition sd = this.context.fetchTypeDefinition(p);
                if (sd == null) {
                    throw new Error("Unable to find profile " + p);
                }
                ccmp = new ElementDefinitionComparer(false, sd.getSnapshot().getElement(), p, child.getSelf().getPath().length(), cmp.name);
            } else {
                throw new Error("Not handled yet (sortElements: " + ed.getPath() + ":" + ProfileUtilities.typeCode(ed.getType()) + ")");
            }
            if (ccmp == null) continue;
            this.sortElements(child, ccmp, errors);
        }
    }

    private boolean isAbstract(String code) {
        return code.equals("Element") || code.equals("BackboneElement") || code.equals("Resource") || code.equals("DomainResource");
    }

    private void writeElements(ElementDefinitionHolder edh, List<ElementDefinition> list) {
        list.add(edh.getSelf());
        for (ElementDefinitionHolder child : edh.getChildren()) {
            this.writeElements(child, list);
        }
    }

    public void generateSchematrons(OutputStream dest, StructureDefinition structure) throws IOException, DefinitionException {
        if (structure.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            throw new DefinitionException("not the right kind of structure to generate schematrons for");
        }
        if (!structure.hasSnapshot()) {
            throw new DefinitionException("needs a snapshot");
        }
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, structure.getBaseDefinition());
        SchematronWriter sch = new SchematronWriter(dest, SchematronWriter.SchematronType.PROFILE, base.getName());
        ElementDefinition ed = structure.getSnapshot().getElement().get(0);
        this.generateForChildren(sch, "f:" + ed.getPath(), ed, structure, base);
        sch.dump();
    }

    public void generateCsvs(OutputStream dest, StructureDefinition structure, boolean asXml) throws IOException, DefinitionException, Exception {
        if (!structure.hasSnapshot()) {
            throw new DefinitionException("needs a snapshot");
        }
        CSVWriter csv = new CSVWriter(dest, structure, asXml);
        for (ElementDefinition child : structure.getSnapshot().getElement()) {
            csv.processElement(child);
        }
        csv.dump();
    }

    private Slicer generateSlicer(ElementDefinition child, ElementDefinition.ElementDefinitionSlicingComponent slicing, StructureDefinition structure) {
        if (child.getPath().endsWith(".extension")) {
            ElementDefinition ued = this.getUrlFor(structure, child);
            if (!(ued != null && ued.hasFixed() || child.hasType() && child.getType().get(0).hasProfile())) {
                return new Slicer(false);
            }
            Slicer s = new Slicer(true);
            String url = ued == null || !ued.hasFixed() ? child.getType().get(0).getProfile() : ((UriType)ued.getFixed()).asStringValue();
            s.name = " with URL = '" + url + "'";
            s.criteria = "[@url = '" + url + "']";
            return s;
        }
        return new Slicer(false);
    }

    private void generateForChildren(SchematronWriter sch, String xpath, ElementDefinition ed, StructureDefinition structure, StructureDefinition base) throws IOException {
        String name;
        List<ElementDefinition> children = ProfileUtilities.getChildList(structure, ed);
        String sliceName = null;
        ElementDefinition.ElementDefinitionSlicingComponent slicing = null;
        for (ElementDefinition child : children) {
            Slicer slicer;
            name = this.tail(child.getPath());
            if (child.hasSlicing()) {
                sliceName = name;
                slicing = child.getSlicing();
            } else if (!name.equals(sliceName)) {
                slicing = null;
            }
            ElementDefinition based = this.getByPath(base, child.getPath());
            boolean doMin = child.getMin() > 0 && (based == null || child.getMin() != based.getMin());
            boolean doMax = child.hasMax() && !child.getMax().equals("*") && (based == null || !child.getMax().equals(based.getMax()));
            Slicer slicer2 = slicer = slicing == null ? new Slicer(true) : this.generateSlicer(child, slicing, structure);
            if (!slicer.check || !doMin && !doMax) continue;
            SchematronWriter.Section s = sch.section(xpath);
            SchematronWriter.Rule r = s.rule(xpath);
            if (doMin) {
                r.assrt("count(f:" + name + slicer.criteria + ") >= " + Integer.toString(child.getMin()), name + slicer.name + ": minimum cardinality of '" + name + "' is " + Integer.toString(child.getMin()));
            }
            if (!doMax) continue;
            r.assrt("count(f:" + name + slicer.criteria + ") <= " + child.getMax(), name + slicer.name + ": maximum cardinality of '" + name + "' is " + child.getMax());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            if (!inv.hasXpath()) continue;
            SchematronWriter.Section s = sch.section(ed.getPath());
            SchematronWriter.Rule r = s.rule(xpath);
            r.assrt(inv.getXpath(), (String)(inv.hasId() ? inv.getId() + ": " : "") + inv.getHuman() + (inv.hasUserData(IS_DERIVED) ? " (inherited)" : ""));
        }
        for (ElementDefinition child : children) {
            name = this.tail(child.getPath());
            this.generateForChildren(sch, xpath + "/f:" + name, child, structure, base);
        }
    }

    private ElementDefinition getByPath(StructureDefinition base, String path) {
        for (ElementDefinition ed : base.getSnapshot().getElement()) {
            if (ed.getPath().equals(path)) {
                return ed;
            }
            if (!ed.getPath().endsWith("[x]") || ed.getPath().length() > path.length() - 3 || !ed.getPath().substring(0, ed.getPath().length() - 3).equals(path.substring(0, ed.getPath().length() - 3))) continue;
            return ed;
        }
        return null;
    }

    public void setIds(StructureDefinition sd, boolean checkFirst) throws DefinitionException {
        if (!checkFirst || !sd.hasDifferential() || this.hasMissingIds(sd.getDifferential().getElement())) {
            if (!sd.hasDifferential()) {
                sd.setDifferential(new StructureDefinition.StructureDefinitionDifferentialComponent());
            }
            this.generateIds(sd.getDifferential().getElement(), sd.getName());
        }
        if (!checkFirst || !sd.hasSnapshot() || this.hasMissingIds(sd.getSnapshot().getElement())) {
            if (!sd.hasSnapshot()) {
                sd.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
            }
            this.generateIds(sd.getSnapshot().getElement(), sd.getName());
        }
    }

    private boolean hasMissingIds(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (ed.hasId()) continue;
            return true;
        }
        return false;
    }

    private void generateIds(List<ElementDefinition> list, String name) throws DefinitionException {
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        ArrayList<String> paths = new ArrayList<String>();
        for (ElementDefinition ed : list) {
            String s2;
            if (!ed.hasPath()) {
                throw new DefinitionException("No path on element Definition " + Integer.toString(list.indexOf(ed)) + " in " + name);
            }
            int depth = this.charCount(ed.getPath(), '.');
            String tail = this.tail(ed.getPath());
            if (depth > paths.size()) {
                String[] pl = ed.getPath().split("\\.");
                for (int i = paths.size(); i < pl.length - 1; ++i) {
                    paths.add(pl[i]);
                }
            }
            while (depth < paths.size() && paths.size() > 0) {
                paths.remove(paths.size() - 1);
            }
            String t = ed.hasSliceName() ? tail + ":" + this.checkName(ed.getSliceName()) : tail;
            name = null;
            StringBuilder b = new StringBuilder();
            for (String s2 : paths) {
                b.append(s2);
                b.append(".");
            }
            b.append(t);
            String bs = b.toString();
            idMap.put(ed.hasId() ? ed.getId() : ed.getPath(), bs);
            ed.setId(bs);
            paths.add(t);
            if (!ed.hasContentReference() || !idMap.containsKey(s2 = ed.getContentReference().substring(1))) continue;
            ed.setContentReference("#" + (String)idMap.get(s2));
        }
    }

    private String urlTail(String profile) {
        return profile.contains("/") ? profile.substring(profile.lastIndexOf("/") + 1) : profile;
    }

    private String checkName(String name) {
        StringBuilder b = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (Utilities.existsInList((int)c, (int[])new int[]{46, 32, 58, 34, 39, 40, 41, 38, 91, 93})) continue;
            b.append(c);
        }
        return b.toString().toLowerCase();
    }

    private int charCount(String path, char t) {
        int res = 0;
        for (char ch : path.toCharArray()) {
            if (ch != t) continue;
            ++res;
        }
        return res;
    }

    public List<Element> generateExamples(StructureDefinition sd, boolean evenWhenNoExamples) throws FHIRException {
        ArrayList<Element> examples = new ArrayList<Element>();
        if (sd.hasSnapshot()) {
            if (evenWhenNoExamples || this.hasAnyExampleValues(sd)) {
                examples.add(this.generateExample(sd, new BaseExampleValueAccessor()));
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.hasAnyExampleValues(sd, Integer.toString(i))) continue;
                examples.add(this.generateExample(sd, new ExtendedExampleValueAccessor(Integer.toString(i))));
            }
        }
        return examples;
    }

    private Element generateExample(StructureDefinition profile, ExampleValueAccessor accessor) throws FHIRException {
        ElementDefinition ed = profile.getSnapshot().getElementFirstRep();
        Element r = new Element(ed.getPath(), new Property(this.context, ed, profile));
        List<ElementDefinition> children = ProfileUtilities.getChildMap(profile, ed);
        for (ElementDefinition child : children) {
            if (child.getPath().endsWith(".id")) {
                Element id = new Element("id", new Property(this.context, child, profile));
                id.setValue(profile.getId() + accessor.getId());
                r.getChildren().add(id);
                continue;
            }
            Element e = this.createExampleElement(profile, child, accessor);
            if (e == null) continue;
            r.getChildren().add(e);
        }
        return r;
    }

    private Element createExampleElement(StructureDefinition profile, ElementDefinition ed, ExampleValueAccessor accessor) throws FHIRException {
        Type v = accessor.getExampleValue(ed);
        if (v != null) {
            return new ObjectConverter(this.context).convert(new Property(this.context, ed, profile), v);
        }
        Element res = new Element(this.tail(ed.getPath()), new Property(this.context, ed, profile));
        boolean hasValue = false;
        List<ElementDefinition> children = ProfileUtilities.getChildMap(profile, ed);
        for (ElementDefinition child : children) {
            Element e;
            if (child.hasContentReference() || (e = this.createExampleElement(profile, child, accessor)) == null) continue;
            hasValue = true;
            res.getChildren().add(e);
        }
        if (hasValue) {
            return res;
        }
        return null;
    }

    private boolean hasAnyExampleValues(StructureDefinition sd, String index) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            for (Extension ex : ed.getExtension()) {
                String ndx = ToolingExtensions.readStringExtension(ex, "index");
                Extension exv = ToolingExtensions.getExtension(ex, "exValue");
                if (exv == null) continue;
                Type value = exv.getValue();
                if (!index.equals(ndx) || value == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnyExampleValues(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.hasExample()) continue;
            return true;
        }
        return false;
    }

    public void populateLogicalSnapshot(StructureDefinition sd) throws FHIRException {
        sd.getSnapshot().getElement().add(sd.getDifferential().getElementFirstRep().copy());
        if (sd.hasBaseDefinition()) {
            StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (base == null) {
                throw new FHIRException("Unable to find base definition for logical model: " + sd.getBaseDefinition() + " from " + sd.getUrl());
            }
            this.copyElements(sd, base.getSnapshot().getElement());
        }
        this.copyElements(sd, sd.getDifferential().getElement());
    }

    private void copyElements(StructureDefinition sd, List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.getPath().contains(".")) continue;
            ElementDefinition n = ed.copy();
            n.setPath(sd.getSnapshot().getElementFirstRep().getPath() + "." + ed.getPath().substring(ed.getPath().indexOf(".") + 1));
            sd.getSnapshot().addElement(n);
        }
    }

    public void cleanUpDifferential(StructureDefinition sd) {
        if (sd.getDifferential().getElement().size() > 1) {
            this.cleanUpDifferential(sd, 1);
        }
    }

    private void cleanUpDifferential(StructureDefinition sd, int start) {
        int level = Utilities.charCount((String)sd.getDifferential().getElement().get(start).getPath(), (char)'.');
        int c = start;
        int len = sd.getDifferential().getElement().size();
        HashSet<String> paths = new HashSet<String>();
        while (c < len && Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') == level) {
            ElementDefinition ed = sd.getDifferential().getElement().get(c);
            if (!paths.contains(ed.getPath())) {
                int ic;
                paths.add(ed.getPath());
                for (ic = c + 1; ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') > level; ++ic) {
                }
                ElementDefinition slicer = null;
                ArrayList<ElementDefinition> slices = new ArrayList<ElementDefinition>();
                slices.add(ed);
                while (ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') == level) {
                    ElementDefinition edi = sd.getDifferential().getElement().get(ic);
                    if (ed.getPath().equals(edi.getPath())) {
                        if (slicer == null) {
                            slicer = new ElementDefinition();
                            slicer.setPath(edi.getPath());
                            slicer.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN);
                            sd.getDifferential().getElement().add(c, slicer);
                            ++c;
                            ++ic;
                        }
                        slices.add(edi);
                    }
                    ++ic;
                    while (ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') > level) {
                        ++ic;
                    }
                }
                if (slicer != null) {
                    this.determineSlicing(slicer, slices);
                }
            }
            if (++c >= len || Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') <= level) continue;
            this.cleanUpDifferential(sd, c);
            ++c;
            while (c < len && Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') > level) {
                ++c;
            }
        }
    }

    private void determineSlicing(ElementDefinition slicer, List<ElementDefinition> slices) {
        int i = 0;
        for (ElementDefinition ed : slices) {
            if (ed.hasUserData("slice-name")) {
                ed.setSliceName(ed.getUserString("slice-name"));
                continue;
            }
            ed.setSliceName("slice-" + Integer.toString(++i));
        }
        if (slicer.getPath().endsWith(".extension") || slicer.getPath().endsWith(".modifierExtension")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("url");
        } else if (slicer.getPath().equals("DiagnosticReport.result")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("reference.code");
        } else if (slicer.getPath().equals("Observation.related")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("target.reference.code");
        } else if (slicer.getPath().equals("Bundle.entry")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("resource.@profile");
        } else {
            throw new Error("No slicing for " + slicer.getPath());
        }
    }

    public XhtmlNode generateSpanningTable(StructureDefinition profile, String imageFolder, boolean onlyConstraints, String constraintPrefix, Set<String> outputTracker) throws IOException, FHIRException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(new RenderingI18nContext(), imageFolder, false);
        HierarchicalTableGenerator.TableModel model = this.initSpanningTable(gen, "", false, profile.getId());
        HashSet<String> processed = new HashSet<String>();
        SpanEntry span = this.buildSpanningTable("(focus)", "", profile, processed, onlyConstraints, constraintPrefix);
        this.genSpanEntry(gen, model.getRows(), span);
        return gen.generate(model, "", 0, outputTracker);
    }

    private SpanEntry buildSpanningTable(String name, String cardinality, StructureDefinition profile, Set<String> processed, boolean onlyConstraints, String constraintPrefix) throws IOException {
        SpanEntry res = this.buildSpanEntryFromProfile(name, cardinality, profile);
        boolean wantProcess = !processed.contains(profile.getUrl());
        processed.add(profile.getUrl());
        if (wantProcess && profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                StructureDefinition sd;
                String uri;
                List<String> refProfiles;
                String card;
                if ("0".equals(ed.getMax()) || ed.getType().size() <= 0 || (card = this.getCardinality(ed, profile.getSnapshot().getElement())).endsWith(".0") || (refProfiles = this.listReferenceProfiles(ed)).size() <= 0 || (uri = refProfiles.get(0)) == null || (sd = this.context.fetchResource(StructureDefinition.class, uri)) == null || onlyConstraints && (sd.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT || constraintPrefix != null && !sd.getUrl().startsWith(constraintPrefix))) continue;
                res.getChildren().add(this.buildSpanningTable(this.nameForElement(ed), card, sd, processed, onlyConstraints, constraintPrefix));
            }
        }
        return res;
    }

    private String getCardinality(ElementDefinition ed, List<ElementDefinition> list) {
        int max;
        int min = ed.getMin();
        int n = max = !ed.hasMax() || ed.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(ed.getMax());
        while (ed != null && ed.getPath().contains(".")) {
            if ((ed = this.findParent(ed, list)).getMax().equals("0")) {
                max = 0;
            } else if (!ed.getMax().equals("1") && !ed.hasSlicing()) {
                max = Integer.MAX_VALUE;
            }
            if (ed.getMin() != 0) continue;
            min = 0;
        }
        return Integer.toString(min) + ".." + (max == Integer.MAX_VALUE ? "*" : Integer.toString(max));
    }

    private ElementDefinition findParent(ElementDefinition ed, List<ElementDefinition> list) {
        int i;
        for (i = list.indexOf(ed) - 1; i >= 0 && !ed.getPath().startsWith(list.get(i).getPath() + "."); --i) {
        }
        if (i == -1) {
            return null;
        }
        return list.get(i);
    }

    private List<String> listReferenceProfiles(ElementDefinition ed) {
        ArrayList<String> res = new ArrayList<String>();
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (tr.getCode() == null || !"Reference".equals(tr.getCode()) || tr.getTargetProfile() == null) continue;
            res.add(tr.getTargetProfile());
        }
        return res;
    }

    private String nameForElement(ElementDefinition ed) {
        return ed.getPath().substring(ed.getPath().indexOf(".") + 1);
    }

    private SpanEntry buildSpanEntryFromProfile(String name, String cardinality, StructureDefinition profile) throws IOException {
        SpanEntry res = new SpanEntry();
        res.setName(name);
        res.setCardinality(cardinality);
        res.setProfileLink(profile.getUserString("path"));
        res.setResType(profile.getType());
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, res.getResType());
        if (base != null) {
            res.setResLink(base.getUserString("path"));
        }
        res.setId(profile.getId());
        res.setProfile(profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT);
        StringBuilder b = new StringBuilder();
        b.append(res.getResType());
        boolean first = true;
        boolean open = false;
        if (profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            res.setDescription(profile.getName());
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                if (!this.isKeyProperty(ed.getBase().getPath()) || !ed.hasFixed()) continue;
                if (first) {
                    open = true;
                    first = false;
                    b.append("[");
                } else {
                    b.append(", ");
                }
                b.append(this.tail(ed.getBase().getPath()));
                b.append("=");
                b.append(this.summarise(ed.getFixed()));
            }
            if (open) {
                b.append("]");
            }
        } else {
            res.setDescription("Base FHIR " + profile.getName());
        }
        res.setType(b.toString());
        return res;
    }

    private String summarise(Type value) throws IOException {
        if (value instanceof Coding) {
            return this.summariseCoding((Coding)value);
        }
        if (value instanceof CodeableConcept) {
            return this.summariseCodeableConcept((CodeableConcept)value);
        }
        return this.buildJson(value);
    }

    private String summariseCoding(Coding value) {
        String uri = value.getSystem();
        String system = NarrativeGenerator.describeSystem(uri);
        if (Utilities.isURL((String)system) && system.equals("http://cap.org/protocols")) {
            system = "CAP Code";
        }
        return system + " " + value.getCode();
    }

    private String summariseCodeableConcept(CodeableConcept value) {
        if (value.hasCoding()) {
            return this.summariseCoding(value.getCodingFirstRep());
        }
        return value.getText();
    }

    private boolean isKeyProperty(String path) {
        return Utilities.existsInList((String)path, (String[])new String[]{"Observation.code"});
    }

    public HierarchicalTableGenerator.TableModel initSpanningTable(HierarchicalTableGenerator gen, String prefix, boolean isLogical, String id) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, false);
        model.setDocoImg(prefix + "help16.png");
        model.setDocoRef(prefix + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), "Property", "A profiled resource", null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), "Card.", "Minimum and Maximum # of times the the element can appear in the instance", null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), "Content", "What goes here", null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), "Description", "Description of the profile", null, 0));
        return model;
    }

    private void genSpanEntry(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, SpanEntry span) throws IOException {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        rows.add(row);
        row.setAnchor(span.getId());
        if (span.isProfile()) {
            row.setIcon("icon_profile.png", "Profile");
        } else {
            row.setIcon("icon_resource.png", "Resource");
        }
        List list = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, span.getName(), null, null));
        List list2 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, span.getCardinality(), null, null));
        List list3 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, span.getProfileLink(), span.getType(), null, null));
        List list4 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, span.getDescription(), null, null));
        for (SpanEntry child : span.getChildren()) {
            this.genSpanEntry(gen, row.getSubRows(), child);
        }
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent interpretR2Discriminator(String discriminator) {
        if (discriminator.endsWith("@pattern")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.PATTERN, discriminator.length() == 8 ? "" : discriminator.substring(0, discriminator.length() - 9));
        }
        if (discriminator.endsWith("@profile")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.PROFILE, discriminator.length() == 8 ? "" : discriminator.substring(discriminator.length() - 9));
        }
        if (discriminator.endsWith("@type")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.TYPE, discriminator.length() == 5 ? "" : discriminator.substring(discriminator.length() - 6));
        }
        return new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent().setType(ElementDefinition.DiscriminatorType.VALUE).setPath(discriminator);
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent makeDiscriminator(ElementDefinition.DiscriminatorType profile, String str) {
        return new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent().setType(ElementDefinition.DiscriminatorType.VALUE).setPath(Utilities.noString((String)str) ? "$this" : str);
    }

    public static String buildR2Discriminator(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t) throws FHIRException {
        switch (t.getType()) {
            case PROFILE: {
                return t.getPath() + "/@profile";
            }
            case PATTERN: {
                return t.getPath() + "/@pattern";
            }
            case TYPE: {
                return t.getPath() + "/@type";
            }
            case VALUE: {
                return t.getPath();
            }
            case EXISTS: {
                return t.getPath();
            }
        }
        throw new FHIRException("Unable to represent " + t.getType().toCode() + ":" + t.getPath() + " in R2");
    }

    public class SpanEntry {
        private List<SpanEntry> children = new ArrayList<SpanEntry>();
        private boolean profile;
        private String id;
        private String name;
        private String resType;
        private String cardinality;
        private String description;
        private String profileLink;
        private String resLink;
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getResType() {
            return this.resType;
        }

        public void setResType(String resType) {
            this.resType = resType;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getProfileLink() {
            return this.profileLink;
        }

        public void setProfileLink(String profileLink) {
            this.profileLink = profileLink;
        }

        public String getResLink() {
            return this.resLink;
        }

        public void setResLink(String resLink) {
            this.resLink = resLink;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isProfile() {
            return this.profile;
        }

        public void setProfile(boolean profile) {
            this.profile = profile;
        }

        public List<SpanEntry> getChildren() {
            return this.children;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    private class ExtendedExampleValueAccessor
    implements ExampleValueAccessor {
        private String index;

        public ExtendedExampleValueAccessor(String index) {
            this.index = index;
        }

        @Override
        public Type getExampleValue(ElementDefinition ed) {
            if (ed.hasFixed()) {
                return ed.getFixed();
            }
            for (Extension ex : ed.getExtension()) {
                String ndx = ToolingExtensions.readStringExtension(ex, "index");
                Type value = ToolingExtensions.getExtension(ex, "exValue").getValue();
                if (!this.index.equals(ndx) || value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String getId() {
            return "-genexample-" + this.index;
        }
    }

    private class BaseExampleValueAccessor
    implements ExampleValueAccessor {
        private BaseExampleValueAccessor() {
        }

        @Override
        public Type getExampleValue(ElementDefinition ed) {
            if (ed.hasFixed()) {
                return ed.getFixed();
            }
            if (ed.hasExample()) {
                return ed.getExample().get(0).getValue();
            }
            return null;
        }

        @Override
        public String getId() {
            return "-genexample";
        }
    }

    private static interface ExampleValueAccessor {
        public Type getExampleValue(ElementDefinition var1);

        public String getId();
    }

    private class Slicer
    extends ElementDefinition.ElementDefinitionSlicingComponent {
        String criteria = "";
        String name = "";
        boolean check;

        public Slicer(boolean cantCheck) {
            this.check = cantCheck;
        }
    }

    private static class ElementNameCompare
    implements Comparator<ElementDefinition> {
        private ElementNameCompare() {
        }

        @Override
        public int compare(ElementDefinition o1, ElementDefinition o2) {
            String path2;
            String path1 = ElementNameCompare.normalizePath(o1);
            int cmp = path1.compareTo(path2 = ElementNameCompare.normalizePath(o2));
            if (cmp == 0) {
                String name1 = o1.hasSliceName() ? o1.getSliceName() : "";
                String name2 = o2.hasSliceName() ? o2.getSliceName() : "";
                cmp = name1.compareTo(name2);
            }
            return cmp;
        }

        private static String normalizePath(ElementDefinition e) {
            if (!e.hasPath()) {
                return "";
            }
            String path = e.getPath();
            if (path.endsWith("[x]")) {
                path = path.substring(0, path.length() - 3);
            }
            return path;
        }
    }

    public static class ElementDefinitionComparer
    implements Comparator<ElementDefinitionHolder> {
        private boolean inExtension;
        private List<ElementDefinition> snapshot;
        private int prefixLength;
        private String base;
        private String name;
        private Set<String> errors = new HashSet<String>();

        public ElementDefinitionComparer(boolean inExtension, List<ElementDefinition> snapshot, String base, int prefixLength, String name) {
            this.inExtension = inExtension;
            this.snapshot = snapshot;
            this.prefixLength = prefixLength;
            this.base = base;
            this.name = name;
        }

        @Override
        public int compare(ElementDefinitionHolder o1, ElementDefinitionHolder o2) {
            if (o1.getBaseIndex() == 0) {
                o1.setBaseIndex(this.find(o1.getSelf().getPath()));
            }
            if (o2.getBaseIndex() == 0) {
                o2.setBaseIndex(this.find(o2.getSelf().getPath()));
            }
            return o1.getBaseIndex() - o2.getBaseIndex();
        }

        private int find(String path) {
            String actual = this.base + path.substring(this.prefixLength);
            for (int i = 0; i < this.snapshot.size(); ++i) {
                String p = this.snapshot.get(i).getPath();
                if (p.equals(actual)) {
                    return i;
                }
                if (p.endsWith("[x]") && actual.startsWith(p.substring(0, p.length() - 3)) && !actual.endsWith("[x]") && !actual.substring(p.length() - 3).contains(".")) {
                    return i;
                }
                if (!path.startsWith(p + ".") || !this.snapshot.get(i).hasContentReference()) continue;
                actual = this.base + (this.snapshot.get(i).getContentReference().substring(1) + "." + path.substring(p.length() + 1)).substring(this.prefixLength);
                i = 0;
            }
            if (this.prefixLength == 0) {
                this.errors.add("Differential contains path " + path + " which is not found in the base");
            } else {
                this.errors.add("Differential contains path " + path + " which is actually " + actual + ", which is not found in the base");
            }
            return 0;
        }

        public void checkForErrors(List<String> errorList) {
            if (this.errors.size() > 0) {
                for (String s : this.errors) {
                    if (s.startsWith("!")) {
                        errorList.add("!StructureDefinition " + this.name + ": " + s.substring(1));
                        continue;
                    }
                    errorList.add("StructureDefinition " + this.name + ": " + s);
                }
            }
        }
    }

    public static class ElementDefinitionHolder {
        private String name;
        private ElementDefinition self;
        private int baseIndex = 0;
        private List<ElementDefinitionHolder> children;

        public ElementDefinitionHolder(ElementDefinition self) {
            this.self = self;
            this.name = self.getPath();
            this.children = new ArrayList<ElementDefinitionHolder>();
        }

        public ElementDefinition getSelf() {
            return this.self;
        }

        public List<ElementDefinitionHolder> getChildren() {
            return this.children;
        }

        public int getBaseIndex() {
            return this.baseIndex;
        }

        public void setBaseIndex(int baseIndex) {
            this.baseIndex = baseIndex;
        }

        public String toString() {
            if (this.self.hasSliceName()) {
                return this.self.getPath() + "(" + this.self.getSliceName() + ")";
            }
            return this.self.getPath();
        }
    }

    public static interface ProfileKnowledgeProvider {
        public boolean isDatatype(String var1);

        public boolean isResource(String var1);

        public boolean hasLinkFor(String var1);

        public String getLinkFor(String var1, String var2);

        public BindingResolution resolveBinding(StructureDefinition var1, ElementDefinition.ElementDefinitionBindingComponent var2, String var3);

        public String getLinkForProfile(StructureDefinition var1, String var2);

        public boolean prependLinks();

        public static class BindingResolution {
            public String display;
            public String url;
        }
    }

    private class UnusedTracker {
        private boolean used;

        private UnusedTracker() {
        }
    }

    public class ExtensionContext {
        private ElementDefinition element;
        private StructureDefinition defn;

        public ExtensionContext(StructureDefinition ext, ElementDefinition ed) {
            this.defn = ext;
            this.element = ed;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public StructureDefinition getDefn() {
            return this.defn;
        }

        public String getUrl() {
            if (this.element == this.defn.getSnapshot().getElement().get(0)) {
                return this.defn.getUrl();
            }
            return this.element.getSliceName();
        }

        public ElementDefinition getExtensionValueDefinition() {
            for (int i = this.defn.getSnapshot().getElement().indexOf(this.element) + 1; i < this.defn.getSnapshot().getElement().size(); ++i) {
                ElementDefinition ed = this.defn.getSnapshot().getElement().get(i);
                if (ed.getPath().equals(this.element.getPath())) {
                    return null;
                }
                if (!ed.getPath().startsWith(this.element.getPath() + ".value")) continue;
                return ed;
            }
            return null;
        }
    }
}

